/*
File timeconstraint.cpp
*/

/***************************************************************************
                          timeconstraint.cpp  -  description
                             -------------------
    begin                : 2002
    copyright            : (C) 2002 by Liviu Lalescu
    email                : Please see https://lalescu.ro/liviu/ for details about contacting Liviu Lalescu (in particular, you can find there the email address)
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software: you can redistribute it and/or modify  *
 *   it under the terms of the GNU Affero General Public License as        *
 *   published by the Free Software Foundation, version 3 of the License.  *
 *                                                                         *
 ***************************************************************************/

#include "timetable_defs.h"
#include "timeconstraint.h"
#include "rules.h"
#include "solution.h"
#include "activity.h"
#include "teacher.h"
#include "subject.h"
#include "activitytag.h"
#include "studentsset.h"

#include "timetableexport.h"

#include "matrix.h"

#include <QString>

#include "messageboxes.h"

#include <QSet>

#include <QDataStream>

//for the min and max functions
//2025-04-03: also for std::stable_sort
#include <algorithm>

//1
QDataStream& operator<<(QDataStream& stream, const ConstraintBasicCompulsoryTime& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	return stream;
}

//2
QDataStream& operator<<(QDataStream& stream, const ConstraintBreakTimes& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.days<<tc.hours;

	return stream;
}

//3
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherNotAvailableTimes& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.days<<tc.hours<<tc.teacher;

	return stream;
}

//4
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxHoursDaily& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursDaily;

	return stream;
}

//5
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxDaysPerWeek<<tc.teacherName;

	return stream;
}

//6
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxGapsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxGaps;

	return stream;
}

//7
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxGapsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxGaps<<tc.teacherName;

	return stream;
}

//8
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxHoursDaily& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursDaily<<tc.teacherName;

	return stream;
}

//9
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxHoursContinuously& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursContinuously;

	return stream;
}

//10
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxHoursContinuously& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursContinuously<<tc.teacherName;

	return stream;
}

//11
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMinHoursDaily& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowEmptyDays<<tc.minHoursDaily;

	return stream;
}

//12
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMinHoursDaily& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowEmptyDays<<tc.minHoursDaily<<tc.teacherName;

	return stream;
}

//13
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxGapsPerDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxGaps;

	return stream;
}

//14
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxGapsPerDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxGaps<<tc.teacherName;

	return stream;
}

//15
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxBeginningsAtSecondHour;

	return stream;
}

//16
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxBeginningsAtSecondHour<<tc.students;

	return stream;
}

//17
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetNotAvailableTimes& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.days<<tc.hours<<tc.students;

	return stream;
}

//18
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMaxGapsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxGaps;

	return stream;
}

//19
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMaxGapsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxGaps<<tc.students;

	return stream;
}

//20
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMaxHoursDaily& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursDaily;

	return stream;
}

//21
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMaxHoursDaily& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursDaily<<tc.students;

	return stream;
}

//22
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMaxHoursContinuously& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursContinuously;

	return stream;
}

//23
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMaxHoursContinuously& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursContinuously<<tc.students;

	return stream;
}

//24
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMinHoursDaily& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowEmptyDays<<tc.minHoursDaily;

	return stream;
}

//25
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMinHoursDaily& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowEmptyDays<<tc.minHoursDaily<<tc.students;

	return stream;
}

//26
QDataStream& operator<<(QDataStream& stream, const ConstraintActivityEndsStudentsDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityId;

	return stream;
}

//27
QDataStream& operator<<(QDataStream& stream, const ConstraintActivityPreferredStartingTime& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityId<<tc.day<<tc.hour<<tc.permanentlyLocked;

	return stream;
}

//28
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesSameStartingTime& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.n_activities;

	return stream;
}

//29
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesNotOverlapping& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.n_activities;

	return stream;
}

//30
QDataStream& operator<<(QDataStream& stream, const ConstraintMinDaysBetweenActivities& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.n_activities<<tc.consecutiveIfSameDay<<tc.minDays;

	return stream;
}

//31
QDataStream& operator<<(QDataStream& stream, const ConstraintActivityPreferredTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.p_activityId<<tc.p_days_L<<tc.p_hours_L<<tc.p_nPreferredTimeSlots_L;

	return stream;
}

//32
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesPreferredTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.duration<<tc.p_days_L<<tc.p_hours_L<<tc.p_nPreferredTimeSlots_L
		 <<tc.p_activityTagName<<tc.p_studentsName<<tc.p_subjectName<<tc.p_teacherName;

	return stream;
}

//33
QDataStream& operator<<(QDataStream& stream, const ConstraintActivityPreferredStartingTimes& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityId<<tc.days_L<<tc.hours_L<<tc.nPreferredStartingTimes_L;

	return stream;
}

//34
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesPreferredStartingTimes& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.duration<<tc.days_L<<tc.hours_L<<tc.nPreferredStartingTimes_L
		 <<tc.activityTagName<<tc.studentsName<<tc.subjectName<<tc.teacherName;

	return stream;
}

//35
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesSameStartingHour& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.n_activities;

	return stream;
}

//36
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesSameStartingDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.n_activities;

	return stream;
}

//37
QDataStream& operator<<(QDataStream& stream, const ConstraintTwoActivitiesConsecutive& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.firstActivityId<<tc.secondActivityId;

	return stream;
}

//38
QDataStream& operator<<(QDataStream& stream, const ConstraintTwoActivitiesOrdered& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.firstActivityId<<tc.secondActivityId;

	return stream;
}

//39
QDataStream& operator<<(QDataStream& stream, const ConstraintMinGapsBetweenActivities& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.n_activities<<tc.minGaps;

	return stream;
}

//40
QDataStream& operator<<(QDataStream& stream, const ConstraintSubactivitiesPreferredTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.duration<<tc.p_days_L<<tc.p_hours_L<<tc.p_nPreferredTimeSlots_L
		 <<tc.p_activityTagName<<tc.p_studentsName<<tc.p_subjectName<<tc.p_teacherName<<tc.componentNumber;

	return stream;
}

//41
QDataStream& operator<<(QDataStream& stream, const ConstraintSubactivitiesPreferredStartingTimes& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.duration<<tc.days_L<<tc.hours_L<<tc.nPreferredStartingTimes_L
		 <<tc.activityTagName<<tc.studentsName<<tc.subjectName<<tc.teacherName<<tc.componentNumber;

	return stream;
}

//42
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherIntervalMaxDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.startHour<<tc.endHour<<tc.maxDaysPerWeek<<tc.teacherName;

	return stream;
}

//43
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersIntervalMaxDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.startHour<<tc.endHour<<tc.maxDaysPerWeek;

	return stream;
}

//44
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetIntervalMaxDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.startHour<<tc.endHour<<tc.maxDaysPerWeek<<tc.students;

	return stream;
}

//45
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsIntervalMaxDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.startHour<<tc.endHour<<tc.maxDaysPerWeek;

	return stream;
}

//46
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesEndStudentsDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.studentsName<<tc.subjectName<<tc.teacherName;

	return stream;
}

//47
QDataStream& operator<<(QDataStream& stream, const ConstraintTwoActivitiesGrouped& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.firstActivityId<<tc.secondActivityId;

	return stream;
}

//48
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersActivityTagMaxHoursContinuously& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.maxHoursContinuously;

	return stream;
}

//49
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherActivityTagMaxHoursContinuously& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.maxHoursContinuously<<tc.teacherName;

	return stream;
}

//50
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsActivityTagMaxHoursContinuously& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.maxHoursContinuously;

	return stream;
}

//51
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetActivityTagMaxHoursContinuously& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.maxHoursContinuously<<tc.students;

	return stream;
}

//52
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxDaysPerWeek;

	return stream;
}

//53
QDataStream& operator<<(QDataStream& stream, const ConstraintThreeActivitiesGrouped& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.firstActivityId<<tc.secondActivityId<<tc.thirdActivityId;

	return stream;
}

//54
QDataStream& operator<<(QDataStream& stream, const ConstraintMaxDaysBetweenActivities& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.n_activities<<tc.maxDays;

	return stream;
}

//55
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMinDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.minDaysPerWeek;

	return stream;
}

//56
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMinDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.minDaysPerWeek<<tc.teacherName;

	return stream;
}

//57
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersActivityTagMaxHoursDaily& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.maxHoursDaily;

	return stream;
}

//58
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherActivityTagMaxHoursDaily& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.maxHoursDaily<<tc.teacherName;

	return stream;
}

//59
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsActivityTagMaxHoursDaily& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.maxHoursDaily;

	return stream;
}

//60
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetActivityTagMaxHoursDaily& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.maxHoursDaily<<tc.students;

	return stream;
}

//61
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMaxGapsPerDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxGaps;

	return stream;
}

//62
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMaxGapsPerDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxGaps<<tc.students;

	return stream;
}

//63
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesOccupyMaxTimeSlotsFromSelection& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.maxOccupiedTimeSlots<<tc.selectedDays<<tc.selectedHours;

	return stream;
}

//64
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.maxSimultaneous<<tc.selectedDays<<tc.selectedHours;

	return stream;
}

//65
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMaxDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxDaysPerWeek<<tc.students;

	return stream;
}

//66
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMaxDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxDaysPerWeek;

	return stream;
}

//67
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxSpanPerDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowOneDayExceptionPlusOne<<tc.maxSpanPerDay<<tc.teacherName;

	return stream;
}

//68
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxSpanPerDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowOneDayExceptionPlusOne<<tc.maxSpanPerDay;

	return stream;
}

//69
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMinRestingHours& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.circular<<tc.minRestingHours<<tc.teacherName;

	return stream;
}

//70
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMinRestingHours& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.circular<<tc.minRestingHours;

	return stream;
}

//71
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMaxSpanPerDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxSpanPerDay<<tc.students;

	return stream;
}

//72
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMaxSpanPerDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxSpanPerDay;

	return stream;
}

//73
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMinRestingHours& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.circular<<tc.minRestingHours<<tc.students;

	return stream;
}

//74
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMinRestingHours& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.circular<<tc.minRestingHours;

	return stream;
}

//75
QDataStream& operator<<(QDataStream& stream, const ConstraintTwoActivitiesOrderedIfSameDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.firstActivityId<<tc.secondActivityId;

	return stream;
}

//76
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTags& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.firstActivityTag<<tc.secondActivityTag<<tc.minGaps<<tc.students;

	return stream;
}

//77
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTags& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.firstActivityTag<<tc.secondActivityTag<<tc.minGaps;

	return stream;
}

//78
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTags& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.firstActivityTag<<tc.secondActivityTag<<tc.minGaps<<tc.teacher;

	return stream;
}

//79
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTags& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.firstActivityTag<<tc.secondActivityTag<<tc.minGaps;

	return stream;
}

//80
QDataStream& operator<<(QDataStream& stream, const ConstraintActivityTagsNotOverlapping& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagsNames;

	return stream;
}

//81
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesOccupyMinTimeSlotsFromSelection& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.minOccupiedTimeSlots<<tc.selectedDays<<tc.selectedHours;

	return stream;
}

//82
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesMinSimultaneousInSelectedTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.allowEmptySlots<<tc.minSimultaneous<<tc.selectedDays<<tc.selectedHours;

	return stream;
}

//83
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersActivityTagMinHoursDaily& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.minHoursDaily<<tc.minDaysWithTag;

	return stream;
}

//84
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherActivityTagMinHoursDaily& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.minHoursDaily<<tc.minDaysWithTag<<tc.teacherName;

	return stream;
}

//85
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsActivityTagMinHoursDaily& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.minHoursDaily<<tc.minDaysWithTag;

	return stream;
}

//86
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetActivityTagMinHoursDaily& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.minHoursDaily<<tc.minDaysWithTag<<tc.students;

	return stream;
}

//87
QDataStream& operator<<(QDataStream& stream, const ConstraintActivityEndsTeachersDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityId;

	return stream;
}

//88
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesEndTeachersDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.studentsName<<tc.subjectName<<tc.teacherName;

	return stream;
}

//89
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxHoursDailyRealDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursDaily;

	return stream;
}

//90
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxRealDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxDaysPerWeek<<tc.teacherName;

	return stream;
}

//91
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxHoursDailyRealDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursDaily<<tc.teacherName;

	return stream;
}

//92
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMaxHoursDailyRealDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursDaily;

	return stream;
}

//93
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMaxHoursDailyRealDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursDaily<<tc.students;

	return stream;
}

//94
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxRealDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxDaysPerWeek;

	return stream;
}

//95
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMinRealDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.minDaysPerWeek;

	return stream;
}

//96
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMinRealDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.minDaysPerWeek<<tc.teacherName;

	return stream;
}

//97
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersActivityTagMaxHoursDailyRealDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.maxHoursDaily;

	return stream;
}

//98
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherActivityTagMaxHoursDailyRealDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.maxHoursDaily<<tc.teacherName;

	return stream;
}

//99
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsActivityTagMaxHoursDailyRealDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.maxHoursDaily;

	return stream;
}

//100
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetActivityTagMaxHoursDailyRealDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.maxHoursDaily<<tc.students;

	return stream;
}

//101
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxAfternoonsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxAfternoonsPerWeek<<tc.teacherName;

	return stream;
}

//102
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxAfternoonsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxAfternoonsPerWeek;

	return stream;
}

//103
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxMorningsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxMorningsPerWeek<<tc.teacherName;

	return stream;
}

//104
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxMorningsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxMorningsPerWeek;

	return stream;
}

//105
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxActivityTagsPerDayFromSet& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.teacherName<<tc.maxTags<<tc.tagsList;

	return stream;
}

//106
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxActivityTagsPerDayFromSet& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;
	
	stream<<tc.maxTags<<tc.tagsList;

	return stream;
}

//107
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMinMorningsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.minMorningsPerWeek;

	return stream;
}

//108
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMinMorningsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.minMorningsPerWeek<<tc.teacherName;

	return stream;
}

//109
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMinAfternoonsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.minAfternoonsPerWeek;

	return stream;
}

//110
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMinAfternoonsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.minAfternoonsPerWeek<<tc.teacherName;

	return stream;
}

//111
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxTwoConsecutiveMornings& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.teacherName;

	return stream;
}

//112
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxTwoConsecutiveMornings& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	return stream;
}

//113
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxTwoConsecutiveAfternoons& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.teacherName;

	return stream;
}

//114
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxTwoConsecutiveAfternoons& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	return stream;
}

//115
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxGapsPerRealDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowOneDayExceptionPlusOne<<tc.maxGaps;

	return stream;
}

//116
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxGapsPerRealDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowOneDayExceptionPlusOne<<tc.maxGaps<<tc.teacherName;

	return stream;
}

//117
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMaxGapsPerRealDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxGaps;

	return stream;
}

//118
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMaxGapsPerRealDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxGaps<<tc.students;

	return stream;
}

//119
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMinHoursDailyRealDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowEmptyDays<<tc.minHoursDaily;

	return stream;
}

//120
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMinHoursDailyRealDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowEmptyDays<<tc.minHoursDaily<<tc.teacherName;

	return stream;
}

//121
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersAfternoonsEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxBeginningsAtSecondHour;

	return stream;
}

//122
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherAfternoonsEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxBeginningsAtSecondHour<<tc.teacherName;

	return stream;
}

//123
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMinHoursPerMorning& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowEmptyMornings<<tc.minHoursPerMorning;

	return stream;
}

//124
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMinHoursPerMorning& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowEmptyMornings<<tc.minHoursPerMorning<<tc.teacherName;

	return stream;
}

//125
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxSpanPerRealDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowOneDayExceptionPlusOne<<tc.maxSpanPerDay<<tc.teacherName;

	return stream;
}

//126
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxSpanPerRealDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowOneDayExceptionPlusOne<<tc.maxSpanPerDay;

	return stream;
}

//127
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMaxSpanPerRealDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxSpanPerDay<<tc.students;

	return stream;
}

//128
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMaxSpanPerRealDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxSpanPerDay;

	return stream;
}

//129
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMorningIntervalMaxDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxDaysPerWeek<<tc.startHour<<tc.endHour<<tc.teacherName;

	return stream;
}

//130
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMorningIntervalMaxDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxDaysPerWeek<<tc.startHour<<tc.endHour;

	return stream;
}

//131
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherAfternoonIntervalMaxDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxDaysPerWeek<<tc.startHour<<tc.endHour<<tc.teacherName;

	return stream;
}

//132
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersAfternoonIntervalMaxDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxDaysPerWeek<<tc.startHour<<tc.endHour;

	return stream;
}

//133
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMinHoursPerMorning& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowEmptyMornings<<tc.minHoursPerMorning;

	return stream;
}

//134
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMinHoursPerMorning& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowEmptyMornings<<tc.minHoursPerMorning<<tc.students;

	return stream;
}

//135
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxZeroGapsPerAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.teacherName;

	return stream;
}

//136
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxZeroGapsPerAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	return stream;
}

//137
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMaxAfternoonsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxAfternoonsPerWeek<<tc.students;

	return stream;
}

//138
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMaxAfternoonsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxAfternoonsPerWeek;

	return stream;
}

//139
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMaxMorningsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxMorningsPerWeek<<tc.students;

	return stream;
}

//140
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMaxMorningsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxMorningsPerWeek;

	return stream;
}

//141
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMinMorningsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.minMorningsPerWeek;

	return stream;
}

//142
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMinMorningsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.minMorningsPerWeek<<tc.students;

	return stream;
}

//143
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMinAfternoonsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.minAfternoonsPerWeek;

	return stream;
}

//144
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMinAfternoonsPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.minAfternoonsPerWeek<<tc.students;

	return stream;
}

//145
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMorningIntervalMaxDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxDaysPerWeek<<tc.startHour<<tc.endHour<<tc.students;

	return stream;
}

//146
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMorningIntervalMaxDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxDaysPerWeek<<tc.startHour<<tc.endHour;

	return stream;
}

//147
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetAfternoonIntervalMaxDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxDaysPerWeek<<tc.startHour<<tc.endHour<<tc.students;

	return stream;
}

//148
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsAfternoonIntervalMaxDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxDaysPerWeek<<tc.startHour<<tc.endHour;

	return stream;
}

//149
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxHoursPerAllAfternoons& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursPerAllAfternoons<<tc.teacherName;

	return stream;
}

//150
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxHoursPerAllAfternoons& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursPerAllAfternoons;

	return stream;
}

//151
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMaxHoursPerAllAfternoons& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursPerAllAfternoons<<tc.students;

	return stream;
}

//152
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMaxHoursPerAllAfternoons& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursPerAllAfternoons;

	return stream;
}

//153
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMinRestingHoursBetweenMorningAndAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.minRestingHours<<tc.teacherName;

	return stream;
}

//154
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMinRestingHoursBetweenMorningAndAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.minRestingHours;

	return stream;
}

//155
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMinRestingHoursBetweenMorningAndAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.minRestingHours<<tc.students;

	return stream;
}

//156
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMinRestingHoursBetweenMorningAndAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.minRestingHours;

	return stream;
}

//157
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetAfternoonsEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxBeginningsAtSecondHour<<tc.students;

	return stream;
}

//158
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsAfternoonsEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxBeginningsAtSecondHour;

	return stream;
}

//159
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxGapsPerWeekForRealDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxGaps;

	return stream;
}

//160
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxGapsPerWeekForRealDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxGaps<<tc.teacherName;

	return stream;
}

//161
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMaxGapsPerWeekForRealDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxGaps;

	return stream;
}

//162
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMaxGapsPerWeekForRealDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxGaps<<tc.students;

	return stream;
}

//163
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMaxRealDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxDaysPerWeek<<tc.students;

	return stream;
}

//164
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMaxRealDaysPerWeek& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxDaysPerWeek;

	return stream;
}

//165
QDataStream& operator<<(QDataStream& stream, const ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.maxActivities<<tc.selectedDays<<tc.selectedHours;

	return stream;
}

//166
QDataStream& operator<<(QDataStream& stream, const ConstraintMaxGapsBetweenActivities& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.n_activities<<tc.maxGaps;

	return stream;
}

//167
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesMaxInATerm& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.maxActivitiesInATerm;

	return stream;
}

//168
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesOccupyMaxTerms& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.maxOccupiedTerms;

	return stream;
}

//169
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxGapsPerMorningAndAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxGaps;

	return stream;
}

//170
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxGapsPerMorningAndAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxGaps<<tc.teacherName;

	return stream;
}

//171
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMorningsEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxBeginningsAtSecondHour;

	return stream;
}

//172
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMorningsEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxBeginningsAtSecondHour<<tc.teacherName;

	return stream;
}

//173
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMorningsEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxBeginningsAtSecondHour<<tc.students;

	return stream;
}

//174
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMorningsEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxBeginningsAtSecondHour;

	return stream;
}

//175
QDataStream& operator<<(QDataStream& stream, const ConstraintTwoSetsOfActivitiesOrdered& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.firstActivitiesIdsList<<tc.secondActivitiesIdsList;

	return stream;
}

//176
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxThreeConsecutiveDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowAMAMException;

	return stream;
}

//177
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxThreeConsecutiveDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowAMAMException<<tc.teacherName;

	return stream;
}

//178
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMinGapsBetweenActivityTag& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTag<<tc.minGaps<<tc.students;

	return stream;
}

//179
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMinGapsBetweenActivityTag& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTag<<tc.minGaps;

	return stream;
}

//180
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMinGapsBetweenActivityTag& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTag<<tc.minGaps<<tc.teacher;

	return stream;
}

//181
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMinGapsBetweenActivityTag& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTag<<tc.minGaps;

	return stream;
}

//182
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMaxThreeConsecutiveDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowAMAMException;

	return stream;
}

//183
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMaxThreeConsecutiveDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowAMAMException<<tc.students;

	return stream;
}

//184
QDataStream& operator<<(QDataStream& stream, const ConstraintMinHalfDaysBetweenActivities& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.n_activities<<tc.consecutiveIfSameDay<<tc.minDays;

	return stream;
}

//185
QDataStream& operator<<(QDataStream& stream, const ConstraintActivityPreferredDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityId<<tc.day;

	return stream;
}

//186
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesMinInATerm& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.minActivitiesInATerm<<tc.allowEmptyTerms;

	return stream;
}

//187
QDataStream& operator<<(QDataStream& stream, const ConstraintMaxTermsBetweenActivities& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.n_activities<<tc.maxTerms;

	return stream;
}

//188
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMaxActivityTagsPerDayFromSet& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.students<<tc.maxTags<<tc.tagsList;

	return stream;
}

//189
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMaxActivityTagsPerDayFromSet& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;
	
	stream<<tc.maxTags<<tc.tagsList;

	return stream;
}

//190
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxActivityTagsPerRealDayFromSet& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.teacherName<<tc.maxTags<<tc.tagsList;

	return stream;
}

//191
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxActivityTagsPerRealDayFromSet& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxTags<<tc.tagsList;

	return stream;
}

//192
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMaxActivityTagsPerRealDayFromSet& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.students<<tc.maxTags<<tc.tagsList;

	return stream;
}

//193
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMaxActivityTagsPerRealDayFromSet& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;
	
	stream<<tc.maxTags<<tc.tagsList;

	return stream;
}

//194
QDataStream& operator<<(QDataStream& stream, const ConstraintMaxHalfDaysBetweenActivities& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.n_activities<<tc.maxDays;

	return stream;
}

//195
QDataStream& operator<<(QDataStream& stream, const ConstraintActivityBeginsStudentsDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityId;

	return stream;
}

//196
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesBeginStudentsDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.studentsName<<tc.subjectName<<tc.teacherName;

	return stream;
}

//197
QDataStream& operator<<(QDataStream& stream, const ConstraintActivityBeginsTeachersDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityId;

	return stream;
}

//198
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesBeginTeachersDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.studentsName<<tc.subjectName<<tc.teacherName;

	return stream;
}

//199
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMinHoursPerAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowEmptyAfternoons<<tc.minHoursPerAfternoon;

	return stream;
}

//200
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMinHoursPerAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowEmptyAfternoons<<tc.minHoursPerAfternoon<<tc.teacherName;

	return stream;
}

//201
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMinHoursPerAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowEmptyAfternoons<<tc.minHoursPerAfternoon;

	return stream;
}

//202
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMinHoursPerAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.allowEmptyAfternoons<<tc.minHoursPerAfternoon<<tc.students;

	return stream;
}

//203
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesMaxHourlySpan& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.n_activities<<tc.maxHourlySpan;

	return stream;
}

//204
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxHoursDailyInInterval& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursDaily<<tc.teacherName<<tc.startHour<<tc.endHour;

	return stream;
}

//205
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxHoursDailyInInterval& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursDaily<<tc.startHour<<tc.endHour;

	return stream;
}

//206
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMaxHoursDailyInInterval& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursDaily<<tc.students<<tc.startHour<<tc.endHour;

	return stream;
}

//207
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMaxHoursDailyInInterval& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursDaily<<tc.startHour<<tc.endHour;

	return stream;
}

//208
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.firstActivityTag<<tc.secondActivityTag<<tc.minGaps<<tc.students;

	return stream;
}

//209
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsPerRealDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.firstActivityTag<<tc.secondActivityTag<<tc.minGaps;

	return stream;
}

//210
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsPerRealDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.firstActivityTag<<tc.secondActivityTag<<tc.minGaps<<tc.teacher;

	return stream;
}

//211
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsPerRealDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.firstActivityTag<<tc.secondActivityTag<<tc.minGaps;

	return stream;
}

//212
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMinGapsBetweenActivityTagPerRealDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTag<<tc.minGaps<<tc.students;

	return stream;
}

//213
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMinGapsBetweenActivityTagPerRealDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTag<<tc.minGaps;

	return stream;
}

//214
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMinGapsBetweenActivityTagPerRealDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTag<<tc.minGaps<<tc.teacher;

	return stream;
}

//215
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMinGapsBetweenActivityTagPerRealDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTag<<tc.minGaps;

	return stream;
}

//216
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.firstActivityTag<<tc.secondActivityTag<<tc.minGaps<<tc.students;

	return stream;
}

//217
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.firstActivityTag<<tc.secondActivityTag<<tc.minGaps;

	return stream;
}

//218
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.firstActivityTag<<tc.secondActivityTag<<tc.minGaps<<tc.teacher;

	return stream;
}

//219
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.firstActivityTag<<tc.secondActivityTag<<tc.minGaps;

	return stream;
}

//220
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTag<<tc.minGaps<<tc.students;

	return stream;
}

//221
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMinGapsBetweenActivityTagBetweenMorningAndAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTag<<tc.minGaps;

	return stream;
}

//222
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMinGapsBetweenActivityTagBetweenMorningAndAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTag<<tc.minGaps<<tc.teacher;

	return stream;
}

//223
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMinGapsBetweenActivityTagBetweenMorningAndAfternoon& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTag<<tc.minGaps;

	return stream;
}

//224
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersNoTwoConsecutiveDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	return stream;
}

//225
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherNoTwoConsecutiveDays& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.teacherName;

	return stream;
}

//226
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherPairOfMutuallyExclusiveTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.teacherName<<tc.day1<<tc.hour1<<tc.day2<<tc.hour2;

	return stream;
}

//227
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersPairOfMutuallyExclusiveTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.day1<<tc.hour1<<tc.day2<<tc.hour2;

	return stream;
}

//228
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetPairOfMutuallyExclusiveTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.students<<tc.day1<<tc.hour1<<tc.day2<<tc.hour2;

	return stream;
}

//229
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsPairOfMutuallyExclusiveTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.day1<<tc.hour1<<tc.day2<<tc.hour2;

	return stream;
}

//230
QDataStream& operator<<(QDataStream& stream, const ConstraintTwoSetsOfActivitiesSameSections& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesAIds<<tc.activitiesBIds<<tc.oDays<<tc.oHours;

	return stream;
}

//231
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsMaxSingleGapsInSelectedTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxSingleGaps<<tc.selectedDays<<tc.selectedHours;

	return stream;
}

//232
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetMaxSingleGapsInSelectedTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.students<<tc.maxSingleGaps<<tc.selectedDays<<tc.selectedHours;

	return stream;
}

//233
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxSingleGapsInSelectedTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxSingleGaps<<tc.selectedDays<<tc.selectedHours;

	return stream;
}

//234
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxSingleGapsInSelectedTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.teacher<<tc.maxSingleGaps<<tc.selectedDays<<tc.selectedHours;

	return stream;
}

//235
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherMaxHoursPerTerm& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursPerTerm<<tc.teacherName;

	return stream;
}

//236
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersMaxHoursPerTerm& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxHoursPerTerm;

	return stream;
}

//237
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherPairOfMutuallyExclusiveSetsOfTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.teacherName<<tc.selectedDays1<<tc.selectedHours1<<tc.selectedDays2<<tc.selectedHours2;

	return stream;
}

//238
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersPairOfMutuallyExclusiveSetsOfTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.selectedDays1<<tc.selectedHours1<<tc.selectedDays2<<tc.selectedHours2;

	return stream;
}

//239
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetPairOfMutuallyExclusiveSetsOfTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.students<<tc.selectedDays1<<tc.selectedHours1<<tc.selectedDays2<<tc.selectedHours2;

	return stream;
}

//240
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsPairOfMutuallyExclusiveSetsOfTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.selectedDays1<<tc.selectedHours1<<tc.selectedDays2<<tc.selectedHours2;

	return stream;
}

//241
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesPairOfMutuallyExclusiveSetsOfTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.selectedDays1<<tc.selectedHours1<<tc.selectedDays2<<tc.selectedHours2;

	return stream;
}

//242
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesPairOfMutuallyExclusiveTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.day1<<tc.hour1<<tc.day2<<tc.hour2;

	return stream;
}

//243
QDataStream& operator<<(QDataStream& stream, const ConstraintTeacherOccupiesMaxSetsOfTimeSlotsFromSelection& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.teacherName<<tc.maxOccupiedSets<<tc.selectedDays<<tc.selectedHours;

	return stream;
}

//244
QDataStream& operator<<(QDataStream& stream, const ConstraintTeachersOccupyMaxSetsOfTimeSlotsFromSelection& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxOccupiedSets<<tc.selectedDays<<tc.selectedHours;

	return stream;
}

//245
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsSetOccupiesMaxSetsOfTimeSlotsFromSelection& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.students<<tc.maxOccupiedSets<<tc.selectedDays<<tc.selectedHours;

	return stream;
}

//246
QDataStream& operator<<(QDataStream& stream, const ConstraintStudentsOccupyMaxSetsOfTimeSlotsFromSelection& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.maxOccupiedSets<<tc.selectedDays<<tc.selectedHours;

	return stream;
}

//247
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesOverlapCompletelyOrDoNotOverlap& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds;

	return stream;
}

//248
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesOccupyMaxSetsOfTimeSlotsFromSelection& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.maxOccupiedSets<<tc.selectedDays<<tc.selectedHours;

	return stream;
}

//249
QDataStream& operator<<(QDataStream& stream, const ConstraintActivityBeginsOrEndsStudentsDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityId;

	return stream;
}

//250
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesBeginOrEndStudentsDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.studentsName<<tc.subjectName<<tc.teacherName;

	return stream;
}

//251
QDataStream& operator<<(QDataStream& stream, const ConstraintActivityBeginsOrEndsTeachersDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityId;

	return stream;
}

//252
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesBeginOrEndTeachersDay& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activityTagName<<tc.studentsName<<tc.subjectName<<tc.teacherName;

	return stream;
}

//253
QDataStream& operator<<(QDataStream& stream, const ConstraintActivitiesMaxTotalNumberOfStudentsInSelectedTimeSlots& tc)
{
	//stream<<tc.type;
	stream<<tc.weightPercentage;
	stream<<tc.active;
	stream<<tc.comments;

	stream<<tc.activitiesIds<<tc.maxNumberOfStudents<<tc.selectedDays<<tc.selectedHours;

	return stream;
}

//1
QDataStream& operator>>(QDataStream& stream, ConstraintBasicCompulsoryTime& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	return stream;
}

//2
QDataStream& operator>>(QDataStream& stream, ConstraintBreakTimes& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.days>>tc.hours;

	return stream;
}

//3
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherNotAvailableTimes& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.days>>tc.hours>>tc.teacher;

	return stream;
}

//4
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxHoursDaily& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursDaily;

	return stream;
}

//5
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxDaysPerWeek>>tc.teacherName;

	return stream;
}

//6
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxGapsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxGaps;

	return stream;
}

//7
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxGapsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxGaps>>tc.teacherName;

	return stream;
}

//8
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxHoursDaily& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursDaily>>tc.teacherName;

	return stream;
}

//9
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxHoursContinuously& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursContinuously;

	return stream;
}

//10
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxHoursContinuously& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursContinuously>>tc.teacherName;

	return stream;
}

//11
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMinHoursDaily& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowEmptyDays>>tc.minHoursDaily;

	return stream;
}

//12
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMinHoursDaily& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowEmptyDays>>tc.minHoursDaily>>tc.teacherName;

	return stream;
}

//13
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxGapsPerDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxGaps;

	return stream;
}

//14
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxGapsPerDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxGaps>>tc.teacherName;

	return stream;
}

//15
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxBeginningsAtSecondHour;

	return stream;
}

//16
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxBeginningsAtSecondHour>>tc.students;

	return stream;
}

//17
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetNotAvailableTimes& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.days>>tc.hours>>tc.students;

	return stream;
}

//18
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMaxGapsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxGaps;

	return stream;
}

//19
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMaxGapsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxGaps>>tc.students;

	return stream;
}

//20
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMaxHoursDaily& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursDaily;

	return stream;
}

//21
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMaxHoursDaily& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursDaily>>tc.students;

	return stream;
}

//22
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMaxHoursContinuously& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursContinuously;

	return stream;
}

//23
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMaxHoursContinuously& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursContinuously>>tc.students;

	return stream;
}

//24
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMinHoursDaily& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowEmptyDays>>tc.minHoursDaily;

	return stream;
}

//25
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMinHoursDaily& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowEmptyDays>>tc.minHoursDaily>>tc.students;

	return stream;
}

//26
QDataStream& operator>>(QDataStream& stream, ConstraintActivityEndsStudentsDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityId;

	return stream;
}

//27
QDataStream& operator>>(QDataStream& stream, ConstraintActivityPreferredStartingTime& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityId>>tc.day>>tc.hour>>tc.permanentlyLocked;

	return stream;
}

//28
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesSameStartingTime& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.n_activities;

	return stream;
}

//29
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesNotOverlapping& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.n_activities;

	return stream;
}

//30
QDataStream& operator>>(QDataStream& stream, ConstraintMinDaysBetweenActivities& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.n_activities>>tc.consecutiveIfSameDay>>tc.minDays;

	return stream;
}

//31
QDataStream& operator>>(QDataStream& stream, ConstraintActivityPreferredTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.p_activityId>>tc.p_days_L>>tc.p_hours_L>>tc.p_nPreferredTimeSlots_L;

	return stream;
}

//32
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesPreferredTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.duration>>tc.p_days_L>>tc.p_hours_L>>tc.p_nPreferredTimeSlots_L
		 >>tc.p_activityTagName>>tc.p_studentsName>>tc.p_subjectName>>tc.p_teacherName;

	return stream;
}

//33
QDataStream& operator>>(QDataStream& stream, ConstraintActivityPreferredStartingTimes& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityId>>tc.days_L>>tc.hours_L>>tc.nPreferredStartingTimes_L;

	return stream;
}

//34
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesPreferredStartingTimes& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.duration>>tc.days_L>>tc.hours_L>>tc.nPreferredStartingTimes_L
		 >>tc.activityTagName>>tc.studentsName>>tc.subjectName>>tc.teacherName;

	return stream;
}

//35
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesSameStartingHour& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.n_activities;

	return stream;
}

//36
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesSameStartingDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.n_activities;

	return stream;
}

//37
QDataStream& operator>>(QDataStream& stream, ConstraintTwoActivitiesConsecutive& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.firstActivityId>>tc.secondActivityId;

	return stream;
}

//38
QDataStream& operator>>(QDataStream& stream, ConstraintTwoActivitiesOrdered& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.firstActivityId>>tc.secondActivityId;

	return stream;
}

//39
QDataStream& operator>>(QDataStream& stream, ConstraintMinGapsBetweenActivities& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.n_activities>>tc.minGaps;

	return stream;
}

//40
QDataStream& operator>>(QDataStream& stream, ConstraintSubactivitiesPreferredTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.duration>>tc.p_days_L>>tc.p_hours_L>>tc.p_nPreferredTimeSlots_L
		 >>tc.p_activityTagName>>tc.p_studentsName>>tc.p_subjectName>>tc.p_teacherName>>tc.componentNumber;

	return stream;
}

//41
QDataStream& operator>>(QDataStream& stream, ConstraintSubactivitiesPreferredStartingTimes& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.duration>>tc.days_L>>tc.hours_L>>tc.nPreferredStartingTimes_L
		 >>tc.activityTagName>>tc.studentsName>>tc.subjectName>>tc.teacherName>>tc.componentNumber;

	return stream;
}

//42
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherIntervalMaxDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.startHour>>tc.endHour>>tc.maxDaysPerWeek>>tc.teacherName;

	return stream;
}

//43
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersIntervalMaxDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.startHour>>tc.endHour>>tc.maxDaysPerWeek;

	return stream;
}

//44
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetIntervalMaxDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.startHour>>tc.endHour>>tc.maxDaysPerWeek>>tc.students;

	return stream;
}

//45
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsIntervalMaxDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.startHour>>tc.endHour>>tc.maxDaysPerWeek;

	return stream;
}

//46
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesEndStudentsDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.studentsName>>tc.subjectName>>tc.teacherName;

	return stream;
}

//47
QDataStream& operator>>(QDataStream& stream, ConstraintTwoActivitiesGrouped& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.firstActivityId>>tc.secondActivityId;

	return stream;
}

//48
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersActivityTagMaxHoursContinuously& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.maxHoursContinuously;

	return stream;
}

//49
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherActivityTagMaxHoursContinuously& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.maxHoursContinuously>>tc.teacherName;

	return stream;
}

//50
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsActivityTagMaxHoursContinuously& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.maxHoursContinuously;

	return stream;
}

//51
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetActivityTagMaxHoursContinuously& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.maxHoursContinuously>>tc.students;

	return stream;
}

//52
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxDaysPerWeek;

	return stream;
}

//53
QDataStream& operator>>(QDataStream& stream, ConstraintThreeActivitiesGrouped& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.firstActivityId>>tc.secondActivityId>>tc.thirdActivityId;

	return stream;
}

//54
QDataStream& operator>>(QDataStream& stream, ConstraintMaxDaysBetweenActivities& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.n_activities>>tc.maxDays;

	return stream;
}

//55
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMinDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.minDaysPerWeek;

	return stream;
}

//56
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMinDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.minDaysPerWeek>>tc.teacherName;

	return stream;
}

//57
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersActivityTagMaxHoursDaily& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.maxHoursDaily;

	return stream;
}

//58
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherActivityTagMaxHoursDaily& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.maxHoursDaily>>tc.teacherName;

	return stream;
}

//59
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsActivityTagMaxHoursDaily& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.maxHoursDaily;

	return stream;
}

//60
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetActivityTagMaxHoursDaily& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.maxHoursDaily>>tc.students;

	return stream;
}

//61
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMaxGapsPerDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxGaps;

	return stream;
}

//62
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMaxGapsPerDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxGaps>>tc.students;

	return stream;
}

//63
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesOccupyMaxTimeSlotsFromSelection& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.maxOccupiedTimeSlots>>tc.selectedDays>>tc.selectedHours;

	return stream;
}

//64
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.maxSimultaneous>>tc.selectedDays>>tc.selectedHours;

	return stream;
}

//65
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMaxDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxDaysPerWeek>>tc.students;

	return stream;
}

//66
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMaxDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxDaysPerWeek;

	return stream;
}

//67
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxSpanPerDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowOneDayExceptionPlusOne>>tc.maxSpanPerDay>>tc.teacherName;

	return stream;
}

//68
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxSpanPerDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowOneDayExceptionPlusOne>>tc.maxSpanPerDay;

	return stream;
}

//69
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMinRestingHours& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.circular>>tc.minRestingHours>>tc.teacherName;

	return stream;
}

//70
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMinRestingHours& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.circular>>tc.minRestingHours;

	return stream;
}

//71
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMaxSpanPerDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxSpanPerDay>>tc.students;

	return stream;
}

//72
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMaxSpanPerDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxSpanPerDay;

	return stream;
}

//73
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMinRestingHours& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.circular>>tc.minRestingHours>>tc.students;

	return stream;
}

//74
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMinRestingHours& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.circular>>tc.minRestingHours;

	return stream;
}

//75
QDataStream& operator>>(QDataStream& stream, ConstraintTwoActivitiesOrderedIfSameDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.firstActivityId>>tc.secondActivityId;

	return stream;
}

//76
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTags& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.firstActivityTag>>tc.secondActivityTag>>tc.minGaps>>tc.students;

	return stream;
}

//77
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTags& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.firstActivityTag>>tc.secondActivityTag>>tc.minGaps;

	return stream;
}

//78
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTags& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.firstActivityTag>>tc.secondActivityTag>>tc.minGaps>>tc.teacher;

	return stream;
}

//79
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTags& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.firstActivityTag>>tc.secondActivityTag>>tc.minGaps;

	return stream;
}

//80
QDataStream& operator>>(QDataStream& stream, ConstraintActivityTagsNotOverlapping& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagsNames;

	return stream;
}

//81
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesOccupyMinTimeSlotsFromSelection& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.minOccupiedTimeSlots>>tc.selectedDays>>tc.selectedHours;

	return stream;
}

//82
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesMinSimultaneousInSelectedTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.allowEmptySlots>>tc.minSimultaneous>>tc.selectedDays>>tc.selectedHours;

	return stream;
}

//83
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersActivityTagMinHoursDaily& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.minHoursDaily>>tc.minDaysWithTag;

	return stream;
}

//84
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherActivityTagMinHoursDaily& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.minHoursDaily>>tc.minDaysWithTag>>tc.teacherName;

	return stream;
}

//85
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsActivityTagMinHoursDaily& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.minHoursDaily>>tc.minDaysWithTag;

	return stream;
}

//86
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetActivityTagMinHoursDaily& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.minHoursDaily>>tc.minDaysWithTag>>tc.students;

	return stream;
}

//87
QDataStream& operator>>(QDataStream& stream, ConstraintActivityEndsTeachersDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityId;

	return stream;
}

//88
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesEndTeachersDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.studentsName>>tc.subjectName>>tc.teacherName;

	return stream;
}

//89
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxHoursDailyRealDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursDaily;

	return stream;
}

//90
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxRealDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxDaysPerWeek>>tc.teacherName;

	return stream;
}

//91
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxHoursDailyRealDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursDaily>>tc.teacherName;

	return stream;
}

//92
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMaxHoursDailyRealDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursDaily;

	return stream;
}

//93
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMaxHoursDailyRealDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursDaily>>tc.students;

	return stream;
}

//94
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxRealDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxDaysPerWeek;

	return stream;
}

//95
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMinRealDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.minDaysPerWeek;

	return stream;
}

//96
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMinRealDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.minDaysPerWeek>>tc.teacherName;

	return stream;
}

//97
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersActivityTagMaxHoursDailyRealDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.maxHoursDaily;

	return stream;
}

//98
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherActivityTagMaxHoursDailyRealDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.maxHoursDaily>>tc.teacherName;

	return stream;
}

//99
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsActivityTagMaxHoursDailyRealDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.maxHoursDaily;

	return stream;
}

//100
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetActivityTagMaxHoursDailyRealDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.maxHoursDaily>>tc.students;

	return stream;
}

//101
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxAfternoonsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxAfternoonsPerWeek>>tc.teacherName;

	return stream;
}

//102
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxAfternoonsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxAfternoonsPerWeek;

	return stream;
}

//103
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxMorningsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxMorningsPerWeek>>tc.teacherName;

	return stream;
}

//104
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxMorningsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxMorningsPerWeek;

	return stream;
}

//105
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxActivityTagsPerDayFromSet& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.teacherName>>tc.maxTags>>tc.tagsList;

	return stream;
}

//106
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxActivityTagsPerDayFromSet& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;
	
	stream>>tc.maxTags>>tc.tagsList;

	return stream;
}

//107
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMinMorningsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.minMorningsPerWeek;

	return stream;
}

//108
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMinMorningsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.minMorningsPerWeek>>tc.teacherName;

	return stream;
}

//109
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMinAfternoonsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.minAfternoonsPerWeek;

	return stream;
}

//110
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMinAfternoonsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.minAfternoonsPerWeek>>tc.teacherName;

	return stream;
}

//111
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxTwoConsecutiveMornings& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.teacherName;

	return stream;
}

//112
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxTwoConsecutiveMornings& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	return stream;
}

//113
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxTwoConsecutiveAfternoons& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.teacherName;

	return stream;
}

//114
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxTwoConsecutiveAfternoons& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	return stream;
}

//115
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxGapsPerRealDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowOneDayExceptionPlusOne>>tc.maxGaps;

	return stream;
}

//116
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxGapsPerRealDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowOneDayExceptionPlusOne>>tc.maxGaps>>tc.teacherName;

	return stream;
}

//117
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMaxGapsPerRealDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxGaps;

	return stream;
}

//118
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMaxGapsPerRealDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxGaps>>tc.students;

	return stream;
}

//119
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMinHoursDailyRealDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowEmptyDays>>tc.minHoursDaily;

	return stream;
}

//120
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMinHoursDailyRealDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowEmptyDays>>tc.minHoursDaily>>tc.teacherName;

	return stream;
}

//121
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersAfternoonsEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxBeginningsAtSecondHour;

	return stream;
}

//122
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherAfternoonsEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxBeginningsAtSecondHour>>tc.teacherName;

	return stream;
}

//123
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMinHoursPerMorning& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowEmptyMornings>>tc.minHoursPerMorning;

	return stream;
}

//124
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMinHoursPerMorning& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowEmptyMornings>>tc.minHoursPerMorning>>tc.teacherName;

	return stream;
}

//125
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxSpanPerRealDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowOneDayExceptionPlusOne>>tc.maxSpanPerDay>>tc.teacherName;

	return stream;
}

//126
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxSpanPerRealDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowOneDayExceptionPlusOne>>tc.maxSpanPerDay;

	return stream;
}

//127
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMaxSpanPerRealDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxSpanPerDay>>tc.students;

	return stream;
}

//128
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMaxSpanPerRealDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxSpanPerDay;

	return stream;
}

//129
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMorningIntervalMaxDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxDaysPerWeek>>tc.startHour>>tc.endHour>>tc.teacherName;

	return stream;
}

//130
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMorningIntervalMaxDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxDaysPerWeek>>tc.startHour>>tc.endHour;

	return stream;
}

//131
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherAfternoonIntervalMaxDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxDaysPerWeek>>tc.startHour>>tc.endHour>>tc.teacherName;

	return stream;
}

//132
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersAfternoonIntervalMaxDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxDaysPerWeek>>tc.startHour>>tc.endHour;

	return stream;
}

//133
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMinHoursPerMorning& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowEmptyMornings>>tc.minHoursPerMorning;

	return stream;
}

//134
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMinHoursPerMorning& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowEmptyMornings>>tc.minHoursPerMorning>>tc.students;

	return stream;
}

//135
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxZeroGapsPerAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.teacherName;

	return stream;
}

//136
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxZeroGapsPerAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	return stream;
}

//137
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMaxAfternoonsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxAfternoonsPerWeek>>tc.students;

	return stream;
}

//138
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMaxAfternoonsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxAfternoonsPerWeek;

	return stream;
}

//139
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMaxMorningsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxMorningsPerWeek>>tc.students;

	return stream;
}

//140
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMaxMorningsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxMorningsPerWeek;

	return stream;
}

//141
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMinMorningsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.minMorningsPerWeek;

	return stream;
}

//142
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMinMorningsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.minMorningsPerWeek>>tc.students;

	return stream;
}

//143
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMinAfternoonsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.minAfternoonsPerWeek;

	return stream;
}

//144
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMinAfternoonsPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.minAfternoonsPerWeek>>tc.students;

	return stream;
}

//145
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMorningIntervalMaxDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxDaysPerWeek>>tc.startHour>>tc.endHour>>tc.students;

	return stream;
}

//146
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMorningIntervalMaxDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxDaysPerWeek>>tc.startHour>>tc.endHour;

	return stream;
}

//147
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetAfternoonIntervalMaxDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxDaysPerWeek>>tc.startHour>>tc.endHour>>tc.students;

	return stream;
}

//148
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsAfternoonIntervalMaxDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxDaysPerWeek>>tc.startHour>>tc.endHour;

	return stream;
}

//149
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxHoursPerAllAfternoons& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursPerAllAfternoons>>tc.teacherName;

	return stream;
}

//150
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxHoursPerAllAfternoons& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursPerAllAfternoons;

	return stream;
}

//151
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMaxHoursPerAllAfternoons& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursPerAllAfternoons>>tc.students;

	return stream;
}

//152
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMaxHoursPerAllAfternoons& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursPerAllAfternoons;

	return stream;
}

//153
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMinRestingHoursBetweenMorningAndAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.minRestingHours>>tc.teacherName;

	return stream;
}

//154
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMinRestingHoursBetweenMorningAndAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.minRestingHours;

	return stream;
}

//155
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMinRestingHoursBetweenMorningAndAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.minRestingHours>>tc.students;

	return stream;
}

//156
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMinRestingHoursBetweenMorningAndAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.minRestingHours;

	return stream;
}

//157
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetAfternoonsEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxBeginningsAtSecondHour>>tc.students;

	return stream;
}

//158
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsAfternoonsEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxBeginningsAtSecondHour;

	return stream;
}

//159
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxGapsPerWeekForRealDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxGaps;

	return stream;
}

//160
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxGapsPerWeekForRealDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxGaps>>tc.teacherName;

	return stream;
}

//161
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMaxGapsPerWeekForRealDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxGaps;

	return stream;
}

//162
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMaxGapsPerWeekForRealDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxGaps>>tc.students;

	return stream;
}

//163
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMaxRealDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxDaysPerWeek>>tc.students;

	return stream;
}

//164
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMaxRealDaysPerWeek& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxDaysPerWeek;

	return stream;
}

//165
QDataStream& operator>>(QDataStream& stream, ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.maxActivities>>tc.selectedDays>>tc.selectedHours;

	return stream;
}

//166
QDataStream& operator>>(QDataStream& stream, ConstraintMaxGapsBetweenActivities& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.n_activities>>tc.maxGaps;

	return stream;
}

//167
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesMaxInATerm& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.maxActivitiesInATerm;

	return stream;
}

//168
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesOccupyMaxTerms& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.maxOccupiedTerms;

	return stream;
}

//169
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxGapsPerMorningAndAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxGaps;

	return stream;
}

//170
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxGapsPerMorningAndAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxGaps>>tc.teacherName;

	return stream;
}

//171
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMorningsEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxBeginningsAtSecondHour;

	return stream;
}

//172
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMorningsEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxBeginningsAtSecondHour>>tc.teacherName;

	return stream;
}

//173
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMorningsEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxBeginningsAtSecondHour>>tc.students;

	return stream;
}

//174
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMorningsEarlyMaxBeginningsAtSecondHour& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxBeginningsAtSecondHour;

	return stream;
}

//175
QDataStream& operator>>(QDataStream& stream, ConstraintTwoSetsOfActivitiesOrdered& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.firstActivitiesIdsList>>tc.secondActivitiesIdsList;

	return stream;
}

//176
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxThreeConsecutiveDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowAMAMException;

	return stream;
}

//177
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxThreeConsecutiveDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowAMAMException>>tc.teacherName;

	return stream;
}

//178
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMinGapsBetweenActivityTag& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTag>>tc.minGaps>>tc.students;

	return stream;
}

//179
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMinGapsBetweenActivityTag& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTag>>tc.minGaps;

	return stream;
}

//180
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMinGapsBetweenActivityTag& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTag>>tc.minGaps>>tc.teacher;

	return stream;
}

//181
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMinGapsBetweenActivityTag& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTag>>tc.minGaps;

	return stream;
}

//182
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMaxThreeConsecutiveDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowAMAMException;

	return stream;
}

//183
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMaxThreeConsecutiveDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowAMAMException>>tc.students;

	return stream;
}

//184
QDataStream& operator>>(QDataStream& stream, ConstraintMinHalfDaysBetweenActivities& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.n_activities>>tc.consecutiveIfSameDay>>tc.minDays;

	return stream;
}

//185
QDataStream& operator>>(QDataStream& stream, ConstraintActivityPreferredDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityId>>tc.day;

	return stream;
}

//186
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesMinInATerm& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.minActivitiesInATerm>>tc.allowEmptyTerms;

	return stream;
}

//187
QDataStream& operator>>(QDataStream& stream, ConstraintMaxTermsBetweenActivities& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.n_activities>>tc.maxTerms;

	return stream;
}

//188
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMaxActivityTagsPerDayFromSet& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.students>>tc.maxTags>>tc.tagsList;

	return stream;
}

//189
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMaxActivityTagsPerDayFromSet& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;
	
	stream>>tc.maxTags>>tc.tagsList;

	return stream;
}

//190
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxActivityTagsPerRealDayFromSet& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.teacherName>>tc.maxTags>>tc.tagsList;

	return stream;
}

//191
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxActivityTagsPerRealDayFromSet& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;
	
	stream>>tc.maxTags>>tc.tagsList;

	return stream;
}

//192
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMaxActivityTagsPerRealDayFromSet& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.students>>tc.maxTags>>tc.tagsList;

	return stream;
}

//193
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMaxActivityTagsPerRealDayFromSet& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;
	
	stream>>tc.maxTags>>tc.tagsList;

	return stream;
}

//194
QDataStream& operator>>(QDataStream& stream, ConstraintMaxHalfDaysBetweenActivities& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.n_activities>>tc.maxDays;

	return stream;
}

//195
QDataStream& operator>>(QDataStream& stream, ConstraintActivityBeginsStudentsDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityId;

	return stream;
}

//196
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesBeginStudentsDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.studentsName>>tc.subjectName>>tc.teacherName;

	return stream;
}

//197
QDataStream& operator>>(QDataStream& stream, ConstraintActivityBeginsTeachersDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityId;

	return stream;
}

//198
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesBeginTeachersDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.studentsName>>tc.subjectName>>tc.teacherName;

	return stream;
}

//199
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMinHoursPerAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowEmptyAfternoons>>tc.minHoursPerAfternoon;

	return stream;
}

//200
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMinHoursPerAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowEmptyAfternoons>>tc.minHoursPerAfternoon>>tc.teacherName;

	return stream;
}

//201
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMinHoursPerAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowEmptyAfternoons>>tc.minHoursPerAfternoon;

	return stream;
}

//202
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMinHoursPerAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.allowEmptyAfternoons>>tc.minHoursPerAfternoon>>tc.students;

	return stream;
}

//203
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesMaxHourlySpan& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.n_activities>>tc.maxHourlySpan;

	return stream;
}

//204
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxHoursDailyInInterval& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursDaily>>tc.teacherName>>tc.startHour>>tc.endHour;

	return stream;
}

//205
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxHoursDailyInInterval& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursDaily>>tc.startHour>>tc.endHour;

	return stream;
}

//206
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMaxHoursDailyInInterval& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursDaily>>tc.students>>tc.startHour>>tc.endHour;

	return stream;
}

//207
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMaxHoursDailyInInterval& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursDaily>>tc.startHour>>tc.endHour;

	return stream;
}

//208
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.firstActivityTag>>tc.secondActivityTag>>tc.minGaps>>tc.students;

	return stream;
}

//209
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsPerRealDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.firstActivityTag>>tc.secondActivityTag>>tc.minGaps;

	return stream;
}

//210
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsPerRealDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.firstActivityTag>>tc.secondActivityTag>>tc.minGaps>>tc.teacher;

	return stream;
}

//211
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsPerRealDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.firstActivityTag>>tc.secondActivityTag>>tc.minGaps;

	return stream;
}

//212
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMinGapsBetweenActivityTagPerRealDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTag>>tc.minGaps>>tc.students;

	return stream;
}

//213
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMinGapsBetweenActivityTagPerRealDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTag>>tc.minGaps;

	return stream;
}

//214
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMinGapsBetweenActivityTagPerRealDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTag>>tc.minGaps>>tc.teacher;

	return stream;
}

//215
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMinGapsBetweenActivityTagPerRealDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTag>>tc.minGaps;

	return stream;
}

//216
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.firstActivityTag>>tc.secondActivityTag>>tc.minGaps>>tc.students;

	return stream;
}

//217
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.firstActivityTag>>tc.secondActivityTag>>tc.minGaps;

	return stream;
}

//218
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.firstActivityTag>>tc.secondActivityTag>>tc.minGaps>>tc.teacher;

	return stream;
}

//219
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.firstActivityTag>>tc.secondActivityTag>>tc.minGaps;

	return stream;
}

//220
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTag>>tc.minGaps>>tc.students;

	return stream;
}

//221
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMinGapsBetweenActivityTagBetweenMorningAndAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTag>>tc.minGaps;

	return stream;
}

//222
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMinGapsBetweenActivityTagBetweenMorningAndAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTag>>tc.minGaps>>tc.teacher;

	return stream;
}

//223
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMinGapsBetweenActivityTagBetweenMorningAndAfternoon& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTag>>tc.minGaps;

	return stream;
}

//224
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersNoTwoConsecutiveDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	return stream;
}

//225
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherNoTwoConsecutiveDays& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.teacherName;

	return stream;
}

//226
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherPairOfMutuallyExclusiveTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.teacherName>>tc.day1>>tc.hour1>>tc.day2>>tc.hour2;

	return stream;
}

//227
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersPairOfMutuallyExclusiveTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.day1>>tc.hour1>>tc.day2>>tc.hour2;

	return stream;
}

//228
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetPairOfMutuallyExclusiveTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.students>>tc.day1>>tc.hour1>>tc.day2>>tc.hour2;

	return stream;
}

//229
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsPairOfMutuallyExclusiveTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.day1>>tc.hour1>>tc.day2>>tc.hour2;

	return stream;
}

//230
QDataStream& operator>>(QDataStream& stream, ConstraintTwoSetsOfActivitiesSameSections& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesAIds>>tc.activitiesBIds>>tc.oDays>>tc.oHours;

	return stream;
}

//231
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsMaxSingleGapsInSelectedTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxSingleGaps>>tc.selectedDays>>tc.selectedHours;

	return stream;
}

//232
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetMaxSingleGapsInSelectedTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.students>>tc.maxSingleGaps>>tc.selectedDays>>tc.selectedHours;

	return stream;
}

//233
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxSingleGapsInSelectedTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxSingleGaps>>tc.selectedDays>>tc.selectedHours;

	return stream;
}

//234
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxSingleGapsInSelectedTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.teacher>>tc.maxSingleGaps>>tc.selectedDays>>tc.selectedHours;

	return stream;
}

//235
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherMaxHoursPerTerm& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursPerTerm>>tc.teacherName;

	return stream;
}

//236
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersMaxHoursPerTerm& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxHoursPerTerm;

	return stream;
}

//237
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherPairOfMutuallyExclusiveSetsOfTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.teacherName>>tc.selectedDays1>>tc.selectedHours1>>tc.selectedDays2>>tc.selectedHours2;

	return stream;
}

//238
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersPairOfMutuallyExclusiveSetsOfTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.selectedDays1>>tc.selectedHours1>>tc.selectedDays2>>tc.selectedHours2;

	return stream;
}

//239
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetPairOfMutuallyExclusiveSetsOfTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.students>>tc.selectedDays1>>tc.selectedHours1>>tc.selectedDays2>>tc.selectedHours2;

	return stream;
}

//240
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsPairOfMutuallyExclusiveSetsOfTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.selectedDays1>>tc.selectedHours1>>tc.selectedDays2>>tc.selectedHours2;

	return stream;
}

//241
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesPairOfMutuallyExclusiveSetsOfTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.selectedDays1>>tc.selectedHours1>>tc.selectedDays2>>tc.selectedHours2;

	return stream;
}

//242
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesPairOfMutuallyExclusiveTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.day1>>tc.hour1>>tc.day2>>tc.hour2;

	return stream;
}

//243
QDataStream& operator>>(QDataStream& stream, ConstraintTeacherOccupiesMaxSetsOfTimeSlotsFromSelection& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.teacherName>>tc.maxOccupiedSets>>tc.selectedDays>>tc.selectedHours;

	return stream;
}

//244
QDataStream& operator>>(QDataStream& stream, ConstraintTeachersOccupyMaxSetsOfTimeSlotsFromSelection& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxOccupiedSets>>tc.selectedDays>>tc.selectedHours;

	return stream;
}

//245
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsSetOccupiesMaxSetsOfTimeSlotsFromSelection& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.students>>tc.maxOccupiedSets>>tc.selectedDays>>tc.selectedHours;

	return stream;
}

//246
QDataStream& operator>>(QDataStream& stream, ConstraintStudentsOccupyMaxSetsOfTimeSlotsFromSelection& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.maxOccupiedSets>>tc.selectedDays>>tc.selectedHours;

	return stream;
}

//247
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesOverlapCompletelyOrDoNotOverlap& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds;

	return stream;
}

//248
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesOccupyMaxSetsOfTimeSlotsFromSelection& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.maxOccupiedSets>>tc.selectedDays>>tc.selectedHours;

	return stream;
}

//249
QDataStream& operator>>(QDataStream& stream, ConstraintActivityBeginsOrEndsStudentsDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityId;

	return stream;
}

//250
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesBeginOrEndStudentsDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.studentsName>>tc.subjectName>>tc.teacherName;

	return stream;
}

//251
QDataStream& operator>>(QDataStream& stream, ConstraintActivityBeginsOrEndsTeachersDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityId;

	return stream;
}

//252
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesBeginOrEndTeachersDay& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activityTagName>>tc.studentsName>>tc.subjectName>>tc.teacherName;

	return stream;
}

//253
QDataStream& operator>>(QDataStream& stream, ConstraintActivitiesMaxTotalNumberOfStudentsInSelectedTimeSlots& tc)
{
	//stream>>tc.type;
	stream>>tc.weightPercentage;
	stream>>tc.active;
	stream>>tc.comments;

	stream>>tc.activitiesIds>>tc.maxNumberOfStudents>>tc.selectedDays>>tc.selectedHours;

	return stream;
}

QString listsOfDaysAndHoursToTable(Rules& r, const QList<int>& days, const QList<int>& hours, bool direct, bool notAvailable, bool colors)
{
	QString s;
	QSet<int> selectedTimesSet;
	
	assert(days.count()==hours.count());
	
	for(int i=0; i<days.count(); i++){
		int d=days.at(i);
		int h=hours.at(i);
		assert(d>=0);
		assert(h>=0);
		selectedTimesSet.insert(d+h*r.nDaysPerWeek);
	}
	
	s+="<table align=\"center\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n";
	for(int rh=0; rh<(r.mode!=MORNINGS_AFTERNOONS?r.nHoursPerDay:r.nRealHoursPerDay); rh++){
		int h=(r.mode!=MORNINGS_AFTERNOONS?rh:rh%r.nHoursPerDay);
		s+="<tr>\n";
		for(int rd=0; rd<(r.mode!=MORNINGS_AFTERNOONS?r.nDaysPerWeek:r.nRealDaysPerWeek); rd++){
			int d;
			if(!LANGUAGE_STYLE_RIGHT_TO_LEFT)
				d=(r.mode!=MORNINGS_AFTERNOONS?rd:2*rd+(rh/r.nHoursPerDay));
			else
				d=(r.mode!=MORNINGS_AFTERNOONS?(r.nDaysPerWeek-1-rd):2*(r.nRealDaysPerWeek-1-rd)+(rh/r.nHoursPerDay));

			//The 'style='background-color: ...; color: ...;'' code was suggested by g.theodoroy.
			if((direct && selectedTimesSet.contains(d+h*r.nDaysPerWeek)) || (!direct && !selectedTimesSet.contains(d+h*r.nDaysPerWeek))){
				s+="<td width=\"20\" align=\"center\"";
				/*if(r.mode==MORNINGS_AFTERNOONS && rh==r.nHoursPerDay-1){
					s+=" border-bottom-width=\"2px\"";
				}*/

				if(colors){
					if(notAvailable){
						//s+=" bgcolor=\"darkred\"";
						s+=" style=\"background-color: darkred; color: lightgray;\"";
					}
					else{
						//s+=" bgcolor=\"darkcyan\"";
						s+=" style=\"background-color: darkcyan; color: lightgray;\"";
					}
				}
				s+=">";
				s+=notAvailable?"X":"✓";
				s+="</td>\n";
			}
			else{
				s+="<td width=\"20\" align=\"center\"";
				if(colors){
					if(notAvailable){
						//s+=" bgcolor=\"darkgreen\"";
						s+=" style=\"background-color: darkgreen;\"";
					}
					else{
						//s+=" bgcolor=\"darkgoldenrod\"";
						s+=" style=\"background-color: darkgoldenrod;\"";
					}
				}
				s+=">&nbsp;</td>\n";
			}
		}
		s+="</tr>\n";
		if(r.mode==MORNINGS_AFTERNOONS && rh==r.nHoursPerDay-1) //By g.theodoroy.
			s+="</table>\n<table align=\"center\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\" style=\"margin-top:5;\">";
	}
	s+="</table>\n";
	
	return s;
}

QString listsOfListsOfDaysAndHoursToTableOfNumbers(Rules& r, const QList<QList<int>>& days, const QList<QList<int>>& hours, bool colors)
{
	QString s;
	
	assert(days.count()==hours.count());
	
	Matrix2D<int> a;
	a.resize(r.nDaysPerWeek, r.nHoursPerDay);
	for(int d=0; d<r.nDaysPerWeek; d++)
		for(int h=0; h<r.nHoursPerDay; h++)
			a[d][h]=0;
			
	for(int i=0; i<days.count(); i++){
		const QList<int>& dl=days.at(i);
		const QList<int>& hl=hours.at(i);
		
		assert(dl.count()==hl.count());
		
		for(int j=0; j<dl.count(); j++){
			int d=dl.at(j);
			int h=hl.at(j);
			a[d][h]=i+1;
		}
	}
	
	s+="<table align=\"center\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">\n";
	for(int rh=0; rh<(r.mode!=MORNINGS_AFTERNOONS?r.nHoursPerDay:r.nRealHoursPerDay); rh++){
		int h=(r.mode!=MORNINGS_AFTERNOONS?rh:rh%r.nHoursPerDay);
		s+="<tr>\n";
		for(int rd=0; rd<(r.mode!=MORNINGS_AFTERNOONS?r.nDaysPerWeek:r.nRealDaysPerWeek); rd++){
			int d;
			if(!LANGUAGE_STYLE_RIGHT_TO_LEFT)
				d=(r.mode!=MORNINGS_AFTERNOONS?rd:2*rd+(rh/r.nHoursPerDay));
			else
				d=(r.mode!=MORNINGS_AFTERNOONS?(r.nDaysPerWeek-1-rd):2*(r.nRealDaysPerWeek-1-rd)+(rh/r.nHoursPerDay));
			if(a[d][h]>0){
				s+="<td width=\"20\" align=\"center\"";
				if(colors){
					QString bgColor;
					QString fgColor;
					
					switch(a[d][h]){
						case 1:
							bgColor="darkblue";
							fgColor="white";

							break;
							
						case 2:
							bgColor="darkorange";
							fgColor="black";

							break;
							
						case 3:
							bgColor="darkcyan";
							fgColor="white";

							break;
							
						case 4:
							bgColor="darkmagenta";
							fgColor="white";

							break;
							
						case 5:
							bgColor="darksalmon";
							fgColor="black";

							break;
							
						case 6:
							bgColor="chartreuse";
							fgColor="black";

							break;
							
						case 7:
							bgColor="darkgrey";
							fgColor="black";

							break;
							
						case 8:
							bgColor="gold";
							fgColor="black";

							break;
							
						case 9:
							//bgColor="#b25ec7"; //rgb(178, 94, 199)
							bgColor="rgb(178, 94, 199)";
							fgColor="black";

							break;
							
						case 10:
							//bgColor="#935f35"; //rgb(147, 95, 53)
							bgColor="rgb(147, 95, 53)";
							fgColor="white";

							break;
							
						default:
							int r, g, b;
							TimetableExport::stringToColor(QString::number(a[d][h]), r, g, b);
							double brightness = double(r)*0.299 + double(g)*0.587 + double(b)*0.114;
							bgColor="rgb("+QString::number(r)+", "+QString::number(g)+", "+QString::number(b)+")";
							//bgColor="#"+QString::number(r, 16)+QString::number(g, 16)+QString::number(b, 16);
							if(brightness<127.5)
								fgColor="white";
							else
								fgColor="black";

							break;
					}
					//s+=" bgcolor=\""+bgColor+"\"";// "fgcolor=\""+fgColor+"\""*/;
					//The 'style='background-color: ...; color: ...;'' code was suggested by g.theodoroy.
					s+=" style=\"background-color: "+bgColor+"; color: "+fgColor+";\"";
				}
				s+=">";
				s+=QString::number(a[d][h]);
				s+="</td>\n";
			}
			else{
				s+="<td width=\"20\" align=\"center\">&nbsp;</td>\n";
			}
		}
		s+="</tr>\n";
		if(r.mode==MORNINGS_AFTERNOONS && rh==r.nHoursPerDay-1) //By g.theodoroy.
			s+="</table>\n<table align=\"center\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\" style=\"margin-top:5;\">";
	}
	s+="</table>\n";
	
	return s;
}

static QString trueFalse(bool x){
	if(!x)
		return QString("false");
	else
		return QString("true");
}

static QString yesNoTranslated(bool x){
	if(!x)
		return QCoreApplication::translate("TimeConstraint", "no", "negative");
	else
		return QCoreApplication::translate("TimeConstraint", "yes", "affirmative");
}

//The following 2 matrices are kept to make the computation faster
//They are calculated only at the beginning of the computation of the fitness
//of the solution.
static Matrix3D<int> subgroupsMatrix;
static Matrix3D<int> teachersMatrix;

static int teachers_conflicts=-1;
static int subgroups_conflicts=-1;

extern Matrix2D<bool> breakDayHour;

extern Matrix3D<bool> teacherNotAvailableDayHour;

extern Matrix3D<bool> subgroupNotAvailableDayHour;

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

QString getActivityDescription(Rules& r, int id)
{
	QString s="";
	
	Activity* act=r.activitiesPointerHash.value(id, nullptr);
	if(act==nullptr){
		s+=translatedQuestionMark();
	}
	else{
		if(!act->active)
			s+="X-";
		s+=QString::number(id);
	}
	
	return s;
}

QString getActivityDetailedDescription(Rules& r, int id)
{
	QString s="";
	
	Activity* act=r.activitiesPointerHash.value(id, nullptr);
	if(act==nullptr){
		s+=QCoreApplication::translate("Activity", "Invalid (nonexistent) id for activity");
		return s;
	}

	/*if(act->activityTagsNames.count()>0){
		s+=QCoreApplication::translate("Activity", "T:%1, S:%2, AT:%3, St:%4", "This is an important translation for an activity's detailed description, please take care (it appears in many places in constraints)."
		 "The abbreviations are: Teachers, Subject, Activity tags, Students. This variant includes activity tags").arg(act->teachersNames.join(translatedComma())).arg(act->subjectName).arg(act->activityTagsNames.join(translatedComma())).arg(act->studentsNames.join(translatedComma()));
	}
	else{
		s+=QCoreApplication::translate("Activity", "T:%1, S:%2, St:%3", "This is an important translation for an activity's detailed description, please take care (it appears in many places in constraints)."
		 "The abbreviations are: Teachers, Subject, Students. There are no activity tags here").arg(act->teachersNames.join(translatedComma())).arg(act->subjectName).arg(act->studentsNames.join(translatedComma()));
	}
	return s;*/

	const int INDENT=4;

	bool _indent;
	if(act->isSplit() && act->id!=act->activityGroupId)
		_indent=true;
	else
		_indent=false;
		
	bool indentRepr;
	if(act->isSplit() && act->id==act->activityGroupId)
		indentRepr=true;
	else
		indentRepr=false;
		
	QString _teachers="";
	if(act->teachersNames.count()==0)
		_teachers=QCoreApplication::translate("Activity", "no teachers");
	else
		_teachers=act->teachersNames.join(translatedComma());

	QString _subject=act->subjectName;
	
	QString _activityTags=act->activityTagsNames.join(translatedComma());

	QString _students="";
	if(act->studentsNames.count()==0)
		_students=QCoreApplication::translate("Activity", "no students");
	else
		_students=act->studentsNames.join(translatedComma());

	/*QString _id;
	_id = CustomFETString::number(id);

	QString _agid="";
	if(act->isSplit())
		_agid = CustomFETString::number(act->activityGroupId);*/

	QString _duration=CustomFETString::number(act->duration);
	
	QString _totalDuration="";
	if(act->isSplit())
		_totalDuration = CustomFETString::number(act->totalDuration);

	QString _active;
	if(act->active==true)
		_active="";
	else
		_active="X";

	QString _nstudents="";
	if(act->computeNTotalStudents==false)
		_nstudents=CustomFETString::number(act->nTotalStudents);

	/////////
	//QString s="";
	if(_indent)
		s+=QString(INDENT, ' ');
		
	/*s+=_id;
	s+=" - ";*/

	if(_active!=""){
		s+=_active;
		s+=" - ";
	}
	
	s+=_duration;
	if(act->isSplit()){
		s+="/";
		s+=_totalDuration;
	}
	s+=" - ";
	
	if(indentRepr)
		s+=QString(INDENT, ' ');
	
	s+=_teachers;
	s+=" - ";
	s+=_subject;
	s+=" - ";
	if(_activityTags!=""){
		s+=_activityTags;
		s+=" - ";
	}
	s+=_students;

	if(_nstudents!=""){
		s+=" - ";
		s+=_nstudents;
	}
	
	if(!act->comments.isEmpty()){
		s+=" - ";
		s+=act->comments;
	}

	return s;
}

bool timeConstraintCanHaveAnyWeight(int type)
{
	assert(type!=CONSTRAINT_GENERIC_TIME);
	
	bool t;
	
	switch(type){
		case CONSTRAINT_TEACHERS_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_ENDS_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIME:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_SAME_STARTING_TIME:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_NOT_OVERLAPPING:
			[[fallthrough]];
		case CONSTRAINT_MIN_DAYS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_PREFERRED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_PREFERRED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIMES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_PREFERRED_STARTING_TIMES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_SAME_STARTING_HOUR:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_SAME_STARTING_DAY:
			[[fallthrough]];
		case CONSTRAINT_TWO_ACTIVITIES_CONSECUTIVE:
			[[fallthrough]];
		case CONSTRAINT_TWO_ACTIVITIES_ORDERED:
			[[fallthrough]];
		case CONSTRAINT_MIN_GAPS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_SUBACTIVITIES_PREFERRED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_SUBACTIVITIES_PREFERRED_STARTING_TIMES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_END_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_TWO_ACTIVITIES_GROUPED:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_THREE_ACTIVITIES_GROUPED:
			[[fallthrough]];
		case CONSTRAINT_MAX_DAYS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TWO_ACTIVITIES_ORDERED_IF_SAME_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_TAGS_NOT_OVERLAPPING:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_ENDS_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_END_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_HOURS_DAILY_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_HOURS_DAILY_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_HOURS_DAILY_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_MAX_GAPS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_TWO_SETS_OF_ACTIVITIES_ORDERED:
			[[fallthrough]];
		case CONSTRAINT_MIN_HALF_DAYS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_MAX_TERMS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_MAX_HALF_DAYS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_MAX_HOURLY_SPAN:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_OR_ENDS_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_OR_ENDS_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_TEACHERS_DAY:
			t=true;
			break;
		
		default:
			t=false;
			break;
	}

	return t;
}

void populateInternalSubgroupsList(const Rules& r, const StudentsSet* ss, QList<int>& iSubgroupsList){
	iSubgroupsList.clear();
	
	QSet<int> tmpSet;
	
	if(ss->type==STUDENTS_SUBGROUP){
		int tmp;
		tmp=((StudentsSubgroup*)ss)->indexInInternalSubgroupsList;
		assert(tmp>=0);
		assert(tmp<r.nInternalSubgroups);
		if(!tmpSet.contains(tmp)){
			tmpSet.insert(tmp);
			iSubgroupsList.append(tmp);
		}
	}
	else if(ss->type==STUDENTS_GROUP){
		StudentsGroup* stg=(StudentsGroup*)ss;
		for(int i=0; i<stg->subgroupsList.size(); i++){
			StudentsSubgroup* sts=stg->subgroupsList[i];
			int tmp;
			tmp=sts->indexInInternalSubgroupsList;
			assert(tmp>=0);
			assert(tmp<r.nInternalSubgroups);
			if(!tmpSet.contains(tmp)){
				tmpSet.insert(tmp);
				iSubgroupsList.append(tmp);
			}
		}
	}
	else if(ss->type==STUDENTS_YEAR){
		StudentsYear* sty=(StudentsYear*)ss;
		for(int i=0; i<sty->groupsList.size(); i++){
			StudentsGroup* stg=sty->groupsList[i];
			for(int j=0; j<stg->subgroupsList.size(); j++){
				StudentsSubgroup* sts=stg->subgroupsList[j];
				int tmp;
				tmp=sts->indexInInternalSubgroupsList;
				assert(tmp>=0);
				assert(tmp<r.nInternalSubgroups);
				if(!tmpSet.contains(tmp)){
					tmpSet.insert(tmp);
					iSubgroupsList.append(tmp);
				}
			}
		}
	}
	else
		assert(0);
}

TimeConstraint::TimeConstraint()
{
	type=CONSTRAINT_GENERIC_TIME;
	
	active=true;
	comments=QString("");
}

TimeConstraint::~TimeConstraint()
{
}

TimeConstraint::TimeConstraint(double wp)
{
	type=CONSTRAINT_GENERIC_TIME;

	weightPercentage=wp;
	assert(wp<=100 && wp>=0);

	active=true;
	comments=QString("");
}

bool TimeConstraint::canHaveAnyWeight()
{
	return timeConstraintCanHaveAnyWeight(type);
}

bool TimeConstraint::canBeUsedInOfficialMode()
{
	assert(type!=CONSTRAINT_GENERIC_TIME);
	
	bool t;
	
	switch(type){
		case CONSTRAINT_BASIC_COMPULSORY_TIME:
			[[fallthrough]];
		case CONSTRAINT_BREAK_TIMES:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_NOT_AVAILABLE_TIMES:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_GAPS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_GAPS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_GAPS_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_GAPS_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_NOT_AVAILABLE_TIMES:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_GAPS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_ENDS_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIME:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_SAME_STARTING_TIME:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_NOT_OVERLAPPING:
			[[fallthrough]];
		case CONSTRAINT_MIN_DAYS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_PREFERRED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_PREFERRED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIMES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_PREFERRED_STARTING_TIMES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_SAME_STARTING_HOUR:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_SAME_STARTING_DAY:
			[[fallthrough]];
		case CONSTRAINT_TWO_ACTIVITIES_CONSECUTIVE:
			[[fallthrough]];
		case CONSTRAINT_TWO_ACTIVITIES_ORDERED:
			[[fallthrough]];
		case CONSTRAINT_MIN_GAPS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_SUBACTIVITIES_PREFERRED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_SUBACTIVITIES_PREFERRED_STARTING_TIMES:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_END_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_TWO_ACTIVITIES_GROUPED:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_THREE_ACTIVITIES_GROUPED:
			[[fallthrough]];
		case CONSTRAINT_MAX_DAYS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_GAPS_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_MAX_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		//2017-02-06
		case CONSTRAINT_TEACHER_MAX_SPAN_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_SPAN_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_RESTING_HOURS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_RESTING_HOURS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_SPAN_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_SPAN_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MIN_RESTING_HOURS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_RESTING_HOURS:
			[[fallthrough]];
		//2018-06-13
		case CONSTRAINT_TWO_ACTIVITIES_ORDERED_IF_SAME_DAY:
			[[fallthrough]];
		//2019-06-08
		case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
			[[fallthrough]];
		//2021-12-15
		case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_TAGS_NOT_OVERLAPPING:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_OCCUPY_MIN_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_MIN_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_ACTIVITY_TAG_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_ENDS_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_END_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_TWO_SETS_OF_ACTIVITIES_ORDERED:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_PREFERRED_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_MAX_HOURLY_SPAN:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_HOURS_DAILY_IN_INTERVAL:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_HOURS_DAILY_IN_INTERVAL:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_HOURS_DAILY_IN_INTERVAL:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY_IN_INTERVAL:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_NO_TWO_CONSECUTIVE_DAYS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_NO_TWO_CONSECUTIVE_DAYS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_OCCUPIES_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_OCCUPIES_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_OVERLAP_COMPLETELY_OR_DO_NOT_OVERLAP:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_OR_ENDS_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_OR_ENDS_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_MAX_TOTAL_NUMBER_OF_STUDENTS_IN_SELECTED_TIME_SLOTS:
			t=true;
			break;
			
		default:
			t=false;
			break;
	}

	return t;
}

bool TimeConstraint::canBeUsedInMorningsAfternoonsMode()
{
	assert(type!=CONSTRAINT_GENERIC_TIME);
	
	bool t;
	
	switch(type){
		case CONSTRAINT_BASIC_COMPULSORY_TIME:
			[[fallthrough]];
		case CONSTRAINT_BREAK_TIMES:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_NOT_AVAILABLE_TIMES:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_GAPS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_GAPS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_GAPS_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_GAPS_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_NOT_AVAILABLE_TIMES:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_GAPS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_ENDS_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIME:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_SAME_STARTING_TIME:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_NOT_OVERLAPPING:
			[[fallthrough]];
		case CONSTRAINT_MIN_DAYS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_PREFERRED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_PREFERRED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIMES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_PREFERRED_STARTING_TIMES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_SAME_STARTING_HOUR:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_SAME_STARTING_DAY:
			[[fallthrough]];
		case CONSTRAINT_TWO_ACTIVITIES_CONSECUTIVE:
			[[fallthrough]];
		case CONSTRAINT_TWO_ACTIVITIES_ORDERED:
			[[fallthrough]];
		case CONSTRAINT_MIN_GAPS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_SUBACTIVITIES_PREFERRED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_SUBACTIVITIES_PREFERRED_STARTING_TIMES:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_END_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_TWO_ACTIVITIES_GROUPED:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_THREE_ACTIVITIES_GROUPED:
			[[fallthrough]];
		case CONSTRAINT_MAX_DAYS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_GAPS_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_MAX_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		//2017-02-06
		case CONSTRAINT_TEACHER_MAX_SPAN_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_SPAN_PER_DAY:
			[[fallthrough]];
		//2018-06-13
		case CONSTRAINT_TWO_ACTIVITIES_ORDERED_IF_SAME_DAY:
			[[fallthrough]];
		//2019-06-08
		case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
			[[fallthrough]];
		//2021-12-15
		case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_TAGS_NOT_OVERLAPPING:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_OCCUPY_MIN_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_MIN_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_ACTIVITY_TAG_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_ENDS_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_END_TEACHERS_DAY:
			[[fallthrough]];
		//mornings-afternoons
		case CONSTRAINT_TEACHERS_MAX_HOURS_DAILY_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_REAL_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_HOURS_DAILY_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_HOURS_DAILY_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_REAL_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_REAL_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_REAL_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_AFTERNOONS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_AFTERNOONS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_MORNINGS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_MORNINGS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_MORNINGS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_MORNINGS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_AFTERNOONS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_AFTERNOONS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_TWO_CONSECUTIVE_MORNINGS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_TWO_CONSECUTIVE_MORNINGS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_TWO_CONSECUTIVE_AFTERNOONS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_TWO_CONSECUTIVE_AFTERNOONS:
			[[fallthrough]];
		//Added in FET Algeria and Morocco on 2018-11-02
		case CONSTRAINT_TEACHERS_MAX_GAPS_PER_REAL_DAY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_GAPS_PER_REAL_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_GAPS_PER_REAL_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_REAL_DAY:
			[[fallthrough]];
		//2019-07-03
		case CONSTRAINT_TEACHERS_MIN_HOURS_DAILY_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_HOURS_DAILY_REAL_DAYS:
			[[fallthrough]];
		//2019-08-18 - for Said213
		case CONSTRAINT_TEACHERS_AFTERNOONS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_AFTERNOONS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_HOURS_PER_MORNING:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_HOURS_PER_MORNING:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_SPAN_PER_REAL_DAY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_SPAN_PER_REAL_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_SPAN_PER_REAL_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_SPAN_PER_REAL_DAY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MORNING_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MORNING_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_AFTERNOON_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_AFTERNOON_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_HOURS_PER_MORNING:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MIN_HOURS_PER_MORNING:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_ZERO_GAPS_PER_AFTERNOON:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_ZERO_GAPS_PER_AFTERNOON:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_AFTERNOONS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_AFTERNOONS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_MORNINGS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_MORNINGS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_MORNINGS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MIN_MORNINGS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_AFTERNOONS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MIN_AFTERNOONS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MORNING_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MORNING_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_AFTERNOON_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_AFTERNOON_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_HOURS_PER_ALL_AFTERNOONS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_HOURS_PER_ALL_AFTERNOONS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_HOURS_PER_ALL_AFTERNOONS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_HOURS_PER_ALL_AFTERNOONS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_RESTING_HOURS_BETWEEN_MORNING_AND_AFTERNOON:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_RESTING_HOURS_BETWEEN_MORNING_AND_AFTERNOON:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MIN_RESTING_HOURS_BETWEEN_MORNING_AND_AFTERNOON:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_RESTING_HOURS_BETWEEN_MORNING_AND_AFTERNOON:
			[[fallthrough]];
		//2020-07-24 - for lakhdar bezzit
		case CONSTRAINT_STUDENTS_SET_AFTERNOONS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_AFTERNOONS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
			[[fallthrough]];
		//Added in FET Algeria and Morocco on 2020-07-29
		case CONSTRAINT_TEACHERS_MAX_GAPS_PER_WEEK_FOR_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_GAPS_PER_WEEK_FOR_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_GAPS_PER_WEEK_FOR_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_WEEK_FOR_REAL_DAYS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_REAL_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_REAL_DAYS_PER_WEEK:
			[[fallthrough]];
		//2021-08-12
		case CONSTRAINT_TEACHERS_MAX_GAPS_PER_MORNING_AND_AFTERNOON:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_GAPS_PER_MORNING_AND_AFTERNOON:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MORNINGS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MORNINGS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MORNINGS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MORNINGS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
			[[fallthrough]];
		case CONSTRAINT_TWO_SETS_OF_ACTIVITIES_ORDERED:
			[[fallthrough]];
		//2021-09-26
		case CONSTRAINT_TEACHERS_MAX_THREE_CONSECUTIVE_DAYS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_THREE_CONSECUTIVE_DAYS:
			[[fallthrough]];
		//2022-02-15
		case CONSTRAINT_STUDENTS_MAX_THREE_CONSECUTIVE_DAYS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_THREE_CONSECUTIVE_DAYS:
			[[fallthrough]];
		case CONSTRAINT_MIN_HALF_DAYS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_PREFERRED_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_MAX_HALF_DAYS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_TEACHERS_DAY:
			[[fallthrough]];
 		case CONSTRAINT_TEACHERS_MIN_HOURS_PER_AFTERNOON:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_HOURS_PER_AFTERNOON:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_HOURS_PER_AFTERNOON:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MIN_HOURS_PER_AFTERNOON:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_MAX_HOURLY_SPAN:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_HOURS_DAILY_IN_INTERVAL:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_HOURS_DAILY_IN_INTERVAL:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_HOURS_DAILY_IN_INTERVAL:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY_IN_INTERVAL:
			[[fallthrough]];
		//2024-03-15
		case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
			[[fallthrough]];
		//2024-05-18
		case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_NO_TWO_CONSECUTIVE_DAYS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_NO_TWO_CONSECUTIVE_DAYS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_OCCUPIES_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_OCCUPIES_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_OVERLAP_COMPLETELY_OR_DO_NOT_OVERLAP:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_OR_ENDS_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_OR_ENDS_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_MAX_TOTAL_NUMBER_OF_STUDENTS_IN_SELECTED_TIME_SLOTS:
			t=true;
			break;
		
		default:
			t=false;
			break;
	}

	return t;
}

bool TimeConstraint::canBeUsedInBlockPlanningMode()
{
	assert(type!=CONSTRAINT_GENERIC_TIME);
	
	bool t;
	
	switch(type){
		case CONSTRAINT_BASIC_COMPULSORY_TIME:
			[[fallthrough]];
		case CONSTRAINT_BREAK_TIMES:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_NOT_AVAILABLE_TIMES:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_GAPS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_GAPS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_GAPS_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_GAPS_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_NOT_AVAILABLE_TIMES:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_GAPS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_ENDS_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIME:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_SAME_STARTING_TIME:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_NOT_OVERLAPPING:
			[[fallthrough]];
		case CONSTRAINT_MIN_DAYS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_PREFERRED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_PREFERRED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIMES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_PREFERRED_STARTING_TIMES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_SAME_STARTING_HOUR:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_SAME_STARTING_DAY:
			[[fallthrough]];
		case CONSTRAINT_TWO_ACTIVITIES_CONSECUTIVE:
			[[fallthrough]];
		case CONSTRAINT_TWO_ACTIVITIES_ORDERED:
			[[fallthrough]];
		case CONSTRAINT_MIN_GAPS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_SUBACTIVITIES_PREFERRED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_SUBACTIVITIES_PREFERRED_STARTING_TIMES:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_END_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_TWO_ACTIVITIES_GROUPED:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_THREE_ACTIVITIES_GROUPED:
			[[fallthrough]];
		case CONSTRAINT_MAX_DAYS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_GAPS_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_MAX_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		//2017-02-06
		case CONSTRAINT_TEACHER_MAX_SPAN_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_SPAN_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_RESTING_HOURS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_RESTING_HOURS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_SPAN_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_SPAN_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MIN_RESTING_HOURS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_RESTING_HOURS:
			[[fallthrough]];
		//2018-06-13
		case CONSTRAINT_TWO_ACTIVITIES_ORDERED_IF_SAME_DAY:
			[[fallthrough]];
		//2019-06-08
		case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
			[[fallthrough]];
		//2021-12-15
		case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_TAGS_NOT_OVERLAPPING:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_OCCUPY_MIN_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_MIN_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_ACTIVITY_TAG_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_ENDS_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_END_TEACHERS_DAY:
			[[fallthrough]];
		//block-planning
		case CONSTRAINT_MAX_TOTAL_ACTIVITIES_FROM_SET_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_MAX_GAPS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_TWO_SETS_OF_ACTIVITIES_ORDERED:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_PREFERRED_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_MAX_HOURLY_SPAN:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_HOURS_DAILY_IN_INTERVAL:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_HOURS_DAILY_IN_INTERVAL:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_HOURS_DAILY_IN_INTERVAL:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY_IN_INTERVAL:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_NO_TWO_CONSECUTIVE_DAYS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_NO_TWO_CONSECUTIVE_DAYS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TWO_SETS_OF_ACTIVITIES_SAME_SECTIONS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_OCCUPIES_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_OCCUPIES_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_OVERLAP_COMPLETELY_OR_DO_NOT_OVERLAP:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_OR_ENDS_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_OR_ENDS_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_MAX_TOTAL_NUMBER_OF_STUDENTS_IN_SELECTED_TIME_SLOTS:
			t=true;
			break;
		
		default:
			t=false;
			break;
	}

	return t;
}

bool TimeConstraint::canBeUsedInTermsMode()
{
	assert(type!=CONSTRAINT_GENERIC_TIME);
	
	bool t;
	
	switch(type){
		case CONSTRAINT_BASIC_COMPULSORY_TIME:
			[[fallthrough]];
		case CONSTRAINT_BREAK_TIMES:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_NOT_AVAILABLE_TIMES:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_GAPS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_GAPS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_GAPS_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_GAPS_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_NOT_AVAILABLE_TIMES:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_GAPS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_ENDS_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIME:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_SAME_STARTING_TIME:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_NOT_OVERLAPPING:
			[[fallthrough]];
		case CONSTRAINT_MIN_DAYS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_PREFERRED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_PREFERRED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIMES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_PREFERRED_STARTING_TIMES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_SAME_STARTING_HOUR:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_SAME_STARTING_DAY:
			[[fallthrough]];
		case CONSTRAINT_TWO_ACTIVITIES_CONSECUTIVE:
			[[fallthrough]];
		case CONSTRAINT_TWO_ACTIVITIES_ORDERED:
			[[fallthrough]];
		case CONSTRAINT_MIN_GAPS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_SUBACTIVITIES_PREFERRED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_SUBACTIVITIES_PREFERRED_STARTING_TIMES:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_INTERVAL_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_END_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_TWO_ACTIVITIES_GROUPED:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_THREE_ACTIVITIES_GROUPED:
			[[fallthrough]];
		case CONSTRAINT_MAX_DAYS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_GAPS_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_MAX_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_DAYS_PER_WEEK:
			[[fallthrough]];
		//2017-02-06
		case CONSTRAINT_TEACHER_MAX_SPAN_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_SPAN_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_RESTING_HOURS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_RESTING_HOURS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_SPAN_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_SPAN_PER_DAY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MIN_RESTING_HOURS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_RESTING_HOURS:
			[[fallthrough]];
		//2018-06-13
		case CONSTRAINT_TWO_ACTIVITIES_ORDERED_IF_SAME_DAY:
			[[fallthrough]];
		//2019-06-08
		case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
			[[fallthrough]];
		//2021-12-15
		case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_TAGS_NOT_OVERLAPPING:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_OCCUPY_MIN_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_MIN_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_ACTIVITY_TAG_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MIN_HOURS_DAILY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_ENDS_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_END_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_MAX_IN_A_TERM:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_TERMS:
			[[fallthrough]];
		case CONSTRAINT_TWO_SETS_OF_ACTIVITIES_ORDERED:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_PREFERRED_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_MIN_IN_A_TERM:
			[[fallthrough]];
		case CONSTRAINT_MAX_TERMS_BETWEEN_ACTIVITIES:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_MAX_HOURLY_SPAN:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_HOURS_DAILY_IN_INTERVAL:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_HOURS_DAILY_IN_INTERVAL:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_HOURS_DAILY_IN_INTERVAL:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY_IN_INTERVAL:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_NO_TWO_CONSECUTIVE_DAYS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_NO_TWO_CONSECUTIVE_DAYS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_MAX_HOURS_PER_TERM:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_MAX_HOURS_PER_TERM:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			[[fallthrough]];
		case CONSTRAINT_TEACHER_OCCUPIES_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_TEACHERS_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_SET_OCCUPIES_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_STUDENTS_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_OVERLAP_COMPLETELY_OR_DO_NOT_OVERLAP:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_OR_ENDS_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_STUDENTS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITY_BEGINS_OR_ENDS_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_TEACHERS_DAY:
			[[fallthrough]];
		case CONSTRAINT_ACTIVITIES_MAX_TOTAL_NUMBER_OF_STUDENTS_IN_SELECTED_TIME_SLOTS:
			t=true;
			break;
		
		default:
			t=false;
			break;
	}

	return t;
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

ConstraintBasicCompulsoryTime::ConstraintBasicCompulsoryTime(): TimeConstraint()
{
	this->type=CONSTRAINT_BASIC_COMPULSORY_TIME;
	this->weightPercentage=100;
}

ConstraintBasicCompulsoryTime::ConstraintBasicCompulsoryTime(double wp): TimeConstraint(wp)
{
	this->type=CONSTRAINT_BASIC_COMPULSORY_TIME;
}

bool ConstraintBasicCompulsoryTime::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);
	Q_UNUSED(r);
	
	return true;
}

bool ConstraintBasicCompulsoryTime::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintBasicCompulsoryTime::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s = IL2+"<ConstraintBasicCompulsoryTime>\n";
	assert(this->weightPercentage==100.0);
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintBasicCompulsoryTime>\n";
	return s;
}

QString ConstraintBasicCompulsoryTime::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	return begin+tr("Basic compulsory constraints (time)") + translatedCommaSpace() + tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage))+end;
}

QString ConstraintBasicCompulsoryTime::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("These are the basic compulsory constraints (referring to time allocation) for any timetable");
	s+="\n";

	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("The basic time constraints try to avoid:");s+="\n";
	s+=QString("- ");s+=tr("teachers assigned to more than one activity simultaneously");s+="\n";
	s+=QString("- ");s+=tr("students assigned to more than one activity simultaneously");s+="\n";
	
	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintBasicCompulsoryTime::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString){
	assert(r.internalStructureComputed);

	int teachersConflicts, subgroupsConflicts;
	
	assert(weightPercentage==100.0);

	//This constraint fitness calculation routine is called firstly,
	//so we can compute the teacher and subgroups conflicts faster this way.
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
	
		subgroups_conflicts = subgroupsConflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = teachersConflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	else{
		assert(subgroups_conflicts>=0);
		assert(teachers_conflicts>=0);
		subgroupsConflicts = subgroups_conflicts;
		teachersConflicts = teachers_conflicts;
	}

	int i,dd;

	qint64 unallocated; //unallocated activities
	int late; //late activities
	int nte; //number of teacher exhaustions
	int nse; //number of students exhaustions
	int ntma;

	//Part without logging..................................................................
	if(conflictsString==nullptr){
		//Unallocated or late activities
		unallocated=0;
		late=0;
		for(i=0; i<r.nInternalActivities; i++){
			if(c.times[i]==UNALLOCATED_TIME){
				//Firstly, we consider a big clash each unallocated activity.
				//Needs to be very a large constant, bigger than any other broken constraint.
				//Take care: MAX_ACTIVITIES*this_constant <= INT_MAX
				unallocated += /*r.internalActivitiesList[i].duration * r.internalActivitiesList[i].nSubgroups * */ 10000;
				//(an unallocated activity for a year is more important than an unallocated activity for a subgroup)
			}
			else{
				//Calculates the number of activities that are scheduled too late (in fact we
				//calculate a function that increases as the activity is getting late)
				int h=c.times[i]/r.nDaysPerWeek;
				dd=r.internalActivitiesList[i].duration;
				if(h+dd>r.nHoursPerDay){
					int tmp;
					tmp=1;
					late += (h+dd-r.nHoursPerDay) * tmp * r.internalActivitiesList[i].iSubgroupsList.count();
					//multiplied with the number
					//of subgroups implied, for seeing the importance of the
					//activity
				}
			}
		}
		
		assert(late==0);

		//Below, for teachers and students, please remember that 2 means a weekly activity
		//and 1 fortnightly one. So, if the matrix teachersMatrix[teacher][day][hour]==2, it is ok.

		//Calculates the number of teachers exhaustion (when he has to teach more than
		//one activity at the same time)
		/*nte=0;
		for(i=0; i<r.nInternalTeachers; i++)
			for(int j=0; j<r.nDaysPerWeek; j++)
				for(int k=0; k<r.nHoursPerDay; k++){
					int tmp=teachersMatrix[i][j][k]-2;
					if(tmp>0)
						nte+=tmp;
				}*/
		nte = teachersConflicts; //faster
		
		assert(nte==0);

		//Calculates the number of subgroups exhaustion (a subgroup cannot attend two
		//activities at the same time)
		/*nse=0;
		for(i=0; i<r.nInternalSubgroups; i++)
			for(int j=0; j<r.nDaysPerWeek; j++)
				for(int k=0; k<r.nHoursPerDay; k++){
					int tmp=subgroupsMatrix[i][j][k]-2;
					if(tmp>0)
						nse += tmp;
				}*/
		nse = subgroupsConflicts; //faster
		
		assert(nse==0);

		ntma=0;
		if(r.mode==MORNINGS_AFTERNOONS){
			Matrix1D<bool> tm;
			tm.resize(r.nDaysPerWeek);
			for(int t=0; t<r.nInternalTeachers; t++){
				Teacher* tch=r.internalTeachersList[t];
				for(int d=0; d<r.nDaysPerWeek; d++){
					tm[d]=false;
					for(int h=0; h<r.nHoursPerDay; h++)
						if(teachersMatrix[t][d][h]>0){
							tm[d]=true;
							break;
						}
				}
				int nExceptions=0;
				for(int d=0; d<r.nDaysPerWeek/2; d++)
					if(tm[2*d] && tm[2*d+1])
						nExceptions++;
				//int tmp=0;
				assert(tch->morningsAfternoonsBehavior!=TEACHER_MORNINGS_AFTERNOONS_BEHAVIOR_NOT_INITIALIZED);
				if(tch->morningsAfternoonsBehavior==TEACHER_MORNING_OR_EXCLUSIVELY_AFTERNOON && nExceptions>0){
					//tmp=nExceptions;
					ntma+=nExceptions;
				}
				else if(tch->morningsAfternoonsBehavior==TEACHER_ONE_DAY_EXCEPTION && nExceptions>1){
					//tmp=nExceptions-1;
					ntma+=nExceptions-1;
				}
				else if(tch->morningsAfternoonsBehavior==TEACHER_TWO_DAYS_EXCEPTION && nExceptions>2){
					//tmp=nExceptions-2;
					ntma+=nExceptions-2;
				}
				else if(tch->morningsAfternoonsBehavior==TEACHER_THREE_DAYS_EXCEPTION && nExceptions>3){
					//tmp=nExceptions-3;
					ntma+=nExceptions-3;
				}
				else if(tch->morningsAfternoonsBehavior==TEACHER_FOUR_DAYS_EXCEPTION && nExceptions>4){
					//tmp=nExceptions-4;
					ntma+=nExceptions-4;
				}
				else if(tch->morningsAfternoonsBehavior==TEACHER_FIVE_DAYS_EXCEPTION && nExceptions>5){
					//tmp=nExceptions-5;
					ntma+=nExceptions-5;
				}
				else{
					assert(0);
				}
			}
		}
		
		assert(ntma==0);
	}
	//part with logging....................................................................
	else{
		//Unallocated or late activities
		unallocated=0;
		late=0;
		for(i=0; i<r.nInternalActivities; i++){
			if(c.times[i]==UNALLOCATED_TIME){
				//Firstly, we consider a big clash each unallocated activity.
				//Needs to be very a large constant, bigger than any other broken constraint.
				//Take care: MAX_ACTIVITIES*this_constant <= INT_MAX
				unallocated += /*r.internalActivitiesList[i].duration * r.internalActivitiesList[i].nSubgroups * */ 10000;
				//(an unallocated activity for a year is more important than an unallocated activity for a subgroup)
				if(conflictsString!=nullptr){
					QString s= tr("Time constraint basic compulsory broken: unallocated activity with id=%1 (%2)",
						"%2 is the detailed description of activity - teachers, subject, students")
						.arg(r.internalActivitiesList[i].id).arg(getActivityDetailedDescription(r, r.internalActivitiesList[i].id));
					s+=" - ";
					s += tr("this increases the conflicts total by %1")
					 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100 * 10000));
					//s += "\n";
					
					dl.append(s);
					cl.append(weightPercentage/100 * 10000);

					(*conflictsString) += s + "\n";
				}
			}
			else{
				//Calculates the number of activities that are scheduled too late (in fact we
				//calculate a function that increases as the activity is getting late)
				int h=c.times[i]/r.nDaysPerWeek;
				dd=r.internalActivitiesList[i].duration;
				if(h+dd>r.nHoursPerDay){
					assert(0);
				
					int tmp;
					tmp=1;
					late += (h+dd-r.nHoursPerDay) * tmp * r.internalActivitiesList[i].iSubgroupsList.count();
					//multiplied with the number
					//of subgroups implied, for seeing the importance of the
					//activity

					if(conflictsString!=nullptr){
						QString s=tr("Time constraint basic compulsory");
						s+=": ";
						s+=tr("activity with id=%1 is late.")
						 .arg(r.internalActivitiesList[i].id);
						s+=" ";
						s+=tr("This increases the conflicts total by %1")
						 .arg(CustomFETString::numberPlusTwoDigitsPrecision((h+dd-r.nHoursPerDay)*tmp*r.internalActivitiesList[i].iSubgroupsList.count()*weightPercentage/100));
						s+="\n";
						
						dl.append(s);
						cl.append((h+dd-r.nHoursPerDay)*tmp*r.internalActivitiesList[i].iSubgroupsList.count()*weightPercentage/100);

						(*conflictsString) += s+"\n";
					}
				}
			}
		}

		//Below, for teachers and students, please remember that 2 means a weekly activity
		//and 1 fortnightly one. So, if the matrix teachersMatrix[teacher][day][hour]==2,
		//that is ok.

		//Calculates the number of teachers exhaustion (when he has to teach more than
		//one activity at the same time)
		nte=0;
		for(i=0; i<r.nInternalTeachers; i++)
			for(int j=0; j<r.nDaysPerWeek; j++)
				for(int k=0; k<r.nHoursPerDay; k++){
					int tmp=teachersMatrix[i][j][k]-1;
					if(tmp>0){
						if(conflictsString!=nullptr){
							QString s=tr("Time constraint basic compulsory");
							s+=": ";
							s+=tr("teacher with name %1 has more than one allocated activity on day %2, hour %3")
							 .arg(r.internalTeachersList[i]->name)
							 .arg(r.daysOfTheWeek[j])
							 .arg(r.hoursOfTheDay[k]);
							s+=". ";
							s+=tr("This increases the conflicts total by %1")
							 .arg(CustomFETString::numberPlusTwoDigitsPrecision(tmp*weightPercentage/100));
						
							(*conflictsString)+= s+"\n";
							
							dl.append(s);
							cl.append(tmp*weightPercentage/100);
						}
						nte+=tmp;
					}
				}

		assert(nte==0);
		
		//Calculates the number of subgroups exhaustion (a subgroup cannot attend two
		//activities at the same time)
		nse=0;
		for(i=0; i<r.nInternalSubgroups; i++)
			for(int j=0; j<r.nDaysPerWeek; j++)
				for(int k=0; k<r.nHoursPerDay; k++){
					int tmp=subgroupsMatrix[i][j][k]-1;
					if(tmp>0){
						if(conflictsString!=nullptr){
							QString s=tr("Time constraint basic compulsory");
							s+=": ";
							s+=tr("subgroup %1 has more than one allocated activity on day %2, hour %3")
							 .arg(r.internalSubgroupsList[i]->name)
							 .arg(r.daysOfTheWeek[j])
							 .arg(r.hoursOfTheDay[k]);
							s+=". ";
							s+=tr("This increases the conflicts total by %1")
							 .arg(CustomFETString::numberPlusTwoDigitsPrecision((subgroupsMatrix[i][j][k]-1)*weightPercentage/100));
							
							dl.append(s);
							cl.append((subgroupsMatrix[i][j][k]-1)*weightPercentage/100);
						
							*conflictsString += s+"\n";
						}
						nse += tmp;
					}
				}
		
		assert(nse==0);
		
		ntma=0;
		if(r.mode==MORNINGS_AFTERNOONS){
			Matrix1D<bool> tm;
			tm.resize(r.nDaysPerWeek);
			for(int t=0; t<r.nInternalTeachers; t++){
				Teacher* tch=r.internalTeachersList[t];
				for(int d=0; d<r.nDaysPerWeek; d++){
					tm[d]=false;
					for(int h=0; h<r.nHoursPerDay; h++)
						if(teachersMatrix[t][d][h]>0){
							tm[d]=true;
							break;
						}
				}
				int nExceptions=0;
				for(int d=0; d<r.nDaysPerWeek/2; d++)
					if(tm[2*d] && tm[2*d+1])
						nExceptions++;
				int tmp=0;
				assert(tch->morningsAfternoonsBehavior!=TEACHER_MORNINGS_AFTERNOONS_BEHAVIOR_NOT_INITIALIZED);
				if(tch->morningsAfternoonsBehavior==TEACHER_MORNING_OR_EXCLUSIVELY_AFTERNOON && nExceptions>0){
					tmp=nExceptions;
					ntma+=nExceptions;
				}
				else if(tch->morningsAfternoonsBehavior==TEACHER_ONE_DAY_EXCEPTION && nExceptions>1){
					tmp=nExceptions-1;
					ntma+=nExceptions-1;
				}
				else if(tch->morningsAfternoonsBehavior==TEACHER_TWO_DAYS_EXCEPTION && nExceptions>2){
					tmp=nExceptions-2;
					ntma+=nExceptions-2;
				}
				else if(tch->morningsAfternoonsBehavior==TEACHER_THREE_DAYS_EXCEPTION && nExceptions>3){
					tmp=nExceptions-3;
					ntma+=nExceptions-3;
				}
				else if(tch->morningsAfternoonsBehavior==TEACHER_FOUR_DAYS_EXCEPTION && nExceptions>4){
					tmp=nExceptions-4;
					ntma+=nExceptions-4;
				}
				else if(tch->morningsAfternoonsBehavior==TEACHER_FIVE_DAYS_EXCEPTION && nExceptions>5){
					tmp=nExceptions-5;
					ntma+=nExceptions-5;
				}
				
				if(tmp>0 && conflictsString!=nullptr){
					QString s=tr("Time constraint basic compulsory");
					s+=": ";
					s+=tr("the teacher with name %1 does not respect mornings-afternoons behavior")
					 .arg(r.internalTeachersList[t]->name);
					s+=". ";
					s+=tr("This increases the conflicts total by %1")
					 .arg(CustomFETString::numberPlusTwoDigitsPrecision(tmp*weightPercentage/100));
				
					(*conflictsString)+= s+"\n";
					
					dl.append(s);
					cl.append(tmp*weightPercentage/100);
				}
			}
		}

		assert(ntma==0);
	}

	/*if(nte!=teachersConflicts){
		cout<<"nte=="<<nte<<", teachersConflicts=="<<teachersConflicts<<endl;
		cout<<c.getTeachersMatrix(r, teachersMatrix)<<endl;
	}
	if(nse!=subgroupsConflicts){
		cout<<"nse=="<<nse<<", subgroupsConflicts=="<<subgroupsConflicts<<endl;
		cout<<c.getSubgroupsMatrix(r, subgroupsMatrix)<<endl;
	}*/
	
	/*assert(nte==teachersConflicts); //just a check, works only on logged fitness calculation
	assert(nse==subgroupsConflicts);*/

	return weightPercentage/100 * (unallocated + qint64(late) + qint64(nte) + qint64(nse) + qint64(ntma)); //conflicts factor
}

bool ConstraintBasicCompulsoryTime::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(aid);
	Q_UNUSED(r);

	return false;
}

bool ConstraintBasicCompulsoryTime::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintBasicCompulsoryTime::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintBasicCompulsoryTime::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintBasicCompulsoryTime::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintBasicCompulsoryTime::categoryOfTimeConstraint()
{
	return IS_BASIC_TIME_CONSTRAINT;
}

bool ConstraintBasicCompulsoryTime::hasWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

bool ConstraintBasicCompulsoryTime::canRepairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0);
	
	return true;
}

bool ConstraintBasicCompulsoryTime::repairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0); //should check hasWrongDayOrHour, firstly

	return true;
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeacherNotAvailableTimes::ConstraintTeacherNotAvailableTimes()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHER_NOT_AVAILABLE_TIMES;
}

ConstraintTeacherNotAvailableTimes::ConstraintTeacherNotAvailableTimes(double wp, const QString& tn, const QList<int>& d, const QList<int>& h)
	: TimeConstraint(wp)
{
	this->teacher=tn;
	assert(d.count()==h.count());
	this->days=d;
	this->hours=h;
	this->type=CONSTRAINT_TEACHER_NOT_AVAILABLE_TIMES;
}

QString ConstraintTeacherNotAvailableTimes::getXmlDescription(Rules& r)
{
	QString s=IL2+"<ConstraintTeacherNotAvailableTimes>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Teacher>"+protect(this->teacher)+"</Teacher>\n";

	s+=IL3+"<Number_of_Not_Available_Times>"+QString::number(this->days.count())+"</Number_of_Not_Available_Times>\n";
	assert(days.count()==hours.count());
	for(int i=0; i<days.count(); i++){
		s+=IL3+"<Not_Available_Time>\n";
		if(this->days.at(i)>=0)
			s+=IL4+"<Day>"+protect(r.daysOfTheWeek[this->days.at(i)])+"</Day>\n";
		if(this->hours.at(i)>=0)
			s+=IL4+"<Hour>"+protect(r.hoursOfTheDay[this->hours.at(i)])+"</Hour>\n";
		s+=IL3+"</Not_Available_Time>\n";
	}

	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeacherNotAvailableTimes>\n";
	return s;
}

QString ConstraintTeacherNotAvailableTimes::getDescription(Rules& r)
{
	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s=tr("Teacher not available");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("T:%1", "Teacher").arg(this->teacher);s+=translatedCommaSpace();

	s+=tr("NA at:", "Not available at");
	s+=" ";
	assert(days.count()==hours.count());
	for(int i=0; i<days.count(); i++){
		if(this->days.at(i)>=0){
			s+=r.daysOfTheWeek[this->days.at(i)];
			s+=" ";
		}
		if(this->hours.at(i)>=0){
			s+=r.hoursOfTheDay[this->hours.at(i)];
		}
		if(i<days.count()-1)
			s+=translatedSemicolonSpace();
	}

	return begin+s+end;
}

QString ConstraintTeacherNotAvailableTimes::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	if(!richText){
		QString s=tr("Time constraint");s+="\n";
		s+=tr("A teacher is not available");s+="\n";
		s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
		s+=tr("Teacher=%1").arg(this->teacher);s+="\n";

		s+=tr("Not available at:", "It refers to a teacher");
		s+="\n";
		assert(days.count()==hours.count());
		for(int i=0; i<days.count(); i++){
			if(this->days.at(i)>=0){
				s+=r.daysOfTheWeek[this->days.at(i)];
				s+=" ";
			}
			if(this->hours.at(i)>=0){
				s+=r.hoursOfTheDay[this->hours.at(i)];
			}
			if(i<days.count()-1)
				s+=translatedSemicolonSpace();
		}
		s+="\n";

		if(!active){
			s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			s+="\n";
		}
		if(!comments.isEmpty()){
			s+=tr("Comments=%1").arg(comments);
			s+="\n";
		}

		return s;
	}
	else{
		QString begin=tr("Time constraint");begin+="\n";
		begin+=tr("A teacher is not available");begin+="\n";
		begin+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));begin+="\n";
		begin+=tr("Teacher=%1").arg(this->teacher);begin+="\n";

		begin+=tr("Not available at:", "It refers to a teacher");
		begin+="\n";
		//the first Boolean is 'direct', the second Boolean is 'not available/selected', the third Boolean is 'color'.
		QString middle=listsOfDaysAndHoursToTable(r, days, hours, true, true, colors);
		QString end;
		end+="\n";

		if(!active){
			end+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			end+="\n";
		}
		if(!comments.isEmpty()){
			end+=tr("Comments=%1").arg(comments);
			end+="\n";
		}
		
		return protect4(begin)+middle+protect4(end);
	}
}

bool ConstraintTeacherNotAvailableTimes::computeInternalStructure(QWidget* parent, Rules& r){
	//this->teacher_ID=r.searchTeacher(this->teacher);
	teacher_ID=r.teachersHash.value(teacher, -1);

	if(this->teacher_ID<0){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint teacher not available times is wrong because it refers to nonexistent teacher."
		 " Please correct it (removing it might be a solution). Please report potential bug. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
		return false;
	}

	assert(days.count()==hours.count());
	for(int k=0; k<days.count(); k++){
		if(this->days.at(k) >= r.nDaysPerWeek){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint teacher not available times is wrong because it refers to removed day. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->hours.at(k) >= r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint teacher not available times is wrong because an hour is too late (after the last acceptable slot). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
	}

	assert(this->teacher_ID>=0);
	return true;
}

bool ConstraintTeacherNotAvailableTimes::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

double ConstraintTeacherNotAvailableTimes::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;

		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	//Calculates the number of hours when the teacher is supposed to be teaching, but he is not available
	//This function consideres all the hours, I mean if there are for example 5 weekly courses
	//scheduled on that hour (which is already a broken compulsory restriction - we only
	//are allowed 1 weekly course for a certain teacher at a certain hour) we calculate
	//5 broken restrictions for that function.
	//TODO: decide if it is better to consider only 2 or 10 as a return value in this particular case
	//(currently it is 10)
	int tch=this->teacher_ID;

	int nbroken;

	nbroken=0;

	assert(days.count()==hours.count());
	for(int k=0; k<days.count(); k++){
		int d=days.at(k);
		int h=hours.at(k);
		
		if(teachersMatrix[tch][d][h]>0){
			nbroken+=teachersMatrix[tch][d][h];
	
			if(conflictsString!=nullptr){
				QString s= tr("Time constraint teacher not available");
				s += " ";
				s += tr("broken for teacher: %1 on day %2, hour %3")
				 .arg(r.internalTeachersList[tch]->name)
				 .arg(r.daysOfTheWeek[d])
				 .arg(r.hoursOfTheDay[h]);
				s += ". ";
				s += tr("This increases the conflicts total by %1")
				 .arg(CustomFETString::numberPlusTwoDigitsPrecision(teachersMatrix[tch][d][h]*weightPercentage/100));
				
				dl.append(s);
				cl.append(teachersMatrix[tch][d][h]*weightPercentage/100);
			
				*conflictsString += s+"\n";
			}
		}
	}

	if(weightPercentage==100.0)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintTeacherNotAvailableTimes::isRelatedToActivity(Rules& r, int aid)
{
	Activity* a=r.activitiesPointerHash.value(aid, nullptr);
	assert(a!=nullptr);
	
	return a->teachersNames.contains(this->teacher);
}

bool ConstraintTeacherNotAvailableTimes::isRelatedToTeacher(const QString& t)
{
	if(this->teacher==t)
		return true;
	return false;
}

bool ConstraintTeacherNotAvailableTimes::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherNotAvailableTimes::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherNotAvailableTimes::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeacherNotAvailableTimes::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeacherNotAvailableTimes::hasWrongDayOrHour(Rules& r)
{
	assert(days.count()==hours.count());
	
	for(int i=0; i<days.count(); i++)
		if(days.at(i)<0 || days.at(i)>=r.nDaysPerWeek
		 || hours.at(i)<0 || hours.at(i)>=r.nHoursPerDay)
			return true;

	return false;
}

bool ConstraintTeacherNotAvailableTimes::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeacherNotAvailableTimes::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	assert(days.count()==hours.count());
	
	QList<int> newDays;
	QList<int> newHours;
	
	for(int i=0; i<days.count(); i++)
		if(days.at(i)>=0 && days.at(i)<r.nDaysPerWeek
		 && hours.at(i)>=0 && hours.at(i)<r.nHoursPerDay){
			newDays.append(days.at(i));
			newHours.append(hours.at(i));
		}
	
	days=newDays;
	hours=newHours;
	
	r.internalStructureComputed=false;
	setRulesModifiedAndOtherThings(&r);

	return true;
}

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsSetNotAvailableTimes::ConstraintStudentsSetNotAvailableTimes()
	: TimeConstraint()
{
	this->type=CONSTRAINT_STUDENTS_SET_NOT_AVAILABLE_TIMES;
}

ConstraintStudentsSetNotAvailableTimes::ConstraintStudentsSetNotAvailableTimes(double wp, const QString& sn, const QList<int>& d, const QList<int>& h)
	 : TimeConstraint(wp){
	this->students = sn;
	assert(d.count()==h.count());
	this->days=d;
	this->hours=h;
	this->type=CONSTRAINT_STUDENTS_SET_NOT_AVAILABLE_TIMES;
}

bool ConstraintStudentsSetNotAvailableTimes::computeInternalStructure(QWidget* parent, Rules& r){
	//StudentsSet* ss=r.searchAugmentedStudentsSet(this->students);
	StudentsSet* ss=r.studentsHash.value(students, nullptr);
	
	if(ss==nullptr){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students set not available is wrong because it refers to nonexistent students set."
		 " Please correct it (removing it might be a solution). Please report potential bug. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
		return false;
	}
	
	assert(days.count()==hours.count());
	for(int k=0; k<days.count(); k++){
		if(this->days.at(k) >= r.nDaysPerWeek){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint students set not available times is wrong because it refers to removed day. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->hours.at(k) >= r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint students set not available times is wrong because an hour is too late (after the last acceptable slot). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
	}
	
	assert(ss!=nullptr);

	populateInternalSubgroupsList(r, ss, this->iSubgroupsList);
	/*this->iSubgroupsList.clear();
	if(ss->type==STUDENTS_SUBGROUP){
		int tmp;
		tmp=((StudentsSubgroup*)ss)->indexInInternalSubgroupsList;
		assert(tmp>=0);
		assert(tmp<r.nInternalSubgroups);
		if(!this->iSubgroupsList.contains(tmp))
			this->iSubgroupsList.append(tmp);
	}
	else if(ss->type==STUDENTS_GROUP){
		StudentsGroup* stg=(StudentsGroup*)ss;
		for(int i=0; i<stg->subgroupsList.size(); i++){
			StudentsSubgroup* sts=stg->subgroupsList[i];
			int tmp;
			tmp=sts->indexInInternalSubgroupsList;
			assert(tmp>=0);
			assert(tmp<r.nInternalSubgroups);
			if(!this->iSubgroupsList.contains(tmp))
				this->iSubgroupsList.append(tmp);
		}
	}
	else if(ss->type==STUDENTS_YEAR){
		StudentsYear* sty=(StudentsYear*)ss;
		for(int i=0; i<sty->groupsList.size(); i++){
			StudentsGroup* stg=sty->groupsList[i];
			for(int j=0; j<stg->subgroupsList.size(); j++){
				StudentsSubgroup* sts=stg->subgroupsList[j];
				int tmp;
				tmp=sts->indexInInternalSubgroupsList;
				assert(tmp>=0);
				assert(tmp<r.nInternalSubgroups);
				if(!this->iSubgroupsList.contains(tmp))
					this->iSubgroupsList.append(tmp);
			}
		}
	}
	else
		assert(0);*/
	return true;
}

bool ConstraintStudentsSetNotAvailableTimes::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsSetNotAvailableTimes::getXmlDescription(Rules& r)
{
	QString s=IL2+"<ConstraintStudentsSetNotAvailableTimes>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Students>"+protect(this->students)+"</Students>\n";

	s+=IL3+"<Number_of_Not_Available_Times>"+QString::number(this->days.count())+"</Number_of_Not_Available_Times>\n";
	assert(days.count()==hours.count());
	for(int i=0; i<days.count(); i++){
		s+=IL3+"<Not_Available_Time>\n";
		if(this->days.at(i)>=0)
			s+=IL4+"<Day>"+protect(r.daysOfTheWeek[this->days.at(i)])+"</Day>\n";
		if(this->hours.at(i)>=0)
			s+=IL4+"<Hour>"+protect(r.hoursOfTheDay[this->hours.at(i)])+"</Hour>\n";
		s+=IL3+"</Not_Available_Time>\n";
	}

	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsSetNotAvailableTimes>\n";
	return s;
}

QString ConstraintStudentsSetNotAvailableTimes::getDescription(Rules& r)
{
	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s=tr("Students set not available");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("St:%1", "Students").arg(this->students);s+=translatedCommaSpace();

	s+=tr("NA at:", "Not available at");
	s+=" ";
	assert(days.count()==hours.count());
	for(int i=0; i<days.count(); i++){
		if(this->days.at(i)>=0){
			s+=r.daysOfTheWeek[this->days.at(i)];
			s+=" ";
		}
		if(this->hours.at(i)>=0){
			s+=r.hoursOfTheDay[this->hours.at(i)];
		}
		if(i<days.count()-1)
			s+=translatedSemicolonSpace();
	}

	return begin+s+end;
}

QString ConstraintStudentsSetNotAvailableTimes::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	if(!richText){
		QString s=tr("Time constraint");s+="\n";
		s+=tr("A students set is not available");s+="\n";
		s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";

		s+=tr("Students=%1").arg(this->students);s+="\n";

		s+=tr("Not available at:", "It refers to a students set");s+="\n";
	
		assert(days.count()==hours.count());
		for(int i=0; i<days.count(); i++){
			if(this->days.at(i)>=0){
				s+=r.daysOfTheWeek[this->days.at(i)];
				s+=" ";
			}
			if(this->hours.at(i)>=0){
				s+=r.hoursOfTheDay[this->hours.at(i)];
			}
			if(i<days.count()-1)
				s+=translatedSemicolonSpace();
		}
		s+="\n";

		if(!active){
			s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			s+="\n";
		}
		if(!comments.isEmpty()){
			s+=tr("Comments=%1").arg(comments);
			s+="\n";
		}

		return s;
	}
	else{
		QString begin=tr("Time constraint");begin+="\n";
		begin+=tr("A students set is not available");begin+="\n";
		begin+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));begin+="\n";

		begin+=tr("Students=%1").arg(this->students);begin+="\n";

		begin+=tr("Not available at:", "It refers to a students set");begin+="\n";
		
		//the first Boolean is 'direct', the second Boolean is 'not available/selected', the third Boolean is 'color'.
		QString middle=listsOfDaysAndHoursToTable(r, days, hours, true, true, colors);
		QString end;
		end+="\n";

		if(!active){
			end+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			end+="\n";
		}
		if(!comments.isEmpty()){
			end+=tr("Comments=%1").arg(comments);
			end+="\n";
		}

		return protect4(begin)+middle+protect4(end);
	}
}

double ConstraintStudentsSetNotAvailableTimes::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	nbroken=0;
	for(int m=0; m<this->iSubgroupsList.count(); m++){
		int sbg=this->iSubgroupsList.at(m);
		
		assert(days.count()==hours.count());
		for(int k=0; k<days.count(); k++){
			int d=days.at(k);
			int h=hours.at(k);
			
			if(subgroupsMatrix[sbg][d][h]>0){
				nbroken+=subgroupsMatrix[sbg][d][h];

				if(conflictsString!=nullptr){
					QString s= tr("Time constraint students set not available");
					s += " ";
					s += tr("broken for subgroup: %1 on day %2, hour %3")
					 .arg(r.internalSubgroupsList[sbg]->name)
					 .arg(r.daysOfTheWeek[d])
					 .arg(r.hoursOfTheDay[h]);
					s += ". ";
					s += tr("This increases the conflicts total by %1")
					 .arg(CustomFETString::numberPlusTwoDigitsPrecision(subgroupsMatrix[sbg][d][h]*weightPercentage/100));
					
					dl.append(s);
					cl.append(subgroupsMatrix[sbg][d][h]*weightPercentage/100);
				
					*conflictsString += s+"\n";
				}
			}
		}
	}

	if(weightPercentage==100.0)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintStudentsSetNotAvailableTimes::isRelatedToActivity(Rules& r, int aid)
{
	Activity* a=r.activitiesPointerHash.value(aid, nullptr);
	assert(a!=nullptr);

	for(const QString& st : std::as_const(a->studentsNames))
		if(r.setsShareStudents(st, this->students))
			return true;

	return false;
}

bool ConstraintStudentsSetNotAvailableTimes::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsSetNotAvailableTimes::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetNotAvailableTimes::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetNotAvailableTimes::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	return r.setsShareStudents(this->students, s);
}

int ConstraintStudentsSetNotAvailableTimes::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsSetNotAvailableTimes::hasWrongDayOrHour(Rules& r)
{
	assert(days.count()==hours.count());
	
	for(int i=0; i<days.count(); i++)
		if(days.at(i)<0 || days.at(i)>=r.nDaysPerWeek
		 || hours.at(i)<0 || hours.at(i)>=r.nHoursPerDay)
			return true;

	return false;
}

bool ConstraintStudentsSetNotAvailableTimes::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsSetNotAvailableTimes::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	assert(days.count()==hours.count());
	
	QList<int> newDays;
	QList<int> newHours;
	
	for(int i=0; i<days.count(); i++)
		if(days.at(i)>=0 && days.at(i)<r.nDaysPerWeek
		 && hours.at(i)>=0 && hours.at(i)<r.nHoursPerDay){
			newDays.append(days.at(i));
			newHours.append(hours.at(i));
		}
	
	days=newDays;
	hours=newHours;
	
	r.internalStructureComputed=false;
	setRulesModifiedAndOtherThings(&r);

	return true;
}

/////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivitiesSameStartingTime::ConstraintActivitiesSameStartingTime()
	: TimeConstraint()
{
	type=CONSTRAINT_ACTIVITIES_SAME_STARTING_TIME;
}

ConstraintActivitiesSameStartingTime::ConstraintActivitiesSameStartingTime(double wp, int nact, const QList<int>& act)
 : TimeConstraint(wp)
 {
	assert(nact>=2);
	assert(act.count()==nact);
	this->n_activities=nact;
	this->activitiesIds.clear();
	for(int i=0; i<nact; i++)
		this->activitiesIds.append(act.at(i));

	this->type=CONSTRAINT_ACTIVITIES_SAME_STARTING_TIME;
}

bool ConstraintActivitiesSameStartingTime::computeInternalStructure(QWidget* parent, Rules& r)
{
	//compute the indices of the activities,
	//based on their unique ID

	assert(this->n_activities==this->activitiesIds.count());

	this->_activities.clear();
	for(int i=0; i<this->n_activities; i++){
		int j=r.activitiesHash.value(activitiesIds.at(i), -1);
		//assert(j>=0);
		if(j>=0)
			_activities.append(j);
		/*int j;
		Activity* act;
		for(j=0; j<r.nInternalActivities; j++){
			act=&r.internalActivitiesList[j];
			if(act->id==this->activitiesIds[i]){
				this->_activities.append(j);
				break;
			}
		}*/
	}
	this->_n_activities=this->_activities.count();
	
	if(this->_n_activities<=1){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (because you need 2 or more activities). Please correct it:\n%1").arg(this->getDetailedDescription(r)));
		//assert(0);
		return false;
	}

	return true;
}

void ConstraintActivitiesSameStartingTime::removeUseless(Rules& r)
{
	//remove the activitiesIds which no longer exist (used after the deletion of an activity)
	
	assert(this->n_activities==this->activitiesIds.count());

	QList<int> tmpList;

	for(int i=0; i<this->n_activities; i++){
		Activity* act=r.activitiesPointerHash.value(activitiesIds[i], nullptr);
		if(act!=nullptr)
			tmpList.append(act->id);
		/*for(int k=0; k<r.activitiesList.size(); k++){
			Activity* act=r.activitiesList[k];
			if(act->id==this->activitiesIds[i]){
				tmpList.append(act->id);
				break;
			}
		}*/
	}
	
	this->activitiesIds=tmpList;
	this->n_activities=this->activitiesIds.count();

	r.internalStructureComputed=false;
}

void ConstraintActivitiesSameStartingTime::recomputeActivitiesSet()
{
	activitiesIdsSet=QSet<int>(activitiesIds.constBegin(), activitiesIds.constEnd());
}

bool ConstraintActivitiesSameStartingTime::hasInactiveActivities(Rules& r)
{
	int count=0;

	for(int i=0; i<this->n_activities; i++)
		if(r.inactiveActivities.contains(this->activitiesIds[i]))
			count++;

	if(this->n_activities-count<=1)
		return true;
	else
		return false;
}

QString ConstraintActivitiesSameStartingTime::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintActivitiesSameStartingTime>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Number_of_Activities>"+CustomFETString::number(this->n_activities)+"</Number_of_Activities>\n";
	for(int i=0; i<this->n_activities; i++)
		s+=IL3+"<Activity_Id>"+CustomFETString::number(this->activitiesIds[i])+"</Activity_Id>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivitiesSameStartingTime>\n";
	return s;
}

QString ConstraintActivitiesSameStartingTime::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);

	QString s;
	s+=tr("Activities same starting time");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("NA:%1", "Number of activities").arg(this->n_activities);s+=translatedCommaSpace();
	for(int i=0; i<this->n_activities; i++){
		s+=tr("Id:%1", "Id of activity").arg(getActivityDescription(r, this->activitiesIds[i]));
		if(i<this->n_activities-1)
			s+=translatedCommaSpace();
	}

	return begin+s+end;
}

QString ConstraintActivitiesSameStartingTime::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(colors);

	QString s;

	s=tr("Time constraint");s+="\n";
	s+=tr("Activities must have the same starting time");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Number of activities=%1").arg(this->n_activities);s+="\n";
	for(int i=0; i<this->n_activities; i++){
		s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity").arg(this->activitiesIds[i]).arg(getActivityDetailedDescription(r, this->activitiesIds[i]));
		s+="\n";
	}

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintActivitiesSameStartingTime::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	assert(r.internalStructureComputed);

	int nbroken;

	//We do not use the matrices 'subgroupsMatrix' nor 'teachersMatrix'.

	//sum the differences in the scheduled time for all pairs of activities.

	//without logging
	if(conflictsString==nullptr){
		nbroken=0;
		for(int i=1; i<this->_n_activities; i++){
			int t1=c.times[this->_activities[i]];
			if(t1!=UNALLOCATED_TIME){
				int day1=t1%r.nDaysPerWeek;
				int hour1=t1/r.nDaysPerWeek;
				for(int j=0; j<i; j++){
					int t2=c.times[this->_activities[j]];
					if(t2!=UNALLOCATED_TIME){
						int day2=t2%r.nDaysPerWeek;
						int hour2=t2/r.nDaysPerWeek;
						int tmp=0;

						tmp = abs(day1-day2) + abs(hour1-hour2);
							
						if(tmp>0)
							tmp=1;

						nbroken+=tmp;
					}
				}
			}
		}
	}
	//with logging
	else{
		nbroken=0;
		for(int i=1; i<this->_n_activities; i++){
			int t1=c.times[this->_activities[i]];
			if(t1!=UNALLOCATED_TIME){
				int day1=t1%r.nDaysPerWeek;
				int hour1=t1/r.nDaysPerWeek;
				for(int j=0; j<i; j++){
					int t2=c.times[this->_activities[j]];
					if(t2!=UNALLOCATED_TIME){
						int day2=t2%r.nDaysPerWeek;
						int hour2=t2/r.nDaysPerWeek;
						int tmp=0;

						tmp = abs(day1-day2) + abs(hour1-hour2);
							
						if(tmp>0)
							tmp=1;

						nbroken+=tmp;

						if(tmp>0 && conflictsString!=nullptr){
							QString s=tr("Time constraint activities same starting time broken, because activity with id=%1 (%2) is not at the same starting time with activity with id=%3 (%4)",
							"%1 is the id, %2 is the detailed description of the activity, %3 id, %4 det. descr.")
							 .arg(r.internalActivitiesList[this->_activities[i]].id)
							 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[this->_activities[i]].id))
							 .arg(r.internalActivitiesList[this->_activities[j]].id)
							 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[this->_activities[j]].id));
							s+=". ";
							s+=tr("Conflicts factor increase=%1").arg(CustomFETString::numberPlusTwoDigitsPrecision(tmp*weightPercentage/100));
							
							dl.append(s);
							cl.append(tmp*weightPercentage/100);
							
							*conflictsString+= s+"\n";
						}
					}
				}
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintActivitiesSameStartingTime::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	
	return activitiesIdsSet.contains(aid);
	
	/*for(int i=0; i<this->n_activities; i++)
		if(this->activitiesIds[i]==a->id)
			return true;
	return false;*/
}

bool ConstraintActivitiesSameStartingTime::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivitiesSameStartingTime::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesSameStartingTime::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesSameStartingTime::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintActivitiesSameStartingTime::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivitiesSameStartingTime::hasWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

bool ConstraintActivitiesSameStartingTime::canRepairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0);
	
	return true;
}

bool ConstraintActivitiesSameStartingTime::repairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0); //should check hasWrongDayOrHour, firstly

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivitiesNotOverlapping::ConstraintActivitiesNotOverlapping()
	: TimeConstraint()
{
	type=CONSTRAINT_ACTIVITIES_NOT_OVERLAPPING;
}

ConstraintActivitiesNotOverlapping::ConstraintActivitiesNotOverlapping(double wp, int nact, const QList<int>& act)
 : TimeConstraint(wp)
 {
  	assert(nact>=2);
  	assert(act.count()==nact);
	this->n_activities=nact;
	this->activitiesIds.clear();
	for(int i=0; i<nact; i++)
		this->activitiesIds.append(act.at(i));

	this->type=CONSTRAINT_ACTIVITIES_NOT_OVERLAPPING;
}

bool ConstraintActivitiesNotOverlapping::computeInternalStructure(QWidget* parent, Rules& r)
{
	//compute the indices of the activities,
	//based on their unique ID

	assert(this->n_activities==this->activitiesIds.count());

	this->_activities.clear();
	for(int i=0; i<this->n_activities; i++){
		int j=r.activitiesHash.value(activitiesIds.at(i), -1);
		//assert(j>=0);
		if(j>=0)
			_activities.append(j);
		/*int j;
		Activity* act;
		for(j=0; j<r.nInternalActivities; j++){
			act=&r.internalActivitiesList[j];
			if(act->id==this->activitiesIds[i]){
				this->_activities.append(j);
				break;
			}
		}*/
	}
	this->_n_activities=this->_activities.count();
	
	if(this->_n_activities<=1){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (because you need 2 or more activities). Please correct it:\n%1").arg(this->getDetailedDescription(r)));
		//assert(0);
		return false;
	}

	return true;
}

void ConstraintActivitiesNotOverlapping::removeUseless(Rules& r)
{
	//remove the activitiesIds which no longer exist (used after the deletion of an activity)
	
	assert(this->n_activities==this->activitiesIds.count());

	QList<int> tmpList;

	for(int i=0; i<this->n_activities; i++){
		Activity* act=r.activitiesPointerHash.value(activitiesIds[i], nullptr);
		if(act!=nullptr)
			tmpList.append(act->id);
		/*for(int k=0; k<r.activitiesList.size(); k++){
			Activity* act=r.activitiesList[k];
			if(act->id==this->activitiesIds[i]){
				tmpList.append(act->id);
				break;
			}
		}*/
	}
	
	this->activitiesIds=tmpList;
	this->n_activities=this->activitiesIds.count();

	r.internalStructureComputed=false;
}

void ConstraintActivitiesNotOverlapping::recomputeActivitiesSet()
{
	activitiesIdsSet=QSet<int>(activitiesIds.constBegin(), activitiesIds.constEnd());
}

bool ConstraintActivitiesNotOverlapping::hasInactiveActivities(Rules& r)
{
	int count=0;

	for(int i=0; i<this->n_activities; i++)
		if(r.inactiveActivities.contains(this->activitiesIds[i]))
			count++;

	if(this->n_activities-count<=1)
		return true;
	else
		return false;
}

QString ConstraintActivitiesNotOverlapping::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintActivitiesNotOverlapping>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Number_of_Activities>"+CustomFETString::number(this->n_activities)+"</Number_of_Activities>\n";
	for(int i=0; i<this->n_activities; i++)
		s+=IL3+"<Activity_Id>"+CustomFETString::number(this->activitiesIds[i])+"</Activity_Id>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivitiesNotOverlapping>\n";
	return s;
}

QString ConstraintActivitiesNotOverlapping::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Activities not overlapping");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("NA:%1", "Number of activities").arg(this->n_activities);s+=translatedCommaSpace();
	for(int i=0; i<this->n_activities; i++){
		s+=tr("Id:%1", "Id of activity").arg(getActivityDescription(r, this->activitiesIds[i]));
		if(i<this->n_activities-1)
			s+=translatedCommaSpace();
	}

	return begin+s+end;
}

QString ConstraintActivitiesNotOverlapping::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("Activities must not overlap");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Number of activities=%1").arg(this->n_activities);s+="\n";
	for(int i=0; i<this->n_activities; i++){
		s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			.arg(this->activitiesIds[i]).arg(getActivityDetailedDescription(r, this->activitiesIds[i]));
		s+="\n";
	}

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintActivitiesNotOverlapping::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	assert(r.internalStructureComputed);

	int nbroken;

	//We do not use the matrices 'subgroupsMatrix' nor 'teachersMatrix'.

	//sum the overlapping hours for all pairs of activities.
	//without logging
	if(conflictsString==nullptr){
		nbroken=0;
		for(int i=1; i<this->_n_activities; i++){
			int t1=c.times[this->_activities[i]];
			if(t1!=UNALLOCATED_TIME){
				int day1=t1%r.nDaysPerWeek;
				int hour1=t1/r.nDaysPerWeek;
				int duration1=r.internalActivitiesList[this->_activities[i]].duration;

				for(int j=0; j<i; j++){
					int t2=c.times[this->_activities[j]];
					if(t2!=UNALLOCATED_TIME){
						int day2=t2%r.nDaysPerWeek;
						int hour2=t2/r.nDaysPerWeek;
						int duration2=r.internalActivitiesList[this->_activities[j]].duration;

						//the number of overlapping hours
						int tt=0;
						if(day1==day2){
							int start=std::max(hour1, hour2);
							int stop=std::min(hour1+duration1, hour2+duration2);
							if(stop>start)
								tt+=stop-start;
						}
						
						nbroken+=tt;
					}
				}
			}
		}
	}
	//with logging
	else{
		nbroken=0;
		for(int i=1; i<this->_n_activities; i++){
			int t1=c.times[this->_activities[i]];
			if(t1!=UNALLOCATED_TIME){
				int day1=t1%r.nDaysPerWeek;
				int hour1=t1/r.nDaysPerWeek;
				int duration1=r.internalActivitiesList[this->_activities[i]].duration;

				for(int j=0; j<i; j++){
					int t2=c.times[this->_activities[j]];
					if(t2!=UNALLOCATED_TIME){
						int day2=t2%r.nDaysPerWeek;
						int hour2=t2/r.nDaysPerWeek;
						int duration2=r.internalActivitiesList[this->_activities[j]].duration;
	
						//the number of overlapping hours
						int tt=0;
						if(day1==day2){
							int start=std::max(hour1, hour2);
							int stop=std::min(hour1+duration1, hour2+duration2);
							if(stop>start)
								tt+=stop-start;
						}

						//The overlapping hours
						int tmp=tt;

						nbroken+=tmp;

						if(tt>0 && conflictsString!=nullptr){

							QString s=tr("Time constraint activities not overlapping broken: activity with id=%1 (%2) overlaps with activity with id=%3 (%4) on a number of %5 periods",
							 "%1 is the id, %2 is the detailed description of the activity, %3 id, %4 det. descr.")
							 .arg(r.internalActivitiesList[this->_activities[i]].id)
							 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[this->_activities[i]].id))
							 .arg(r.internalActivitiesList[this->_activities[j]].id)
							 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[this->_activities[j]].id))
							 .arg(tt);
							s+=translatedCommaSpace();
							s+=tr("conflicts factor increase=%1").arg(CustomFETString::numberPlusTwoDigitsPrecision(tmp*weightPercentage/100));
							
							dl.append(s);
							cl.append(tmp*weightPercentage/100);
						
							*conflictsString+= s+"\n";
						}
					}
				}
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintActivitiesNotOverlapping::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	
	return activitiesIdsSet.contains(aid);
	
	/*for(int i=0; i<this->n_activities; i++)
		if(this->activitiesIds[i]==a->id)
			return true;
	return false;*/
}

bool ConstraintActivitiesNotOverlapping::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivitiesNotOverlapping::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesNotOverlapping::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesNotOverlapping::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintActivitiesNotOverlapping::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivitiesNotOverlapping::hasWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

bool ConstraintActivitiesNotOverlapping::canRepairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0);
	
	return true;
}

bool ConstraintActivitiesNotOverlapping::repairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0); //should check hasWrongDayOrHour, firstly

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivityTagsNotOverlapping::ConstraintActivityTagsNotOverlapping()
	: TimeConstraint()
{
	type=CONSTRAINT_ACTIVITY_TAGS_NOT_OVERLAPPING;
}

ConstraintActivityTagsNotOverlapping::ConstraintActivityTagsNotOverlapping(double wp, const QStringList& atl)
 : TimeConstraint(wp)
 {
	activityTagsNames=atl;

	this->type=CONSTRAINT_ACTIVITY_TAGS_NOT_OVERLAPPING;
}

bool ConstraintActivityTagsNotOverlapping::computeInternalStructure(QWidget* parent, Rules& r)
{
	if(activityTagsNames.count()<2){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("The following constraint is wrong (because it needs at least two activity tags). "
			"Please correct it:\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}

	activityTagsIndices.clear();
	activitiesIndicesLists.clear();
	for(const QString& activityTagName : std::as_const(activityTagsNames)){
		int activityTagIndex=r.activityTagsHash.value(activityTagName, -1);
		assert(activityTagIndex>=0);
		activityTagsIndices.append(activityTagIndex);
		activitiesIndicesLists.append(QList<int>());
	}
	
	for(int ai=0; ai<r.nInternalActivities; ai++){
		Activity* act=&r.internalActivitiesList[ai];
		for(int i=0; i<activityTagsIndices.count(); i++){
			int at=activityTagsIndices.at(i);
			if(act->iActivityTagsSet.contains(at))
				activitiesIndicesLists[i].append(ai);
		}
	}
	
	assert(activitiesIndicesLists.count()==activityTagsIndices.count());
	assert(activityTagsNames.count()==activityTagsIndices.count());
	for(int i=0; i<activityTagsIndices.count(); i++){
		if(activitiesIndicesLists.at(i).count()<1){
			TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
				tr("Following constraint is wrong (because you need at least one activity for each activity tag, but"
				 " no activity has activity tag %1). Please correct it:\n%2").arg(activityTagsNames.at(i)).arg(this->getDetailedDescription(r)));
			return false;
		}
	}

	return true;
}

bool ConstraintActivityTagsNotOverlapping::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintActivityTagsNotOverlapping::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintActivityTagsNotOverlapping>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Number_of_Activity_Tags>"+QString::number(this->activityTagsNames.count())+"</Number_of_Activity_Tags>\n";
	for(const QString& atn : std::as_const(activityTagsNames))
		s+=IL3+"<Activity_Tag>"+protect(atn)+"</Activity_Tag>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivityTagsNotOverlapping>\n";
	return s;
}

QString ConstraintActivityTagsNotOverlapping::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Activity tags not overlapping");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("NAT:%1", "Number of activity tags").arg(this->activityTagsNames.count());s+=translatedCommaSpace();
	int i=0;
	for(const QString& atn : std::as_const(activityTagsNames)){
		s+=tr("AT:%1", "Activity tag").arg(atn);
		if(i<this->activityTagsNames.count()-1)
			s+=translatedCommaSpace();
		i++;
	}

	return begin+s+end;
}

QString ConstraintActivityTagsNotOverlapping::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("Activity tags must not overlap");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Number of activity tags=%1").arg(this->activityTagsNames.count());s+="\n";
	for(const QString& atn : std::as_const(activityTagsNames)){
		s+=tr("Activity tag=%1").arg(atn);
		s+="\n";
	}

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintActivityTagsNotOverlapping::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	assert(r.internalStructureComputed);

	int nbroken;

	//We do not use the matrices 'subgroupsMatrix' nor 'teachersMatrix'.

	//sum the overlapping hours for all pairs of activities.
	nbroken=0;
	
	for(int k1=1; k1<activitiesIndicesLists.count(); k1++){
		const QList<int>& l1=activitiesIndicesLists.at(k1);
		for(int k2=0; k2<k1; k2++){
			const QList<int>& l2=activitiesIndicesLists.at(k2);
			
			for(int i : std::as_const(l1)){
				int t1=c.times[i];
				if(t1!=UNALLOCATED_TIME){
					int day1=t1%r.nDaysPerWeek;
					int hour1=t1/r.nDaysPerWeek;
					int duration1=r.internalActivitiesList[i].duration;

					for(int j : std::as_const(l2)){
						int t2=c.times[j];
						if(t2!=UNALLOCATED_TIME){
							int day2=t2%r.nDaysPerWeek;
							int hour2=t2/r.nDaysPerWeek;
							int duration2=r.internalActivitiesList[j].duration;

							//the number of overlapping hours
							int tt=0;
							if(day1==day2){
								int start=std::max(hour1, hour2);
								int stop=std::min(hour1+duration1, hour2+duration2);
								if(stop>start)
									tt+=stop-start;
							}

							int tmp=tt;

							nbroken+=tmp;

							if(tt>0 && conflictsString!=nullptr){
								QString s=tr("Time constraint activity tags not overlapping broken: activity with id=%1 (%2) overlaps with activity with id=%3 (%4) on a number of %5 periods",
								 "%1 is the id, %2 is the detailed description of the activity, %3 id, %4 det. descr.")
								 .arg(r.internalActivitiesList[i].id)
								 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[i].id))
								 .arg(r.internalActivitiesList[j].id)
								 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[j].id))
								 .arg(tt);
								s+=translatedCommaSpace();
								s+=tr("conflicts factor increase=%1").arg(CustomFETString::numberPlusTwoDigitsPrecision(tmp*weightPercentage/100));
								
								dl.append(s);
								cl.append(tmp*weightPercentage/100);
								
								*conflictsString+= s+"\n";
							}
						}
					}
				}
			}
		}
	}
	
	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintActivityTagsNotOverlapping::isRelatedToActivity(Rules& r, int aid)
{
	Activity* a=r.activitiesPointerHash.value(aid, nullptr);
	assert(a!=nullptr);
	
	QSet<QString> ats(activityTagsNames.constBegin(), activityTagsNames.constEnd());
	QSet<QString> aats(a->activityTagsNames.constBegin(), a->activityTagsNames.constEnd());

	return ats.intersects(aats);
}

bool ConstraintActivityTagsNotOverlapping::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivityTagsNotOverlapping::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivityTagsNotOverlapping::isRelatedToActivityTag(const QString& s)
{
	return activityTagsNames.contains(s);
}

bool ConstraintActivityTagsNotOverlapping::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintActivityTagsNotOverlapping::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivityTagsNotOverlapping::hasWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

bool ConstraintActivityTagsNotOverlapping::canRepairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0);
	
	return true;
}

bool ConstraintActivityTagsNotOverlapping::repairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0); //should check hasWrongDayOrHour, firstly

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintMinDaysBetweenActivities::ConstraintMinDaysBetweenActivities()
	: TimeConstraint()
{
	type=CONSTRAINT_MIN_DAYS_BETWEEN_ACTIVITIES;
}

ConstraintMinDaysBetweenActivities::ConstraintMinDaysBetweenActivities(double wp, bool cisd, int nact, const QList<int>& act, int _minDays)
 : TimeConstraint(wp)
 {
	this->consecutiveIfSameDay=cisd;

	assert(nact>=2);
	assert(act.count()==nact);
	this->n_activities=nact;
	this->activitiesIds.clear();
	for(int i=0; i<nact; i++)
		this->activitiesIds.append(act.at(i));

	assert(_minDays>0);
	this->minDays=_minDays;

	this->type=CONSTRAINT_MIN_DAYS_BETWEEN_ACTIVITIES;
}

bool ConstraintMinDaysBetweenActivities::operator==(ConstraintMinDaysBetweenActivities& c){
	assert(this->n_activities==this->activitiesIds.count());
	assert(c.n_activities==c.activitiesIds.count());

	if(this->n_activities!=c.n_activities)
		return false;
	for(int i=0; i<this->n_activities; i++)
		if(this->activitiesIds[i]!=c.activitiesIds[i])
			return false;
	if(this->minDays!=c.minDays)
		return false;
	if(this->weightPercentage!=c.weightPercentage)
		return false;
	if(this->consecutiveIfSameDay!=c.consecutiveIfSameDay)
		return false;
	return true;
}

bool ConstraintMinDaysBetweenActivities::computeInternalStructure(QWidget* parent, Rules& r)
{
	//compute the indices of the activities,
	//based on their unique ID

	assert(this->n_activities==this->activitiesIds.count());

	this->_activities.clear();
	for(int i=0; i<this->n_activities; i++){
		int j=r.activitiesHash.value(activitiesIds.at(i), -1);
		//assert(j>=0);
		if(j>=0)
			_activities.append(j);
		/*Activity* act;
		for(j=0; j<r.nInternalActivities; j++){
			act=&r.internalActivitiesList[j];
			if(act->id==this->activitiesIds[i]){
				this->_activities.append(j);
				break;
			}
		}*/
	}
	this->_n_activities=this->_activities.count();
	
	if(this->_n_activities<=1){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (because you need 2 or more activities). Please correct it:\n%1").arg(this->getDetailedDescription(r)));
		//assert(0);
		return false;
	}

	return true;
}

void ConstraintMinDaysBetweenActivities::removeUseless(Rules& r)
{
	//remove the activitiesIds which no longer exist (used after the deletion of an activity)
	
	assert(this->n_activities==this->activitiesIds.count());

	QList<int> tmpList;

	for(int i=0; i<this->n_activities; i++){
		Activity* act=r.activitiesPointerHash.value(activitiesIds[i], nullptr);
		if(act!=nullptr)
			tmpList.append(act->id);
		/*for(int k=0; k<r.activitiesList.size(); k++){
			Activity* act=r.activitiesList[k];
			if(act->id==this->activitiesIds[i]){
				tmpList.append(act->id);
				break;
			}
		}*/
	}
	
	this->activitiesIds=tmpList;
	this->n_activities=this->activitiesIds.count();

	r.internalStructureComputed=false;
}

void ConstraintMinDaysBetweenActivities::recomputeActivitiesSet()
{
	activitiesIdsSet=QSet<int>(activitiesIds.constBegin(), activitiesIds.constEnd());
}

bool ConstraintMinDaysBetweenActivities::hasInactiveActivities(Rules& r)
{
	int count=0;

	for(int i=0; i<this->n_activities; i++)
		if(r.inactiveActivities.contains(this->activitiesIds[i]))
			count++;

	if(this->n_activities-count<=1)
		return true;
	else
		return false;
}

QString ConstraintMinDaysBetweenActivities::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintMinDaysBetweenActivities>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Consecutive_If_Same_Day>";s+=trueFalse(this->consecutiveIfSameDay);s+="</Consecutive_If_Same_Day>\n";
	s+=IL3+"<Number_of_Activities>"+CustomFETString::number(this->n_activities)+"</Number_of_Activities>\n";
	for(int i=0; i<this->n_activities; i++)
		s+=IL3+"<Activity_Id>"+CustomFETString::number(this->activitiesIds[i])+"</Activity_Id>\n";
	s+=IL3+"<MinDays>"+CustomFETString::number(this->minDays)+"</MinDays>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintMinDaysBetweenActivities>\n";
	return s;
}

QString ConstraintMinDaysBetweenActivities::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Min days between activities");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("NA:%1", "Number of activities").arg(this->n_activities);s+=translatedCommaSpace();
	for(int i=0; i<this->n_activities; i++){
		s+=tr("Id:%1", "Id of activity").arg(getActivityDescription(r, this->activitiesIds[i]));s+=translatedCommaSpace();
	}
	s+=tr("mD:%1", "Min days").arg(this->minDays);s+=translatedCommaSpace();
	s+=tr("CSD:%1", "Consecutive if on the same day").arg(yesNoTranslated(this->consecutiveIfSameDay));

	return begin+s+end;
}

QString ConstraintMinDaysBetweenActivities::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("Minimum number of days between activities");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Number of activities=%1").arg(this->n_activities);s+="\n";
	for(int i=0; i<this->n_activities; i++){
		s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			.arg(this->activitiesIds[i])
			.arg(getActivityDetailedDescription(r, this->activitiesIds[i]));
		s+="\n";
	}
	s+=tr("Minimum number of days=%1").arg(this->minDays);s+="\n";
	s+=tr("Consecutive if on the same day=%1").arg(yesNoTranslated(this->consecutiveIfSameDay));s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintMinDaysBetweenActivities::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	assert(r.internalStructureComputed);

	int nbroken;

	//We do not use the matrices 'subgroupsMatrix' nor 'teachersMatrix'.

	//without logging
	if(conflictsString==nullptr){
		nbroken=0;
		for(int i=1; i<this->_n_activities; i++){
			int t1=c.times[this->_activities[i]];
			if(t1!=UNALLOCATED_TIME){
				int day1=t1%r.nDaysPerWeek;
				int hour1=t1/r.nDaysPerWeek;
				int duration1=r.internalActivitiesList[this->_activities[i]].duration;

				for(int j=0; j<i; j++){
					int t2=c.times[this->_activities[j]];
					if(t2!=UNALLOCATED_TIME){
						int day2=t2%r.nDaysPerWeek;
						int hour2=t2/r.nDaysPerWeek;
						int duration2=r.internalActivitiesList[this->_activities[j]].duration;
					
						int tmp;
						int tt=0;
						int dist = r.mode==MORNINGS_AFTERNOONS ? abs(day1/2-day2/2) : abs(day1-day2);
						if(dist<minDays){
							tt=minDays-dist;
							
							if(r.mode!=MORNINGS_AFTERNOONS){
								if(this->consecutiveIfSameDay && day1==day2)
									assert( day1==day2 && (hour1+duration1==hour2 || hour2+duration2==hour1) );
							}
							else{
								if(this->consecutiveIfSameDay)
									assert( ( day1==day2 && (hour1+duration1==hour2 || hour2+duration2==hour1) ) || (day1/2!=day2/2) );
							}
						}
						
						tmp=tt;
	
						nbroken+=tmp;
					}
				}
			}
		}
	}
	//with logging
	else{
		nbroken=0;
		for(int i=1; i<this->_n_activities; i++){
			int t1=c.times[this->_activities[i]];
			if(t1!=UNALLOCATED_TIME){
				int day1=t1%r.nDaysPerWeek;
				int hour1=t1/r.nDaysPerWeek;
				int duration1=r.internalActivitiesList[this->_activities[i]].duration;

				for(int j=0; j<i; j++){
					int t2=c.times[this->_activities[j]];
					if(t2!=UNALLOCATED_TIME){
						int day2=t2%r.nDaysPerWeek;
						int hour2=t2/r.nDaysPerWeek;
						int duration2=r.internalActivitiesList[this->_activities[j]].duration;
					
						int tmp;
						int tt=0;
						int dist = r.mode==MORNINGS_AFTERNOONS ? abs(day1/2-day2/2) : abs(day1-day2);

						if(dist<minDays){
							tt=minDays-dist;
							
							if(r.mode!=MORNINGS_AFTERNOONS){
								if(this->consecutiveIfSameDay && day1==day2)
									assert( day1==day2 && (hour1+duration1==hour2 || hour2+duration2==hour1) );
							}
							else{
								if(this->consecutiveIfSameDay)
									assert( ( day1==day2 && (hour1+duration1==hour2 || hour2+duration2==hour1) ) || (day1/2!=day2/2) );
							}
						}

						tmp=tt;
	
						nbroken+=tmp;

						if(tt>0 && conflictsString!=nullptr){
							QString s=tr("Time constraint min days between activities broken: activity with id=%1 (%2) conflicts with activity with id=%3 (%4), being %5 days too close, on days %6 and %7",
							 "%1 is the id, %2 is the detailed description of the activity, %3 id, %4 det. descr. Close here means near")
							 .arg(r.internalActivitiesList[this->_activities[i]].id)
							 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[this->_activities[i]].id))
							 .arg(r.internalActivitiesList[this->_activities[j]].id)
							 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[this->_activities[j]].id))
							 .arg(tt)
							 .arg(r.daysOfTheWeek[day1])
							 .arg(r.daysOfTheWeek[day2]);
							 ;

							s+=translatedCommaSpace();
							s+=tr("conflicts factor increase=%1").arg(CustomFETString::numberPlusTwoDigitsPrecision(tmp*weightPercentage/100));
							s+=translatedDot();
							
							if(this->consecutiveIfSameDay && ((r.mode!=MORNINGS_AFTERNOONS && day1==day2) || (r.mode==MORNINGS_AFTERNOONS && day1/2==day2/2))){
								s+=" ";
								s+=tr("The activities are placed consecutively in the timetable, because you selected this option"
								 " in case the activities are on the same day");
							}
							
							dl.append(s);
							cl.append(tmp*weightPercentage/100);
							
							*conflictsString+= s+"\n";
						}
					}
				}
			}
		}
	}
	
	if(true && minDays>=1 /*!this->consecutiveIfSameDay*/){ //from version 6.4.0, not allowed more than two activities on the same (real) day
	//The test minDays>=1 was added in FET-6.9.6, after the crash report by Rouge Rosé on 2023-09-17. If minDays was 0, FET crashed if there were
	//more than two activities from this constraint on the same day. It is possible to have minDays==0 is the .fet file is created manually or
	//with another tool, or if the user decreases the number of days to 1 after adding one or more constraint(s) of type min days between activities.
		if(r.mode!=MORNINGS_AFTERNOONS){
			Matrix1D<int> na;
			na.resize(r.nDaysPerWeek);
			for(int d=0; d<r.nDaysPerWeek; d++)
				na[d]=0;
			
			for(int i=0; i<this->_n_activities; i++){
				int t=c.times[this->_activities[i]];
				if(t!=UNALLOCATED_TIME){
					int day=t%r.nDaysPerWeek;
					na[day]++;
				}
			}
			
			for(int d=0; d<r.nDaysPerWeek; d++)
				assert(na[d]<=2);
		}
		else{
			Matrix1D<int> na;
			na.resize(r.nDaysPerWeek/2);
			for(int d=0; d<r.nDaysPerWeek/2; d++)
				na[d]=0;
			
			for(int i=0; i<this->_n_activities; i++){
				int t=c.times[this->_activities[i]];
				if(t!=UNALLOCATED_TIME){
					int day=t%r.nDaysPerWeek;
					na[day/2]++;
				}
			}
			
			for(int d=0; d<r.nDaysPerWeek/2; d++)
				assert(na[d]<=2);
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintMinDaysBetweenActivities::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	
	return activitiesIdsSet.contains(aid);
	
	/*for(int i=0; i<this->n_activities; i++)
		if(this->activitiesIds[i]==a->id)
			return true;
	return false;*/
}

bool ConstraintMinDaysBetweenActivities::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintMinDaysBetweenActivities::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintMinDaysBetweenActivities::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintMinDaysBetweenActivities::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintMinDaysBetweenActivities::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintMinDaysBetweenActivities::hasWrongDayOrHour(Rules& r)
{
	if(r.mode!=MORNINGS_AFTERNOONS){
		if(minDays>=r.nDaysPerWeek)
			return true;
	}
	else{
		if(minDays>=r.nDaysPerWeek/2)
			return true;
	}
	
	return false;
}

bool ConstraintMinDaysBetweenActivities::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintMinDaysBetweenActivities::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(r.mode!=MORNINGS_AFTERNOONS){
		if(minDays>=r.nDaysPerWeek)
			minDays=r.nDaysPerWeek-1;
	}
	else{
		if(minDays>=r.nDaysPerWeek/2)
			minDays=r.nDaysPerWeek/2-1;
	}

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintMaxDaysBetweenActivities::ConstraintMaxDaysBetweenActivities()
	: TimeConstraint()
{
	type=CONSTRAINT_MAX_DAYS_BETWEEN_ACTIVITIES;
}

ConstraintMaxDaysBetweenActivities::ConstraintMaxDaysBetweenActivities(double wp, int nact, const QList<int>& act, int _maxDays)
 : TimeConstraint(wp)
 {
	assert(nact>=2);
	assert(act.count()==nact);
	this->n_activities=nact;
	this->activitiesIds.clear();
	for(int i=0; i<nact; i++)
		this->activitiesIds.append(act.at(i));

	assert(_maxDays>=0);
	this->maxDays=_maxDays;

	this->type=CONSTRAINT_MAX_DAYS_BETWEEN_ACTIVITIES;
}

bool ConstraintMaxDaysBetweenActivities::computeInternalStructure(QWidget* parent, Rules& r)
{
	//compute the indices of the activities,
	//based on their unique ID

	assert(this->n_activities==this->activitiesIds.count());

	this->_activities.clear();
	for(int i=0; i<this->n_activities; i++){
		int j=r.activitiesHash.value(activitiesIds.at(i), -1);
		//assert(j>=0);
		if(j>=0)
			_activities.append(j);
		/*int j;
		Activity* act;
		for(j=0; j<r.nInternalActivities; j++){
			act=&r.internalActivitiesList[j];
			if(act->id==this->activitiesIds[i]){
				this->_activities.append(j);
				break;
			}
		}*/
	}
	this->_n_activities=this->_activities.count();
	
	if(this->_n_activities<=1){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (because you need 2 or more activities). Please correct it:\n%1").arg(this->getDetailedDescription(r)));
		//assert(0);
		return false;
	}

	return true;
}

void ConstraintMaxDaysBetweenActivities::removeUseless(Rules& r)
{
	//remove the activitiesIds which no longer exist (used after the deletion of an activity)
	
	assert(this->n_activities==this->activitiesIds.count());

	QList<int> tmpList;

	for(int i=0; i<this->n_activities; i++){
		Activity* act=r.activitiesPointerHash.value(activitiesIds[i], nullptr);
		if(act!=nullptr)
			tmpList.append(act->id);
		/*for(int k=0; k<r.activitiesList.size(); k++){
			Activity* act=r.activitiesList[k];
			if(act->id==this->activitiesIds[i]){
				tmpList.append(act->id);
				break;
			}
		}*/
	}
	
	this->activitiesIds=tmpList;
	this->n_activities=this->activitiesIds.count();

	r.internalStructureComputed=false;
}

void ConstraintMaxDaysBetweenActivities::recomputeActivitiesSet()
{
	activitiesIdsSet=QSet<int>(activitiesIds.constBegin(), activitiesIds.constEnd());
}

bool ConstraintMaxDaysBetweenActivities::hasInactiveActivities(Rules& r)
{
	int count=0;

	for(int i=0; i<this->n_activities; i++)
		if(r.inactiveActivities.contains(this->activitiesIds[i]))
			count++;

	if(this->n_activities-count<=1)
		return true;
	else
		return false;
}

QString ConstraintMaxDaysBetweenActivities::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintMaxDaysBetweenActivities>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Number_of_Activities>"+CustomFETString::number(this->n_activities)+"</Number_of_Activities>\n";
	for(int i=0; i<this->n_activities; i++)
		s+=IL3+"<Activity_Id>"+CustomFETString::number(this->activitiesIds[i])+"</Activity_Id>\n";
	s+=IL3+"<MaxDays>"+CustomFETString::number(this->maxDays)+"</MaxDays>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintMaxDaysBetweenActivities>\n";
	return s;
}

QString ConstraintMaxDaysBetweenActivities::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Max days between activities");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("NA:%1", "Number of activities").arg(this->n_activities);s+=translatedCommaSpace();
	for(int i=0; i<this->n_activities; i++){
		s+=tr("Id:%1", "Id of activity").arg(getActivityDescription(r, this->activitiesIds[i]));s+=translatedCommaSpace();
	}
	s+=tr("MD:%1", "Abbreviation for maximum days").arg(this->maxDays);

	return begin+s+end;
}

QString ConstraintMaxDaysBetweenActivities::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("Maximum number of days between activities");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Number of activities=%1").arg(this->n_activities);s+="\n";
	for(int i=0; i<this->n_activities; i++){
		s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			.arg(this->activitiesIds[i])
			.arg(getActivityDetailedDescription(r, this->activitiesIds[i]));
		s+="\n";
	}
	s+=tr("Maximum number of days=%1").arg(this->maxDays);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintMaxDaysBetweenActivities::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	assert(r.internalStructureComputed);

	int nbroken;

	//We do not use the matrices 'subgroupsMatrix' nor 'teachersMatrix'.

	//without logging
	if(conflictsString==nullptr){
		nbroken=0;
		for(int i=1; i<this->_n_activities; i++){
			int t1=c.times[this->_activities[i]];
			if(t1!=UNALLOCATED_TIME){
				int day1=t1%r.nDaysPerWeek;
				//int hour1=t1/r.nDaysPerWeek;
				//int duration1=r.internalActivitiesList[this->_activities[i]].duration;

				for(int j=0; j<i; j++){
					int t2=c.times[this->_activities[j]];
					if(t2!=UNALLOCATED_TIME){
						int day2=t2%r.nDaysPerWeek;
						//int hour2=t2/r.nDaysPerWeek;
						//int duration2=r.internalActivitiesList[this->_activities[j]].duration;
					
						int tmp;
						int tt=0;
						int dist = r.mode==MORNINGS_AFTERNOONS ? abs(day1/2-day2/2) : abs(day1-day2);
						if(dist>maxDays){
							tt=dist-maxDays;
							
							//if(this->consecutiveIfSameDay && day1==day2)
							//	assert( day1==day2 && (hour1+duration1==hour2 || hour2+duration2==hour1) );
						}
						
						tmp=tt;
	
						nbroken+=tmp;
					}
				}
			}
		}
	}
	//with logging
	else{
		nbroken=0;
		for(int i=1; i<this->_n_activities; i++){
			int t1=c.times[this->_activities[i]];
			if(t1!=UNALLOCATED_TIME){
				int day1=t1%r.nDaysPerWeek;
				//int hour1=t1/r.nDaysPerWeek;
				//int duration1=r.internalActivitiesList[this->_activities[i]].duration;

				for(int j=0; j<i; j++){
					int t2=c.times[this->_activities[j]];
					if(t2!=UNALLOCATED_TIME){
						int day2=t2%r.nDaysPerWeek;
						//int hour2=t2/r.nDaysPerWeek;
						//int duration2=r.internalActivitiesList[this->_activities[j]].duration;
					
						int tmp;
						int tt=0;
						int dist = r.mode==MORNINGS_AFTERNOONS ? abs(day1/2-day2/2) : abs(day1-day2);

						if(dist>maxDays){
							tt=dist-maxDays;
							
							//if(this->consecutiveIfSameDay && day1==day2)
							//	assert( day1==day2 && (hour1+duration1==hour2 || hour2+duration2==hour1) );
						}

						tmp=tt;
	
						nbroken+=tmp;

						if(tt>0 && conflictsString!=nullptr){
							QString s=tr("Time constraint max days between activities broken: activity with id=%1 (%2) conflicts with activity with id=%3 (%4), being %5 days too far away"
							 ", on days %6 and %7", "%1 is the id, %2 is the detailed description of the activity, %3 id, %4 det. descr.")
							 .arg(r.internalActivitiesList[this->_activities[i]].id)
							 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[this->_activities[i]].id))
							 .arg(r.internalActivitiesList[this->_activities[j]].id)
							 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[this->_activities[j]].id))
							 .arg(tt)
							 .arg(r.daysOfTheWeek[day1])
							 .arg(r.daysOfTheWeek[day2]);
							
							s+=translatedCommaSpace();
							s+=tr("conflicts factor increase=%1").arg(CustomFETString::numberPlusTwoDigitsPrecision(tmp*weightPercentage/100));
							s+=translatedDot();
							
							dl.append(s);
							cl.append(tmp*weightPercentage/100);
							
							*conflictsString+= s+"\n";
						}
					}
				}
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintMaxDaysBetweenActivities::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	return activitiesIdsSet.contains(aid);

	/*for(int i=0; i<this->n_activities; i++)
		if(this->activitiesIds[i]==a->id)
			return true;
	return false;*/
}

bool ConstraintMaxDaysBetweenActivities::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintMaxDaysBetweenActivities::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintMaxDaysBetweenActivities::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintMaxDaysBetweenActivities::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintMaxDaysBetweenActivities::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintMaxDaysBetweenActivities::hasWrongDayOrHour(Rules& r)
{
	if(r.mode!=MORNINGS_AFTERNOONS){
		if(maxDays>=r.nDaysPerWeek)
			return true;
	}
	else{
		if(maxDays>=r.nDaysPerWeek/2)
			return true;
	}
	
	return false;
}

bool ConstraintMaxDaysBetweenActivities::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintMaxDaysBetweenActivities::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(r.mode!=MORNINGS_AFTERNOONS){
		if(maxDays>=r.nDaysPerWeek)
			maxDays=r.nDaysPerWeek-1;
	}
	else{
		if(maxDays>=r.nDaysPerWeek/2)
			maxDays=r.nDaysPerWeek/2-1;
	}

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivitiesMaxHourlySpan::ConstraintActivitiesMaxHourlySpan()
	: TimeConstraint()
{
	type=CONSTRAINT_ACTIVITIES_MAX_HOURLY_SPAN;
}

ConstraintActivitiesMaxHourlySpan::ConstraintActivitiesMaxHourlySpan(double wp, int nact, const QList<int>& act, int _maxHourlySpan)
 : TimeConstraint(wp)
 {
	assert(nact>=2);
	assert(act.count()==nact);
	this->n_activities=nact;
	this->activitiesIds.clear();
	for(int i=0; i<nact; i++)
		this->activitiesIds.append(act.at(i));

	assert(_maxHourlySpan>=0);
	this->maxHourlySpan=_maxHourlySpan;

	this->type=CONSTRAINT_ACTIVITIES_MAX_HOURLY_SPAN;
}

bool ConstraintActivitiesMaxHourlySpan::computeInternalStructure(QWidget* parent, Rules& r)
{
	//compute the indices of the activities,
	//based on their unique ID

	assert(this->n_activities==this->activitiesIds.count());

	this->_activities.clear();
	for(int i=0; i<this->n_activities; i++){
		int j=r.activitiesHash.value(activitiesIds.at(i), -1);
		//assert(j>=0);
		if(j>=0)
			_activities.append(j);
		/*int j;
		Activity* act;
		for(j=0; j<r.nInternalActivities; j++){
			act=&r.internalActivitiesList[j];
			if(act->id==this->activitiesIds[i]){
				this->_activities.append(j);
				break;
			}
		}*/
	}
	this->_n_activities=this->_activities.count();
	
	if(this->_n_activities<=1){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (because you need 2 or more activities). Please correct it:\n%1").arg(this->getDetailedDescription(r)));
		//assert(0);
		return false;
	}

	return true;
}

void ConstraintActivitiesMaxHourlySpan::removeUseless(Rules& r)
{
	//remove the activitiesIds which no longer exist (used after the deletion of an activity)
	
	assert(this->n_activities==this->activitiesIds.count());

	QList<int> tmpList;

	for(int i=0; i<this->n_activities; i++){
		Activity* act=r.activitiesPointerHash.value(activitiesIds[i], nullptr);
		if(act!=nullptr)
			tmpList.append(act->id);
		/*for(int k=0; k<r.activitiesList.size(); k++){
			Activity* act=r.activitiesList[k];
			if(act->id==this->activitiesIds[i]){
				tmpList.append(act->id);
				break;
			}
		}*/
	}
	
	this->activitiesIds=tmpList;
	this->n_activities=this->activitiesIds.count();

	r.internalStructureComputed=false;
}

void ConstraintActivitiesMaxHourlySpan::recomputeActivitiesSet()
{
	activitiesIdsSet=QSet<int>(activitiesIds.constBegin(), activitiesIds.constEnd());
}

bool ConstraintActivitiesMaxHourlySpan::hasInactiveActivities(Rules& r)
{
	int count=0;

	for(int i=0; i<this->n_activities; i++)
		if(r.inactiveActivities.contains(this->activitiesIds[i]))
			count++;

	if(this->n_activities-count<=1)
		return true;
	else
		return false;
}

QString ConstraintActivitiesMaxHourlySpan::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintActivitiesMaxHourlySpan>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Number_of_Activities>"+CustomFETString::number(this->n_activities)+"</Number_of_Activities>\n";
	for(int i=0; i<this->n_activities; i++)
		s+=IL3+"<Activity_Id>"+CustomFETString::number(this->activitiesIds[i])+"</Activity_Id>\n";
	s+=IL3+"<MaxHourlySpan>"+CustomFETString::number(this->maxHourlySpan)+"</MaxHourlySpan>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivitiesMaxHourlySpan>\n";
	return s;
}

QString ConstraintActivitiesMaxHourlySpan::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Activities max hourly span");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("NA:%1", "Number of activities").arg(this->n_activities);s+=translatedCommaSpace();
	for(int i=0; i<this->n_activities; i++){
		s+=tr("Id:%1", "Id of activity").arg(getActivityDescription(r, this->activitiesIds[i]));s+=translatedCommaSpace();
	}
	s+=tr("MHS:%1", "Abbreviation for maximum hourly span").arg(this->maxHourlySpan);

	return begin+s+end;
}

QString ConstraintActivitiesMaxHourlySpan::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("Activities max hourly span");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Number of activities=%1").arg(this->n_activities);s+="\n";
	for(int i=0; i<this->n_activities; i++){
		s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			.arg(this->activitiesIds[i])
			.arg(getActivityDetailedDescription(r, this->activitiesIds[i]));
		s+="\n";
	}
	s+=tr("Maximum hourly span=%1").arg(this->maxHourlySpan);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintActivitiesMaxHourlySpan::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	assert(r.internalStructureComputed);

	int nbroken;

	//We do not use the matrices 'subgroupsMatrix' nor 'teachersMatrix'.

	//without logging
	if(conflictsString==nullptr){
		nbroken=0;
		for(int i=1; i<this->_n_activities; i++){
			int t1=c.times[this->_activities[i]];
			if(t1!=UNALLOCATED_TIME){
				//int day1=t1%r.nDaysPerWeek;
				int hour1=t1/r.nDaysPerWeek;
				int duration1=r.internalActivitiesList[this->_activities[i]].duration;

				for(int j=0; j<i; j++){
					int t2=c.times[this->_activities[j]];
					if(t2!=UNALLOCATED_TIME){
						//int day2=t2%r.nDaysPerWeek;
						int hour2=t2/r.nDaysPerWeek;
						int duration2=r.internalActivitiesList[this->_activities[j]].duration;
					
						int tmp;
						int tt=0;
						int td1 = abs(hour1-(hour2+duration2));
						int td2 = abs(hour2-(hour1+duration1));
						//int dist = abs(day1-day2);

						if(td1>maxHourlySpan || td2>maxHourlySpan)
							tt=std::max(maxHourlySpan-td1, maxHourlySpan-td2);

						/*if(dist>maxDays){
							tt=dist-maxDays;
							
							//if(this->consecutiveIfSameDay && day1==day2)
							//	assert( day1==day2 && (hour1+duration1==hour2 || hour2+duration2==hour1) );
						}*/

						tmp=tt;
	
						nbroken+=tmp;
					}
				}
			}
		}
	}
	//with logging
	else{
		nbroken=0;
		for(int i=1; i<this->_n_activities; i++){
			int t1=c.times[this->_activities[i]];
			if(t1!=UNALLOCATED_TIME){
				//int day1=t1%r.nDaysPerWeek;
				int hour1=t1/r.nDaysPerWeek;
				int duration1=r.internalActivitiesList[this->_activities[i]].duration;

				for(int j=0; j<i; j++){
					int t2=c.times[this->_activities[j]];
					if(t2!=UNALLOCATED_TIME){
						//int day2=t2%r.nDaysPerWeek;
						int hour2=t2/r.nDaysPerWeek;
						int duration2=r.internalActivitiesList[this->_activities[j]].duration;
					
						int tmp;
						int tt=0;
						int td1 = abs(hour1-(hour2+duration2));
						int td2 = abs(hour2-(hour1+duration1));
						//int dist = abs(day1-day2);

						if(td1>maxHourlySpan || td2>maxHourlySpan)
							tt=std::max(maxHourlySpan-td1, maxHourlySpan-td2);

						/*if(dist>maxDays){
							tt=dist-maxDays;
							
							//if(this->consecutiveIfSameDay && day1==day2)
							//	assert( day1==day2 && (hour1+duration1==hour2 || hour2+duration2==hour1) );
						}*/

						tmp=tt;
	
						nbroken+=tmp;

						if(tt>0 && conflictsString!=nullptr){
							int day1=t1%r.nDaysPerWeek;
							int day2=t2%r.nDaysPerWeek;
							
							QString s=tr("Time constraint activities max hourly span broken: activity with id=%1 (%2) conflicts with activity with id=%3 (%4), spanning %5 hours too much."
							 " The first activity begins on day %6, hour %7, and the second activity begins on day %8, hour %9",
							 "%1 is the id, %2 is the detailed description of the activity, %3 id, %4 det. descr.")
							 .arg(r.internalActivitiesList[this->_activities[i]].id)
							 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[this->_activities[i]].id))
							 .arg(r.internalActivitiesList[this->_activities[j]].id)
							 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[this->_activities[j]].id))
							 .arg(tt)
							 .arg(r.daysOfTheWeek[day1])
							 .arg(r.hoursOfTheDay[hour1])
							 .arg(r.daysOfTheWeek[day2])
							 .arg(r.hoursOfTheDay[hour2]);
							
							s+=translatedCommaSpace();
							s+=tr("conflicts factor increase=%1").arg(CustomFETString::numberPlusTwoDigitsPrecision(tmp*weightPercentage/100));
							s+=translatedDot();
							
							dl.append(s);
							cl.append(tmp*weightPercentage/100);
							
							*conflictsString+= s+"\n";
						}
					}
				}
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintActivitiesMaxHourlySpan::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	return activitiesIdsSet.contains(aid);

	/*for(int i=0; i<this->n_activities; i++)
		if(this->activitiesIds[i]==a->id)
			return true;
	return false;*/
}

bool ConstraintActivitiesMaxHourlySpan::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivitiesMaxHourlySpan::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesMaxHourlySpan::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesMaxHourlySpan::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintActivitiesMaxHourlySpan::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivitiesMaxHourlySpan::hasWrongDayOrHour(Rules& r)
{
	if(maxHourlySpan>r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintActivitiesMaxHourlySpan::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintActivitiesMaxHourlySpan::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxHourlySpan>r.nHoursPerDay)
		maxHourlySpan=r.nHoursPerDay;
	
	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintMinGapsBetweenActivities::ConstraintMinGapsBetweenActivities()
	: TimeConstraint()
{
	type=CONSTRAINT_MIN_GAPS_BETWEEN_ACTIVITIES;
}

ConstraintMinGapsBetweenActivities::ConstraintMinGapsBetweenActivities(double wp, int nact, const QList<int>& actList, int ngaps)
 : TimeConstraint(wp)
 {
	this->n_activities=nact;
	assert(nact==actList.count());
	this->activitiesIds.clear();
	for(int i=0; i<nact; i++)
		this->activitiesIds.append(actList.at(i));

	assert(ngaps>0);
	this->minGaps=ngaps;

	this->type=CONSTRAINT_MIN_GAPS_BETWEEN_ACTIVITIES;
}

bool ConstraintMinGapsBetweenActivities::computeInternalStructure(QWidget* parent, Rules& r)
{
	//compute the indices of the activities,
	//based on their unique ID

	assert(this->n_activities==this->activitiesIds.count());

	this->_activities.clear();
	for(int i=0; i<this->n_activities; i++){
		int j=r.activitiesHash.value(activitiesIds.at(i), -1);
		//assert(j>=0);
		if(j>=0)
			_activities.append(j);
		/*int j;
		Activity* act;
		for(j=0; j<r.nInternalActivities; j++){
			act=&r.internalActivitiesList[j];
			if(act->id==this->activitiesIds[i]){
				this->_activities.append(j);
				break;
			}
		}*/
	}
	this->_n_activities=this->_activities.count();
	
	if(this->_n_activities<=1){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (because you need 2 or more activities). Please correct it:\n%1").arg(this->getDetailedDescription(r)));
		//assert(0);
		return false;
	}

	return true;
}

void ConstraintMinGapsBetweenActivities::removeUseless(Rules& r)
{
	//remove the activitiesIds which no longer exist (used after the deletion of an activity)
	
	assert(this->n_activities==this->activitiesIds.count());

	QList<int> tmpList;

	for(int i=0; i<this->n_activities; i++){
		Activity* act=r.activitiesPointerHash.value(activitiesIds[i], nullptr);
		if(act!=nullptr)
			tmpList.append(act->id);
		/*for(int k=0; k<r.activitiesList.size(); k++){
			Activity* act=r.activitiesList[k];
			if(act->id==this->activitiesIds[i]){
				tmpList.append(act->id);
				break;
			}
		}*/
	}
	
	this->activitiesIds=tmpList;
	this->n_activities=this->activitiesIds.count();

	r.internalStructureComputed=false;
}

void ConstraintMinGapsBetweenActivities::recomputeActivitiesSet()
{
	activitiesIdsSet=QSet<int>(activitiesIds.constBegin(), activitiesIds.constEnd());
}

bool ConstraintMinGapsBetweenActivities::hasInactiveActivities(Rules& r)
{
	int count=0;

	for(int i=0; i<this->n_activities; i++)
		if(r.inactiveActivities.contains(this->activitiesIds[i]))
			count++;

	if(this->n_activities-count<=1)
		return true;
	else
		return false;
}

QString ConstraintMinGapsBetweenActivities::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintMinGapsBetweenActivities>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Number_of_Activities>"+CustomFETString::number(this->n_activities)+"</Number_of_Activities>\n";
	for(int i=0; i<this->n_activities; i++)
		s+=IL3+"<Activity_Id>"+CustomFETString::number(this->activitiesIds[i])+"</Activity_Id>\n";
	s+=IL3+"<MinGaps>"+CustomFETString::number(this->minGaps)+"</MinGaps>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintMinGapsBetweenActivities>\n";
	return s;
}

QString ConstraintMinGapsBetweenActivities::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Min gaps between activities");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("NA:%1", "Number of activities").arg(this->n_activities);s+=translatedCommaSpace();
	for(int i=0; i<this->n_activities; i++){
		s+=tr("Id:%1", "Id of activity").arg(getActivityDescription(r, this->activitiesIds[i]));s+=translatedCommaSpace();
	}
	s+=tr("mG:%1", "Minimum number of gaps").arg(this->minGaps);

	return begin+s+end;
}

QString ConstraintMinGapsBetweenActivities::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("Minimum gaps between activities (if the activities are on the same day)");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Number of activities=%1").arg(this->n_activities);s+="\n";
	for(int i=0; i<this->n_activities; i++){
		s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			.arg(this->activitiesIds[i])
			.arg(getActivityDetailedDescription(r, this->activitiesIds[i]));
		s+="\n";
	}
	s+=tr("Minimum number of gaps=%1").arg(this->minGaps);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintMinGapsBetweenActivities::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	assert(r.internalStructureComputed);

	int nbroken;

	//We do not use the matrices 'subgroupsMatrix' nor 'teachersMatrix'.

	nbroken=0;
	for(int i=1; i<this->_n_activities; i++){
		int t1=c.times[this->_activities[i]];
		if(t1!=UNALLOCATED_TIME){
			int day1=t1%r.nDaysPerWeek;
			int hour1=t1/r.nDaysPerWeek;
			int duration1=r.internalActivitiesList[this->_activities[i]].duration;

			for(int j=0; j<i; j++){
				int t2=c.times[this->_activities[j]];
				if(t2!=UNALLOCATED_TIME){
					int day2=t2%r.nDaysPerWeek;
					int hour2=t2/r.nDaysPerWeek;
					int duration2=r.internalActivitiesList[this->_activities[j]].duration;
				
					int tmp;
					int tt=0;
					int dist=abs(day1-day2);
					
					if(dist==0){ //same day
						assert(day1==day2);
						if(hour2>=hour1){
							//assert(hour1+duration1<=hour2); not true for activities which are not incompatible
							if(hour1+duration1+minGaps > hour2)
								tt = (hour1+duration1+minGaps) - hour2;
						}
						else{
							//assert(hour2+duration2<=hour1); not true for activities which are not incompatible
							if(hour2+duration2+minGaps > hour1)
								tt = (hour2+duration2+minGaps) - hour1;
						}
					}

					tmp=tt;
	
					nbroken+=tmp;

					if(tt>0 && conflictsString!=nullptr){
						QString s=tr("Time constraint min gaps between activities broken: activity with id=%1 (%2) conflicts with activity with id=%3 (%4), they are on the same day %5 and there are %6 more needed hours between them",
							"%1 is the id, %2 is the detailed description of the activity, %3 id, %4 det. descr.")
						 .arg(r.internalActivitiesList[this->_activities[i]].id)
						 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[this->_activities[i]].id))
						 .arg(r.internalActivitiesList[this->_activities[j]].id)
						 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[this->_activities[j]].id))
						 .arg(r.daysOfTheWeek[day1])
						 .arg(tt);

						s+=translatedCommaSpace();
						s+=tr("conflicts factor increase=%1").arg(CustomFETString::numberPlusTwoDigitsPrecision(tmp*weightPercentage/100));
						s+=translatedDot();
							
						dl.append(s);
						cl.append(tmp*weightPercentage/100);
							
						*conflictsString+= s+"\n";
					}
				}
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintMinGapsBetweenActivities::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	return activitiesIdsSet.contains(aid);

	/*for(int i=0; i<this->n_activities; i++)
		if(this->activitiesIds[i]==a->id)
			return true;
	return false;*/
}

bool ConstraintMinGapsBetweenActivities::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintMinGapsBetweenActivities::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintMinGapsBetweenActivities::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintMinGapsBetweenActivities::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintMinGapsBetweenActivities::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintMinGapsBetweenActivities::hasWrongDayOrHour(Rules& r)
{
	if(minGaps>r.nHoursPerDay)
		return true;
		
	return false;
}

bool ConstraintMinGapsBetweenActivities::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintMinGapsBetweenActivities::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(minGaps>r.nHoursPerDay)
		minGaps=r.nHoursPerDay;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintMaxGapsBetweenActivities::ConstraintMaxGapsBetweenActivities()
	: TimeConstraint()
{
	type=CONSTRAINT_MAX_GAPS_BETWEEN_ACTIVITIES;
}

ConstraintMaxGapsBetweenActivities::ConstraintMaxGapsBetweenActivities(double wp, int nact, const QList<int>& actList, int ngaps)
 : TimeConstraint(wp)
 {
	this->n_activities=nact;
	assert(nact==actList.count());
	this->activitiesIds.clear();
	for(int i=0; i<nact; i++)
		this->activitiesIds.append(actList.at(i));

	assert(ngaps>0);
	this->maxGaps=ngaps;

	this->type=CONSTRAINT_MAX_GAPS_BETWEEN_ACTIVITIES;
}

bool ConstraintMaxGapsBetweenActivities::computeInternalStructure(QWidget* parent, Rules& r)
{
	//compute the indices of the activities,
	//based on their unique ID

	assert(this->n_activities==this->activitiesIds.count());

	this->_activities.clear();
	for(int i=0; i<this->n_activities; i++){
		int j=r.activitiesHash.value(activitiesIds.at(i), -1);
		//assert(j>=0);
		if(j>=0)
			_activities.append(j);
		/*int j;
		Activity* act;
		for(j=0; j<r.nInternalActivities; j++){
			act=&r.internalActivitiesList[j];
			if(act->id==this->activitiesIds[i]){
				this->_activities.append(j);
				break;
			}
		}*/
	}
	this->_n_activities=this->_activities.count();

	if(this->_n_activities<=1){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (because you need 2 or more activities). Please correct it:\n%1").arg(this->getDetailedDescription(r)));
		//assert(0);
		return false;
	}

	return true;
}

void ConstraintMaxGapsBetweenActivities::removeUseless(Rules& r)
{
	//remove the activitiesIds which no longer exist (used after the deletion of an activity)

	assert(this->n_activities==this->activitiesIds.count());

	QList<int> tmpList;

	for(int i=0; i<this->n_activities; i++){
		Activity* act=r.activitiesPointerHash.value(activitiesIds[i], nullptr);
		if(act!=nullptr)
			tmpList.append(act->id);
		/*for(int k=0; k<r.activitiesList.size(); k++){
			Activity* act=r.activitiesList[k];
			if(act->id==this->activitiesIds[i]){
				tmpList.append(act->id);
				break;
			}
		}*/
	}

	this->activitiesIds=tmpList;
	this->n_activities=this->activitiesIds.count();

	r.internalStructureComputed=false;
}

void ConstraintMaxGapsBetweenActivities::recomputeActivitiesSet()
{
	activitiesIdsSet=QSet<int>(activitiesIds.constBegin(), activitiesIds.constEnd());
}

bool ConstraintMaxGapsBetweenActivities::hasInactiveActivities(Rules& r)
{
	int count=0;

	for(int i=0; i<this->n_activities; i++)
		if(r.inactiveActivities.contains(this->activitiesIds[i]))
			count++;

	if(this->n_activities-count<=1)
		return true;
	else
		return false;
}

QString ConstraintMaxGapsBetweenActivities::getXmlDescription(Rules& r){
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintMaxGapsBetweenActivities>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Number_of_Activities>"+CustomFETString::number(this->n_activities)+"</Number_of_Activities>\n";
	for(int i=0; i<this->n_activities; i++)
		s+=IL3+"<Activity_Id>"+CustomFETString::number(this->activitiesIds[i])+"</Activity_Id>\n";
	s+=IL3+"<MaxGaps>"+CustomFETString::number(this->maxGaps)+"</MaxGaps>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintMaxGapsBetweenActivities>\n";
	return s;
}

QString ConstraintMaxGapsBetweenActivities::getDescription(Rules& r){
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";

	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);

	QString s;
	s+=tr("Max gaps between activities");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("NA:%1", "Number of activities").arg(this->n_activities);s+=translatedCommaSpace();
	for(int i=0; i<this->n_activities; i++){
		s+=tr("Id:%1", "Id of activity").arg(getActivityDescription(r, this->activitiesIds[i]));s+=translatedCommaSpace();
	}
	s+=tr("MG:%1", "Maximum number of gaps").arg(this->maxGaps);

	return begin+s+end;
}

QString ConstraintMaxGapsBetweenActivities::getDetailedDescription(Rules& r, bool richText, bool colors){
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("Maximum gaps between activities (if the activities are on the same day)");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Number of activities=%1").arg(this->n_activities);s+="\n";
	for(int i=0; i<this->n_activities; i++){
		s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			.arg(this->activitiesIds[i])
			.arg(getActivityDetailedDescription(r, this->activitiesIds[i]));
		s+="\n";
	}
	s+=tr("Maximum number of gaps=%1").arg(this->maxGaps);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintMaxGapsBetweenActivities::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	assert(r.internalStructureComputed);

	int nbroken;

	//We do not use the matrices 'subgroupsMatrix' nor 'teachersMatrix'.

	nbroken=0;
	for(int i=1; i<this->_n_activities; i++){
		int t1=c.times[this->_activities[i]];
		if(t1!=UNALLOCATED_TIME){
			int day1=t1%r.nDaysPerWeek;
			int hour1=t1/r.nDaysPerWeek;
			int duration1=r.internalActivitiesList[this->_activities[i]].duration;

			for(int j=0; j<i; j++){
				int t2=c.times[this->_activities[j]];
				if(t2!=UNALLOCATED_TIME){
					int day2=t2%r.nDaysPerWeek;
					int hour2=t2/r.nDaysPerWeek;
					int duration2=r.internalActivitiesList[this->_activities[j]].duration;

					int tmp;
					int tt=0;
					int dist=abs(day1-day2);

					if(dist==0){ //same day
						assert(day1==day2);
						if(hour2>=hour1){
							//assert(hour1+duration1<=hour2); not true for activities which are not incompatible
							if(hour1+duration1+maxGaps < hour2)
								tt = - (hour1+duration1+maxGaps) + hour2;
						}
						else{
							//assert(hour2+duration2<=hour1); not true for activities which are not incompatible
							if(hour2+duration2+maxGaps < hour1)
								tt = - (hour2+duration2+maxGaps) + hour1;
						}
					}

					tmp=tt;

					nbroken+=tmp;

					if(tt>0 && conflictsString!=nullptr){
						QString s=tr("Time constraint max gaps between activities broken: activity with id=%1 (%2) conflicts with activity with id=%3 (%4), they are on the same day %5 and there are %6 extra hours between them",
							"%1 is the id, %2 is the detailed description of the activity, %3 id, %4 det. descr.")
						 .arg(r.internalActivitiesList[this->_activities[i]].id)
						 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[this->_activities[i]].id))
						 .arg(r.internalActivitiesList[this->_activities[j]].id)
						 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[this->_activities[j]].id))
						 .arg(r.daysOfTheWeek[day1])
						 .arg(tt);

						s+=translatedCommaSpace();
						s+=tr("conflicts factor increase=%1").arg(CustomFETString::numberPlusTwoDigitsPrecision(tmp*weightPercentage/100));
						s+=translatedDot();

						dl.append(s);
						cl.append(tmp*weightPercentage/100);

						*conflictsString+= s+"\n";
					}
				}
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintMaxGapsBetweenActivities::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	return activitiesIdsSet.contains(aid);

	/*for(int i=0; i<this->n_activities; i++)
		if(this->activitiesIds[i]==a->id)
			return true;
	return false;*/
}

bool ConstraintMaxGapsBetweenActivities::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintMaxGapsBetweenActivities::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintMaxGapsBetweenActivities::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintMaxGapsBetweenActivities::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintMaxGapsBetweenActivities::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintMaxGapsBetweenActivities::hasWrongDayOrHour(Rules& r)
{
	if(maxGaps>r.nHoursPerDay)
		return true;

	return false;
}

bool ConstraintMaxGapsBetweenActivities::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));

	return true;
}

bool ConstraintMaxGapsBetweenActivities::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));

	if(maxGaps>r.nHoursPerDay)
		maxGaps=r.nHoursPerDay;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeachersMaxHoursDaily::ConstraintTeachersMaxHoursDaily()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHERS_MAX_HOURS_DAILY;
}

ConstraintTeachersMaxHoursDaily::ConstraintTeachersMaxHoursDaily(double wp, int maxhours)
 : TimeConstraint(wp)
 {
	assert(maxhours>0);
	this->maxHoursDaily=maxhours;

	this->type=CONSTRAINT_TEACHERS_MAX_HOURS_DAILY;
}

bool ConstraintTeachersMaxHoursDaily::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);
	Q_UNUSED(r);
	
	return true;
}

bool ConstraintTeachersMaxHoursDaily::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeachersMaxHoursDaily::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeachersMaxHoursDaily>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Maximum_Hours_Daily>"+CustomFETString::number(this->maxHoursDaily)+"</Maximum_Hours_Daily>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeachersMaxHoursDaily>\n";
	return s;
}

QString ConstraintTeachersMaxHoursDaily::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teachers max hours daily"), s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("MH:%1", "Maximum hours (daily)").arg(this->maxHoursDaily);

	return begin+s+end;
}

QString ConstraintTeachersMaxHoursDaily::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All teachers must respect the maximum number of hours daily");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Maximum hours daily=%1").arg(this->maxHoursDaily);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeachersMaxHoursDaily::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	//without logging
	if(conflictsString==nullptr){
		nbroken=0;
		for(int i=0; i<r.nInternalTeachers; i++){
			for(int d=0; d<r.nDaysPerWeek; d++){
				int n_hours_daily=0;
				for(int h=0; h<r.nHoursPerDay; h++)
					if(teachersMatrix[i][d][h]>0)
						n_hours_daily++;

				if(n_hours_daily>this->maxHoursDaily)
					nbroken++;
			}
		}
	}
	//with logging
	else{
		nbroken=0;
		for(int i=0; i<r.nInternalTeachers; i++){
			for(int d=0; d<r.nDaysPerWeek; d++){
				int n_hours_daily=0;
				for(int h=0; h<r.nHoursPerDay; h++)
					if(teachersMatrix[i][d][h]>0)
						n_hours_daily++;

				if(n_hours_daily>this->maxHoursDaily){
					nbroken++;

					if(conflictsString!=nullptr){
						QString s=(tr(
						 "Time constraint teachers max %1 hours daily broken for teacher %2, on day %3, length=%4.")
						 .arg(CustomFETString::number(this->maxHoursDaily))
						 .arg(r.internalTeachersList[i]->name)
						 .arg(r.daysOfTheWeek[d])
						 .arg(n_hours_daily)
						 )
						 +
						 " "
						 +
						 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100)));
						
						dl.append(s);
						cl.append(weightPercentage/100);
					
						*conflictsString+= s+"\n";
					}
				}
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintTeachersMaxHoursDaily::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeachersMaxHoursDaily::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return true;
}

bool ConstraintTeachersMaxHoursDaily::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMaxHoursDaily::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMaxHoursDaily::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeachersMaxHoursDaily::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeachersMaxHoursDaily::hasWrongDayOrHour(Rules& r)
{
	if(maxHoursDaily>r.nHoursPerDay)
		return true;
		
	return false;
}

bool ConstraintTeachersMaxHoursDaily::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeachersMaxHoursDaily::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxHoursDaily>r.nHoursPerDay)
		maxHoursDaily=r.nHoursPerDay;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeacherMaxHoursDaily::ConstraintTeacherMaxHoursDaily()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHER_MAX_HOURS_DAILY;
}

ConstraintTeacherMaxHoursDaily::ConstraintTeacherMaxHoursDaily(double wp, int maxhours, const QString& teacher)
 : TimeConstraint(wp)
 {
	assert(maxhours>0);
	this->maxHoursDaily=maxhours;
	this->teacherName=teacher;

	this->type=CONSTRAINT_TEACHER_MAX_HOURS_DAILY;
}

bool ConstraintTeacherMaxHoursDaily::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);

	//this->teacher_ID=r.searchTeacher(this->teacherName);
	teacher_ID=r.teachersHash.value(teacherName, -1);
	assert(this->teacher_ID>=0);
	return true;
}

bool ConstraintTeacherMaxHoursDaily::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeacherMaxHoursDaily::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeacherMaxHoursDaily>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Teacher>"+protect(this->teacherName)+"</Teacher>\n";
	s+=IL3+"<Maximum_Hours_Daily>"+CustomFETString::number(this->maxHoursDaily)+"</Maximum_Hours_Daily>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeacherMaxHoursDaily>\n";
	return s;
}

QString ConstraintTeacherMaxHoursDaily::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teacher max hours daily");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("T:%1", "Teacher").arg(this->teacherName);s+=translatedCommaSpace();
	s+=tr("MH:%1", "Maximum hours (daily)").arg(this->maxHoursDaily);

	return begin+s+end;
}

QString ConstraintTeacherMaxHoursDaily::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A teacher must respect the maximum number of hours daily");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Teacher=%1").arg(this->teacherName);s+="\n";
	s+=tr("Maximum hours daily=%1").arg(this->maxHoursDaily);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeacherMaxHoursDaily::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	//without logging
	if(conflictsString==nullptr){
		nbroken=0;
		int i=this->teacher_ID;
		for(int d=0; d<r.nDaysPerWeek; d++){
			int n_hours_daily=0;
			for(int h=0; h<r.nHoursPerDay; h++)
				if(teachersMatrix[i][d][h]>0)
					n_hours_daily++;

			if(n_hours_daily>this->maxHoursDaily){
				nbroken++;
			}
		}
	}
	//with logging
	else{
		nbroken=0;
		int i=this->teacher_ID;
		for(int d=0; d<r.nDaysPerWeek; d++){
			int n_hours_daily=0;
			for(int h=0; h<r.nHoursPerDay; h++)
				if(teachersMatrix[i][d][h]>0)
					n_hours_daily++;

			if(n_hours_daily>this->maxHoursDaily){
				nbroken++;

				if(conflictsString!=nullptr){
					QString s=(tr(
					 "Time constraint teacher max %1 hours daily broken for teacher %2, on day %3, length=%4.")
					 .arg(CustomFETString::number(this->maxHoursDaily))
					 .arg(r.internalTeachersList[i]->name)
					 .arg(r.daysOfTheWeek[d])
					 .arg(n_hours_daily)
					 )
					 +" "
					 +
					 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100)));
						
					dl.append(s);
					cl.append(weightPercentage/100);
				
					*conflictsString+= s+"\n";
				}
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintTeacherMaxHoursDaily::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeacherMaxHoursDaily::isRelatedToTeacher(const QString& t)
{
	if(this->teacherName==t)
		return true;
	return false;
}

bool ConstraintTeacherMaxHoursDaily::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMaxHoursDaily::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMaxHoursDaily::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeacherMaxHoursDaily::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeacherMaxHoursDaily::hasWrongDayOrHour(Rules& r)
{
	if(maxHoursDaily>r.nHoursPerDay)
		return true;
		
	return false;
}

bool ConstraintTeacherMaxHoursDaily::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeacherMaxHoursDaily::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxHoursDaily>r.nHoursPerDay)
		maxHoursDaily=r.nHoursPerDay;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeachersMaxHoursContinuously::ConstraintTeachersMaxHoursContinuously()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHERS_MAX_HOURS_CONTINUOUSLY;
}

ConstraintTeachersMaxHoursContinuously::ConstraintTeachersMaxHoursContinuously(double wp, int maxhours)
 : TimeConstraint(wp)
 {
	assert(maxhours>0);
	this->maxHoursContinuously=maxhours;

	this->type=CONSTRAINT_TEACHERS_MAX_HOURS_CONTINUOUSLY;
}

bool ConstraintTeachersMaxHoursContinuously::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);
	Q_UNUSED(r);

	return true;
}

bool ConstraintTeachersMaxHoursContinuously::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeachersMaxHoursContinuously::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeachersMaxHoursContinuously>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Maximum_Hours_Continuously>"+CustomFETString::number(this->maxHoursContinuously)+"</Maximum_Hours_Continuously>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeachersMaxHoursContinuously>\n";
	return s;
}

QString ConstraintTeachersMaxHoursContinuously::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teachers max hours continuously");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("MH:%1", "Maximum hours (continuously)").arg(this->maxHoursContinuously);

	return begin+s+end;
}

QString ConstraintTeachersMaxHoursContinuously::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All teachers must respect the maximum number of hours continuously");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Maximum hours continuously=%1").arg(this->maxHoursContinuously);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeachersMaxHoursContinuously::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	nbroken=0;
	for(int i=0; i<r.nInternalTeachers; i++){
		for(int d=0; d<r.nDaysPerWeek; d++){
			int nc=0;
			for(int h=0; h<r.nHoursPerDay; h++){
				if(teachersMatrix[i][d][h]>0)
					nc++;
				else{
					if(nc>this->maxHoursContinuously){
						nbroken++;

						if(conflictsString!=nullptr){
							QString s=(tr(
							 "Time constraint teachers max %1 hours continuously broken for teacher %2, on day %3, length=%4.")
							 .arg(CustomFETString::number(this->maxHoursContinuously))
							 .arg(r.internalTeachersList[i]->name)
							 .arg(r.daysOfTheWeek[d])
							 .arg(nc)
							 )
							 +
							 " "
							 +
							 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100)));
							
							dl.append(s);
							cl.append(weightPercentage/100);
				
							*conflictsString+= s+"\n";
						}
					}
				
					nc=0;
				}
			}

			if(nc>this->maxHoursContinuously){
				nbroken++;

				if(conflictsString!=nullptr){
					QString s=(tr(
					 "Time constraint teachers max %1 hours continuously broken for teacher %2, on day %3, length=%4.")
					 .arg(CustomFETString::number(this->maxHoursContinuously))
					 .arg(r.internalTeachersList[i]->name)
					 .arg(r.daysOfTheWeek[d])
					 .arg(nc)
					 )
					 +
					 " "
					 +
					 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100)));
					
					dl.append(s);
					cl.append(weightPercentage/100);
				
					*conflictsString+= s+"\n";
				}
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintTeachersMaxHoursContinuously::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeachersMaxHoursContinuously::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return true;
}

bool ConstraintTeachersMaxHoursContinuously::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMaxHoursContinuously::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMaxHoursContinuously::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeachersMaxHoursContinuously::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeachersMaxHoursContinuously::hasWrongDayOrHour(Rules& r)
{
	if(maxHoursContinuously>r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintTeachersMaxHoursContinuously::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeachersMaxHoursContinuously::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxHoursContinuously>r.nHoursPerDay)
		maxHoursContinuously=r.nHoursPerDay;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeacherMaxHoursContinuously::ConstraintTeacherMaxHoursContinuously()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHER_MAX_HOURS_CONTINUOUSLY;
}

ConstraintTeacherMaxHoursContinuously::ConstraintTeacherMaxHoursContinuously(double wp, int maxhours, const QString& teacher)
 : TimeConstraint(wp)
 {
	assert(maxhours>0);
	this->maxHoursContinuously=maxhours;
	this->teacherName=teacher;

	this->type=CONSTRAINT_TEACHER_MAX_HOURS_CONTINUOUSLY;
}

bool ConstraintTeacherMaxHoursContinuously::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);

	//this->teacher_ID=r.searchTeacher(this->teacherName);
	teacher_ID=r.teachersHash.value(teacherName, -1);
	assert(this->teacher_ID>=0);
	return true;
}

bool ConstraintTeacherMaxHoursContinuously::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeacherMaxHoursContinuously::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeacherMaxHoursContinuously>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Teacher>"+protect(this->teacherName)+"</Teacher>\n";
	s+=IL3+"<Maximum_Hours_Continuously>"+CustomFETString::number(this->maxHoursContinuously)+"</Maximum_Hours_Continuously>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeacherMaxHoursContinuously>\n";
	return s;
}

QString ConstraintTeacherMaxHoursContinuously::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teacher max hours continuously");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("T:%1", "Teacher").arg(this->teacherName);s+=translatedCommaSpace();
	s+=tr("MH:%1", "Maximum hours continuously").arg(this->maxHoursContinuously);

	return begin+s+end;
}

QString ConstraintTeacherMaxHoursContinuously::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A teacher must respect the maximum number of hours continuously");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Teacher=%1").arg(this->teacherName);s+="\n";
	s+=tr("Maximum hours continuously=%1").arg(this->maxHoursContinuously);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeacherMaxHoursContinuously::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	nbroken=0;
	int i=this->teacher_ID;
	for(int d=0; d<r.nDaysPerWeek; d++){
		int nc=0;
		for(int h=0; h<r.nHoursPerDay; h++){
			if(teachersMatrix[i][d][h]>0)
				nc++;
			else{
				if(nc>this->maxHoursContinuously){
					nbroken++;

					if(conflictsString!=nullptr){
						QString s=(tr(
						 "Time constraint teacher max %1 hours continuously broken for teacher %2, on day %3, length=%4.")
						 .arg(CustomFETString::number(this->maxHoursContinuously))
						 .arg(r.internalTeachersList[i]->name)
						 .arg(r.daysOfTheWeek[d])
						 .arg(nc)
						 )
						 +
						 " "
						 +
						 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100)));
						
						dl.append(s);
						cl.append(weightPercentage/100);
			
						*conflictsString+= s+"\n";
					}
				}
			
				nc=0;
			}
		}

		if(nc>this->maxHoursContinuously){
			nbroken++;

			if(conflictsString!=nullptr){
				QString s=(tr(
				 "Time constraint teacher max %1 hours continuously broken for teacher %2, on day %3, length=%4.")
				 .arg(CustomFETString::number(this->maxHoursContinuously))
				 .arg(r.internalTeachersList[i]->name)
				 .arg(r.daysOfTheWeek[d])
				 .arg(nc)
				 )
				 +
				 " "
				 +
				 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100)));
				
				dl.append(s);
				cl.append(weightPercentage/100);
			
				*conflictsString+= s+"\n";
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintTeacherMaxHoursContinuously::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeacherMaxHoursContinuously::isRelatedToTeacher(const QString& t)
{
	if(this->teacherName==t)
		return true;
	return false;
}

bool ConstraintTeacherMaxHoursContinuously::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMaxHoursContinuously::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMaxHoursContinuously::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeacherMaxHoursContinuously::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeacherMaxHoursContinuously::hasWrongDayOrHour(Rules& r)
{
	if(maxHoursContinuously>r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintTeacherMaxHoursContinuously::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeacherMaxHoursContinuously::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxHoursContinuously>r.nHoursPerDay)
		maxHoursContinuously=r.nHoursPerDay;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeachersActivityTagMaxHoursContinuously::ConstraintTeachersActivityTagMaxHoursContinuously()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY;
}

ConstraintTeachersActivityTagMaxHoursContinuously::ConstraintTeachersActivityTagMaxHoursContinuously(double wp, int maxhours, const QString& activityTag)
 : TimeConstraint(wp)
 {
	assert(maxhours>0);
	this->maxHoursContinuously=maxhours;
	this->activityTagName=activityTag;

	this->type=CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY;
}

bool ConstraintTeachersActivityTagMaxHoursContinuously::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);

	//this->activityTagIndex=r.searchActivityTag(this->activityTagName);
	activityTagIndex=r.activityTagsHash.value(activityTagName, -1);
	assert(this->activityTagIndex>=0);
	
	this->canonicalTeachersList.clear();
	for(int i=0; i<r.nInternalTeachers; i++){
		bool found=false;
	
		Teacher* tch=r.internalTeachersList[i];
		for(int actIndex : std::as_const(tch->activitiesForTeacher)){
			if(r.internalActivitiesList[actIndex].iActivityTagsSet.contains(this->activityTagIndex)){
				found=true;
				break;
			}
		}
		
		if(found)
			this->canonicalTeachersList.append(i);
	}

	return true;
}

bool ConstraintTeachersActivityTagMaxHoursContinuously::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeachersActivityTagMaxHoursContinuously::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeachersActivityTagMaxHoursContinuously>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Activity_Tag>"+protect(this->activityTagName)+"</Activity_Tag>\n";
	s+=IL3+"<Maximum_Hours_Continuously>"+CustomFETString::number(this->maxHoursContinuously)+"</Maximum_Hours_Continuously>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeachersActivityTagMaxHoursContinuously>\n";
	return s;
}

QString ConstraintTeachersActivityTagMaxHoursContinuously::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teachers for activity tag %1 have max %2 hours continuously").arg(this->activityTagName).arg(this->maxHoursContinuously);s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintTeachersActivityTagMaxHoursContinuously::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All teachers, for an activity tag, must respect the maximum number of hours continuously");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Activity tag=%1").arg(this->activityTagName); s+="\n";
	s+=tr("Maximum hours continuously=%1").arg(this->maxHoursContinuously); s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeachersActivityTagMaxHoursContinuously::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	nbroken=0;
	
	Matrix2D<int> crtTeacherTimetableActivityTag;
	crtTeacherTimetableActivityTag.resize(r.nDaysPerWeek, r.nHoursPerDay);
	
	for(int i : std::as_const(this->canonicalTeachersList)){
		Teacher* tch=r.internalTeachersList[i];
		for(int d=0; d<r.nDaysPerWeek; d++)
			for(int h=0; h<r.nHoursPerDay; h++)
				crtTeacherTimetableActivityTag[d][h]=-1;
		for(int ai : std::as_const(tch->activitiesForTeacher)) if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek;
			int h=c.times[ai]/r.nDaysPerWeek;
			for(int dur=0; dur<r.internalActivitiesList[ai].duration; dur++){
				assert(h+dur<r.nHoursPerDay);
				assert(crtTeacherTimetableActivityTag[d][h+dur]==-1);
				if(r.internalActivitiesList[ai].iActivityTagsSet.contains(this->activityTagIndex))
					crtTeacherTimetableActivityTag[d][h+dur]=this->activityTagIndex;
			}
		}
	
		for(int d=0; d<r.nDaysPerWeek; d++){
			int nc=0;
			for(int h=0; h<r.nHoursPerDay; h++){
				bool inc=false;
				if(crtTeacherTimetableActivityTag[d][h]==this->activityTagIndex)
					inc=true;
				
				if(inc){
					nc++;
				}
				else{
					if(nc>this->maxHoursContinuously){
						nbroken++;

						if(conflictsString!=nullptr){
							QString s=(tr(
							 "Time constraint teachers activity tag %1 max %2 hours continuously broken for teacher %3, on day %4, length=%5.")
							 .arg(this->activityTagName)
							 .arg(CustomFETString::number(this->maxHoursContinuously))
							 .arg(r.internalTeachersList[i]->name)
							 .arg(r.daysOfTheWeek[d])
							 .arg(nc)
							 )
							 +
							 " "
							 +
							 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100)));
							
							dl.append(s);
							cl.append(weightPercentage/100);
				
							*conflictsString+= s+"\n";
						}
					}
				
					nc=0;
				}
			}

			if(nc>this->maxHoursContinuously){
				nbroken++;

				if(conflictsString!=nullptr){
					QString s=(tr(
					 "Time constraint teachers activity tag %1 max %2 hours continuously broken for teacher %3, on day %4, length=%5.")
					 .arg(this->activityTagName)
					 .arg(CustomFETString::number(this->maxHoursContinuously))
					 .arg(r.internalTeachersList[i]->name)
					 .arg(r.daysOfTheWeek[d])
					 .arg(nc)
					 )
					 +
					 " "
					 +
					 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100)));
					
					dl.append(s);
					cl.append(weightPercentage/100);
				
					*conflictsString+= s+"\n";
				}
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintTeachersActivityTagMaxHoursContinuously::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeachersActivityTagMaxHoursContinuously::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return true;
}

bool ConstraintTeachersActivityTagMaxHoursContinuously::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersActivityTagMaxHoursContinuously::isRelatedToActivityTag(const QString& s)
{
	return s==this->activityTagName;
}

bool ConstraintTeachersActivityTagMaxHoursContinuously::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeachersActivityTagMaxHoursContinuously::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeachersActivityTagMaxHoursContinuously::hasWrongDayOrHour(Rules& r)
{
	if(maxHoursContinuously>r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintTeachersActivityTagMaxHoursContinuously::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeachersActivityTagMaxHoursContinuously::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxHoursContinuously>r.nHoursPerDay)
		maxHoursContinuously=r.nHoursPerDay;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
ConstraintTeacherActivityTagMaxHoursContinuously::ConstraintTeacherActivityTagMaxHoursContinuously()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY;
}

ConstraintTeacherActivityTagMaxHoursContinuously::ConstraintTeacherActivityTagMaxHoursContinuously(double wp, int maxhours, const QString& teacher, const QString& activityTag)
 : TimeConstraint(wp)
 {
	assert(maxhours>0);
	this->maxHoursContinuously=maxhours;
	this->teacherName=teacher;
	this->activityTagName=activityTag;

	this->type=CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY;
}

bool ConstraintTeacherActivityTagMaxHoursContinuously::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);

	//this->teacher_ID=r.searchTeacher(this->teacherName);
	teacher_ID=r.teachersHash.value(teacherName, -1);
	assert(this->teacher_ID>=0);

	//this->activityTagIndex=r.searchActivityTag(this->activityTagName);
	activityTagIndex=r.activityTagsHash.value(activityTagName, -1);
	assert(this->activityTagIndex>=0);

	this->canonicalTeachersList.clear();
	int i=this->teacher_ID;
	bool found=false;
	
	Teacher* tch=r.internalTeachersList[i];
	for(int actIndex : std::as_const(tch->activitiesForTeacher)){
		if(r.internalActivitiesList[actIndex].iActivityTagsSet.contains(this->activityTagIndex)){
			found=true;
			break;
		}
	}
		
	if(found)
		this->canonicalTeachersList.append(i);

	return true;
}

bool ConstraintTeacherActivityTagMaxHoursContinuously::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeacherActivityTagMaxHoursContinuously::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeacherActivityTagMaxHoursContinuously>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Teacher>"+protect(this->teacherName)+"</Teacher>\n";
	s+=IL3+"<Activity_Tag>"+protect(this->activityTagName)+"</Activity_Tag>\n";
	s+=IL3+"<Maximum_Hours_Continuously>"+CustomFETString::number(this->maxHoursContinuously)+"</Maximum_Hours_Continuously>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeacherActivityTagMaxHoursContinuously>\n";
	return s;
}

QString ConstraintTeacherActivityTagMaxHoursContinuously::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teacher %1 for activity tag %2 has max %3 hours continuously").arg(this->teacherName).arg(this->activityTagName).arg(this->maxHoursContinuously);s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintTeacherActivityTagMaxHoursContinuously::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A teacher for an activity tag must respect the maximum number of hours continuously");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Teacher=%1").arg(this->teacherName);s+="\n";
	s+=tr("Activity tag=%1").arg(this->activityTagName);s+="\n";
	s+=tr("Maximum hours continuously=%1").arg(this->maxHoursContinuously); s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeacherActivityTagMaxHoursContinuously::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	nbroken=0;
	
	Matrix2D<int> crtTeacherTimetableActivityTag;
	crtTeacherTimetableActivityTag.resize(r.nDaysPerWeek, r.nHoursPerDay);
	
	for(int i : std::as_const(this->canonicalTeachersList)){
		Teacher* tch=r.internalTeachersList[i];
		for(int d=0; d<r.nDaysPerWeek; d++)
			for(int h=0; h<r.nHoursPerDay; h++)
				crtTeacherTimetableActivityTag[d][h]=-1;
		for(int ai : std::as_const(tch->activitiesForTeacher)) if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek;
			int h=c.times[ai]/r.nDaysPerWeek;
			for(int dur=0; dur<r.internalActivitiesList[ai].duration; dur++){
				assert(h+dur<r.nHoursPerDay);
				assert(crtTeacherTimetableActivityTag[d][h+dur]==-1);
				if(r.internalActivitiesList[ai].iActivityTagsSet.contains(this->activityTagIndex))
					crtTeacherTimetableActivityTag[d][h+dur]=this->activityTagIndex;
			}
		}

		for(int d=0; d<r.nDaysPerWeek; d++){
			int nc=0;
			for(int h=0; h<r.nHoursPerDay; h++){
				bool inc=false;

				if(crtTeacherTimetableActivityTag[d][h]==this->activityTagIndex)
					inc=true;
				
				if(inc)
					nc++;
				else{
					if(nc>this->maxHoursContinuously){
						nbroken++;

						if(conflictsString!=nullptr){
							QString s=(tr(
							 "Time constraint teacher activity tag max %1 hours continuously broken for teacher %2, activity tag %3, on day %4, length=%5.")
							 .arg(CustomFETString::number(this->maxHoursContinuously))
							 .arg(r.internalTeachersList[i]->name)
							 .arg(this->activityTagName)
							 .arg(r.daysOfTheWeek[d])
							 .arg(nc)
							 )
							 +
							 " "
							 +
							 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100)));
							
							dl.append(s);
							cl.append(weightPercentage/100);
				
							*conflictsString+= s+"\n";
						}
					}
				
					nc=0;
				}
			}

			if(nc>this->maxHoursContinuously){
				nbroken++;

				if(conflictsString!=nullptr){
					QString s=(tr(
					 "Time constraint teacher activity tag max %1 hours continuously broken for teacher %2, activity tag %3, on day %4, length=%5.")
					 .arg(CustomFETString::number(this->maxHoursContinuously))
					 .arg(r.internalTeachersList[i]->name)
					 .arg(this->activityTagName)
					 .arg(r.daysOfTheWeek[d])
					 .arg(nc)
					 )
					 +
					 " "
					 +
					 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100)));
					
					dl.append(s);
					cl.append(weightPercentage/100);
				
					*conflictsString+= s+"\n";
				}
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintTeacherActivityTagMaxHoursContinuously::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeacherActivityTagMaxHoursContinuously::isRelatedToTeacher(const QString& t)
{
	if(this->teacherName==t)
		return true;
	return false;
}

bool ConstraintTeacherActivityTagMaxHoursContinuously::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherActivityTagMaxHoursContinuously::isRelatedToActivityTag(const QString& s)
{
	return this->activityTagName==s;
}

bool ConstraintTeacherActivityTagMaxHoursContinuously::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeacherActivityTagMaxHoursContinuously::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeacherActivityTagMaxHoursContinuously::hasWrongDayOrHour(Rules& r)
{
	if(maxHoursContinuously>r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintTeacherActivityTagMaxHoursContinuously::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeacherActivityTagMaxHoursContinuously::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxHoursContinuously>r.nHoursPerDay)
		maxHoursContinuously=r.nHoursPerDay;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeacherMaxDaysPerWeek::ConstraintTeacherMaxDaysPerWeek()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHER_MAX_DAYS_PER_WEEK;
}

ConstraintTeacherMaxDaysPerWeek::ConstraintTeacherMaxDaysPerWeek(double wp, int maxnd, const QString& tn)
	 : TimeConstraint(wp)
{
	this->teacherName = tn;
	this->maxDaysPerWeek=maxnd;
	this->type=CONSTRAINT_TEACHER_MAX_DAYS_PER_WEEK;
}

bool ConstraintTeacherMaxDaysPerWeek::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);

	//this->teacher_ID=r.searchTeacher(this->teacherName);
	teacher_ID=r.teachersHash.value(teacherName, -1);
	assert(this->teacher_ID>=0);
	return true;
}

bool ConstraintTeacherMaxDaysPerWeek::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeacherMaxDaysPerWeek::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeacherMaxDaysPerWeek>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Teacher>"+protect(this->teacherName)+"</Teacher>\n";
	s+=IL3+"<Max_Days_Per_Week>"+CustomFETString::number(this->maxDaysPerWeek)+"</Max_Days_Per_Week>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeacherMaxDaysPerWeek>\n";
	return s;
}

QString ConstraintTeacherMaxDaysPerWeek::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s=tr("Teacher max days per week");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("T:%1", "Teacher").arg(this->teacherName);s+=translatedCommaSpace();
	s+=tr("MD:%1", "Max days (per week)").arg(this->maxDaysPerWeek);

	return begin+s+end;
}

QString ConstraintTeacherMaxDaysPerWeek::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A teacher must respect the maximum number of days per week");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Teacher=%1").arg(this->teacherName);s+="\n";
	s+=tr("Maximum days per week=%1").arg(this->maxDaysPerWeek);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeacherMaxDaysPerWeek::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	Matrix1D<int> nd;
	nd.resize(r.nHoursPerDay+1);

	//without logging
	if(conflictsString==nullptr){
		nbroken=0;
		//count sort
		int t=this->teacher_ID;
		for(int h=0; h<=r.nHoursPerDay; h++)
			nd[h]=0;
		for(int d=0; d<r.nDaysPerWeek; d++){
			int nh=0;
			for(int h=0; h<r.nHoursPerDay; h++)
				nh += teachersMatrix[t][d][h]>=1 ? 1 : 0;
			nd[nh]++;
		}
		//return the minimum occupied days which do not respect this constraint
		int i = r.nDaysPerWeek - this->maxDaysPerWeek;
		for(int k=0; k<=r.nHoursPerDay; k++){
			if(nd[k]>0){
				if(i>nd[k]){
					i-=nd[k];
					nbroken+=nd[k]*k;
				}
				else{
					nbroken+=i*k;
					break;
				}
			}
		}
	}
	//with logging
	else{
		nbroken=0;
		//count sort
		int t=this->teacher_ID;
		for(int h=0; h<=r.nHoursPerDay; h++)
			nd[h]=0;
		for(int d=0; d<r.nDaysPerWeek; d++){
			int nh=0;
			for(int h=0; h<r.nHoursPerDay; h++)
				nh += teachersMatrix[t][d][h]>=1 ? 1 : 0;
			nd[nh]++;
		}
		//return the minimum occupied days which do not respect this constraint
		int i = r.nDaysPerWeek - this->maxDaysPerWeek;
		for(int k=0; k<=r.nHoursPerDay; k++){
			if(nd[k]>0){
				if(i>nd[k]){
					i-=nd[k];
					nbroken+=nd[k]*k;
				}
				else{
					nbroken+=i*k;
					break;
				}
			}
		}

		if(nbroken>0){
			QString s= tr("Time constraint teacher max days per week broken for teacher: %1.")
			 .arg(r.internalTeachersList[t]->name);
			s += tr("This increases the conflicts total by %1")
			 .arg(CustomFETString::numberPlusTwoDigitsPrecision(nbroken*weightPercentage/100));
			
			dl.append(s);
			cl.append(nbroken*weightPercentage/100);
		
			*conflictsString += s+"\n";
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintTeacherMaxDaysPerWeek::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeacherMaxDaysPerWeek::isRelatedToTeacher(const QString& t)
{
	if(this->teacherName==t)
		return true;
	return false;
}

bool ConstraintTeacherMaxDaysPerWeek::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMaxDaysPerWeek::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMaxDaysPerWeek::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeacherMaxDaysPerWeek::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeacherMaxDaysPerWeek::hasWrongDayOrHour(Rules& r)
{
	if(maxDaysPerWeek>r.nDaysPerWeek)
		return true;
	
	return false;
}

bool ConstraintTeacherMaxDaysPerWeek::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeacherMaxDaysPerWeek::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxDaysPerWeek>r.nDaysPerWeek)
		maxDaysPerWeek=r.nDaysPerWeek;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeachersMaxDaysPerWeek::ConstraintTeachersMaxDaysPerWeek()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHERS_MAX_DAYS_PER_WEEK;
}

ConstraintTeachersMaxDaysPerWeek::ConstraintTeachersMaxDaysPerWeek(double wp, int maxnd)
	 : TimeConstraint(wp)
{
	this->maxDaysPerWeek=maxnd;
	this->type=CONSTRAINT_TEACHERS_MAX_DAYS_PER_WEEK;
}

bool ConstraintTeachersMaxDaysPerWeek::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);
	Q_UNUSED(r);

	return true;
}

bool ConstraintTeachersMaxDaysPerWeek::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeachersMaxDaysPerWeek::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeachersMaxDaysPerWeek>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Max_Days_Per_Week>"+CustomFETString::number(this->maxDaysPerWeek)+"</Max_Days_Per_Week>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeachersMaxDaysPerWeek>\n";
	return s;
}

QString ConstraintTeachersMaxDaysPerWeek::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s=tr("Teachers max days per week");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("MD:%1", "Max days (per week)").arg(this->maxDaysPerWeek);

	return begin+s+end;
}

QString ConstraintTeachersMaxDaysPerWeek::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All teachers must respect the maximum number of days per week");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Maximum days per week=%1").arg(this->maxDaysPerWeek);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeachersMaxDaysPerWeek::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	Matrix1D<int> nd;
	nd.resize(r.nHoursPerDay+1);

	//without logging
	if(conflictsString==nullptr){
		nbroken=0;
		//count sort
		
		for(int t=0; t<r.nInternalTeachers; t++){
			for(int h=0; h<=r.nHoursPerDay; h++)
				nd[h]=0;
			for(int d=0; d<r.nDaysPerWeek; d++){
				int nh=0;
				for(int h=0; h<r.nHoursPerDay; h++)
					nh += teachersMatrix[t][d][h]>=1 ? 1 : 0;
				nd[nh]++;
			}
			//return the minimum occupied days which do not respect this constraint
			int i = r.nDaysPerWeek - this->maxDaysPerWeek;
			for(int k=0; k<=r.nHoursPerDay; k++){
				if(nd[k]>0){
					if(i>nd[k]){
						i-=nd[k];
						nbroken+=nd[k]*k;
					}
					else{
						nbroken+=i*k;
						break;
					}
				}
			}
		
		}
	}
	//with logging
	else{
		nbroken=0;

		for(int t=0; t<r.nInternalTeachers; t++){
			int nbr=0;

			//count sort
			for(int h=0; h<=r.nHoursPerDay; h++)
				nd[h]=0;
			for(int d=0; d<r.nDaysPerWeek; d++){
				int nh=0;
				for(int h=0; h<r.nHoursPerDay; h++)
					nh += teachersMatrix[t][d][h]>=1 ? 1 : 0;
				nd[nh]++;
			}
			//return the minimum occupied days which do not respect this constraint
			int i = r.nDaysPerWeek - this->maxDaysPerWeek;
			for(int k=0; k<=r.nHoursPerDay; k++){
				if(nd[k]>0){
					if(i>nd[k]){
						i-=nd[k];
						nbroken+=nd[k]*k;
						nbr+=nd[k]*k;
					}
					else{
						nbroken+=i*k;
						nbr+=i*k;
						break;
					}
				}
			}

			if(nbr>0){
				QString s= tr("Time constraint teachers max days per week broken for teacher: %1.")
				.arg(r.internalTeachersList[t]->name);
				s += tr("This increases the conflicts total by %1")
				.arg(CustomFETString::numberPlusTwoDigitsPrecision(nbr*weightPercentage/100));
				
				dl.append(s);
				cl.append(nbr*weightPercentage/100);
			
				*conflictsString += s+"\n";
			}
		
		}
		
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintTeachersMaxDaysPerWeek::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeachersMaxDaysPerWeek::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return true;
}

bool ConstraintTeachersMaxDaysPerWeek::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMaxDaysPerWeek::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMaxDaysPerWeek::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeachersMaxDaysPerWeek::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeachersMaxDaysPerWeek::hasWrongDayOrHour(Rules& r)
{
	if(maxDaysPerWeek>r.nDaysPerWeek)
		return true;
	
	return false;
}

bool ConstraintTeachersMaxDaysPerWeek::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeachersMaxDaysPerWeek::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxDaysPerWeek>r.nDaysPerWeek)
		maxDaysPerWeek=r.nDaysPerWeek;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeachersMaxGapsPerWeek::ConstraintTeachersMaxGapsPerWeek()
	: TimeConstraint()
{
	this->type = CONSTRAINT_TEACHERS_MAX_GAPS_PER_WEEK;
}

ConstraintTeachersMaxGapsPerWeek::ConstraintTeachersMaxGapsPerWeek(double wp, int mg)
	: TimeConstraint(wp)
{
	this->type = CONSTRAINT_TEACHERS_MAX_GAPS_PER_WEEK;
	this->maxGaps=mg;
}

bool ConstraintTeachersMaxGapsPerWeek::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);
	Q_UNUSED(r);
	
	return true;
}

bool ConstraintTeachersMaxGapsPerWeek::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeachersMaxGapsPerWeek::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeachersMaxGapsPerWeek>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Max_Gaps>"+CustomFETString::number(this->maxGaps)+"</Max_Gaps>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeachersMaxGapsPerWeek>\n";
	return s;
}

QString ConstraintTeachersMaxGapsPerWeek::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teachers max gaps per week");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("MG:%1", "Max gaps (per week)").arg(this->maxGaps);

	return begin+s+end;
}

QString ConstraintTeachersMaxGapsPerWeek::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All teachers must respect the maximum number of gaps per week");s+="\n";
	s+=tr("(breaks and teacher not available not counted)");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Maximum gaps per week=%1").arg(this->maxGaps); s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeachersMaxGapsPerWeek::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);
		
		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	int tg;
	int i, j, k;
	int totalGaps;

	totalGaps=0;
	for(i=0; i<r.nInternalTeachers; i++){
		tg=0;
		for(j=0; j<r.nDaysPerWeek; j++){
			for(k=0; k<r.nHoursPerDay; k++)
				if(teachersMatrix[i][j][k]>0){
					assert(!breakDayHour[j][k] && !teacherNotAvailableDayHour[i][j][k]);
					break;
				}

			int cnt=0;
			for(; k<r.nHoursPerDay; k++) if(!breakDayHour[j][k] && !teacherNotAvailableDayHour[i][j][k]){
				if(teachersMatrix[i][j][k]>0){
					tg+=cnt;
					cnt=0;
				}
				else
					cnt++;
			}
		}
		if(tg>this->maxGaps){
			totalGaps+=tg-maxGaps;
			//assert(this->weightPercentage<100); partial solutions might break this rule
			if(conflictsString!=nullptr){
				QString s=tr("Time constraint teachers max gaps per week broken for teacher: %1, conflicts factor increase=%2")
					.arg(r.internalTeachersList[i]->name)
					.arg(CustomFETString::numberPlusTwoDigitsPrecision((tg-maxGaps)*weightPercentage/100));
					
				*conflictsString+= s+"\n";
				
				dl.append(s);
				cl.append((tg-maxGaps)*weightPercentage/100);
			}
		}
	}
	
	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100){
			assert(totalGaps==0); //for partial solutions this rule might be broken
		}
	
	return weightPercentage/100 * totalGaps;
}

bool ConstraintTeachersMaxGapsPerWeek::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeachersMaxGapsPerWeek::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return true;
}

bool ConstraintTeachersMaxGapsPerWeek::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMaxGapsPerWeek::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMaxGapsPerWeek::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeachersMaxGapsPerWeek::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeachersMaxGapsPerWeek::hasWrongDayOrHour(Rules& r)
{
	if(maxGaps>r.nDaysPerWeek*r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintTeachersMaxGapsPerWeek::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeachersMaxGapsPerWeek::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxGaps>r.nDaysPerWeek*r.nHoursPerDay)
		maxGaps=r.nDaysPerWeek*r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeacherMaxGapsPerWeek::ConstraintTeacherMaxGapsPerWeek()
	: TimeConstraint()
{
	this->type = CONSTRAINT_TEACHER_MAX_GAPS_PER_WEEK;
}

ConstraintTeacherMaxGapsPerWeek::ConstraintTeacherMaxGapsPerWeek(double wp, const QString& tn, int mg)
	: TimeConstraint(wp)
{
	this->type = CONSTRAINT_TEACHER_MAX_GAPS_PER_WEEK;
	this->teacherName=tn;
	this->maxGaps=mg;
}

bool ConstraintTeacherMaxGapsPerWeek::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);

	//this->teacherIndex=r.searchTeacher(this->teacherName);
	teacherIndex=r.teachersHash.value(teacherName, -1);
	assert(this->teacherIndex>=0);
	return true;
}

bool ConstraintTeacherMaxGapsPerWeek::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeacherMaxGapsPerWeek::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeacherMaxGapsPerWeek>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Teacher>"+protect(this->teacherName)+"</Teacher>\n";
	s+=IL3+"<Max_Gaps>"+CustomFETString::number(this->maxGaps)+"</Max_Gaps>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeacherMaxGapsPerWeek>\n";
	return s;
}

QString ConstraintTeacherMaxGapsPerWeek::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teacher max gaps per week");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("T:%1", "Teacher").arg(this->teacherName); s+=translatedCommaSpace();
	s+=tr("MG:%1", "Max gaps (per week").arg(this->maxGaps);

	return begin+s+end;
}

QString ConstraintTeacherMaxGapsPerWeek::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint"); s+="\n";
	s+=tr("A teacher must respect the maximum number of gaps per week"); s+="\n";
	s+=tr("(breaks and teacher not available not counted)");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage)); s+="\n";
	s+=tr("Teacher=%1").arg(this->teacherName); s+="\n";
	s+=tr("Maximum gaps per week=%1").arg(this->maxGaps); s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeacherMaxGapsPerWeek::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	int tg;
	int i, j, k;
	int totalGaps;

	totalGaps=0;
		
	i=this->teacherIndex;
	
	tg=0;
	for(j=0; j<r.nDaysPerWeek; j++){
		for(k=0; k<r.nHoursPerDay; k++)
			if(teachersMatrix[i][j][k]>0){
				assert(!breakDayHour[j][k] && !teacherNotAvailableDayHour[i][j][k]);
				break;
			}

		int cnt=0;
		for(; k<r.nHoursPerDay; k++) if(!breakDayHour[j][k] && !teacherNotAvailableDayHour[i][j][k]){
			if(teachersMatrix[i][j][k]>0){
				tg+=cnt;
				cnt=0;
			}
			else
				cnt++;
		}
	}
	if(tg>this->maxGaps){
		totalGaps+=tg-maxGaps;
		//assert(this->weightPercentage<100); partial solutions might break this rule
		if(conflictsString!=nullptr){
			QString s=tr("Time constraint teacher max gaps per week broken for teacher: %1, conflicts factor increase=%2")
				.arg(r.internalTeachersList[i]->name)
				.arg(CustomFETString::numberPlusTwoDigitsPrecision((tg-maxGaps)*weightPercentage/100));
					
			*conflictsString+= s+"\n";
						
			dl.append(s);
			cl.append((tg-maxGaps)*weightPercentage/100);
		}
	}

	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100)
			assert(totalGaps==0); //for partial solutions this rule might be broken
	return weightPercentage/100 * totalGaps;
}

bool ConstraintTeacherMaxGapsPerWeek::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeacherMaxGapsPerWeek::isRelatedToTeacher(const QString& t)
{
	if(this->teacherName==t)
		return true;
	return false;
}

bool ConstraintTeacherMaxGapsPerWeek::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMaxGapsPerWeek::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMaxGapsPerWeek::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeacherMaxGapsPerWeek::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeacherMaxGapsPerWeek::hasWrongDayOrHour(Rules& r)
{
	if(maxGaps>r.nDaysPerWeek*r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintTeacherMaxGapsPerWeek::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeacherMaxGapsPerWeek::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxGaps>r.nDaysPerWeek*r.nHoursPerDay)
		maxGaps=r.nDaysPerWeek*r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeachersMaxGapsPerDay::ConstraintTeachersMaxGapsPerDay()
	: TimeConstraint()
{
	this->type = CONSTRAINT_TEACHERS_MAX_GAPS_PER_DAY;
}

ConstraintTeachersMaxGapsPerDay::ConstraintTeachersMaxGapsPerDay(double wp, int mg)
	: TimeConstraint(wp)
{
	this->type = CONSTRAINT_TEACHERS_MAX_GAPS_PER_DAY;
	this->maxGaps=mg;
}

bool ConstraintTeachersMaxGapsPerDay::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);
	Q_UNUSED(r);
	
	return true;
}

bool ConstraintTeachersMaxGapsPerDay::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeachersMaxGapsPerDay::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeachersMaxGapsPerDay>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Max_Gaps>"+CustomFETString::number(this->maxGaps)+"</Max_Gaps>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeachersMaxGapsPerDay>\n";
	return s;
}

QString ConstraintTeachersMaxGapsPerDay::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teachers max gaps per day");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("MG:%1", "Max gaps (per day)").arg(this->maxGaps);

	return begin+s+end;
}

QString ConstraintTeachersMaxGapsPerDay::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All teachers must respect the maximum gaps per day");s+="\n";
	s+=tr("(breaks and teacher not available not counted)");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Maximum gaps per day=%1").arg(this->maxGaps); s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeachersMaxGapsPerDay::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	int tg;
	int i, j, k;
	int totalGaps;

	totalGaps=0;
	for(i=0; i<r.nInternalTeachers; i++){
		for(j=0; j<r.nDaysPerWeek; j++){
			tg=0;
			for(k=0; k<r.nHoursPerDay; k++)
				if(teachersMatrix[i][j][k]>0){
					assert(!breakDayHour[j][k] && !teacherNotAvailableDayHour[i][j][k]);
					break;
				}

			int cnt=0;
			for(; k<r.nHoursPerDay; k++) if(!breakDayHour[j][k] && !teacherNotAvailableDayHour[i][j][k]){
				if(teachersMatrix[i][j][k]>0){
					tg+=cnt;
					cnt=0;
				}
				else
					cnt++;
			}
			if(tg>this->maxGaps){
				totalGaps+=tg-maxGaps;
				//assert(this->weightPercentage<100); partial solutions might break this rule
				if(conflictsString!=nullptr){
					QString s=tr("Time constraint teachers max gaps per day broken for teacher: %1, day: %2, conflicts factor increase=%3")
						.arg(r.internalTeachersList[i]->name)
						.arg(r.daysOfTheWeek[j])
						.arg(CustomFETString::numberPlusTwoDigitsPrecision((tg-maxGaps)*weightPercentage/100));
					
					*conflictsString+= s+"\n";
					
					dl.append(s);
					cl.append((tg-maxGaps)*weightPercentage/100);
				}
			}
		}
	}
	
	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100)
			assert(totalGaps==0); //for partial solutions this rule might be broken
	return weightPercentage/100 * totalGaps;
}

bool ConstraintTeachersMaxGapsPerDay::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeachersMaxGapsPerDay::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return true;
}

bool ConstraintTeachersMaxGapsPerDay::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMaxGapsPerDay::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMaxGapsPerDay::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeachersMaxGapsPerDay::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeachersMaxGapsPerDay::hasWrongDayOrHour(Rules& r)
{
	if(maxGaps>r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintTeachersMaxGapsPerDay::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeachersMaxGapsPerDay::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxGaps>r.nHoursPerDay)
		maxGaps=r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeacherMaxGapsPerDay::ConstraintTeacherMaxGapsPerDay()
	: TimeConstraint()
{
	this->type = CONSTRAINT_TEACHER_MAX_GAPS_PER_DAY;
}

ConstraintTeacherMaxGapsPerDay::ConstraintTeacherMaxGapsPerDay(double wp, const QString& tn, int mg)
	: TimeConstraint(wp)
{
	this->type = CONSTRAINT_TEACHER_MAX_GAPS_PER_DAY;
	this->teacherName=tn;
	this->maxGaps=mg;
}

bool ConstraintTeacherMaxGapsPerDay::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);

	//this->teacherIndex=r.searchTeacher(this->teacherName);
	teacherIndex=r.teachersHash.value(teacherName, -1);
	assert(this->teacherIndex>=0);
	return true;
}

bool ConstraintTeacherMaxGapsPerDay::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeacherMaxGapsPerDay::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeacherMaxGapsPerDay>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Teacher>"+protect(this->teacherName)+"</Teacher>\n";
	s+=IL3+"<Max_Gaps>"+CustomFETString::number(this->maxGaps)+"</Max_Gaps>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeacherMaxGapsPerDay>\n";
	return s;
}

QString ConstraintTeacherMaxGapsPerDay::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teacher max gaps per day");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("T:%1", "Teacher").arg(this->teacherName); s+=translatedCommaSpace();
	s+=tr("MG:%1", "Max gaps (per day)").arg(this->maxGaps);

	return begin+s+end;
}

QString ConstraintTeacherMaxGapsPerDay::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint"); s+="\n";
	s+=tr("A teacher must respect the maximum number of gaps per day"); s+="\n";
	s+=tr("(breaks and teacher not available not counted)");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage)); s+="\n";
	s+=tr("Teacher=%1").arg(this->teacherName); s+="\n";
	s+=tr("Maximum gaps per day=%1").arg(this->maxGaps); s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeacherMaxGapsPerDay::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	int tg;
	int i, j, k;
	int totalGaps;

	totalGaps=0;
	
	i=this->teacherIndex;
	
	for(j=0; j<r.nDaysPerWeek; j++){
		tg=0;
		for(k=0; k<r.nHoursPerDay; k++)
			if(teachersMatrix[i][j][k]>0){
				assert(!breakDayHour[j][k] && !teacherNotAvailableDayHour[i][j][k]);
				break;
			}

		int cnt=0;
		for(; k<r.nHoursPerDay; k++) if(!breakDayHour[j][k] && !teacherNotAvailableDayHour[i][j][k]){
			if(teachersMatrix[i][j][k]>0){
				tg+=cnt;
				cnt=0;
			}
			else
				cnt++;
		}
		if(tg>this->maxGaps){
			totalGaps+=tg-maxGaps;
			//assert(this->weightPercentage<100); partial solutions might break this rule
			if(conflictsString!=nullptr){
				QString s=tr("Time constraint teacher max gaps per day broken for teacher: %1, day: %2, conflicts factor increase=%3")
					.arg(r.internalTeachersList[i]->name)
					.arg(r.daysOfTheWeek[j])
					.arg(CustomFETString::numberPlusTwoDigitsPrecision((tg-maxGaps)*weightPercentage/100));
				
				*conflictsString+= s+"\n";
				
				dl.append(s);
				cl.append((tg-maxGaps)*weightPercentage/100);
			}
		}
	}

	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100)
			assert(totalGaps==0); //for partial solutions this rule might be broken
	return weightPercentage/100 * totalGaps;
}

bool ConstraintTeacherMaxGapsPerDay::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeacherMaxGapsPerDay::isRelatedToTeacher(const QString& t)
{
	if(this->teacherName==t)
		return true;
	return false;
}

bool ConstraintTeacherMaxGapsPerDay::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMaxGapsPerDay::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMaxGapsPerDay::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeacherMaxGapsPerDay::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeacherMaxGapsPerDay::hasWrongDayOrHour(Rules& r)
{
	if(maxGaps>r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintTeacherMaxGapsPerDay::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeacherMaxGapsPerDay::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxGaps>r.nHoursPerDay)
		maxGaps=r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeachersMaxGapsPerMorningAndAfternoon::ConstraintTeachersMaxGapsPerMorningAndAfternoon()
	: TimeConstraint()
{
	this->type = CONSTRAINT_TEACHERS_MAX_GAPS_PER_MORNING_AND_AFTERNOON;
}

ConstraintTeachersMaxGapsPerMorningAndAfternoon::ConstraintTeachersMaxGapsPerMorningAndAfternoon(double wp, int mg)
	: TimeConstraint(wp)
{
	this->type = CONSTRAINT_TEACHERS_MAX_GAPS_PER_MORNING_AND_AFTERNOON;
	this->maxGaps=mg;
}

bool ConstraintTeachersMaxGapsPerMorningAndAfternoon::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);
	Q_UNUSED(r);
	
	return true;
}

bool ConstraintTeachersMaxGapsPerMorningAndAfternoon::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeachersMaxGapsPerMorningAndAfternoon::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeachersMaxGapsPerMorningAndAfternoon>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Max_Gaps>"+CustomFETString::number(this->maxGaps)+"</Max_Gaps>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeachersMaxGapsPerMorningAndAfternoon>\n";
	return s;
}

QString ConstraintTeachersMaxGapsPerMorningAndAfternoon::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teachers max gaps per morning and afternoon");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("MG:%1", "Max gaps (per morning and afternoon)").arg(this->maxGaps);

	return begin+s+end;
}

QString ConstraintTeachersMaxGapsPerMorningAndAfternoon::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All teachers must respect the maximum gaps per morning and afternoon");s+="\n";
	s+=tr("(breaks and teacher not available not counted)");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Maximum gaps per morning and afternoon=%1").arg(this->maxGaps); s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeachersMaxGapsPerMorningAndAfternoon::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	int tg;
	int i, j, k;
	int totalGaps;

	totalGaps=0;
	for(i=0; i<r.nInternalTeachers; i++){
		for(j=0; j<r.nDaysPerWeek/2; j++){
			tg=0;
			for(k=0; k<r.nHoursPerDay; k++)
				if(teachersMatrix[i][2*j][k]>0){
					assert(!breakDayHour[2*j][k] && !teacherNotAvailableDayHour[i][2*j][k]);
					break;
				}

			int cnt=0;
			for(; k<r.nHoursPerDay; k++) if(!breakDayHour[2*j][k] && !teacherNotAvailableDayHour[i][2*j][k]){
				if(teachersMatrix[i][2*j][k]>0){
					tg+=cnt;
					cnt=0;
				}
				else
					cnt++;
			}

			for(k=0; k<r.nHoursPerDay; k++)
				if(teachersMatrix[i][2*j+1][k]>0){
					assert(!breakDayHour[2*j+1][k] && !teacherNotAvailableDayHour[i][2*j+1][k]);
					break;
				}

			cnt=0;
			for(; k<r.nHoursPerDay; k++) if(!breakDayHour[2*j+1][k] && !teacherNotAvailableDayHour[i][2*j+1][k]){
				if(teachersMatrix[i][2*j+1][k]>0){
					tg+=cnt;
					cnt=0;
				}
				else
					cnt++;
			}

			if(tg>this->maxGaps){
				totalGaps+=tg-maxGaps;
				//assert(this->weightPercentage<100); partial solutions might break this rule
				if(conflictsString!=nullptr){
					QString s=tr("Time constraint teachers max gaps per morning and afternoon broken for teacher: %1, real day number: %2, conflicts factor increase=%3")
						.arg(r.internalTeachersList[i]->name)
						.arg(j)
						.arg(CustomFETString::numberPlusTwoDigitsPrecision((tg-maxGaps)*weightPercentage/100));
					
					*conflictsString+= s+"\n";
					
					dl.append(s);
					cl.append((tg-maxGaps)*weightPercentage/100);
				}
			}
		}
	}
	
	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100)
			assert(totalGaps==0); //for partial solutions this rule might be broken
	return weightPercentage/100 * totalGaps;
}

bool ConstraintTeachersMaxGapsPerMorningAndAfternoon::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeachersMaxGapsPerMorningAndAfternoon::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return true;
}

bool ConstraintTeachersMaxGapsPerMorningAndAfternoon::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMaxGapsPerMorningAndAfternoon::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMaxGapsPerMorningAndAfternoon::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeachersMaxGapsPerMorningAndAfternoon::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeachersMaxGapsPerMorningAndAfternoon::hasWrongDayOrHour(Rules& r)
{
	if(maxGaps>2*r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintTeachersMaxGapsPerMorningAndAfternoon::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeachersMaxGapsPerMorningAndAfternoon::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxGaps>2*r.nHoursPerDay)
		maxGaps=2*r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeacherMaxGapsPerMorningAndAfternoon::ConstraintTeacherMaxGapsPerMorningAndAfternoon()
	: TimeConstraint()
{
	this->type = CONSTRAINT_TEACHER_MAX_GAPS_PER_MORNING_AND_AFTERNOON;
}

ConstraintTeacherMaxGapsPerMorningAndAfternoon::ConstraintTeacherMaxGapsPerMorningAndAfternoon(double wp, const QString& tn, int mg)
	: TimeConstraint(wp)
{
	this->type = CONSTRAINT_TEACHER_MAX_GAPS_PER_MORNING_AND_AFTERNOON;
	this->teacherName=tn;
	this->maxGaps=mg;
}

bool ConstraintTeacherMaxGapsPerMorningAndAfternoon::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);

	//this->teacherIndex=r.searchTeacher(this->teacherName);
	teacherIndex=r.teachersHash.value(teacherName, -1);
	assert(this->teacherIndex>=0);
	return true;
}

bool ConstraintTeacherMaxGapsPerMorningAndAfternoon::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeacherMaxGapsPerMorningAndAfternoon::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeacherMaxGapsPerMorningAndAfternoon>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Teacher>"+protect(this->teacherName)+"</Teacher>\n";
	s+=IL3+"<Max_Gaps>"+CustomFETString::number(this->maxGaps)+"</Max_Gaps>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeacherMaxGapsPerMorningAndAfternoon>\n";
	return s;
}

QString ConstraintTeacherMaxGapsPerMorningAndAfternoon::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teacher max gaps per morning and afternoon");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("T:%1", "Teacher").arg(this->teacherName); s+=translatedCommaSpace();
	s+=tr("MG:%1", "Max gaps (per morning and afternoon)").arg(this->maxGaps);

	return begin+s+end;
}

QString ConstraintTeacherMaxGapsPerMorningAndAfternoon::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint"); s+="\n";
	s+=tr("A teacher must respect the maximum number of gaps per morning and afternoon"); s+="\n";
	s+=tr("(breaks and teacher not available not counted)");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage)); s+="\n";
	s+=tr("Teacher=%1").arg(this->teacherName); s+="\n";
	s+=tr("Maximum gaps per morning and afternoon=%1").arg(this->maxGaps); s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeacherMaxGapsPerMorningAndAfternoon::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	int tg;
	int i, j, k;
	int totalGaps;

	totalGaps=0;
	
	i=this->teacherIndex;
	
	for(j=0; j<r.nDaysPerWeek/2; j++){
		tg=0;
		for(k=0; k<r.nHoursPerDay; k++)
			if(teachersMatrix[i][2*j][k]>0){
				assert(!breakDayHour[2*j][k] && !teacherNotAvailableDayHour[i][2*j][k]);
				break;
			}

		int cnt=0;
		for(; k<r.nHoursPerDay; k++) if(!breakDayHour[2*j][k] && !teacherNotAvailableDayHour[i][2*j][k]){
			if(teachersMatrix[i][2*j][k]>0){
				tg+=cnt;
				cnt=0;
			}
			else
				cnt++;
		}
		
		for(k=0; k<r.nHoursPerDay; k++)
			if(teachersMatrix[i][2*j+1][k]>0){
				assert(!breakDayHour[2*j+1][k] && !teacherNotAvailableDayHour[i][2*j+1][k]);
				break;
			}

		cnt=0;
		for(; k<r.nHoursPerDay; k++) if(!breakDayHour[2*j+1][k] && !teacherNotAvailableDayHour[i][2*j+1][k]){
			if(teachersMatrix[i][2*j+1][k]>0){
				tg+=cnt;
				cnt=0;
			}
			else
				cnt++;
		}
		
		if(tg>this->maxGaps){
			totalGaps+=tg-maxGaps;
			//assert(this->weightPercentage<100); partial solutions might break this rule
			if(conflictsString!=nullptr){
				QString s=tr("Time constraint teacher max gaps per morning and afternoon broken for teacher: %1, real day number: %2, conflicts factor increase=%3")
					.arg(r.internalTeachersList[i]->name)
					.arg(j)
					.arg(CustomFETString::numberPlusTwoDigitsPrecision((tg-maxGaps)*weightPercentage/100));
				
				*conflictsString+= s+"\n";
				
				dl.append(s);
				cl.append((tg-maxGaps)*weightPercentage/100);
			}
		}
	}

	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100)
			assert(totalGaps==0); //for partial solutions this rule might be broken
	return weightPercentage/100 * totalGaps;
}

bool ConstraintTeacherMaxGapsPerMorningAndAfternoon::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeacherMaxGapsPerMorningAndAfternoon::isRelatedToTeacher(const QString& t)
{
	if(this->teacherName==t)
		return true;
	return false;
}

bool ConstraintTeacherMaxGapsPerMorningAndAfternoon::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMaxGapsPerMorningAndAfternoon::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMaxGapsPerMorningAndAfternoon::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeacherMaxGapsPerMorningAndAfternoon::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeacherMaxGapsPerMorningAndAfternoon::hasWrongDayOrHour(Rules& r)
{
	if(maxGaps>2*r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintTeacherMaxGapsPerMorningAndAfternoon::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeacherMaxGapsPerMorningAndAfternoon::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxGaps>2*r.nHoursPerDay)
		maxGaps=2*r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintBreakTimes::ConstraintBreakTimes()
	: TimeConstraint()
{
	this->type = CONSTRAINT_BREAK_TIMES;
}

ConstraintBreakTimes::ConstraintBreakTimes(double wp, const QList<int>& d, const QList<int>& h)
	: TimeConstraint(wp)
{
	this->days = d;
	this->hours = h;
	this->type = CONSTRAINT_BREAK_TIMES;
}

bool ConstraintBreakTimes::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintBreakTimes::getXmlDescription(Rules& r)
{
	QString s=IL2+"<ConstraintBreakTimes>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";

	s+=IL3+"<Number_of_Break_Times>"+QString::number(this->days.count())+"</Number_of_Break_Times>\n";
	assert(days.count()==hours.count());
	for(int i=0; i<days.count(); i++){
		s+=IL3+"<Break_Time>\n";
		if(this->days.at(i)>=0)
			s+=IL4+"<Day>"+protect(r.daysOfTheWeek[this->days.at(i)])+"</Day>\n";
		if(this->hours.at(i)>=0)
			s+=IL4+"<Hour>"+protect(r.hoursOfTheDay[this->hours.at(i)])+"</Hour>\n";
		s+=IL3+"</Break_Time>\n";
	}

	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintBreakTimes>\n";
	return s;
}

QString ConstraintBreakTimes::getDescription(Rules& r)
{
	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Break times");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();

	s+=tr("B at:", "Break at");
	s+=" ";
	assert(days.count()==hours.count());
	for(int i=0; i<days.count(); i++){
		if(this->days.at(i)>=0){
			s+=r.daysOfTheWeek[this->days.at(i)];
			s+=" ";
		}
		if(this->hours.at(i)>=0){
			s+=r.hoursOfTheDay[this->hours.at(i)];
		}
		if(i<days.count()-1)
			s+=translatedSemicolonSpace();
	}
	
	return begin+s+end;
}

QString ConstraintBreakTimes::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	if(!richText){
		QString s=tr("Time constraint");s+="\n";
		s+=tr("Break times");s+="\n";
		s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";

		s+=tr("Break at:"); s+="\n";
		assert(days.count()==hours.count());
		for(int i=0; i<days.count(); i++){
			if(this->days.at(i)>=0){
				s+=r.daysOfTheWeek[this->days.at(i)];
				s+=" ";
			}
			if(this->hours.at(i)>=0){
				s+=r.hoursOfTheDay[this->hours.at(i)];
			}
			if(i<days.count()-1)
				s+=translatedSemicolonSpace();
		}
		s+="\n";

		if(!active){
			s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			s+="\n";
		}
		if(!comments.isEmpty()){
			s+=tr("Comments=%1").arg(comments);
			s+="\n";
		}
		
		return s;
	}
	else{
		QString begin=tr("Time constraint");begin+="\n";
		begin+=tr("Break times");begin+="\n";
		begin+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));begin+="\n";

		begin+=tr("Break at:"); begin+="\n";

		//the first Boolean is 'direct', the second Boolean is 'not available/selected', the third Boolean is 'color'.
		QString middle=listsOfDaysAndHoursToTable(r, days, hours, true, true, colors);
		QString end;
		end+="\n";

		if(!active){
			end+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			end+="\n";
		}
		if(!comments.isEmpty()){
			end+=tr("Comments=%1").arg(comments);
			end+="\n";
		}
		
		return protect4(begin)+middle+protect4(end);
	}
}

bool ConstraintBreakTimes::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(r);
	
	assert(days.count()==hours.count());
	for(int k=0; k<days.count(); k++){
		if(this->days.at(k) >= r.nDaysPerWeek){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint break times is wrong because it refers to removed day. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->hours.at(k) >= r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint break times is wrong because an hour is too late (after the last acceptable slot). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
	}

	return true;
}

double ConstraintBreakTimes::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	//DEPRECATED COMMENT
	//For the moment, this function sums the number of hours each teacher
	//is teaching in this break period.
	//This function consideres all the hours, I mean if there are for example 5 weekly courses
	//scheduled on that hour (which is already a broken hard restriction - we only
	//are allowed 1 weekly course for a certain teacher at a certain hour) we calculate
	//5 broken restrictions for this break period.
	//TODO: decide if it is better to consider only 2 or 10 as a return value in this particular case
	//(currently it is 10)
	
	int nbroken;
	
	nbroken=0;
		
	for(int i=0; i<r.nInternalActivities; i++){
		int dayact=c.times[i]%r.nDaysPerWeek;
		int houract=c.times[i]/r.nDaysPerWeek;
		
		assert(days.count()==hours.count());
		for(int kk=0; kk<days.count(); kk++){
			int d=days.at(kk);
			int h=hours.at(kk);
			
			int dur=r.internalActivitiesList[i].duration;
			if(d==dayact && !(houract+dur<=h || houract>h))
			{			
				nbroken++;

				if(conflictsString!=nullptr){
					QString s=tr("Time constraint break not respected for activity with id %1, on day %2, hour %3")
						.arg(r.internalActivitiesList[i].id)
						.arg(r.daysOfTheWeek[dayact])
						.arg(r.hoursOfTheDay[houract]);
					s+=". ";
					s+=tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100));
					
					dl.append(s);
					cl.append(weightPercentage/100);
				
					*conflictsString+= s+"\n";
				}
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintBreakTimes::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintBreakTimes::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintBreakTimes::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintBreakTimes::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintBreakTimes::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintBreakTimes::categoryOfTimeConstraint()
{
	return IS_BREAK_TIME_CONSTRAINT;
}

bool ConstraintBreakTimes::hasWrongDayOrHour(Rules& r)
{
	assert(days.count()==hours.count());
	
	for(int i=0; i<days.count(); i++)
		if(days.at(i)<0 || days.at(i)>=r.nDaysPerWeek
		 || hours.at(i)<0 || hours.at(i)>=r.nHoursPerDay)
			return true;

	return false;
}

bool ConstraintBreakTimes::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintBreakTimes::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	assert(days.count()==hours.count());
	
	QList<int> newDays;
	QList<int> newHours;
	
	for(int i=0; i<days.count(); i++)
		if(days.at(i)>=0 && days.at(i)<r.nDaysPerWeek
		 && hours.at(i)>=0 && hours.at(i)<r.nHoursPerDay){
			newDays.append(days.at(i));
			newHours.append(hours.at(i));
		}
	
	days=newDays;
	hours=newHours;
	
	r.internalStructureComputed=false;
	setRulesModifiedAndOtherThings(&r);

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsMaxGapsPerWeek::ConstraintStudentsMaxGapsPerWeek()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_MAX_GAPS_PER_WEEK;
}

ConstraintStudentsMaxGapsPerWeek::ConstraintStudentsMaxGapsPerWeek(double wp, int mg)
	: TimeConstraint(wp)
{
	this->type = CONSTRAINT_STUDENTS_MAX_GAPS_PER_WEEK;
	this->maxGaps=mg;
}

bool ConstraintStudentsMaxGapsPerWeek::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);
	Q_UNUSED(r);
	
	return true;
}

bool ConstraintStudentsMaxGapsPerWeek::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsMaxGapsPerWeek::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsMaxGapsPerWeek>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Max_Gaps>"+CustomFETString::number(this->maxGaps)+"</Max_Gaps>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsMaxGapsPerWeek>\n";
	return s;
}

QString ConstraintStudentsMaxGapsPerWeek::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Students max gaps per week");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("MG:%1", "Max gaps (per week)").arg(this->maxGaps);

	return begin+s+end;
}

QString ConstraintStudentsMaxGapsPerWeek::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All students must respect the maximum number of gaps per week");s+="\n";
	s+=tr("(breaks and students set not available not counted)");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Maximum gaps per week=%1").arg(this->maxGaps);s+="\n";
	
	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintStudentsMaxGapsPerWeek::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//returns a number equal to the number of gaps of the subgroups (in hours)

	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);
		
		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nGaps;
	int tmp;
	int i;
	
	int tIllegalGaps=0;

	for(i=0; i<r.nInternalSubgroups; i++){
		nGaps=0;
		for(int j=0; j<r.nDaysPerWeek; j++){
			int k;
			tmp=0;
			for(k=0; k<r.nHoursPerDay; k++)
				if(subgroupsMatrix[i][j][k]>0){
					assert(!breakDayHour[j][k] && !subgroupNotAvailableDayHour[i][j][k]);
					break;
				}
			for(; k<r.nHoursPerDay; k++) if(!breakDayHour[j][k] && !subgroupNotAvailableDayHour[i][j][k]){
				if(subgroupsMatrix[i][j][k]>0){
					nGaps+=tmp;
					tmp=0;
				}
				else
					tmp++;
			}
		}
		
		int illegalGaps=nGaps-this->maxGaps;
		if(illegalGaps<0)
			illegalGaps=0;

		if(illegalGaps>0 && conflictsString!=nullptr){
			QString s=tr("Time constraint students max gaps per week broken for subgroup: %1, it has %2 extra gaps, conflicts increase=%3")
			 .arg(r.internalSubgroupsList[i]->name)
			 .arg(illegalGaps)
			 .arg(CustomFETString::numberPlusTwoDigitsPrecision(illegalGaps*weightPercentage/100));
			
			dl.append(s);
			cl.append(illegalGaps*weightPercentage/100);
			
			*conflictsString+= s+"\n";
		}
		
		tIllegalGaps+=illegalGaps;
	}
		
	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100)    //for partial solutions it might be broken
			assert(tIllegalGaps==0);
	return weightPercentage/100 * tIllegalGaps;
}

bool ConstraintStudentsMaxGapsPerWeek::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsMaxGapsPerWeek::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsMaxGapsPerWeek::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsMaxGapsPerWeek::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsMaxGapsPerWeek::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return true;
}

int ConstraintStudentsMaxGapsPerWeek::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsMaxGapsPerWeek::hasWrongDayOrHour(Rules& r)
{
	if(maxGaps>r.nDaysPerWeek*r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintStudentsMaxGapsPerWeek::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsMaxGapsPerWeek::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxGaps>r.nDaysPerWeek*r.nHoursPerDay)
		maxGaps=r.nDaysPerWeek*r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsSetMaxGapsPerWeek::ConstraintStudentsSetMaxGapsPerWeek()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_WEEK;
}

ConstraintStudentsSetMaxGapsPerWeek::ConstraintStudentsSetMaxGapsPerWeek(double wp, int mg, const QString& st )
	: TimeConstraint(wp)
{
	this->type = CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_WEEK;
	this->maxGaps=mg;
	this->students = st;
}

bool ConstraintStudentsSetMaxGapsPerWeek::computeInternalStructure(QWidget* parent, Rules& r){
	//StudentsSet* ss=r.searchAugmentedStudentsSet(this->students);
	StudentsSet* ss=r.studentsHash.value(students, nullptr);

	if(ss==nullptr){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students set max gaps per week is wrong because it refers to nonexistent students set."
		 " Please correct it (removing it might be a solution). Please report potential bug. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
		return false;
	}

	assert(ss!=nullptr);

	populateInternalSubgroupsList(r, ss, this->iSubgroupsList);
	/*this->iSubgroupsList.clear();
	if(ss->type==STUDENTS_SUBGROUP){
		int tmp;
		tmp=((StudentsSubgroup*)ss)->indexInInternalSubgroupsList;
		assert(tmp>=0);
		assert(tmp<r.nInternalSubgroups);
		if(!this->iSubgroupsList.contains(tmp))
			this->iSubgroupsList.append(tmp);
	}
	else if(ss->type==STUDENTS_GROUP){
		StudentsGroup* stg=(StudentsGroup*)ss;
		for(int i=0; i<stg->subgroupsList.size(); i++){
			StudentsSubgroup* sts=stg->subgroupsList[i];
			int tmp;
			tmp=sts->indexInInternalSubgroupsList;
			assert(tmp>=0);
			assert(tmp<r.nInternalSubgroups);
			if(!this->iSubgroupsList.contains(tmp))
				this->iSubgroupsList.append(tmp);
		}
	}
	else if(ss->type==STUDENTS_YEAR){
		StudentsYear* sty=(StudentsYear*)ss;
		for(int i=0; i<sty->groupsList.size(); i++){
			StudentsGroup* stg=sty->groupsList[i];
			for(int j=0; j<stg->subgroupsList.size(); j++){
				StudentsSubgroup* sts=stg->subgroupsList[j];
				int tmp;
				tmp=sts->indexInInternalSubgroupsList;
				assert(tmp>=0);
				assert(tmp<r.nInternalSubgroups);
				if(!this->iSubgroupsList.contains(tmp))
					this->iSubgroupsList.append(tmp);
			}
		}
	}
	else
		assert(0);*/
		
	return true;
}

bool ConstraintStudentsSetMaxGapsPerWeek::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsSetMaxGapsPerWeek::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsSetMaxGapsPerWeek>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Max_Gaps>"+CustomFETString::number(this->maxGaps)+"</Max_Gaps>\n";
	s+=IL3+"<Students>"+protect(this->students)+"</Students>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsSetMaxGapsPerWeek>\n";
	return s;
}

QString ConstraintStudentsSetMaxGapsPerWeek::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Students set max gaps per week"); s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage)); s+=translatedCommaSpace();
	s+=tr("MG:%1", "Max gaps (per week)").arg(this->maxGaps);s+=translatedCommaSpace();
	s+=tr("St:%1", "Students").arg(this->students);

	return begin+s+end;
}

QString ConstraintStudentsSetMaxGapsPerWeek::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A students set must respect the maximum number of gaps per week");s+="\n";
	s+=tr("(breaks and students set not available not counted)");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Maximum gaps per week=%1").arg(this->maxGaps);s+="\n";
	s+=tr("Students=%1").arg(this->students); s+="\n";
	
	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}
	
	return richText?protect4(s):s;
}

double ConstraintStudentsSetMaxGapsPerWeek::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//OLD COMMENT
	//returns a number equal to the number of gaps of the subgroups (in hours)

	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	int nGaps;
	int tmp;
	
	int tIllegalGaps=0;
	
	for(int sg=0; sg<this->iSubgroupsList.count(); sg++){
		nGaps=0;
		int i=this->iSubgroupsList.at(sg);
		for(int j=0; j<r.nDaysPerWeek; j++){
			int k;
			tmp=0;
			for(k=0; k<r.nHoursPerDay; k++)
				if(subgroupsMatrix[i][j][k]>0){
					assert(!breakDayHour[j][k] && !subgroupNotAvailableDayHour[i][j][k]);
					break;
				}
			for(; k<r.nHoursPerDay; k++) if(!breakDayHour[j][k] && !subgroupNotAvailableDayHour[i][j][k]){
				if(subgroupsMatrix[i][j][k]>0){
					nGaps+=tmp;
					tmp=0;
				}
				else
					tmp++;
			}
		}
		
		int illegalGaps=nGaps-this->maxGaps;
		if(illegalGaps<0)
			illegalGaps=0;

		if(illegalGaps>0 && conflictsString!=nullptr){
			QString s=tr("Time constraint students set max gaps per week broken for subgroup: %1, extra gaps=%2, conflicts increase=%3")
			 .arg(r.internalSubgroupsList[i]->name)
			 .arg(illegalGaps)
			 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*illegalGaps));
			
			dl.append(s);
			cl.append(weightPercentage/100*illegalGaps);
			
			*conflictsString+= s+"\n";
		}
		
		tIllegalGaps+=illegalGaps;
	}

	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100)     //for partial solutions it might be broken
			assert(tIllegalGaps==0);
	return weightPercentage/100 * tIllegalGaps;
}

bool ConstraintStudentsSetMaxGapsPerWeek::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsSetMaxGapsPerWeek::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsSetMaxGapsPerWeek::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetMaxGapsPerWeek::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetMaxGapsPerWeek::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	return r.setsShareStudents(this->students, s);
}

int ConstraintStudentsSetMaxGapsPerWeek::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsSetMaxGapsPerWeek::hasWrongDayOrHour(Rules& r)
{
	if(maxGaps>r.nDaysPerWeek*r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintStudentsSetMaxGapsPerWeek::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsSetMaxGapsPerWeek::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxGaps>r.nDaysPerWeek*r.nHoursPerDay)
		maxGaps=r.nDaysPerWeek*r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsEarlyMaxBeginningsAtSecondHour::ConstraintStudentsEarlyMaxBeginningsAtSecondHour()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR;
}

ConstraintStudentsEarlyMaxBeginningsAtSecondHour::ConstraintStudentsEarlyMaxBeginningsAtSecondHour(double wp, int mBSH)
	: TimeConstraint(wp)
{
	this->type = CONSTRAINT_STUDENTS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR;
	this->maxBeginningsAtSecondHour=mBSH;
}

bool ConstraintStudentsEarlyMaxBeginningsAtSecondHour::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);
	Q_UNUSED(r);
	
	return true;
}

bool ConstraintStudentsEarlyMaxBeginningsAtSecondHour::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsEarlyMaxBeginningsAtSecondHour::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsEarlyMaxBeginningsAtSecondHour>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Max_Beginnings_At_Second_Hour>"+CustomFETString::number(this->maxBeginningsAtSecondHour)+"</Max_Beginnings_At_Second_Hour>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsEarlyMaxBeginningsAtSecondHour>\n";
	return s;
}

QString ConstraintStudentsEarlyMaxBeginningsAtSecondHour::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Students must begin early, respecting maximum %1 beginnings at second hour")
	 .arg(this->maxBeginningsAtSecondHour);
	s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintStudentsEarlyMaxBeginningsAtSecondHour::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All students must begin their activities early, respecting maximum %1 later beginnings, at second hour")
	 .arg(this->maxBeginningsAtSecondHour);s+="\n";
	s+=tr("(breaks and students set not available not counted)");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintStudentsEarlyMaxBeginningsAtSecondHour::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//considers the condition that the hours of subgroups begin as early as possible

	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	int conflTotal=0;
	
	for(int i=0; i<r.nInternalSubgroups; i++){
		int nGapsFirstHour=0;
		for(int j=0; j<r.nDaysPerWeek; j++){
			int k;
			for(k=0; k<r.nHoursPerDay; k++)
				if(!breakDayHour[j][k] && !subgroupNotAvailableDayHour[i][j][k])
					break;
			
			bool firstHourOccupied=false;
			if(k<r.nHoursPerDay)
				if(subgroupsMatrix[i][j][k]>0)
					firstHourOccupied=true;
			
			bool dayOccupied=firstHourOccupied;
			
			bool illegalGap=false;
			
			if(!dayOccupied){
				for(k++; k<r.nHoursPerDay; k++){
					if(!breakDayHour[j][k] && !subgroupNotAvailableDayHour[i][j][k]){
						if(subgroupsMatrix[i][j][k]>0){
							dayOccupied=true;
							break;
						}
						else{
							illegalGap=true;
						}
					}
				}
			}
			
			if(dayOccupied && illegalGap){
				if(conflictsString!=nullptr){
					QString s=tr("Constraint students early max %1 beginnings at second hour broken for subgroup %2, on day %3,"
					 " because students have an illegal gap, increases conflicts total by %4")
					 .arg(this->maxBeginningsAtSecondHour)
					 .arg(r.internalSubgroupsList[i]->name)
					 .arg(r.daysOfTheWeek[j])
					 .arg(CustomFETString::numberPlusTwoDigitsPrecision(1*weightPercentage/100));
					
					dl.append(s);
					cl.append(1*weightPercentage/100);
					
					*conflictsString+= s+"\n";
					
					conflTotal+=1;
				}
				
				if(c.nPlacedActivities==r.nInternalActivities){
					assert(0);
				}
			}
			
			if(dayOccupied && !firstHourOccupied)
				nGapsFirstHour++;
		}
		
		if(nGapsFirstHour>this->maxBeginningsAtSecondHour){
			if(conflictsString!=nullptr){
				QString s=tr("Constraint students early max %1 beginnings at second hour broken for subgroup %2,"
				 " because students have too many beginnings at second hour, increases conflicts total by %3")
				 .arg(this->maxBeginningsAtSecondHour)
				 .arg(r.internalSubgroupsList[i]->name)
				 .arg(CustomFETString::numberPlusTwoDigitsPrecision((nGapsFirstHour-this->maxBeginningsAtSecondHour)*weightPercentage/100));
				
				dl.append(s);
				cl.append((nGapsFirstHour-this->maxBeginningsAtSecondHour)*weightPercentage/100);
				
				*conflictsString+= s+"\n";
				
				conflTotal+=(nGapsFirstHour-this->maxBeginningsAtSecondHour);
			}
			
			if(c.nPlacedActivities==r.nInternalActivities){
				assert(0);
			}
		}
	}
	
	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100)    //might be broken for partial solutions
			assert(conflTotal==0);
	return weightPercentage/100 * conflTotal;
}

bool ConstraintStudentsEarlyMaxBeginningsAtSecondHour::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsEarlyMaxBeginningsAtSecondHour::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsEarlyMaxBeginningsAtSecondHour::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsEarlyMaxBeginningsAtSecondHour::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsEarlyMaxBeginningsAtSecondHour::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return true;
}

int ConstraintStudentsEarlyMaxBeginningsAtSecondHour::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsEarlyMaxBeginningsAtSecondHour::hasWrongDayOrHour(Rules& r)
{
	if(maxBeginningsAtSecondHour>r.nDaysPerWeek)
		return true;
	
	return false;
}

bool ConstraintStudentsEarlyMaxBeginningsAtSecondHour::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsEarlyMaxBeginningsAtSecondHour::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxBeginningsAtSecondHour>r.nDaysPerWeek)
		maxBeginningsAtSecondHour=r.nDaysPerWeek;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour::ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_SET_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR;
}

ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour::ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour(double wp, int mBSH, const QString& students)
	: TimeConstraint(wp)
{
	this->type = CONSTRAINT_STUDENTS_SET_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR;
	this->students=students;
	this->maxBeginningsAtSecondHour=mBSH;
}

bool ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour::computeInternalStructure(QWidget* parent, Rules& r)
{
	//StudentsSet* ss=r.searchAugmentedStudentsSet(this->students);
	StudentsSet* ss=r.studentsHash.value(students, nullptr);

	if(ss==nullptr){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students set early is wrong because it refers to nonexistent students set."
		 " Please correct it (removing it might be a solution). Please report potential bug. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
		return false;
	}

	assert(ss!=nullptr);

	populateInternalSubgroupsList(r, ss, this->iSubgroupsList);
	/*this->iSubgroupsList.clear();
	if(ss->type==STUDENTS_SUBGROUP){
		int tmp;
		tmp=((StudentsSubgroup*)ss)->indexInInternalSubgroupsList;
		assert(tmp>=0);
		assert(tmp<r.nInternalSubgroups);
		if(!this->iSubgroupsList.contains(tmp))
			this->iSubgroupsList.append(tmp);
	}
	else if(ss->type==STUDENTS_GROUP){
		StudentsGroup* stg=(StudentsGroup*)ss;
		for(int i=0; i<stg->subgroupsList.size(); i++){
			StudentsSubgroup* sts=stg->subgroupsList[i];
			int tmp;
			tmp=sts->indexInInternalSubgroupsList;
			assert(tmp>=0);
			assert(tmp<r.nInternalSubgroups);
			if(!this->iSubgroupsList.contains(tmp))
				this->iSubgroupsList.append(tmp);
		}
	}
	else if(ss->type==STUDENTS_YEAR){
		StudentsYear* sty=(StudentsYear*)ss;
		for(int i=0; i<sty->groupsList.size(); i++){
			StudentsGroup* stg=sty->groupsList[i];
			for(int j=0; j<stg->subgroupsList.size(); j++){
				StudentsSubgroup* sts=stg->subgroupsList[j];
				int tmp;
				tmp=sts->indexInInternalSubgroupsList;
				assert(tmp>=0);
				assert(tmp<r.nInternalSubgroups);
				if(!this->iSubgroupsList.contains(tmp))
					this->iSubgroupsList.append(tmp);
			}
		}
	}
	else
		assert(0);*/
	return true;
}

bool ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Max_Beginnings_At_Second_Hour>"+CustomFETString::number(this->maxBeginningsAtSecondHour)+"</Max_Beginnings_At_Second_Hour>\n";
	s+=IL3+"<Students>"+protect(this->students)+"</Students>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour>\n";
	return s;
}

QString ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;

	s+=tr("Students set must begin early, respecting maximum %1 beginnings at second hour")
	 .arg(this->maxBeginningsAtSecondHour); s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("St:%1", "Students set").arg(this->students);

	return begin+s+end;
}

QString ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";

	s+=tr("A students set must begin its activities early, respecting a maximum number of later beginnings, at second hour"); s+="\n";
	s+=tr("(breaks and students set not available not counted)");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Students set=%1").arg(this->students); s+="\n";
	s+=tr("Maximum number of beginnings at the second hour=%1").arg(this->maxBeginningsAtSecondHour);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//considers the condition that the hours of subgroups begin as early as possible

	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	int conflTotal=0;

	for(int i : std::as_const(this->iSubgroupsList)){
		int nGapsFirstHour=0;
		for(int j=0; j<r.nDaysPerWeek; j++){
			int k;
			for(k=0; k<r.nHoursPerDay; k++)
				if(!breakDayHour[j][k] && !subgroupNotAvailableDayHour[i][j][k])
					break;
			
			bool firstHourOccupied=false;
			if(k<r.nHoursPerDay)
				if(subgroupsMatrix[i][j][k]>0)
					firstHourOccupied=true;
			
			bool dayOccupied=firstHourOccupied;
			
			bool illegalGap=false;
			
			if(!dayOccupied){
				for(k++; k<r.nHoursPerDay; k++){
					if(!breakDayHour[j][k] && !subgroupNotAvailableDayHour[i][j][k]){
						if(subgroupsMatrix[i][j][k]>0){
							dayOccupied=true;
							break;
						}
						else{
							illegalGap=true;
						}
					}
				}
			}
			
			if(dayOccupied && illegalGap){
				if(conflictsString!=nullptr){
					QString s=tr("Constraint students set early max %1 beginnings at second hour broken for subgroup %2, on day %3,"
					 " because students have an illegal gap, increases conflicts total by %4")
					 .arg(this->maxBeginningsAtSecondHour)
					 .arg(r.internalSubgroupsList[i]->name)
					 .arg(r.daysOfTheWeek[j])
					 .arg(CustomFETString::numberPlusTwoDigitsPrecision(1*weightPercentage/100));
					
					dl.append(s);
					cl.append(1*weightPercentage/100);
					
					*conflictsString+= s+"\n";
					
					conflTotal+=1;
				}
				
				if(c.nPlacedActivities==r.nInternalActivities)
					assert(0);
			}
			
			if(dayOccupied && !firstHourOccupied)
				nGapsFirstHour++;
		}
		
		if(nGapsFirstHour>this->maxBeginningsAtSecondHour){
			if(conflictsString!=nullptr){
				QString s=tr("Constraint students set early max %1 beginnings at second hour broken for subgroup %2,"
				 " because students have too many beginnings at second hour, increases conflicts total by %3")
				 .arg(this->maxBeginningsAtSecondHour)
				 .arg(r.internalSubgroupsList[i]->name)
				 .arg(CustomFETString::numberPlusTwoDigitsPrecision((nGapsFirstHour-this->maxBeginningsAtSecondHour)*weightPercentage/100));
				
				dl.append(s);
				cl.append((nGapsFirstHour-this->maxBeginningsAtSecondHour)*weightPercentage/100);
				
				*conflictsString+= s+"\n";
				
				conflTotal+=(nGapsFirstHour-this->maxBeginningsAtSecondHour);
			}
			
			if(c.nPlacedActivities==r.nInternalActivities)
				assert(0);
		}
	}
	
	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100)    //might be broken for partial solutions
			assert(conflTotal==0);
	return weightPercentage/100 * conflTotal;
}

bool ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	return r.setsShareStudents(this->students, s);
}

int ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour::hasWrongDayOrHour(Rules& r)
{
	if(maxBeginningsAtSecondHour>r.nDaysPerWeek)
		return true;
	
	return false;
}

bool ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxBeginningsAtSecondHour>r.nDaysPerWeek)
		maxBeginningsAtSecondHour=r.nDaysPerWeek;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsMaxHoursDaily::ConstraintStudentsMaxHoursDaily()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_MAX_HOURS_DAILY;
	this->maxHoursDaily = -1;
}

ConstraintStudentsMaxHoursDaily::ConstraintStudentsMaxHoursDaily(double wp, int maxnh)
	: TimeConstraint(wp)
{
	this->maxHoursDaily = maxnh;
	this->type = CONSTRAINT_STUDENTS_MAX_HOURS_DAILY;
}

bool ConstraintStudentsMaxHoursDaily::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);
	Q_UNUSED(r);
	
	return true;
}

bool ConstraintStudentsMaxHoursDaily::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsMaxHoursDaily::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsMaxHoursDaily>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	if(this->maxHoursDaily>=0)
		s+=IL3+"<Maximum_Hours_Daily>"+CustomFETString::number(this->maxHoursDaily)+"</Maximum_Hours_Daily>\n";
	else
		assert(0);
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsMaxHoursDaily>\n";
	return s;
}

QString ConstraintStudentsMaxHoursDaily::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Students max hours daily");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("MH:%1", "Max hours (daily)").arg(this->maxHoursDaily);

	return begin+s+end;
}

QString ConstraintStudentsMaxHoursDaily::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All students must respect the maximum number of hours daily");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Maximum hours daily=%1").arg(this->maxHoursDaily);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintStudentsMaxHoursDaily::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int tmp;
	int too_much;
	
	assert(this->maxHoursDaily>=0);

	if(true){
		too_much=0;
		for(int i=0; i<r.nInternalSubgroups; i++)
			for(int j=0; j<r.nDaysPerWeek; j++){
				tmp=0;
				for(int k=0; k<r.nHoursPerDay; k++){
					//OLD COMMENT
					//Here we want to see if we have a weekly activity or a 2 weeks activity
					//We don't do tmp+=subgroupsMatrix[i][j][k] because we already counted this as a hard hitness
					if(subgroupsMatrix[i][j][k]>=1)
						tmp++;
				}
				if(this->maxHoursDaily>=0 && tmp > this->maxHoursDaily){ //we would like no more than maxHoursDaily hours per day.
					too_much += 1; //tmp - this->maxHoursDaily;

					if(conflictsString!=nullptr){
						QString s=tr("Time constraint students max hours daily broken for subgroup: %1, day: %2, length=%3, conflicts increase=%4")
						 .arg(r.internalSubgroupsList[i]->name)
						 .arg(r.daysOfTheWeek[j])
						 .arg(CustomFETString::number(tmp))
						 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*1));
						
						dl.append(s);
						cl.append(weightPercentage/100*1);
					
						*conflictsString+= s+"\n";
					}
				}
			}
	}

	assert(too_much>=0);
	if(weightPercentage==100)
		assert(too_much==0);
	return too_much * weightPercentage/100;
}

bool ConstraintStudentsMaxHoursDaily::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsMaxHoursDaily::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsMaxHoursDaily::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsMaxHoursDaily::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsMaxHoursDaily::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return true;
}

int ConstraintStudentsMaxHoursDaily::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsMaxHoursDaily::hasWrongDayOrHour(Rules& r)
{
	if(maxHoursDaily>r.nHoursPerDay)
		return true;
		
	return false;
}

bool ConstraintStudentsMaxHoursDaily::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsMaxHoursDaily::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxHoursDaily>r.nHoursPerDay)
		maxHoursDaily=r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsSetMaxHoursDaily::ConstraintStudentsSetMaxHoursDaily()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY;
	this->maxHoursDaily = -1;
}

ConstraintStudentsSetMaxHoursDaily::ConstraintStudentsSetMaxHoursDaily(double wp, int maxnh, const QString& s)
	: TimeConstraint(wp)
{
	this->maxHoursDaily = maxnh;
	this->students = s;
	this->type = CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY;
}

bool ConstraintStudentsSetMaxHoursDaily::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsSetMaxHoursDaily::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsSetMaxHoursDaily>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Maximum_Hours_Daily>"+CustomFETString::number(this->maxHoursDaily)+"</Maximum_Hours_Daily>\n";
	s+=IL3+"<Students>"+protect(this->students)+"</Students>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsSetMaxHoursDaily>\n";
	return s;
}

QString ConstraintStudentsSetMaxHoursDaily::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Students set max hours daily");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("St:%1", "Students (set)").arg(this->students); s+=translatedCommaSpace();
	s+=tr("MH:%1", "Max hours (daily)").arg(this->maxHoursDaily);

	return begin+s+end;
}

QString ConstraintStudentsSetMaxHoursDaily::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A students set must respect the maximum number of hours daily");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Students set=%1").arg(this->students);s+="\n";
	s+=tr("Maximum hours daily=%1").arg(this->maxHoursDaily);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

bool ConstraintStudentsSetMaxHoursDaily::computeInternalStructure(QWidget* parent, Rules& r)
{
	//StudentsSet* ss=r.searchAugmentedStudentsSet(this->students);
	StudentsSet* ss=r.studentsHash.value(students, nullptr);
	
	if(ss==nullptr){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students set max hours daily is wrong because it refers to nonexistent students set."
		 " Please correct it (removing it might be a solution). Please report potential bug. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
		return false;
	}

	assert(ss!=nullptr);

	populateInternalSubgroupsList(r, ss, this->iSubgroupsList);
	/*this->iSubgroupsList.clear();
	if(ss->type==STUDENTS_SUBGROUP){
		int tmp;
		tmp=((StudentsSubgroup*)ss)->indexInInternalSubgroupsList;
		assert(tmp>=0);
		assert(tmp<r.nInternalSubgroups);
		if(!this->iSubgroupsList.contains(tmp))
			this->iSubgroupsList.append(tmp);
	}
	else if(ss->type==STUDENTS_GROUP){
		StudentsGroup* stg=(StudentsGroup*)ss;
		for(int i=0; i<stg->subgroupsList.size(); i++){
			StudentsSubgroup* sts=stg->subgroupsList[i];
			int tmp;
			tmp=sts->indexInInternalSubgroupsList;
			assert(tmp>=0);
			assert(tmp<r.nInternalSubgroups);
			if(!this->iSubgroupsList.contains(tmp))
				this->iSubgroupsList.append(tmp);
		}
	}
	else if(ss->type==STUDENTS_YEAR){
		StudentsYear* sty=(StudentsYear*)ss;
		for(int i=0; i<sty->groupsList.size(); i++){
			StudentsGroup* stg=sty->groupsList[i];
			for(int j=0; j<stg->subgroupsList.size(); j++){
				StudentsSubgroup* sts=stg->subgroupsList[j];
				int tmp;
				tmp=sts->indexInInternalSubgroupsList;
				assert(tmp>=0);
				assert(tmp<r.nInternalSubgroups);
				if(!this->iSubgroupsList.contains(tmp))
					this->iSubgroupsList.append(tmp);
			}
		}
	}
	else
		assert(0);*/
		
	return true;
}

double ConstraintStudentsSetMaxHoursDaily::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int tmp;
	int too_much;

	assert(this->maxHoursDaily>=0);

	if(true){
		too_much=0;
		for(int sg=0; sg<this->iSubgroupsList.count(); sg++){
			int i=iSubgroupsList.at(sg);
			for(int j=0; j<r.nDaysPerWeek; j++){
				tmp=0;
				for(int k=0; k<r.nHoursPerDay; k++){
					//Here we want to see if we have a weekly activity or a 2 weeks activity
					//We don't do tmp+=subgroupsMatrix[i][j][k] because we already counted this as a hard hitness
					if(subgroupsMatrix[i][j][k]>=1)
						tmp++;
				}
				if(this->maxHoursDaily>=0 && tmp > this->maxHoursDaily){ //we would like no more than max_hours_daily hours per day.
					too_much += 1; //tmp - this->maxHoursDaily;

					if(conflictsString!=nullptr){
						QString s=tr("Time constraint students set max hours daily broken for subgroup: %1, day: %2, length=%3, conflicts increase=%4")
						 .arg(r.internalSubgroupsList[i]->name)
						 .arg(r.daysOfTheWeek[j])
						 .arg(CustomFETString::number(tmp))
						 .arg(CustomFETString::numberPlusTwoDigitsPrecision( 1 *weightPercentage/100));
						
						dl.append(s);
						cl.append( 1 *weightPercentage/100);
					
						*conflictsString+= s+"\n";
					}
				}
			}
		}
	}
	
	assert(too_much>=0);
	if(weightPercentage==100)
		assert(too_much==0);
	return too_much * weightPercentage / 100.0;
}

bool ConstraintStudentsSetMaxHoursDaily::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsSetMaxHoursDaily::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsSetMaxHoursDaily::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetMaxHoursDaily::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetMaxHoursDaily::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	return r.setsShareStudents(this->students, s);
}

int ConstraintStudentsSetMaxHoursDaily::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsSetMaxHoursDaily::hasWrongDayOrHour(Rules& r)
{
	if(maxHoursDaily>r.nHoursPerDay)
		return true;
		
	return false;
}

bool ConstraintStudentsSetMaxHoursDaily::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsSetMaxHoursDaily::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxHoursDaily>r.nHoursPerDay)
		maxHoursDaily=r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsMaxHoursContinuously::ConstraintStudentsMaxHoursContinuously()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_MAX_HOURS_CONTINUOUSLY;
	this->maxHoursContinuously = -1;
}

ConstraintStudentsMaxHoursContinuously::ConstraintStudentsMaxHoursContinuously(double wp, int maxnh)
	: TimeConstraint(wp)
{
	this->maxHoursContinuously = maxnh;
	this->type = CONSTRAINT_STUDENTS_MAX_HOURS_CONTINUOUSLY;
}

bool ConstraintStudentsMaxHoursContinuously::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);
	Q_UNUSED(r);
	
	return true;
}

bool ConstraintStudentsMaxHoursContinuously::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsMaxHoursContinuously::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsMaxHoursContinuously>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	if(this->maxHoursContinuously>=0)
		s+=IL3+"<Maximum_Hours_Continuously>"+CustomFETString::number(this->maxHoursContinuously)+"</Maximum_Hours_Continuously>\n";
	else
		assert(0);
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsMaxHoursContinuously>\n";
	return s;
}

QString ConstraintStudentsMaxHoursContinuously::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Students max hours continuously");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("MH:%1", "Max hours (continuously)").arg(this->maxHoursContinuously);

	return begin+s+end;
}

QString ConstraintStudentsMaxHoursContinuously::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All students must respect the maximum number of hours continuously");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Maximum hours continuously=%1").arg(this->maxHoursContinuously);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintStudentsMaxHoursContinuously::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	int nbroken;

	nbroken=0;
	for(int i=0; i<r.nInternalSubgroups; i++){
		for(int d=0; d<r.nDaysPerWeek; d++){
			int nc=0;
			for(int h=0; h<r.nHoursPerDay; h++){
				if(subgroupsMatrix[i][d][h]>0)
					nc++;
				else{
					if(nc>this->maxHoursContinuously){
						nbroken++;

						if(conflictsString!=nullptr){
							QString s=(tr(
							 "Time constraint students max %1 hours continuously broken for subgroup %2, on day %3, length=%4.")
							 .arg(CustomFETString::number(this->maxHoursContinuously))
							 .arg(r.internalSubgroupsList[i]->name)
							 .arg(r.daysOfTheWeek[d])
							 .arg(nc)
							 )
							 +
							 " "
							 +
							 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100)));
							
							dl.append(s);
							cl.append(weightPercentage/100);
				
							*conflictsString+= s+"\n";
						}
					}
				
					nc=0;
				}
			}

			if(nc>this->maxHoursContinuously){
				nbroken++;

				if(conflictsString!=nullptr){
					QString s=(tr(
					 "Time constraint students max %1 hours continuously broken for subgroup %2, on day %3, length=%4.")
					 .arg(CustomFETString::number(this->maxHoursContinuously))
					 .arg(r.internalSubgroupsList[i]->name)
					 .arg(r.daysOfTheWeek[d])
					 .arg(nc)
					 )
					 +
					 " "
					 +
					 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100)));
					
					dl.append(s);
					cl.append(weightPercentage/100);
				
					*conflictsString+= s+"\n";
				}
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintStudentsMaxHoursContinuously::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsMaxHoursContinuously::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsMaxHoursContinuously::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsMaxHoursContinuously::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsMaxHoursContinuously::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return true;
}

int ConstraintStudentsMaxHoursContinuously::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsMaxHoursContinuously::hasWrongDayOrHour(Rules& r)
{
	if(maxHoursContinuously>r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintStudentsMaxHoursContinuously::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsMaxHoursContinuously::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxHoursContinuously>r.nHoursPerDay)
		maxHoursContinuously=r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsSetMaxHoursContinuously::ConstraintStudentsSetMaxHoursContinuously()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_SET_MAX_HOURS_CONTINUOUSLY;
	this->maxHoursContinuously = -1;
}

ConstraintStudentsSetMaxHoursContinuously::ConstraintStudentsSetMaxHoursContinuously(double wp, int maxnh, const QString& s)
	: TimeConstraint(wp)
{
	this->maxHoursContinuously = maxnh;
	this->students = s;
	this->type = CONSTRAINT_STUDENTS_SET_MAX_HOURS_CONTINUOUSLY;
}

bool ConstraintStudentsSetMaxHoursContinuously::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsSetMaxHoursContinuously::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsSetMaxHoursContinuously>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Maximum_Hours_Continuously>"+CustomFETString::number(this->maxHoursContinuously)+"</Maximum_Hours_Continuously>\n";
	s+=IL3+"<Students>"+protect(this->students)+"</Students>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsSetMaxHoursContinuously>\n";
	return s;
}

QString ConstraintStudentsSetMaxHoursContinuously::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Students set max hours continuously");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("St:%1", "Students (set)").arg(this->students);s+=translatedCommaSpace();
	s+=tr("MH:%1", "Max hours (continuously)").arg(this->maxHoursContinuously);

	return begin+s+end;
}

QString ConstraintStudentsSetMaxHoursContinuously::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A students set must respect the maximum number of hours continuously");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Students set=%1").arg(this->students);s+="\n";
	s+=tr("Maximum hours continuously=%1").arg(this->maxHoursContinuously);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

bool ConstraintStudentsSetMaxHoursContinuously::computeInternalStructure(QWidget* parent, Rules& r)
{
	//StudentsSet* ss=r.searchAugmentedStudentsSet(this->students);
	StudentsSet* ss=r.studentsHash.value(students, nullptr);
	
	if(ss==nullptr){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students set max hours continuously is wrong because it refers to nonexistent students set."
		 " Please correct it (removing it might be a solution). Please report potential bug. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
		return false;
	}

	assert(ss!=nullptr);

	populateInternalSubgroupsList(r, ss, this->iSubgroupsList);
	/*this->iSubgroupsList.clear();
	if(ss->type==STUDENTS_SUBGROUP){
		int tmp;
		tmp=((StudentsSubgroup*)ss)->indexInInternalSubgroupsList;
		assert(tmp>=0);
		assert(tmp<r.nInternalSubgroups);
		if(!this->iSubgroupsList.contains(tmp))
			this->iSubgroupsList.append(tmp);
	}
	else if(ss->type==STUDENTS_GROUP){
		StudentsGroup* stg=(StudentsGroup*)ss;
		for(int i=0; i<stg->subgroupsList.size(); i++){
			StudentsSubgroup* sts=stg->subgroupsList[i];
			int tmp;
			tmp=sts->indexInInternalSubgroupsList;
			assert(tmp>=0);
			assert(tmp<r.nInternalSubgroups);
			if(!this->iSubgroupsList.contains(tmp))
				this->iSubgroupsList.append(tmp);
		}
	}
	else if(ss->type==STUDENTS_YEAR){
		StudentsYear* sty=(StudentsYear*)ss;
		for(int i=0; i<sty->groupsList.size(); i++){
			StudentsGroup* stg=sty->groupsList[i];
			for(int j=0; j<stg->subgroupsList.size(); j++){
				StudentsSubgroup* sts=stg->subgroupsList[j];
				int tmp;
				tmp=sts->indexInInternalSubgroupsList;
				assert(tmp>=0);
				assert(tmp<r.nInternalSubgroups);
				if(!this->iSubgroupsList.contains(tmp))
					this->iSubgroupsList.append(tmp);
			}
		}
	}
	else
		assert(0);*/
		
	return true;
}

double ConstraintStudentsSetMaxHoursContinuously::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	nbroken=0;
	for(int i : std::as_const(this->iSubgroupsList)){
		for(int d=0; d<r.nDaysPerWeek; d++){
			int nc=0;
			for(int h=0; h<r.nHoursPerDay; h++){
				if(subgroupsMatrix[i][d][h]>0)
					nc++;
				else{
					if(nc>this->maxHoursContinuously){
						nbroken++;

						if(conflictsString!=nullptr){
							QString s=(tr(
							 "Time constraint students set max %1 hours continuously broken for subgroup %2, on day %3, length=%4.")
							 .arg(CustomFETString::number(this->maxHoursContinuously))
							 .arg(r.internalSubgroupsList[i]->name)
							 .arg(r.daysOfTheWeek[d])
							 .arg(nc)
							 )
							 +
							 " "
							 +
							 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100)));
							
							dl.append(s);
							cl.append(weightPercentage/100);
				
							*conflictsString+= s+"\n";
						}
					}
				
					nc=0;
				}
			}

			if(nc>this->maxHoursContinuously){
				nbroken++;

				if(conflictsString!=nullptr){
					QString s=(tr(
					 "Time constraint students set max %1 hours continuously broken for subgroup %2, on day %3, length=%4.")
					 .arg(CustomFETString::number(this->maxHoursContinuously))
					 .arg(r.internalSubgroupsList[i]->name)
					 .arg(r.daysOfTheWeek[d])
					 .arg(nc)
					 )
					 +
					 " "
					 +
					 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100)));
					
					dl.append(s);
					cl.append(weightPercentage/100);
				
					*conflictsString+= s+"\n";
				}
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintStudentsSetMaxHoursContinuously::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsSetMaxHoursContinuously::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsSetMaxHoursContinuously::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetMaxHoursContinuously::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetMaxHoursContinuously::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	return r.setsShareStudents(this->students, s);
}

int ConstraintStudentsSetMaxHoursContinuously::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsSetMaxHoursContinuously::hasWrongDayOrHour(Rules& r)
{
	if(maxHoursContinuously>r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintStudentsSetMaxHoursContinuously::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsSetMaxHoursContinuously::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxHoursContinuously>r.nHoursPerDay)
		maxHoursContinuously=r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsActivityTagMaxHoursContinuously::ConstraintStudentsActivityTagMaxHoursContinuously()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY;
	this->maxHoursContinuously = -1;
}

ConstraintStudentsActivityTagMaxHoursContinuously::ConstraintStudentsActivityTagMaxHoursContinuously(double wp, int maxnh, const QString& activityTag)
	: TimeConstraint(wp)
{
	this->maxHoursContinuously = maxnh;
	this->activityTagName=activityTag;
	this->type = CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY;
}

bool ConstraintStudentsActivityTagMaxHoursContinuously::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);

	//this->activityTagIndex=r.searchActivityTag(this->activityTagName);
	activityTagIndex=r.activityTagsHash.value(activityTagName, -1);
	assert(this->activityTagIndex>=0);
	
	this->canonicalSubgroupsList.clear();
	for(int i=0; i<r.nInternalSubgroups; i++){
		bool found=false;
	
		StudentsSubgroup* sbg=r.internalSubgroupsList[i];
		for(int actIndex : std::as_const(sbg->activitiesForSubgroup)){
			if(r.internalActivitiesList[actIndex].iActivityTagsSet.contains(this->activityTagIndex)){
				found=true;
				break;
			}
		}
		
		if(found)
			this->canonicalSubgroupsList.append(i);
	}

	return true;
}

bool ConstraintStudentsActivityTagMaxHoursContinuously::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsActivityTagMaxHoursContinuously::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsActivityTagMaxHoursContinuously>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	
	s+=IL3+"<Activity_Tag>"+protect(this->activityTagName)+"</Activity_Tag>\n";
	
	if(this->maxHoursContinuously>=0)
		s+=IL3+"<Maximum_Hours_Continuously>"+CustomFETString::number(this->maxHoursContinuously)+"</Maximum_Hours_Continuously>\n";
	else
		assert(0);
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsActivityTagMaxHoursContinuously>\n";
	return s;
}

QString ConstraintStudentsActivityTagMaxHoursContinuously::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Students for activity tag %1 have max %2 hours continuously")
		.arg(this->activityTagName).arg(this->maxHoursContinuously); s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintStudentsActivityTagMaxHoursContinuously::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All students, for an activity tag, must respect the maximum number of hours continuously"); s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Activity tag=%1").arg(this->activityTagName);s+="\n";
	s+=tr("Maximum hours continuously=%1").arg(this->maxHoursContinuously);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintStudentsActivityTagMaxHoursContinuously::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);
		
		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	int nbroken;

	nbroken=0;
	
	Matrix2D<int> crtSubgroupTimetableActivityTag;
	crtSubgroupTimetableActivityTag.resize(r.nDaysPerWeek, r.nHoursPerDay);
	
	for(int i : std::as_const(this->canonicalSubgroupsList)){
		StudentsSubgroup* sbg=r.internalSubgroupsList[i];
		for(int d=0; d<r.nDaysPerWeek; d++)
			for(int h=0; h<r.nHoursPerDay; h++)
				crtSubgroupTimetableActivityTag[d][h]=-1;
		for(int ai : std::as_const(sbg->activitiesForSubgroup)) if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek;
			int h=c.times[ai]/r.nDaysPerWeek;
			for(int dur=0; dur<r.internalActivitiesList[ai].duration; dur++){
				assert(h+dur<r.nHoursPerDay);
				assert(crtSubgroupTimetableActivityTag[d][h+dur]==-1);
				if(r.internalActivitiesList[ai].iActivityTagsSet.contains(this->activityTagIndex))
					crtSubgroupTimetableActivityTag[d][h+dur]=this->activityTagIndex;
			}
		}

		for(int d=0; d<r.nDaysPerWeek; d++){
			int nc=0;
			for(int h=0; h<r.nHoursPerDay; h++){
				bool inc=false;
				
				if(crtSubgroupTimetableActivityTag[d][h]==this->activityTagIndex)
					inc=true;
				
				if(inc)
					nc++;
				else{
					if(nc>this->maxHoursContinuously){
						nbroken++;

						if(conflictsString!=nullptr){
							QString s=(tr(
							 "Time constraint students, activity tag %1, max %2 hours continuously, broken for subgroup %3, on day %4, length=%5.")
							 .arg(this->activityTagName)
							 .arg(CustomFETString::number(this->maxHoursContinuously))
							 .arg(r.internalSubgroupsList[i]->name)
							 .arg(r.daysOfTheWeek[d])
							 .arg(nc)
							 )
							 +
							 " "
							 +
							 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100)));
							
							dl.append(s);
							cl.append(weightPercentage/100);
				
							*conflictsString+= s+"\n";
						}
					}
				
					nc=0;
				}
			}

			if(nc>this->maxHoursContinuously){
				nbroken++;

				if(conflictsString!=nullptr){
					QString s=(tr(
					 "Time constraint students, activity tag %1, max %2 hours continuously, broken for subgroup %3, on day %4, length=%5.")
					 .arg(this->activityTagName)
					 .arg(CustomFETString::number(this->maxHoursContinuously))
					 .arg(r.internalSubgroupsList[i]->name)
					 .arg(r.daysOfTheWeek[d])
					 .arg(nc)
					 )
					 +
					 " "
					 +
					 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100)));
					
					dl.append(s);
					cl.append(weightPercentage/100);
				
					*conflictsString+= s+"\n";
				}
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintStudentsActivityTagMaxHoursContinuously::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsActivityTagMaxHoursContinuously::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsActivityTagMaxHoursContinuously::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsActivityTagMaxHoursContinuously::isRelatedToActivityTag(const QString& s)
{
	return s==this->activityTagName;
}

bool ConstraintStudentsActivityTagMaxHoursContinuously::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return true;
}

int ConstraintStudentsActivityTagMaxHoursContinuously::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsActivityTagMaxHoursContinuously::hasWrongDayOrHour(Rules& r)
{
	if(maxHoursContinuously>r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintStudentsActivityTagMaxHoursContinuously::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsActivityTagMaxHoursContinuously::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxHoursContinuously>r.nHoursPerDay)
		maxHoursContinuously=r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsSetActivityTagMaxHoursContinuously::ConstraintStudentsSetActivityTagMaxHoursContinuously()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY;
	this->maxHoursContinuously = -1;
}

ConstraintStudentsSetActivityTagMaxHoursContinuously::ConstraintStudentsSetActivityTagMaxHoursContinuously(double wp, int maxnh, const QString& s, const QString& activityTag)
	: TimeConstraint(wp)
{
	this->maxHoursContinuously = maxnh;
	this->students = s;
	this->activityTagName=activityTag;
	this->type = CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY;
}

bool ConstraintStudentsSetActivityTagMaxHoursContinuously::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsSetActivityTagMaxHoursContinuously::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsSetActivityTagMaxHoursContinuously>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Maximum_Hours_Continuously>"+CustomFETString::number(this->maxHoursContinuously)+"</Maximum_Hours_Continuously>\n";
	s+=IL3+"<Students>"+protect(this->students)+"</Students>\n";
	s+=IL3+"<Activity_Tag>"+protect(this->activityTagName)+"</Activity_Tag>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsSetActivityTagMaxHoursContinuously>\n";
	return s;
}

QString ConstraintStudentsSetActivityTagMaxHoursContinuously::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Students set %1 for activity tag %2 has max %3 hours continuously").arg(this->students).arg(this->activityTagName).arg(this->maxHoursContinuously);
	s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintStudentsSetActivityTagMaxHoursContinuously::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A students set, for an activity tag, must respect the maximum number of hours continuously"); s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Students set=%1").arg(this->students);s+="\n";
	s+=tr("Activity tag=%1").arg(this->activityTagName);s+="\n";
	s+=tr("Maximum hours continuously=%1").arg(this->maxHoursContinuously);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

bool ConstraintStudentsSetActivityTagMaxHoursContinuously::computeInternalStructure(QWidget* parent, Rules& r)
{
	//this->activityTagIndex=r.searchActivityTag(this->activityTagName);
	activityTagIndex=r.activityTagsHash.value(activityTagName, -1);
	assert(this->activityTagIndex>=0);

	//StudentsSet* ss=r.searchAugmentedStudentsSet(this->students);
	StudentsSet* ss=r.studentsHash.value(students, nullptr);
	
	if(ss==nullptr){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students set max hours continuously is wrong because it refers to nonexistent students set."
		 " Please correct it (removing it might be a solution). Please report potential bug. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
		return false;
	}

	assert(ss!=nullptr);

	populateInternalSubgroupsList(r, ss, this->iSubgroupsList);
	/*this->iSubgroupsList.clear();
	if(ss->type==STUDENTS_SUBGROUP){
		int tmp;
		tmp=((StudentsSubgroup*)ss)->indexInInternalSubgroupsList;
		assert(tmp>=0);
		assert(tmp<r.nInternalSubgroups);
		if(!this->iSubgroupsList.contains(tmp))
			this->iSubgroupsList.append(tmp);
	}
	else if(ss->type==STUDENTS_GROUP){
		StudentsGroup* stg=(StudentsGroup*)ss;
		for(int i=0; i<stg->subgroupsList.size(); i++){
			StudentsSubgroup* sts=stg->subgroupsList[i];
			int tmp;
			tmp=sts->indexInInternalSubgroupsList;
			assert(tmp>=0);
			assert(tmp<r.nInternalSubgroups);
			if(!this->iSubgroupsList.contains(tmp))
				this->iSubgroupsList.append(tmp);
		}
	}
	else if(ss->type==STUDENTS_YEAR){
		StudentsYear* sty=(StudentsYear*)ss;
		for(int i=0; i<sty->groupsList.size(); i++){
			StudentsGroup* stg=sty->groupsList[i];
			for(int j=0; j<stg->subgroupsList.size(); j++){
				StudentsSubgroup* sts=stg->subgroupsList[j];
				int tmp;
				tmp=sts->indexInInternalSubgroupsList;
				assert(tmp>=0);
				assert(tmp<r.nInternalSubgroups);
				if(!this->iSubgroupsList.contains(tmp))
					this->iSubgroupsList.append(tmp);
			}
		}
	}
	else
		assert(0);*/
		
	/////////////
	this->canonicalSubgroupsList.clear();
	for(int i : std::as_const(this->iSubgroupsList)){
		bool found=false;
	
		StudentsSubgroup* sbg=r.internalSubgroupsList[i];
		for(int actIndex : std::as_const(sbg->activitiesForSubgroup)){
			if(r.internalActivitiesList[actIndex].iActivityTagsSet.contains(this->activityTagIndex)){
				found=true;
				break;
			}
		}
		
		if(found)
			this->canonicalSubgroupsList.append(i);
	}
		
	return true;
}

double ConstraintStudentsSetActivityTagMaxHoursContinuously::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	nbroken=0;

	Matrix2D<int> crtSubgroupTimetableActivityTag;
	crtSubgroupTimetableActivityTag.resize(r.nDaysPerWeek, r.nHoursPerDay);

	for(int i : std::as_const(this->canonicalSubgroupsList)){
		StudentsSubgroup* sbg=r.internalSubgroupsList[i];
		for(int d=0; d<r.nDaysPerWeek; d++)
			for(int h=0; h<r.nHoursPerDay; h++)
				crtSubgroupTimetableActivityTag[d][h]=-1;
		for(int ai : std::as_const(sbg->activitiesForSubgroup)) if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek;
			int h=c.times[ai]/r.nDaysPerWeek;
			for(int dur=0; dur<r.internalActivitiesList[ai].duration; dur++){
				assert(h+dur<r.nHoursPerDay);
				assert(crtSubgroupTimetableActivityTag[d][h+dur]==-1);
				if(r.internalActivitiesList[ai].iActivityTagsSet.contains(this->activityTagIndex))
					crtSubgroupTimetableActivityTag[d][h+dur]=this->activityTagIndex;
			}
		}

		for(int d=0; d<r.nDaysPerWeek; d++){
			int nc=0;
			for(int h=0; h<r.nHoursPerDay; h++){
				bool inc=false;
				
				if(crtSubgroupTimetableActivityTag[d][h]==this->activityTagIndex)
					inc=true;
			
				if(inc)
					nc++;
				else{
					if(nc>this->maxHoursContinuously){
						nbroken++;

						if(conflictsString!=nullptr){
							QString s=(tr(
							 "Time constraint students set max %1 hours continuously broken for subgroup %2, on day %3, length=%4.")
							 .arg(CustomFETString::number(this->maxHoursContinuously))
							 .arg(r.internalSubgroupsList[i]->name)
							 .arg(r.daysOfTheWeek[d])
							 .arg(nc)
							 )
							 +
							 " "
							 +
							 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100)));
							
							dl.append(s);
							cl.append(weightPercentage/100);
				
							*conflictsString+= s+"\n";
						}
					}
				
					nc=0;
				}
			}

			if(nc>this->maxHoursContinuously){
				nbroken++;

				if(conflictsString!=nullptr){
					QString s=(tr(
					 "Time constraint students set max %1 hours continuously broken for subgroup %2, on day %3, length=%4.")
					 .arg(CustomFETString::number(this->maxHoursContinuously))
					 .arg(r.internalSubgroupsList[i]->name)
					 .arg(r.daysOfTheWeek[d])
					 .arg(nc)
					 )
					 +
					 " "
					 +
					 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100)));
					
					dl.append(s);
					cl.append(weightPercentage/100);
				
					*conflictsString+= s+"\n";
				}
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintStudentsSetActivityTagMaxHoursContinuously::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsSetActivityTagMaxHoursContinuously::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsSetActivityTagMaxHoursContinuously::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetActivityTagMaxHoursContinuously::isRelatedToActivityTag(const QString& s)
{
	return s==this->activityTagName;

	return false;
}

bool ConstraintStudentsSetActivityTagMaxHoursContinuously::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	return r.setsShareStudents(this->students, s);
}

int ConstraintStudentsSetActivityTagMaxHoursContinuously::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsSetActivityTagMaxHoursContinuously::hasWrongDayOrHour(Rules& r)
{
	if(maxHoursContinuously>r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintStudentsSetActivityTagMaxHoursContinuously::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsSetActivityTagMaxHoursContinuously::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxHoursContinuously>r.nHoursPerDay)
		maxHoursContinuously=r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsMinHoursDaily::ConstraintStudentsMinHoursDaily()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_MIN_HOURS_DAILY;
	this->minHoursDaily = -1;
	
	this->allowEmptyDays=false;
}

ConstraintStudentsMinHoursDaily::ConstraintStudentsMinHoursDaily(double wp, int minnh, bool _allowEmptyDays)
	: TimeConstraint(wp)
{
	this->minHoursDaily = minnh;
	this->type = CONSTRAINT_STUDENTS_MIN_HOURS_DAILY;
	
	this->allowEmptyDays=_allowEmptyDays;
}

bool ConstraintStudentsMinHoursDaily::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);
	Q_UNUSED(r);
	
	return true;
}

bool ConstraintStudentsMinHoursDaily::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsMinHoursDaily::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsMinHoursDaily>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	if(this->minHoursDaily>=0)
		s+=IL3+"<Minimum_Hours_Daily>"+CustomFETString::number(this->minHoursDaily)+"</Minimum_Hours_Daily>\n";
	else
		assert(0);
	if(this->allowEmptyDays)
		s+=IL3+"<Allow_Empty_Days>true</Allow_Empty_Days>\n";
	else
		s+=IL3+"<Allow_Empty_Days>false</Allow_Empty_Days>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsMinHoursDaily>\n";
	return s;
}

QString ConstraintStudentsMinHoursDaily::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;

	s+=tr("Students min hours daily");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("mH:%1", "Min hours (daily)").arg(this->minHoursDaily);s+=translatedCommaSpace();
	s+=tr("AED:%1", "Allow empty days").arg(yesNoTranslated(this->allowEmptyDays));

	return begin+s+end;
}

QString ConstraintStudentsMinHoursDaily::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All students must respect the minimum number of hours daily");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Minimum hours daily=%1").arg(this->minHoursDaily);s+="\n";
	s+=tr("Allow empty days=%1").arg(yesNoTranslated(this->allowEmptyDays));s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintStudentsMinHoursDaily::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	if(r.mode!=MORNINGS_AFTERNOONS){
		int tmp;
		int too_little;

		assert(this->minHoursDaily>=0);

		too_little=0;
		for(int i=0; i<r.nInternalSubgroups; i++)
			for(int j=0; j<r.nDaysPerWeek; j++){
				tmp=0;
				for(int k=0; k<r.nHoursPerDay; k++){
					if(subgroupsMatrix[i][j][k]>=1)
						tmp++;
				}

				bool searchDay;
				if(this->allowEmptyDays==true)
					searchDay=(tmp>0);
				else
					searchDay=true;

				if(/*tmp>0*/ searchDay && this->minHoursDaily>=0 && tmp < this->minHoursDaily){ //we would like no less than minHoursDaily hours per day.
					too_little += - tmp + this->minHoursDaily;

					if(conflictsString!=nullptr){
						QString s=tr("Time constraint students min hours daily broken for subgroup: %1, day: %2, length=%3, conflicts increase=%4")
						 .arg(r.internalSubgroupsList[i]->name)
						 .arg(r.daysOfTheWeek[j])
						 .arg(CustomFETString::number(tmp))
						 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*(-tmp+this->minHoursDaily)));

						dl.append(s);
						cl.append(weightPercentage/100*(-tmp+this->minHoursDaily));

						*conflictsString+= s+"\n";
					}
				}
			}

		//should not consider for empty days

		assert(too_little>=0);

		if(c.nPlacedActivities==r.nInternalActivities)
			if(weightPercentage==100) //does not work for partial solutions
				assert(too_little==0);

		return too_little * weightPercentage/100;
	}
	else{
		int tmp1, tmp2;
		int too_little;

		assert(this->minHoursDaily>=0);

		too_little=0;
		for(int i=0; i<r.nInternalSubgroups; i++)
			for(int j=0; j<r.nDaysPerWeek/2; j++){
				tmp1=0;
				for(int k=0; k<r.nHoursPerDay; k++){
					if(subgroupsMatrix[i][2*j][k]>=1)
						tmp1++;
				}

				if(tmp1>0 && tmp1<this->minHoursDaily){
					too_little += - tmp1 + this->minHoursDaily;

					if(conflictsString!=nullptr){
						QString s=tr("Time constraint students min hours daily broken for subgroup: %1, day: %2, length=%3, conflicts increase=%4")
						 .arg(r.internalSubgroupsList[i]->name)
						 .arg(r.daysOfTheWeek[2*j])
						 .arg(CustomFETString::number(tmp1))
						 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*(-tmp1+this->minHoursDaily)));

						dl.append(s);
						cl.append(weightPercentage/100*(-tmp1+this->minHoursDaily));

						*conflictsString+= s+"\n";
					}
				}

				tmp2=0;
				for(int k=0; k<r.nHoursPerDay; k++){
					if(subgroupsMatrix[i][2*j+1][k]>=1)
						tmp2++;
				}

				if(tmp2>0 && tmp2<this->minHoursDaily){
					too_little += - tmp2 + this->minHoursDaily;

					if(conflictsString!=nullptr){
						QString s=tr("Time constraint students min hours daily broken for subgroup: %1, day: %2, length=%3, conflicts increase=%4")
						 .arg(r.internalSubgroupsList[i]->name)
						 .arg(r.daysOfTheWeek[2*j+1])
						 .arg(CustomFETString::number(tmp2))
						 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*(-tmp2+this->minHoursDaily)));

						dl.append(s);
						cl.append(weightPercentage/100*(-tmp2+this->minHoursDaily));

						*conflictsString+= s+"\n";
					}
				}

				if(!this->allowEmptyDays==true)
					if(tmp1+tmp2==0){
						too_little++;

						if(conflictsString!=nullptr){
							QString s=tr("Time constraint students min hours daily broken for subgroup: %1, real day: %2, empty real day, but"
							 " the constraint does not allow empty real days, conflicts increase=%3")
							 .arg(r.internalSubgroupsList[i]->name)
							 .arg(j)
							 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*(1)));

							dl.append(s);
							cl.append(weightPercentage/100*1);

							*conflictsString+= s+"\n";
						}
					}
			}

		assert(too_little>=0);

		if(c.nPlacedActivities==r.nInternalActivities)
			if(weightPercentage==100) //does not work for partial solutions
				assert(too_little==0);

		return too_little * weightPercentage/100;
	}
}

bool ConstraintStudentsMinHoursDaily::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsMinHoursDaily::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsMinHoursDaily::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsMinHoursDaily::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsMinHoursDaily::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return true;
}

int ConstraintStudentsMinHoursDaily::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsMinHoursDaily::hasWrongDayOrHour(Rules& r)
{
	if(minHoursDaily>r.nHoursPerDay)
		return true;
		
	return false;
}

bool ConstraintStudentsMinHoursDaily::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsMinHoursDaily::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(minHoursDaily>r.nHoursPerDay)
		minHoursDaily=r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsSetMinHoursDaily::ConstraintStudentsSetMinHoursDaily()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_SET_MIN_HOURS_DAILY;
	this->minHoursDaily = -1;
	
	this->allowEmptyDays=false;
}

ConstraintStudentsSetMinHoursDaily::ConstraintStudentsSetMinHoursDaily(double wp, int minnh, const QString& s, bool _allowEmptyDays)
	: TimeConstraint(wp)
{
	this->minHoursDaily = minnh;
	this->students = s;
	this->type = CONSTRAINT_STUDENTS_SET_MIN_HOURS_DAILY;
	
	this->allowEmptyDays=_allowEmptyDays;
}

bool ConstraintStudentsSetMinHoursDaily::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsSetMinHoursDaily::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsSetMinHoursDaily>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Minimum_Hours_Daily>"+CustomFETString::number(this->minHoursDaily)+"</Minimum_Hours_Daily>\n";
	s+=IL3+"<Students>"+protect(this->students)+"</Students>\n";
	if(this->allowEmptyDays)
		s+=IL3+"<Allow_Empty_Days>true</Allow_Empty_Days>\n";
	else
		s+=IL3+"<Allow_Empty_Days>false</Allow_Empty_Days>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsSetMinHoursDaily>\n";
	return s;
}

QString ConstraintStudentsSetMinHoursDaily::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	
	s+=tr("Students set min hours daily");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("St:%1", "Students (set)").arg(this->students);s+=translatedCommaSpace();
	s+=tr("mH:%1", "Min hours (daily)").arg(this->minHoursDaily);s+=translatedCommaSpace();
	s+=tr("AED:%1", "Allow empty days").arg(yesNoTranslated(this->allowEmptyDays));

	return begin+s+end;
}

QString ConstraintStudentsSetMinHoursDaily::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A students set must respect the minimum number of hours daily");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Students set=%1").arg(this->students);s+="\n";
	s+=tr("Minimum hours daily=%1").arg(this->minHoursDaily);s+="\n";
	s+=tr("Allow empty days=%1").arg(yesNoTranslated(this->allowEmptyDays));s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

bool ConstraintStudentsSetMinHoursDaily::computeInternalStructure(QWidget* parent, Rules& r)
{
	//StudentsSet* ss=r.searchAugmentedStudentsSet(this->students);
	StudentsSet* ss=r.studentsHash.value(students, nullptr);
	
	if(ss==nullptr){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students set min hours daily is wrong because it refers to nonexistent students set."
		 " Please correct it (removing it might be a solution). Please report potential bug. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
		return false;
	}

	assert(ss!=nullptr);

	populateInternalSubgroupsList(r, ss, this->iSubgroupsList);
	/*this->iSubgroupsList.clear();
	if(ss->type==STUDENTS_SUBGROUP){
		int tmp;
		tmp=((StudentsSubgroup*)ss)->indexInInternalSubgroupsList;
		assert(tmp>=0);
		assert(tmp<r.nInternalSubgroups);
		if(!this->iSubgroupsList.contains(tmp))
			this->iSubgroupsList.append(tmp);
	}
	else if(ss->type==STUDENTS_GROUP){
		StudentsGroup* stg=(StudentsGroup*)ss;
		for(int i=0; i<stg->subgroupsList.size(); i++){
			StudentsSubgroup* sts=stg->subgroupsList[i];
			int tmp;
			tmp=sts->indexInInternalSubgroupsList;
			assert(tmp>=0);
			assert(tmp<r.nInternalSubgroups);
			if(!this->iSubgroupsList.contains(tmp))
				this->iSubgroupsList.append(tmp);
		}
	}
	else if(ss->type==STUDENTS_YEAR){
		StudentsYear* sty=(StudentsYear*)ss;
		for(int i=0; i<sty->groupsList.size(); i++){
			StudentsGroup* stg=sty->groupsList[i];
			for(int j=0; j<stg->subgroupsList.size(); j++){
				StudentsSubgroup* sts=stg->subgroupsList[j];
				int tmp;
				tmp=sts->indexInInternalSubgroupsList;
				assert(tmp>=0);
				assert(tmp<r.nInternalSubgroups);
				if(!this->iSubgroupsList.contains(tmp))
					this->iSubgroupsList.append(tmp);
			}
		}
	}
	else
		assert(0);*/
		
	return true;
}

double ConstraintStudentsSetMinHoursDaily::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	if(r.mode!=MORNINGS_AFTERNOONS){
		int tmp;
		int too_little;

		assert(this->minHoursDaily>=0);

		too_little=0;
		for(int sg=0; sg<this->iSubgroupsList.count(); sg++){
			int i=iSubgroupsList.at(sg);
			for(int j=0; j<r.nDaysPerWeek; j++){
				tmp=0;
				for(int k=0; k<r.nHoursPerDay; k++){
					if(subgroupsMatrix[i][j][k]>=1)
						tmp++;
				}

				bool searchDay;
				if(this->allowEmptyDays==true)
					searchDay=(tmp>0);
				else
					searchDay=true;

				if(/*tmp>0*/ searchDay && this->minHoursDaily>=0 && tmp < this->minHoursDaily){
					too_little += - tmp + this->minHoursDaily;

					if(conflictsString!=nullptr){
						QString s=tr("Time constraint students set min hours daily broken for subgroup: %1, day: %2, length=%3, conflicts increase=%4")
						 .arg(r.internalSubgroupsList[i]->name)
						 .arg(r.daysOfTheWeek[j])
						 .arg(CustomFETString::number(tmp))
						 .arg(CustomFETString::numberPlusTwoDigitsPrecision((-tmp+this->minHoursDaily)*weightPercentage/100));

						dl.append(s);
						cl.append((-tmp+this->minHoursDaily)*weightPercentage/100);

						*conflictsString+= s+"\n";
					}
				}
			}
		}

		assert(too_little>=0);

		if(c.nPlacedActivities==r.nInternalActivities)
			if(weightPercentage==100) //does not work for partial solutions
				assert(too_little==0);

		return too_little * weightPercentage / 100.0;
	}
	else{
		int tmp1, tmp2;
		int too_little;

		assert(this->minHoursDaily>=0);

		too_little=0;
		for(int sg=0; sg<this->iSubgroupsList.count(); sg++){
			int i=iSubgroupsList.at(sg);
			for(int j=0; j<r.nDaysPerWeek/2; j++){
				tmp1=0;
				for(int k=0; k<r.nHoursPerDay; k++){
					if(subgroupsMatrix[i][2*j][k]>=1)
						tmp1++;
				}

				if(tmp1>0 && tmp1<this->minHoursDaily){
					too_little += - tmp1 + this->minHoursDaily;

					if(conflictsString!=nullptr){
						QString s=tr("Time constraint students set min hours daily broken for subgroup: %1, day: %2, length=%3, conflicts increase=%4")
						 .arg(r.internalSubgroupsList[i]->name)
						 .arg(r.daysOfTheWeek[2*j])
						 .arg(CustomFETString::number(tmp1))
						 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*(-tmp1+this->minHoursDaily)));

						dl.append(s);
						cl.append(weightPercentage/100*(-tmp1+this->minHoursDaily));

						*conflictsString+= s+"\n";
					}
				}

				tmp2=0;
				for(int k=0; k<r.nHoursPerDay; k++){
					if(subgroupsMatrix[i][2*j+1][k]>=1)
						tmp2++;
				}

				if(tmp2>0 && tmp2<this->minHoursDaily){
					too_little += - tmp2 + this->minHoursDaily;

					if(conflictsString!=nullptr){
						QString s=tr("Time constraint students set min hours daily broken for subgroup: %1, day: %2, length=%3, conflicts increase=%4")
						 .arg(r.internalSubgroupsList[i]->name)
						 .arg(r.daysOfTheWeek[2*j+1])
						 .arg(CustomFETString::number(tmp2))
						 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*(-tmp2+this->minHoursDaily)));

						dl.append(s);
						cl.append(weightPercentage/100*(-tmp2+this->minHoursDaily));

						*conflictsString+= s+"\n";
					}
				}

				if(!this->allowEmptyDays==true)
					if(tmp1+tmp2==0){
						too_little++;

						if(conflictsString!=nullptr){
							QString s=tr("Time constraint students set min hours daily broken for subgroup: %1, real day: %2, empty real day, but"
							 " the constraint does not allow empty real days, conflicts increase=%3")
							 .arg(r.internalSubgroupsList[i]->name)
							 .arg(j)
							 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*(1)));

							dl.append(s);
							cl.append(weightPercentage/100*1);

							*conflictsString+= s+"\n";
						}
					}
			}
		}

		assert(too_little>=0);

		if(c.nPlacedActivities==r.nInternalActivities)
			if(weightPercentage==100) //does not work for partial solutions
				assert(too_little==0);

		return too_little * weightPercentage / 100.0;
	}
}

bool ConstraintStudentsSetMinHoursDaily::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsSetMinHoursDaily::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsSetMinHoursDaily::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetMinHoursDaily::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetMinHoursDaily::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	return r.setsShareStudents(this->students, s);
}

int ConstraintStudentsSetMinHoursDaily::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsSetMinHoursDaily::hasWrongDayOrHour(Rules& r)
{
	if(minHoursDaily>r.nHoursPerDay)
		return true;
		
	return false;
}

bool ConstraintStudentsSetMinHoursDaily::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsSetMinHoursDaily::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(minHoursDaily>r.nHoursPerDay)
		minHoursDaily=r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivityPreferredStartingTime::ConstraintActivityPreferredStartingTime()
	: TimeConstraint()
{
	this->type = CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIME;
}

ConstraintActivityPreferredStartingTime::ConstraintActivityPreferredStartingTime(double wp, int actId, int d, int h, bool perm)
	: TimeConstraint(wp)
{
	this->activityId = actId;
	this->day = d;
	this->hour = h;
	this->type = CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIME;
	this->permanentlyLocked=perm;
}

bool ConstraintActivityPreferredStartingTime::operator==(const ConstraintActivityPreferredStartingTime& c){
	if(this->day!=c.day)
		return false;
	if(this->hour!=c.hour)
		return false;
	if(this->activityId!=c.activityId)
		return false;
	if(this->weightPercentage!=c.weightPercentage)
		return false;
	if(this->active!=c.active)
		return false;
	//no need to care about permanently locked
	return true;
}

bool ConstraintActivityPreferredStartingTime::computeInternalStructure(QWidget* parent, Rules& r)
{
	/*Activity* act;
	int i;
	for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];
		if(act->id==this->activityId)
			break;
	}*/
	
	int i=r.activitiesHash.value(activityId, r.nInternalActivities);
	
	if(i==r.nInternalActivities){
		//assert(0);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (because it refers to invalid activity id). Please correct it (maybe removing it is a solution):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}

	if(this->day >= r.nDaysPerWeek){
		TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
		 tr("Constraint activity preferred starting time is wrong because it refers to removed day. Please correct"
		 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
		return false;
	}
	if(this->hour == r.nHoursPerDay){
		TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
		 tr("Constraint activity preferred starting time is wrong because preferred hour is too late (after the last acceptable slot). Please correct"
		 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
		return false;
	}
	if(this->hour > r.nHoursPerDay){
		TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
		 tr("Constraint activity preferred starting time is wrong because it refers to removed hour. Please correct"
		 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
		return false;
	}

	this->activityIndex=i;
	return true;
}

bool ConstraintActivityPreferredStartingTime::hasInactiveActivities(Rules& r)
{
	if(r.inactiveActivities.contains(this->activityId))
		return true;
	return false;
}

QString ConstraintActivityPreferredStartingTime::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintActivityPreferredStartingTime>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Activity_Id>"+CustomFETString::number(this->activityId)+"</Activity_Id>\n";
	if(this->day>=0)
		s+=IL3+"<Day>"+protect(r.daysOfTheWeek[this->day])+"</Day>\n";
	if(this->hour>=0)
		s+=IL3+"<Hour>"+protect(r.hoursOfTheDay[this->hour])+"</Hour>\n";
	s+=IL3+"<Permanently_Locked>";s+=trueFalse(this->permanentlyLocked);s+="</Permanently_Locked>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivityPreferredStartingTime>\n";
	return s;
}

QString ConstraintActivityPreferredStartingTime::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Act. id: %1 (%2) has a preferred starting time: %3", "%1 is the id, %2 is the detailed description of the activity. %3 is time (day and hour)")
	 .arg(getActivityDescription(r, this->activityId))
	 .arg(getActivityDetailedDescription(r, this->activityId))
	 .arg(r.daysOfTheWeek[this->day]+" "+r.hoursOfTheDay[this->hour]);

	s+=translatedCommaSpace();

	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));
	s+=translatedCommaSpace();
	s+=tr("PL:%1", "Abbreviation for permanently locked").arg(yesNoTranslated(this->permanentlyLocked));

	return begin+s+end;
}

QString ConstraintActivityPreferredStartingTime::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
		.arg(this->activityId)
		.arg(getActivityDetailedDescription(r, this->activityId));
	s+="\n";

	s+=tr("has a preferred starting time:");
	s+="\n";
	s+=tr("Day=%1").arg(r.daysOfTheWeek[this->day]);
	s+="\n";
	s+=tr("Hour=%1").arg(r.hoursOfTheDay[this->hour]);
	s+="\n";

	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	if(this->permanentlyLocked){
		s+=tr("This activity is permanently locked, which means you cannot unlock it from the 'Timetable' menu"
		" (you can unlock this activity by removing the constraint from the constraints dialog or by setting the 'permanently"
		" locked' attribute false when editing this constraint)");
	}
	else{
		s+=tr("This activity is not permanently locked, which means you can unlock it from the 'Timetable' menu");
	}
	s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintActivityPreferredStartingTime::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

	nbroken=0;
	if(c.times[this->activityIndex]!=UNALLOCATED_TIME){
		int d=c.times[this->activityIndex]%r.nDaysPerWeek; //the day when this activity was scheduled
		int h=c.times[this->activityIndex]/r.nDaysPerWeek; //the hour
		if(this->day>=0)
			nbroken+=abs(this->day-d);
		if(this->hour>=0)
			nbroken+=abs(this->hour-h);
	}
	if(nbroken>0)
		nbroken=1;

	if(conflictsString!=nullptr && nbroken>0){
		QString s=tr("Time constraint activity preferred starting time broken for activity with id=%1 (%2), increases conflicts total by %3",
			"%1 is the id, %2 is the detailed description of the activity")
			.arg(this->activityId)
			.arg(getActivityDetailedDescription(r, this->activityId))
			.arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*nbroken));

		dl.append(s);
		cl.append(weightPercentage/100*nbroken);
	
		*conflictsString+= s+"\n";
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return nbroken * weightPercentage/100;
}

bool ConstraintActivityPreferredStartingTime::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	if(this->activityId==aid)
		return true;
	return false;
}

bool ConstraintActivityPreferredStartingTime::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivityPreferredStartingTime::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivityPreferredStartingTime::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivityPreferredStartingTime::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);
	
	return false;
}

int ConstraintActivityPreferredStartingTime::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivityPreferredStartingTime::hasWrongDayOrHour(Rules& r)
{
	if(day<0 || day>=r.nDaysPerWeek || hour<0 || hour>=r.nHoursPerDay)
		return true;
	return false;
}

bool ConstraintActivityPreferredStartingTime::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return false;
}

bool ConstraintActivityPreferredStartingTime::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));

	return false;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivityPreferredTimeSlots::ConstraintActivityPreferredTimeSlots()
	: TimeConstraint()
{
	this->type = CONSTRAINT_ACTIVITY_PREFERRED_TIME_SLOTS;
}

ConstraintActivityPreferredTimeSlots::ConstraintActivityPreferredTimeSlots(double wp, int actId, int nPT_L, const QList<int>& d_L, const QList<int>& h_L)
	: TimeConstraint(wp)
{
	assert(d_L.count()==nPT_L);
	assert(h_L.count()==nPT_L);

	this->p_activityId=actId;
	this->p_nPreferredTimeSlots_L=nPT_L;
	this->p_days_L=d_L;
	this->p_hours_L=h_L;
	this->type=CONSTRAINT_ACTIVITY_PREFERRED_TIME_SLOTS;
}

bool ConstraintActivityPreferredTimeSlots::computeInternalStructure(QWidget* parent, Rules& r)
{
	/*Activity* act;
	int i;
	for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];
		if(act->id==this->p_activityId)
			break;
	}*/
	
	int i=r.activitiesHash.value(p_activityId, r.nInternalActivities);

	if(i==r.nInternalActivities){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (because it refers to invalid activity id). Please correct it (maybe removing it is a solution):\n%1").arg(this->getDetailedDescription(r)));
		//assert(0);
		return false;
	}

	for(int k=0; k<p_nPreferredTimeSlots_L; k++){
		if(this->p_days_L[k] >= r.nDaysPerWeek){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activity preferred time slots is wrong because it refers to removed day. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->p_hours_L[k] == r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activity preferred time slots is wrong because a preferred hour is too late (after the last acceptable slot). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->p_hours_L[k] > r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activity preferred time slots is wrong because it refers to removed hour. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}

		if(this->p_hours_L[k]<0 || this->p_days_L[k]<0){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activity preferred time slots is wrong because it has hour or day not specified for a slot (-1). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
	}

	this->p_activityIndex=i;
	return true;
}

bool ConstraintActivityPreferredTimeSlots::hasInactiveActivities(Rules& r)
{
	if(r.inactiveActivities.contains(this->p_activityId))
		return true;
	return false;
}

QString ConstraintActivityPreferredTimeSlots::getXmlDescription(Rules& r)
{
	QString s=IL2+"<ConstraintActivityPreferredTimeSlots>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Activity_Id>"+CustomFETString::number(this->p_activityId)+"</Activity_Id>\n";
	s+=IL3+"<Number_of_Preferred_Time_Slots>"+CustomFETString::number(this->p_nPreferredTimeSlots_L)+"</Number_of_Preferred_Time_Slots>\n";
	for(int i=0; i<p_nPreferredTimeSlots_L; i++){
		s+=IL3+"<Preferred_Time_Slot>\n";
		if(this->p_days_L[i]>=0)
			s+=IL4+"<Day>"+protect(r.daysOfTheWeek[this->p_days_L[i]])+"</Day>\n";
		if(this->p_hours_L[i]>=0)
			s+=IL4+"<Hour>"+protect(r.hoursOfTheDay[this->p_hours_L[i]])+"</Hour>\n";
		s+=IL3+"</Preferred_Time_Slot>\n";
	}
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivityPreferredTimeSlots>\n";
	return s;
}

QString ConstraintActivityPreferredTimeSlots::getDescription(Rules& r)
{
	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Act. id: %1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
		.arg(getActivityDescription(r, this->p_activityId))
		.arg(getActivityDetailedDescription(r, this->p_activityId));
	s+=" ";

	s+=tr("has a set of preferred time slots:");
	s+=" ";
	for(int i=0; i<this->p_nPreferredTimeSlots_L; i++){
		if(this->p_days_L[i]>=0){
			s+=r.daysOfTheWeek[this->p_days_L[i]];
			s+=" ";
		}
		if(this->p_hours_L[i]>=0){
			s+=r.hoursOfTheDay[this->p_hours_L[i]];
		}
		if(i<this->p_nPreferredTimeSlots_L-1)
			s+=translatedSemicolonSpace();
	}
	s+=translatedCommaSpace();

	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintActivityPreferredTimeSlots::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	if(!richText){
		QString s=tr("Time constraint");s+="\n";
		s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			.arg(this->p_activityId)
			.arg(getActivityDetailedDescription(r, this->p_activityId));
		s+="\n";

		s+=tr("has a set of preferred time slots (all hours of the activity must be in the allowed slots):");
		s+="\n";
		for(int i=0; i<this->p_nPreferredTimeSlots_L; i++){
			if(this->p_days_L[i]>=0){
				s+=r.daysOfTheWeek[this->p_days_L[i]];
				s+=" ";
			}
			if(this->p_hours_L[i]>=0){
				s+=r.hoursOfTheDay[this->p_hours_L[i]];
			}
			if(i<this->p_nPreferredTimeSlots_L-1)
				s+=translatedSemicolonSpace();
		}
		s+="\n";

		s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";

		if(!active){
			s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			s+="\n";
		}
		if(!comments.isEmpty()){
			s+=tr("Comments=%1").arg(comments);
			s+="\n";
		}

		return s;
	}
	else{
		QString begin=tr("Time constraint");begin+="\n";
		begin+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			.arg(this->p_activityId)
			.arg(getActivityDetailedDescription(r, this->p_activityId));
		begin+="\n";

		begin+=tr("has a set of preferred time slots (all hours of the activity must be in the allowed slots):");
		begin+="\n";
		
		//the first Boolean is 'direct', the second Boolean is 'not available/selected', the third Boolean is 'color'.
		QString middle=listsOfDaysAndHoursToTable(r, p_days_L, p_hours_L, false, true, colors);
		QString end;
		end+="\n";

		end+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));end+="\n";

		if(!active){
			end+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			end+="\n";
		}
		if(!comments.isEmpty()){
			end+=tr("Comments=%1").arg(comments);
			end+="\n";
		}

		return protect4(begin)+middle+protect4(end);
	}
}

double ConstraintActivityPreferredTimeSlots::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);
	
	Matrix2D<bool> allowed;
	allowed.resize(r.nDaysPerWeek, r.nHoursPerDay);
	for(int d=0; d<r.nDaysPerWeek; d++)
		for(int h=0; h<r.nHoursPerDay; h++)
			allowed[d][h]=false;
	for(int i=0; i<this->p_nPreferredTimeSlots_L; i++){
		if(this->p_days_L[i]>=0 && this->p_hours_L[i]>=0)
			allowed[this->p_days_L[i]][this->p_hours_L[i]]=true;
		else
			assert(0);
	}

	nbroken=0;
	if(c.times[this->p_activityIndex]!=UNALLOCATED_TIME){
		int d=c.times[this->p_activityIndex]%r.nDaysPerWeek; //the day when this activity was scheduled
		int h=c.times[this->p_activityIndex]/r.nDaysPerWeek; //the hour
		for(int dur=0; dur<r.internalActivitiesList[this->p_activityIndex].duration; dur++)
			if(!allowed[d][h+dur])
				nbroken++;
	}

	if(conflictsString!=nullptr && nbroken>0){
		QString s=tr("Time constraint activity preferred time slots broken for activity with id=%1 (%2) on %3 hours, increases conflicts total by %4",
		 "%1 is the id, %2 is the detailed description of the activity.")
		 .arg(this->p_activityId)
		 .arg(getActivityDetailedDescription(r, this->p_activityId))
		 .arg(nbroken)
		 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*nbroken));
		
		dl.append(s);
		cl.append(weightPercentage/100*nbroken);
	
		*conflictsString+= s+"\n";
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return nbroken * weightPercentage/100;
}

bool ConstraintActivityPreferredTimeSlots::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	if(this->p_activityId==aid)
		return true;
	return false;
}

bool ConstraintActivityPreferredTimeSlots::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivityPreferredTimeSlots::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivityPreferredTimeSlots::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivityPreferredTimeSlots::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintActivityPreferredTimeSlots::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivityPreferredTimeSlots::hasWrongDayOrHour(Rules& r)
{
	assert(p_nPreferredTimeSlots_L==p_days_L.count());
	assert(p_nPreferredTimeSlots_L==p_hours_L.count());
	
	for(int i=0; i<p_nPreferredTimeSlots_L; i++)
		if(p_days_L.at(i)<0 || p_days_L.at(i)>=r.nDaysPerWeek
		 || p_hours_L.at(i)<0 || p_hours_L.at(i)>=r.nHoursPerDay)
			return true;

	return false;
}

bool ConstraintActivityPreferredTimeSlots::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintActivityPreferredTimeSlots::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	assert(p_nPreferredTimeSlots_L==p_days_L.count());
	assert(p_nPreferredTimeSlots_L==p_hours_L.count());
	
	QList<int> newDays;
	QList<int> newHours;
	int newNPref=0;
	
	for(int i=0; i<p_nPreferredTimeSlots_L; i++)
		if(p_days_L.at(i)>=0 && p_days_L.at(i)<r.nDaysPerWeek
		 && p_hours_L.at(i)>=0 && p_hours_L.at(i)<r.nHoursPerDay){
			newDays.append(p_days_L.at(i));
			newHours.append(p_hours_L.at(i));
			newNPref++;
		}
	
	p_nPreferredTimeSlots_L=newNPref;
	p_days_L=newDays;
	p_hours_L=newHours;
	
	r.internalStructureComputed=false;
	setRulesModifiedAndOtherThings(&r);

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivitiesPreferredTimeSlots::ConstraintActivitiesPreferredTimeSlots()
	: TimeConstraint()
{
	this->type = CONSTRAINT_ACTIVITIES_PREFERRED_TIME_SLOTS;
}

ConstraintActivitiesPreferredTimeSlots::ConstraintActivitiesPreferredTimeSlots(double wp, const QString& te,
	const QString& st, const QString& su, const QString& sut, int dur, int nPT_L, const QList<int>& d_L, const QList<int>& h_L)
	: TimeConstraint(wp)
{
	assert(dur==-1 || dur>=1);
	duration=dur;

	assert(d_L.count()==nPT_L);
	assert(h_L.count()==nPT_L);

	this->p_teacherName=te;
	this->p_subjectName=su;
	this->p_activityTagName=sut;
	this->p_studentsName=st;
	this->p_nPreferredTimeSlots_L=nPT_L;
	this->p_days_L=d_L;
	this->p_hours_L=h_L;
	this->type=CONSTRAINT_ACTIVITIES_PREFERRED_TIME_SLOTS;
}

bool ConstraintActivitiesPreferredTimeSlots::computeInternalStructure(QWidget* parent, Rules& r)
{
	this->p_nActivities=0;
	this->p_activitiesIndices.clear();

	int it;
	Activity* act;
	int i;
	for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];

		//check if this activity has the corresponding teacher
		if(this->p_teacherName!=""){
			it = act->teachersNames.indexOf(this->p_teacherName);
			if(it==-1)
				continue;
		}
		//check if this activity has the corresponding students
		if(this->p_studentsName!=""){
			bool commonStudents=false;
			for(const QString& st : std::as_const(act->studentsNames))
				if(r.augmentedSetsShareStudentsFaster(st, p_studentsName)){
					commonStudents=true;
					break;
				}
		
			if(!commonStudents)
				continue;
		}
		//check if this activity has the corresponding subject
		if(this->p_subjectName!="" && act->subjectName!=this->p_subjectName){
			continue;
		}
		//check if this activity has the corresponding activity tag
		if(this->p_activityTagName!="" && !act->activityTagsNames.contains(this->p_activityTagName)){
			continue;
		}

		if(duration>=1 && act->duration!=duration)
			continue;
	
		assert(this->p_nActivities < r.nInternalActivities);
		this->p_nActivities++;
		this->p_activitiesIndices.append(i);
	}
	
	assert(this->p_nActivities==this->p_activitiesIndices.count());

	//////////////////////
	for(int k=0; k<p_nPreferredTimeSlots_L; k++){
		if(this->p_days_L[k] >= r.nDaysPerWeek){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities preferred time slots is wrong because it refers to removed day. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->p_hours_L[k] == r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities preferred time slots is wrong because a preferred hour is too late (after the last acceptable slot). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->p_hours_L[k] > r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities preferred time slots is wrong because it refers to removed hour. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->p_hours_L[k]<0 || this->p_days_L[k]<0){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities preferred time slots is wrong because hour or day is not specified for a slot (-1). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
	}
	///////////////////////
	
	if(this->p_nActivities>0)
		return true;
	else{
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to no activities). Please modify, deactivate, or remove it:\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}
}

bool ConstraintActivitiesPreferredTimeSlots::hasInactiveActivities(Rules& r)
{
	QList<int> localActiveActs;
	QList<int> localAllActs;

	//returns true if all activities are inactive
	int it;
	Activity* act;
	int i;
	for(i=0; i<r.activitiesList.count(); i++){
		act=r.activitiesList.at(i);

		//check if this activity has the corresponding teacher
		if(this->p_teacherName!=""){
			it = act->teachersNames.indexOf(this->p_teacherName);
			if(it==-1)
				continue;
		}
		//check if this activity has the corresponding students
		if(this->p_studentsName!=""){
			bool commonStudents=false;
			for(const QString& st : std::as_const(act->studentsNames))
				if(r.setsShareStudents(st, p_studentsName)){
					commonStudents=true;
					break;
				}
		
			if(!commonStudents)
				continue;
		}
		//check if this activity has the corresponding subject
		if(this->p_subjectName!="" && act->subjectName!=this->p_subjectName){
				continue;
		}
		//check if this activity has the corresponding activity tag
		if(this->p_activityTagName!="" && !act->activityTagsNames.contains(this->p_activityTagName)){
				continue;
		}

		if(duration>=1 && act->duration!=duration)
			continue;
	
		if(!r.inactiveActivities.contains(act->id))
			localActiveActs.append(act->id);
			
		localAllActs.append(act->id);
	}

	if(localActiveActs.count()==0 && localAllActs.count()>0)
	//because if this constraint does not refer to any activity,
	//it should be reported as incorrect
		return true;
	else
		return false;
}

QString ConstraintActivitiesPreferredTimeSlots::getXmlDescription(Rules& r)
{
	QString s=IL2+"<ConstraintActivitiesPreferredTimeSlots>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Teacher>"+protect(this->p_teacherName)+"</Teacher>\n";
	s+=IL3+"<Students>"+protect(this->p_studentsName)+"</Students>\n";
	s+=IL3+"<Subject>"+protect(this->p_subjectName)+"</Subject>\n";
	s+=IL3+"<Activity_Tag>"+protect(this->p_activityTagName)+"</Activity_Tag>\n";
	if(duration>=1)
		s+=IL3+"<Duration>"+CustomFETString::number(duration)+"</Duration>\n";
	else
		s+=IL3+"<Duration></Duration>\n";
	s+=IL3+"<Number_of_Preferred_Time_Slots>"+CustomFETString::number(this->p_nPreferredTimeSlots_L)+"</Number_of_Preferred_Time_Slots>\n";
	for(int i=0; i<p_nPreferredTimeSlots_L; i++){
		s+=IL3+"<Preferred_Time_Slot>\n";
		if(this->p_days_L[i]>=0)
			s+=IL4+"<Day>"+protect(r.daysOfTheWeek[this->p_days_L[i]])+"</Day>\n";
		if(this->p_hours_L[i]>=0)
			s+=IL4+"<Hour>"+protect(r.hoursOfTheDay[this->p_hours_L[i]])+"</Hour>\n";
		s+=IL3+"</Preferred_Time_Slot>\n";
	}
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivitiesPreferredTimeSlots>\n";
	return s;
}

QString ConstraintActivitiesPreferredTimeSlots::getDescription(Rules& r)
{
	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;

	QString tc, st, su, at, dur;
	
	if(this->p_teacherName!="")
		tc=tr("teacher=%1").arg(this->p_teacherName);
	else
		tc=tr("all teachers");
		
	if(this->p_studentsName!="")
		st=tr("students=%1").arg(this->p_studentsName);
	else
		st=tr("all students");
		
	if(this->p_subjectName!="")
		su=tr("subject=%1").arg(this->p_subjectName);
	else
		su=tr("all subjects");
		
	if(this->p_activityTagName!="")
		at=tr("activity tag=%1").arg(this->p_activityTagName);
	else
		at=tr("all activity tags");
	
	if(duration>=1)
		dur=tr("duration=%1").arg(duration);
	else
		dur=tr("all durations");

	s+=tr("Activities with %1, %2, %3, %4, %5, have a set of preferred time slots:", "%1...%5 are conditions for the activities").arg(tc).arg(st).arg(su).arg(at).arg(dur);
	s+=" ";
	for(int i=0; i<this->p_nPreferredTimeSlots_L; i++){
		if(this->p_days_L[i]>=0){
			s+=r.daysOfTheWeek[this->p_days_L[i]];
			s+=" ";
		}
		if(this->p_hours_L[i]>=0){
			s+=r.hoursOfTheDay[this->p_hours_L[i]];
		}
		if(i<this->p_nPreferredTimeSlots_L-1)
			s+=translatedSemicolonSpace();
	}
	s+=translatedCommaSpace();

	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintActivitiesPreferredTimeSlots::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	if(!richText){
		QString s=tr("Time constraint");s+="\n";
		s+=tr("Activities with:");s+="\n";

		if(this->p_teacherName!="")
			s+=tr("Teacher=%1").arg(this->p_teacherName);
		else
			s+=tr("All teachers");
		s+="\n";
		if(this->p_studentsName!="")
			s+=tr("Students=%1").arg(this->p_studentsName);
		else
			s+=tr("All students");
		s+="\n";
		if(this->p_subjectName!="")
			s+=tr("Subject=%1").arg(this->p_subjectName);
		else
			s+=tr("All subjects");
		s+="\n";
		if(this->p_activityTagName!="")
			s+=tr("Activity tag=%1").arg(this->p_activityTagName);
		else
			s+=tr("All activity tags");
		s+="\n";

		if(duration>=1)
			s+=tr("Duration=%1").arg(duration);
		else
			s+=tr("All durations");
		s+="\n";

		s+=tr("have a set of preferred time slots (all hours of each affected activity must be in the allowed slots):");
		s+="\n";
		for(int i=0; i<this->p_nPreferredTimeSlots_L; i++){
			if(this->p_days_L[i]>=0){
				s+=r.daysOfTheWeek[this->p_days_L[i]];
				s+=" ";
			}
			if(this->p_hours_L[i]>=0){
				s+=r.hoursOfTheDay[this->p_hours_L[i]];
			}
			if(i<this->p_nPreferredTimeSlots_L-1)
				s+=translatedSemicolonSpace();
		}
		s+="\n";

		s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";

		if(!active){
			s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			s+="\n";
		}
		if(!comments.isEmpty()){
			s+=tr("Comments=%1").arg(comments);
			s+="\n";
		}

		return s;
	}
	else{
		QString begin=tr("Time constraint");begin+="\n";
		begin+=tr("Activities with:");begin+="\n";

		if(this->p_teacherName!="")
			begin+=tr("Teacher=%1").arg(this->p_teacherName);
		else
			begin+=tr("All teachers");
		begin+="\n";
		if(this->p_studentsName!="")
			begin+=tr("Students=%1").arg(this->p_studentsName);
		else
			begin+=tr("All students");
		begin+="\n";
		if(this->p_subjectName!="")
			begin+=tr("Subject=%1").arg(this->p_subjectName);
		else
			begin+=tr("All subjects");
		begin+="\n";
		if(this->p_activityTagName!="")
			begin+=tr("Activity tag=%1").arg(this->p_activityTagName);
		else
			begin+=tr("All activity tags");
		begin+="\n";

		if(duration>=1)
			begin+=tr("Duration=%1").arg(duration);
		else
			begin+=tr("All durations");
		begin+="\n";

		begin+=tr("have a set of preferred time slots (all hours of each affected activity must be in the allowed slots):");
		begin+="\n";

		//the first Boolean is 'direct', the second Boolean is 'not available/selected', the third Boolean is 'color'.
		QString middle=listsOfDaysAndHoursToTable(r, p_days_L, p_hours_L, false, true, colors);
		QString end;
		end+="\n";

		end+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));end+="\n";

		if(!active){
			end+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			end+="\n";
		}
		if(!comments.isEmpty()){
			end+=tr("Comments=%1").arg(comments);
			end+="\n";
		}

		return protect4(begin)+middle+protect4(end);
	}
}

double ConstraintActivitiesPreferredTimeSlots::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

///////////////////
	Matrix2D<bool> allowed;
	allowed.resize(r.nDaysPerWeek, r.nHoursPerDay);
	for(int d=0; d<r.nDaysPerWeek; d++)
		for(int h=0; h<r.nHoursPerDay; h++)
			allowed[d][h]=false;
	for(int i=0; i<this->p_nPreferredTimeSlots_L; i++){
		if(this->p_days_L[i]>=0 && this->p_hours_L[i]>=0)
			allowed[this->p_days_L[i]][this->p_hours_L[i]]=true;
		else
			assert(0);
	}
////////////////////

	nbroken=0;
	int tmp;
	
	for(int i=0; i<this->p_nActivities; i++){
		tmp=0;
		int ai=this->p_activitiesIndices[i];
		if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek; //the day when this activity was scheduled
			int h=c.times[ai]/r.nDaysPerWeek; //the hour
			
			for(int dur=0; dur<r.internalActivitiesList[ai].duration; dur++)
				if(!allowed[d][h+dur])
					tmp++;
		}
		nbroken+=tmp;
		if(conflictsString!=nullptr && tmp>0){
			QString s=tr("Time constraint activities preferred time slots broken"
			 " for activity with id=%1 (%2) on %3 hours,"
			 " increases conflicts total by %4", "%1 is the id, %2 is the detailed description of the activity.")
			 .arg(r.internalActivitiesList[ai].id)
			 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[ai].id))
			 .arg(tmp)
			 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*tmp));
			
			dl.append(s);
			cl.append(weightPercentage/100*tmp);
		
			*conflictsString+= s+"\n";
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return nbroken * weightPercentage / 100.0;
}

bool ConstraintActivitiesPreferredTimeSlots::isRelatedToActivity(Rules& r, int aid)
{
	Activity* a=r.activitiesPointerHash.value(aid, nullptr);
	assert(a!=nullptr);

	int it;

	//check if this activity has the corresponding teacher
	if(this->p_teacherName!=""){
		it = a->teachersNames.indexOf(this->p_teacherName);
		if(it==-1)
			return false;
	}
	//check if this activity has the corresponding students
	if(this->p_studentsName!=""){
		bool commonStudents=false;
		for(const QString& st : std::as_const(a->studentsNames)){
			if(r.setsShareStudents(st, this->p_studentsName)){
				commonStudents=true;
				break;
			}
		}
		if(!commonStudents)
			return false;
	}
	//check if this activity has the corresponding subject
	if(this->p_subjectName!="" && a->subjectName!=this->p_subjectName)
		return false;
	//check if this activity has the corresponding activity tag
	if(this->p_activityTagName!="" && !a->activityTagsNames.contains(this->p_activityTagName))
		return false;

	if(duration>=1 && a->duration!=duration)
		return false;

	return true;
}

bool ConstraintActivitiesPreferredTimeSlots::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivitiesPreferredTimeSlots::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesPreferredTimeSlots::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesPreferredTimeSlots::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);
	
	return false;
}

int ConstraintActivitiesPreferredTimeSlots::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivitiesPreferredTimeSlots::hasWrongDayOrHour(Rules& r)
{
	assert(p_nPreferredTimeSlots_L==p_days_L.count());
	assert(p_nPreferredTimeSlots_L==p_hours_L.count());
	
	for(int i=0; i<p_nPreferredTimeSlots_L; i++)
		if(p_days_L.at(i)<0 || p_days_L.at(i)>=r.nDaysPerWeek
		 || p_hours_L.at(i)<0 || p_hours_L.at(i)>=r.nHoursPerDay)
			return true;

	return false;
}

bool ConstraintActivitiesPreferredTimeSlots::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintActivitiesPreferredTimeSlots::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	assert(p_nPreferredTimeSlots_L==p_days_L.count());
	assert(p_nPreferredTimeSlots_L==p_hours_L.count());
	
	QList<int> newDays;
	QList<int> newHours;
	int newNPref=0;
	
	for(int i=0; i<p_nPreferredTimeSlots_L; i++)
		if(p_days_L.at(i)>=0 && p_days_L.at(i)<r.nDaysPerWeek
		 && p_hours_L.at(i)>=0 && p_hours_L.at(i)<r.nHoursPerDay){
			newDays.append(p_days_L.at(i));
			newHours.append(p_hours_L.at(i));
			newNPref++;
		}
	
	p_nPreferredTimeSlots_L=newNPref;
	p_days_L=newDays;
	p_hours_L=newHours;
	
	r.internalStructureComputed=false;
	setRulesModifiedAndOtherThings(&r);

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintSubactivitiesPreferredTimeSlots::ConstraintSubactivitiesPreferredTimeSlots()
	: TimeConstraint()
{
	this->type = CONSTRAINT_SUBACTIVITIES_PREFERRED_TIME_SLOTS;
}

ConstraintSubactivitiesPreferredTimeSlots::ConstraintSubactivitiesPreferredTimeSlots(double wp, int compNo, const QString& te,
	const QString& st, const QString& su, const QString& sut, int dur, int nPT_L, const QList<int>& d_L, const QList<int>& h_L)
	: TimeConstraint(wp)
{
	assert(dur==-1 || dur>=1);
	duration=dur;

	assert(d_L.count()==nPT_L);
	assert(h_L.count()==nPT_L);

	this->componentNumber=compNo;
	this->p_teacherName=te;
	this->p_subjectName=su;
	this->p_activityTagName=sut;
	this->p_studentsName=st;
	this->p_nPreferredTimeSlots_L=nPT_L;
	this->p_days_L=d_L;
	this->p_hours_L=h_L;
	this->type=CONSTRAINT_SUBACTIVITIES_PREFERRED_TIME_SLOTS;
}

bool ConstraintSubactivitiesPreferredTimeSlots::computeInternalStructure(QWidget* parent, Rules& r)
{
	this->p_nActivities=0;
	this->p_activitiesIndices.clear();

	int it;
	Activity* act;
	int i;
	for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];
		
		if(!act->representsComponentNumber(this->componentNumber))
			continue;

		//check if this activity has the corresponding teacher
		if(this->p_teacherName!=""){
			it = act->teachersNames.indexOf(this->p_teacherName);
			if(it==-1)
				continue;
		}
		//check if this activity has the corresponding students
		if(this->p_studentsName!=""){
			bool commonStudents=false;
			for(const QString& st : std::as_const(act->studentsNames))
				if(r.augmentedSetsShareStudentsFaster(st, p_studentsName)){
					commonStudents=true;
					break;
				}
		
			if(!commonStudents)
				continue;
		}
		//check if this activity has the corresponding subject
		if(this->p_subjectName!="" && act->subjectName!=this->p_subjectName){
			continue;
		}
		//check if this activity has the corresponding activity tag
		if(this->p_activityTagName!="" && !act->activityTagsNames.contains(this->p_activityTagName)){
			continue;
		}

		if(duration>=1 && act->duration!=duration)
			continue;
	
		assert(this->p_nActivities < r.nInternalActivities);
		this->p_nActivities++;
		this->p_activitiesIndices.append(i);
	}

	assert(this->p_nActivities==this->p_activitiesIndices.count());

	//////////////////////
	for(int k=0; k<p_nPreferredTimeSlots_L; k++){
		if(this->p_days_L[k] >= r.nDaysPerWeek){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint subactivities preferred time slots is wrong because it refers to removed day. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->p_hours_L[k] == r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint subactivities preferred time slots is wrong because a preferred hour is too late (after the last acceptable slot). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->p_hours_L[k] > r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint subactivities preferred time slots is wrong because it refers to removed hour. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->p_hours_L[k]<0 || this->p_days_L[k]<0){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint subactivities preferred time slots is wrong because hour or day is not specified for a slot (-1). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
	}
	///////////////////////
	
	if(this->p_nActivities>0)
		return true;
	else{
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to no activities). Please modify, deactivate, or remove it:\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}
}

bool ConstraintSubactivitiesPreferredTimeSlots::hasInactiveActivities(Rules& r)
{
	QList<int> localActiveActs;
	QList<int> localAllActs;

	//returns true if all activities are inactive
	int it;
	Activity* act;
	int i;
	for(i=0; i<r.activitiesList.count(); i++){
		act=r.activitiesList.at(i);

		if(!act->representsComponentNumber(this->componentNumber))
			continue;

		//check if this activity has the corresponding teacher
		if(this->p_teacherName!=""){
			it = act->teachersNames.indexOf(this->p_teacherName);
			if(it==-1)
				continue;
		}
		//check if this activity has the corresponding students
		if(this->p_studentsName!=""){
			bool commonStudents=false;
			for(const QString& st : std::as_const(act->studentsNames))
				if(r.setsShareStudents(st, p_studentsName)){
					commonStudents=true;
					break;
				}
		
			if(!commonStudents)
				continue;
		}
		//check if this activity has the corresponding subject
		if(this->p_subjectName!="" && act->subjectName!=this->p_subjectName){
				continue;
		}
		//check if this activity has the corresponding activity tag
		if(this->p_activityTagName!="" && !act->activityTagsNames.contains(this->p_activityTagName)){
				continue;
		}

		if(duration>=1 && act->duration!=duration)
			continue;
	
		if(!r.inactiveActivities.contains(act->id))
			localActiveActs.append(act->id);
			
		localAllActs.append(act->id);
	}

	if(localActiveActs.count()==0 && localAllActs.count()>0)
		return true;
	else
		return false;
}

QString ConstraintSubactivitiesPreferredTimeSlots::getXmlDescription(Rules& r)
{
	QString s=IL2+"<ConstraintSubactivitiesPreferredTimeSlots>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Component_Number>"+CustomFETString::number(this->componentNumber)+"</Component_Number>\n";
	s+=IL3+"<Teacher>"+protect(this->p_teacherName)+"</Teacher>\n";
	s+=IL3+"<Students>"+protect(this->p_studentsName)+"</Students>\n";
	s+=IL3+"<Subject>"+protect(this->p_subjectName)+"</Subject>\n";
	s+=IL3+"<Activity_Tag>"+protect(this->p_activityTagName)+"</Activity_Tag>\n";
	if(duration>=1)
		s+=IL3+"<Duration>"+CustomFETString::number(duration)+"</Duration>\n";
	else
		s+=IL3+"<Duration></Duration>\n";
	s+=IL3+"<Number_of_Preferred_Time_Slots>"+CustomFETString::number(this->p_nPreferredTimeSlots_L)+"</Number_of_Preferred_Time_Slots>\n";
	for(int i=0; i<p_nPreferredTimeSlots_L; i++){
		s+=IL3+"<Preferred_Time_Slot>\n";
		if(this->p_days_L[i]>=0)
			s+=IL4+"<Day>"+protect(r.daysOfTheWeek[this->p_days_L[i]])+"</Day>\n";
		if(this->p_hours_L[i]>=0)
			s+=IL4+"<Hour>"+protect(r.hoursOfTheDay[this->p_hours_L[i]])+"</Hour>\n";
		s+=IL3+"</Preferred_Time_Slot>\n";
	}
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintSubactivitiesPreferredTimeSlots>\n";
	return s;
}

QString ConstraintSubactivitiesPreferredTimeSlots::getDescription(Rules& r)
{
	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	
	QString tc, st, su, at, dur;
	
	if(this->p_teacherName!="")
		tc=tr("teacher=%1").arg(this->p_teacherName);
	else
		tc=tr("all teachers");
		
	if(this->p_studentsName!="")
		st=tr("students=%1").arg(this->p_studentsName);
	else
		st=tr("all students");
		
	if(this->p_subjectName!="")
		su=tr("subject=%1").arg(this->p_subjectName);
	else
		su=tr("all subjects");
		
	if(this->p_activityTagName!="")
		at=tr("activity tag=%1").arg(this->p_activityTagName);
	else
		at=tr("all activity tags");
	
	if(duration>=1)
		dur=tr("duration=%1").arg(duration);
	else
		dur=tr("all durations");

	s+=tr("Subactivities with %1, %2, %3, %4, %5, %6, have a set of preferred time slots:", "%1...%6 are conditions for the subactivities")
		.arg(tr("component number=%1").arg(this->componentNumber)).arg(tc).arg(st).arg(su).arg(at).arg(dur);
		
	s+=" ";
	
	for(int i=0; i<this->p_nPreferredTimeSlots_L; i++){
		if(this->p_days_L[i]>=0){
			s+=r.daysOfTheWeek[this->p_days_L[i]];
			s+=" ";
		}
		if(this->p_hours_L[i]>=0){
			s+=r.hoursOfTheDay[this->p_hours_L[i]];
		}
		if(i<this->p_nPreferredTimeSlots_L-1)
			s+=translatedSemicolonSpace();
	}
	s+=translatedCommaSpace();

	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintSubactivitiesPreferredTimeSlots::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	if(!richText){
		QString s=tr("Time constraint");s+="\n";
		s+=tr("Subactivities with:");s+="\n";
		
		s+=tr("Component number=%1").arg(this->componentNumber);
		s+="\n";

		if(this->p_teacherName!="")
			s+=tr("Teacher=%1").arg(this->p_teacherName);
		else
			s+=tr("All teachers");
		s+="\n";
		
		if(this->p_studentsName!="")
			s+=tr("Students=%1").arg(this->p_studentsName);
		else
			s+=tr("All students");
		s+="\n";
		
		if(this->p_subjectName!="")
			s+=tr("Subject=%1").arg(this->p_subjectName);
		else
			s+=tr("All subjects");
		s+="\n";
		
		if(this->p_activityTagName!="")
			s+=tr("Activity tag=%1").arg(this->p_activityTagName);
		else
			s+=tr("All activity tags");
		s+="\n";

		if(duration>=1)
			s+=tr("Duration=%1").arg(duration);
		else
			s+=tr("All durations");
		s+="\n";

		s+=tr("have a set of preferred time slots (all hours of each affected subactivity must be in the allowed slots):");
		s+="\n";
		for(int i=0; i<this->p_nPreferredTimeSlots_L; i++){
			if(this->p_days_L[i]>=0){
				s+=r.daysOfTheWeek[this->p_days_L[i]];
				s+=" ";
			}
			if(this->p_hours_L[i]>=0){
				s+=r.hoursOfTheDay[this->p_hours_L[i]];
			}
			if(i<this->p_nPreferredTimeSlots_L-1)
				s+=translatedSemicolonSpace();
		}
		s+="\n";

		s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";

		if(!active){
			s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			s+="\n";
		}
		if(!comments.isEmpty()){
			s+=tr("Comments=%1").arg(comments);
			s+="\n";
		}

		return s;
	}
	else{
		QString begin=tr("Time constraint");begin+="\n";
		begin+=tr("Subactivities with:");begin+="\n";
		
		begin+=tr("Component number=%1").arg(this->componentNumber);
		begin+="\n";

		if(this->p_teacherName!="")
			begin+=tr("Teacher=%1").arg(this->p_teacherName);
		else
			begin+=tr("All teachers");
		begin+="\n";
		
		if(this->p_studentsName!="")
			begin+=tr("Students=%1").arg(this->p_studentsName);
		else
			begin+=tr("All students");
		begin+="\n";
		
		if(this->p_subjectName!="")
			begin+=tr("Subject=%1").arg(this->p_subjectName);
		else
			begin+=tr("All subjects");
		begin+="\n";
		
		if(this->p_activityTagName!="")
			begin+=tr("Activity tag=%1").arg(this->p_activityTagName);
		else
			begin+=tr("All activity tags");
		begin+="\n";

		if(duration>=1)
			begin+=tr("Duration=%1").arg(duration);
		else
			begin+=tr("All durations");
		begin+="\n";

		begin+=tr("have a set of preferred time slots (all hours of each affected subactivity must be in the allowed slots):");
		begin+="\n";

		//the first Boolean is 'direct', the second Boolean is 'not available/selected', the third Boolean is 'color'.
		QString middle=listsOfDaysAndHoursToTable(r, p_days_L, p_hours_L, false, true, colors);
		QString end;
		end+="\n";

		end+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));end+="\n";

		if(!active){
			end+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			end+="\n";
		}
		if(!comments.isEmpty()){
			end+=tr("Comments=%1").arg(comments);
			end+="\n";
		}

		return protect4(begin)+middle+protect4(end);
	}
}

double ConstraintSubactivitiesPreferredTimeSlots::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

///////////////////
	Matrix2D<bool> allowed;
	allowed.resize(r.nDaysPerWeek, r.nHoursPerDay);
	for(int d=0; d<r.nDaysPerWeek; d++)
		for(int h=0; h<r.nHoursPerDay; h++)
			allowed[d][h]=false;
	for(int i=0; i<this->p_nPreferredTimeSlots_L; i++){
		if(this->p_days_L[i]>=0 && this->p_hours_L[i]>=0)
			allowed[this->p_days_L[i]][this->p_hours_L[i]]=true;
		else
			assert(0);
	}
////////////////////

	nbroken=0;
	int tmp;
	
	for(int i=0; i<this->p_nActivities; i++){
		tmp=0;
		int ai=this->p_activitiesIndices[i];
		if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek; //the day when this activity was scheduled
			int h=c.times[ai]/r.nDaysPerWeek; //the hour
			
			for(int dur=0; dur<r.internalActivitiesList[ai].duration; dur++)
				if(!allowed[d][h+dur])
					tmp++;
		}
		nbroken+=tmp;
		if(conflictsString!=nullptr && tmp>0){
			QString s=tr("Time constraint subactivities preferred time slots broken"
			 " for activity with id=%1 (%2), component number %3, on %4 hours,"
			 " increases conflicts total by %5", "%1 is the id, %2 is the detailed description of the activity.")
			 .arg(r.internalActivitiesList[ai].id)
			 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[ai].id))
			 .arg(componentNumber)
			 .arg(tmp)
			 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*tmp));

			dl.append(s);
			cl.append(weightPercentage/100*tmp);
		
			*conflictsString+= s+"\n";
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return nbroken * weightPercentage / 100.0;
}

bool ConstraintSubactivitiesPreferredTimeSlots::isRelatedToActivity(Rules& r, int aid)
{
	Activity* a=r.activitiesPointerHash.value(aid, nullptr);
	assert(a!=nullptr);

	if(!a->representsComponentNumber(this->componentNumber))
		return false;

	int it;

	//check if this activity has the corresponding teacher
	if(this->p_teacherName!=""){
		it = a->teachersNames.indexOf(this->p_teacherName);
		if(it==-1)
			return false;
	}
	//check if this activity has the corresponding students
	if(this->p_studentsName!=""){
		bool commonStudents=false;
		for(const QString& st : std::as_const(a->studentsNames)){
			if(r.setsShareStudents(st, this->p_studentsName)){
				commonStudents=true;
				break;
			}
		}
		if(!commonStudents)
			return false;
	}
	//check if this activity has the corresponding subject
	if(this->p_subjectName!="" && a->subjectName!=this->p_subjectName)
		return false;
	//check if this activity has the corresponding activity tag
	if(this->p_activityTagName!="" && !a->activityTagsNames.contains(this->p_activityTagName))
		return false;

	if(duration>=1 && a->duration!=duration)
		return false;

	return true;
}

bool ConstraintSubactivitiesPreferredTimeSlots::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintSubactivitiesPreferredTimeSlots::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintSubactivitiesPreferredTimeSlots::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintSubactivitiesPreferredTimeSlots::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintSubactivitiesPreferredTimeSlots::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintSubactivitiesPreferredTimeSlots::hasWrongDayOrHour(Rules& r)
{
	assert(p_nPreferredTimeSlots_L==p_days_L.count());
	assert(p_nPreferredTimeSlots_L==p_hours_L.count());
	
	for(int i=0; i<p_nPreferredTimeSlots_L; i++)
		if(p_days_L.at(i)<0 || p_days_L.at(i)>=r.nDaysPerWeek
		 || p_hours_L.at(i)<0 || p_hours_L.at(i)>=r.nHoursPerDay)
			return true;

	return false;
}

bool ConstraintSubactivitiesPreferredTimeSlots::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintSubactivitiesPreferredTimeSlots::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	assert(p_nPreferredTimeSlots_L==p_days_L.count());
	assert(p_nPreferredTimeSlots_L==p_hours_L.count());
	
	QList<int> newDays;
	QList<int> newHours;
	int newNPref=0;
	
	for(int i=0; i<p_nPreferredTimeSlots_L; i++)
		if(p_days_L.at(i)>=0 && p_days_L.at(i)<r.nDaysPerWeek
		 && p_hours_L.at(i)>=0 && p_hours_L.at(i)<r.nHoursPerDay){
			newDays.append(p_days_L.at(i));
			newHours.append(p_hours_L.at(i));
			newNPref++;
		}
	
	p_nPreferredTimeSlots_L=newNPref;
	p_days_L=newDays;
	p_hours_L=newHours;
	
	r.internalStructureComputed=false;
	setRulesModifiedAndOtherThings(&r);

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivityPreferredStartingTimes::ConstraintActivityPreferredStartingTimes()
	: TimeConstraint()
{
	this->type = CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIMES;
}

ConstraintActivityPreferredStartingTimes::ConstraintActivityPreferredStartingTimes(double wp, int actId, int nPT_L, const QList<int>& d_L, const QList<int>& h_L)
	: TimeConstraint(wp)
{
	assert(d_L.count()==nPT_L);
	assert(h_L.count()==nPT_L);

	this->activityId=actId;
	this->nPreferredStartingTimes_L=nPT_L;
	this->days_L=d_L;
	this->hours_L=h_L;
	this->type=CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIMES;
}

bool ConstraintActivityPreferredStartingTimes::computeInternalStructure(QWidget* parent, Rules& r)
{
	/*Activity* act;
	int i;
	for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];
		if(act->id==this->activityId)
			break;
	}*/
	
	int i=r.activitiesHash.value(activityId, r.nInternalActivities);

	if(i==r.nInternalActivities){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (because it refers to invalid activity id). Please correct it (maybe removing it is a solution):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}

	for(int k=0; k<nPreferredStartingTimes_L; k++){
		if(this->days_L[k] >= r.nDaysPerWeek){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activity preferred starting times is wrong because it refers to removed day. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->hours_L[k] == r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activity preferred starting times is wrong because a preferred hour is too late (after the last acceptable slot). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->hours_L[k] > r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activity preferred starting times is wrong because it refers to removed hour. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
	}

	this->activityIndex=i;
	return true;
}

bool ConstraintActivityPreferredStartingTimes::hasInactiveActivities(Rules& r)
{
	if(r.inactiveActivities.contains(this->activityId))
		return true;
	return false;
}

QString ConstraintActivityPreferredStartingTimes::getXmlDescription(Rules& r)
{
	QString s=IL2+"<ConstraintActivityPreferredStartingTimes>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Activity_Id>"+CustomFETString::number(this->activityId)+"</Activity_Id>\n";
	s+=IL3+"<Number_of_Preferred_Starting_Times>"+CustomFETString::number(this->nPreferredStartingTimes_L)+"</Number_of_Preferred_Starting_Times>\n";
	for(int i=0; i<nPreferredStartingTimes_L; i++){
		s+=IL3+"<Preferred_Starting_Time>\n";
		if(this->days_L[i]>=0)
			s+=IL4+"<Day>"+protect(r.daysOfTheWeek[this->days_L[i]])+"</Day>\n";
		if(this->hours_L[i]>=0)
			s+=IL4+"<Hour>"+protect(r.hoursOfTheDay[this->hours_L[i]])+"</Hour>\n";
		s+=IL3+"</Preferred_Starting_Time>\n";
	}
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivityPreferredStartingTimes>\n";
	return s;
}

QString ConstraintActivityPreferredStartingTimes::getDescription(Rules& r)
{
	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Act. id: %1 (%2)", "%1 is the id, %2 is the detailed description of the activity.")
		.arg(getActivityDescription(r, this->activityId))
		.arg(getActivityDetailedDescription(r, this->activityId));
	
	s+=" ";
	s+=tr("has a set of preferred starting times:");
	s+=" ";
	for(int i=0; i<this->nPreferredStartingTimes_L; i++){
		if(this->days_L[i]>=0){
			s+=r.daysOfTheWeek[this->days_L[i]];
			s+=" ";
		}
		if(this->hours_L[i]>=0){
			s+=r.hoursOfTheDay[this->hours_L[i]];
		}
		if(i<nPreferredStartingTimes_L-1)
			s+=translatedSemicolonSpace();
	}
	s+=translatedCommaSpace();

	s+=tr("WP:%1%", "Weight Percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintActivityPreferredStartingTimes::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	if(!richText){
		QString s=tr("Time constraint");s+="\n";
		s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			.arg(this->activityId)
			.arg(getActivityDetailedDescription(r, this->activityId));
		
		s+="\n";
		s+=tr("has a set of preferred starting times:");
		s+="\n";
		for(int i=0; i<this->nPreferredStartingTimes_L; i++){
			if(this->days_L[i]>=0){
				s+=r.daysOfTheWeek[this->days_L[i]];
				s+=" ";
			}
			if(this->hours_L[i]>=0){
				s+=r.hoursOfTheDay[this->hours_L[i]];
			}
			if(i<this->nPreferredStartingTimes_L-1)
				s+=translatedSemicolonSpace();
		}
		s+="\n";

		s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";

		if(!active){
			s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			s+="\n";
		}
		if(!comments.isEmpty()){
			s+=tr("Comments=%1").arg(comments);
			s+="\n";
		}

		return s;
	}
	else{
		QString begin=tr("Time constraint");begin+="\n";
		begin+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			.arg(this->activityId)
			.arg(getActivityDetailedDescription(r, this->activityId));
		
		begin+="\n";
		begin+=tr("has a set of preferred starting times:");
		begin+="\n";

		//the first Boolean is 'direct', the second Boolean is 'not available/selected', the third Boolean is 'color'.
		QString middle=listsOfDaysAndHoursToTable(r, days_L, hours_L, false, true, colors);
		QString end;
		end+="\n";

		end+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));end+="\n";

		if(!active){
			end+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			end+="\n";
		}
		if(!comments.isEmpty()){
			end+=tr("Comments=%1").arg(comments);
			end+="\n";
		}

		return protect4(begin)+middle+protect4(end);
	}
}

double ConstraintActivityPreferredStartingTimes::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

	nbroken=0;
	if(c.times[this->activityIndex]!=UNALLOCATED_TIME){
		int d=c.times[this->activityIndex]%r.nDaysPerWeek; //the day when this activity was scheduled
		int h=c.times[this->activityIndex]/r.nDaysPerWeek; //the hour
		int i;
		for(i=0; i<this->nPreferredStartingTimes_L; i++){
			if(this->days_L[i]>=0 && this->days_L[i]!=d)
				continue;
			if(this->hours_L[i]>=0 && this->hours_L[i]!=h)
				continue;
			break;
		}
		if(i==this->nPreferredStartingTimes_L){
			nbroken=1;
		}
	}

	if(conflictsString!=nullptr && nbroken>0){
		QString s=tr("Time constraint activity preferred starting times broken for activity with id=%1 (%2), increases conflicts total by %3",
		 "%1 is the id, %2 is the detailed description of the activity")
		 .arg(this->activityId)
		 .arg(getActivityDetailedDescription(r, this->activityId))
		 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*nbroken));

		dl.append(s);
		cl.append(weightPercentage/100*nbroken);
	
		*conflictsString+= s+"\n";
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return nbroken * weightPercentage/100;
}

bool ConstraintActivityPreferredStartingTimes::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	if(this->activityId==aid)
		return true;
	return false;
}

bool ConstraintActivityPreferredStartingTimes::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivityPreferredStartingTimes::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivityPreferredStartingTimes::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivityPreferredStartingTimes::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintActivityPreferredStartingTimes::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivityPreferredStartingTimes::hasWrongDayOrHour(Rules& r)
{
	assert(nPreferredStartingTimes_L==days_L.count());
	assert(nPreferredStartingTimes_L==hours_L.count());
	
	for(int i=0; i<nPreferredStartingTimes_L; i++)
		if(days_L.at(i)<0 || days_L.at(i)>=r.nDaysPerWeek
		 || hours_L.at(i)<0 || hours_L.at(i)>=r.nHoursPerDay)
			return true;

	return false;
}

bool ConstraintActivityPreferredStartingTimes::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintActivityPreferredStartingTimes::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	assert(nPreferredStartingTimes_L==days_L.count());
	assert(nPreferredStartingTimes_L==hours_L.count());
	
	QList<int> newDays;
	QList<int> newHours;
	int newNPref=0;
	
	for(int i=0; i<nPreferredStartingTimes_L; i++)
		if(days_L.at(i)>=0 && days_L.at(i)<r.nDaysPerWeek
		 && hours_L.at(i)>=0 && hours_L.at(i)<r.nHoursPerDay){
			newDays.append(days_L.at(i));
			newHours.append(hours_L.at(i));
			newNPref++;
		}
	
	nPreferredStartingTimes_L=newNPref;
	days_L=newDays;
	hours_L=newHours;
	
	r.internalStructureComputed=false;
	setRulesModifiedAndOtherThings(&r);

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivitiesPreferredStartingTimes::ConstraintActivitiesPreferredStartingTimes()
	: TimeConstraint()
{
	this->type = CONSTRAINT_ACTIVITIES_PREFERRED_STARTING_TIMES;
}

ConstraintActivitiesPreferredStartingTimes::ConstraintActivitiesPreferredStartingTimes(double wp, const QString& te,
	const QString& st, const QString& su, const QString& sut, int dur, int nPT_L, const QList<int>& d_L, const QList<int>& h_L)
	: TimeConstraint(wp)
{
	assert(dur==-1 || dur>=1);
	duration=dur;

	assert(d_L.count()==nPT_L);
	assert(h_L.count()==nPT_L);

	this->teacherName=te;
	this->subjectName=su;
	this->activityTagName=sut;
	this->studentsName=st;
	this->nPreferredStartingTimes_L=nPT_L;
	this->days_L=d_L;
	this->hours_L=h_L;
	this->type=CONSTRAINT_ACTIVITIES_PREFERRED_STARTING_TIMES;
}

bool ConstraintActivitiesPreferredStartingTimes::computeInternalStructure(QWidget* parent, Rules& r)
{
	this->nActivities=0;
	this->activitiesIndices.clear();

	int it;
	Activity* act;
	int i;
	for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];

		//check if this activity has the corresponding teacher
		if(this->teacherName!=""){
			it = act->teachersNames.indexOf(this->teacherName);
			if(it==-1)
				continue;
		}
		//check if this activity has the corresponding students
		if(this->studentsName!=""){
			bool commonStudents=false;
			for(const QString& st : std::as_const(act->studentsNames))
				if(r.augmentedSetsShareStudentsFaster(st, studentsName)){
					commonStudents=true;
					break;
				}
		
			if(!commonStudents)
				continue;
		}
		//check if this activity has the corresponding subject
		if(this->subjectName!="" && act->subjectName!=this->subjectName){
				continue;
		}
		//check if this activity has the corresponding activity tag
		if(this->activityTagName!="" && !act->activityTagsNames.contains(this->activityTagName)){
				continue;
		}
	
		if(duration>=1 && act->duration!=duration)
			continue;

		assert(this->nActivities < r.nInternalActivities);
		this->activitiesIndices.append(i);
		this->nActivities++;
	}
	
	assert(this->activitiesIndices.count()==this->nActivities);

	//////////////////////
	for(int k=0; k<nPreferredStartingTimes_L; k++){
		if(this->days_L[k] >= r.nDaysPerWeek){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities preferred starting times is wrong because it refers to removed day. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->hours_L[k] == r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities preferred starting times is wrong because a preferred hour is too late (after the last acceptable slot). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->hours_L[k] > r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities preferred starting times is wrong because it refers to removed hour. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
	}
	///////////////////////
	
	if(this->nActivities>0)
		return true;
	else{
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to no activities). Please modify, deactivate, or remove it:\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}
}

bool ConstraintActivitiesPreferredStartingTimes::hasInactiveActivities(Rules& r)
{
	QList<int> localActiveActs;
	QList<int> localAllActs;

	//returns true if all activities are inactive
	int it;
	Activity* act;
	int i;
	for(i=0; i<r.activitiesList.count(); i++){
		act=r.activitiesList.at(i);

		//check if this activity has the corresponding teacher
		if(this->teacherName!=""){
			it = act->teachersNames.indexOf(this->teacherName);
			if(it==-1)
				continue;
		}
		//check if this activity has the corresponding students
		if(this->studentsName!=""){
			bool commonStudents=false;
			for(const QString& st : std::as_const(act->studentsNames))
				if(r.setsShareStudents(st, studentsName)){
					commonStudents=true;
					break;
				}
		
			if(!commonStudents)
				continue;
		}
		//check if this activity has the corresponding subject
		if(this->subjectName!="" && act->subjectName!=this->subjectName){
				continue;
		}
		//check if this activity has the corresponding activity tag
		if(this->activityTagName!="" && !act->activityTagsNames.contains(this->activityTagName)){
				continue;
		}

		if(duration>=1 && act->duration!=duration)
			continue;
	
		if(!r.inactiveActivities.contains(act->id))
			localActiveActs.append(act->id);
			
		localAllActs.append(act->id);
	}

	if(localActiveActs.count()==0 && localAllActs.count()>0)
		return true;
	else
		return false;
}

QString ConstraintActivitiesPreferredStartingTimes::getXmlDescription(Rules& r)
{
	QString s=IL2+"<ConstraintActivitiesPreferredStartingTimes>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Teacher>"+protect(this->teacherName)+"</Teacher>\n";
	s+=IL3+"<Students>"+protect(this->studentsName)+"</Students>\n";
	s+=IL3+"<Subject>"+protect(this->subjectName)+"</Subject>\n";
	s+=IL3+"<Activity_Tag>"+protect(this->activityTagName)+"</Activity_Tag>\n";
	if(duration>=1)
		s+=IL3+"<Duration>"+CustomFETString::number(duration)+"</Duration>\n";
	else
		s+=IL3+"<Duration></Duration>\n";
	s+=IL3+"<Number_of_Preferred_Starting_Times>"+CustomFETString::number(this->nPreferredStartingTimes_L)+"</Number_of_Preferred_Starting_Times>\n";
	for(int i=0; i<nPreferredStartingTimes_L; i++){
		s+=IL3+"<Preferred_Starting_Time>\n";
		if(this->days_L[i]>=0)
			s+=IL4+"<Day>"+protect(r.daysOfTheWeek[this->days_L[i]])+"</Day>\n";
		if(this->hours_L[i]>=0)
			s+=IL4+"<Hour>"+protect(r.hoursOfTheDay[this->hours_L[i]])+"</Hour>\n";
		s+=IL3+"</Preferred_Starting_Time>\n";
	}
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivitiesPreferredStartingTimes>\n";
	return s;
}

QString ConstraintActivitiesPreferredStartingTimes::getDescription(Rules& r)
{
	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;

	QString tc, st, su, at, dur;
	
	if(this->teacherName!="")
		tc=tr("teacher=%1").arg(this->teacherName);
	else
		tc=tr("all teachers");
		
	if(this->studentsName!="")
		st=tr("students=%1").arg(this->studentsName);
	else
		st=tr("all students");
		
	if(this->subjectName!="")
		su=tr("subject=%1").arg(this->subjectName);
	else
		su=tr("all subjects");
		
	if(this->activityTagName!="")
		at=tr("activity tag=%1").arg(this->activityTagName);
	else
		at=tr("all activity tags");

	if(duration>=1)
		dur=tr("duration=%1").arg(duration);
	else
		dur=tr("all durations");

	s+=tr("Activities with %1, %2, %3, %4, %5, have a set of preferred starting times:", "%1...%5 are conditions for the activities").arg(tc).arg(st).arg(su).arg(at).arg(dur);
	s+=" ";

	for(int i=0; i<this->nPreferredStartingTimes_L; i++){
		if(this->days_L[i]>=0){
			s+=r.daysOfTheWeek[this->days_L[i]];
			s+=" ";
		}
		if(this->hours_L[i]>=0){
			s+=r.hoursOfTheDay[this->hours_L[i]];
		}
		if(i<this->nPreferredStartingTimes_L-1)
			s+=translatedSemicolonSpace();
	}
	s+=translatedCommaSpace();
	
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintActivitiesPreferredStartingTimes::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	if(!richText){
		QString s=tr("Time constraint");s+="\n";
		s+=tr("Activities with:");s+="\n";

		if(this->teacherName!="")
			s+=tr("Teacher=%1").arg(this->teacherName);
		else
			s+=tr("All teachers");
		s+="\n";
		
		if(this->studentsName!="")
			s+=tr("Students=%1").arg(this->studentsName);
		else
			s+=tr("All students");
		s+="\n";
		
		if(this->subjectName!="")
			s+=tr("Subject=%1").arg(this->subjectName);
		else
			s+=tr("All subjects");
		s+="\n";
		
		if(this->activityTagName!="")
			s+=tr("Activity tag=%1").arg(this->activityTagName);
		else
			s+=tr("All activity tags");
		s+="\n";

		if(duration>=1)
			s+=tr("Duration=%1").arg(duration);
		else
			s+=tr("All durations");
		s+="\n";

		s+=tr("have a set of preferred starting times:");
		s+="\n";
		for(int i=0; i<this->nPreferredStartingTimes_L; i++){
			if(this->days_L[i]>=0){
				s+=r.daysOfTheWeek[this->days_L[i]];
				s+=" ";
			}
			if(this->hours_L[i]>=0){
				s+=r.hoursOfTheDay[this->hours_L[i]];
			}
			if(i<this->nPreferredStartingTimes_L-1)
				s+=translatedSemicolonSpace();
		}
		s+="\n";

		s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";

		if(!active){
			s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			s+="\n";
		}
		if(!comments.isEmpty()){
			s+=tr("Comments=%1").arg(comments);
			s+="\n";
		}

		return s;
	}
	else{
		QString begin=tr("Time constraint");begin+="\n";
		begin+=tr("Activities with:");begin+="\n";

		if(this->teacherName!="")
			begin+=tr("Teacher=%1").arg(this->teacherName);
		else
			begin+=tr("All teachers");
		begin+="\n";
		
		if(this->studentsName!="")
			begin+=tr("Students=%1").arg(this->studentsName);
		else
			begin+=tr("All students");
		begin+="\n";
		
		if(this->subjectName!="")
			begin+=tr("Subject=%1").arg(this->subjectName);
		else
			begin+=tr("All subjects");
		begin+="\n";
		
		if(this->activityTagName!="")
			begin+=tr("Activity tag=%1").arg(this->activityTagName);
		else
			begin+=tr("All activity tags");
		begin+="\n";

		if(duration>=1)
			begin+=tr("Duration=%1").arg(duration);
		else
			begin+=tr("All durations");
		begin+="\n";

		begin+=tr("have a set of preferred starting times:");
		begin+="\n";

		//the first Boolean is 'direct', the second Boolean is 'not available/selected', the third Boolean is 'color'.
		QString middle=listsOfDaysAndHoursToTable(r, days_L, hours_L, false, true, colors);
		QString end;
		end+="\n";

		end+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));end+="\n";

		if(!active){
			end+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			end+="\n";
		}
		if(!comments.isEmpty()){
			end+=tr("Comments=%1").arg(comments);
			end+="\n";
		}

		return protect4(begin)+middle+protect4(end);
	}
}

double ConstraintActivitiesPreferredStartingTimes::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

	nbroken=0;
	int tmp;
	
	for(int i=0; i<this->nActivities; i++){
		tmp=0;
		int ai=this->activitiesIndices[i];
		if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek; //the day when this activity was scheduled
			int h=c.times[ai]/r.nDaysPerWeek; //the hour
			int i;
			for(i=0; i<this->nPreferredStartingTimes_L; i++){
				if(this->days_L[i]>=0 && this->days_L[i]!=d)
					continue;
				if(this->hours_L[i]>=0 && this->hours_L[i]!=h)
					continue;
				break;
			}
			if(i==this->nPreferredStartingTimes_L){
				tmp=1;
			}
		}
		nbroken+=tmp;
		if(conflictsString!=nullptr && tmp>0){
			QString s=tr("Time constraint activities preferred starting times broken"
			 " for activity with id=%1 (%2),"
			 " increases conflicts total by %3", "%1 is the id, %2 is the detailed description of the activity")
			 .arg(r.internalActivitiesList[ai].id)
			 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[ai].id))
			 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*tmp));
			
			dl.append(s);
			cl.append(weightPercentage/100*tmp);
		
			*conflictsString+= s+"\n";
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return nbroken * weightPercentage / 100.0;
}

bool ConstraintActivitiesPreferredStartingTimes::isRelatedToActivity(Rules& r, int aid)
{
	Activity* a=r.activitiesPointerHash.value(aid, nullptr);
	assert(a!=nullptr);

	int it;

	//check if this activity has the corresponding teacher
	if(this->teacherName!=""){
		it = a->teachersNames.indexOf(this->teacherName);
		if(it==-1)
			return false;
	}
	//check if this activity has the corresponding students
	if(this->studentsName!=""){
		bool commonStudents=false;
		for(const QString& st : std::as_const(a->studentsNames)){
			if(r.setsShareStudents(st, this->studentsName)){
				commonStudents=true;
				break;
			}
		}
		if(!commonStudents)
			return false;
	}
	//check if this activity has the corresponding subject
	if(this->subjectName!="" && a->subjectName!=this->subjectName)
		return false;
	//check if this activity has the corresponding activity tag
	if(this->activityTagName!="" && !a->activityTagsNames.contains(this->activityTagName))
		return false;

	if(duration>=1 && a->duration!=duration)
		return false;

	return true;
}

bool ConstraintActivitiesPreferredStartingTimes::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivitiesPreferredStartingTimes::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesPreferredStartingTimes::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesPreferredStartingTimes::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintActivitiesPreferredStartingTimes::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivitiesPreferredStartingTimes::hasWrongDayOrHour(Rules& r)
{
	assert(nPreferredStartingTimes_L==days_L.count());
	assert(nPreferredStartingTimes_L==hours_L.count());
	
	for(int i=0; i<nPreferredStartingTimes_L; i++)
		if(days_L.at(i)<0 || days_L.at(i)>=r.nDaysPerWeek
		 || hours_L.at(i)<0 || hours_L.at(i)>=r.nHoursPerDay)
			return true;

	return false;
}

bool ConstraintActivitiesPreferredStartingTimes::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintActivitiesPreferredStartingTimes::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	assert(nPreferredStartingTimes_L==days_L.count());
	assert(nPreferredStartingTimes_L==hours_L.count());
	
	QList<int> newDays;
	QList<int> newHours;
	int newNPref=0;
	
	for(int i=0; i<nPreferredStartingTimes_L; i++)
		if(days_L.at(i)>=0 && days_L.at(i)<r.nDaysPerWeek
		 && hours_L.at(i)>=0 && hours_L.at(i)<r.nHoursPerDay){
			newDays.append(days_L.at(i));
			newHours.append(hours_L.at(i));
			newNPref++;
		}
	
	nPreferredStartingTimes_L=newNPref;
	days_L=newDays;
	hours_L=newHours;
	
	r.internalStructureComputed=false;
	setRulesModifiedAndOtherThings(&r);

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintSubactivitiesPreferredStartingTimes::ConstraintSubactivitiesPreferredStartingTimes()
	: TimeConstraint()
{
	this->type = CONSTRAINT_SUBACTIVITIES_PREFERRED_STARTING_TIMES;
}

ConstraintSubactivitiesPreferredStartingTimes::ConstraintSubactivitiesPreferredStartingTimes(double wp, int compNo, const QString& te,
	const QString& st, const QString& su, const QString& sut, int dur, int nPT_L, const QList<int>& d_L, const QList<int>& h_L)
	: TimeConstraint(wp)
{
	assert(dur==-1 || dur>=1);
	duration=dur;

	assert(d_L.count()==nPT_L);
	assert(h_L.count()==nPT_L);

	this->componentNumber=compNo;
	this->teacherName=te;
	this->subjectName=su;
	this->activityTagName=sut;
	this->studentsName=st;
	this->nPreferredStartingTimes_L=nPT_L;
	this->days_L=d_L;
	this->hours_L=h_L;
	this->type=CONSTRAINT_SUBACTIVITIES_PREFERRED_STARTING_TIMES;
}

bool ConstraintSubactivitiesPreferredStartingTimes::computeInternalStructure(QWidget* parent, Rules& r)
{
	this->nActivities=0;
	this->activitiesIndices.clear();

	int it;
	Activity* act;
	int i;
	for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];
		
		if(!act->representsComponentNumber(this->componentNumber))
			continue;

		//check if this activity has the corresponding teacher
		if(this->teacherName!=""){
			it = act->teachersNames.indexOf(this->teacherName);
			if(it==-1)
				continue;
		}
		//check if this activity has the corresponding students
		if(this->studentsName!=""){
			bool commonStudents=false;
			for(const QString& st : std::as_const(act->studentsNames))
				if(r.augmentedSetsShareStudentsFaster(st, studentsName)){
					commonStudents=true;
					break;
				}
		
			if(!commonStudents)
				continue;
		}
		//check if this activity has the corresponding subject
		if(this->subjectName!="" && act->subjectName!=this->subjectName){
				continue;
		}
		//check if this activity has the corresponding activity tag
		if(this->activityTagName!="" && !act->activityTagsNames.contains(this->activityTagName)){
				continue;
		}

		if(duration>=1 && act->duration!=duration)
			continue;
	
		assert(this->nActivities < r.nInternalActivities);
		this->nActivities++;
		this->activitiesIndices.append(i);
	}
	
	assert(this->activitiesIndices.count()==this->nActivities);

	//////////////////////
	for(int k=0; k<nPreferredStartingTimes_L; k++){
		if(this->days_L[k] >= r.nDaysPerWeek){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint subactivities preferred starting times is wrong because it refers to removed day. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->hours_L[k] == r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint subactivities preferred starting times is wrong because a preferred hour is too late (after the last acceptable slot). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->hours_L[k] > r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint subactivities preferred starting times is wrong because it refers to removed hour. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
	}
	///////////////////////
	
	if(this->nActivities>0)
		return true;
	else{
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to no activities). Please modify, deactivate, or remove it:\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}
}

bool ConstraintSubactivitiesPreferredStartingTimes::hasInactiveActivities(Rules& r)
{
	QList<int> localActiveActs;
	QList<int> localAllActs;

	//returns true if all activities are inactive
	int it;
	Activity* act;
	int i;
	for(i=0; i<r.activitiesList.count(); i++){
		act=r.activitiesList.at(i);

		if(!act->representsComponentNumber(this->componentNumber))
			continue;

		//check if this activity has the corresponding teacher
		if(this->teacherName!=""){
			it = act->teachersNames.indexOf(this->teacherName);
			if(it==-1)
				continue;
		}
		//check if this activity has the corresponding students
		if(this->studentsName!=""){
			bool commonStudents=false;
			for(const QString& st : std::as_const(act->studentsNames))
				if(r.setsShareStudents(st, studentsName)){
					commonStudents=true;
					break;
				}
		
			if(!commonStudents)
				continue;
		}
		//check if this activity has the corresponding subject
		if(this->subjectName!="" && act->subjectName!=this->subjectName){
				continue;
		}
		//check if this activity has the corresponding activity tag
		if(this->activityTagName!="" && !act->activityTagsNames.contains(this->activityTagName)){
				continue;
		}
	
		if(duration>=1 && act->duration!=duration)
			continue;

		if(!r.inactiveActivities.contains(act->id))
			localActiveActs.append(act->id);
			
		localAllActs.append(act->id);
	}

	if(localActiveActs.count()==0 && localAllActs.count()>0)
		return true;
	else
		return false;
}

QString ConstraintSubactivitiesPreferredStartingTimes::getXmlDescription(Rules& r)
{
	QString s=IL2+"<ConstraintSubactivitiesPreferredStartingTimes>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Component_Number>"+CustomFETString::number(this->componentNumber)+"</Component_Number>\n";
	s+=IL3+"<Teacher>"+protect(this->teacherName)+"</Teacher>\n";
	s+=IL3+"<Students>"+protect(this->studentsName)+"</Students>\n";
	s+=IL3+"<Subject>"+protect(this->subjectName)+"</Subject>\n";
	s+=IL3+"<Activity_Tag>"+protect(this->activityTagName)+"</Activity_Tag>\n";
	if(duration>=1)
		s+=IL3+"<Duration>"+CustomFETString::number(duration)+"</Duration>\n";
	else
		s+=IL3+"<Duration></Duration>\n";
	s+=IL3+"<Number_of_Preferred_Starting_Times>"+CustomFETString::number(this->nPreferredStartingTimes_L)+"</Number_of_Preferred_Starting_Times>\n";
	for(int i=0; i<nPreferredStartingTimes_L; i++){
		s+=IL3+"<Preferred_Starting_Time>\n";
		if(this->days_L[i]>=0)
			s+=IL4+"<Day>"+protect(r.daysOfTheWeek[this->days_L[i]])+"</Day>\n";
		if(this->hours_L[i]>=0)
			s+=IL4+"<Hour>"+protect(r.hoursOfTheDay[this->hours_L[i]])+"</Hour>\n";
		s+=IL3+"</Preferred_Starting_Time>\n";
	}
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintSubactivitiesPreferredStartingTimes>\n";
	return s;
}

QString ConstraintSubactivitiesPreferredStartingTimes::getDescription(Rules& r)
{
	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString tc, st, su, at, dur;
	
	if(this->teacherName!="")
		tc=tr("teacher=%1").arg(this->teacherName);
	else
		tc=tr("all teachers");
		
	if(this->studentsName!="")
		st=tr("students=%1").arg(this->studentsName);
	else
		st=tr("all students");
		
	if(this->subjectName!="")
		su=tr("subject=%1").arg(this->subjectName);
	else
		su=tr("all subjects");
		
	if(this->activityTagName!="")
		at=tr("activity tag=%1").arg(this->activityTagName);
	else
		at=tr("all activity tags");
		
	if(duration>=1)
		dur=tr("duration=%1").arg(duration);
	else
		dur=tr("all durations");

	QString s;
	
	s+=tr("Subactivities with %1, %2, %3, %4, %5, %6, have a set of preferred starting times:", "%1...%6 are conditions for the subactivities")
		.arg(tr("component number=%1").arg(this->componentNumber)).arg(tc).arg(st).arg(su).arg(at).arg(dur);
	s+=" ";

	for(int i=0; i<this->nPreferredStartingTimes_L; i++){
		if(this->days_L[i]>=0){
			s+=r.daysOfTheWeek[this->days_L[i]];
			s+=" ";
		}
		if(this->hours_L[i]>=0){
			s+=r.hoursOfTheDay[this->hours_L[i]];
		}
		if(i<this->nPreferredStartingTimes_L-1)
			s+=translatedSemicolonSpace();
	}
	s+=translatedCommaSpace();

	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintSubactivitiesPreferredStartingTimes::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	if(!richText){
		QString s=tr("Time constraint");s+="\n";
		s+=tr("Subactivities with:");s+="\n";

		s+=tr("Component number=%1").arg(this->componentNumber);s+="\n";

		if(this->teacherName!="")
			s+=tr("Teacher=%1").arg(this->teacherName);
		else
			s+=tr("All teachers");
		s+="\n";
		
		if(this->studentsName!="")
			s+=tr("Students=%1").arg(this->studentsName);
		else
			s+=tr("All students");
		s+="\n";
		
		if(this->subjectName!="")
			s+=tr("Subject=%1").arg(this->subjectName);
		else
			s+=tr("All subjects");
		s+="\n";
		
		if(this->activityTagName!="")
			s+=tr("Activity tag=%1").arg(this->activityTagName);
		else
			s+=tr("All activity tags");
		s+="\n";

		if(duration>=1)
			s+=tr("Duration=%1").arg(duration);
		else
			s+=tr("All durations");
		s+="\n";

		s+=tr("have a set of preferred starting times:");
		s+="\n";
		for(int i=0; i<this->nPreferredStartingTimes_L; i++){
			if(this->days_L[i]>=0){
				s+=r.daysOfTheWeek[this->days_L[i]];
				s+=" ";
			}
			if(this->hours_L[i]>=0){
				s+=r.hoursOfTheDay[this->hours_L[i]];
			}
			if(i<this->nPreferredStartingTimes_L-1)
				s+=translatedSemicolonSpace();
		}
		s+="\n";

		s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";

		if(!active){
			s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			s+="\n";
		}
		if(!comments.isEmpty()){
			s+=tr("Comments=%1").arg(comments);
			s+="\n";
		}

		return s;
	}
	else{
		QString begin=tr("Time constraint");begin+="\n";
		begin+=tr("Subactivities with:");begin+="\n";

		begin+=tr("Component number=%1").arg(this->componentNumber);begin+="\n";

		if(this->teacherName!="")
			begin+=tr("Teacher=%1").arg(this->teacherName);
		else
			begin+=tr("All teachers");
		begin+="\n";
		
		if(this->studentsName!="")
			begin+=tr("Students=%1").arg(this->studentsName);
		else
			begin+=tr("All students");
		begin+="\n";
		
		if(this->subjectName!="")
			begin+=tr("Subject=%1").arg(this->subjectName);
		else
			begin+=tr("All subjects");
		begin+="\n";
		
		if(this->activityTagName!="")
			begin+=tr("Activity tag=%1").arg(this->activityTagName);
		else
			begin+=tr("All activity tags");
		begin+="\n";

		if(duration>=1)
			begin+=tr("Duration=%1").arg(duration);
		else
			begin+=tr("All durations");
		begin+="\n";

		begin+=tr("have a set of preferred starting times:");
		begin+="\n";

		//the first Boolean is 'direct', the second Boolean is 'not available/selected', the third Boolean is 'color'.
		QString middle=listsOfDaysAndHoursToTable(r, days_L, hours_L, false, true, colors);
		QString end;
		end+="\n";

		end+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));end+="\n";

		if(!active){
			end+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			end+="\n";
		}
		if(!comments.isEmpty()){
			end+=tr("Comments=%1").arg(comments);
			end+="\n";
		}

		return protect4(begin)+middle+protect4(end);
	}
}

double ConstraintSubactivitiesPreferredStartingTimes::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

	nbroken=0;
	int tmp;
	
	for(int i=0; i<this->nActivities; i++){
		tmp=0;
		int ai=this->activitiesIndices[i];
		if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek; //the day when this activity was scheduled
			int h=c.times[ai]/r.nDaysPerWeek; //the hour
			int i;
			for(i=0; i<this->nPreferredStartingTimes_L; i++){
				if(this->days_L[i]>=0 && this->days_L[i]!=d)
					continue;
				if(this->hours_L[i]>=0 && this->hours_L[i]!=h)
					continue;
				break;
			}
			if(i==this->nPreferredStartingTimes_L){
				tmp=1;
			}
		}
		nbroken+=tmp;
		if(conflictsString!=nullptr && tmp>0){
			QString s=tr("Time constraint subactivities preferred starting times broken"
			 " for activity with id=%1 (%2), component number %3,"
			 " increases conflicts total by %4", "%1 is the id, %2 is the detailed description of the activity")
			 .arg(r.internalActivitiesList[ai].id)
			 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[ai].id))
			 .arg(this->componentNumber)
			 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*tmp));

			dl.append(s);
			cl.append(weightPercentage/100*tmp);
		
			*conflictsString+= s+"\n";
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return nbroken * weightPercentage / 100.0;
}

bool ConstraintSubactivitiesPreferredStartingTimes::isRelatedToActivity(Rules& r, int aid)
{
	Activity* a=r.activitiesPointerHash.value(aid, nullptr);
	assert(a!=nullptr);

	if(!a->representsComponentNumber(this->componentNumber))
		return false;

	int it;
	
	//check if this activity has the corresponding teacher
	if(this->teacherName!=""){
		it = a->teachersNames.indexOf(this->teacherName);
		if(it==-1)
			return false;
	}
	//check if this activity has the corresponding students
	if(this->studentsName!=""){
		bool commonStudents=false;
		for(const QString& st : std::as_const(a->studentsNames)){
			if(r.setsShareStudents(st, this->studentsName)){
				commonStudents=true;
				break;
			}
		}
		if(!commonStudents)
			return false;
	}
	//check if this activity has the corresponding subject
	if(this->subjectName!="" && a->subjectName!=this->subjectName)
		return false;
	//check if this activity has the corresponding activity tag
	if(this->activityTagName!="" && !a->activityTagsNames.contains(this->activityTagName))
		return false;

	if(duration>=1 && a->duration!=duration)
		return false;

	return true;
}

bool ConstraintSubactivitiesPreferredStartingTimes::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintSubactivitiesPreferredStartingTimes::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintSubactivitiesPreferredStartingTimes::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintSubactivitiesPreferredStartingTimes::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintSubactivitiesPreferredStartingTimes::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintSubactivitiesPreferredStartingTimes::hasWrongDayOrHour(Rules& r)
{
	assert(nPreferredStartingTimes_L==days_L.count());
	assert(nPreferredStartingTimes_L==hours_L.count());
	
	for(int i=0; i<nPreferredStartingTimes_L; i++)
		if(days_L.at(i)<0 || days_L.at(i)>=r.nDaysPerWeek
		 || hours_L.at(i)<0 || hours_L.at(i)>=r.nHoursPerDay)
			return true;

	return false;
}

bool ConstraintSubactivitiesPreferredStartingTimes::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintSubactivitiesPreferredStartingTimes::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	assert(nPreferredStartingTimes_L==days_L.count());
	assert(nPreferredStartingTimes_L==hours_L.count());
	
	QList<int> newDays;
	QList<int> newHours;
	int newNPref=0;
	
	for(int i=0; i<nPreferredStartingTimes_L; i++)
		if(days_L.at(i)>=0 && days_L.at(i)<r.nDaysPerWeek
		 && hours_L.at(i)>=0 && hours_L.at(i)<r.nHoursPerDay){
			newDays.append(days_L.at(i));
			newHours.append(hours_L.at(i));
			newNPref++;
		}
	
	nPreferredStartingTimes_L=newNPref;
	days_L=newDays;
	hours_L=newHours;
	
	r.internalStructureComputed=false;
	setRulesModifiedAndOtherThings(&r);

	return true;
}

/////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivitiesSameStartingHour::ConstraintActivitiesSameStartingHour()
	: TimeConstraint()
{
	type=CONSTRAINT_ACTIVITIES_SAME_STARTING_HOUR;
}

ConstraintActivitiesSameStartingHour::ConstraintActivitiesSameStartingHour(double wp, int nact, const QList<int>& act)
 : TimeConstraint(wp)
 {
	assert(nact>=2);
	assert(act.count()==nact);
	this->n_activities=nact;
	this->activitiesIds.clear();
	for(int i=0; i<nact; i++)
		this->activitiesIds.append(act.at(i));

	this->type=CONSTRAINT_ACTIVITIES_SAME_STARTING_HOUR;
}

bool ConstraintActivitiesSameStartingHour::computeInternalStructure(QWidget* parent, Rules& r)
{
	//compute the indices of the activities,
	//based on their unique ID

	assert(this->n_activities==this->activitiesIds.count());

	this->_activities.clear();
	for(int i=0; i<this->n_activities; i++){
		int j=r.activitiesHash.value(activitiesIds.at(i), -1);
		//assert(j>=0);
		if(j>=0)
			_activities.append(j);
		/*Activity* act;
		for(j=0; j<r.nInternalActivities; j++){
			act=&r.internalActivitiesList[j];
			if(act->id==this->activitiesIds[i]){
				this->_activities.append(j);
				break;
			}
		}*/
	}
	this->_n_activities=this->_activities.count();
	
	if(this->_n_activities<=1){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (because you need 2 or more activities). Please correct it:\n%1").arg(this->getDetailedDescription(r)));
		//assert(0);
		return false;
	}

	return true;
}

void ConstraintActivitiesSameStartingHour::removeUseless(Rules& r)
{
	//remove the activitiesIds which no longer exist (used after the deletion of an activity)
	
	assert(this->n_activities==this->activitiesIds.count());

	QList<int> tmpList;

	for(int i=0; i<this->n_activities; i++){
		Activity* act=r.activitiesPointerHash.value(activitiesIds[i], nullptr);
		if(act!=nullptr)
			tmpList.append(act->id);
		/*for(int k=0; k<r.activitiesList.size(); k++){
			Activity* act=r.activitiesList[k];
			if(act->id==this->activitiesIds[i]){
				tmpList.append(act->id);
				break;
			}
		}*/
	}
	
	this->activitiesIds=tmpList;
	this->n_activities=this->activitiesIds.count();

	r.internalStructureComputed=false;
}

void ConstraintActivitiesSameStartingHour::recomputeActivitiesSet()
{
	activitiesIdsSet=QSet<int>(activitiesIds.constBegin(), activitiesIds.constEnd());
}

bool ConstraintActivitiesSameStartingHour::hasInactiveActivities(Rules& r)
{
	int count=0;

	for(int i=0; i<this->n_activities; i++)
		if(r.inactiveActivities.contains(this->activitiesIds[i]))
			count++;

	if(this->n_activities-count<=1)
		return true;
	else
		return false;
}

QString ConstraintActivitiesSameStartingHour::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintActivitiesSameStartingHour>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Number_of_Activities>"+CustomFETString::number(this->n_activities)+"</Number_of_Activities>\n";
	for(int i=0; i<this->n_activities; i++)
		s+=IL3+"<Activity_Id>"+CustomFETString::number(this->activitiesIds[i])+"</Activity_Id>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivitiesSameStartingHour>\n";
	return s;
}

QString ConstraintActivitiesSameStartingHour::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Activities same starting hour");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("NA:%1", "Number of activities").arg(this->n_activities);s+=translatedCommaSpace();
	for(int i=0; i<this->n_activities; i++){
		s+=tr("Id:%1", "Id of activity").arg(getActivityDescription(r, this->activitiesIds[i]));
		if(i<this->n_activities-1)
			s+=translatedCommaSpace();
	}

	return begin+s+end;
}

QString ConstraintActivitiesSameStartingHour::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(colors);

	QString s;
	
	s=tr("Time constraint");s+="\n";
	s+=tr("Activities must have the same starting hour");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Number of activities=%1").arg(this->n_activities);s+="\n";
	for(int i=0; i<this->n_activities; i++){
		s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity.")
			.arg(this->activitiesIds[i])
			.arg(getActivityDetailedDescription(r, this->activitiesIds[i]));
		s+="\n";
	}

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintActivitiesSameStartingHour::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	assert(r.internalStructureComputed);

	int nbroken;

	//We do not use the matrices 'subgroupsMatrix' nor 'teachersMatrix'.

	//sum the differences in the scheduled hour for all pairs of activities.

	//without logging
	if(conflictsString==nullptr){
		nbroken=0;
		for(int i=1; i<this->_n_activities; i++){
			int t1=c.times[this->_activities[i]];
			if(t1!=UNALLOCATED_TIME){
				//int day1=t1%r.nDaysPerWeek;
				int hour1=t1/r.nDaysPerWeek;
				for(int j=0; j<i; j++){
					int t2=c.times[this->_activities[j]];
					if(t2!=UNALLOCATED_TIME){
						//int day2=t2%r.nDaysPerWeek;
						int hour2=t2/r.nDaysPerWeek;
						int tmp=0;

						//	tmp = abs(hour1-hour2);
						if(hour1!=hour2)
							tmp=1;

						nbroken+=tmp;
					}
				}
			}
		}
	}
	//with logging
	else{
		nbroken=0;
		for(int i=1; i<this->_n_activities; i++){
			int t1=c.times[this->_activities[i]];
			if(t1!=UNALLOCATED_TIME){
				//int day1=t1%r.nDaysPerWeek;
				int hour1=t1/r.nDaysPerWeek;
				for(int j=0; j<i; j++){
					int t2=c.times[this->_activities[j]];
					if(t2!=UNALLOCATED_TIME){
						//int day2=t2%r.nDaysPerWeek;
						int hour2=t2/r.nDaysPerWeek;
						int tmp=0;

						//	tmp = abs(hour1-hour2);
						if(hour1!=hour2)
							tmp=1;

						nbroken+=tmp;

						if(tmp>0 && conflictsString!=nullptr){
							QString s=tr("Time constraint activities same starting hour broken, because activity with id=%1 (%2) is not at the same hour with activity with id=%3 (%4)"
							 , "%1 is the id, %2 is the detailed description of the activity, %3 id, %4 det. descr.")
							 .arg(r.internalActivitiesList[this->_activities[i]].id)
							 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[this->_activities[i]].id))
							 .arg(r.internalActivitiesList[this->_activities[j]].id)
							 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[this->_activities[j]].id));
							s+=". ";
							s+=tr("Conflicts factor increase=%1").arg(CustomFETString::numberPlusTwoDigitsPrecision(tmp*weightPercentage/100));
							
							dl.append(s);
							cl.append(tmp*weightPercentage/100);
						
							*conflictsString+= s+"\n";
						}
					}
				}
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintActivitiesSameStartingHour::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	return activitiesIdsSet.contains(aid);

	/*for(int i=0; i<this->n_activities; i++)
		if(this->activitiesIds[i]==a->id)
			return true;
	return false;*/
}

bool ConstraintActivitiesSameStartingHour::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivitiesSameStartingHour::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesSameStartingHour::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesSameStartingHour::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);
	
	return false;
}

int ConstraintActivitiesSameStartingHour::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivitiesSameStartingHour::hasWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

bool ConstraintActivitiesSameStartingHour::canRepairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0);
	
	return true;
}

bool ConstraintActivitiesSameStartingHour::repairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0); //should check hasWrongDayOrHour, firstly

	return true;
}

/////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivitiesSameStartingDay::ConstraintActivitiesSameStartingDay()
	: TimeConstraint()
{
	type=CONSTRAINT_ACTIVITIES_SAME_STARTING_DAY;
}

ConstraintActivitiesSameStartingDay::ConstraintActivitiesSameStartingDay(double wp, int nact, const QList<int>& act)
 : TimeConstraint(wp)
 {
	assert(nact>=2);
	assert(act.count()==nact);
	this->n_activities=nact;
	this->activitiesIds.clear();
	for(int i=0; i<nact; i++)
		this->activitiesIds.append(act.at(i));

	this->type=CONSTRAINT_ACTIVITIES_SAME_STARTING_DAY;
}

bool ConstraintActivitiesSameStartingDay::computeInternalStructure(QWidget* parent, Rules& r)
{
	//compute the indices of the activities,
	//based on their unique ID

	assert(this->n_activities==this->activitiesIds.count());

	this->_activities.clear();
	for(int i=0; i<this->n_activities; i++){
		int j=r.activitiesHash.value(activitiesIds.at(i), -1);
		//assert(j>=0);
		if(j>=0)
			_activities.append(j);
		/*int j;
		Activity* act;
		for(j=0; j<r.nInternalActivities; j++){
			act=&r.internalActivitiesList[j];
			if(act->id==this->activitiesIds[i]){
				this->_activities.append(j);
				break;
			}
		}*/
	}
	this->_n_activities=this->_activities.count();
	
	if(this->_n_activities<=1){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (because you need 2 or more activities). Please correct it:\n%1").arg(this->getDetailedDescription(r)));
		//assert(0);
		return false;
	}

	return true;
}

void ConstraintActivitiesSameStartingDay::removeUseless(Rules& r)
{
	//remove the activitiesIds which no longer exist (used after the deletion of an activity)
	
	assert(this->n_activities==this->activitiesIds.count());

	QList<int> tmpList;

	for(int i=0; i<this->n_activities; i++){
		Activity* act=r.activitiesPointerHash.value(activitiesIds[i], nullptr);
		if(act!=nullptr)
			tmpList.append(act->id);
		/*for(int k=0; k<r.activitiesList.size(); k++){
			Activity* act=r.activitiesList[k];
			if(act->id==this->activitiesIds[i]){
				tmpList.append(act->id);
				break;
			}
		}*/
	}
	
	this->activitiesIds=tmpList;
	this->n_activities=this->activitiesIds.count();

	r.internalStructureComputed=false;
}

void ConstraintActivitiesSameStartingDay::recomputeActivitiesSet()
{
	activitiesIdsSet=QSet<int>(activitiesIds.constBegin(), activitiesIds.constEnd());
}

bool ConstraintActivitiesSameStartingDay::hasInactiveActivities(Rules& r)
{
	int count=0;

	for(int i=0; i<this->n_activities; i++)
		if(r.inactiveActivities.contains(this->activitiesIds[i]))
			count++;

	if(this->n_activities-count<=1)
		return true;
	else
		return false;
}

QString ConstraintActivitiesSameStartingDay::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintActivitiesSameStartingDay>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Number_of_Activities>"+CustomFETString::number(this->n_activities)+"</Number_of_Activities>\n";
	for(int i=0; i<this->n_activities; i++)
		s+=IL3+"<Activity_Id>"+CustomFETString::number(this->activitiesIds[i])+"</Activity_Id>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivitiesSameStartingDay>\n";
	return s;
}

QString ConstraintActivitiesSameStartingDay::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Activities same starting day");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("NA:%1", "Number of activities").arg(this->n_activities);s+=translatedCommaSpace();
	for(int i=0; i<this->n_activities; i++){
		s+=tr("Id:%1", "Id of activity").arg(getActivityDescription(r, this->activitiesIds[i]));
		if(i<this->n_activities-1)
			s+=translatedCommaSpace();
	}

	return begin+s+end;
}

QString ConstraintActivitiesSameStartingDay::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(colors);

	QString s;
	
	s=tr("Time constraint");s+="\n";
	s+=tr("Activities must have the same starting day");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Number of activities=%1").arg(this->n_activities);s+="\n";
	for(int i=0; i<this->n_activities; i++){
		s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity.")
			.arg(this->activitiesIds[i])
			.arg(getActivityDetailedDescription(r, this->activitiesIds[i]));
		s+="\n";
	}

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintActivitiesSameStartingDay::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	assert(r.internalStructureComputed);

	int nbroken;

	//We do not use the matrices 'subgroupsMatrix' nor 'teachersMatrix'.

	//sum the differences in the scheduled hour for all pairs of activities.

	//without logging
	if(conflictsString==nullptr){
		nbroken=0;
		for(int i=1; i<this->_n_activities; i++){
			int t1=c.times[this->_activities[i]];
			if(t1!=UNALLOCATED_TIME){
				int day1=t1%r.nDaysPerWeek;
				//int hour1=t1/r.nDaysPerWeek;
				for(int j=0; j<i; j++){
					int t2=c.times[this->_activities[j]];
					if(t2!=UNALLOCATED_TIME){
						int day2=t2%r.nDaysPerWeek;
						//int hour2=t2/r.nDaysPerWeek;
						int tmp=0;

						if(day1!=day2)
							tmp=1;

						nbroken+=tmp;
					}
				}
			}
		}
	}
	//with logging
	else{
		nbroken=0;
		for(int i=1; i<this->_n_activities; i++){
			int t1=c.times[this->_activities[i]];
			if(t1!=UNALLOCATED_TIME){
				int day1=t1%r.nDaysPerWeek;
				//int hour1=t1/r.nDaysPerWeek;
				for(int j=0; j<i; j++){
					int t2=c.times[this->_activities[j]];
					if(t2!=UNALLOCATED_TIME){
						int day2=t2%r.nDaysPerWeek;
						//int hour2=t2/r.nDaysPerWeek;
						int tmp=0;

						if(day1!=day2)
							tmp=1;

						nbroken+=tmp;

						if(tmp>0 && conflictsString!=nullptr){
							QString s=tr("Time constraint activities same starting day broken, because activity with id=%1 (%2) is not on the same day with activity with id=%3 (%4)"
							 , "%1 is the id, %2 is the detailed description of the activity, %3 id, %4 det. descr.")
							 .arg(r.internalActivitiesList[this->_activities[i]].id)
							 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[this->_activities[i]].id))
							 .arg(r.internalActivitiesList[this->_activities[j]].id)
							 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[this->_activities[j]].id));
							s+=". ";
							s+=tr("Conflicts factor increase=%1").arg(CustomFETString::numberPlusTwoDigitsPrecision(tmp*weightPercentage/100));
							
							dl.append(s);
							cl.append(tmp*weightPercentage/100);
						
							*conflictsString+= s+"\n";
						}
					}
				}
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintActivitiesSameStartingDay::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	return activitiesIdsSet.contains(aid);

	/*for(int i=0; i<this->n_activities; i++)
		if(this->activitiesIds[i]==a->id)
			return true;
	return false;*/
}

bool ConstraintActivitiesSameStartingDay::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivitiesSameStartingDay::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesSameStartingDay::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesSameStartingDay::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);
	
	return false;
}

int ConstraintActivitiesSameStartingDay::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivitiesSameStartingDay::hasWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

bool ConstraintActivitiesSameStartingDay::canRepairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0);
	
	return true;
}

bool ConstraintActivitiesSameStartingDay::repairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0); //should check hasWrongDayOrHour, firstly

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintTwoActivitiesConsecutive::ConstraintTwoActivitiesConsecutive()
	: TimeConstraint()
{
	this->type = CONSTRAINT_TWO_ACTIVITIES_CONSECUTIVE;
}

ConstraintTwoActivitiesConsecutive::ConstraintTwoActivitiesConsecutive(double wp, int firstActId, int secondActId)
	: TimeConstraint(wp)
{
	this->firstActivityId = firstActId;
	this->secondActivityId=secondActId;
	this->type = CONSTRAINT_TWO_ACTIVITIES_CONSECUTIVE;
}

bool ConstraintTwoActivitiesConsecutive::computeInternalStructure(QWidget* parent, Rules& r)
{
	/*Activity* act;
	int i;
	for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];
		if(act->id==this->firstActivityId)
			break;
	}*/
	
	int i=r.activitiesHash.value(firstActivityId, r.nInternalActivities);
	
	if(i==r.nInternalActivities){
		//assert(0);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to nonexistent activity ids):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}

	this->firstActivityIndex=i;

	////////
	
	/*for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];
		if(act->id==this->secondActivityId)
			break;
	}*/
	
	i=r.activitiesHash.value(secondActivityId, r.nInternalActivities);
	
	if(i==r.nInternalActivities){
		//assert(0);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to nonexistent activity ids):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}

	this->secondActivityIndex=i;
	
	if(firstActivityIndex==secondActivityIndex){
		//assert(0);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to same activities):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}
	assert(firstActivityIndex!=secondActivityIndex);
	
	return true;
}

bool ConstraintTwoActivitiesConsecutive::hasInactiveActivities(Rules& r)
{
	if(r.inactiveActivities.contains(this->firstActivityId))
		return true;
	if(r.inactiveActivities.contains(this->secondActivityId))
		return true;
	return false;
}

QString ConstraintTwoActivitiesConsecutive::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTwoActivitiesConsecutive>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<First_Activity_Id>"+CustomFETString::number(this->firstActivityId)+"</First_Activity_Id>\n";
	s+=IL3+"<Second_Activity_Id>"+CustomFETString::number(this->secondActivityId)+"</Second_Activity_Id>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTwoActivitiesConsecutive>\n";
	return s;
}

QString ConstraintTwoActivitiesConsecutive::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	
	s=tr("Two activities consecutive:");
	s+=" ";
	
	s+=tr("first act. id: %1", "act.=activity").arg(getActivityDescription(r, this->firstActivityId));
	s+=translatedCommaSpace();
	s+=tr("second act. id: %1", "act.=activity").arg(getActivityDescription(r, this->secondActivityId));
	s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintTwoActivitiesConsecutive::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("Two activities consecutive (second activity must be placed immediately after the first"
	 " activity, on the same day; no gaps are allowed between them, except for break constraints)"); s+="\n";
	
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";

	s+=tr("First activity id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity.")
		.arg(this->firstActivityId)
		.arg(getActivityDetailedDescription(r, this->firstActivityId));
	s+="\n";

	s+=tr("Second activity id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity.")
		.arg(this->secondActivityId)
		.arg(getActivityDetailedDescription(r, this->secondActivityId));
	s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}
	
	return richText?protect4(s):s;
}

double ConstraintTwoActivitiesConsecutive::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

	nbroken=0;
	if(c.times[this->firstActivityIndex]!=UNALLOCATED_TIME && c.times[this->secondActivityIndex]!=UNALLOCATED_TIME){
		int fd=c.times[this->firstActivityIndex]%r.nDaysPerWeek; //the day when first activity was scheduled
		int fh=c.times[this->firstActivityIndex]/r.nDaysPerWeek; //the hour
		int sd=c.times[this->secondActivityIndex]%r.nDaysPerWeek; //the day when second activity was scheduled
		int sh=c.times[this->secondActivityIndex]/r.nDaysPerWeek; //the hour
		
		if(fd!=sd)
			nbroken=1;
		else if(fh+r.internalActivitiesList[this->firstActivityIndex].duration>sh)
			nbroken=1;
		else{
			assert(fd==sd);
			int h;
			int d=fd;
			assert(d==sd);
			for(h=fh+r.internalActivitiesList[this->firstActivityIndex].duration; h<r.nHoursPerDay; h++)
				if(!breakDayHour[d][h])
					break;
					
			assert(h<=sh);
				
			if(h!=sh)
				nbroken=1;
		}
	}
	
	assert(nbroken==0 || nbroken==1);

	if(conflictsString!=nullptr && nbroken>0){
		QString s=tr("Time constraint two activities consecutive broken for first activity with id=%1 (%2) and "
		 "second activity with id=%3 (%4), increases conflicts total by %5", "%1 is the id, %2 is the detailed description of the activity, %3 id, %4 det. descr.")
		 .arg(this->firstActivityId)
		 .arg(getActivityDetailedDescription(r, this->firstActivityId))
		 .arg(this->secondActivityId)
		 .arg(getActivityDetailedDescription(r, this->secondActivityId))
		 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*nbroken));

		dl.append(s);
		cl.append(weightPercentage/100*nbroken);
	
		*conflictsString+= s+"\n";
	}
	
	if(weightPercentage==100)
		assert(nbroken==0);
	return nbroken * weightPercentage/100;
}

bool ConstraintTwoActivitiesConsecutive::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	if(this->firstActivityId==aid)
		return true;
	if(this->secondActivityId==aid)
		return true;
	return false;
}

bool ConstraintTwoActivitiesConsecutive::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintTwoActivitiesConsecutive::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTwoActivitiesConsecutive::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTwoActivitiesConsecutive::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTwoActivitiesConsecutive::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintTwoActivitiesConsecutive::hasWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

bool ConstraintTwoActivitiesConsecutive::canRepairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0);
	
	return true;
}

bool ConstraintTwoActivitiesConsecutive::repairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0); //should check hasWrongDayOrHour, firstly

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintTwoActivitiesGrouped::ConstraintTwoActivitiesGrouped()
	: TimeConstraint()
{
	this->type = CONSTRAINT_TWO_ACTIVITIES_GROUPED;
}

ConstraintTwoActivitiesGrouped::ConstraintTwoActivitiesGrouped(double wp, int firstActId, int secondActId)
	: TimeConstraint(wp)
{
	this->firstActivityId = firstActId;
	this->secondActivityId=secondActId;
	this->type = CONSTRAINT_TWO_ACTIVITIES_GROUPED;
}

bool ConstraintTwoActivitiesGrouped::computeInternalStructure(QWidget* parent, Rules& r)
{
	/*Activity* act;
	int i;
	for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];
		if(act->id==this->firstActivityId)
			break;
	}*/
	
	int i=r.activitiesHash.value(firstActivityId, r.nInternalActivities);
	
	if(i==r.nInternalActivities){
		//assert(0);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to nonexistent activity ids):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}

	this->firstActivityIndex=i;

	////////
	
	/*for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];
		if(act->id==this->secondActivityId)
			break;
	}*/

	i=r.activitiesHash.value(secondActivityId, r.nInternalActivities);
	
	if(i==r.nInternalActivities){
		//assert(0);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to nonexistent activity ids):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}

	this->secondActivityIndex=i;
	
	if(firstActivityIndex==secondActivityIndex){
		//assert(0);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to same activities):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}
	assert(firstActivityIndex!=secondActivityIndex);
	
	return true;
}

bool ConstraintTwoActivitiesGrouped::hasInactiveActivities(Rules& r)
{
	if(r.inactiveActivities.contains(this->firstActivityId))
		return true;
	if(r.inactiveActivities.contains(this->secondActivityId))
		return true;
	return false;
}

QString ConstraintTwoActivitiesGrouped::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTwoActivitiesGrouped>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<First_Activity_Id>"+CustomFETString::number(this->firstActivityId)+"</First_Activity_Id>\n";
	s+=IL3+"<Second_Activity_Id>"+CustomFETString::number(this->secondActivityId)+"</Second_Activity_Id>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTwoActivitiesGrouped>\n";
	return s;
}

QString ConstraintTwoActivitiesGrouped::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	
	s=tr("Two activities grouped:");
	s+=" ";
	
	s+=tr("first act. id: %1", "act.=activity").arg(getActivityDescription(r, this->firstActivityId));
	s+=translatedCommaSpace();
	s+=tr("second act. id: %1", "act.=activity").arg(getActivityDescription(r, this->secondActivityId));
	s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintTwoActivitiesGrouped::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("Two activities grouped (the activities must be placed on the same day, "
	 "one immediately following the other, in any order; no gaps are allowed between them, except for break constraints)"); s+="\n";
	
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";

	s+=tr("First activity id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity.")
		.arg(this->firstActivityId)
		.arg(getActivityDetailedDescription(r, this->firstActivityId));
	s+="\n";

	s+=tr("Second activity id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity.")
		.arg(this->secondActivityId)
		.arg(getActivityDetailedDescription(r, this->secondActivityId));
	s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}
	
	return richText?protect4(s):s;
}

double ConstraintTwoActivitiesGrouped::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

	nbroken=0;
	if(c.times[this->firstActivityIndex]!=UNALLOCATED_TIME && c.times[this->secondActivityIndex]!=UNALLOCATED_TIME){
		int fd=c.times[this->firstActivityIndex]%r.nDaysPerWeek; //the day when first activity was scheduled
		int fh=c.times[this->firstActivityIndex]/r.nDaysPerWeek; //the hour
		int sd=c.times[this->secondActivityIndex]%r.nDaysPerWeek; //the day when second activity was scheduled
		int sh=c.times[this->secondActivityIndex]/r.nDaysPerWeek; //the hour
		
		if(fd!=sd)
			nbroken=1;
		else if(fd==sd && fh+r.internalActivitiesList[this->firstActivityIndex].duration <= sh){
			int h;
			int d=fd;
			assert(d==sd);
			for(h=fh+r.internalActivitiesList[this->firstActivityIndex].duration; h<r.nHoursPerDay; h++)
				if(!breakDayHour[d][h])
					break;
					
			assert(h<=sh);
				
			if(h!=sh)
				nbroken=1;
		}
		else if(fd==sd && sh+r.internalActivitiesList[this->secondActivityIndex].duration <= fh){
			int h;
			int d=sd;
			assert(d==fd);
			for(h=sh+r.internalActivitiesList[this->secondActivityIndex].duration; h<r.nHoursPerDay; h++)
				if(!breakDayHour[d][h])
					break;
					
			assert(h<=fh);
				
			if(h!=fh)
				nbroken=1;
		}
		else
			nbroken=1;
	}
	
	assert(nbroken==0 || nbroken==1);

	if(conflictsString!=nullptr && nbroken>0){
		QString s=tr("Time constraint two activities grouped broken for first activity with id=%1 (%2) and "
		 "second activity with id=%3 (%4), increases conflicts total by %5", "%1 is the id, %2 is the detailed description of the activity, %3 id, %4 det. descr.")
		 .arg(this->firstActivityId)
		 .arg(getActivityDetailedDescription(r, this->firstActivityId))
		 .arg(this->secondActivityId)
		 .arg(getActivityDetailedDescription(r, this->secondActivityId))
		 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*nbroken));

		dl.append(s);
		cl.append(weightPercentage/100*nbroken);
	
		*conflictsString+= s+"\n";
	}
	
	if(weightPercentage==100)
		assert(nbroken==0);
	return nbroken * weightPercentage/100;
}

bool ConstraintTwoActivitiesGrouped::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	if(this->firstActivityId==aid)
		return true;
	if(this->secondActivityId==aid)
		return true;
	return false;
}

bool ConstraintTwoActivitiesGrouped::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintTwoActivitiesGrouped::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTwoActivitiesGrouped::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTwoActivitiesGrouped::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTwoActivitiesGrouped::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintTwoActivitiesGrouped::hasWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

bool ConstraintTwoActivitiesGrouped::canRepairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0);
	
	return true;
}

bool ConstraintTwoActivitiesGrouped::repairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0); //should check hasWrongDayOrHour, firstly

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintThreeActivitiesGrouped::ConstraintThreeActivitiesGrouped()
	: TimeConstraint()
{
	this->type = CONSTRAINT_THREE_ACTIVITIES_GROUPED;
}

ConstraintThreeActivitiesGrouped::ConstraintThreeActivitiesGrouped(double wp, int firstActId, int secondActId, int thirdActId)
	: TimeConstraint(wp)
{
	this->firstActivityId = firstActId;
	this->secondActivityId=secondActId;
	this->thirdActivityId=thirdActId;
	this->type = CONSTRAINT_THREE_ACTIVITIES_GROUPED;
}

bool ConstraintThreeActivitiesGrouped::computeInternalStructure(QWidget* parent, Rules& r)
{
	/*Activity* act;
	int i;
	for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];
		if(act->id==this->firstActivityId)
			break;
	}*/
	
	int i=r.activitiesHash.value(firstActivityId, r.nInternalActivities);
	
	if(i==r.nInternalActivities){
		//assert(0);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to nonexistent activity ids):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}

	this->firstActivityIndex=i;

	////////
	
	/*for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];
		if(act->id==this->secondActivityId)
			break;
	}*/

	i=r.activitiesHash.value(secondActivityId, r.nInternalActivities);
	
	if(i==r.nInternalActivities){
		//assert(0);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to nonexistent activity ids):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}

	this->secondActivityIndex=i;
	
	////////
	
	/*for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];
		if(act->id==this->thirdActivityId)
			break;
	}*/

	i=r.activitiesHash.value(thirdActivityId, r.nInternalActivities);
	
	if(i==r.nInternalActivities){
		//assert(0);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to nonexistent activity ids):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}

	this->thirdActivityIndex=i;
	
	if(firstActivityIndex==secondActivityIndex || firstActivityIndex==thirdActivityIndex || secondActivityIndex==thirdActivityIndex){
		//assert(0);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to same activities):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}
	assert(firstActivityIndex!=secondActivityIndex && firstActivityIndex!=thirdActivityIndex && secondActivityIndex!=thirdActivityIndex);
	
	return true;
}

bool ConstraintThreeActivitiesGrouped::hasInactiveActivities(Rules& r)
{
	if(r.inactiveActivities.contains(this->firstActivityId))
		return true;
	if(r.inactiveActivities.contains(this->secondActivityId))
		return true;
	if(r.inactiveActivities.contains(this->thirdActivityId))
		return true;
	return false;
}

QString ConstraintThreeActivitiesGrouped::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintThreeActivitiesGrouped>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<First_Activity_Id>"+CustomFETString::number(this->firstActivityId)+"</First_Activity_Id>\n";
	s+=IL3+"<Second_Activity_Id>"+CustomFETString::number(this->secondActivityId)+"</Second_Activity_Id>\n";
	s+=IL3+"<Third_Activity_Id>"+CustomFETString::number(this->thirdActivityId)+"</Third_Activity_Id>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintThreeActivitiesGrouped>\n";
	return s;
}

QString ConstraintThreeActivitiesGrouped::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	
	s=tr("Three activities grouped:");
	s+=" ";
	
	s+=tr("first act. id: %1", "act.=activity").arg(getActivityDescription(r, this->firstActivityId));
	s+=translatedCommaSpace();
	s+=tr("second act. id: %1", "act.=activity").arg(getActivityDescription(r, this->secondActivityId));
	s+=translatedCommaSpace();
	s+=tr("third act. id: %1", "act.=activity").arg(getActivityDescription(r, this->thirdActivityId));
	s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintThreeActivitiesGrouped::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("Three activities grouped (the activities must be placed on the same day, "
	 "one immediately following the other, as a block of three activities, in any order; no gaps are allowed between them, except for break constraints)"); s+="\n";
	
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";

	s+=tr("First activity id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity.")
		.arg(this->firstActivityId)
		.arg(getActivityDetailedDescription(r, this->firstActivityId));
	s+="\n";

	s+=tr("Second activity id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity.")
		.arg(this->secondActivityId)
		.arg(getActivityDetailedDescription(r, this->secondActivityId));
	s+="\n";
	
	s+=tr("Third activity id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity.")
		.arg(this->thirdActivityId)
		.arg(getActivityDetailedDescription(r, this->thirdActivityId));
	s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintThreeActivitiesGrouped::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

	nbroken=0;
	if(c.times[this->firstActivityIndex]!=UNALLOCATED_TIME && c.times[this->secondActivityIndex]!=UNALLOCATED_TIME && c.times[this->thirdActivityIndex]!=UNALLOCATED_TIME){
		int fd=c.times[this->firstActivityIndex]%r.nDaysPerWeek; //the day when first activity was scheduled
		int fh=c.times[this->firstActivityIndex]/r.nDaysPerWeek; //the hour
		int sd=c.times[this->secondActivityIndex]%r.nDaysPerWeek; //the day when second activity was scheduled
		int sh=c.times[this->secondActivityIndex]/r.nDaysPerWeek; //the hour
		int td=c.times[this->thirdActivityIndex]%r.nDaysPerWeek; //the day when third activity was scheduled
		int th=c.times[this->thirdActivityIndex]/r.nDaysPerWeek; //the hour
		
		if(!(fd==sd && fd==td))
			nbroken=1;
		else{
			assert(fd==sd && fd==td && sd==td);
			int a1=-1,a2=-1,a3=-1;
			if(fh>=sh && fh>=th && sh>=th){
				a1=thirdActivityIndex;
				a2=secondActivityIndex;
				a3=firstActivityIndex;
				//out<<"321"<<endl;
			}
			else if(fh>=sh && fh>=th && th>=sh){
				a1=secondActivityIndex;
				a2=thirdActivityIndex;
				a3=firstActivityIndex;
				//out<<"231"<<endl;
			}
			else if(sh>=fh && sh>=th && fh>=th){
				a1=thirdActivityIndex;
				a2=firstActivityIndex;
				a3=secondActivityIndex;
				//out<<"312"<<endl;
			}
			else if(sh>=fh && sh>=th && th>=fh){
				a1=firstActivityIndex;
				a2=thirdActivityIndex;
				a3=secondActivityIndex;
				//out<<"132"<<endl;
			}
			else if(th>=fh && th>=sh && fh>=sh){
				a1=secondActivityIndex;
				a2=firstActivityIndex;
				a3=thirdActivityIndex;
				//out<<"213"<<endl;
			}
			else if(th>=fh && th>=sh && sh>=fh){
				a1=firstActivityIndex;
				a2=secondActivityIndex;
				a3=thirdActivityIndex;
				//out<<"123"<<endl;
			}
			else
				assert(0);
			
			int a1d=c.times[a1]%r.nDaysPerWeek; //the day for a1
			int a1h=c.times[a1]/r.nDaysPerWeek; //the day for a1
			int a1dur=r.internalActivitiesList[a1].duration;

			int a2d=c.times[a2]%r.nDaysPerWeek; //the day for a2
			int a2h=c.times[a2]/r.nDaysPerWeek; //the day for a2
			int a2dur=r.internalActivitiesList[a2].duration;

			int a3d=c.times[a3]%r.nDaysPerWeek; //the day for a3
			int a3h=c.times[a3]/r.nDaysPerWeek; //the day for a3
			//int a3dur=r.internalActivitiesList[a3].duration;
			
			int hoursBetweenThem=-1;
			
			assert(a1d==a2d && a1d==a3d);
			
			if(a1h+a1dur<=a2h && a2h+a2dur<=a3h){
				hoursBetweenThem=0;
				for(int hh=a1h+a1dur; hh<a2h; hh++)
					if(!breakDayHour[a1d][hh])
						hoursBetweenThem++;

				for(int hh=a2h+a2dur; hh<a3h; hh++)
					if(!breakDayHour[a2d][hh])
						hoursBetweenThem++;
			}
			
			if(hoursBetweenThem==0)
				nbroken=0;
			else
				nbroken=1;
		}
	}
	
	assert(nbroken==0 || nbroken==1);

	if(conflictsString!=nullptr && nbroken>0){
		QString s=tr("Time constraint three activities grouped broken for first activity with id=%1 (%2), "
		 "second activity with id=%3 (%4) and third activity with id=%5 (%6), increases conflicts total by %7",
		 "%1 is the id, %2 is the detailed description of the activity, %3 id, %4 det. descr., %5 id, %6 det. descr.")
		 .arg(this->firstActivityId)
		 .arg(getActivityDetailedDescription(r, this->firstActivityId))
		 .arg(this->secondActivityId)
		 .arg(getActivityDetailedDescription(r, this->secondActivityId))
		 .arg(this->thirdActivityId)
		 .arg(getActivityDetailedDescription(r, this->thirdActivityId))
		 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*nbroken));

		dl.append(s);
		cl.append(weightPercentage/100*nbroken);
	
		*conflictsString+= s+"\n";
	}
	
	if(weightPercentage==100)
		assert(nbroken==0);
	return nbroken * weightPercentage/100;
}

bool ConstraintThreeActivitiesGrouped::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	if(this->firstActivityId==aid)
		return true;
	if(this->secondActivityId==aid)
		return true;
	if(this->thirdActivityId==aid)
		return true;
	return false;
}

bool ConstraintThreeActivitiesGrouped::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintThreeActivitiesGrouped::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintThreeActivitiesGrouped::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintThreeActivitiesGrouped::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);
	
	return false;
}

int ConstraintThreeActivitiesGrouped::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintThreeActivitiesGrouped::hasWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

bool ConstraintThreeActivitiesGrouped::canRepairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0);
	
	return true;
}

bool ConstraintThreeActivitiesGrouped::repairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0); //should check hasWrongDayOrHour, firstly

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintTwoActivitiesOrdered::ConstraintTwoActivitiesOrdered()
	: TimeConstraint()
{
	this->type = CONSTRAINT_TWO_ACTIVITIES_ORDERED;
}

ConstraintTwoActivitiesOrdered::ConstraintTwoActivitiesOrdered(double wp, int firstActId, int secondActId)
	: TimeConstraint(wp)
{
	this->firstActivityId = firstActId;
	this->secondActivityId=secondActId;
	this->type = CONSTRAINT_TWO_ACTIVITIES_ORDERED;
}

bool ConstraintTwoActivitiesOrdered::computeInternalStructure(QWidget* parent, Rules& r)
{
	/*Activity* act;
	int i;
	for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];
		if(act->id==this->firstActivityId)
			break;
	}*/
	
	int i=r.activitiesHash.value(firstActivityId, r.nInternalActivities);
	
	if(i==r.nInternalActivities){
		//assert(0);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to nonexistent activity ids):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}

	this->firstActivityIndex=i;

	////////
	
	/*for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];
		if(act->id==this->secondActivityId)
			break;
	}*/

	i=r.activitiesHash.value(secondActivityId, r.nInternalActivities);
	
	if(i==r.nInternalActivities){
		//assert(0);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to nonexistent activity ids):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}

	this->secondActivityIndex=i;
	
	if(firstActivityIndex==secondActivityIndex){
		//assert(0);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to same activities):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}
	assert(firstActivityIndex!=secondActivityIndex);
	
	return true;
}

bool ConstraintTwoActivitiesOrdered::hasInactiveActivities(Rules& r)
{
	if(r.inactiveActivities.contains(this->firstActivityId))
		return true;
	if(r.inactiveActivities.contains(this->secondActivityId))
		return true;
	return false;
}

QString ConstraintTwoActivitiesOrdered::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTwoActivitiesOrdered>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<First_Activity_Id>"+CustomFETString::number(this->firstActivityId)+"</First_Activity_Id>\n";
	s+=IL3+"<Second_Activity_Id>"+CustomFETString::number(this->secondActivityId)+"</Second_Activity_Id>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTwoActivitiesOrdered>\n";
	return s;
}

QString ConstraintTwoActivitiesOrdered::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	
	s=tr("Two activities ordered:");
	s+=" ";
	
	s+=tr("first act. id: %1", "act.=activity").arg(getActivityDescription(r, this->firstActivityId));
	s+=translatedCommaSpace();
	s+=tr("second act. id: %1", "act.=activity").arg(getActivityDescription(r, this->secondActivityId));
	s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintTwoActivitiesOrdered::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("Two activities ordered (the second activity must begin at any time in the week later than the first"
	 " activity has finished)"); s+="\n";

	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";

	s+=tr("First activity id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity.")
		.arg(this->firstActivityId)
		.arg(getActivityDetailedDescription(r, this->firstActivityId));
	s+="\n";

	s+=tr("Second activity id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity.")
		.arg(this->secondActivityId)
		.arg(getActivityDetailedDescription(r, this->secondActivityId));
	s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTwoActivitiesOrdered::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

	nbroken=0;
	if(c.times[this->firstActivityIndex]!=UNALLOCATED_TIME && c.times[this->secondActivityIndex]!=UNALLOCATED_TIME){
		int fd=c.times[this->firstActivityIndex]%r.nDaysPerWeek; //the day when first activity was scheduled
		int fh=c.times[this->firstActivityIndex]/r.nDaysPerWeek
		  + r.internalActivitiesList[this->firstActivityIndex].duration-1; //the end hour of first activity
		int sd=c.times[this->secondActivityIndex]%r.nDaysPerWeek; //the day when second activity was scheduled
		int sh=c.times[this->secondActivityIndex]/r.nDaysPerWeek; //the start hour of second activity
		
		if(!(fd<sd || (fd==sd && fh<sh)))
			nbroken=1;
	}
	
	assert(nbroken==0 || nbroken==1);

	if(conflictsString!=nullptr && nbroken>0){
		QString s=tr("Time constraint two activities ordered broken for first activity with id=%1 (%2) and "
		 "second activity with id=%3 (%4), increases conflicts total by %5", "%1 is the id, %2 is the detailed description of the activity, %3 id, %4 det. descr.")
		 .arg(this->firstActivityId)
		 .arg(getActivityDetailedDescription(r, this->firstActivityId))
		 .arg(this->secondActivityId)
		 .arg(getActivityDetailedDescription(r, this->secondActivityId))
		 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*nbroken));

		dl.append(s);
		cl.append(weightPercentage/100*nbroken);
	
		*conflictsString+= s+"\n";
	}
	
	if(weightPercentage==100)
		assert(nbroken==0);
	return nbroken * weightPercentage/100;
}

bool ConstraintTwoActivitiesOrdered::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	if(this->firstActivityId==aid)
		return true;
	if(this->secondActivityId==aid)
		return true;
	return false;
}

bool ConstraintTwoActivitiesOrdered::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintTwoActivitiesOrdered::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTwoActivitiesOrdered::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTwoActivitiesOrdered::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);
	
	return false;
}

int ConstraintTwoActivitiesOrdered::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintTwoActivitiesOrdered::hasWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

bool ConstraintTwoActivitiesOrdered::canRepairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0);
	
	return true;
}

bool ConstraintTwoActivitiesOrdered::repairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0); //should check hasWrongDayOrHour, firstly

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintTwoSetsOfActivitiesOrdered::ConstraintTwoSetsOfActivitiesOrdered()
	: TimeConstraint()
{
	this->type = CONSTRAINT_TWO_SETS_OF_ACTIVITIES_ORDERED;
}

ConstraintTwoSetsOfActivitiesOrdered::ConstraintTwoSetsOfActivitiesOrdered(double wp, const QList<int>& firstActsIds, const QList<int>& secondActsIds)
	: TimeConstraint(wp)
{
	this->firstActivitiesIdsList = firstActsIds;
	this->secondActivitiesIdsList=secondActsIds;
	this->type = CONSTRAINT_TWO_SETS_OF_ACTIVITIES_ORDERED;
}

bool ConstraintTwoSetsOfActivitiesOrdered::computeInternalStructure(QWidget* parent, Rules& r)
{
	QSet<int> sf;
	
	this->firstActivitiesIndicesList.clear();
	for(int firstActivityId : std::as_const(this->firstActivitiesIdsList)){
		int i=r.activitiesHash.value(firstActivityId, r.nInternalActivities);
	
		if(i<r.nInternalActivities){
			this->firstActivitiesIndicesList.append(i);
			sf.insert(i);
		}
	}

	if(this->firstActivitiesIndicesList.isEmpty()){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (its first set of activities is empty/incorrect). Please correct it:\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}

	////////

	bool intersect=false;
	this->secondActivitiesIndicesList.clear();
	for(int secondActivityId : std::as_const(this->secondActivitiesIdsList)){
		int i=r.activitiesHash.value(secondActivityId, r.nInternalActivities);
	
		if(i<r.nInternalActivities){
			this->secondActivitiesIndicesList.append(i);
			if(sf.contains(i)){
				intersect=true;
				break;
			}
		}
	}

	if(this->secondActivitiesIndicesList.isEmpty()){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (its second set of activities is empty/incorrect). Please correct it:\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}

	if(intersect){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (the first set of activities has activities in common with the second set of activities). Please correct it:\n%1")
			 .arg(this->getDetailedDescription(r)));
		return false;
	}
	
	return true;
}

bool ConstraintTwoSetsOfActivitiesOrdered::hasInactiveActivities(Rules& r)
{
	bool okf=false;
	for(int ai : std::as_const(this->firstActivitiesIdsList))
		if(!r.inactiveActivities.contains(ai)){
			okf=true;
			break;
		}

	bool oks=false;
	for(int ai : std::as_const(this->secondActivitiesIdsList))
		if(!r.inactiveActivities.contains(ai)){
			oks=true;
			break;
		}
	
	if(!okf || !oks)
		return true;
	return false;
}

QString ConstraintTwoSetsOfActivitiesOrdered::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTwoSetsOfActivitiesOrdered>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<First_Activities_Ids_Set>\n";
	s+=IL4+"<Number_of_Activities>"+QString::number(this->firstActivitiesIdsList.count())+"</Number_of_Activities>\n";
	for(int ai : std::as_const(this->firstActivitiesIdsList))
		s+=IL4+"<Activity_Id>"+CustomFETString::number(ai)+"</Activity_Id>\n";
	s+=IL3+"</First_Activities_Ids_Set>\n";
	s+=IL3+"<Second_Activities_Ids_Set>\n";
	s+=IL4+"<Number_of_Activities>"+QString::number(this->secondActivitiesIdsList.count())+"</Number_of_Activities>\n";
	for(int ai : std::as_const(this->secondActivitiesIdsList))
		s+=IL4+"<Activity_Id>"+CustomFETString::number(ai)+"</Activity_Id>\n";
	s+=IL3+"</Second_Activities_Ids_Set>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTwoSetsOfActivitiesOrdered>\n";
	return s;
}

QString ConstraintTwoSetsOfActivitiesOrdered::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	
	s=tr("Two sets of activities ordered:");
	s+=" ";
	
	s+=tr("first activities set:");
	s+=" ";
	s+=tr("NA:%1", "Number of activities").arg(this->firstActivitiesIdsList.count());
	s+=translatedCommaSpace();
	for(int ai : std::as_const(this->firstActivitiesIdsList))
		s+=tr("Id:%1").arg(getActivityDescription(r, ai))+translatedCommaSpace();

	s+=tr("second activities set:");
	s+=" ";
	s+=tr("NA:%1", "Number of activities").arg(this->secondActivitiesIdsList.count());
	s+=translatedCommaSpace();
	for(int ai : std::as_const(this->secondActivitiesIdsList))
		s+=tr("Id:%1").arg(getActivityDescription(r, ai))+translatedCommaSpace();

	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintTwoSetsOfActivitiesOrdered::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("Two sets of activities ordered (each activity from the second set must begin at any time in the week later than each activity"
	 " from the first set has finished)"); s+="\n";

	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";

	s+=tr("First activities set ids:");
	s+="\n";
	s+=tr("Number of activities=%1").arg(this->firstActivitiesIdsList.count());s+="\n";
	for(int ai : std::as_const(this->firstActivitiesIdsList)){
		s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			.arg(ai).arg(getActivityDetailedDescription(r, ai));
		s+="\n";
	}

	s+=tr("Second activities set ids:");
	s+="\n";
	s+=tr("Number of activities=%1").arg(this->secondActivitiesIdsList.count());s+="\n";
	for(int ai : std::as_const(this->secondActivitiesIdsList)){
		s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			.arg(ai).arg(getActivityDetailedDescription(r, ai));
		s+="\n";
	}

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTwoSetsOfActivitiesOrdered::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

	int totalBroken=0;
	
	for(int i=0; i<this->firstActivitiesIndicesList.count(); i++){
		for(int j=0; j<this->secondActivitiesIndicesList.count(); j++){
			nbroken=0;

			int firstActivityIndex=this->firstActivitiesIndicesList[i];
			int secondActivityIndex=this->secondActivitiesIndicesList[j];

			if(c.times[firstActivityIndex]!=UNALLOCATED_TIME && c.times[secondActivityIndex]!=UNALLOCATED_TIME){
				int fd=c.times[firstActivityIndex]%r.nDaysPerWeek; //the day when first activity was scheduled
				int fh=c.times[firstActivityIndex]/r.nDaysPerWeek
				  + r.internalActivitiesList[firstActivityIndex].duration-1; //the end hour of first activity
				int sd=c.times[secondActivityIndex]%r.nDaysPerWeek; //the day when second activity was scheduled
				int sh=c.times[secondActivityIndex]/r.nDaysPerWeek; //the start hour of second activity
				
				if(!(fd<sd || (fd==sd && fh<sh)))
					nbroken=1;
			}
		
			assert(nbroken==0 || nbroken==1);
			
			totalBroken+=nbroken;

			if(conflictsString!=nullptr && nbroken>0){
				int firstActivityId=r.internalActivitiesList[firstActivityIndex].id;
				int secondActivityId=r.internalActivitiesList[secondActivityIndex].id;
			
				QString s=tr("Time constraint two sets of activities ordered broken for first activity with id=%1 (%2) and "
				 "second activity with id=%3 (%4), increases conflicts total by %5", "%1 is the id, %2 is the detailed description of the activity, %3 id, %4 det. descr.")
				 .arg(firstActivityId)
				 .arg(getActivityDetailedDescription(r, firstActivityId))
				 .arg(secondActivityId)
				 .arg(getActivityDetailedDescription(r, secondActivityId))
				 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*nbroken));
	
				dl.append(s);
				cl.append(weightPercentage/100*nbroken);
		
				*conflictsString+= s+"\n";
			}
		}
	}
	
	if(weightPercentage==100)
		assert(totalBroken==0);
	return totalBroken * weightPercentage/100;
}

void ConstraintTwoSetsOfActivitiesOrdered::removeUseless(Rules& r)
{
	//remove the activitiesIds which no longer exist (used after the deletion of an activity)
	
	QList<int> tmpList;

	tmpList.clear();
	for(int ai : std::as_const(this->firstActivitiesIdsList)){
		Activity* act=r.activitiesPointerHash.value(ai, nullptr);
		if(act!=nullptr){
			assert(act->id==ai);
			tmpList.append(act->id);
		}
	}
	this->firstActivitiesIdsList=tmpList;
	
	tmpList.clear();
	for(int ai : std::as_const(this->secondActivitiesIdsList)){
		Activity* act=r.activitiesPointerHash.value(ai, nullptr);
		if(act!=nullptr){
			assert(act->id==ai);
			tmpList.append(act->id);
		}
	}
	this->secondActivitiesIdsList=tmpList;
	
	r.internalStructureComputed=false;
}

void ConstraintTwoSetsOfActivitiesOrdered::recomputeActivitiesSets()
{
	firstActivitiesIdsSet=QSet<int>(firstActivitiesIdsList.constBegin(), firstActivitiesIdsList.constEnd());
	secondActivitiesIdsSet=QSet<int>(secondActivitiesIdsList.constBegin(), secondActivitiesIdsList.constEnd());
}

bool ConstraintTwoSetsOfActivitiesOrdered::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	
	return firstActivitiesIdsSet.contains(aid) || secondActivitiesIdsSet.contains(aid);

	/*for(int ai : std::as_const(this->firstActivitiesIdsList))
		if(ai==a->id)
			return true;
	for(int ai : std::as_const(this->secondActivitiesIdsList))
		if(ai==a->id)
			return true;
	return false;*/
}

bool ConstraintTwoSetsOfActivitiesOrdered::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintTwoSetsOfActivitiesOrdered::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTwoSetsOfActivitiesOrdered::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTwoSetsOfActivitiesOrdered::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);
	
	return false;
}

int ConstraintTwoSetsOfActivitiesOrdered::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintTwoSetsOfActivitiesOrdered::hasWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

bool ConstraintTwoSetsOfActivitiesOrdered::canRepairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0);
	
	return true;
}

bool ConstraintTwoSetsOfActivitiesOrdered::repairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0); //should check hasWrongDayOrHour, firstly

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintTwoActivitiesOrderedIfSameDay::ConstraintTwoActivitiesOrderedIfSameDay()
	: TimeConstraint()
{
	this->type = CONSTRAINT_TWO_ACTIVITIES_ORDERED_IF_SAME_DAY;
}

ConstraintTwoActivitiesOrderedIfSameDay::ConstraintTwoActivitiesOrderedIfSameDay(double wp, int firstActId, int secondActId)
	: TimeConstraint(wp)
{
	this->firstActivityId = firstActId;
	this->secondActivityId=secondActId;
	this->type = CONSTRAINT_TWO_ACTIVITIES_ORDERED_IF_SAME_DAY;
}

bool ConstraintTwoActivitiesOrderedIfSameDay::computeInternalStructure(QWidget* parent, Rules& r)
{
	/*Activity* act;
	int i;
	for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];
		if(act->id==this->firstActivityId)
			break;
	}*/
	
	int i=r.activitiesHash.value(firstActivityId, r.nInternalActivities);
	
	if(i==r.nInternalActivities){
		//assert(0);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to nonexistent activity ids):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}

	this->firstActivityIndex=i;

	////////
	
	/*for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];
		if(act->id==this->secondActivityId)
			break;
	}*/

	i=r.activitiesHash.value(secondActivityId, r.nInternalActivities);
	
	if(i==r.nInternalActivities){
		//assert(0);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to nonexistent activity ids):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}

	this->secondActivityIndex=i;
	
	if(firstActivityIndex==secondActivityIndex){
		//assert(0);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to same activities):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}
	assert(firstActivityIndex!=secondActivityIndex);
	
	return true;
}

bool ConstraintTwoActivitiesOrderedIfSameDay::hasInactiveActivities(Rules& r)
{
	if(r.inactiveActivities.contains(this->firstActivityId))
		return true;
	if(r.inactiveActivities.contains(this->secondActivityId))
		return true;
	return false;
}

QString ConstraintTwoActivitiesOrderedIfSameDay::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTwoActivitiesOrderedIfSameDay>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<First_Activity_Id>"+CustomFETString::number(this->firstActivityId)+"</First_Activity_Id>\n";
	s+=IL3+"<Second_Activity_Id>"+CustomFETString::number(this->secondActivityId)+"</Second_Activity_Id>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTwoActivitiesOrderedIfSameDay>\n";
	return s;
}

QString ConstraintTwoActivitiesOrderedIfSameDay::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	
	s=tr("Two activities ordered if same day:");
	s+=" ";
	
	s+=tr("first act. id: %1", "act.=activity").arg(getActivityDescription(r, this->firstActivityId));
	s+=translatedCommaSpace();
	s+=tr("second act. id: %1", "act.=activity").arg(getActivityDescription(r, this->secondActivityId));
	s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintTwoActivitiesOrderedIfSameDay::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("Two activities are ordered if they are on the same day (the second activity must begin later than the first"
	 " activity has finished if they are on the same day)");
	s+="\n";

	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));
	s+="\n";

	s+=tr("First activity id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity.")
		.arg(this->firstActivityId)
		.arg(getActivityDetailedDescription(r, this->firstActivityId));
	s+="\n";

	s+=tr("Second activity id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity.")
		.arg(this->secondActivityId)
		.arg(getActivityDetailedDescription(r, this->secondActivityId));
	s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTwoActivitiesOrderedIfSameDay::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

	nbroken=0;
	if(c.times[this->firstActivityIndex]!=UNALLOCATED_TIME && c.times[this->secondActivityIndex]!=UNALLOCATED_TIME){
		int fd=c.times[this->firstActivityIndex]%r.nDaysPerWeek; //the day when first activity was scheduled
		int fh=c.times[this->firstActivityIndex]/r.nDaysPerWeek
		  + r.internalActivitiesList[this->firstActivityIndex].duration-1; //the end hour of first activity
		int sd=c.times[this->secondActivityIndex]%r.nDaysPerWeek; //the day when second activity was scheduled
		int sh=c.times[this->secondActivityIndex]/r.nDaysPerWeek; //the start hour of second activity
		
		if(!(fd!=sd || (fd==sd && fh<sh)))
			nbroken=1;
	}
	
	assert(nbroken==0 || nbroken==1);

	if(conflictsString!=nullptr && nbroken>0){
		QString s=tr("Time constraint two activities ordered if on the same day broken for first activity with id=%1 (%2) and "
		 "second activity with id=%3 (%4), increases conflicts total by %5", "%1 is the id, %2 is the detailed description of the activity, %3 id, %4 det. descr.")
		 .arg(this->firstActivityId)
		 .arg(getActivityDetailedDescription(r, this->firstActivityId))
		 .arg(this->secondActivityId)
		 .arg(getActivityDetailedDescription(r, this->secondActivityId))
		 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*nbroken));

		dl.append(s);
		cl.append(weightPercentage/100*nbroken);
	
		*conflictsString+= s+"\n";
	}
	
	if(weightPercentage==100)
		assert(nbroken==0);
	return nbroken * weightPercentage/100;
}

bool ConstraintTwoActivitiesOrderedIfSameDay::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	if(this->firstActivityId==aid)
		return true;
	if(this->secondActivityId==aid)
		return true;
	return false;
}

bool ConstraintTwoActivitiesOrderedIfSameDay::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintTwoActivitiesOrderedIfSameDay::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTwoActivitiesOrderedIfSameDay::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTwoActivitiesOrderedIfSameDay::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);
	
	return false;
}

int ConstraintTwoActivitiesOrderedIfSameDay::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintTwoActivitiesOrderedIfSameDay::hasWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

bool ConstraintTwoActivitiesOrderedIfSameDay::canRepairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0);
	
	return true;
}

bool ConstraintTwoActivitiesOrderedIfSameDay::repairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0); //should check hasWrongDayOrHour, firstly

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivityEndsStudentsDay::ConstraintActivityEndsStudentsDay()
	: TimeConstraint()
{
	this->type = CONSTRAINT_ACTIVITY_ENDS_STUDENTS_DAY;
}

ConstraintActivityEndsStudentsDay::ConstraintActivityEndsStudentsDay(double wp, int actId)
	: TimeConstraint(wp)
{
	this->activityId = actId;
	this->type = CONSTRAINT_ACTIVITY_ENDS_STUDENTS_DAY;
}

bool ConstraintActivityEndsStudentsDay::computeInternalStructure(QWidget* parent, Rules& r)
{
	/*Activity* act;
	int i;
	for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];
		if(act->id==this->activityId)
			break;
	}*/
	
	int i=r.activitiesHash.value(activityId, r.nInternalActivities);
	
	if(i==r.nInternalActivities){
		//assert(0);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (because it refers to invalid activity id). Please correct it (maybe removing it is a solution):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}

	this->activityIndex=i;
	return true;
}

bool ConstraintActivityEndsStudentsDay::hasInactiveActivities(Rules& r)
{
	if(r.inactiveActivities.contains(this->activityId))
		return true;
	return false;
}

QString ConstraintActivityEndsStudentsDay::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintActivityEndsStudentsDay>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Activity_Id>"+CustomFETString::number(this->activityId)+"</Activity_Id>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivityEndsStudentsDay>\n";
	return s;
}

QString ConstraintActivityEndsStudentsDay::getDescription(Rules& r)
{
	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Act. id: %1 (%2) must end students' day",
		"%1 is the id, %2 is the detailed description of the activity.")
		.arg(getActivityDescription(r, this->activityId))
		.arg(getActivityDetailedDescription(r, this->activityId));
	s+=translatedCommaSpace();

	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintActivityEndsStudentsDay::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("Activity must end students' day");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Activity id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity.")
		.arg(this->activityId)
		.arg(getActivityDetailedDescription(r, this->activityId));s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintActivityEndsStudentsDay::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

	nbroken=0;
	if(c.times[this->activityIndex]!=UNALLOCATED_TIME){
		int d=c.times[this->activityIndex]%r.nDaysPerWeek; //the day when this activity was scheduled
		int h=c.times[this->activityIndex]/r.nDaysPerWeek; //the hour
		
		int i=this->activityIndex;
		for(int j=0; j<r.internalActivitiesList[i].iSubgroupsList.count(); j++){
			int sb=r.internalActivitiesList[i].iSubgroupsList.at(j);
			for(int hh=h+r.internalActivitiesList[i].duration; hh<r.nHoursPerDay; hh++)
				if(subgroupsMatrix[sb][d][hh]>0){
					nbroken=1;
					break;
				}
			if(nbroken>0)
				break;
		}
	}

	if(conflictsString!=nullptr && nbroken>0){
		QString s=tr("Time constraint activity ends students' day broken for activity with id=%1 (%2), increases conflicts total by %3",
		 "%1 is the id, %2 is the detailed description of the activity")
		 .arg(this->activityId)
		 .arg(getActivityDetailedDescription(r, this->activityId))
		 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*nbroken));

		dl.append(s);
		cl.append(weightPercentage/100*nbroken);
	
		*conflictsString+= s+"\n";
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return nbroken * weightPercentage/100;
}

bool ConstraintActivityEndsStudentsDay::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	if(this->activityId==aid)
		return true;
	return false;
}

bool ConstraintActivityEndsStudentsDay::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivityEndsStudentsDay::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivityEndsStudentsDay::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivityEndsStudentsDay::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);
	
	return false;
}

int ConstraintActivityEndsStudentsDay::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivityEndsStudentsDay::hasWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

bool ConstraintActivityEndsStudentsDay::canRepairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0);
	
	return true;
}

bool ConstraintActivityEndsStudentsDay::repairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0); //should check hasWrongDayOrHour, firstly

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeachersMinHoursDaily::ConstraintTeachersMinHoursDaily()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHERS_MIN_HOURS_DAILY;
	
	this->allowEmptyDays=true;
}

ConstraintTeachersMinHoursDaily::ConstraintTeachersMinHoursDaily(double wp, int minhours, bool _allowEmptyDays)
 : TimeConstraint(wp)
 {
	assert(minhours>0);
	this->minHoursDaily=minhours;
	
	this->allowEmptyDays=_allowEmptyDays;

	this->type=CONSTRAINT_TEACHERS_MIN_HOURS_DAILY;
}

bool ConstraintTeachersMinHoursDaily::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(r);
	
	if(allowEmptyDays==false){
		QString s=tr("Cannot generate a timetable with a constraint teachers min hours daily with allow empty days=false. Please modify it,"
			" so that it allows empty days. If you need a facility like that, please use constraint teachers min days per week");
		s+="\n\n";
		s+=tr("Constraint is:")+"\n"+this->getDetailedDescription(r);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"), s);
		
		return false;
	}
	
	return true;
}

bool ConstraintTeachersMinHoursDaily::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeachersMinHoursDaily::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeachersMinHoursDaily>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Minimum_Hours_Daily>"+CustomFETString::number(this->minHoursDaily)+"</Minimum_Hours_Daily>\n";
	if(this->allowEmptyDays)
		s+=IL3+"<Allow_Empty_Days>true</Allow_Empty_Days>\n";
	else
		s+=IL3+"<Allow_Empty_Days>false</Allow_Empty_Days>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeachersMinHoursDaily>\n";
	return s;
}

QString ConstraintTeachersMinHoursDaily::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teachers min hours daily");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("mH:%1", "Min hours (daily)").arg(this->minHoursDaily);s+=translatedCommaSpace();
	s+=tr("AED:%1", "Allow empty days").arg(yesNoTranslated(this->allowEmptyDays));

	return begin+s+end;
}

QString ConstraintTeachersMinHoursDaily::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All teachers must respect the minimum number of hours daily"); s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Minimum hours daily=%1").arg(this->minHoursDaily);s+="\n";
	s+=tr("Allow empty days=%1").arg(yesNoTranslated(this->allowEmptyDays));s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeachersMinHoursDaily::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	assert(this->allowEmptyDays==true);

	int nbroken;

	//without logging
	if(conflictsString==nullptr){
		nbroken=0;
		for(int i=0; i<r.nInternalTeachers; i++){
			for(int d=0; d<r.nDaysPerWeek; d++){
				int n_hours_daily=0;
				for(int h=0; h<r.nHoursPerDay; h++)
					if(teachersMatrix[i][d][h]>0)
						n_hours_daily++;

				if(n_hours_daily>0 && n_hours_daily<this->minHoursDaily){
					nbroken++;
				}
			}
		}
	}
	//with logging
	else{
		nbroken=0;
		for(int i=0; i<r.nInternalTeachers; i++){
			for(int d=0; d<r.nDaysPerWeek; d++){
				int n_hours_daily=0;
				for(int h=0; h<r.nHoursPerDay; h++)
					if(teachersMatrix[i][d][h]>0)
						n_hours_daily++;

				if(n_hours_daily>0 && n_hours_daily<this->minHoursDaily){
					nbroken++;

					if(conflictsString!=nullptr){
						QString s=(tr("Time constraint teachers min %1 hours daily broken for teacher %2, on day %3, length=%4.")
						 .arg(CustomFETString::number(this->minHoursDaily))
						 .arg(r.internalTeachersList[i]->name)
						 .arg(r.daysOfTheWeek[d])
						 .arg(n_hours_daily)
						 )
						 +
						 " "
						 +
						 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100)));
						
						dl.append(s);
						cl.append(weightPercentage/100);
					
						*conflictsString+= s+"\n";
					}
				}
			}
		}
	}

	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100)
			assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintTeachersMinHoursDaily::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeachersMinHoursDaily::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return true;
}

bool ConstraintTeachersMinHoursDaily::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMinHoursDaily::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMinHoursDaily::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeachersMinHoursDaily::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeachersMinHoursDaily::hasWrongDayOrHour(Rules& r)
{
	if(minHoursDaily>r.nHoursPerDay)
		return true;
		
	return false;
}

bool ConstraintTeachersMinHoursDaily::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeachersMinHoursDaily::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(minHoursDaily>r.nHoursPerDay)
		minHoursDaily=r.nHoursPerDay;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeacherMinHoursDaily::ConstraintTeacherMinHoursDaily()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHER_MIN_HOURS_DAILY;
	
	this->allowEmptyDays=true;
}

ConstraintTeacherMinHoursDaily::ConstraintTeacherMinHoursDaily(double wp, int minhours, const QString& teacher, bool _allowEmptyDays)
 : TimeConstraint(wp)
 {
	assert(minhours>0);
	this->minHoursDaily=minhours;
	this->teacherName=teacher;
	
	this->allowEmptyDays=_allowEmptyDays;

	this->type=CONSTRAINT_TEACHER_MIN_HOURS_DAILY;
}

bool ConstraintTeacherMinHoursDaily::computeInternalStructure(QWidget* parent, Rules& r)
{
	//this->teacher_ID=r.searchTeacher(this->teacherName);
	teacher_ID=r.teachersHash.value(teacherName, -1);
	assert(this->teacher_ID>=0);
	
	if(allowEmptyDays==false){
		QString s=tr("Cannot generate a timetable with a constraint teacher min hours daily with allow empty days=false. Please modify it,"
			" so that it allows empty days. If you need a facility like that, please use constraint teacher min days per week");
		s+="\n\n";
		s+=tr("Constraint is:")+"\n"+this->getDetailedDescription(r);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"), s);
		
		return false;
	}
	
	return true;
}

bool ConstraintTeacherMinHoursDaily::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeacherMinHoursDaily::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeacherMinHoursDaily>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Teacher>"+protect(this->teacherName)+"</Teacher>\n";
	s+=IL3+"<Minimum_Hours_Daily>"+CustomFETString::number(this->minHoursDaily)+"</Minimum_Hours_Daily>\n";
	if(this->allowEmptyDays)
		s+=IL3+"<Allow_Empty_Days>true</Allow_Empty_Days>\n";
	else
		s+=IL3+"<Allow_Empty_Days>false</Allow_Empty_Days>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeacherMinHoursDaily>\n";
	return s;
}

QString ConstraintTeacherMinHoursDaily::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teacher min hours daily");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("T:%1", "Teacher").arg(this->teacherName);s+=translatedCommaSpace();
	s+=tr("mH:%1", "Minimum hours (daily)").arg(this->minHoursDaily);s+=translatedCommaSpace();
	s+=tr("AED:%1", "Allow empty days").arg(yesNoTranslated(this->allowEmptyDays));

	return begin+s+end;
}

QString ConstraintTeacherMinHoursDaily::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A teacher must respect the minimum number of hours daily");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Teacher=%1").arg(this->teacherName);s+="\n";
	s+=tr("Minimum hours daily=%1").arg(this->minHoursDaily);s+="\n";
	s+=tr("Allow empty days=%1").arg(yesNoTranslated(this->allowEmptyDays));s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeacherMinHoursDaily::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	assert(this->allowEmptyDays==true);

	int nbroken;

	//without logging
	if(conflictsString==nullptr){
		nbroken=0;
		int i=this->teacher_ID;
		for(int d=0; d<r.nDaysPerWeek; d++){
			int n_hours_daily=0;
			for(int h=0; h<r.nHoursPerDay; h++)
				if(teachersMatrix[i][d][h]>0)
					n_hours_daily++;

			if(n_hours_daily>0 && n_hours_daily<this->minHoursDaily){
				nbroken++;
			}
		}
	}
	//with logging
	else{
		nbroken=0;
		int i=this->teacher_ID;
		for(int d=0; d<r.nDaysPerWeek; d++){
			int n_hours_daily=0;
			for(int h=0; h<r.nHoursPerDay; h++)
				if(teachersMatrix[i][d][h]>0)
					n_hours_daily++;

			if(n_hours_daily>0 && n_hours_daily<this->minHoursDaily){
				nbroken++;

				if(conflictsString!=nullptr){
					QString s=(tr(
					 "Time constraint teacher min %1 hours daily broken for teacher %2, on day %3, length=%4.")
					 .arg(CustomFETString::number(this->minHoursDaily))
					 .arg(r.internalTeachersList[i]->name)
					 .arg(r.daysOfTheWeek[d])
					 .arg(n_hours_daily)
					 )
					 +" "
					 +
					 tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100));
						
					dl.append(s);
					cl.append(weightPercentage/100);
				
					*conflictsString+= s+"\n";
				}
			}
		}
	}

	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100)
			assert(nbroken==0);
			
	return weightPercentage/100 * nbroken;
}

bool ConstraintTeacherMinHoursDaily::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeacherMinHoursDaily::isRelatedToTeacher(const QString& t)
{
	if(this->teacherName==t)
		return true;
	return false;
}

bool ConstraintTeacherMinHoursDaily::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMinHoursDaily::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMinHoursDaily::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeacherMinHoursDaily::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeacherMinHoursDaily::hasWrongDayOrHour(Rules& r)
{
	if(minHoursDaily>r.nHoursPerDay)
		return true;
		
	return false;
}

bool ConstraintTeacherMinHoursDaily::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeacherMinHoursDaily::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(minHoursDaily>r.nHoursPerDay)
		minHoursDaily=r.nHoursPerDay;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeacherMinDaysPerWeek::ConstraintTeacherMinDaysPerWeek()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHER_MIN_DAYS_PER_WEEK;
}

ConstraintTeacherMinDaysPerWeek::ConstraintTeacherMinDaysPerWeek(double wp, int mindays, const QString& teacher)
 : TimeConstraint(wp)
 {
	assert(mindays>0);
	this->minDaysPerWeek=mindays;
	this->teacherName=teacher;

	this->type=CONSTRAINT_TEACHER_MIN_DAYS_PER_WEEK;
}

bool ConstraintTeacherMinDaysPerWeek::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);

	//this->teacher_ID=r.searchTeacher(this->teacherName);
	teacher_ID=r.teachersHash.value(teacherName, -1);
	assert(this->teacher_ID>=0);
	return true;
}

bool ConstraintTeacherMinDaysPerWeek::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeacherMinDaysPerWeek::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeacherMinDaysPerWeek>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Teacher>"+protect(this->teacherName)+"</Teacher>\n";
	s+=IL3+"<Minimum_Days_Per_Week>"+CustomFETString::number(this->minDaysPerWeek)+"</Minimum_Days_Per_Week>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeacherMinDaysPerWeek>\n";
	return s;
}

QString ConstraintTeacherMinDaysPerWeek::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teacher min days per week");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("T:%1", "Teacher").arg(this->teacherName);s+=translatedCommaSpace();
	s+=tr("mD:%1", "Minimum days per week").arg(this->minDaysPerWeek);

	return begin+s+end;
}

QString ConstraintTeacherMinDaysPerWeek::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A teacher must respect the minimum number of days per week");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Teacher=%1").arg(this->teacherName);s+="\n";
	s+=tr("Minimum days per week=%1").arg(this->minDaysPerWeek);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeacherMinDaysPerWeek::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	nbroken=0;
	int i=this->teacher_ID;
	int nd=0;
	for(int d=0; d<r.nDaysPerWeek; d++){
		for(int h=0; h<r.nHoursPerDay; h++){
			if(teachersMatrix[i][d][h]>0){
				nd++;
				break;
			}
		}
	}

	if(nd<this->minDaysPerWeek){
		nbroken+=this->minDaysPerWeek-nd;

		if(conflictsString!=nullptr){
			QString s=(tr(
			 "Time constraint teacher min %1 days per week broken for teacher %2.")
			 .arg(CustomFETString::number(this->minDaysPerWeek))
			 .arg(r.internalTeachersList[i]->name)
			 )
			 +" "
			 +
			 tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(double(nbroken)*weightPercentage/100));
				
			dl.append(s);
			cl.append(double(nbroken)*weightPercentage/100);
		
			*conflictsString+= s+"\n";
		}
	}

	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100)
			assert(nbroken==0);
			
	return weightPercentage/100 * nbroken;
}

bool ConstraintTeacherMinDaysPerWeek::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeacherMinDaysPerWeek::isRelatedToTeacher(const QString& t)
{
	if(this->teacherName==t)
		return true;
	return false;
}

bool ConstraintTeacherMinDaysPerWeek::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMinDaysPerWeek::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMinDaysPerWeek::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeacherMinDaysPerWeek::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeacherMinDaysPerWeek::hasWrongDayOrHour(Rules& r)
{
	if(minDaysPerWeek>r.nDaysPerWeek)
		return true;
	
	return false;
}

bool ConstraintTeacherMinDaysPerWeek::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeacherMinDaysPerWeek::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(minDaysPerWeek>r.nDaysPerWeek)
		minDaysPerWeek=r.nDaysPerWeek;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeachersMinDaysPerWeek::ConstraintTeachersMinDaysPerWeek()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHERS_MIN_DAYS_PER_WEEK;
}

ConstraintTeachersMinDaysPerWeek::ConstraintTeachersMinDaysPerWeek(double wp, int mindays)
 : TimeConstraint(wp)
 {
	assert(mindays>0);
	this->minDaysPerWeek=mindays;

	this->type=CONSTRAINT_TEACHERS_MIN_DAYS_PER_WEEK;
}

bool ConstraintTeachersMinDaysPerWeek::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);
	Q_UNUSED(r);

	return true;
}

bool ConstraintTeachersMinDaysPerWeek::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeachersMinDaysPerWeek::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeachersMinDaysPerWeek>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Minimum_Days_Per_Week>"+CustomFETString::number(this->minDaysPerWeek)+"</Minimum_Days_Per_Week>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeachersMinDaysPerWeek>\n";
	return s;
}

QString ConstraintTeachersMinDaysPerWeek::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teachers min days per week");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("mD:%1", "Minimum days per week").arg(this->minDaysPerWeek);

	return begin+s+end;
}

QString ConstraintTeachersMinDaysPerWeek::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All teachers must respect the minimum number of days per week");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Minimum days per week=%1").arg(this->minDaysPerWeek);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeachersMinDaysPerWeek::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbrokentotal=0;
	for(int i=0; i<r.nInternalTeachers; i++){
		int nbroken;

		nbroken=0;
		//int i=this->teacher_ID;
		int nd=0;
		for(int d=0; d<r.nDaysPerWeek; d++){
			for(int h=0; h<r.nHoursPerDay; h++){
				if(teachersMatrix[i][d][h]>0){
					nd++;
					break;
				}
			}
		}

		if(nd<this->minDaysPerWeek){
			nbroken+=this->minDaysPerWeek-nd;
			nbrokentotal+=nbroken;

			if(conflictsString!=nullptr){
				QString s=(tr(
				 "Time constraint teachers min %1 days per week broken for teacher %2.")
				 .arg(CustomFETString::number(this->minDaysPerWeek))
				 .arg(r.internalTeachersList[i]->name)
				 )
				 +" "
				 +
				 tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(double(nbroken)*weightPercentage/100));
					
				dl.append(s);
				cl.append(double(nbroken)*weightPercentage/100);
			
				*conflictsString+= s+"\n";
			}
		}
	}

	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100)
			assert(nbrokentotal==0);
			
	return weightPercentage/100 * nbrokentotal;
}

bool ConstraintTeachersMinDaysPerWeek::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeachersMinDaysPerWeek::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);
	
	return true;
}

bool ConstraintTeachersMinDaysPerWeek::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMinDaysPerWeek::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMinDaysPerWeek::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeachersMinDaysPerWeek::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeachersMinDaysPerWeek::hasWrongDayOrHour(Rules& r)
{
	if(minDaysPerWeek>r.nDaysPerWeek)
		return true;
	
	return false;
}

bool ConstraintTeachersMinDaysPerWeek::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeachersMinDaysPerWeek::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(minDaysPerWeek>r.nDaysPerWeek)
		minDaysPerWeek=r.nDaysPerWeek;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeacherIntervalMaxDaysPerWeek::ConstraintTeacherIntervalMaxDaysPerWeek()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHER_INTERVAL_MAX_DAYS_PER_WEEK;
}

ConstraintTeacherIntervalMaxDaysPerWeek::ConstraintTeacherIntervalMaxDaysPerWeek(double wp, int maxnd, const QString& tn, int sh, int eh)
	 : TimeConstraint(wp)
{
	this->teacherName = tn;
	this->maxDaysPerWeek=maxnd;
	this->type=CONSTRAINT_TEACHER_INTERVAL_MAX_DAYS_PER_WEEK;
	this->startHour=sh;
	this->endHour=eh;
	assert(sh<eh);
	assert(sh>=0);
}

bool ConstraintTeacherIntervalMaxDaysPerWeek::computeInternalStructure(QWidget* parent, Rules& r)
{
	//this->teacher_ID=r.searchTeacher(this->teacherName);
	teacher_ID=r.teachersHash.value(teacherName, -1);
	assert(this->teacher_ID>=0);
	if(this->startHour>=this->endHour){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint teacher interval max days per week is wrong because start hour >= end hour."
		 " Please correct it. Constraint is:\n%1").arg(this->getDetailedDescription(r)));

		return false;
	}
	if(this->startHour<0){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint teacher interval max days per week is wrong because start hour < first hour of the day."
		 " Please correct it. Constraint is:\n%1").arg(this->getDetailedDescription(r)));

		return false;
	}
	if(this->endHour>r.nHoursPerDay){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint teacher interval max days per week is wrong because end hour > number of hours per day."
		 " Please correct it. Constraint is:\n%1").arg(this->getDetailedDescription(r)));

		return false;
	}
	return true;
}

bool ConstraintTeacherIntervalMaxDaysPerWeek::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeacherIntervalMaxDaysPerWeek::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeacherIntervalMaxDaysPerWeek>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Teacher>"+protect(this->teacherName)+"</Teacher>\n";
	s+=IL3+"<Interval_Start_Hour>"+protect(r.hoursOfTheDay[this->startHour])+"</Interval_Start_Hour>\n";
	if(this->endHour < r.nHoursPerDay){
		s+=IL3+"<Interval_End_Hour>"+protect(r.hoursOfTheDay[this->endHour])+"</Interval_End_Hour>\n";
	}
	else{
		s+=IL3+"<Interval_End_Hour></Interval_End_Hour>\n";
		s+=IL3+"<!-- Interval_End_Hour void means the end of the day (which has no name) -->\n";
	}
	s+=IL3+"<Max_Days_Per_Week>"+CustomFETString::number(this->maxDaysPerWeek)+"</Max_Days_Per_Week>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeacherIntervalMaxDaysPerWeek>\n";
	return s;
}

QString ConstraintTeacherIntervalMaxDaysPerWeek::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s=tr("Teacher interval max days per week");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Abbreviation for weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("T:%1", "Abbreviation for teacher").arg(this->teacherName);s+=translatedCommaSpace();
	s+=tr("ISH:%1", "Abbreviation for interval start hour").arg(r.hoursOfTheDay[this->startHour]);s+=translatedCommaSpace();
	if(this->endHour<r.nHoursPerDay)
		s+=tr("IEH:%1", "Abbreviation for interval end hour").arg(r.hoursOfTheDay[this->endHour]);
	else
		s+=tr("IEH:%1", "Abbreviation for interval end hour").arg(tr("End of the day"));
	s+=translatedCommaSpace();
	s+=tr("MD:%1", "Abbreviation for max days").arg(this->maxDaysPerWeek);

	return begin+s+end;
}

QString ConstraintTeacherIntervalMaxDaysPerWeek::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A teacher respects working in an hourly interval a maximum number of days per week");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Teacher=%1").arg(this->teacherName);s+="\n";
	s+=tr("Interval start hour=%1").arg(r.hoursOfTheDay[this->startHour]);s+="\n";

	if(this->endHour<r.nHoursPerDay)
		s+=tr("Interval end hour=%1").arg(r.hoursOfTheDay[this->endHour]);
	else
		s+=tr("Interval end hour=%1").arg(tr("End of the day"));
	s+="\n";

	s+=tr("Maximum days per week=%1").arg(this->maxDaysPerWeek);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeacherIntervalMaxDaysPerWeek::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;
	
	int t=this->teacher_ID;

	nbroken=0;
	
	Matrix1D<bool> ocDay;
	ocDay.resize(r.nDaysPerWeek);
	for(int d=0; d<r.nDaysPerWeek; d++){
		ocDay[d]=false;
		for(int h=startHour; h<endHour; h++){
			if(teachersMatrix[t][d][h]>0){
				ocDay[d]=true;
			}
		}
	}
	int nOcDays=0;
	for(int d=0; d<r.nDaysPerWeek; d++)
		if(ocDay[d])
			nOcDays++;
	if(nOcDays > this->maxDaysPerWeek){
		nbroken+=nOcDays-this->maxDaysPerWeek;

		if(nbroken>0){
			QString s= tr("Time constraint teacher interval max days per week broken for teacher: %1, allowed %2 days, required %3 days.")
			 .arg(r.internalTeachersList[t]->name)
			 .arg(this->maxDaysPerWeek)
			 .arg(nOcDays);
			s+=" ";
			s += tr("This increases the conflicts total by %1")
			 .arg(CustomFETString::numberPlusTwoDigitsPrecision(nbroken*weightPercentage/100));
			
			dl.append(s);
			cl.append(nbroken*weightPercentage/100);
		
			*conflictsString += s+"\n";
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintTeacherIntervalMaxDaysPerWeek::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeacherIntervalMaxDaysPerWeek::isRelatedToTeacher(const QString& t)
{
	if(this->teacherName==t)
		return true;
	return false;
}

bool ConstraintTeacherIntervalMaxDaysPerWeek::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherIntervalMaxDaysPerWeek::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherIntervalMaxDaysPerWeek::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeacherIntervalMaxDaysPerWeek::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeacherIntervalMaxDaysPerWeek::hasWrongDayOrHour(Rules& r)
{
	if(this->startHour>=r.nHoursPerDay)
		return true;
	if(this->endHour>r.nHoursPerDay)
		return true;
	if(this->maxDaysPerWeek>r.nDaysPerWeek)
		return true;
	
	return false;
}

bool ConstraintTeacherIntervalMaxDaysPerWeek::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(this->startHour<r.nHoursPerDay && this->endHour<=r.nHoursPerDay)
		return true;

	return false;
}

bool ConstraintTeacherIntervalMaxDaysPerWeek::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));

	assert(this->startHour<r.nHoursPerDay && this->endHour<=r.nHoursPerDay);

	if(this->maxDaysPerWeek>r.nDaysPerWeek)
		this->maxDaysPerWeek=r.nDaysPerWeek;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeachersIntervalMaxDaysPerWeek::ConstraintTeachersIntervalMaxDaysPerWeek()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHERS_INTERVAL_MAX_DAYS_PER_WEEK;
}

ConstraintTeachersIntervalMaxDaysPerWeek::ConstraintTeachersIntervalMaxDaysPerWeek(double wp, int maxnd, int sh, int eh)
	 : TimeConstraint(wp)
{
	this->maxDaysPerWeek=maxnd;
	this->type=CONSTRAINT_TEACHERS_INTERVAL_MAX_DAYS_PER_WEEK;
	this->startHour=sh;
	this->endHour=eh;
	assert(sh<eh);
	assert(sh>=0);
}

bool ConstraintTeachersIntervalMaxDaysPerWeek::computeInternalStructure(QWidget* parent, Rules& r)
{
	if(this->startHour>=this->endHour){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint teachers interval max days per week is wrong because start hour >= end hour."
		 " Please correct it. Constraint is:\n%1").arg(this->getDetailedDescription(r)));

		return false;
	}
	if(this->startHour<0){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint teachers interval max days per week is wrong because start hour < first hour of the day."
		 " Please correct it. Constraint is:\n%1").arg(this->getDetailedDescription(r)));

		return false;
	}
	if(this->endHour>r.nHoursPerDay){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint teachers interval max days per week is wrong because end hour > number of hours per day."
		 " Please correct it. Constraint is:\n%1").arg(this->getDetailedDescription(r)));

		return false;
	}
	return true;
}

bool ConstraintTeachersIntervalMaxDaysPerWeek::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeachersIntervalMaxDaysPerWeek::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeachersIntervalMaxDaysPerWeek>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Interval_Start_Hour>"+protect(r.hoursOfTheDay[this->startHour])+"</Interval_Start_Hour>\n";
	if(this->endHour < r.nHoursPerDay){
		s+=IL3+"<Interval_End_Hour>"+protect(r.hoursOfTheDay[this->endHour])+"</Interval_End_Hour>\n";
	}
	else{
		s+=IL3+"<Interval_End_Hour></Interval_End_Hour>\n";
		s+=IL3+"<!-- Interval_End_Hour void means the end of the day (which has no name) -->\n";
	}
	s+=IL3+"<Max_Days_Per_Week>"+CustomFETString::number(this->maxDaysPerWeek)+"</Max_Days_Per_Week>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeachersIntervalMaxDaysPerWeek>\n";
	return s;
}

QString ConstraintTeachersIntervalMaxDaysPerWeek::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s=tr("Teachers interval max days per week");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Abbreviation for weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("ISH:%1", "Abbreviation for interval start hour").arg(r.hoursOfTheDay[this->startHour]);
	s+=translatedCommaSpace();
	if(this->endHour<r.nHoursPerDay)
		s+=tr("IEH:%1", "Abbreviation for interval end hour").arg(r.hoursOfTheDay[this->endHour]);
	else
		s+=tr("IEH:%1", "Abbreviation for interval end hour").arg(tr("End of the day"));
	s+=translatedCommaSpace();
	s+=tr("MD:%1", "Abbreviation for max days").arg(this->maxDaysPerWeek);

	return begin+s+end;
}

QString ConstraintTeachersIntervalMaxDaysPerWeek::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All teachers respect working in an hourly interval a maximum number of days per week");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Interval start hour=%1").arg(r.hoursOfTheDay[this->startHour]);s+="\n";

	if(this->endHour<r.nHoursPerDay)
		s+=tr("Interval end hour=%1").arg(r.hoursOfTheDay[this->endHour]);
	else
		s+=tr("Interval end hour=%1").arg(tr("End of the day"));
	s+="\n";

	s+=tr("Maximum days per week=%1").arg(this->maxDaysPerWeek);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeachersIntervalMaxDaysPerWeek::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken=0;
	
	Matrix1D<bool> ocDay;
	ocDay.resize(r.nDaysPerWeek);
	for(int t=0; t<r.nInternalTeachers; t++){
		for(int d=0; d<r.nDaysPerWeek; d++){
			ocDay[d]=false;
			for(int h=startHour; h<endHour; h++){
				if(teachersMatrix[t][d][h]>0){
					ocDay[d]=true;
				}
			}
		}
		int nOcDays=0;
		for(int d=0; d<r.nDaysPerWeek; d++)
			if(ocDay[d])
				nOcDays++;
		if(nOcDays > this->maxDaysPerWeek){
			nbroken+=nOcDays-this->maxDaysPerWeek;

			if(nOcDays-this->maxDaysPerWeek>0){
				QString s= tr("Time constraint teachers interval max days per week broken for teacher: %1, allowed %2 days, required %3 days.")
				 .arg(r.internalTeachersList[t]->name)
				 .arg(this->maxDaysPerWeek)
				 .arg(nOcDays);
				s+=" ";
				s += tr("This increases the conflicts total by %1")
				 .arg(CustomFETString::numberPlusTwoDigitsPrecision((nOcDays-this->maxDaysPerWeek)*weightPercentage/100));
				
				dl.append(s);
				cl.append((nOcDays-this->maxDaysPerWeek)*weightPercentage/100);
			
				*conflictsString += s+"\n";
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintTeachersIntervalMaxDaysPerWeek::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeachersIntervalMaxDaysPerWeek::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);
	
	return true;
}

bool ConstraintTeachersIntervalMaxDaysPerWeek::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersIntervalMaxDaysPerWeek::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersIntervalMaxDaysPerWeek::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeachersIntervalMaxDaysPerWeek::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeachersIntervalMaxDaysPerWeek::hasWrongDayOrHour(Rules& r)
{
	if(this->startHour>=r.nHoursPerDay)
		return true;
	if(this->endHour>r.nHoursPerDay)
		return true;
	if(this->maxDaysPerWeek>r.nDaysPerWeek)
		return true;
	
	return false;
}

bool ConstraintTeachersIntervalMaxDaysPerWeek::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(this->startHour<r.nHoursPerDay && this->endHour<=r.nHoursPerDay)
		return true;

	return false;
}

bool ConstraintTeachersIntervalMaxDaysPerWeek::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));

	assert(this->startHour<r.nHoursPerDay && this->endHour<=r.nHoursPerDay);

	if(this->maxDaysPerWeek>r.nDaysPerWeek)
		this->maxDaysPerWeek=r.nDaysPerWeek;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsSetIntervalMaxDaysPerWeek::ConstraintStudentsSetIntervalMaxDaysPerWeek()
	: TimeConstraint()
{
	this->type=CONSTRAINT_STUDENTS_SET_INTERVAL_MAX_DAYS_PER_WEEK;
}

ConstraintStudentsSetIntervalMaxDaysPerWeek::ConstraintStudentsSetIntervalMaxDaysPerWeek(double wp, int maxnd, const QString& sn, int sh, int eh)
	 : TimeConstraint(wp)
{
	this->students = sn;
	this->maxDaysPerWeek=maxnd;
	this->type=CONSTRAINT_STUDENTS_SET_INTERVAL_MAX_DAYS_PER_WEEK;
	this->startHour=sh;
	this->endHour=eh;
	assert(sh<eh);
	assert(sh>=0);
}

bool ConstraintStudentsSetIntervalMaxDaysPerWeek::computeInternalStructure(QWidget* parent, Rules& r)
{
	if(this->startHour>=this->endHour){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students set interval max days per week is wrong because start hour >= end hour."
		 " Please correct it. Constraint is:\n%1").arg(this->getDetailedDescription(r)));

		return false;
	}
	if(this->startHour<0){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students set interval max days per week is wrong because start hour < first hour of the day."
		 " Please correct it. Constraint is:\n%1").arg(this->getDetailedDescription(r)));

		return false;
	}
	if(this->endHour>r.nHoursPerDay){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students set interval max days per week is wrong because end hour > number of hours per day."
		 " Please correct it. Constraint is:\n%1").arg(this->getDetailedDescription(r)));

		return false;
	}

	/////////
	//StudentsSet* ss=r.searchAugmentedStudentsSet(this->students);
	StudentsSet* ss=r.studentsHash.value(students, nullptr);

	if(ss==nullptr){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students set interval max days per week is wrong because it refers to nonexistent students set."
		 " Please correct it (removing it might be a solution). Please report potential bug. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
		return false;
	}

	assert(ss!=nullptr);

	populateInternalSubgroupsList(r, ss, this->iSubgroupsList);
	/*this->iSubgroupsList.clear();
	if(ss->type==STUDENTS_SUBGROUP){
		int tmp;
		tmp=((StudentsSubgroup*)ss)->indexInInternalSubgroupsList;
		assert(tmp>=0);
		assert(tmp<r.nInternalSubgroups);
		if(!this->iSubgroupsList.contains(tmp))
			this->iSubgroupsList.append(tmp);
	}
	else if(ss->type==STUDENTS_GROUP){
		StudentsGroup* stg=(StudentsGroup*)ss;
		for(int i=0; i<stg->subgroupsList.size(); i++){
			StudentsSubgroup* sts=stg->subgroupsList[i];
			int tmp;
			tmp=sts->indexInInternalSubgroupsList;
			assert(tmp>=0);
			assert(tmp<r.nInternalSubgroups);
			if(!this->iSubgroupsList.contains(tmp))
				this->iSubgroupsList.append(tmp);
		}
	}
	else if(ss->type==STUDENTS_YEAR){
		StudentsYear* sty=(StudentsYear*)ss;
		for(int i=0; i<sty->groupsList.size(); i++){
			StudentsGroup* stg=sty->groupsList[i];
			for(int j=0; j<stg->subgroupsList.size(); j++){
				StudentsSubgroup* sts=stg->subgroupsList[j];
				int tmp;
				tmp=sts->indexInInternalSubgroupsList;
				assert(tmp>=0);
				assert(tmp<r.nInternalSubgroups);
				if(!this->iSubgroupsList.contains(tmp))
					this->iSubgroupsList.append(tmp);
			}
		}
	}
	else
		assert(0);*/
		
	return true;
}

bool ConstraintStudentsSetIntervalMaxDaysPerWeek::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsSetIntervalMaxDaysPerWeek::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsSetIntervalMaxDaysPerWeek>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Students>"+protect(this->students)+"</Students>\n";
	s+=IL3+"<Interval_Start_Hour>"+protect(r.hoursOfTheDay[this->startHour])+"</Interval_Start_Hour>\n";
	if(this->endHour < r.nHoursPerDay){
		s+=IL3+"<Interval_End_Hour>"+protect(r.hoursOfTheDay[this->endHour])+"</Interval_End_Hour>\n";
	}
	else{
		s+=IL3+"<Interval_End_Hour></Interval_End_Hour>\n";
		s+=IL3+"<!-- Interval_End_Hour void means the end of the day (which has no name) -->\n";
	}
	s+=IL3+"<Max_Days_Per_Week>"+CustomFETString::number(this->maxDaysPerWeek)+"</Max_Days_Per_Week>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsSetIntervalMaxDaysPerWeek>\n";
	return s;
}

QString ConstraintStudentsSetIntervalMaxDaysPerWeek::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s=tr("Students set interval max days per week");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Abbreviation for weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("St:%1", "Abbreviation for students (sets)").arg(this->students);s+=translatedCommaSpace();
	s+=tr("ISH:%1", "Abbreviation for interval start hour").arg(r.hoursOfTheDay[this->startHour]);
	s+=translatedCommaSpace();
	if(this->endHour<r.nHoursPerDay)
		s+=tr("IEH:%1", "Abbreviation for interval end hour").arg(r.hoursOfTheDay[this->endHour]);
	else
		s+=tr("IEH:%1", "Abbreviation for interval end hour").arg(tr("End of the day"));
	s+=translatedCommaSpace();
	s+=tr("MD:%1", "Abbreviation for max days").arg(this->maxDaysPerWeek);

	return begin+s+end;
}

QString ConstraintStudentsSetIntervalMaxDaysPerWeek::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A students set respects working in an hourly interval a maximum number of days per week");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Students set=%1").arg(this->students);s+="\n";
	s+=tr("Interval start hour=%1").arg(r.hoursOfTheDay[this->startHour]);s+="\n";

	if(this->endHour<r.nHoursPerDay)
		s+=tr("Interval end hour=%1").arg(r.hoursOfTheDay[this->endHour]);
	else
		s+=tr("Interval end hour=%1").arg(tr("End of the day"));
	s+="\n";

	s+=tr("Maximum days per week=%1").arg(this->maxDaysPerWeek);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintStudentsSetIntervalMaxDaysPerWeek::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);
		
		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;
	
	nbroken=0;
	
	Matrix1D<bool> ocDay;
	ocDay.resize(r.nDaysPerWeek);
	for(int sbg : std::as_const(this->iSubgroupsList)){
		for(int d=0; d<r.nDaysPerWeek; d++){
			ocDay[d]=false;
			for(int h=startHour; h<endHour; h++){
				if(subgroupsMatrix[sbg][d][h]>0){
					ocDay[d]=true;
				}
			}
		}
		int nOcDays=0;
		for(int d=0; d<r.nDaysPerWeek; d++)
			if(ocDay[d])
				nOcDays++;
		if(nOcDays > this->maxDaysPerWeek){
			nbroken+=nOcDays-this->maxDaysPerWeek;

			if((nOcDays-this->maxDaysPerWeek)>0){
				QString s= tr("Time constraint students set interval max days per week broken for subgroup: %1, allowed %2 days, required %3 days.")
				 .arg(r.internalSubgroupsList[sbg]->name)
				 .arg(this->maxDaysPerWeek)
				 .arg(nOcDays);
				s+=" ";
				s += tr("This increases the conflicts total by %1")
				 .arg(CustomFETString::numberPlusTwoDigitsPrecision((nOcDays-this->maxDaysPerWeek)*weightPercentage/100));
			
				dl.append(s);
				cl.append((nOcDays-this->maxDaysPerWeek)*weightPercentage/100);
		
				*conflictsString += s+"\n";
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintStudentsSetIntervalMaxDaysPerWeek::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsSetIntervalMaxDaysPerWeek::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);
	return false;
}

bool ConstraintStudentsSetIntervalMaxDaysPerWeek::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetIntervalMaxDaysPerWeek::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetIntervalMaxDaysPerWeek::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	return r.setsShareStudents(this->students, s);
}

int ConstraintStudentsSetIntervalMaxDaysPerWeek::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsSetIntervalMaxDaysPerWeek::hasWrongDayOrHour(Rules& r)
{
	if(this->startHour>=r.nHoursPerDay)
		return true;
	if(this->endHour>r.nHoursPerDay)
		return true;
	if(this->maxDaysPerWeek>r.nDaysPerWeek)
		return true;
	
	return false;
}

bool ConstraintStudentsSetIntervalMaxDaysPerWeek::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(this->startHour<r.nHoursPerDay && this->endHour<=r.nHoursPerDay)
		return true;

	return false;
}

bool ConstraintStudentsSetIntervalMaxDaysPerWeek::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));

	assert(this->startHour<r.nHoursPerDay && this->endHour<=r.nHoursPerDay);

	if(this->maxDaysPerWeek>r.nDaysPerWeek)
		this->maxDaysPerWeek=r.nDaysPerWeek;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsIntervalMaxDaysPerWeek::ConstraintStudentsIntervalMaxDaysPerWeek()
	: TimeConstraint()
{
	this->type=CONSTRAINT_STUDENTS_INTERVAL_MAX_DAYS_PER_WEEK;
}

ConstraintStudentsIntervalMaxDaysPerWeek::ConstraintStudentsIntervalMaxDaysPerWeek(double wp, int maxnd, int sh, int eh)
	 : TimeConstraint(wp)
{
	this->maxDaysPerWeek=maxnd;
	this->type=CONSTRAINT_STUDENTS_INTERVAL_MAX_DAYS_PER_WEEK;
	this->startHour=sh;
	this->endHour=eh;
	assert(sh<eh);
	assert(sh>=0);
}

bool ConstraintStudentsIntervalMaxDaysPerWeek::computeInternalStructure(QWidget* parent, Rules& r)
{
	if(this->startHour>=this->endHour){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students interval max days per week is wrong because start hour >= end hour."
		 " Please correct it. Constraint is:\n%1").arg(this->getDetailedDescription(r)));

		return false;
	}
	if(this->startHour<0){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students interval max days per week is wrong because start hour < first hour of the day."
		 " Please correct it. Constraint is:\n%1").arg(this->getDetailedDescription(r)));

		return false;
	}
	if(this->endHour>r.nHoursPerDay){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students interval max days per week is wrong because end hour > number of hours per day."
		 " Please correct it. Constraint is:\n%1").arg(this->getDetailedDescription(r)));

		return false;
	}

	return true;
}

bool ConstraintStudentsIntervalMaxDaysPerWeek::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsIntervalMaxDaysPerWeek::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsIntervalMaxDaysPerWeek>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Interval_Start_Hour>"+protect(r.hoursOfTheDay[this->startHour])+"</Interval_Start_Hour>\n";
	if(this->endHour < r.nHoursPerDay){
		s+=IL3+"<Interval_End_Hour>"+protect(r.hoursOfTheDay[this->endHour])+"</Interval_End_Hour>\n";
	}
	else{
		s+=IL3+"<Interval_End_Hour></Interval_End_Hour>\n";
		s+=IL3+"<!-- Interval_End_Hour void means the end of the day (which has no name) -->\n";
	}
	s+=IL3+"<Max_Days_Per_Week>"+CustomFETString::number(this->maxDaysPerWeek)+"</Max_Days_Per_Week>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsIntervalMaxDaysPerWeek>\n";
	return s;
}

QString ConstraintStudentsIntervalMaxDaysPerWeek::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s=tr("Students interval max days per week");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Abbreviation for weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("ISH:%1", "Abbreviation for interval start hour").arg(r.hoursOfTheDay[this->startHour]);
	s+=translatedCommaSpace();
	if(this->endHour<r.nHoursPerDay)
		s+=tr("IEH:%1", "Abbreviation for interval end hour").arg(r.hoursOfTheDay[this->endHour]);
	else
		s+=tr("IEH:%1", "Abbreviation for interval end hour").arg(tr("End of the day"));
	s+=translatedCommaSpace();
	s+=tr("MD:%1", "Abbreviation for max days").arg(this->maxDaysPerWeek);

	return begin+s+end;
}

QString ConstraintStudentsIntervalMaxDaysPerWeek::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All students respect working in an hourly interval a maximum number of days per week");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Interval start hour=%1").arg(r.hoursOfTheDay[this->startHour]);s+="\n";

	if(this->endHour<r.nHoursPerDay)
		s+=tr("Interval end hour=%1").arg(r.hoursOfTheDay[this->endHour]);
	else
		s+=tr("Interval end hour=%1").arg(tr("End of the day"));
	s+="\n";

	s+=tr("Maximum days per week=%1").arg(this->maxDaysPerWeek);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintStudentsIntervalMaxDaysPerWeek::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;
	
	nbroken=0;
	
	Matrix1D<bool> ocDay;
	ocDay.resize(r.nDaysPerWeek);
	for(int sbg=0; sbg<r.nInternalSubgroups; sbg++){
		for(int d=0; d<r.nDaysPerWeek; d++){
			ocDay[d]=false;
			for(int h=startHour; h<endHour; h++){
				if(subgroupsMatrix[sbg][d][h]>0){
					ocDay[d]=true;
				}
			}
		}
		int nOcDays=0;
		for(int d=0; d<r.nDaysPerWeek; d++)
			if(ocDay[d])
				nOcDays++;
		if(nOcDays > this->maxDaysPerWeek){
			nbroken+=nOcDays-this->maxDaysPerWeek;

			if((nOcDays-this->maxDaysPerWeek)>0){
				QString s= tr("Time constraint students interval max days per week broken for subgroup: %1, allowed %2 days, required %3 days.")
				 .arg(r.internalSubgroupsList[sbg]->name)
				 .arg(this->maxDaysPerWeek)
				 .arg(nOcDays);
				s+=" ";
				s += tr("This increases the conflicts total by %1")
				 .arg(CustomFETString::numberPlusTwoDigitsPrecision((nOcDays-this->maxDaysPerWeek)*weightPercentage/100));
			
				dl.append(s);
				cl.append((nOcDays-this->maxDaysPerWeek)*weightPercentage/100);
		
				*conflictsString += s+"\n";
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintStudentsIntervalMaxDaysPerWeek::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsIntervalMaxDaysPerWeek::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);
	return false;
}

bool ConstraintStudentsIntervalMaxDaysPerWeek::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsIntervalMaxDaysPerWeek::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsIntervalMaxDaysPerWeek::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);
	return true;
}

int ConstraintStudentsIntervalMaxDaysPerWeek::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsIntervalMaxDaysPerWeek::hasWrongDayOrHour(Rules& r)
{
	if(this->startHour>=r.nHoursPerDay)
		return true;
	if(this->endHour>r.nHoursPerDay)
		return true;
	if(this->maxDaysPerWeek>r.nDaysPerWeek)
		return true;
	
	return false;
}

bool ConstraintStudentsIntervalMaxDaysPerWeek::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(this->startHour<r.nHoursPerDay && this->endHour<=r.nHoursPerDay)
		return true;

	return false;
}

bool ConstraintStudentsIntervalMaxDaysPerWeek::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));

	assert(this->startHour<r.nHoursPerDay && this->endHour<=r.nHoursPerDay);

	if(this->maxDaysPerWeek>r.nDaysPerWeek)
		this->maxDaysPerWeek=r.nDaysPerWeek;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivitiesEndStudentsDay::ConstraintActivitiesEndStudentsDay()
	: TimeConstraint()
{
	this->type = CONSTRAINT_ACTIVITIES_END_STUDENTS_DAY;
}

ConstraintActivitiesEndStudentsDay::ConstraintActivitiesEndStudentsDay(double wp, const QString& te,
	const QString& st, const QString& su, const QString& sut)
	: TimeConstraint(wp)
{
	this->teacherName=te;
	this->subjectName=su;
	this->activityTagName=sut;
	this->studentsName=st;
	this->type=CONSTRAINT_ACTIVITIES_END_STUDENTS_DAY;
}

bool ConstraintActivitiesEndStudentsDay::computeInternalStructure(QWidget* parent, Rules& r)
{
	this->nActivities=0;
	this->activitiesIndices.clear();

	int it;
	Activity* act;
	int i;
	for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];

		//check if this activity has the corresponding teacher
		if(this->teacherName!=""){
			it = act->teachersNames.indexOf(this->teacherName);
			if(it==-1)
				continue;
		}
		//check if this activity has the corresponding students
		if(this->studentsName!=""){
			bool commonStudents=false;
			for(const QString& st : std::as_const(act->studentsNames))
				if(r.augmentedSetsShareStudentsFaster(st, studentsName)){
					commonStudents=true;
					break;
				}
		
			if(!commonStudents)
				continue;
		}
		//check if this activity has the corresponding subject
		if(this->subjectName!="" && act->subjectName!=this->subjectName){
				continue;
		}
		//check if this activity has the corresponding activity tag
		if(this->activityTagName!="" && !act->activityTagsNames.contains(this->activityTagName)){
				continue;
		}
	
		assert(this->nActivities < r.nInternalActivities);
		this->nActivities++;
		this->activitiesIndices.append(i);
	}
	
	assert(this->activitiesIndices.count()==this->nActivities);

	if(this->nActivities>0)
		return true;
	else{
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to no activities). Please modify, deactivate, or remove it:\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}
}

bool ConstraintActivitiesEndStudentsDay::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintActivitiesEndStudentsDay::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintActivitiesEndStudentsDay>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Teacher>"+protect(this->teacherName)+"</Teacher>\n";
	s+=IL3+"<Students>"+protect(this->studentsName)+"</Students>\n";
	s+=IL3+"<Subject>"+protect(this->subjectName)+"</Subject>\n";
	s+=IL3+"<Activity_Tag>"+protect(this->activityTagName)+"</Activity_Tag>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivitiesEndStudentsDay>\n";
	return s;
}

QString ConstraintActivitiesEndStudentsDay::getDescription(Rules& r)
{
	Q_UNUSED(r);
	
	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString tc, st, su, at;
	
	if(this->teacherName!="")
		tc=tr("teacher=%1").arg(this->teacherName);
	else
		tc=tr("all teachers");
		
	if(this->studentsName!="")
		st=tr("students=%1").arg(this->studentsName);
	else
		st=tr("all students");
		
	if(this->subjectName!="")
		su=tr("subject=%1").arg(this->subjectName);
	else
		su=tr("all subjects");
		
	if(this->activityTagName!="")
		at=tr("activity tag=%1").arg(this->activityTagName);
	else
		at=tr("all activity tags");
	
	QString s;
	s+=tr("Activities with %1, %2, %3, %4, must end students' day", "%1...%4 are conditions for the activities").arg(tc).arg(st).arg(su).arg(at);

	s+=translatedCommaSpace();

	s+=tr("WP:%1%", "Abbreviation for Weight Percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintActivitiesEndStudentsDay::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("Activities with:");s+="\n";

	if(this->teacherName!="")
		s+=tr("Teacher=%1").arg(this->teacherName);
	else
		s+=tr("All teachers");
	s+="\n";
		
	if(this->studentsName!="")
		s+=tr("Students=%1").arg(this->studentsName);
	else
		s+=tr("All students");
	s+="\n";
		
	if(this->subjectName!="")
		s+=tr("Subject=%1").arg(this->subjectName);
	else
		s+=tr("All subjects");
	s+="\n";
		
	if(this->activityTagName!="")
		s+=tr("Activity tag=%1").arg(this->activityTagName);
	else
		s+=tr("All activity tags");
	s+="\n";

	s+=tr("must end students' day");
	s+="\n";

	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintActivitiesEndStudentsDay::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken=0;

	assert(r.internalStructureComputed);

	for(int kk=0; kk<this->nActivities; kk++){
		int tmp=0;
		int ai=this->activitiesIndices[kk];
	
		if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek; //the day when this activity was scheduled
			int h=c.times[ai]/r.nDaysPerWeek; //the hour
		
			for(int j=0; j<r.internalActivitiesList[ai].iSubgroupsList.count(); j++){
				int sb=r.internalActivitiesList[ai].iSubgroupsList.at(j);
				for(int hh=h+r.internalActivitiesList[ai].duration; hh<r.nHoursPerDay; hh++)
					if(subgroupsMatrix[sb][d][hh]>0){
						nbroken++;
						tmp=1;
						break;
					}
				if(tmp>0)
					break;
			}

			if(conflictsString!=nullptr && tmp>0){
				QString s=tr("Time constraint activities end students' day broken for activity with id=%1 (%2), increases conflicts total by %3",
				 "%1 is the id, %2 is the detailed description of the activity")
				 .arg(r.internalActivitiesList[ai].id)
				 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[ai].id))
				 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*tmp));

				dl.append(s);
				cl.append(weightPercentage/100*tmp);
	
				*conflictsString+= s+"\n";
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return nbroken * weightPercentage/100;
}

bool ConstraintActivitiesEndStudentsDay::isRelatedToActivity(Rules& r, int aid)
{
	Activity* a=r.activitiesPointerHash.value(aid, nullptr);
	assert(a!=nullptr);

	int it;

	//check if this activity has the corresponding teacher
	if(this->teacherName!=""){
		it = a->teachersNames.indexOf(this->teacherName);
		if(it==-1)
			return false;
	}
	//check if this activity has the corresponding students
	if(this->studentsName!=""){
		bool commonStudents=false;
		for(const QString& st : std::as_const(a->studentsNames)){
			if(r.setsShareStudents(st, this->studentsName)){
				commonStudents=true;
				break;
			}
		}
		if(!commonStudents)
			return false;
	}
	//check if this activity has the corresponding subject
	if(this->subjectName!="" && a->subjectName!=this->subjectName)
		return false;
	//check if this activity has the corresponding activity tag
	if(this->activityTagName!="" && !a->activityTagsNames.contains(this->activityTagName))
		return false;

	return true;
}

bool ConstraintActivitiesEndStudentsDay::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivitiesEndStudentsDay::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesEndStudentsDay::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesEndStudentsDay::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);
	
	return false;
}

int ConstraintActivitiesEndStudentsDay::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivitiesEndStudentsDay::hasWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

bool ConstraintActivitiesEndStudentsDay::canRepairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0);
	
	return true;
}

bool ConstraintActivitiesEndStudentsDay::repairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0); //should check hasWrongDayOrHour, firstly

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivityEndsTeachersDay::ConstraintActivityEndsTeachersDay()
	: TimeConstraint()
{
	this->type = CONSTRAINT_ACTIVITY_ENDS_TEACHERS_DAY;
}

ConstraintActivityEndsTeachersDay::ConstraintActivityEndsTeachersDay(double wp, int actId)
	: TimeConstraint(wp)
{
	this->activityId = actId;
	this->type = CONSTRAINT_ACTIVITY_ENDS_TEACHERS_DAY;
}

bool ConstraintActivityEndsTeachersDay::computeInternalStructure(QWidget* parent, Rules& r)
{
	/*Activity* act;
	int i;
	for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];
		if(act->id==this->activityId)
			break;
	}*/
	
	int i=r.activitiesHash.value(activityId, r.nInternalActivities);
	
	if(i==r.nInternalActivities){
		//assert(0);
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"), 
			tr("Following constraint is wrong (because it refers to invalid activity id). Please correct it (maybe removing it is a solution):\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}

	this->activityIndex=i;
	return true;
}

bool ConstraintActivityEndsTeachersDay::hasInactiveActivities(Rules& r)
{
	if(r.inactiveActivities.contains(this->activityId))
		return true;
	return false;
}

QString ConstraintActivityEndsTeachersDay::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintActivityEndsTeachersDay>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Activity_Id>"+CustomFETString::number(this->activityId)+"</Activity_Id>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivityEndsTeachersDay>\n";
	return s;
}

QString ConstraintActivityEndsTeachersDay::getDescription(Rules& r)
{
	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Act. id: %1 (%2) must end teachers' day",
		"%1 is the id, %2 is the detailed description of the activity.")
		.arg(getActivityDescription(r, this->activityId))
		.arg(getActivityDetailedDescription(r, this->activityId));
	s+=translatedCommaSpace();

	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintActivityEndsTeachersDay::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("Activity must end teachers' day");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Activity id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity.")
		.arg(this->activityId)
		.arg(getActivityDetailedDescription(r, this->activityId));s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintActivityEndsTeachersDay::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString> &dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

	nbroken=0;
	if(c.times[this->activityIndex]!=UNALLOCATED_TIME){
		int d=c.times[this->activityIndex]%r.nDaysPerWeek; //the day when this activity was scheduled
		int h=c.times[this->activityIndex]/r.nDaysPerWeek; //the hour
		
		int i=this->activityIndex;
		for(int j=0; j<r.internalActivitiesList[i].iTeachersList.count(); j++){
			int tch=r.internalActivitiesList[i].iTeachersList.at(j);
			for(int hh=h+r.internalActivitiesList[i].duration; hh<r.nHoursPerDay; hh++)
				if(teachersMatrix[tch][d][hh]>0){
					nbroken=1;
					break;
				}
			if(nbroken>0)
				break;
		}
	}

	if(conflictsString!=nullptr && nbroken>0){
		QString s=tr("Time constraint activity ends teachers' day broken for activity with id=%1 (%2), increases conflicts total by %3",
		 "%1 is the id, %2 is the detailed description of the activity")
		 .arg(this->activityId)
		 .arg(getActivityDetailedDescription(r, this->activityId))
		 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*nbroken));

		dl.append(s);
		cl.append(weightPercentage/100*nbroken);
	
		*conflictsString+= s+"\n";
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return nbroken * weightPercentage/100;
}

bool ConstraintActivityEndsTeachersDay::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	if(this->activityId==aid)
		return true;
	return false;
}

bool ConstraintActivityEndsTeachersDay::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivityEndsTeachersDay::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivityEndsTeachersDay::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivityEndsTeachersDay::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);
	
	return false;
}

int ConstraintActivityEndsTeachersDay::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivityEndsTeachersDay::hasWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

bool ConstraintActivityEndsTeachersDay::canRepairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0);
	
	return true;
}

bool ConstraintActivityEndsTeachersDay::repairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0); //should check hasWrongDayOrHour, firstly

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivitiesEndTeachersDay::ConstraintActivitiesEndTeachersDay()
	: TimeConstraint()
{
	this->type = CONSTRAINT_ACTIVITIES_END_TEACHERS_DAY;
}

ConstraintActivitiesEndTeachersDay::ConstraintActivitiesEndTeachersDay(double wp, const QString& te,
	const QString& st, const QString& su, const QString& sut)
	: TimeConstraint(wp)
{
	this->teacherName=te;
	this->subjectName=su;
	this->activityTagName=sut;
	this->studentsName=st;
	this->type=CONSTRAINT_ACTIVITIES_END_TEACHERS_DAY;
}

bool ConstraintActivitiesEndTeachersDay::computeInternalStructure(QWidget* parent, Rules& r)
{
	this->nActivities=0;
	this->activitiesIndices.clear();

	int it;
	Activity* act;
	int i;
	for(i=0; i<r.nInternalActivities; i++){
		act=&r.internalActivitiesList[i];

		//check if this activity has the corresponding teacher
		if(this->teacherName!=""){
			it = act->teachersNames.indexOf(this->teacherName);
			if(it==-1)
				continue;
		}
		//check if this activity has the corresponding students
		if(this->studentsName!=""){
			bool commonStudents=false;
			for(const QString& st : std::as_const(act->studentsNames))
				if(r.augmentedSetsShareStudentsFaster(st, studentsName)){
					commonStudents=true;
					break;
				}
		
			if(!commonStudents)
				continue;
		}
		//check if this activity has the corresponding subject
		if(this->subjectName!="" && act->subjectName!=this->subjectName){
				continue;
		}
		//check if this activity has the corresponding activity tag
		if(this->activityTagName!="" && !act->activityTagsNames.contains(this->activityTagName)){
				continue;
		}
	
		assert(this->nActivities < MAX_ACTIVITIES);	
		this->nActivities++;
		this->activitiesIndices.append(i);
	}
	
	assert(this->activitiesIndices.count()==this->nActivities);

	if(this->nActivities>0)
		return true;
	else{
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to no activities). Please modify, deactivate, or remove it:\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}
}

bool ConstraintActivitiesEndTeachersDay::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintActivitiesEndTeachersDay::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintActivitiesEndTeachersDay>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Teacher>"+protect(this->teacherName)+"</Teacher>\n";
	s+=IL3+"<Students>"+protect(this->studentsName)+"</Students>\n";
	s+=IL3+"<Subject>"+protect(this->subjectName)+"</Subject>\n";
	s+=IL3+"<Activity_Tag>"+protect(this->activityTagName)+"</Activity_Tag>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivitiesEndTeachersDay>\n";
	return s;
}

QString ConstraintActivitiesEndTeachersDay::getDescription(Rules& r)
{
	Q_UNUSED(r);
	
	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString tc, st, su, at;
	
	if(this->teacherName!="")
		tc=tr("teacher=%1").arg(this->teacherName);
	else
		tc=tr("all teachers");
		
	if(this->studentsName!="")
		st=tr("students=%1").arg(this->studentsName);
	else
		st=tr("all students");
		
	if(this->subjectName!="")
		su=tr("subject=%1").arg(this->subjectName);
	else
		su=tr("all subjects");
		
	if(this->activityTagName!="")
		at=tr("activity tag=%1").arg(this->activityTagName);
	else
		at=tr("all activity tags");
	
	QString s;
	s+=tr("Activities with %1, %2, %3, %4, must end teachers' day", "%1...%4 are conditions for the activities").arg(tc).arg(st).arg(su).arg(at);

	s+=translatedCommaSpace();

	s+=tr("WP:%1%", "Abbreviation for Weight Percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintActivitiesEndTeachersDay::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("Activities with:");s+="\n";

	if(this->teacherName!="")
		s+=tr("Teacher=%1").arg(this->teacherName);
	else
		s+=tr("All teachers");
	s+="\n";
		
	if(this->studentsName!="")
		s+=tr("Students=%1").arg(this->studentsName);
	else
		s+=tr("All students");
	s+="\n";
		
	if(this->subjectName!="")
		s+=tr("Subject=%1").arg(this->subjectName);
	else
		s+=tr("All subjects");
	s+="\n";
		
	if(this->activityTagName!="")
		s+=tr("Activity tag=%1").arg(this->activityTagName);
	else
		s+=tr("All activity tags");
	s+="\n";

	s+=tr("must end teachers' day");
	s+="\n";

	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintActivitiesEndTeachersDay::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString> &dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken=0;

	assert(r.internalStructureComputed);

	for(int kk=0; kk<this->nActivities; kk++){
		int tmp=0;
		int ai=this->activitiesIndices[kk];
	
		if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek; //the day when this activity was scheduled
			int h=c.times[ai]/r.nDaysPerWeek; //the hour
		
			for(int j=0; j<r.internalActivitiesList[ai].iTeachersList.count(); j++){
				int tch=r.internalActivitiesList[ai].iTeachersList.at(j);
				for(int hh=h+r.internalActivitiesList[ai].duration; hh<r.nHoursPerDay; hh++)
					if(teachersMatrix[tch][d][hh]>0){
						nbroken++;
						tmp=1;
						break;
					}
				if(tmp>0)
					break;
			}

			if(conflictsString!=nullptr && tmp>0){
				QString s=tr("Time constraint activities end teachers' day broken for activity with id=%1 (%2), increases conflicts total by %3",
				 "%1 is the id, %2 is the detailed description of the activity")
				 .arg(r.internalActivitiesList[ai].id)
				 .arg(getActivityDetailedDescription(r, r.internalActivitiesList[ai].id))
				 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*tmp));

				dl.append(s);
				cl.append(weightPercentage/100*tmp);
	
				*conflictsString+= s+"\n";
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return nbroken * weightPercentage/100;
}

bool ConstraintActivitiesEndTeachersDay::isRelatedToActivity(Rules& r, int aid)
{
	Activity* a=r.activitiesPointerHash.value(aid, nullptr);
	assert(a!=nullptr);

	int it;

	//check if this activity has the corresponding teacher
	if(this->teacherName!=""){
		it = a->teachersNames.indexOf(this->teacherName);
		if(it==-1)
			return false;
	}
	//check if this activity has the corresponding students
	if(this->studentsName!=""){
		bool commonStudents=false;
		for(const QString& st : std::as_const(a->studentsNames)){
			if(r.setsShareStudents(st, this->studentsName)){
				commonStudents=true;
				break;
			}
		}
		if(!commonStudents)
			return false;
	}
	//check if this activity has the corresponding subject
	if(this->subjectName!="" && a->subjectName!=this->subjectName)
		return false;
	//check if this activity has the corresponding activity tag
	if(this->activityTagName!="" && !a->activityTagsNames.contains(this->activityTagName))
		return false;

	return true;
}

bool ConstraintActivitiesEndTeachersDay::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivitiesEndTeachersDay::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesEndTeachersDay::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesEndTeachersDay::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);
	
	return false;
}

int ConstraintActivitiesEndTeachersDay::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivitiesEndTeachersDay::hasWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

bool ConstraintActivitiesEndTeachersDay::canRepairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0);
	
	return true;
}

bool ConstraintActivitiesEndTeachersDay::repairWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);
	assert(0); //should check hasWrongDayOrHour, firstly

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeachersActivityTagMaxHoursDaily::ConstraintTeachersActivityTagMaxHoursDaily()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_DAILY;
}

ConstraintTeachersActivityTagMaxHoursDaily::ConstraintTeachersActivityTagMaxHoursDaily(double wp, int maxhours, const QString& activityTag)
 : TimeConstraint(wp)
 {
	assert(maxhours>0);
	this->maxHoursDaily=maxhours;
	this->activityTagName=activityTag;

	this->type=CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_DAILY;
}

bool ConstraintTeachersActivityTagMaxHoursDaily::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);

	//this->activityTagIndex=r.searchActivityTag(this->activityTagName);
	activityTagIndex=r.activityTagsHash.value(activityTagName, -1);
	assert(this->activityTagIndex>=0);
	
	this->canonicalTeachersList.clear();
	for(int i=0; i<r.nInternalTeachers; i++){
		bool found=false;
	
		Teacher* tch=r.internalTeachersList[i];
		for(int actIndex : std::as_const(tch->activitiesForTeacher)){
			if(r.internalActivitiesList[actIndex].iActivityTagsSet.contains(this->activityTagIndex)){
				found=true;
				break;
			}
		}
		
		if(found)
			this->canonicalTeachersList.append(i);
	}

	return true;
}

bool ConstraintTeachersActivityTagMaxHoursDaily::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeachersActivityTagMaxHoursDaily::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeachersActivityTagMaxHoursDaily>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Activity_Tag>"+protect(this->activityTagName)+"</Activity_Tag>\n";
	s+=IL3+"<Maximum_Hours_Daily>"+CustomFETString::number(this->maxHoursDaily)+"</Maximum_Hours_Daily>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeachersActivityTagMaxHoursDaily>\n";
	return s;
}

QString ConstraintTeachersActivityTagMaxHoursDaily::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teachers for activity tag %1 have max %2 hours daily").arg(this->activityTagName).arg(this->maxHoursDaily);s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintTeachersActivityTagMaxHoursDaily::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All teachers, for an activity tag, must respect the maximum number of hours daily");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Activity tag=%1").arg(this->activityTagName); s+="\n";
	s+=tr("Maximum hours daily=%1").arg(this->maxHoursDaily); s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeachersActivityTagMaxHoursDaily::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;
	
	Matrix2D<int> crtTeacherTimetableActivityTag;
	crtTeacherTimetableActivityTag.resize(r.nDaysPerWeek, r.nHoursPerDay);

	nbroken=0;
	for(int i : std::as_const(this->canonicalTeachersList)){
		Teacher* tch=r.internalTeachersList[i];
		for(int d=0; d<r.nDaysPerWeek; d++)
			for(int h=0; h<r.nHoursPerDay; h++)
				crtTeacherTimetableActivityTag[d][h]=-1;
				
		for(int ai : std::as_const(tch->activitiesForTeacher)) if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek;
			int h=c.times[ai]/r.nDaysPerWeek;
			for(int dur=0; dur<r.internalActivitiesList[ai].duration; dur++){
				assert(h+dur<r.nHoursPerDay);
				assert(crtTeacherTimetableActivityTag[d][h+dur]==-1);
				if(r.internalActivitiesList[ai].iActivityTagsSet.contains(this->activityTagIndex))
					crtTeacherTimetableActivityTag[d][h+dur]=this->activityTagIndex;
			}
		}
	
		for(int d=0; d<r.nDaysPerWeek; d++){
			int nd=0;
			for(int h=0; h<r.nHoursPerDay; h++)
				if(crtTeacherTimetableActivityTag[d][h]==this->activityTagIndex)
					nd++;

			if(nd>this->maxHoursDaily){
				nbroken++;

				if(conflictsString!=nullptr){
					QString s=(tr("Time constraint teachers activity tag %1 max %2 hours daily broken for teacher %3, on day %4, length=%5.")
					 .arg(this->activityTagName)
					 .arg(CustomFETString::number(this->maxHoursDaily))
					 .arg(r.internalTeachersList[i]->name)
					 .arg(r.daysOfTheWeek[d])
					 .arg(nd)
					 )
					 +
					 " "
					 +
					 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100.0)));
					
					dl.append(s);
					cl.append(weightPercentage/100.0);
				
					*conflictsString+= s+"\n";
				}
			}
		}
	}

	if(weightPercentage==100.0)
		assert(nbroken==0);
	return weightPercentage/100.0 * nbroken;
}

bool ConstraintTeachersActivityTagMaxHoursDaily::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeachersActivityTagMaxHoursDaily::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return true;
}

bool ConstraintTeachersActivityTagMaxHoursDaily::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersActivityTagMaxHoursDaily::isRelatedToActivityTag(const QString& s)
{
	return s==this->activityTagName;
}

bool ConstraintTeachersActivityTagMaxHoursDaily::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeachersActivityTagMaxHoursDaily::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeachersActivityTagMaxHoursDaily::hasWrongDayOrHour(Rules& r)
{
	if(maxHoursDaily>r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintTeachersActivityTagMaxHoursDaily::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeachersActivityTagMaxHoursDaily::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxHoursDaily>r.nHoursPerDay)
		maxHoursDaily=r.nHoursPerDay;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeacherActivityTagMaxHoursDaily::ConstraintTeacherActivityTagMaxHoursDaily()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_DAILY;
}

ConstraintTeacherActivityTagMaxHoursDaily::ConstraintTeacherActivityTagMaxHoursDaily(double wp, int maxhours, const QString& teacher, const QString& activityTag)
 : TimeConstraint(wp)
 {
	assert(maxhours>0);
	this->maxHoursDaily=maxhours;
	this->teacherName=teacher;
	this->activityTagName=activityTag;

	this->type=CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_DAILY;
}

bool ConstraintTeacherActivityTagMaxHoursDaily::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);

	//this->teacher_ID=r.searchTeacher(this->teacherName);
	teacher_ID=r.teachersHash.value(teacherName, -1);
	assert(this->teacher_ID>=0);

	//this->activityTagIndex=r.searchActivityTag(this->activityTagName);
	activityTagIndex=r.activityTagsHash.value(activityTagName, -1);
	assert(this->activityTagIndex>=0);

	this->canonicalTeachersList.clear();
	int i=this->teacher_ID;
	bool found=false;
	
	Teacher* tch=r.internalTeachersList[i];
	for(int actIndex : std::as_const(tch->activitiesForTeacher)){
		if(r.internalActivitiesList[actIndex].iActivityTagsSet.contains(this->activityTagIndex)){
			found=true;
			break;
		}
	}
		
	if(found)
		this->canonicalTeachersList.append(i);

	return true;
}

bool ConstraintTeacherActivityTagMaxHoursDaily::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeacherActivityTagMaxHoursDaily::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeacherActivityTagMaxHoursDaily>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Teacher>"+protect(this->teacherName)+"</Teacher>\n";
	s+=IL3+"<Activity_Tag>"+protect(this->activityTagName)+"</Activity_Tag>\n";
	s+=IL3+"<Maximum_Hours_Daily>"+CustomFETString::number(this->maxHoursDaily)+"</Maximum_Hours_Daily>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeacherActivityTagMaxHoursDaily>\n";
	return s;
}

QString ConstraintTeacherActivityTagMaxHoursDaily::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teacher %1 for activity tag %2 has max %3 hours daily").arg(this->teacherName).arg(this->activityTagName).arg(this->maxHoursDaily);s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintTeacherActivityTagMaxHoursDaily::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A teacher for an activity tag must respect the maximum number of hours daily");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Teacher=%1").arg(this->teacherName);s+="\n";
	s+=tr("Activity tag=%1").arg(this->activityTagName);s+="\n";
	s+=tr("Maximum hours daily=%1").arg(this->maxHoursDaily); s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeacherActivityTagMaxHoursDaily::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	Matrix2D<int> crtTeacherTimetableActivityTag;
	crtTeacherTimetableActivityTag.resize(r.nDaysPerWeek, r.nHoursPerDay);

	nbroken=0;
	for(int i : std::as_const(this->canonicalTeachersList)){
		Teacher* tch=r.internalTeachersList[i];
		for(int d=0; d<r.nDaysPerWeek; d++)
			for(int h=0; h<r.nHoursPerDay; h++)
				crtTeacherTimetableActivityTag[d][h]=-1;
				
		for(int ai : std::as_const(tch->activitiesForTeacher)) if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek;
			int h=c.times[ai]/r.nDaysPerWeek;
			for(int dur=0; dur<r.internalActivitiesList[ai].duration; dur++){
				assert(h+dur<r.nHoursPerDay);
				assert(crtTeacherTimetableActivityTag[d][h+dur]==-1);
				if(r.internalActivitiesList[ai].iActivityTagsSet.contains(this->activityTagIndex))
					crtTeacherTimetableActivityTag[d][h+dur]=this->activityTagIndex;
			}
		}
	
		for(int d=0; d<r.nDaysPerWeek; d++){
			int nd=0;
			for(int h=0; h<r.nHoursPerDay; h++)
				if(crtTeacherTimetableActivityTag[d][h]==this->activityTagIndex)
					nd++;

			if(nd>this->maxHoursDaily){
				nbroken++;

				if(conflictsString!=nullptr){
					QString s=(tr("Time constraint teacher activity tag %1 max %2 hours daily broken for teacher %3, on day %4, length=%5.")
					 .arg(this->activityTagName)
					 .arg(CustomFETString::number(this->maxHoursDaily))
					 .arg(r.internalTeachersList[i]->name)
					 .arg(r.daysOfTheWeek[d])
					 .arg(nd)
					 )
					 +
					 " "
					 +
					 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100.0)));
					
					dl.append(s);
					cl.append(weightPercentage/100.0);
				
					*conflictsString+= s+"\n";
				}
			}
		}
	}

	if(weightPercentage==100.0)
		assert(nbroken==0);
	return weightPercentage/100.0 * nbroken;
}

bool ConstraintTeacherActivityTagMaxHoursDaily::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeacherActivityTagMaxHoursDaily::isRelatedToTeacher(const QString& t)
{
	if(this->teacherName==t)
		return true;
	return false;
}

bool ConstraintTeacherActivityTagMaxHoursDaily::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherActivityTagMaxHoursDaily::isRelatedToActivityTag(const QString& s)
{
	return this->activityTagName==s;
}

bool ConstraintTeacherActivityTagMaxHoursDaily::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeacherActivityTagMaxHoursDaily::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeacherActivityTagMaxHoursDaily::hasWrongDayOrHour(Rules& r)
{
	if(maxHoursDaily>r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintTeacherActivityTagMaxHoursDaily::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeacherActivityTagMaxHoursDaily::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxHoursDaily>r.nHoursPerDay)
		maxHoursDaily=r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsActivityTagMaxHoursDaily::ConstraintStudentsActivityTagMaxHoursDaily()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_DAILY;
	this->maxHoursDaily = -1;
}

ConstraintStudentsActivityTagMaxHoursDaily::ConstraintStudentsActivityTagMaxHoursDaily(double wp, int maxnh, const QString& activityTag)
	: TimeConstraint(wp)
{
	this->maxHoursDaily = maxnh;
	this->activityTagName=activityTag;
	this->type = CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_DAILY;
}

bool ConstraintStudentsActivityTagMaxHoursDaily::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);

	//this->activityTagIndex=r.searchActivityTag(this->activityTagName);
	activityTagIndex=r.activityTagsHash.value(activityTagName, -1);
	assert(this->activityTagIndex>=0);
	
	this->canonicalSubgroupsList.clear();
	for(int i=0; i<r.nInternalSubgroups; i++){
		bool found=false;
	
		StudentsSubgroup* sbg=r.internalSubgroupsList[i];
		for(int actIndex : std::as_const(sbg->activitiesForSubgroup)){
			if(r.internalActivitiesList[actIndex].iActivityTagsSet.contains(this->activityTagIndex)){
				found=true;
				break;
			}
		}
		
		if(found)
			this->canonicalSubgroupsList.append(i);
	}

	return true;
}

bool ConstraintStudentsActivityTagMaxHoursDaily::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsActivityTagMaxHoursDaily::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsActivityTagMaxHoursDaily>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	
	s+=IL3+"<Activity_Tag>"+protect(this->activityTagName)+"</Activity_Tag>\n";
	
	if(this->maxHoursDaily>=0)
		s+=IL3+"<Maximum_Hours_Daily>"+CustomFETString::number(this->maxHoursDaily)+"</Maximum_Hours_Daily>\n";
	else
		assert(0);
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsActivityTagMaxHoursDaily>\n";
	return s;
}

QString ConstraintStudentsActivityTagMaxHoursDaily::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Students for activity tag %1 have max %2 hours daily")
		.arg(this->activityTagName).arg(this->maxHoursDaily); s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintStudentsActivityTagMaxHoursDaily::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All students, for an activity tag, must respect the maximum number of hours daily"); s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Activity tag=%1").arg(this->activityTagName);s+="\n";
	s+=tr("Maximum hours daily=%1").arg(this->maxHoursDaily);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintStudentsActivityTagMaxHoursDaily::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	int nbroken;

	nbroken=0;
	
	Matrix2D<int> crtSubgroupTimetableActivityTag;
	crtSubgroupTimetableActivityTag.resize(r.nDaysPerWeek, r.nHoursPerDay);

	for(int i : std::as_const(this->canonicalSubgroupsList)){
		StudentsSubgroup* sbg=r.internalSubgroupsList[i];
		for(int d=0; d<r.nDaysPerWeek; d++)
			for(int h=0; h<r.nHoursPerDay; h++)
				crtSubgroupTimetableActivityTag[d][h]=-1;
		for(int ai : std::as_const(sbg->activitiesForSubgroup)) if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek;
			int h=c.times[ai]/r.nDaysPerWeek;
			for(int dur=0; dur<r.internalActivitiesList[ai].duration; dur++){
				assert(h+dur<r.nHoursPerDay);
				assert(crtSubgroupTimetableActivityTag[d][h+dur]==-1);
				if(r.internalActivitiesList[ai].iActivityTagsSet.contains(this->activityTagIndex))
					crtSubgroupTimetableActivityTag[d][h+dur]=this->activityTagIndex;
			}
		}

		for(int d=0; d<r.nDaysPerWeek; d++){
			int nd=0;
			for(int h=0; h<r.nHoursPerDay; h++)
				if(crtSubgroupTimetableActivityTag[d][h]==this->activityTagIndex)
					nd++;
				
			if(nd>this->maxHoursDaily){
				nbroken++;

				if(conflictsString!=nullptr){
					QString s=(tr(
					 "Time constraint students, activity tag %1, max %2 hours daily, broken for subgroup %3, on day %4, length=%5.")
					 .arg(this->activityTagName)
					 .arg(CustomFETString::number(this->maxHoursDaily))
					 .arg(r.internalSubgroupsList[i]->name)
					 .arg(r.daysOfTheWeek[d])
					 .arg(nd)
					 )
					 +
					 " "
					 +
					 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100.0)));
					
					dl.append(s);
					cl.append(weightPercentage/100);
				
					*conflictsString+= s+"\n";
				}
			}
		}
	}
	
	if(weightPercentage==100.0)
		assert(nbroken==0);
	return weightPercentage/100.0 * nbroken;
}

bool ConstraintStudentsActivityTagMaxHoursDaily::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsActivityTagMaxHoursDaily::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsActivityTagMaxHoursDaily::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsActivityTagMaxHoursDaily::isRelatedToActivityTag(const QString& s)
{
	return s==this->activityTagName;
}

bool ConstraintStudentsActivityTagMaxHoursDaily::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return true;
}

int ConstraintStudentsActivityTagMaxHoursDaily::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsActivityTagMaxHoursDaily::hasWrongDayOrHour(Rules& r)
{
	if(maxHoursDaily>r.nHoursPerDay)
		return true;
		
	return false;
}

bool ConstraintStudentsActivityTagMaxHoursDaily::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsActivityTagMaxHoursDaily::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxHoursDaily>r.nHoursPerDay)
		maxHoursDaily=r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsSetActivityTagMaxHoursDaily::ConstraintStudentsSetActivityTagMaxHoursDaily()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY;
	this->maxHoursDaily = -1;
}

ConstraintStudentsSetActivityTagMaxHoursDaily::ConstraintStudentsSetActivityTagMaxHoursDaily(double wp, int maxnh, const QString& s, const QString& activityTag)
	: TimeConstraint(wp)
{
	this->maxHoursDaily = maxnh;
	this->students = s;
	this->activityTagName=activityTag;
	this->type = CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY;
}

bool ConstraintStudentsSetActivityTagMaxHoursDaily::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsSetActivityTagMaxHoursDaily::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsSetActivityTagMaxHoursDaily>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Maximum_Hours_Daily>"+CustomFETString::number(this->maxHoursDaily)+"</Maximum_Hours_Daily>\n";
	s+=IL3+"<Students>"+protect(this->students)+"</Students>\n";
	s+=IL3+"<Activity_Tag>"+protect(this->activityTagName)+"</Activity_Tag>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsSetActivityTagMaxHoursDaily>\n";
	return s;
}

QString ConstraintStudentsSetActivityTagMaxHoursDaily::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Students set %1 for activity tag %2 has max %3 hours daily").arg(this->students).arg(this->activityTagName).arg(this->maxHoursDaily);
	s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintStudentsSetActivityTagMaxHoursDaily::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A students set, for an activity tag, must respect the maximum number of hours daily"); s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Students set=%1").arg(this->students);s+="\n";
	s+=tr("Activity tag=%1").arg(this->activityTagName);s+="\n";
	s+=tr("Maximum hours daily=%1").arg(this->maxHoursDaily);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

bool ConstraintStudentsSetActivityTagMaxHoursDaily::computeInternalStructure(QWidget* parent, Rules& r)
{
	//this->activityTagIndex=r.searchActivityTag(this->activityTagName);
	activityTagIndex=r.activityTagsHash.value(activityTagName, -1);
	assert(this->activityTagIndex>=0);

	//StudentsSet* ss=r.searchAugmentedStudentsSet(this->students);
	StudentsSet* ss=r.studentsHash.value(students, nullptr);
	
	if(ss==nullptr){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students set max hours daily is wrong because it refers to nonexistent students set."
		 " Please correct it (removing it might be a solution). Please report potential bug. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
		return false;
	}

	assert(ss!=nullptr);

	populateInternalSubgroupsList(r, ss, this->iSubgroupsList);
	/*this->iSubgroupsList.clear();
	if(ss->type==STUDENTS_SUBGROUP){
		int tmp;
		tmp=((StudentsSubgroup*)ss)->indexInInternalSubgroupsList;
		assert(tmp>=0);
		assert(tmp<r.nInternalSubgroups);
		if(!this->iSubgroupsList.contains(tmp))
			this->iSubgroupsList.append(tmp);
	}
	else if(ss->type==STUDENTS_GROUP){
		StudentsGroup* stg=(StudentsGroup*)ss;
		for(int i=0; i<stg->subgroupsList.size(); i++){
			StudentsSubgroup* sts=stg->subgroupsList[i];
			int tmp;
			tmp=sts->indexInInternalSubgroupsList;
			assert(tmp>=0);
			assert(tmp<r.nInternalSubgroups);
			if(!this->iSubgroupsList.contains(tmp))
				this->iSubgroupsList.append(tmp);
		}
	}
	else if(ss->type==STUDENTS_YEAR){
		StudentsYear* sty=(StudentsYear*)ss;
		for(int i=0; i<sty->groupsList.size(); i++){
			StudentsGroup* stg=sty->groupsList[i];
			for(int j=0; j<stg->subgroupsList.size(); j++){
				StudentsSubgroup* sts=stg->subgroupsList[j];
				int tmp;
				tmp=sts->indexInInternalSubgroupsList;
				assert(tmp>=0);
				assert(tmp<r.nInternalSubgroups);
				if(!this->iSubgroupsList.contains(tmp))
					this->iSubgroupsList.append(tmp);
			}
		}
	}
	else
		assert(0);*/
		
	/////////////
	this->canonicalSubgroupsList.clear();
	for(int i : std::as_const(this->iSubgroupsList)){
		bool found=false;
	
		StudentsSubgroup* sbg=r.internalSubgroupsList[i];
		for(int actIndex : std::as_const(sbg->activitiesForSubgroup)){
			if(r.internalActivitiesList[actIndex].iActivityTagsSet.contains(this->activityTagIndex)){
				found=true;
				break;
			}
		}
		
		if(found)
			this->canonicalSubgroupsList.append(i);
	}
		
	return true;
}

double ConstraintStudentsSetActivityTagMaxHoursDaily::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	nbroken=0;

	Matrix2D<int> crtSubgroupTimetableActivityTag;
	crtSubgroupTimetableActivityTag.resize(r.nDaysPerWeek, r.nHoursPerDay);
	
	for(int i : std::as_const(this->canonicalSubgroupsList)){
		StudentsSubgroup* sbg=r.internalSubgroupsList[i];
		for(int d=0; d<r.nDaysPerWeek; d++)
			for(int h=0; h<r.nHoursPerDay; h++)
				crtSubgroupTimetableActivityTag[d][h]=-1;
		for(int ai : std::as_const(sbg->activitiesForSubgroup)) if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek;
			int h=c.times[ai]/r.nDaysPerWeek;
			for(int dur=0; dur<r.internalActivitiesList[ai].duration; dur++){
				assert(h+dur<r.nHoursPerDay);
				assert(crtSubgroupTimetableActivityTag[d][h+dur]==-1);
				if(r.internalActivitiesList[ai].iActivityTagsSet.contains(this->activityTagIndex))
					crtSubgroupTimetableActivityTag[d][h+dur]=this->activityTagIndex;
			}
		}

		for(int d=0; d<r.nDaysPerWeek; d++){
			int nd=0;
			for(int h=0; h<r.nHoursPerDay; h++)
				if(crtSubgroupTimetableActivityTag[d][h]==this->activityTagIndex)
					nd++;
				
			if(nd>this->maxHoursDaily){
				nbroken++;

				if(conflictsString!=nullptr){
					QString s=(tr(
					 "Time constraint students set, activity tag %1, max %2 hours daily, broken for subgroup %3, on day %4, length=%5.")
					 .arg(this->activityTagName)
					 .arg(CustomFETString::number(this->maxHoursDaily))
					 .arg(r.internalSubgroupsList[i]->name)
					 .arg(r.daysOfTheWeek[d])
					 .arg(nd)
					 )
					 +
					 " "
					 +
					 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100.0)));
					
					dl.append(s);
					cl.append(weightPercentage/100);
				
					*conflictsString+= s+"\n";
				}
			}
		}
	}
	
	if(weightPercentage==100.0)
		assert(nbroken==0);
	return weightPercentage/100.0 * nbroken;
}

bool ConstraintStudentsSetActivityTagMaxHoursDaily::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsSetActivityTagMaxHoursDaily::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsSetActivityTagMaxHoursDaily::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetActivityTagMaxHoursDaily::isRelatedToActivityTag(const QString& s)
{
	return s==this->activityTagName;
}

bool ConstraintStudentsSetActivityTagMaxHoursDaily::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	return r.setsShareStudents(this->students, s);
}

int ConstraintStudentsSetActivityTagMaxHoursDaily::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsSetActivityTagMaxHoursDaily::hasWrongDayOrHour(Rules& r)
{
	if(maxHoursDaily>r.nHoursPerDay)
		return true;
		
	return false;
}

bool ConstraintStudentsSetActivityTagMaxHoursDaily::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsSetActivityTagMaxHoursDaily::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxHoursDaily>r.nHoursPerDay)
		maxHoursDaily=r.nHoursPerDay;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeachersActivityTagMinHoursDaily::ConstraintTeachersActivityTagMinHoursDaily()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHERS_ACTIVITY_TAG_MIN_HOURS_DAILY;
}

ConstraintTeachersActivityTagMinHoursDaily::ConstraintTeachersActivityTagMinHoursDaily(double wp, int minhours, int mindays, const QString& activityTag)
 : TimeConstraint(wp)
 {
	assert(minhours>0);
	this->minHoursDaily=minhours;
	this->minDaysWithTag=mindays;
	this->activityTagName=activityTag;

	this->type=CONSTRAINT_TEACHERS_ACTIVITY_TAG_MIN_HOURS_DAILY;
}

bool ConstraintTeachersActivityTagMinHoursDaily::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);

	//this->activityTagIndex=r.searchActivityTag(this->activityTagName);
	activityTagIndex=r.activityTagsHash.value(activityTagName, -1);
	assert(this->activityTagIndex>=0);
	
	this->canonicalTeachersList.clear();
	for(int i=0; i<r.nInternalTeachers; i++){
		bool found=false;
	
		Teacher* tch=r.internalTeachersList[i];
		for(int actIndex : std::as_const(tch->activitiesForTeacher)){
			if(r.internalActivitiesList[actIndex].iActivityTagsSet.contains(this->activityTagIndex)){
				found=true;
				break;
			}
		}
		
		if(found)
			this->canonicalTeachersList.append(i);
	}

	return true;
}

bool ConstraintTeachersActivityTagMinHoursDaily::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeachersActivityTagMinHoursDaily::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeachersActivityTagMinHoursDaily>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Activity_Tag>"+protect(this->activityTagName)+"</Activity_Tag>\n";
	s+=IL3+"<Minimum_Hours_Daily>"+CustomFETString::number(this->minHoursDaily)+"</Minimum_Hours_Daily>\n";
	s+=IL3+"<Minimum_Days_With_Tag>"+CustomFETString::number(this->minDaysWithTag)+"</Minimum_Days_With_Tag>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeachersActivityTagMinHoursDaily>\n";
	return s;
}

QString ConstraintTeachersActivityTagMinHoursDaily::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teachers for activity tag %1 have min %2 hours daily").arg(this->activityTagName).arg(this->minHoursDaily);s+=translatedCommaSpace();
	s+=tr("mDWT:%1", "Min days with tag").arg(this->minDaysWithTag);s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintTeachersActivityTagMinHoursDaily::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All teachers, for an activity tag, must respect the minimum number of hours daily");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Activity tag=%1").arg(this->activityTagName); s+="\n";
	s+=tr("Minimum hours daily=%1").arg(this->minHoursDaily); s+="\n";
	s+=tr("Minimum days with tag=%1").arg(this->minDaysWithTag);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeachersActivityTagMinHoursDaily::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;
	
	Matrix2D<int> crtTeacherTimetableActivityTag;
	crtTeacherTimetableActivityTag.resize(r.nDaysPerWeek, r.nHoursPerDay);

	nbroken=0;
	for(int i : std::as_const(this->canonicalTeachersList)){
		Teacher* tch=r.internalTeachersList[i];
		for(int d=0; d<r.nDaysPerWeek; d++)
			for(int h=0; h<r.nHoursPerDay; h++)
				crtTeacherTimetableActivityTag[d][h]=-1;
		
		for(int ai : std::as_const(tch->activitiesForTeacher)) if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek;
			int h=c.times[ai]/r.nDaysPerWeek;
			for(int dur=0; dur<r.internalActivitiesList[ai].duration; dur++){
				assert(h+dur<r.nHoursPerDay);
				assert(crtTeacherTimetableActivityTag[d][h+dur]==-1);
				if(r.internalActivitiesList[ai].iActivityTagsSet.contains(this->activityTagIndex))
					crtTeacherTimetableActivityTag[d][h+dur]=this->activityTagIndex;
			}
		}
		
		int nrd = r.nDaysPerWeek - this->minDaysWithTag;
		for(int d=0; d<r.nDaysPerWeek; d++){
			int nd=0;
			for(int h=0; h<r.nHoursPerDay; h++)
				if(crtTeacherTimetableActivityTag[d][h]==this->activityTagIndex)
					nd++;

			if(nd==0 && nrd>0){
				nrd--;
				continue;
			}
			if(nd<this->minHoursDaily){
				nbroken++;

				if(conflictsString!=nullptr){
					QString s=(tr("Time constraint teachers activity tag %1 min %2 hours daily broken for teacher %3, on day %4, length=%5.")
					 .arg(this->activityTagName)
					 .arg(CustomFETString::number(this->minHoursDaily))
					 .arg(r.internalTeachersList[i]->name)
					 .arg(r.daysOfTheWeek[d])
					 .arg(nd)
					 )
					 +
					 " "
					 +
					 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100.0)));
					
					dl.append(s);
					cl.append(weightPercentage/100.0);
				
					*conflictsString+= s+"\n";
				}
			}
		}
	}

	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100.0)
			assert(nbroken==0);
	return weightPercentage/100.0 * nbroken;
}

bool ConstraintTeachersActivityTagMinHoursDaily::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeachersActivityTagMinHoursDaily::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return true;
}

bool ConstraintTeachersActivityTagMinHoursDaily::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersActivityTagMinHoursDaily::isRelatedToActivityTag(const QString& s)
{
	return s==this->activityTagName;
}

bool ConstraintTeachersActivityTagMinHoursDaily::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeachersActivityTagMinHoursDaily::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeachersActivityTagMinHoursDaily::hasWrongDayOrHour(Rules& r)
{
	if(minHoursDaily>r.nHoursPerDay)
		return true;
	
	if(minDaysWithTag>r.nDaysPerWeek)
		return true;
	
	return false;
}

bool ConstraintTeachersActivityTagMinHoursDaily::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeachersActivityTagMinHoursDaily::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(minHoursDaily>r.nHoursPerDay)
		minHoursDaily=r.nHoursPerDay;
	
	if(minDaysWithTag>r.nDaysPerWeek)
		minDaysWithTag=r.nDaysPerWeek;
	
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeacherActivityTagMinHoursDaily::ConstraintTeacherActivityTagMinHoursDaily()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHER_ACTIVITY_TAG_MIN_HOURS_DAILY;
}

ConstraintTeacherActivityTagMinHoursDaily::ConstraintTeacherActivityTagMinHoursDaily(double wp, int minhours, int mindays, const QString& teacher, const QString& activityTag)
 : TimeConstraint(wp)
 {
	assert(minhours>0);
	this->minHoursDaily=minhours;
	this->minDaysWithTag=mindays;
	this->teacherName=teacher;
	this->activityTagName=activityTag;

	this->type=CONSTRAINT_TEACHER_ACTIVITY_TAG_MIN_HOURS_DAILY;
}

bool ConstraintTeacherActivityTagMinHoursDaily::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);

	//this->teacher_ID=r.searchTeacher(this->teacherName);
	teacher_ID=r.teachersHash.value(teacherName, -1);
	assert(this->teacher_ID>=0);

	//this->activityTagIndex=r.searchActivityTag(this->activityTagName);
	activityTagIndex=r.activityTagsHash.value(activityTagName, -1);
	assert(this->activityTagIndex>=0);

	this->canonicalTeachersList.clear();
	int i=this->teacher_ID;
	bool found=false;
	
	Teacher* tch=r.internalTeachersList[i];
	for(int actIndex : std::as_const(tch->activitiesForTeacher)){
		if(r.internalActivitiesList[actIndex].iActivityTagsSet.contains(this->activityTagIndex)){
			found=true;
			break;
		}
	}
		
	if(found)
		this->canonicalTeachersList.append(i);

	return true;
}

bool ConstraintTeacherActivityTagMinHoursDaily::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeacherActivityTagMinHoursDaily::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeacherActivityTagMinHoursDaily>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Teacher>"+protect(this->teacherName)+"</Teacher>\n";
	s+=IL3+"<Activity_Tag>"+protect(this->activityTagName)+"</Activity_Tag>\n";
	s+=IL3+"<Minimum_Hours_Daily>"+CustomFETString::number(this->minHoursDaily)+"</Minimum_Hours_Daily>\n";
	s+=IL3+"<Minimum_Days_With_Tag>"+CustomFETString::number(this->minDaysWithTag)+"</Minimum_Days_With_Tag>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeacherActivityTagMinHoursDaily>\n";
	return s;
}

QString ConstraintTeacherActivityTagMinHoursDaily::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teacher %1 for activity tag %2 has min %3 hours daily").arg(this->teacherName).arg(this->activityTagName).arg(this->minHoursDaily);s+=translatedCommaSpace();
	s+=tr("mDWT:%1", "Min days with tag").arg(this->minDaysWithTag);s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintTeacherActivityTagMinHoursDaily::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A teacher for an activity tag must respect the minimum number of hours daily");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Teacher=%1").arg(this->teacherName);s+="\n";
	s+=tr("Activity tag=%1").arg(this->activityTagName);s+="\n";
	s+=tr("Minimum hours daily=%1").arg(this->minHoursDaily); s+="\n";
	s+=tr("Minimum days with tag=%1").arg(this->minDaysWithTag);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeacherActivityTagMinHoursDaily::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	Matrix2D<int> crtTeacherTimetableActivityTag;
	crtTeacherTimetableActivityTag.resize(r.nDaysPerWeek, r.nHoursPerDay);

	nbroken=0;
	for(int i : std::as_const(this->canonicalTeachersList)){
		Teacher* tch=r.internalTeachersList[i];
		for(int d=0; d<r.nDaysPerWeek; d++)
			for(int h=0; h<r.nHoursPerDay; h++)
				crtTeacherTimetableActivityTag[d][h]=-1;
				
		for(int ai : std::as_const(tch->activitiesForTeacher)) if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek;
			int h=c.times[ai]/r.nDaysPerWeek;
			for(int dur=0; dur<r.internalActivitiesList[ai].duration; dur++){
				assert(h+dur<r.nHoursPerDay);
				assert(crtTeacherTimetableActivityTag[d][h+dur]==-1);
				if(r.internalActivitiesList[ai].iActivityTagsSet.contains(this->activityTagIndex))
					crtTeacherTimetableActivityTag[d][h+dur]=this->activityTagIndex;
			}
		}
	
		int nrd = r.nDaysPerWeek - this->minDaysWithTag;
		for(int d=0; d<r.nDaysPerWeek; d++){
			int nd=0;
			for(int h=0; h<r.nHoursPerDay; h++)
				if(crtTeacherTimetableActivityTag[d][h]==this->activityTagIndex)
					nd++;

			if(nd==0 && nrd>0){
				nrd--;
				continue;
			}
			if(nd<this->minHoursDaily){
				nbroken++;

				if(conflictsString!=nullptr){
					QString s=(tr("Time constraint teacher activity tag %1 min %2 hours daily broken for teacher %3, on day %4, length=%5.")
					 .arg(this->activityTagName)
					 .arg(CustomFETString::number(this->minHoursDaily))
					 .arg(r.internalTeachersList[i]->name)
					 .arg(r.daysOfTheWeek[d])
					 .arg(nd)
					 )
					 +
					 " "
					 +
					 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100.0)));
					
					dl.append(s);
					cl.append(weightPercentage/100.0);
				
					*conflictsString+= s+"\n";
				}
			}
		}
	}

	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100.0)
			assert(nbroken==0);
	return weightPercentage/100.0 * nbroken;
}

bool ConstraintTeacherActivityTagMinHoursDaily::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeacherActivityTagMinHoursDaily::isRelatedToTeacher(const QString& t)
{
	if(this->teacherName==t)
		return true;
	return false;
}

bool ConstraintTeacherActivityTagMinHoursDaily::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherActivityTagMinHoursDaily::isRelatedToActivityTag(const QString& s)
{
	return this->activityTagName==s;
}

bool ConstraintTeacherActivityTagMinHoursDaily::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeacherActivityTagMinHoursDaily::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeacherActivityTagMinHoursDaily::hasWrongDayOrHour(Rules& r)
{
	if(minHoursDaily>r.nHoursPerDay)
		return true;

	if(minDaysWithTag>r.nDaysPerWeek)
		return true;

	return false;
}

bool ConstraintTeacherActivityTagMinHoursDaily::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeacherActivityTagMinHoursDaily::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(minHoursDaily>r.nHoursPerDay)
		minHoursDaily=r.nHoursPerDay;

	if(minDaysWithTag>r.nDaysPerWeek)
		minDaysWithTag=r.nDaysPerWeek;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsActivityTagMinHoursDaily::ConstraintStudentsActivityTagMinHoursDaily()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_ACTIVITY_TAG_MIN_HOURS_DAILY;
	this->minHoursDaily = -1;
}

ConstraintStudentsActivityTagMinHoursDaily::ConstraintStudentsActivityTagMinHoursDaily(double wp, int minnh, int mindays, const QString& activityTag)
	: TimeConstraint(wp)
{
	this->minHoursDaily = minnh;
	this->minDaysWithTag=mindays;
	this->activityTagName=activityTag;
	this->type = CONSTRAINT_STUDENTS_ACTIVITY_TAG_MIN_HOURS_DAILY;
}

bool ConstraintStudentsActivityTagMinHoursDaily::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);

	//this->activityTagIndex=r.searchActivityTag(this->activityTagName);
	activityTagIndex=r.activityTagsHash.value(activityTagName, -1);
	assert(this->activityTagIndex>=0);
	
	this->canonicalSubgroupsList.clear();
	for(int i=0; i<r.nInternalSubgroups; i++){
		bool found=false;
	
		StudentsSubgroup* sbg=r.internalSubgroupsList[i];
		for(int actIndex : std::as_const(sbg->activitiesForSubgroup)){
			if(r.internalActivitiesList[actIndex].iActivityTagsSet.contains(this->activityTagIndex)){
				found=true;
				break;
			}
		}
		
		if(found)
			this->canonicalSubgroupsList.append(i);
	}

	return true;
}

bool ConstraintStudentsActivityTagMinHoursDaily::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsActivityTagMinHoursDaily::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsActivityTagMinHoursDaily>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	
	s+=IL3+"<Activity_Tag>"+protect(this->activityTagName)+"</Activity_Tag>\n";
	
	if(this->minHoursDaily>=0)
		s+=IL3+"<Minimum_Hours_Daily>"+CustomFETString::number(this->minHoursDaily)+"</Minimum_Hours_Daily>\n";
	else
		assert(0);

	s+=IL3+"<Minimum_Days_With_Tag>"+CustomFETString::number(this->minDaysWithTag)+"</Minimum_Days_With_Tag>\n";

	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsActivityTagMinHoursDaily>\n";
	return s;
}

QString ConstraintStudentsActivityTagMinHoursDaily::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Students for activity tag %1 have min %2 hours daily")
		.arg(this->activityTagName).arg(this->minHoursDaily); s+=translatedCommaSpace();
	s+=tr("mDWT:%1", "Min days with tag").arg(this->minDaysWithTag);s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintStudentsActivityTagMinHoursDaily::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All students, for an activity tag, must respect the minimum number of hours daily"); s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Activity tag=%1").arg(this->activityTagName);s+="\n";
	s+=tr("Minimum hours daily=%1").arg(this->minHoursDaily);s+="\n";
	s+=tr("Minimum days with tag=%1").arg(this->minDaysWithTag);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintStudentsActivityTagMinHoursDaily::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	int nbroken;

	nbroken=0;

	Matrix2D<int> crtSubgroupTimetableActivityTag;
	crtSubgroupTimetableActivityTag.resize(r.nDaysPerWeek, r.nHoursPerDay);
	
	for(int i : std::as_const(this->canonicalSubgroupsList)){
		StudentsSubgroup* sbg=r.internalSubgroupsList[i];
		for(int d=0; d<r.nDaysPerWeek; d++)
			for(int h=0; h<r.nHoursPerDay; h++)
				crtSubgroupTimetableActivityTag[d][h]=-1;
		for(int ai : std::as_const(sbg->activitiesForSubgroup)) if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek;
			int h=c.times[ai]/r.nDaysPerWeek;
			for(int dur=0; dur<r.internalActivitiesList[ai].duration; dur++){
				assert(h+dur<r.nHoursPerDay);
				assert(crtSubgroupTimetableActivityTag[d][h+dur]==-1);
				if(r.internalActivitiesList[ai].iActivityTagsSet.contains(this->activityTagIndex))
					crtSubgroupTimetableActivityTag[d][h+dur]=this->activityTagIndex;
			}
		}

		int nrd = r.nDaysPerWeek - this->minDaysWithTag;
		for(int d=0; d<r.nDaysPerWeek; d++){
			int nd=0;
			for(int h=0; h<r.nHoursPerDay; h++)
				if(crtSubgroupTimetableActivityTag[d][h]==this->activityTagIndex)
					nd++;
				
			if(nd==0 && nrd>0){
				nrd--;
				continue;
			}
			if(nd<this->minHoursDaily){
				nbroken++;

				if(conflictsString!=nullptr){
					QString s=(tr(
					 "Time constraint students, activity tag %1, min %2 hours daily, broken for subgroup %3, on day %4, length=%5.")
					 .arg(this->activityTagName)
					 .arg(CustomFETString::number(this->minHoursDaily))
					 .arg(r.internalSubgroupsList[i]->name)
					 .arg(r.daysOfTheWeek[d])
					 .arg(nd)
					 )
					 +
					 " "
					 +
					 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100.0)));
					
					dl.append(s);
					cl.append(weightPercentage/100);
				
					*conflictsString+= s+"\n";
				}
			}
		}
	}
	
	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100.0)
			assert(nbroken==0);
	return weightPercentage/100.0 * nbroken;
}

bool ConstraintStudentsActivityTagMinHoursDaily::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsActivityTagMinHoursDaily::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsActivityTagMinHoursDaily::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsActivityTagMinHoursDaily::isRelatedToActivityTag(const QString& s)
{
	return s==this->activityTagName;
}

bool ConstraintStudentsActivityTagMinHoursDaily::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return true;
}

int ConstraintStudentsActivityTagMinHoursDaily::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsActivityTagMinHoursDaily::hasWrongDayOrHour(Rules& r)
{
	if(minHoursDaily>r.nHoursPerDay)
		return true;
	
	if(minDaysWithTag>r.nDaysPerWeek)
		return true;
	
	return false;
}

bool ConstraintStudentsActivityTagMinHoursDaily::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsActivityTagMinHoursDaily::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(minHoursDaily>r.nHoursPerDay)
		minHoursDaily=r.nHoursPerDay;

	if(minDaysWithTag>r.nDaysPerWeek)
		minDaysWithTag=r.nDaysPerWeek;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsSetActivityTagMinHoursDaily::ConstraintStudentsSetActivityTagMinHoursDaily()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MIN_HOURS_DAILY;
	this->minHoursDaily = -1;
}

ConstraintStudentsSetActivityTagMinHoursDaily::ConstraintStudentsSetActivityTagMinHoursDaily(double wp, int minnh, int mindays, const QString& s, const QString& activityTag)
	: TimeConstraint(wp)
{
	this->minHoursDaily = minnh;
	this->minDaysWithTag=mindays;
	this->students = s;
	this->activityTagName=activityTag;
	this->type = CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MIN_HOURS_DAILY;
}

bool ConstraintStudentsSetActivityTagMinHoursDaily::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsSetActivityTagMinHoursDaily::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsSetActivityTagMinHoursDaily>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Students>"+protect(this->students)+"</Students>\n";
	s+=IL3+"<Activity_Tag>"+protect(this->activityTagName)+"</Activity_Tag>\n";
	s+=IL3+"<Minimum_Hours_Daily>"+CustomFETString::number(this->minHoursDaily)+"</Minimum_Hours_Daily>\n";
	s+=IL3+"<Minimum_Days_With_Tag>"+CustomFETString::number(this->minDaysWithTag)+"</Minimum_Days_With_Tag>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsSetActivityTagMinHoursDaily>\n";
	return s;
}

QString ConstraintStudentsSetActivityTagMinHoursDaily::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Students set %1 for activity tag %2 has min %3 hours daily").arg(this->students).arg(this->activityTagName).arg(this->minHoursDaily);
	s+=translatedCommaSpace();
	s+=tr("mDWT:%1", "Min days with tag").arg(this->minDaysWithTag);
	s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));

	return begin+s+end;
}

QString ConstraintStudentsSetActivityTagMinHoursDaily::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A students set, for an activity tag, must respect the minimum number of hours daily"); s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Students set=%1").arg(this->students);s+="\n";
	s+=tr("Activity tag=%1").arg(this->activityTagName);s+="\n";
	s+=tr("Minimum hours daily=%1").arg(this->minHoursDaily);s+="\n";
	s+=tr("Minimum days with tag=%1").arg(this->minDaysWithTag);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

bool ConstraintStudentsSetActivityTagMinHoursDaily::computeInternalStructure(QWidget* parent, Rules& r)
{
	//this->activityTagIndex=r.searchActivityTag(this->activityTagName);
	activityTagIndex=r.activityTagsHash.value(activityTagName, -1);
	assert(this->activityTagIndex>=0);

	//StudentsSet* ss=r.searchAugmentedStudentsSet(this->students);
	StudentsSet* ss=r.studentsHash.value(students, nullptr);
	
	if(ss==nullptr){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students set min hours daily is wrong because it refers to nonexistent students set."
		 " Please correct it (removing it might be a solution). Please report potential bug. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
		return false;
	}

	assert(ss!=nullptr);

	populateInternalSubgroupsList(r, ss, this->iSubgroupsList);
	/*this->iSubgroupsList.clear();
	if(ss->type==STUDENTS_SUBGROUP){
		int tmp;
		tmp=((StudentsSubgroup*)ss)->indexInInternalSubgroupsList;
		assert(tmp>=0);
		assert(tmp<r.nInternalSubgroups);
		if(!this->iSubgroupsList.contains(tmp))
			this->iSubgroupsList.append(tmp);
	}
	else if(ss->type==STUDENTS_GROUP){
		StudentsGroup* stg=(StudentsGroup*)ss;
		for(int i=0; i<stg->subgroupsList.size(); i++){
			StudentsSubgroup* sts=stg->subgroupsList[i];
			int tmp;
			tmp=sts->indexInInternalSubgroupsList;
			assert(tmp>=0);
			assert(tmp<r.nInternalSubgroups);
			if(!this->iSubgroupsList.contains(tmp))
				this->iSubgroupsList.append(tmp);
		}
	}
	else if(ss->type==STUDENTS_YEAR){
		StudentsYear* sty=(StudentsYear*)ss;
		for(int i=0; i<sty->groupsList.size(); i++){
			StudentsGroup* stg=sty->groupsList[i];
			for(int j=0; j<stg->subgroupsList.size(); j++){
				StudentsSubgroup* sts=stg->subgroupsList[j];
				int tmp;
				tmp=sts->indexInInternalSubgroupsList;
				assert(tmp>=0);
				assert(tmp<r.nInternalSubgroups);
				if(!this->iSubgroupsList.contains(tmp))
					this->iSubgroupsList.append(tmp);
			}
		}
	}
	else
		assert(0);*/
		
	/////////////
	this->canonicalSubgroupsList.clear();
	for(int i : std::as_const(this->iSubgroupsList)){
		bool found=false;
	
		StudentsSubgroup* sbg=r.internalSubgroupsList[i];
		for(int actIndex : std::as_const(sbg->activitiesForSubgroup)){
			if(r.internalActivitiesList[actIndex].iActivityTagsSet.contains(this->activityTagIndex)){
				found=true;
				break;
			}
		}
		
		if(found)
			this->canonicalSubgroupsList.append(i);
	}
		
	return true;
}

double ConstraintStudentsSetActivityTagMinHoursDaily::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	Matrix2D<int> crtSubgroupTimetableActivityTag;
	crtSubgroupTimetableActivityTag.resize(r.nDaysPerWeek, r.nHoursPerDay);

	nbroken=0;
	
	for(int i : std::as_const(this->canonicalSubgroupsList)){
		StudentsSubgroup* sbg=r.internalSubgroupsList[i];
		for(int d=0; d<r.nDaysPerWeek; d++)
			for(int h=0; h<r.nHoursPerDay; h++)
				crtSubgroupTimetableActivityTag[d][h]=-1;
		for(int ai : std::as_const(sbg->activitiesForSubgroup)) if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek;
			int h=c.times[ai]/r.nDaysPerWeek;
			for(int dur=0; dur<r.internalActivitiesList[ai].duration; dur++){
				assert(h+dur<r.nHoursPerDay);
				assert(crtSubgroupTimetableActivityTag[d][h+dur]==-1);
				if(r.internalActivitiesList[ai].iActivityTagsSet.contains(this->activityTagIndex))
					crtSubgroupTimetableActivityTag[d][h+dur]=this->activityTagIndex;
			}
		}

		int nrd = r.nDaysPerWeek - this->minDaysWithTag;
		for(int d=0; d<r.nDaysPerWeek; d++){
			int nd=0;
			for(int h=0; h<r.nHoursPerDay; h++)
				if(crtSubgroupTimetableActivityTag[d][h]==this->activityTagIndex)
					nd++;
				
			if(nd==0 && nrd>0){
				nrd--;
				continue;
			}
			if(nd<this->minHoursDaily){
				nbroken++;

				if(conflictsString!=nullptr){
					QString s=(tr(
					 "Time constraint students set, activity tag %1, min %2 hours daily, broken for subgroup %3, on day %4, length=%5.")
					 .arg(this->activityTagName)
					 .arg(CustomFETString::number(this->minHoursDaily))
					 .arg(r.internalSubgroupsList[i]->name)
					 .arg(r.daysOfTheWeek[d])
					 .arg(nd)
					 )
					 +
					 " "
					 +
					 (tr("This increases the conflicts total by %1").arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100.0)));
					
					dl.append(s);
					cl.append(weightPercentage/100);
				
					*conflictsString+= s+"\n";
				}
			}
		}
	}
	
	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100.0)
			assert(nbroken==0);
	return weightPercentage/100.0 * nbroken;
}

bool ConstraintStudentsSetActivityTagMinHoursDaily::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsSetActivityTagMinHoursDaily::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsSetActivityTagMinHoursDaily::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetActivityTagMinHoursDaily::isRelatedToActivityTag(const QString& s)
{
	return s==this->activityTagName;
}

bool ConstraintStudentsSetActivityTagMinHoursDaily::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	return r.setsShareStudents(this->students, s);
}

int ConstraintStudentsSetActivityTagMinHoursDaily::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsSetActivityTagMinHoursDaily::hasWrongDayOrHour(Rules& r)
{
	if(minHoursDaily>r.nHoursPerDay)
		return true;
	
	if(minDaysWithTag>r.nDaysPerWeek)
		return true;
	
	return false;
}

bool ConstraintStudentsSetActivityTagMinHoursDaily::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsSetActivityTagMinHoursDaily::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(minHoursDaily>r.nHoursPerDay)
		minHoursDaily=r.nHoursPerDay;

	if(minDaysWithTag>r.nDaysPerWeek)
		minDaysWithTag=r.nDaysPerWeek;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsMaxGapsPerDay::ConstraintStudentsMaxGapsPerDay()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_MAX_GAPS_PER_DAY;
}

ConstraintStudentsMaxGapsPerDay::ConstraintStudentsMaxGapsPerDay(double wp, int mg)
	: TimeConstraint(wp)
{
	this->type = CONSTRAINT_STUDENTS_MAX_GAPS_PER_DAY;
	this->maxGaps=mg;
}

bool ConstraintStudentsMaxGapsPerDay::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);
	Q_UNUSED(r);

	return true;
}

bool ConstraintStudentsMaxGapsPerDay::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsMaxGapsPerDay::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsMaxGapsPerDay>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Max_Gaps>"+CustomFETString::number(this->maxGaps)+"</Max_Gaps>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsMaxGapsPerDay>\n";
	return s;
}

QString ConstraintStudentsMaxGapsPerDay::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Students max gaps per day");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("MG:%1", "Max gaps (per day)").arg(this->maxGaps);

	return begin+s+end;
}

QString ConstraintStudentsMaxGapsPerDay::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All students must respect the maximum number of gaps per day");s+="\n";
	s+=tr("(breaks and students set not available not counted)");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Maximum gaps per day=%1").arg(this->maxGaps);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintStudentsMaxGapsPerDay::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//returns a number equal to the number of gaps of the subgroups (in hours)

	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	int nGaps;
	int tmp;
	int i;
	
	int tIllegalGaps=0;

	for(i=0; i<r.nInternalSubgroups; i++){
		for(int j=0; j<r.nDaysPerWeek; j++){
			nGaps=0;
	
			int k;
			tmp=0;
			for(k=0; k<r.nHoursPerDay; k++)
				if(subgroupsMatrix[i][j][k]>0){
					assert(!breakDayHour[j][k] && !subgroupNotAvailableDayHour[i][j][k]);
					break;
				}
			for(; k<r.nHoursPerDay; k++) if(!breakDayHour[j][k] && !subgroupNotAvailableDayHour[i][j][k]){
				if(subgroupsMatrix[i][j][k]>0){
					nGaps+=tmp;
					tmp=0;
				}
				else
					tmp++;
			}
		
			int illegalGaps=nGaps-this->maxGaps;
			if(illegalGaps<0)
				illegalGaps=0;

			if(illegalGaps>0 && conflictsString!=nullptr){
				QString s=tr("Time constraint students max gaps per day broken for subgroup: %1, it has %2 extra gaps, on day %3, conflicts increase=%4")
				 .arg(r.internalSubgroupsList[i]->name)
				 .arg(illegalGaps)
				 .arg(r.daysOfTheWeek[j])
				 .arg(CustomFETString::numberPlusTwoDigitsPrecision(illegalGaps*weightPercentage/100));
				
				dl.append(s);
				cl.append(illegalGaps*weightPercentage/100);
				
				*conflictsString+= s+"\n";
			}
		
			tIllegalGaps+=illegalGaps;
		}
	}
	
	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100)    //for partial solutions it might be broken
			assert(tIllegalGaps==0);
	return weightPercentage/100 * tIllegalGaps;
}

bool ConstraintStudentsMaxGapsPerDay::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsMaxGapsPerDay::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsMaxGapsPerDay::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsMaxGapsPerDay::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsMaxGapsPerDay::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return true;
}

int ConstraintStudentsMaxGapsPerDay::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsMaxGapsPerDay::hasWrongDayOrHour(Rules& r)
{
	if(maxGaps>r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintStudentsMaxGapsPerDay::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsMaxGapsPerDay::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxGaps>r.nHoursPerDay)
		maxGaps=r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsSetMaxGapsPerDay::ConstraintStudentsSetMaxGapsPerDay()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_DAY;
}

ConstraintStudentsSetMaxGapsPerDay::ConstraintStudentsSetMaxGapsPerDay(double wp, int mg, const QString& st )
	: TimeConstraint(wp)
{
	this->type = CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_DAY;
	this->maxGaps=mg;
	this->students = st;
}

bool ConstraintStudentsSetMaxGapsPerDay::computeInternalStructure(QWidget* parent, Rules& r){
	//StudentsSet* ss=r.searchAugmentedStudentsSet(this->students);
	StudentsSet* ss=r.studentsHash.value(students, nullptr);

	if(ss==nullptr){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students set max gaps per day is wrong because it refers to nonexistent students set."
		 " Please correct it (removing it might be a solution). Please report potential bug. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
		return false;
	}

	assert(ss!=nullptr);

	populateInternalSubgroupsList(r, ss, this->iSubgroupsList);
	/*this->iSubgroupsList.clear();
	if(ss->type==STUDENTS_SUBGROUP){
		int tmp;
		tmp=((StudentsSubgroup*)ss)->indexInInternalSubgroupsList;
		assert(tmp>=0);
		assert(tmp<r.nInternalSubgroups);
		if(!this->iSubgroupsList.contains(tmp))
			this->iSubgroupsList.append(tmp);
	}
	else if(ss->type==STUDENTS_GROUP){
		StudentsGroup* stg=(StudentsGroup*)ss;
		for(int i=0; i<stg->subgroupsList.size(); i++){
			StudentsSubgroup* sts=stg->subgroupsList[i];
			int tmp;
			tmp=sts->indexInInternalSubgroupsList;
			assert(tmp>=0);
			assert(tmp<r.nInternalSubgroups);
			if(!this->iSubgroupsList.contains(tmp))
				this->iSubgroupsList.append(tmp);
		}
	}
	else if(ss->type==STUDENTS_YEAR){
		StudentsYear* sty=(StudentsYear*)ss;
		for(int i=0; i<sty->groupsList.size(); i++){
			StudentsGroup* stg=sty->groupsList[i];
			for(int j=0; j<stg->subgroupsList.size(); j++){
				StudentsSubgroup* sts=stg->subgroupsList[j];
				int tmp;
				tmp=sts->indexInInternalSubgroupsList;
				assert(tmp>=0);
				assert(tmp<r.nInternalSubgroups);
				if(!this->iSubgroupsList.contains(tmp))
					this->iSubgroupsList.append(tmp);
			}
		}
	}
	else
		assert(0);*/
		
	return true;
}

bool ConstraintStudentsSetMaxGapsPerDay::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsSetMaxGapsPerDay::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsSetMaxGapsPerDay>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Max_Gaps>"+CustomFETString::number(this->maxGaps)+"</Max_Gaps>\n";
	s+=IL3+"<Students>"+protect(this->students)+"</Students>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsSetMaxGapsPerDay>\n";
	return s;
}

QString ConstraintStudentsSetMaxGapsPerDay::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Students set max gaps per day"); s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage)); s+=translatedCommaSpace();
	s+=tr("MG:%1", "Max gaps (per day)").arg(this->maxGaps);s+=translatedCommaSpace();
	s+=tr("St:%1", "Students").arg(this->students);

	return begin+s+end;
}

QString ConstraintStudentsSetMaxGapsPerDay::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A students set must respect the maximum number of gaps per day");s+="\n";
	s+=tr("(breaks and students set not available not counted)");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Maximum gaps per day=%1").arg(this->maxGaps);s+="\n";
	s+=tr("Students=%1").arg(this->students); s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}
	
	return richText?protect4(s):s;
}

double ConstraintStudentsSetMaxGapsPerDay::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//OLD COMMENT
	//returns a number equal to the number of gaps of the subgroups (in hours)

	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	int nGaps;
	int tmp;
	
	int tIllegalGaps=0;
	
	for(int sg=0; sg<this->iSubgroupsList.count(); sg++){
		int i=this->iSubgroupsList.at(sg);
		for(int j=0; j<r.nDaysPerWeek; j++){
			nGaps=0;
	
			int k;
			tmp=0;
			for(k=0; k<r.nHoursPerDay; k++)
				if(subgroupsMatrix[i][j][k]>0){
					assert(!breakDayHour[j][k] && !subgroupNotAvailableDayHour[i][j][k]);
					break;
				}
			for(; k<r.nHoursPerDay; k++) if(!breakDayHour[j][k] && !subgroupNotAvailableDayHour[i][j][k]){
				if(subgroupsMatrix[i][j][k]>0){
					nGaps+=tmp;
					tmp=0;
				}
				else
					tmp++;
			}
		
			int illegalGaps=nGaps-this->maxGaps;
			if(illegalGaps<0)
				illegalGaps=0;

			if(illegalGaps>0 && conflictsString!=nullptr){
				QString s=tr("Time constraint students set max gaps per day broken for subgroup: %1, extra gaps=%2, on day %3, conflicts increase=%4")
				 .arg(r.internalSubgroupsList[i]->name)
				 .arg(illegalGaps)
				 .arg(r.daysOfTheWeek[j])
				 .arg(CustomFETString::numberPlusTwoDigitsPrecision(weightPercentage/100*illegalGaps));
				
				dl.append(s);
				cl.append(weightPercentage/100*illegalGaps);
				
				*conflictsString+= s+"\n";
			}
		
			tIllegalGaps+=illegalGaps;
		}
	}

	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100)     //for partial solutions it might be broken
			assert(tIllegalGaps==0);
	return weightPercentage/100 * tIllegalGaps;
}

bool ConstraintStudentsSetMaxGapsPerDay::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsSetMaxGapsPerDay::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsSetMaxGapsPerDay::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetMaxGapsPerDay::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetMaxGapsPerDay::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	return r.setsShareStudents(this->students, s);
}

int ConstraintStudentsSetMaxGapsPerDay::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsSetMaxGapsPerDay::hasWrongDayOrHour(Rules& r)
{
	if(maxGaps>r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintStudentsSetMaxGapsPerDay::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsSetMaxGapsPerDay::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxGaps>r.nHoursPerDay)
		maxGaps=r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivitiesOccupyMaxTimeSlotsFromSelection::ConstraintActivitiesOccupyMaxTimeSlotsFromSelection()
	: TimeConstraint()
{
	this->type = CONSTRAINT_ACTIVITIES_OCCUPY_MAX_TIME_SLOTS_FROM_SELECTION;
}

ConstraintActivitiesOccupyMaxTimeSlotsFromSelection::ConstraintActivitiesOccupyMaxTimeSlotsFromSelection(double wp,
	const QList<int>& a_L, const QList<int>& d_L, const QList<int>& h_L, int max_slots)
	: TimeConstraint(wp)
{
	assert(d_L.count()==h_L.count());

	this->activitiesIds=a_L;
	this->selectedDays=d_L;
	this->selectedHours=h_L;
	this->maxOccupiedTimeSlots=max_slots;
	
	this->type=CONSTRAINT_ACTIVITIES_OCCUPY_MAX_TIME_SLOTS_FROM_SELECTION;
}

bool ConstraintActivitiesOccupyMaxTimeSlotsFromSelection::computeInternalStructure(QWidget* parent, Rules& r)
{
	//this cares about inactive activities, also, so do not assert this->_actIndices.count()==this->actIds.count()
	_activitiesIndices.clear();
	for(int id : std::as_const(activitiesIds)){
		int i=r.activitiesHash.value(id, -1);
		if(i>=0)
			_activitiesIndices.append(i);
	}

	/*this->_activitiesIndices.clear();
	
	QSet<int> req=this->activitiesIds.toSet();
	assert(req.count()==this->activitiesIds.count());
	
	//this cares about inactive activities, also, so do not assert this->_actIndices.count()==this->actIds.count()
	int i;
	for(i=0; i<r.nInternalActivities; i++)
		if(req.contains(r.internalActivitiesList[i].id))
			this->_activitiesIndices.append(i);*/
			
	//////////////////////
	assert(this->selectedDays.count()==this->selectedHours.count());
	
	for(int k=0; k<this->selectedDays.count(); k++){
		if(this->selectedDays.at(k) >= r.nDaysPerWeek){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities occupy max time slots from selection is wrong because it refers to removed day. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->selectedHours.at(k) == r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities occupy max time slots from selection is wrong because an hour is too late (after the last acceptable slot). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->selectedHours.at(k) > r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities occupy max time slots from selection is wrong because it refers to removed hour. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->selectedDays.at(k)<0 || this->selectedHours.at(k)<0){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities occupy max time slots from selection is wrong because hour or day is not specified for a slot (-1). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
	}
	///////////////////////
	
	if(this->_activitiesIndices.count()>0)
		return true;
	else{
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to no activities). Please correct it:\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}
}

bool ConstraintActivitiesOccupyMaxTimeSlotsFromSelection::hasInactiveActivities(Rules& r)
{
	//returns true if all activities are inactive
	
	for(int aid : std::as_const(this->activitiesIds))
		if(!r.inactiveActivities.contains(aid))
			return false;

	return true;
}

QString ConstraintActivitiesOccupyMaxTimeSlotsFromSelection::getXmlDescription(Rules& r)
{
	assert(this->selectedDays.count()==this->selectedHours.count());

	QString s=IL2+"<ConstraintActivitiesOccupyMaxTimeSlotsFromSelection>\n";
	
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	
	s+=IL3+"<Number_of_Activities>"+QString::number(this->activitiesIds.count())+"</Number_of_Activities>\n";
	for(int aid : std::as_const(this->activitiesIds))
		s+=IL3+"<Activity_Id>"+CustomFETString::number(aid)+"</Activity_Id>\n";
	
	s+=IL3+"<Number_of_Selected_Time_Slots>"+QString::number(this->selectedDays.count())+"</Number_of_Selected_Time_Slots>\n";
	for(int i=0; i<this->selectedDays.count(); i++){
		s+=IL3+"<Selected_Time_Slot>\n";
		s+=IL4+"<Day>"+protect(r.daysOfTheWeek[this->selectedDays.at(i)])+"</Day>\n";
		s+=IL4+"<Hour>"+protect(r.hoursOfTheDay[this->selectedHours.at(i)])+"</Hour>\n";
		s+=IL3+"</Selected_Time_Slot>\n";
	}
	s+=IL3+"<Max_Number_of_Occupied_Time_Slots>"+CustomFETString::number(this->maxOccupiedTimeSlots)+"</Max_Number_of_Occupied_Time_Slots>\n";
	
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivitiesOccupyMaxTimeSlotsFromSelection>\n";
	return s;
}

QString ConstraintActivitiesOccupyMaxTimeSlotsFromSelection::getDescription(Rules& r)
{
	QString begin=QString("");
	if(!active)
		begin="X - ";
	
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
	
	assert(this->selectedDays.count()==this->selectedHours.count());

	QString actids=QString("");
	for(int aid : std::as_const(this->activitiesIds))
		actids+=getActivityDescription(r, aid)+translatedCommaSpace();
	actids.chop(translatedCommaSpace().size());
	
	QString timeslots=QString("");
	for(int i=0; i<this->selectedDays.count(); i++)
		timeslots+=r.daysOfTheWeek[selectedDays.at(i)]+QString(" ")+r.hoursOfTheDay[selectedHours.at(i)]+translatedCommaSpace();
	timeslots.chop(translatedCommaSpace().size());
	
	QString s=tr("Activities occupy max time slots from selection, WP:%1%, NA:%2, A: %3, STS: %4, MTS:%5", "Constraint description. WP means weight percentage, "
	 "NA means the number of activities, A means activities list, STS means selected time slots, MTS means max time slots")
	 .arg(CustomFETString::number(this->weightPercentage))
	 .arg(QString::number(this->activitiesIds.count()))
	 .arg(actids)
	 .arg(timeslots)
	 .arg(CustomFETString::number(this->maxOccupiedTimeSlots));
	
	return begin+s+end;
}

QString ConstraintActivitiesOccupyMaxTimeSlotsFromSelection::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	assert(this->selectedDays.count()==this->selectedHours.count());

	/*QString actids=QString("");
	for(int aid : std::as_const(this->activitiesIds))
		actids+=CustomFETString::number(aid)+QString(", ");
	actids.chop(2);*/
	
	if(!richText){
		QString timeslots=QString("");
		for(int i=0; i<this->selectedDays.count(); i++)
			timeslots+=r.daysOfTheWeek[selectedDays.at(i)]+QString(" ")+r.hoursOfTheDay[selectedHours.at(i)]+translatedCommaSpace();
		timeslots.chop(translatedCommaSpace().size());
		
		QString s=tr("Time constraint"); s+="\n";
		s+=tr("Activities occupy max time slots from selection"); s+="\n";
		s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage)); s+="\n";
		s+=tr("Number of activities=%1").arg(QString::number(this->activitiesIds.count())); s+="\n";
		for(int id : std::as_const(this->activitiesIds)){
			s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			 .arg(id)
			 .arg(getActivityDetailedDescription(r, id));
			s+="\n";
		}
		s+=tr("Selected time slots: %1").arg(timeslots); s+="\n";
		s+=tr("Maximum number of occupied slots from selection=%1").arg(CustomFETString::number(this->maxOccupiedTimeSlots)); s+="\n";

		if(!active){
			s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			s+="\n";
		}
		if(!comments.isEmpty()){
			s+=tr("Comments=%1").arg(comments);
			s+="\n";
		}
		
		return s;
	}
	else{
		QString begin=tr("Time constraint"); begin+="\n";
		begin+=tr("Activities occupy max time slots from selection"); begin+="\n";
		begin+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage)); begin+="\n";
		begin+=tr("Number of activities=%1").arg(QString::number(this->activitiesIds.count())); begin+="\n";
		for(int id : std::as_const(this->activitiesIds)){
			begin+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			 .arg(id)
			 .arg(getActivityDetailedDescription(r, id));
			begin+="\n";
		}

		begin+=tr("Selected time slots:"); begin+="\n";
		//the first Boolean is 'direct', the second Boolean is 'not available/selected', the third Boolean is 'color'.
		QString middle=listsOfDaysAndHoursToTable(r, selectedDays, selectedHours, true, false, colors);
		QString end;
		end+="\n";

		end+=tr("Maximum number of occupied slots from selection=%1").arg(CustomFETString::number(this->maxOccupiedTimeSlots)); end+="\n";

		if(!active){
			end+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			end+="\n";
		}
		if(!comments.isEmpty()){
			end+=tr("Comments=%1").arg(comments);
			end+="\n";
		}
		
		return protect4(begin)+middle+protect4(end);
	}
}

double ConstraintActivitiesOccupyMaxTimeSlotsFromSelection::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

	///////////////////
	Matrix2D<bool> used;
	used.resize(r.nDaysPerWeek, r.nHoursPerDay);
	for(int d=0; d<r.nDaysPerWeek; d++)
		for(int h=0; h<r.nHoursPerDay; h++)
			used[d][h]=false;
	
	for(int ai : std::as_const(this->_activitiesIndices)){
		if(c.times[ai]!=UNALLOCATED_TIME){
			Activity* act=&r.internalActivitiesList[ai];
			int d=c.times[ai]%r.nDaysPerWeek;
			int h=c.times[ai]/r.nDaysPerWeek;
			for(int dur=0; dur<act->duration; dur++){
				assert(h+dur<r.nHoursPerDay);
				used[d][h+dur]=true;
			}
		}
	}

	int cnt=0;
	assert(this->selectedDays.count()==this->selectedHours.count());
	for(int t=0; t<this->selectedDays.count(); t++){
		int d=this->selectedDays.at(t);
		int h=this->selectedHours.at(t);
		
		if(used[d][h])
			cnt++;
	}

	nbroken=0;
	
	if(cnt > this->maxOccupiedTimeSlots){
		nbroken=1;
	
		if(conflictsString!=nullptr){
			QString s=tr("Time constraint %1 broken - this should not happen, as this kind of constraint should "
			 "have only 100.0% weight. Please report error!").arg(this->getDescription(r));
			
			dl.append(s);
			cl.append(weightPercentage/100.0);
		
			*conflictsString+= s+"\n";
		}
	}

	if(weightPercentage==100.0)
		assert(nbroken==0);
	return nbroken * weightPercentage / 100.0;
}

void ConstraintActivitiesOccupyMaxTimeSlotsFromSelection::removeUseless(Rules& r)
{
	QList<int> newActs;
	
	for(int aid : std::as_const(activitiesIds)){
		Activity* act=r.activitiesPointerHash.value(aid, nullptr);
		if(act!=nullptr)
			newActs.append(aid);
	}
	
	activitiesIds=newActs;

	r.internalStructureComputed=false;
}

void ConstraintActivitiesOccupyMaxTimeSlotsFromSelection::recomputeActivitiesSet()
{
	activitiesIdsSet=QSet<int>(activitiesIds.constBegin(), activitiesIds.constEnd());
}

bool ConstraintActivitiesOccupyMaxTimeSlotsFromSelection::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	return activitiesIdsSet.contains(aid);

	//return this->activitiesIds.contains(a->id);
}

bool ConstraintActivitiesOccupyMaxTimeSlotsFromSelection::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivitiesOccupyMaxTimeSlotsFromSelection::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesOccupyMaxTimeSlotsFromSelection::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesOccupyMaxTimeSlotsFromSelection::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);
	
	return false;
}

int ConstraintActivitiesOccupyMaxTimeSlotsFromSelection::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivitiesOccupyMaxTimeSlotsFromSelection::hasWrongDayOrHour(Rules& r)
{
	assert(selectedDays.count()==selectedHours.count());
	
	for(int i=0; i<selectedDays.count(); i++)
		if(selectedDays.at(i)<0 || selectedDays.at(i)>=r.nDaysPerWeek
		 || selectedHours.at(i)<0 || selectedHours.at(i)>=r.nHoursPerDay)
			return true;
			
	if(maxOccupiedTimeSlots>r.nDaysPerWeek*r.nHoursPerDay)
		return true;

	return false;
}

bool ConstraintActivitiesOccupyMaxTimeSlotsFromSelection::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintActivitiesOccupyMaxTimeSlotsFromSelection::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	assert(selectedDays.count()==selectedHours.count());
	
	QList<int> newDays;
	QList<int> newHours;
	
	for(int i=0; i<selectedDays.count(); i++)
		if(selectedDays.at(i)>=0 && selectedDays.at(i)<r.nDaysPerWeek
		 && selectedHours.at(i)>=0 && selectedHours.at(i)<r.nHoursPerDay){
			newDays.append(selectedDays.at(i));
			newHours.append(selectedHours.at(i));
		}
	
	selectedDays=newDays;
	selectedHours=newHours;
	
	if(maxOccupiedTimeSlots>r.nDaysPerWeek*r.nHoursPerDay)
		maxOccupiedTimeSlots=r.nDaysPerWeek*r.nHoursPerDay;
	
	r.internalStructureComputed=false;
	setRulesModifiedAndOtherThings(&r);

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivitiesOccupyMinTimeSlotsFromSelection::ConstraintActivitiesOccupyMinTimeSlotsFromSelection()
	: TimeConstraint()
{
	this->type = CONSTRAINT_ACTIVITIES_OCCUPY_MIN_TIME_SLOTS_FROM_SELECTION;
}

ConstraintActivitiesOccupyMinTimeSlotsFromSelection::ConstraintActivitiesOccupyMinTimeSlotsFromSelection(double wp,
	const QList<int>& a_L, const QList<int>& d_L, const QList<int>& h_L, int min_slots)
	: TimeConstraint(wp)
{
	assert(d_L.count()==h_L.count());

	this->activitiesIds=a_L;
	this->selectedDays=d_L;
	this->selectedHours=h_L;
	this->minOccupiedTimeSlots=min_slots;
	
	this->type=CONSTRAINT_ACTIVITIES_OCCUPY_MIN_TIME_SLOTS_FROM_SELECTION;
}

bool ConstraintActivitiesOccupyMinTimeSlotsFromSelection::computeInternalStructure(QWidget* parent, Rules& r)
{
	//this cares about inactive activities, also, so do not assert this->_actIndices.count()==this->actIds.count()
	_activitiesIndices.clear();
	for(int id : std::as_const(activitiesIds)){
		int i=r.activitiesHash.value(id, -1);
		if(i>=0)
			_activitiesIndices.append(i);
	}

	/*this->_activitiesIndices.clear();
	
	QSet<int> req=this->activitiesIds.toSet();
	assert(req.count()==this->activitiesIds.count());
	
	//this cares about inactive activities, also, so do not assert this->_actIndices.count()==this->actIds.count()
	int i;
	for(i=0; i<r.nInternalActivities; i++)
		if(req.contains(r.internalActivitiesList[i].id))
			this->_activitiesIndices.append(i);*/
			
	//////////////////////
	assert(this->selectedDays.count()==this->selectedHours.count());
	
	for(int k=0; k<this->selectedDays.count(); k++){
		if(this->selectedDays.at(k) >= r.nDaysPerWeek){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities occupy min time slots from selection is wrong because it refers to removed day. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->selectedHours.at(k) == r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities occupy min time slots from selection is wrong because an hour is too late (after the last acceptable slot). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->selectedHours.at(k) > r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities occupy min time slots from selection is wrong because it refers to removed hour. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->selectedDays.at(k)<0 || this->selectedHours.at(k)<0){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities occupy min time slots from selection is wrong because hour or day is not specified for a slot (-1). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
	}
	///////////////////////
	
	if(this->_activitiesIndices.count()>0)
		return true;
	else{
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to no activities). Please correct it:\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}
}

bool ConstraintActivitiesOccupyMinTimeSlotsFromSelection::hasInactiveActivities(Rules& r)
{
	//returns true if all activities are inactive
	
	for(int aid : std::as_const(this->activitiesIds))
		if(!r.inactiveActivities.contains(aid))
			return false;

	return true;
}

QString ConstraintActivitiesOccupyMinTimeSlotsFromSelection::getXmlDescription(Rules& r)
{
	assert(this->selectedDays.count()==this->selectedHours.count());

	QString s=IL2+"<ConstraintActivitiesOccupyMinTimeSlotsFromSelection>\n";
	
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	
	s+=IL3+"<Number_of_Activities>"+QString::number(this->activitiesIds.count())+"</Number_of_Activities>\n";
	for(int aid : std::as_const(this->activitiesIds))
		s+=IL3+"<Activity_Id>"+CustomFETString::number(aid)+"</Activity_Id>\n";
	
	s+=IL3+"<Number_of_Selected_Time_Slots>"+QString::number(this->selectedDays.count())+"</Number_of_Selected_Time_Slots>\n";
	for(int i=0; i<this->selectedDays.count(); i++){
		s+=IL3+"<Selected_Time_Slot>\n";
		s+=IL4+"<Day>"+protect(r.daysOfTheWeek[this->selectedDays.at(i)])+"</Day>\n";
		s+=IL4+"<Hour>"+protect(r.hoursOfTheDay[this->selectedHours.at(i)])+"</Hour>\n";
		s+=IL3+"</Selected_Time_Slot>\n";
	}
	s+=IL3+"<Min_Number_of_Occupied_Time_Slots>"+CustomFETString::number(this->minOccupiedTimeSlots)+"</Min_Number_of_Occupied_Time_Slots>\n";
	
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivitiesOccupyMinTimeSlotsFromSelection>\n";
	return s;
}

QString ConstraintActivitiesOccupyMinTimeSlotsFromSelection::getDescription(Rules& r)
{
	QString begin=QString("");
	if(!active)
		begin="X - ";
	
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
	
	assert(this->selectedDays.count()==this->selectedHours.count());

	QString actids=QString("");
	for(int aid : std::as_const(this->activitiesIds))
		actids+=getActivityDescription(r, aid)+translatedCommaSpace();
	actids.chop(translatedCommaSpace().size());
	
	QString timeslots=QString("");
	for(int i=0; i<this->selectedDays.count(); i++)
		timeslots+=r.daysOfTheWeek[selectedDays.at(i)]+QString(" ")+r.hoursOfTheDay[selectedHours.at(i)]+translatedCommaSpace();
	timeslots.chop(translatedCommaSpace().size());
	
	QString s=tr("Activities occupy min time slots from selection, WP:%1%, NA:%2, A: %3, STS: %4, mTS:%5", "Constraint description. WP means weight percentage, "
	 "NA means the number of activities, A means activities list, STS means selected time slots, mTS means min time slots")
	 .arg(CustomFETString::number(this->weightPercentage))
	 .arg(QString::number(this->activitiesIds.count()))
	 .arg(actids)
	 .arg(timeslots)
	 .arg(CustomFETString::number(this->minOccupiedTimeSlots));
	
	return begin+s+end;
}

QString ConstraintActivitiesOccupyMinTimeSlotsFromSelection::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	assert(this->selectedDays.count()==this->selectedHours.count());

	/*QString actids=QString("");
	for(int aid : std::as_const(this->activitiesIds))
		actids+=CustomFETString::number(aid)+QString(", ");
	actids.chop(2);*/
	
	if(!richText){
		QString timeslots=QString("");
		for(int i=0; i<this->selectedDays.count(); i++)
			timeslots+=r.daysOfTheWeek[selectedDays.at(i)]+QString(" ")+r.hoursOfTheDay[selectedHours.at(i)]+translatedCommaSpace();
		timeslots.chop(translatedCommaSpace().size());
		
		QString s=tr("Time constraint"); s+="\n";
		s+=tr("Activities occupy min time slots from selection"); s+="\n";
		s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage)); s+="\n";
		s+=tr("Number of activities=%1").arg(QString::number(this->activitiesIds.count())); s+="\n";
		for(int id : std::as_const(this->activitiesIds)){
			s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			 .arg(id)
			 .arg(getActivityDetailedDescription(r, id));
			s+="\n";
		}
		s+=tr("Selected time slots: %1").arg(timeslots); s+="\n";
		s+=tr("Minimum number of occupied slots from selection=%1").arg(CustomFETString::number(this->minOccupiedTimeSlots)); s+="\n";

		if(!active){
			s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			s+="\n";
		}
		if(!comments.isEmpty()){
			s+=tr("Comments=%1").arg(comments);
			s+="\n";
		}
		
		return s;
	}
	else{
		QString begin=tr("Time constraint"); begin+="\n";
		begin+=tr("Activities occupy min time slots from selection"); begin+="\n";
		begin+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage)); begin+="\n";
		begin+=tr("Number of activities=%1").arg(QString::number(this->activitiesIds.count())); begin+="\n";
		for(int id : std::as_const(this->activitiesIds)){
			begin+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			 .arg(id)
			 .arg(getActivityDetailedDescription(r, id));
			begin+="\n";
		}

		begin+=tr("Selected time slots:"); begin+="\n";
		//the first Boolean is 'direct', the second Boolean is 'not available/selected', the third Boolean is 'color'.
		QString middle=listsOfDaysAndHoursToTable(r, selectedDays, selectedHours, true, false, colors);
		QString end;
		end+="\n";
		
		end+=tr("Minimum number of occupied slots from selection=%1").arg(CustomFETString::number(this->minOccupiedTimeSlots)); end+="\n";

		if(!active){
			end+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			end+="\n";
		}
		if(!comments.isEmpty()){
			end+=tr("Comments=%1").arg(comments);
			end+="\n";
		}
		
		return protect4(begin)+middle+protect4(end);
	}
}

double ConstraintActivitiesOccupyMinTimeSlotsFromSelection::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

	///////////////////
	Matrix2D<bool> used;
	used.resize(r.nDaysPerWeek, r.nHoursPerDay);
	for(int d=0; d<r.nDaysPerWeek; d++)
		for(int h=0; h<r.nHoursPerDay; h++)
			used[d][h]=false;
	
	for(int ai : std::as_const(this->_activitiesIndices)){
		if(c.times[ai]!=UNALLOCATED_TIME){
			Activity* act=&r.internalActivitiesList[ai];
			int d=c.times[ai]%r.nDaysPerWeek;
			int h=c.times[ai]/r.nDaysPerWeek;
			for(int dur=0; dur<act->duration; dur++){
				assert(h+dur<r.nHoursPerDay);
				used[d][h+dur]=true;
			}
		}
	}

	int cnt=0;
	assert(this->selectedDays.count()==this->selectedHours.count());
	for(int t=0; t<this->selectedDays.count(); t++){
		int d=this->selectedDays.at(t);
		int h=this->selectedHours.at(t);
		
		if(used[d][h])
			cnt++;
	}

	nbroken=0;
	
	if(cnt < this->minOccupiedTimeSlots){
		nbroken=1;
	
		if(conflictsString!=nullptr){
			QString s;
			if(c.nPlacedActivities==r.nInternalActivities){
				s=tr("Time constraint %1 broken - this should not happen, as this kind of constraint should "
				 "have only 100.0% weight. Please report error!").arg(this->getDescription(r));
			}
			else{
				s=tr("Time constraint %1 broken for the partial timetable.").arg(this->getDescription(r));
				s+=" ";
				s+=tr("Conflicts factor increase=%1").arg(CustomFETString::numberPlusTwoDigitsPrecision(nbroken*weightPercentage/100));
			}
			
			dl.append(s);
			cl.append(weightPercentage/100.0);
		
			*conflictsString+= s+"\n";
		}
	}

	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100.0)
			assert(nbroken==0);
	return nbroken * weightPercentage / 100.0;
}

void ConstraintActivitiesOccupyMinTimeSlotsFromSelection::removeUseless(Rules& r)
{
	QList<int> newActs;
	
	for(int aid : std::as_const(activitiesIds)){
		Activity* act=r.activitiesPointerHash.value(aid, nullptr);
		if(act!=nullptr)
			newActs.append(aid);
	}
	
	activitiesIds=newActs;

	r.internalStructureComputed=false;
}

void ConstraintActivitiesOccupyMinTimeSlotsFromSelection::recomputeActivitiesSet()
{
	activitiesIdsSet=QSet<int>(activitiesIds.constBegin(), activitiesIds.constEnd());
}

bool ConstraintActivitiesOccupyMinTimeSlotsFromSelection::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	return activitiesIdsSet.contains(aid);

	//return this->activitiesIds.contains(a->id);
}

bool ConstraintActivitiesOccupyMinTimeSlotsFromSelection::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivitiesOccupyMinTimeSlotsFromSelection::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesOccupyMinTimeSlotsFromSelection::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesOccupyMinTimeSlotsFromSelection::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);
	
	return false;
}

int ConstraintActivitiesOccupyMinTimeSlotsFromSelection::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivitiesOccupyMinTimeSlotsFromSelection::hasWrongDayOrHour(Rules& r)
{
	assert(selectedDays.count()==selectedHours.count());
	
	for(int i=0; i<selectedDays.count(); i++)
		if(selectedDays.at(i)<0 || selectedDays.at(i)>=r.nDaysPerWeek
		 || selectedHours.at(i)<0 || selectedHours.at(i)>=r.nHoursPerDay)
			return true;
			
	if(minOccupiedTimeSlots>r.nDaysPerWeek*r.nHoursPerDay)
		return true;

	return false;
}

bool ConstraintActivitiesOccupyMinTimeSlotsFromSelection::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintActivitiesOccupyMinTimeSlotsFromSelection::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	assert(selectedDays.count()==selectedHours.count());
	
	QList<int> newDays;
	QList<int> newHours;
	
	for(int i=0; i<selectedDays.count(); i++)
		if(selectedDays.at(i)>=0 && selectedDays.at(i)<r.nDaysPerWeek
		 && selectedHours.at(i)>=0 && selectedHours.at(i)<r.nHoursPerDay){
			newDays.append(selectedDays.at(i));
			newHours.append(selectedHours.at(i));
		}
	
	selectedDays=newDays;
	selectedHours=newHours;
	
	if(minOccupiedTimeSlots>r.nDaysPerWeek*r.nHoursPerDay)
		minOccupiedTimeSlots=r.nDaysPerWeek*r.nHoursPerDay;
	
	r.internalStructureComputed=false;
	setRulesModifiedAndOtherThings(&r);

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots::ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots()
	: TimeConstraint()
{
	this->type = CONSTRAINT_ACTIVITIES_MAX_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS;
}

ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots::ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots(double wp,
	const QList<int>& a_L, const QList<int>& d_L, const QList<int>& h_L, int max_simultaneous)
	: TimeConstraint(wp)
{
	assert(d_L.count()==h_L.count());

	this->activitiesIds=a_L;
	this->selectedDays=d_L;
	this->selectedHours=h_L;
	this->maxSimultaneous=max_simultaneous;
	
	this->type=CONSTRAINT_ACTIVITIES_MAX_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS;
}

bool ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots::computeInternalStructure(QWidget* parent, Rules& r)
{
	//this cares about inactive activities, also, so do not assert this->_actIndices.count()==this->actIds.count()
	_activitiesIndices.clear();
	for(int id : std::as_const(activitiesIds)){
		int i=r.activitiesHash.value(id, -1);
		if(i>=0)
			_activitiesIndices.append(i);
	}

	/*this->_activitiesIndices.clear();
	
	QSet<int> req=this->activitiesIds.toSet();
	assert(req.count()==this->activitiesIds.count());
	
	//this cares about inactive activities, also, so do not assert this->_actIndices.count()==this->actIds.count()
	int i;
	for(i=0; i<r.nInternalActivities; i++)
		if(req.contains(r.internalActivitiesList[i].id))
			this->_activitiesIndices.append(i);*/
			
	//////////////////////
	assert(this->selectedDays.count()==this->selectedHours.count());
	
	for(int k=0; k<this->selectedDays.count(); k++){
		if(this->selectedDays.at(k) >= r.nDaysPerWeek){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities max simultaneous in selected time slots is wrong because it refers to removed day. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->selectedHours.at(k) == r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities max simultaneous in selected time slots is wrong because an hour is too late (after the last acceptable slot). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->selectedHours.at(k) > r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities max simultaneous in selected time slots is wrong because it refers to removed hour. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->selectedDays.at(k)<0 || this->selectedHours.at(k)<0){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities max simultaneous in selected time slots is wrong because hour or day is not specified for a slot (-1). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
	}
	///////////////////////
	
	if(this->_activitiesIndices.count()>0)
		return true;
	else{
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to no activities). Please correct it:\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}
}

bool ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots::hasInactiveActivities(Rules& r)
{
	//returns true if all activities are inactive
	
	for(int aid : std::as_const(this->activitiesIds))
		if(!r.inactiveActivities.contains(aid))
			return false;

	return true;
}

QString ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots::getXmlDescription(Rules& r)
{
	assert(this->selectedDays.count()==this->selectedHours.count());

	QString s=IL2+"<ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots>\n";
	
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	
	s+=IL3+"<Number_of_Activities>"+QString::number(this->activitiesIds.count())+"</Number_of_Activities>\n";
	for(int aid : std::as_const(this->activitiesIds))
		s+=IL3+"<Activity_Id>"+CustomFETString::number(aid)+"</Activity_Id>\n";
	
	s+=IL3+"<Number_of_Selected_Time_Slots>"+QString::number(this->selectedDays.count())+"</Number_of_Selected_Time_Slots>\n";
	for(int i=0; i<this->selectedDays.count(); i++){
		s+=IL3+"<Selected_Time_Slot>\n";
		s+=IL4+"<Day>"+protect(r.daysOfTheWeek[this->selectedDays.at(i)])+"</Day>\n";
		s+=IL4+"<Hour>"+protect(r.hoursOfTheDay[this->selectedHours.at(i)])+"</Hour>\n";
		s+=IL3+"</Selected_Time_Slot>\n";
	}
	s+=IL3+"<Max_Number_of_Simultaneous_Activities>"+CustomFETString::number(this->maxSimultaneous)+"</Max_Number_of_Simultaneous_Activities>\n";
	
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots>\n";
	return s;
}

QString ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots::getDescription(Rules& r)
{
	QString begin=QString("");
	if(!active)
		begin="X - ";
	
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	assert(this->selectedDays.count()==this->selectedHours.count());

	QString actids=QString("");
	for(int aid : std::as_const(this->activitiesIds))
		actids+=getActivityDescription(r, aid)+translatedCommaSpace();
	actids.chop(translatedCommaSpace().size());
	
	QString timeslots=QString("");
	for(int i=0; i<this->selectedDays.count(); i++)
		timeslots+=r.daysOfTheWeek[selectedDays.at(i)]+QString(" ")+r.hoursOfTheDay[selectedHours.at(i)]+translatedCommaSpace();
	timeslots.chop(translatedCommaSpace().size());
	
	QString s=tr("Activities max simultaneous in selected time slots, WP:%1%, NA:%2, A: %3, STS: %4, MS:%5", "Constraint description. WP means weight percentage, "
	 "NA means the number of activities, A means activities list, STS means selected time slots, MS means max simultaneous (number of activities in each selected time slot)")
	 .arg(CustomFETString::number(this->weightPercentage))
	 .arg(QString::number(this->activitiesIds.count()))
	 .arg(actids)
	 .arg(timeslots)
	 .arg(CustomFETString::number(this->maxSimultaneous));
	
	return begin+s+end;
}

QString ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	assert(this->selectedDays.count()==this->selectedHours.count());

	/*QString actids=QString("");
	for(int aid : std::as_const(this->activitiesIds))
		actids+=CustomFETString::number(aid)+QString(", ");
	actids.chop(2);*/
	
	if(!richText){
		QString timeslots=QString("");
		for(int i=0; i<this->selectedDays.count(); i++)
			timeslots+=r.daysOfTheWeek[selectedDays.at(i)]+QString(" ")+r.hoursOfTheDay[selectedHours.at(i)]+translatedCommaSpace();
		timeslots.chop(translatedCommaSpace().size());
		
		QString s=tr("Time constraint"); s+="\n";
		s+=tr("Activities max simultaneous in selected time slots"); s+="\n";
		s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage)); s+="\n";
		s+=tr("Number of activities=%1").arg(QString::number(this->activitiesIds.count())); s+="\n";
		for(int id : std::as_const(this->activitiesIds)){
			s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			 .arg(id)
			 .arg(getActivityDetailedDescription(r, id));
			s+="\n";
		}
		s+=tr("Selected time slots: %1").arg(timeslots); s+="\n";
		s+=tr("Maximum number of simultaneous activities in each selected time slot=%1").arg(CustomFETString::number(this->maxSimultaneous)); s+="\n";
		
		if(!active){
			s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			s+="\n";
		}
		if(!comments.isEmpty()){
			s+=tr("Comments=%1").arg(comments);
			s+="\n";
		}
		
		return s;
	}
	else{
		QString begin=tr("Time constraint"); begin+="\n";
		begin+=tr("Activities max simultaneous in selected time slots"); begin+="\n";
		begin+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage)); begin+="\n";
		begin+=tr("Number of activities=%1").arg(QString::number(this->activitiesIds.count())); begin+="\n";
		for(int id : std::as_const(this->activitiesIds)){
			begin+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			 .arg(id)
			 .arg(getActivityDetailedDescription(r, id));
			begin+="\n";
		}

		begin+=tr("Selected time slots:"); begin+="\n";
		//the first Boolean is 'direct', the second Boolean is 'not available/selected', the third Boolean is 'color'.
		QString middle=listsOfDaysAndHoursToTable(r, selectedDays, selectedHours, true, false, colors);
		QString end;
		end+="\n";
		
		end+=tr("Maximum number of simultaneous activities in each selected time slot=%1").arg(CustomFETString::number(this->maxSimultaneous)); end+="\n";
		
		if(!active){
			end+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			end+="\n";
		}
		if(!comments.isEmpty()){
			end+=tr("Comments=%1").arg(comments);
			end+="\n";
		}
		
		return protect4(begin)+middle+protect4(end);
	}
}

double ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

///////////////////

	Matrix2D<int> count;
	count.resize(r.nDaysPerWeek, r.nHoursPerDay);
	for(int d=0; d<r.nDaysPerWeek; d++)
		for(int h=0; h<r.nHoursPerDay; h++)
			count[d][h]=0;
	
	for(int ai : std::as_const(this->_activitiesIndices)){
		if(c.times[ai]!=UNALLOCATED_TIME){
			Activity* act=&r.internalActivitiesList[ai];
			int d=c.times[ai]%r.nDaysPerWeek;
			int h=c.times[ai]/r.nDaysPerWeek;
			for(int dur=0; dur<act->duration; dur++){
				assert(h+dur<r.nHoursPerDay);
				count[d][h+dur]++;
			}
		}
	}

	nbroken=0;

	assert(this->selectedDays.count()==this->selectedHours.count());
	for(int t=0; t<this->selectedDays.count(); t++){
		int d=this->selectedDays.at(t);
		int h=this->selectedHours.at(t);
		
		if(count[d][h] > this->maxSimultaneous)
			nbroken++;
	}

	if(nbroken>0){
		if(conflictsString!=nullptr){
			QString s=tr("Time constraint %1 broken - this should not happen, as this kind of constraint should "
			 "have only 100.0% weight. Please report error!").arg(this->getDescription(r));
			
			dl.append(s);
			cl.append(weightPercentage/100.0);
		
			*conflictsString+= s+"\n";
		}
	}

	if(weightPercentage==100.0)
		assert(nbroken==0);
	return nbroken * weightPercentage / 100.0;
}

void ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots::removeUseless(Rules& r)
{
	QList<int> newActs;
	
	for(int aid : std::as_const(activitiesIds)){
		Activity* act=r.activitiesPointerHash.value(aid, nullptr);
		if(act!=nullptr)
			newActs.append(aid);
	}
	
	activitiesIds=newActs;

	r.internalStructureComputed=false;
}

void ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots::recomputeActivitiesSet()
{
	activitiesIdsSet=QSet<int>(activitiesIds.constBegin(), activitiesIds.constEnd());
}

bool ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	return activitiesIdsSet.contains(aid);

	//return this->activitiesIds.contains(a->id);
}

bool ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);
	
	return false;
}

int ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots::hasWrongDayOrHour(Rules& r)
{
	assert(selectedDays.count()==selectedHours.count());
	
	for(int i=0; i<selectedDays.count(); i++)
		if(selectedDays.at(i)<0 || selectedDays.at(i)>=r.nDaysPerWeek
		 || selectedHours.at(i)<0 || selectedHours.at(i)>=r.nHoursPerDay)
			return true;

	//Do not care about maxSimultaneous, which can be as high as MAX_ACTIVITIES

	return false;
}

bool ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	assert(selectedDays.count()==selectedHours.count());
	
	QList<int> newDays;
	QList<int> newHours;
	
	for(int i=0; i<selectedDays.count(); i++)
		if(selectedDays.at(i)>=0 && selectedDays.at(i)<r.nDaysPerWeek
		 && selectedHours.at(i)>=0 && selectedHours.at(i)<r.nHoursPerDay){
			newDays.append(selectedDays.at(i));
			newHours.append(selectedHours.at(i));
		}
	
	selectedDays=newDays;
	selectedHours=newHours;

	//Do not modify maxSimultaneous, which can be as high as MAX_ACTIVITIES
	
	r.internalStructureComputed=false;
	setRulesModifiedAndOtherThings(&r);

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivitiesMinSimultaneousInSelectedTimeSlots::ConstraintActivitiesMinSimultaneousInSelectedTimeSlots()
	: TimeConstraint()
{
	this->type = CONSTRAINT_ACTIVITIES_MIN_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS;
}

ConstraintActivitiesMinSimultaneousInSelectedTimeSlots::ConstraintActivitiesMinSimultaneousInSelectedTimeSlots(double wp,
	const QList<int>& a_L, const QList<int>& d_L, const QList<int>& h_L, int min_simultaneous, bool allow_empty_slots)
	: TimeConstraint(wp)
{
	assert(d_L.count()==h_L.count());

	this->activitiesIds=a_L;
	this->selectedDays=d_L;
	this->selectedHours=h_L;
	this->minSimultaneous=min_simultaneous;
	this->allowEmptySlots=allow_empty_slots;
	
	this->type=CONSTRAINT_ACTIVITIES_MIN_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS;
}

bool ConstraintActivitiesMinSimultaneousInSelectedTimeSlots::computeInternalStructure(QWidget* parent, Rules& r)
{
	//this cares about inactive activities, also, so do not assert this->_actIndices.count()==this->actIds.count()
	_activitiesIndices.clear();
	for(int id : std::as_const(activitiesIds)){
		int i=r.activitiesHash.value(id, -1);
		if(i>=0)
			_activitiesIndices.append(i);
	}

	/*this->_activitiesIndices.clear();
	
	QSet<int> req=this->activitiesIds.toSet();
	assert(req.count()==this->activitiesIds.count());
	
	//this cares about inactive activities, also, so do not assert this->_actIndices.count()==this->actIds.count()
	int i;
	for(i=0; i<r.nInternalActivities; i++)
		if(req.contains(r.internalActivitiesList[i].id))
			this->_activitiesIndices.append(i);*/
			
	//////////////////////
	assert(this->selectedDays.count()==this->selectedHours.count());
	
	for(int k=0; k<this->selectedDays.count(); k++){
		if(this->selectedDays.at(k) >= r.nDaysPerWeek){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities min simultaneous in selected time slots is wrong because it refers to removed day. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->selectedHours.at(k) == r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities min simultaneous in selected time slots is wrong because an hour is too late (after the last acceptable slot). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->selectedHours.at(k) > r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities min simultaneous in selected time slots is wrong because it refers to removed hour. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
		if(this->selectedDays.at(k)<0 || this->selectedHours.at(k)<0){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint activities min simultaneous in selected time slots is wrong because hour or day is not specified for a slot (-1). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
			return false;
		}
	}
	///////////////////////
	
	if(this->_activitiesIndices.count()>0)
		return true;
	else{
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to no activities). Please correct it:\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}
}

bool ConstraintActivitiesMinSimultaneousInSelectedTimeSlots::hasInactiveActivities(Rules& r)
{
	//returns true if all activities are inactive
	
	for(int aid : std::as_const(this->activitiesIds))
		if(!r.inactiveActivities.contains(aid))
			return false;

	return true;
}

QString ConstraintActivitiesMinSimultaneousInSelectedTimeSlots::getXmlDescription(Rules& r)
{
	assert(this->selectedDays.count()==this->selectedHours.count());

	QString s=IL2+"<ConstraintActivitiesMinSimultaneousInSelectedTimeSlots>\n";
	
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	
	s+=IL3+"<Number_of_Activities>"+QString::number(this->activitiesIds.count())+"</Number_of_Activities>\n";
	for(int aid : std::as_const(this->activitiesIds))
		s+=IL3+"<Activity_Id>"+CustomFETString::number(aid)+"</Activity_Id>\n";
	
	s+=IL3+"<Number_of_Selected_Time_Slots>"+QString::number(this->selectedDays.count())+"</Number_of_Selected_Time_Slots>\n";
	for(int i=0; i<this->selectedDays.count(); i++){
		s+=IL3+"<Selected_Time_Slot>\n";
		s+=IL4+"<Day>"+protect(r.daysOfTheWeek[this->selectedDays.at(i)])+"</Day>\n";
		s+=IL4+"<Hour>"+protect(r.hoursOfTheDay[this->selectedHours.at(i)])+"</Hour>\n";
		s+=IL3+"</Selected_Time_Slot>\n";
	}
	s+=IL3+"<Min_Number_of_Simultaneous_Activities>"+CustomFETString::number(this->minSimultaneous)+"</Min_Number_of_Simultaneous_Activities>\n";
	s+=IL3+"<Allow_Empty_Slots>"+trueFalse(allowEmptySlots)+"</Allow_Empty_Slots>\n";
	
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivitiesMinSimultaneousInSelectedTimeSlots>\n";
	return s;
}

QString ConstraintActivitiesMinSimultaneousInSelectedTimeSlots::getDescription(Rules& r)
{
	QString begin=QString("");
	if(!active)
		begin="X - ";
	
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
	
	assert(this->selectedDays.count()==this->selectedHours.count());

	QString actids=QString("");
	for(int aid : std::as_const(this->activitiesIds))
		actids+=getActivityDescription(r, aid)+translatedCommaSpace();
	actids.chop(translatedCommaSpace().size());
	
	QString timeslots=QString("");
	for(int i=0; i<this->selectedDays.count(); i++)
		timeslots+=r.daysOfTheWeek[selectedDays.at(i)]+QString(" ")+r.hoursOfTheDay[selectedHours.at(i)]+translatedCommaSpace();
	timeslots.chop(translatedCommaSpace().size());
	
	QString s=tr("Activities min simultaneous in selected time slots, WP:%1%, NA:%2, A: %3, STS: %4, mS:%5, AES=%6", "Constraint description. WP means weight percentage, "
	 "NA means the number of activities, A means activities list, STS means selected time slots, mS means min simultaneous (number of activities in each selected time slot), "
	 "AES means allow empty slots.")
	 .arg(CustomFETString::number(this->weightPercentage))
	 .arg(QString::number(this->activitiesIds.count()))
	 .arg(actids)
	 .arg(timeslots)
	 .arg(CustomFETString::number(this->minSimultaneous))
	 .arg(yesNoTranslated(allowEmptySlots));
	
	return begin+s+end;
}

QString ConstraintActivitiesMinSimultaneousInSelectedTimeSlots::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	assert(this->selectedDays.count()==this->selectedHours.count());

	/*QString actids=QString("");
	for(int aid : std::as_const(this->activitiesIds))
		actids+=CustomFETString::number(aid)+QString(", ");
	actids.chop(2);*/
	
	if(!richText){
		QString timeslots=QString("");
		for(int i=0; i<this->selectedDays.count(); i++)
			timeslots+=r.daysOfTheWeek[selectedDays.at(i)]+QString(" ")+r.hoursOfTheDay[selectedHours.at(i)]+translatedCommaSpace();
		timeslots.chop(translatedCommaSpace().size());
		
		QString s=tr("Time constraint"); s+="\n";
		s+=tr("Activities min simultaneous in selected time slots"); s+="\n";
		s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage)); s+="\n";
		s+=tr("Number of activities=%1").arg(QString::number(this->activitiesIds.count())); s+="\n";
		for(int id : std::as_const(this->activitiesIds)){
			s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			 .arg(id)
			 .arg(getActivityDetailedDescription(r, id));
			s+="\n";
		}
		s+=tr("Selected time slots: %1").arg(timeslots); s+="\n";
		s+=tr("Minimum number of simultaneous activities in each selected time slot=%1").arg(CustomFETString::number(this->minSimultaneous)); s+="\n";
		s+=tr("Allow empty slots=%1").arg(yesNoTranslated(allowEmptySlots)); s+="\n";
		
		if(!active){
			s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			s+="\n";
		}
		if(!comments.isEmpty()){
			s+=tr("Comments=%1").arg(comments);
			s+="\n";
		}
		
		return s;
	}
	else{
		QString begin=tr("Time constraint"); begin+="\n";
		begin+=tr("Activities min simultaneous in selected time slots"); begin+="\n";
		begin+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage)); begin+="\n";
		begin+=tr("Number of activities=%1").arg(QString::number(this->activitiesIds.count())); begin+="\n";
		for(int id : std::as_const(this->activitiesIds)){
			begin+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			 .arg(id)
			 .arg(getActivityDetailedDescription(r, id));
			begin+="\n";
		}

		begin+=tr("Selected time slots:"); begin+="\n";
		//the first Boolean is 'direct', the second Boolean is 'not available/selected', the third Boolean is 'color'.
		QString middle=listsOfDaysAndHoursToTable(r, selectedDays, selectedHours, true, false, colors);
		QString end;
		end+="\n";

		end+=tr("Minimum number of simultaneous activities in each selected time slot=%1").arg(CustomFETString::number(this->minSimultaneous)); end+="\n";
		end+=tr("Allow empty slots=%1").arg(yesNoTranslated(allowEmptySlots)); end+="\n";
		
		if(!active){
			end+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			end+="\n";
		}
		if(!comments.isEmpty()){
			end+=tr("Comments=%1").arg(comments);
			end+="\n";
		}
		
		return protect4(begin)+middle+protect4(end);
	}
}

double ConstraintActivitiesMinSimultaneousInSelectedTimeSlots::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

///////////////////

	Matrix2D<int> count;
	count.resize(r.nDaysPerWeek, r.nHoursPerDay);
	for(int d=0; d<r.nDaysPerWeek; d++)
		for(int h=0; h<r.nHoursPerDay; h++)
			count[d][h]=0;
	
	for(int ai : std::as_const(this->_activitiesIndices)){
		if(c.times[ai]!=UNALLOCATED_TIME){
			Activity* act=&r.internalActivitiesList[ai];
			int d=c.times[ai]%r.nDaysPerWeek;
			int h=c.times[ai]/r.nDaysPerWeek;
			for(int dur=0; dur<act->duration; dur++){
				assert(h+dur<r.nHoursPerDay);
				count[d][h+dur]++;
			}
		}
	}

	nbroken=0;

	assert(this->selectedDays.count()==this->selectedHours.count());
	for(int t=0; t<this->selectedDays.count(); t++){
		int d=this->selectedDays.at(t);
		int h=this->selectedHours.at(t);
		
		if(allowEmptySlots && count[d][h]>0 && count[d][h] < this->minSimultaneous)
			nbroken++;
		else if(!allowEmptySlots && count[d][h] < this->minSimultaneous)
			nbroken++;
	}

	if(nbroken>0){
		if(conflictsString!=nullptr){
			QString s;
			if(c.nPlacedActivities==r.nInternalActivities){
				s=tr("Time constraint %1 broken - this should not happen, as this kind of constraint should "
				 "have only 100.0% weight. Please report error!").arg(this->getDescription(r));
			}
			else{
				s=tr("Time constraint %1 broken for the partial timetable.").arg(this->getDescription(r));
				s+=" ";
				s+=tr("Conflicts factor increase=%1").arg(CustomFETString::numberPlusTwoDigitsPrecision(nbroken*weightPercentage/100));
			}

			dl.append(s);
			cl.append(weightPercentage/100.0);
		
			*conflictsString+= s+"\n";
		}
	}

	if(c.nPlacedActivities==r.nInternalActivities)
		if(weightPercentage==100.0)
			assert(nbroken==0);
	return nbroken * weightPercentage / 100.0;
}

void ConstraintActivitiesMinSimultaneousInSelectedTimeSlots::removeUseless(Rules& r)
{
	QList<int> newActs;
	
	for(int aid : std::as_const(activitiesIds)){
		Activity* act=r.activitiesPointerHash.value(aid, nullptr);
		if(act!=nullptr)
			newActs.append(aid);
	}
	
	activitiesIds=newActs;

	r.internalStructureComputed=false;
}

void ConstraintActivitiesMinSimultaneousInSelectedTimeSlots::recomputeActivitiesSet()
{
	activitiesIdsSet=QSet<int>(activitiesIds.constBegin(), activitiesIds.constEnd());
}

bool ConstraintActivitiesMinSimultaneousInSelectedTimeSlots::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	return activitiesIdsSet.contains(aid);

	//return this->activitiesIds.contains(a->id);
}

bool ConstraintActivitiesMinSimultaneousInSelectedTimeSlots::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivitiesMinSimultaneousInSelectedTimeSlots::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesMinSimultaneousInSelectedTimeSlots::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesMinSimultaneousInSelectedTimeSlots::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);
	
	return false;
}

int ConstraintActivitiesMinSimultaneousInSelectedTimeSlots::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivitiesMinSimultaneousInSelectedTimeSlots::hasWrongDayOrHour(Rules& r)
{
	assert(selectedDays.count()==selectedHours.count());
	
	for(int i=0; i<selectedDays.count(); i++)
		if(selectedDays.at(i)<0 || selectedDays.at(i)>=r.nDaysPerWeek
		 || selectedHours.at(i)<0 || selectedHours.at(i)>=r.nHoursPerDay)
			return true;

	//Do not care about minSimultaneous, which can be as high as MAX_ACTIVITIES

	return false;
}

bool ConstraintActivitiesMinSimultaneousInSelectedTimeSlots::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintActivitiesMinSimultaneousInSelectedTimeSlots::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	assert(selectedDays.count()==selectedHours.count());
	
	QList<int> newDays;
	QList<int> newHours;
	
	for(int i=0; i<selectedDays.count(); i++)
		if(selectedDays.at(i)>=0 && selectedDays.at(i)<r.nDaysPerWeek
		 && selectedHours.at(i)>=0 && selectedHours.at(i)<r.nHoursPerDay){
			newDays.append(selectedDays.at(i));
			newHours.append(selectedHours.at(i));
		}
	
	selectedDays=newDays;
	selectedHours=newHours;

	//Do not modify minSimultaneous, which can be as high as MAX_ACTIVITIES
	
	r.internalStructureComputed=false;
	setRulesModifiedAndOtherThings(&r);

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots::ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots()
	: TimeConstraint()
{
	this->type = CONSTRAINT_MAX_TOTAL_ACTIVITIES_FROM_SET_IN_SELECTED_TIME_SLOTS;
}

ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots::ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots(double wp,
	const QList<int>& a_L, const QList<int>& d_L, const QList<int>& h_L, int max_activities)
	: TimeConstraint(wp)
{
	assert(d_L.count()==h_L.count());

	this->activitiesIds=a_L;
	this->selectedDays=d_L;
	this->selectedHours=h_L;
	this->maxActivities=max_activities;

	this->type=CONSTRAINT_MAX_TOTAL_ACTIVITIES_FROM_SET_IN_SELECTED_TIME_SLOTS;
}

bool ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots::computeInternalStructure(QWidget* parent, Rules& r)
{
	//this cares about inactive activities, also, so do not assert this->_actIndices.count()==this->actIds.count()
	_activitiesIndices.clear();
	for(int id : std::as_const(activitiesIds)){
		int i=r.activitiesHash.value(id, -1);
		if(i>=0)
			_activitiesIndices.append(i);
	}

	/*this->_activitiesIndices.clear();

	QSet<int> req=this->activitiesIds.toSet();
	assert(req.count()==this->activitiesIds.count());

	//this cares about inactive activities, also, so do not assert this->_actIndices.count()==this->actIds.count()
	int i;
	for(i=0; i<r.nInternalActivities; i++)
		if(req.contains(r.internalActivitiesList[i].id))
			this->_activitiesIndices.append(i);*/

	//////////////////////
	assert(this->selectedDays.count()==this->selectedHours.count());

	for(int k=0; k<this->selectedDays.count(); k++){
		if(this->selectedDays.at(k) >= r.nDaysPerWeek){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint max total activities from set in selected time slots is wrong because it refers to removed day. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));

			return false;
		}
		if(this->selectedHours.at(k) == r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint max total activities from set in selected time slots is wrong because an hour is too late (after the last acceptable slot). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));

			return false;
		}
		if(this->selectedHours.at(k) > r.nHoursPerDay){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint max total activities from set in selected time slots is wrong because it refers to removed hour. Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));

			return false;
		}
		if(this->selectedDays.at(k)<0 || this->selectedHours.at(k)<0){
			TimeConstraintIrreconcilableMessage::information(parent, tr("FET information"),
			 tr("Constraint max total activities from set in selected time slots is wrong because hour or day is not specified for a slot (-1). Please correct"
			 " and try again. Correcting means editing the constraint and updating information. Constraint is:\n%1").arg(this->getDetailedDescription(r)));

			return false;
		}
	}
	///////////////////////

	if(this->_activitiesIndices.count()>0)
		return true;
	else{
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to no activities). Please correct it:\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}
}

bool ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots::hasInactiveActivities(Rules& r)
{
	//returns true if all activities are inactive

	for(int aid : std::as_const(this->activitiesIds))
		if(!r.inactiveActivities.contains(aid))
			return false;

	return true;
}

QString ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots::getXmlDescription(Rules& r)
{
	assert(this->selectedDays.count()==this->selectedHours.count());

	QString s=IL2+"<ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots>\n";

	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";

	s+=IL3+"<Number_of_Activities>"+QString::number(this->activitiesIds.count())+"</Number_of_Activities>\n";
	for(int aid : std::as_const(this->activitiesIds))
		s+=IL3+"<Activity_Id>"+CustomFETString::number(aid)+"</Activity_Id>\n";

	s+=IL3+"<Number_of_Selected_Time_Slots>"+QString::number(this->selectedDays.count())+"</Number_of_Selected_Time_Slots>\n";
	for(int i=0; i<this->selectedDays.count(); i++){
		s+=IL3+"<Selected_Time_Slot>\n";
		s+=IL4+"<Day>"+protect(r.daysOfTheWeek[this->selectedDays.at(i)])+"</Day>\n";
		s+=IL4+"<Hour>"+protect(r.hoursOfTheDay[this->selectedHours.at(i)])+"</Hour>\n";
		s+=IL3+"</Selected_Time_Slot>\n";
	}
	s+=IL3+"<Max_Total_Number_of_Activities>"+CustomFETString::number(this->maxActivities)+"</Max_Total_Number_of_Activities>\n";

	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots>\n";
	return s;
}

QString ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots::getDescription(Rules& r)
{
	QString begin=QString("");
	if(!active)
		begin="X - ";

	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);

	assert(this->selectedDays.count()==this->selectedHours.count());

	QString actids=QString("");
	for(int aid : std::as_const(this->activitiesIds))
		actids+=getActivityDescription(r, aid)+translatedCommaSpace();
	actids.chop(translatedCommaSpace().size());

	QString timeslots=QString("");
	for(int i=0; i<this->selectedDays.count(); i++)
		timeslots+=r.daysOfTheWeek[selectedDays.at(i)]+QString(" ")+r.hoursOfTheDay[selectedHours.at(i)]+translatedCommaSpace();
	timeslots.chop(translatedCommaSpace().size());

	QString s=tr("Max total activities from set in selected time slots, WP:%1%, NA:%2, A: %3, STS: %4, MA:%5", "Constraint description. WP means weight percentage, "
	 "NA means the number of activities, A means activities list, STS means selected time slots, MA means max number of activities.")
	 .arg(CustomFETString::number(this->weightPercentage))
	 .arg(QString::number(this->activitiesIds.count()))
	 .arg(actids)
	 .arg(timeslots)
	 .arg(CustomFETString::number(this->maxActivities));

	return begin+s+end;
}

QString ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	assert(this->selectedDays.count()==this->selectedHours.count());

	/*QString actids=QString("");
	for(int aid : std::as_const(this->activitiesIds))
		actids+=CustomFETString::number(aid)+QString(", ");
	actids.chop(2);*/

	if(!richText){
		QString timeslots=QString("");
		for(int i=0; i<this->selectedDays.count(); i++)
			timeslots+=r.daysOfTheWeek[selectedDays.at(i)]+QString(" ")+r.hoursOfTheDay[selectedHours.at(i)]+translatedCommaSpace();
		timeslots.chop(translatedCommaSpace().size());

		QString s=tr("Time constraint"); s+="\n";
		s+=tr("Max total activities from set in selected time slots"); s+="\n";
		s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage)); s+="\n";
		s+=tr("Number of activities=%1").arg(QString::number(this->activitiesIds.count())); s+="\n";
		for(int id : std::as_const(this->activitiesIds)){
			s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			 .arg(id)
			 .arg(getActivityDetailedDescription(r, id));
			s+="\n";
		}
		s+=tr("Selected time slots: %1").arg(timeslots); s+="\n";
		s+=tr("Maximum total number of activities in selected time slots=%1").arg(CustomFETString::number(this->maxActivities)); s+="\n";

		if(!active){
			s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			s+="\n";
		}
		if(!comments.isEmpty()){
			s+=tr("Comments=%1").arg(comments);
			s+="\n";
		}

		return s;
	}
	else{
		QString begin=tr("Time constraint"); begin+="\n";
		begin+=tr("Max total activities from set in selected time slots"); begin+="\n";
		begin+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage)); begin+="\n";
		begin+=tr("Number of activities=%1").arg(QString::number(this->activitiesIds.count())); begin+="\n";
		for(int id : std::as_const(this->activitiesIds)){
			begin+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
			 .arg(id)
			 .arg(getActivityDetailedDescription(r, id));
			begin+="\n";
		}

		begin+=tr("Selected time slots:"); begin+="\n";
		//the first Boolean is 'direct', the second Boolean is 'not available/selected', the third Boolean is 'color'.
		QString middle=listsOfDaysAndHoursToTable(r, selectedDays, selectedHours, true, false, colors);
		QString end;
		end+="\n";

		end+=tr("Maximum total number of activities in selected time slots=%1").arg(CustomFETString::number(this->maxActivities)); end+="\n";

		if(!active){
			end+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
			end+="\n";
		}
		if(!comments.isEmpty()){
			end+=tr("Comments=%1").arg(comments);
			end+="\n";
		}

		return protect4(begin)+middle+protect4(end);
	}
}

double ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

///////////////////

	QSet<int> selectedTimeSlotsSet;
	for(int i=0; i<this->selectedDays.count(); i++)
		selectedTimeSlotsSet.insert(selectedDays.at(i)+selectedHours.at(i)*r.nDaysPerWeek);

	int cnt=0;
	for(int ai : std::as_const(this->_activitiesIndices)){
		if(c.times[ai]!=UNALLOCATED_TIME){
			Activity* act=&r.internalActivitiesList[ai];
			for(int dur=0; dur<act->duration; dur++){
				if(selectedTimeSlotsSet.contains(c.times[ai]+dur*r.nDaysPerWeek)){
					cnt++;
					break;
				}
			}
		}
	}

	nbroken=0;

	if(cnt > this->maxActivities)
		nbroken++;

	if(nbroken>0){
		if(conflictsString!=nullptr){
			QString s;
			s=tr("Time constraint %1 broken - this should not happen, as this kind of constraint should "
			 "have only 100.0% weight. Please report error!").arg(this->getDescription(r));

			dl.append(s);
			cl.append(weightPercentage/100.0);

			*conflictsString+= s+"\n";
		}
	}

	if(weightPercentage==100.0)
		assert(nbroken==0);
	return nbroken * weightPercentage / 100.0;
}

void ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots::removeUseless(Rules& r)
{
	QList<int> newActs;

	for(int aid : std::as_const(activitiesIds)){
		Activity* act=r.activitiesPointerHash.value(aid, nullptr);
		if(act!=nullptr)
			newActs.append(aid);
	}

	activitiesIds=newActs;

	r.internalStructureComputed=false;
}

void ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots::recomputeActivitiesSet()
{
	activitiesIdsSet=QSet<int>(activitiesIds.constBegin(), activitiesIds.constEnd());
}

bool ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	return activitiesIdsSet.contains(aid);

	//return this->activitiesIds.contains(a->id);
}

bool ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots::hasWrongDayOrHour(Rules& r)
{
	assert(selectedDays.count()==selectedHours.count());

	for(int i=0; i<selectedDays.count(); i++)
		if(selectedDays.at(i)<0 || selectedDays.at(i)>=r.nDaysPerWeek
		 || selectedHours.at(i)<0 || selectedHours.at(i)>=r.nHoursPerDay)
			return true;

	//Do not care about minSimultaneous, which can be as high as MAX_ACTIVITIES

	return false;
}

bool ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));

	return true;
}

bool ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));

	assert(selectedDays.count()==selectedHours.count());

	QList<int> newDays;
	QList<int> newHours;

	for(int i=0; i<selectedDays.count(); i++)
		if(selectedDays.at(i)>=0 && selectedDays.at(i)<r.nDaysPerWeek
		 && selectedHours.at(i)>=0 && selectedHours.at(i)<r.nHoursPerDay){
			newDays.append(selectedDays.at(i));
			newHours.append(selectedHours.at(i));
		}

	selectedDays=newDays;
	selectedHours=newHours;

	//Do not modify minSimultaneous, which can be as high as MAX_ACTIVITIES

	r.internalStructureComputed=false;
	setRulesModifiedAndOtherThings(&r);

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivitiesMaxInATerm::ConstraintActivitiesMaxInATerm()
	: TimeConstraint()
{
	this->type = CONSTRAINT_ACTIVITIES_MAX_IN_A_TERM;
}

ConstraintActivitiesMaxInATerm::ConstraintActivitiesMaxInATerm(double wp,
	const QList<int>& a_L, int max_acts)
	: TimeConstraint(wp)
{
	this->activitiesIds=a_L;
	this->maxActivitiesInATerm=max_acts;

	this->type=CONSTRAINT_ACTIVITIES_MAX_IN_A_TERM;
}

bool ConstraintActivitiesMaxInATerm::computeInternalStructure(QWidget* parent, Rules& r)
{
	//this cares about inactive activities, also, so do not assert this->_actIndices.count()==this->actIds.count()
	_activitiesIndices.clear();
	for(int id : std::as_const(activitiesIds)){
		int i=r.activitiesHash.value(id, -1);
		if(i>=0)
			_activitiesIndices.append(i);
	}

	/*this->_activitiesIndices.clear();

	QSet<int> req=this->activitiesIds.toSet();
	assert(req.count()==this->activitiesIds.count());

	//this cares about inactive activities, also, so do not assert this->_actIndices.count()==this->actIds.count()
	int i;
	for(i=0; i<r.nInternalActivities; i++)
		if(req.contains(r.internalActivitiesList[i].id))
			this->_activitiesIndices.append(i);*/

	if(this->_activitiesIndices.count()>0)
		return true;
	else{
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to no activities). Please correct it:\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}
}

bool ConstraintActivitiesMaxInATerm::hasInactiveActivities(Rules& r)
{
	//returns true if all activities are inactive

	for(int aid : std::as_const(this->activitiesIds))
		if(!r.inactiveActivities.contains(aid))
			return false;

	return true;
}

QString ConstraintActivitiesMaxInATerm::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintActivitiesMaxInATerm>\n";

	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";

	s+=IL3+"<Number_of_Activities>"+QString::number(this->activitiesIds.count())+"</Number_of_Activities>\n";
	for(int aid : std::as_const(this->activitiesIds))
		s+=IL3+"<Activity_Id>"+CustomFETString::number(aid)+"</Activity_Id>\n";

	s+=IL3+"<Max_Number_of_Activities_in_A_Term>"+CustomFETString::number(this->maxActivitiesInATerm)+"</Max_Number_of_Activities_in_A_Term>\n";

	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivitiesMaxInATerm>\n";
	return s;
}

QString ConstraintActivitiesMaxInATerm::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";

	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);

	QString actids=QString("");
	for(int aid : std::as_const(this->activitiesIds))
		actids+=getActivityDescription(r, aid)+translatedCommaSpace();
	actids.chop(translatedCommaSpace().size());

	QString s=tr("Activities max in a term, WP:%1%, NA:%2, A: %3, MAIAT:%4", "Constraint description. WP means weight percentage, "
	 "NA means the number of activities, A means activities list, MAIAT means max activities in a term")
	 .arg(CustomFETString::number(this->weightPercentage))
	 .arg(QString::number(this->activitiesIds.count()))
	 .arg(actids)
	 .arg(CustomFETString::number(this->maxActivitiesInATerm));

	return begin+s+end;
}

QString ConstraintActivitiesMaxInATerm::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(colors);

	/*QString actids=QString("");
	for(int aid : std::as_const(this->activitiesIds))
		actids+=CustomFETString::number(aid)+QString(", ");
	actids.chop(2);*/

	QString s=tr("Time constraint"); s+="\n";
	s+=tr("Activities max in a term"); s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage)); s+="\n";
	s+=tr("Number of activities=%1").arg(QString::number(this->activitiesIds.count())); s+="\n";
	for(int id : std::as_const(this->activitiesIds)){
		s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
		 .arg(id)
		 .arg(getActivityDetailedDescription(r, id));
		s+="\n";
	}
	s+=tr("Maximum number of activities in a term=%1").arg(CustomFETString::number(this->maxActivitiesInATerm)); s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintActivitiesMaxInATerm::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

	Matrix1D<int> cnt;
	cnt.resize(r.nTerms);
	for(int i=0; i<r.nTerms; i++)
		cnt[i]=0;
	for(int ai : std::as_const(this->_activitiesIndices))
		if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek;
			int term=d/r.nDaysPerTerm;
			cnt[term]++;
		}

	nbroken=0;

	for(int i=0; i<r.nTerms; i++)
		if(cnt[i]>maxActivitiesInATerm)
			nbroken++;

	if(nbroken>0){
		if(conflictsString!=nullptr){
			QString s=tr("Time constraint %1 broken - this should not happen, as this kind of constraint should "
			 "have only 100.0% weight. Please report error!").arg(this->getDescription(r));

			dl.append(s);
			cl.append(weightPercentage/100.0);

			*conflictsString+= s+"\n";
		}
	}

	if(weightPercentage==100.0)
		assert(nbroken==0);
	return nbroken * weightPercentage / 100.0;
}

void ConstraintActivitiesMaxInATerm::removeUseless(Rules& r)
{
	QList<int> newActs;

	for(int aid : std::as_const(activitiesIds)){
		Activity* act=r.activitiesPointerHash.value(aid, nullptr);
		if(act!=nullptr)
			newActs.append(aid);
	}

	activitiesIds=newActs;

	r.internalStructureComputed=false;
}

void ConstraintActivitiesMaxInATerm::recomputeActivitiesSet()
{
	activitiesIdsSet=QSet<int>(activitiesIds.constBegin(), activitiesIds.constEnd());
}

bool ConstraintActivitiesMaxInATerm::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	return activitiesIdsSet.contains(aid);

	//return this->activitiesIds.contains(a->id);
}

bool ConstraintActivitiesMaxInATerm::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivitiesMaxInATerm::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesMaxInATerm::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesMaxInATerm::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintActivitiesMaxInATerm::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivitiesMaxInATerm::hasWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);

	return false;
}

bool ConstraintActivitiesMaxInATerm::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));

	return true;
}

bool ConstraintActivitiesMaxInATerm::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintActivitiesOccupyMaxTerms::ConstraintActivitiesOccupyMaxTerms()
	: TimeConstraint()
{
	this->type = CONSTRAINT_ACTIVITIES_OCCUPY_MAX_TERMS;
}

ConstraintActivitiesOccupyMaxTerms::ConstraintActivitiesOccupyMaxTerms(double wp,
	const QList<int>& a_L, int max_occupied)
	: TimeConstraint(wp)
{
	this->activitiesIds=a_L;
	this->maxOccupiedTerms=max_occupied;

	this->type=CONSTRAINT_ACTIVITIES_OCCUPY_MAX_TERMS;
}

bool ConstraintActivitiesOccupyMaxTerms::computeInternalStructure(QWidget* parent, Rules& r)
{
	//this cares about inactive activities, also, so do not assert this->_actIndices.count()==this->actIds.count()
	_activitiesIndices.clear();
	for(int id : std::as_const(activitiesIds)){
		int i=r.activitiesHash.value(id, -1);
		if(i>=0)
			_activitiesIndices.append(i);
	}

	/*this->_activitiesIndices.clear();

	QSet<int> req=this->activitiesIds.toSet();
	assert(req.count()==this->activitiesIds.count());

	//this cares about inactive activities, also, so do not assert this->_actIndices.count()==this->actIds.count()
	int i;
	for(i=0; i<r.nInternalActivities; i++)
		if(req.contains(r.internalActivitiesList[i].id))
			this->_activitiesIndices.append(i);*/

	if(this->_activitiesIndices.count()>0)
		return true;
	else{
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET error in data"),
			tr("Following constraint is wrong (refers to no activities). Please correct it:\n%1").arg(this->getDetailedDescription(r)));
		return false;
	}
}

bool ConstraintActivitiesOccupyMaxTerms::hasInactiveActivities(Rules& r)
{
	//returns true if all activities are inactive

	for(int aid : std::as_const(this->activitiesIds))
		if(!r.inactiveActivities.contains(aid))
			return false;

	return true;
}

QString ConstraintActivitiesOccupyMaxTerms::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintActivitiesOccupyMaxTerms>\n";

	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";

	s+=IL3+"<Number_of_Activities>"+QString::number(this->activitiesIds.count())+"</Number_of_Activities>\n";
	for(int aid : std::as_const(this->activitiesIds))
		s+=IL3+"<Activity_Id>"+CustomFETString::number(aid)+"</Activity_Id>\n";

	s+=IL3+"<Max_Number_of_Occupied_Terms>"+CustomFETString::number(this->maxOccupiedTerms)+"</Max_Number_of_Occupied_Terms>\n";

	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintActivitiesOccupyMaxTerms>\n";
	return s;
}

QString ConstraintActivitiesOccupyMaxTerms::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";

	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);

	QString actids=QString("");
	for(int aid : std::as_const(this->activitiesIds))
		actids+=getActivityDescription(r, aid)+translatedCommaSpace();
	actids.chop(translatedCommaSpace().size());

	QString s=tr("Activities occupy max terms, WP:%1%, NA:%2, A: %3, MOT:%4", "Constraint description. WP means weight percentage, "
	 "NA means the number of activities, A means activities list, MOT means max occupied terms")
	 .arg(CustomFETString::number(this->weightPercentage))
	 .arg(QString::number(this->activitiesIds.count()))
	 .arg(actids)
	 .arg(CustomFETString::number(this->maxOccupiedTerms));

	return begin+s+end;
}

QString ConstraintActivitiesOccupyMaxTerms::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(colors);

	/*QString actids=QString("");
	for(int aid : std::as_const(this->activitiesIds))
		actids+=CustomFETString::number(aid)+QString(", ");
	actids.chop(2);*/

	QString s=tr("Time constraint"); s+="\n";
	s+=tr("Activities occupy max terms"); s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage)); s+="\n";
	s+=tr("Number of activities=%1").arg(QString::number(this->activitiesIds.count())); s+="\n";
	for(int id : std::as_const(this->activitiesIds)){
		s+=tr("Activity with id=%1 (%2)", "%1 is the id, %2 is the detailed description of the activity")
		 .arg(id)
		 .arg(getActivityDetailedDescription(r, id));
		s+="\n";
	}
	s+=tr("Maximum number of occupied terms=%1").arg(CustomFETString::number(this->maxOccupiedTerms)); s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintActivitiesOccupyMaxTerms::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;

	assert(r.internalStructureComputed);

	Matrix1D<bool> occupiedTerm;
	occupiedTerm.resize(r.nTerms);
	for(int i=0; i<r.nTerms; i++)
		occupiedTerm[i]=false;
	for(int ai : std::as_const(this->_activitiesIndices))
		if(c.times[ai]!=UNALLOCATED_TIME){
			int d=c.times[ai]%r.nDaysPerWeek;
			int term=d/r.nDaysPerTerm;
			occupiedTerm[term]=true;
		}

	nbroken=0;

	int cnt=0;
	for(int i=0; i<r.nTerms; i++)
		if(occupiedTerm[i])
			cnt++;

	if(cnt>maxOccupiedTerms)
		nbroken++;

	if(nbroken>0){
		if(conflictsString!=nullptr){
			QString s=tr("Time constraint %1 broken - this should not happen, as this kind of constraint should "
			 "have only 100.0% weight. Please report error!").arg(this->getDescription(r));

			dl.append(s);
			cl.append(weightPercentage/100.0);

			*conflictsString+= s+"\n";
		}
	}

	if(weightPercentage==100.0)
		assert(nbroken==0);
	return nbroken * weightPercentage / 100.0;
}

void ConstraintActivitiesOccupyMaxTerms::removeUseless(Rules& r)
{
	QList<int> newActs;

	for(int aid : std::as_const(activitiesIds)){
		Activity* act=r.activitiesPointerHash.value(aid, nullptr);
		if(act!=nullptr)
			newActs.append(aid);
	}

	activitiesIds=newActs;

	r.internalStructureComputed=false;
}

void ConstraintActivitiesOccupyMaxTerms::recomputeActivitiesSet()
{
	activitiesIdsSet=QSet<int>(activitiesIds.constBegin(), activitiesIds.constEnd());
}

bool ConstraintActivitiesOccupyMaxTerms::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);

	return activitiesIdsSet.contains(aid);

	//return this->activitiesIds.contains(a->id);
}

bool ConstraintActivitiesOccupyMaxTerms::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintActivitiesOccupyMaxTerms::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesOccupyMaxTerms::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintActivitiesOccupyMaxTerms::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintActivitiesOccupyMaxTerms::categoryOfTimeConstraint()
{
	return IS_ACTIVITY_TIME_CONSTRAINT;
}

bool ConstraintActivitiesOccupyMaxTerms::hasWrongDayOrHour(Rules& r)
{
	Q_UNUSED(r);

	return false;
}

bool ConstraintActivitiesOccupyMaxTerms::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));

	return true;
}

bool ConstraintActivitiesOccupyMaxTerms::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsSetMaxDaysPerWeek::ConstraintStudentsSetMaxDaysPerWeek()
	: TimeConstraint()
{
	this->type=CONSTRAINT_STUDENTS_SET_MAX_DAYS_PER_WEEK;
}

ConstraintStudentsSetMaxDaysPerWeek::ConstraintStudentsSetMaxDaysPerWeek(double wp, int maxnd, const QString& sn)
	 : TimeConstraint(wp)
{
	this->students = sn;
	this->maxDaysPerWeek=maxnd;
	this->type=CONSTRAINT_STUDENTS_SET_MAX_DAYS_PER_WEEK;
}

bool ConstraintStudentsSetMaxDaysPerWeek::computeInternalStructure(QWidget* parent, Rules& r)
{
	//StudentsSet* ss=r.searchAugmentedStudentsSet(this->students);
	StudentsSet* ss=r.studentsHash.value(students, nullptr);

	if(ss==nullptr){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students set max days per week is wrong because it refers to nonexistent students set."
		 " Please correct it (removing it might be a solution). Please report potential bug. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
		return false;
	}

	assert(ss!=nullptr);

	populateInternalSubgroupsList(r, ss, this->iSubgroupsList);
	/*this->iSubgroupsList.clear();
	if(ss->type==STUDENTS_SUBGROUP){
		int tmp;
		tmp=((StudentsSubgroup*)ss)->indexInInternalSubgroupsList;
		assert(tmp>=0);
		assert(tmp<r.nInternalSubgroups);
		if(!this->iSubgroupsList.contains(tmp))
			this->iSubgroupsList.append(tmp);
	}
	else if(ss->type==STUDENTS_GROUP){
		StudentsGroup* stg=(StudentsGroup*)ss;
		for(int i=0; i<stg->subgroupsList.size(); i++){
			StudentsSubgroup* sts=stg->subgroupsList[i];
			int tmp;
			tmp=sts->indexInInternalSubgroupsList;
			assert(tmp>=0);
			assert(tmp<r.nInternalSubgroups);
			if(!this->iSubgroupsList.contains(tmp))
				this->iSubgroupsList.append(tmp);
		}
	}
	else if(ss->type==STUDENTS_YEAR){
		StudentsYear* sty=(StudentsYear*)ss;
		for(int i=0; i<sty->groupsList.size(); i++){
			StudentsGroup* stg=sty->groupsList[i];
			for(int j=0; j<stg->subgroupsList.size(); j++){
				StudentsSubgroup* sts=stg->subgroupsList[j];
				int tmp;
				tmp=sts->indexInInternalSubgroupsList;
				assert(tmp>=0);
				assert(tmp<r.nInternalSubgroups);
				if(!this->iSubgroupsList.contains(tmp))
					this->iSubgroupsList.append(tmp);
			}
		}
	}
	else
		assert(0);*/
		
	return true;
}

bool ConstraintStudentsSetMaxDaysPerWeek::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsSetMaxDaysPerWeek::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsSetMaxDaysPerWeek>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Students>"+protect(this->students)+"</Students>\n";
	s+=IL3+"<Max_Days_Per_Week>"+CustomFETString::number(this->maxDaysPerWeek)+"</Max_Days_Per_Week>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsSetMaxDaysPerWeek>\n";
	return s;
}

QString ConstraintStudentsSetMaxDaysPerWeek::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s=tr("Students set max days per week");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Abbreviation for weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("St:%1", "Abbreviation for students (sets)").arg(this->students);s+=translatedCommaSpace();
	s+=tr("MD:%1", "Abbreviation for max days").arg(this->maxDaysPerWeek);

	return begin+s+end;
}

QString ConstraintStudentsSetMaxDaysPerWeek::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A students set must respect the maximum number of days per week");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Students set=%1").arg(this->students);s+="\n";

	s+=tr("Maximum days per week=%1").arg(this->maxDaysPerWeek);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintStudentsSetMaxDaysPerWeek::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);
		
		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;
	
	nbroken=0;
	
	Matrix1D<bool> ocDay;
	ocDay.resize(r.nDaysPerWeek);
	for(int sbg : std::as_const(this->iSubgroupsList)){
		for(int d=0; d<r.nDaysPerWeek; d++){
			ocDay[d]=false;
			for(int h=0; h<r.nHoursPerDay; h++){
				if(subgroupsMatrix[sbg][d][h]>0){
					ocDay[d]=true;
				}
			}
		}
		int nOcDays=0;
		for(int d=0; d<r.nDaysPerWeek; d++)
			if(ocDay[d])
				nOcDays++;
		if(nOcDays > this->maxDaysPerWeek){
			nbroken+=nOcDays-this->maxDaysPerWeek;

			if((nOcDays-this->maxDaysPerWeek)>0){
				QString s= tr("Time constraint students set max days per week broken for subgroup: %1, allowed %2 days, required %3 days.")
				 .arg(r.internalSubgroupsList[sbg]->name)
				 .arg(this->maxDaysPerWeek)
				 .arg(nOcDays);
				s+=" ";
				s += tr("This increases the conflicts total by %1")
				 .arg(CustomFETString::numberPlusTwoDigitsPrecision((nOcDays-this->maxDaysPerWeek)*weightPercentage/100));
			
				dl.append(s);
				cl.append((nOcDays-this->maxDaysPerWeek)*weightPercentage/100);
		
				*conflictsString += s+"\n";
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintStudentsSetMaxDaysPerWeek::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsSetMaxDaysPerWeek::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);
	return false;
}

bool ConstraintStudentsSetMaxDaysPerWeek::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetMaxDaysPerWeek::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetMaxDaysPerWeek::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	return r.setsShareStudents(this->students, s);
}

int ConstraintStudentsSetMaxDaysPerWeek::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsSetMaxDaysPerWeek::hasWrongDayOrHour(Rules& r)
{
	if(this->maxDaysPerWeek>r.nDaysPerWeek)
		return true;
	
	return false;
}

bool ConstraintStudentsSetMaxDaysPerWeek::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));

	return true;
}

bool ConstraintStudentsSetMaxDaysPerWeek::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));

	if(this->maxDaysPerWeek>r.nDaysPerWeek)
		this->maxDaysPerWeek=r.nDaysPerWeek;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsMaxDaysPerWeek::ConstraintStudentsMaxDaysPerWeek()
	: TimeConstraint()
{
	this->type=CONSTRAINT_STUDENTS_MAX_DAYS_PER_WEEK;
}

ConstraintStudentsMaxDaysPerWeek::ConstraintStudentsMaxDaysPerWeek(double wp, int maxnd)
	 : TimeConstraint(wp)
{
	this->maxDaysPerWeek=maxnd;
	this->type=CONSTRAINT_STUDENTS_MAX_DAYS_PER_WEEK;
}

bool ConstraintStudentsMaxDaysPerWeek::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);
	Q_UNUSED(r);

	return true;
}

bool ConstraintStudentsMaxDaysPerWeek::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsMaxDaysPerWeek::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsMaxDaysPerWeek>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Max_Days_Per_Week>"+CustomFETString::number(this->maxDaysPerWeek)+"</Max_Days_Per_Week>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsMaxDaysPerWeek>\n";
	return s;
}

QString ConstraintStudentsMaxDaysPerWeek::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s=tr("Students max days per week");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Abbreviation for weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("MD:%1", "Abbreviation for max days").arg(this->maxDaysPerWeek);

	return begin+s+end;
}

QString ConstraintStudentsMaxDaysPerWeek::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All students must respect the maximum number of days per week");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Maximum days per week=%1").arg(this->maxDaysPerWeek);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintStudentsMaxDaysPerWeek::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	int nbroken;
	
	nbroken=0;
	
	Matrix1D<bool> ocDay;
	ocDay.resize(r.nDaysPerWeek);
	for(int sbg=0; sbg<r.nInternalSubgroups; sbg++){
		for(int d=0; d<r.nDaysPerWeek; d++){
			ocDay[d]=false;
			for(int h=0; h<r.nHoursPerDay; h++){
				if(subgroupsMatrix[sbg][d][h]>0){
					ocDay[d]=true;
				}
			}
		}
		int nOcDays=0;
		for(int d=0; d<r.nDaysPerWeek; d++)
			if(ocDay[d])
				nOcDays++;
		if(nOcDays > this->maxDaysPerWeek){
			nbroken+=nOcDays-this->maxDaysPerWeek;

			if((nOcDays-this->maxDaysPerWeek)>0){
				QString s= tr("Time constraint students max days per week broken for subgroup: %1, allowed %2 days, required %3 days.")
				 .arg(r.internalSubgroupsList[sbg]->name)
				 .arg(this->maxDaysPerWeek)
				 .arg(nOcDays);
				s+=" ";
				s += tr("This increases the conflicts total by %1")
				 .arg(CustomFETString::numberPlusTwoDigitsPrecision((nOcDays-this->maxDaysPerWeek)*weightPercentage/100));
			
				dl.append(s);
				cl.append((nOcDays-this->maxDaysPerWeek)*weightPercentage/100);
		
				*conflictsString += s+"\n";
			}
		}
	}

	if(weightPercentage==100)
		assert(nbroken==0);
	return weightPercentage/100 * nbroken;
}

bool ConstraintStudentsMaxDaysPerWeek::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsMaxDaysPerWeek::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);
	return false;
}

bool ConstraintStudentsMaxDaysPerWeek::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsMaxDaysPerWeek::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsMaxDaysPerWeek::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);
	return true;
}

int ConstraintStudentsMaxDaysPerWeek::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsMaxDaysPerWeek::hasWrongDayOrHour(Rules& r)
{
	if(this->maxDaysPerWeek>r.nDaysPerWeek)
		return true;
	
	return false;
}

bool ConstraintStudentsMaxDaysPerWeek::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsMaxDaysPerWeek::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));

	if(this->maxDaysPerWeek>r.nDaysPerWeek)
		this->maxDaysPerWeek=r.nDaysPerWeek;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeacherMaxSpanPerDay::ConstraintTeacherMaxSpanPerDay()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHER_MAX_SPAN_PER_DAY;
	this->maxSpanPerDay = -1;
	allowOneDayExceptionPlusOne=false;
}

ConstraintTeacherMaxSpanPerDay::ConstraintTeacherMaxSpanPerDay(double wp, int maxspan, bool except, const QString& teacher)
 : TimeConstraint(wp)
 {
	assert(maxspan>0);
	this->maxSpanPerDay=maxspan;
	this->teacherName=teacher;

	allowOneDayExceptionPlusOne=except;

	this->type=CONSTRAINT_TEACHER_MAX_SPAN_PER_DAY;
}

bool ConstraintTeacherMaxSpanPerDay::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);

	//this->teacher_ID=r.searchTeacher(this->teacherName);
	teacher_ID=r.teachersHash.value(teacherName, -1);
	assert(this->teacher_ID>=0);
	return true;
}

bool ConstraintTeacherMaxSpanPerDay::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeacherMaxSpanPerDay::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeacherMaxSpanPerDay>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Teacher>"+protect(this->teacherName)+"</Teacher>\n";
	s+=IL3+"<Max_Span>"+CustomFETString::number(this->maxSpanPerDay)+"</Max_Span>\n";
	s+=IL3+"<Allow_One_Day_Exception_of_Plus_One>"+trueFalse(allowOneDayExceptionPlusOne)+"</Allow_One_Day_Exception_of_Plus_One>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeacherMaxSpanPerDay>\n";
	return s;
}

QString ConstraintTeacherMaxSpanPerDay::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teacher max span per day");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("T:%1", "Teacher").arg(this->teacherName);s+=translatedCommaSpace();
	s+=tr("MS:%1", "Maximum span (in hours, per day)").arg(this->maxSpanPerDay);s+=translatedCommaSpace();
	s+=tr("ODE:%1", "One day exception (in which the teacher can have span+1)").arg(yesNoTranslated(this->allowOneDayExceptionPlusOne));

	return begin+s+end;
}

QString ConstraintTeacherMaxSpanPerDay::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A teacher must respect the maximum number of span (in hours) per day");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Teacher=%1").arg(this->teacherName);s+="\n";
	s+=tr("Maximum span per day=%1").arg(this->maxSpanPerDay);s+="\n";
	s+=tr("Allow one day exception of plus one=%1").arg(yesNoTranslated(this->allowOneDayExceptionPlusOne));s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeacherMaxSpanPerDay::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	Q_UNUSED(cl);
	Q_UNUSED(dl);
	Q_UNUSED(conflictsString);

	assert(this->weightPercentage==100.0);
	
	int nbroken=0;
	
	bool except;
	if(allowOneDayExceptionPlusOne)
		except=true;
	else
		except=false;
	
	for(int d=0; d<r.nDaysPerWeek; d++){
		int begin=-1;
		int end=-1;
		for(int h=0; h<r.nHoursPerDay; h++)
			if(teachersMatrix[this->teacher_ID][d][h]>0){
				begin=h;
				break;
			}
		for(int h=r.nHoursPerDay-1; h>=0; h--)
			if(teachersMatrix[this->teacher_ID][d][h]>0){
				end=h;
				break;
			}
		if(end>=0 && begin>=0 && end>=begin){
			int span=end-begin+1;
			if(span>this->maxSpanPerDay){
				if(except && span==maxSpanPerDay+1)
					except=false;
				else
					nbroken++;
			}
		}
	}
	
	assert(nbroken==0);
	
	return nbroken;
}

bool ConstraintTeacherMaxSpanPerDay::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeacherMaxSpanPerDay::isRelatedToTeacher(const QString& t)
{
	if(this->teacherName==t)
		return true;
	return false;
}

bool ConstraintTeacherMaxSpanPerDay::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMaxSpanPerDay::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMaxSpanPerDay::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeacherMaxSpanPerDay::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeacherMaxSpanPerDay::hasWrongDayOrHour(Rules& r)
{
	if(maxSpanPerDay>r.nHoursPerDay)
		return true;
		
	return false;
}

bool ConstraintTeacherMaxSpanPerDay::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeacherMaxSpanPerDay::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxSpanPerDay>r.nHoursPerDay)
		maxSpanPerDay=r.nHoursPerDay;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeachersMaxSpanPerDay::ConstraintTeachersMaxSpanPerDay()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHERS_MAX_SPAN_PER_DAY;
	this->maxSpanPerDay = -1;
	allowOneDayExceptionPlusOne=false;
}

ConstraintTeachersMaxSpanPerDay::ConstraintTeachersMaxSpanPerDay(double wp, int maxspan, bool except)
 : TimeConstraint(wp)
 {
	assert(maxspan>0);
	this->maxSpanPerDay=maxspan;
	
	allowOneDayExceptionPlusOne=except;

	this->type=CONSTRAINT_TEACHERS_MAX_SPAN_PER_DAY;
}

bool ConstraintTeachersMaxSpanPerDay::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);
	Q_UNUSED(r);

	return true;
}

bool ConstraintTeachersMaxSpanPerDay::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeachersMaxSpanPerDay::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeachersMaxSpanPerDay>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Max_Span>"+CustomFETString::number(this->maxSpanPerDay)+"</Max_Span>\n";
	s+=IL3+"<Allow_One_Day_Exception_of_Plus_One>"+trueFalse(allowOneDayExceptionPlusOne)+"</Allow_One_Day_Exception_of_Plus_One>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeachersMaxSpanPerDay>\n";
	return s;
}

QString ConstraintTeachersMaxSpanPerDay::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teachers max span per day");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("MS:%1", "Maximum span (in hours, per day)").arg(this->maxSpanPerDay);s+=translatedCommaSpace();
	s+=tr("ODE:%1", "One day exception (in which the teachers can have span+1)").arg(yesNoTranslated(this->allowOneDayExceptionPlusOne));

	return begin+s+end;
}

QString ConstraintTeachersMaxSpanPerDay::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All teachers must respect the maximum number of span (in hours) per day");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Maximum span per day=%1").arg(this->maxSpanPerDay);s+="\n";
	s+=tr("Allow one day exception of plus one=%1").arg(yesNoTranslated(this->allowOneDayExceptionPlusOne));s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeachersMaxSpanPerDay::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	Q_UNUSED(cl);
	Q_UNUSED(dl);
	Q_UNUSED(conflictsString);

	assert(this->weightPercentage==100.0);
	
	int nbroken=0;
	
	for(int tch=0; tch<r.nInternalTeachers; tch++){
		bool except;
		if(allowOneDayExceptionPlusOne)
			except=true;
		else
			except=false;

		for(int d=0; d<r.nDaysPerWeek; d++){
			int begin=-1;
			int end=-1;
			for(int h=0; h<r.nHoursPerDay; h++)
				if(teachersMatrix[tch][d][h]>0){
					begin=h;
					break;
				}
			for(int h=r.nHoursPerDay-1; h>=0; h--)
				if(teachersMatrix[tch][d][h]>0){
					end=h;
					break;
				}
			if(end>=0 && begin>=0 && end>=begin){
				int span=end-begin+1;
				if(span>this->maxSpanPerDay){
					if(except && span==maxSpanPerDay+1)
						except=false;
					else
						nbroken++;
				}
			}
		}
	}
	
	assert(nbroken==0);
	
	return nbroken;
}

bool ConstraintTeachersMaxSpanPerDay::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeachersMaxSpanPerDay::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return true;
}

bool ConstraintTeachersMaxSpanPerDay::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMaxSpanPerDay::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMaxSpanPerDay::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeachersMaxSpanPerDay::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeachersMaxSpanPerDay::hasWrongDayOrHour(Rules& r)
{
	if(maxSpanPerDay>r.nHoursPerDay)
		return true;
		
	return false;
}

bool ConstraintTeachersMaxSpanPerDay::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeachersMaxSpanPerDay::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxSpanPerDay>r.nHoursPerDay)
		maxSpanPerDay=r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsSetMaxSpanPerDay::ConstraintStudentsSetMaxSpanPerDay()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_SET_MAX_SPAN_PER_DAY;
	this->maxSpanPerDay = -1;
}

ConstraintStudentsSetMaxSpanPerDay::ConstraintStudentsSetMaxSpanPerDay(double wp, int maxspan, const QString& sn)
	: TimeConstraint(wp)
{
	this->maxSpanPerDay = maxspan;
	this->students = sn;
	this->type = CONSTRAINT_STUDENTS_SET_MAX_SPAN_PER_DAY;
}

bool ConstraintStudentsSetMaxSpanPerDay::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsSetMaxSpanPerDay::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsSetMaxSpanPerDay>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Max_Span>"+CustomFETString::number(this->maxSpanPerDay)+"</Max_Span>\n";
	s+=IL3+"<Students>"+protect(this->students)+"</Students>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsSetMaxSpanPerDay>\n";
	return s;
}

QString ConstraintStudentsSetMaxSpanPerDay::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Students set max span per day");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("St:%1", "Students (set)").arg(this->students); s+=translatedCommaSpace();
	s+=tr("MS:%1", "Max span (in hours, per day)").arg(this->maxSpanPerDay);

	return begin+s+end;
}

QString ConstraintStudentsSetMaxSpanPerDay::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);
	
	QString s=tr("Time constraint");s+="\n";
	s+=tr("A students set must respect the maximum number of span (in hours) per day");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Students set=%1").arg(this->students);s+="\n";
	s+=tr("Maximum span per day=%1").arg(this->maxSpanPerDay);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

bool ConstraintStudentsSetMaxSpanPerDay::computeInternalStructure(QWidget* parent, Rules& r)
{
	//StudentsSet* ss=r.searchAugmentedStudentsSet(this->students);
	StudentsSet* ss=r.studentsHash.value(students, nullptr);
	
	if(ss==nullptr){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students set max span per day is wrong because it refers to nonexistent students set."
		 " Please correct it (removing it might be a solution). Please report potential bug. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
		return false;
	}

	assert(ss!=nullptr);

	populateInternalSubgroupsList(r, ss, this->iSubgroupsList);
	/*this->iSubgroupsList.clear();
	if(ss->type==STUDENTS_SUBGROUP){
		int tmp;
		tmp=((StudentsSubgroup*)ss)->indexInInternalSubgroupsList;
		assert(tmp>=0);
		assert(tmp<r.nInternalSubgroups);
		if(!this->iSubgroupsList.contains(tmp))
			this->iSubgroupsList.append(tmp);
	}
	else if(ss->type==STUDENTS_GROUP){
		StudentsGroup* stg=(StudentsGroup*)ss;
		for(int i=0; i<stg->subgroupsList.size(); i++){
			StudentsSubgroup* sts=stg->subgroupsList[i];
			int tmp;
			tmp=sts->indexInInternalSubgroupsList;
			assert(tmp>=0);
			assert(tmp<r.nInternalSubgroups);
			if(!this->iSubgroupsList.contains(tmp))
				this->iSubgroupsList.append(tmp);
		}
	}
	else if(ss->type==STUDENTS_YEAR){
		StudentsYear* sty=(StudentsYear*)ss;
		for(int i=0; i<sty->groupsList.size(); i++){
			StudentsGroup* stg=sty->groupsList[i];
			for(int j=0; j<stg->subgroupsList.size(); j++){
				StudentsSubgroup* sts=stg->subgroupsList[j];
				int tmp;
				tmp=sts->indexInInternalSubgroupsList;
				assert(tmp>=0);
				assert(tmp<r.nInternalSubgroups);
				if(!this->iSubgroupsList.contains(tmp))
					this->iSubgroupsList.append(tmp);
			}
		}
	}
	else
		assert(0);*/
		
	return true;
}

double ConstraintStudentsSetMaxSpanPerDay::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	Q_UNUSED(cl);
	Q_UNUSED(dl);
	Q_UNUSED(conflictsString);

	assert(this->weightPercentage==100.0);
	
	int nbroken=0;
	
	for(int sbg : std::as_const(this->iSubgroupsList)){
		for(int d=0; d<r.nDaysPerWeek; d++){
			int begin=-1;
			int end=-1;
			for(int h=0; h<r.nHoursPerDay; h++)
				if(subgroupsMatrix[sbg][d][h]>0){
					begin=h;
					break;
				}
			for(int h=r.nHoursPerDay-1; h>=0; h--)
				if(subgroupsMatrix[sbg][d][h]>0){
					end=h;
					break;
				}
			if(end>=0 && begin>=0 && end>=begin){
				int span=end-begin+1;
				if(span>this->maxSpanPerDay)
					nbroken++;
			}
		}
	}
	
	assert(nbroken==0);
	
	return nbroken;
}

bool ConstraintStudentsSetMaxSpanPerDay::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsSetMaxSpanPerDay::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsSetMaxSpanPerDay::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetMaxSpanPerDay::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetMaxSpanPerDay::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	return r.setsShareStudents(this->students, s);
}

int ConstraintStudentsSetMaxSpanPerDay::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsSetMaxSpanPerDay::hasWrongDayOrHour(Rules& r)
{
	if(maxSpanPerDay>r.nHoursPerDay)
		return true;
	
	return false;
}

bool ConstraintStudentsSetMaxSpanPerDay::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsSetMaxSpanPerDay::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxSpanPerDay>r.nHoursPerDay)
		maxSpanPerDay=r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsMaxSpanPerDay::ConstraintStudentsMaxSpanPerDay()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_MAX_SPAN_PER_DAY;
	this->maxSpanPerDay = -1;
}

ConstraintStudentsMaxSpanPerDay::ConstraintStudentsMaxSpanPerDay(double wp, int maxspan)
	: TimeConstraint(wp)
{
	this->maxSpanPerDay = maxspan;
	this->type = CONSTRAINT_STUDENTS_MAX_SPAN_PER_DAY;
}

bool ConstraintStudentsMaxSpanPerDay::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsMaxSpanPerDay::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsMaxSpanPerDay>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Max_Span>"+CustomFETString::number(this->maxSpanPerDay)+"</Max_Span>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsMaxSpanPerDay>\n";
	return s;
}

QString ConstraintStudentsMaxSpanPerDay::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Students max span per day");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("MS:%1", "Max span (in hours, per day)").arg(this->maxSpanPerDay);

	return begin+s+end;
}

QString ConstraintStudentsMaxSpanPerDay::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);
	
	QString s=tr("Time constraint");s+="\n";
	s+=tr("All students must respect the maximum number of span (in hours) per day");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Maximum span per day=%1").arg(this->maxSpanPerDay);s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

bool ConstraintStudentsMaxSpanPerDay::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);
	Q_UNUSED(r);
	
	return true;
}

double ConstraintStudentsMaxSpanPerDay::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	Q_UNUSED(cl);
	Q_UNUSED(dl);
	Q_UNUSED(conflictsString);

	assert(this->weightPercentage==100.0);
	
	int nbroken=0;
	
	for(int sbg=0; sbg<r.nInternalSubgroups; sbg++){
		for(int d=0; d<r.nDaysPerWeek; d++){
			int begin=-1;
			int end=-1;
			for(int h=0; h<r.nHoursPerDay; h++)
				if(subgroupsMatrix[sbg][d][h]>0){
					begin=h;
					break;
				}
			for(int h=r.nHoursPerDay-1; h>=0; h--)
				if(subgroupsMatrix[sbg][d][h]>0){
					end=h;
					break;
				}
			if(end>=0 && begin>=0 && end>=begin){
				int span=end-begin+1;
				if(span>this->maxSpanPerDay)
					nbroken++;
			}
		}
	}
	
	assert(nbroken==0);
	
	return nbroken;
}

bool ConstraintStudentsMaxSpanPerDay::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsMaxSpanPerDay::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsMaxSpanPerDay::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsMaxSpanPerDay::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsMaxSpanPerDay::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return true;
}

int ConstraintStudentsMaxSpanPerDay::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsMaxSpanPerDay::hasWrongDayOrHour(Rules& r)
{
	if(maxSpanPerDay>r.nHoursPerDay)
		return true;
		
	return false;
}

bool ConstraintStudentsMaxSpanPerDay::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsMaxSpanPerDay::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(maxSpanPerDay>r.nHoursPerDay)
		maxSpanPerDay=r.nHoursPerDay;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeacherMinRestingHours::ConstraintTeacherMinRestingHours()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHER_MIN_RESTING_HOURS;
	this->minRestingHours=-1;
	this->circular=true;
}

ConstraintTeacherMinRestingHours::ConstraintTeacherMinRestingHours(double wp, int minrestinghours, bool circ, const QString& teacher)
 : TimeConstraint(wp)
 {
	assert(minrestinghours>0);
	this->minRestingHours=minrestinghours;
	this->circular=circ;
	this->teacherName=teacher;

	this->type=CONSTRAINT_TEACHER_MIN_RESTING_HOURS;
}

bool ConstraintTeacherMinRestingHours::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);

	//this->teacher_ID=r.searchTeacher(this->teacherName);
	teacher_ID=r.teachersHash.value(teacherName, -1);
	assert(this->teacher_ID>=0);
	return true;
}

bool ConstraintTeacherMinRestingHours::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeacherMinRestingHours::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeacherMinRestingHours>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Teacher>"+protect(this->teacherName)+"</Teacher>\n";
	s+=IL3+"<Minimum_Resting_Hours>"+CustomFETString::number(this->minRestingHours)+"</Minimum_Resting_Hours>\n";
	s+=IL3+"<Circular>"+trueFalse(circular)+"</Circular>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeacherMinRestingHours>\n";
	return s;
}

QString ConstraintTeacherMinRestingHours::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teacher min resting hours");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("T:%1", "Teacher").arg(this->teacherName);s+=translatedCommaSpace();
	s+=tr("mRH:%1", "Minimum resting hours").arg(this->minRestingHours);s+=translatedCommaSpace();
	s+=tr("C:%1", "Circular").arg(yesNoTranslated(this->circular));

	return begin+s+end;
}

QString ConstraintTeacherMinRestingHours::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("A teacher must respect the minimum resting hours (between days)");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Teacher=%1").arg(this->teacherName);s+="\n";
	s+=tr("Minimum resting hours=%1").arg(this->minRestingHours);s+="\n";
	s+=tr("Circular=%1").arg(yesNoTranslated(circular));s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeacherMinRestingHours::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	Q_UNUSED(cl);
	Q_UNUSED(dl);
	Q_UNUSED(conflictsString);

	assert(this->weightPercentage==100.0);
	
	int nbroken=0;

	for(int d=0; d<=r.nDaysPerWeek-2+(circular?1:0); d++){
		int cnt=0;
		for(int h=r.nHoursPerDay-1; h>=0; h--){
			if(teachersMatrix[this->teacher_ID][d][h]>0)
				break;
			else
				cnt++;
		}
		for(int h=0; h<r.nHoursPerDay; h++){
			if(teachersMatrix[this->teacher_ID][(d+1<=r.nDaysPerWeek-1?d+1:0)][h]>0)
				break;
			else
				cnt++;
		}
		if(cnt < this->minRestingHours)
			nbroken++;
	}
	
	assert(nbroken==0);
	
	return nbroken;
}

bool ConstraintTeacherMinRestingHours::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeacherMinRestingHours::isRelatedToTeacher(const QString& t)
{
	if(this->teacherName==t)
		return true;
	return false;
}

bool ConstraintTeacherMinRestingHours::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMinRestingHours::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeacherMinRestingHours::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeacherMinRestingHours::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeacherMinRestingHours::hasWrongDayOrHour(Rules& r)
{
	if(minRestingHours>r.nHoursPerDay)
		return true;
		
	return false;
}

bool ConstraintTeacherMinRestingHours::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeacherMinRestingHours::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(minRestingHours>r.nHoursPerDay)
		minRestingHours=r.nHoursPerDay;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////

ConstraintTeachersMinRestingHours::ConstraintTeachersMinRestingHours()
	: TimeConstraint()
{
	this->type=CONSTRAINT_TEACHERS_MIN_RESTING_HOURS;
	this->minRestingHours=-1;
	this->circular=true;
}

ConstraintTeachersMinRestingHours::ConstraintTeachersMinRestingHours(double wp, int minrestinghours, bool circ)
 : TimeConstraint(wp)
 {
	assert(minrestinghours>0);
	this->minRestingHours=minrestinghours;
	this->circular=circ;

	this->type=CONSTRAINT_TEACHERS_MIN_RESTING_HOURS;
}

bool ConstraintTeachersMinRestingHours::computeInternalStructure(QWidget* parent, Rules& r)
{
	Q_UNUSED(parent);
	Q_UNUSED(r);

	return true;
}

bool ConstraintTeachersMinRestingHours::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintTeachersMinRestingHours::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintTeachersMinRestingHours>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Minimum_Resting_Hours>"+CustomFETString::number(this->minRestingHours)+"</Minimum_Resting_Hours>\n";
	s+=IL3+"<Circular>"+trueFalse(circular)+"</Circular>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintTeachersMinRestingHours>\n";
	return s;
}

QString ConstraintTeachersMinRestingHours::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Teachers min resting hours");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("mRH:%1", "Minimum resting hours").arg(this->minRestingHours);s+=translatedCommaSpace();
	s+=tr("C:%1", "Circular").arg(yesNoTranslated(this->circular));

	return begin+s+end;
}

QString ConstraintTeachersMinRestingHours::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);

	QString s=tr("Time constraint");s+="\n";
	s+=tr("All teachers must respect the minimum resting hours (between days)");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Minimum resting hours=%1").arg(this->minRestingHours);s+="\n";
	s+=tr("Circular=%1").arg(yesNoTranslated(circular));s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

double ConstraintTeachersMinRestingHours::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}
	
	Q_UNUSED(cl);
	Q_UNUSED(dl);
	Q_UNUSED(conflictsString);

	assert(this->weightPercentage==100.0);
	
	int nbroken=0;

	for(int tch=0; tch<r.nInternalTeachers; tch++){
		for(int d=0; d<=r.nDaysPerWeek-2+(circular?1:0); d++){
			int cnt=0;
			for(int h=r.nHoursPerDay-1; h>=0; h--){
				if(teachersMatrix[tch][d][h]>0)
					break;
				else
					cnt++;
			}
			for(int h=0; h<r.nHoursPerDay; h++){
				if(teachersMatrix[tch][(d+1<=r.nDaysPerWeek-1?d+1:0)][h]>0)
					break;
				else
					cnt++;
			}
			if(cnt < this->minRestingHours)
				nbroken++;
		}
	}
	
	assert(nbroken==0);
	
	return nbroken;
}

bool ConstraintTeachersMinRestingHours::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintTeachersMinRestingHours::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);
	
	return true;
}

bool ConstraintTeachersMinRestingHours::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMinRestingHours::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintTeachersMinRestingHours::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	Q_UNUSED(r);
	Q_UNUSED(s);

	return false;
}

int ConstraintTeachersMinRestingHours::categoryOfTimeConstraint()
{
	return IS_TEACHER_TIME_CONSTRAINT;
}

bool ConstraintTeachersMinRestingHours::hasWrongDayOrHour(Rules& r)
{
	if(minRestingHours>r.nHoursPerDay)
		return true;
		
	return false;
}

bool ConstraintTeachersMinRestingHours::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintTeachersMinRestingHours::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(minRestingHours>r.nHoursPerDay)
		minRestingHours=r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsSetMinRestingHours::ConstraintStudentsSetMinRestingHours()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_SET_MIN_RESTING_HOURS;
	this->minRestingHours = -1;
	this->circular=true;
}

ConstraintStudentsSetMinRestingHours::ConstraintStudentsSetMinRestingHours(double wp, int minrestinghours, bool circ, const QString& sn)
	: TimeConstraint(wp)
{
	this->minRestingHours = minrestinghours;
	this->circular=circ;
	this->students = sn;
	this->type = CONSTRAINT_STUDENTS_SET_MIN_RESTING_HOURS;
}

bool ConstraintStudentsSetMinRestingHours::hasInactiveActivities(Rules& r)
{
	Q_UNUSED(r);
	return false;
}

QString ConstraintStudentsSetMinRestingHours::getXmlDescription(Rules& r)
{
	Q_UNUSED(r);

	QString s=IL2+"<ConstraintStudentsSetMinRestingHours>\n";
	s+=IL3+"<Weight_Percentage>"+CustomFETString::number(this->weightPercentage)+"</Weight_Percentage>\n";
	s+=IL3+"<Minimum_Resting_Hours>"+CustomFETString::number(this->minRestingHours)+"</Minimum_Resting_Hours>\n";
	s+=IL3+"<Students>"+protect(this->students)+"</Students>\n";
	s+=IL3+"<Circular>"+trueFalse(circular)+"</Circular>\n";
	s+=IL3+"<Active>"+trueFalse(active)+"</Active>\n";
	s+=IL3+"<Comments>"+protect(comments)+"</Comments>\n";
	s+=IL2+"</ConstraintStudentsSetMinRestingHours>\n";
	return s;
}

QString ConstraintStudentsSetMinRestingHours::getDescription(Rules& r)
{
	Q_UNUSED(r);

	QString begin=QString("");
	if(!active)
		begin="X - ";
		
	QString end=QString("");
	if(!comments.isEmpty())
		end=translatedCommaSpace()+tr("C: %1", "Comments").arg(comments);
		
	QString s;
	s+=tr("Students set min resting hours");s+=translatedCommaSpace();
	s+=tr("WP:%1%", "Weight percentage").arg(CustomFETString::number(this->weightPercentage));s+=translatedCommaSpace();
	s+=tr("St:%1", "Students (set)").arg(this->students); s+=translatedCommaSpace();
	s+=tr("mRH:%1", "Minimum resting hours").arg(this->minRestingHours);s+=translatedCommaSpace();
	s+=tr("C:%1", "Circular").arg(yesNoTranslated(this->circular));

	return begin+s+end;
}

QString ConstraintStudentsSetMinRestingHours::getDetailedDescription(Rules& r, bool richText, bool colors)
{
	Q_UNUSED(r);
	Q_UNUSED(colors);
	
	QString s=tr("Time constraint");s+="\n";
	s+=tr("A students set must respect the minimum resting hours (between days)");s+="\n";
	s+=tr("Weight (percentage)=%1%").arg(CustomFETString::number(this->weightPercentage));s+="\n";
	s+=tr("Students set=%1").arg(this->students);s+="\n";
	s+=tr("Minimum resting hours=%1").arg(this->minRestingHours);s+="\n";
	s+=tr("Circular=%1").arg(yesNoTranslated(circular));s+="\n";

	if(!active){
		s+=tr("Active time constraint=%1", "Represents a yes/no value, if a time constraint is active or not, %1 is yes or no").arg(yesNoTranslated(active));
		s+="\n";
	}
	if(!comments.isEmpty()){
		s+=tr("Comments=%1").arg(comments);
		s+="\n";
	}

	return richText?protect4(s):s;
}

bool ConstraintStudentsSetMinRestingHours::computeInternalStructure(QWidget* parent, Rules& r)
{
	//StudentsSet* ss=r.searchAugmentedStudentsSet(this->students);
	StudentsSet* ss=r.studentsHash.value(students, nullptr);
	
	if(ss==nullptr){
		TimeConstraintIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Constraint students set min resting hours is wrong because it refers to nonexistent students set."
		 " Please correct it (removing it might be a solution). Please report potential bug. Constraint is:\n%1").arg(this->getDetailedDescription(r)));
		
		return false;
	}

	assert(ss!=nullptr);

	populateInternalSubgroupsList(r, ss, this->iSubgroupsList);
	/*this->iSubgroupsList.clear();
	if(ss->type==STUDENTS_SUBGROUP){
		int tmp;
		tmp=((StudentsSubgroup*)ss)->indexInInternalSubgroupsList;
		assert(tmp>=0);
		assert(tmp<r.nInternalSubgroups);
		if(!this->iSubgroupsList.contains(tmp))
			this->iSubgroupsList.append(tmp);
	}
	else if(ss->type==STUDENTS_GROUP){
		StudentsGroup* stg=(StudentsGroup*)ss;
		for(int i=0; i<stg->subgroupsList.size(); i++){
			StudentsSubgroup* sts=stg->subgroupsList[i];
			int tmp;
			tmp=sts->indexInInternalSubgroupsList;
			assert(tmp>=0);
			assert(tmp<r.nInternalSubgroups);
			if(!this->iSubgroupsList.contains(tmp))
				this->iSubgroupsList.append(tmp);
		}
	}
	else if(ss->type==STUDENTS_YEAR){
		StudentsYear* sty=(StudentsYear*)ss;
		for(int i=0; i<sty->groupsList.size(); i++){
			StudentsGroup* stg=sty->groupsList[i];
			for(int j=0; j<stg->subgroupsList.size(); j++){
				StudentsSubgroup* sts=stg->subgroupsList[j];
				int tmp;
				tmp=sts->indexInInternalSubgroupsList;
				assert(tmp>=0);
				assert(tmp<r.nInternalSubgroups);
				if(!this->iSubgroupsList.contains(tmp))
					this->iSubgroupsList.append(tmp);
			}
		}
	}
	else
		assert(0);*/
		
	return true;
}

double ConstraintStudentsSetMinRestingHours::fitness(Solution& c, Rules& r, QList<double>& cl, QList<QString>& dl, FakeString* conflictsString)
{
	//if the matrices subgroupsMatrix and teachersMatrix are already calculated, do not calculate them again!
	if(!c.teachersMatrixReady || !c.subgroupsMatrixReady){
		c.teachersMatrixReady=true;
		c.subgroupsMatrixReady=true;
		subgroups_conflicts = c.getSubgroupsMatrix(r, subgroupsMatrix);
		teachers_conflicts = c.getTeachersMatrix(r, teachersMatrix);

		c.changedForMatrixCalculationTeachers=false;
		c.changedForMatrixCalculationStudents=false;
	}

	Q_UNUSED(cl);
	Q_UNUSED(dl);
	Q_UNUSED(conflictsString);

	assert(this->weightPercentage==100.0);
	
	int nbroken=0;

	for(int sbg : std::as_const(this->iSubgroupsList)){
		for(int d=0; d<=r.nDaysPerWeek-2+(circular?1:0); d++){
			int cnt=0;
			for(int h=r.nHoursPerDay-1; h>=0; h--){
				if(subgroupsMatrix[sbg][d][h]>0)
					break;
				else
					cnt++;
			}
			for(int h=0; h<r.nHoursPerDay; h++){
				if(subgroupsMatrix[sbg][(d+1<=r.nDaysPerWeek-1?d+1:0)][h]>0)
					break;
				else
					cnt++;
			}
			if(cnt < this->minRestingHours)
				nbroken++;
		}
	}
	
	assert(nbroken==0);
	
	return nbroken;
}

bool ConstraintStudentsSetMinRestingHours::isRelatedToActivity(Rules& r, int aid)
{
	Q_UNUSED(r);
	Q_UNUSED(aid);

	return false;
}

bool ConstraintStudentsSetMinRestingHours::isRelatedToTeacher(const QString& t)
{
	Q_UNUSED(t);

	return false;
}

bool ConstraintStudentsSetMinRestingHours::isRelatedToSubject(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetMinRestingHours::isRelatedToActivityTag(const QString& s)
{
	Q_UNUSED(s);

	return false;
}

bool ConstraintStudentsSetMinRestingHours::isRelatedToStudentsSet(Rules& r, const QString& s)
{
	return r.setsShareStudents(this->students, s);
}

int ConstraintStudentsSetMinRestingHours::categoryOfTimeConstraint()
{
	return IS_STUDENTS_TIME_CONSTRAINT;
}

bool ConstraintStudentsSetMinRestingHours::hasWrongDayOrHour(Rules& r)
{
	if(minRestingHours>r.nHoursPerDay)
		return true;
		
	return false;
}

bool ConstraintStudentsSetMinRestingHours::canRepairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	return true;
}

bool ConstraintStudentsSetMinRestingHours::repairWrongDayOrHour(Rules& r)
{
	assert(hasWrongDayOrHour(r));
	
	if(minRestingHours>r.nHoursPerDay)
		minRestingHours=r.nHoursPerDay;

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

ConstraintStudentsMinRestingHours::ConstraintStudentsMinRestingHours()
	: TimeConstraint()
{
	this->type = CONSTRAINT_STUDENTS_MIN_RESTING_HOURS;
	this->minRestingHours = -1;
	this->circular=true;
}

ConstraintStudentsMinRestingHours::C