/*
File rules.cpp
*/

/***************************************************************************
                          rules.cpp  -  description
                             -------------------
    begin                : 2002
    copyright            : (C) 2002 by Liviu Lalescu
    email                : Please see https://lalescu.ro/liviu/ for details about contacting Liviu Lalescu (in particular, you can find there the email address)
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software: you can redistribute it and/or modify  *
 *   it under the terms of the GNU Affero General Public License as        *
 *   published by the Free Software Foundation, version 3 of the License.  *
 *                                                                         *
 ***************************************************************************/

#include "timetable_defs.h"
#include "rules.h"

#include <QIODevice>

#include <QDir>

#include <algorithm>
#include <iostream>

#include <QTextStream>
#include <QFile>
#include <QFileDevice>
#include <QSaveFile>
#include <QFileInfo>

#include <QDate>
#include <QTime>
#include <QLocale>

#include <QString>

#include <QXmlStreamReader>

#include <QTranslator>

#include <QtGlobal>

#include <QSet>
#include <QHash>

#include <deque>
#include <list>
#include <iterator>

#include <QDataStream>
#include <QByteArray>

//#include <QApplication>
#ifndef FET_COMMAND_LINE
#include <QProgressDialog>
#endif

#include <QRegularExpression>
#include <QRegularExpressionMatch>

#include "messageboxes.h"

#include "lockunlock.h"

//static bool toSkipTime[MAX_TIME_CONSTRAINTS];
//static bool toSkipSpace[MAX_SPACE_CONSTRAINTS];

//extern QApplication* pqapplication;

extern bool students_schedule_ready;
extern bool rooms_buildings_schedule_ready;
extern bool teachers_schedule_ready;

#ifndef FET_COMMAND_LINE
#include <QMessageBox>
#include <ctime>

int cntUndoRedoStackIterator=0;
std::deque<QByteArray> oldRulesArchived; //.front() is oldest, .back() is newest
//std::list<QString> operationWhichWasDone; //as above
std::deque<QByteArray> operationWhichWasDoneArchived; //as above
std::deque<QPair<QDate, QTime>> operationDateTime; //as above
std::deque<int> unarchivedSizes; //as above
//std::list<QString> stateFileName; //as above

std::deque<QByteArray>::const_iterator crtBAIt;
//std::list<QString>::const_iterator crtFNIt;

int savedStateIterator=0;

class QWidget;
class FetMainForm;
extern FetMainForm* pFetMainForm;

void showStatusBarAutosaved();
void updateFetMainFormAfterHistoryRestored(int iterationsBackward);
//void clearHistory();
#endif

FakeString::FakeString()
{
}

void FakeString::operator=(const QString& other)
{
	Q_UNUSED(other);
}

void FakeString::operator=(const char* str)
{
	Q_UNUSED(str);
}

void FakeString::operator+=(const QString& other)
{
	Q_UNUSED(other);
}

void FakeString::operator+=(const char* str)
{
	Q_UNUSED(str);
}

#ifndef FET_COMMAND_LINE
QDataStream& operator<<(QDataStream& stream, const Rules& rules)
{
	stream<<rules.mode;

	stream<<rules.institutionName;
	stream<<rules.comments;

	stream<<rules.nTerms;
	stream<<rules.nDaysPerTerm;

	stream<<rules.nDaysPerWeek;
	stream<<rules.daysOfTheWeek;
	stream<<rules.daysOfTheWeek_longNames;

	stream<<rules.nRealDaysPerWeek;
	stream<<rules.realDaysOfTheWeek;
	stream<<rules.realDaysOfTheWeek_longNames;

	stream<<rules.nHoursPerDay;
	stream<<rules.hoursOfTheDay;
	stream<<rules.hoursOfTheDay_longNames;

	stream<<rules.nRealHoursPerDay;
	stream<<rules.realHoursOfTheDay;
	stream<<rules.realHoursOfTheDay_longNames;

	//Important note: below, need to convert teachersList.count() to an int to push it into the stream. Same for the rest of count()-s.
	
	int ntch=rules.teachersList.count();
	stream<<ntch;
	for(int i=0; i<ntch; i++)
		stream<<*(rules.teachersList.at(i));

	int nsbj=rules.subjectsList.count();
	stream<<nsbj;
	for(int i=0; i<nsbj; i++)
		stream<<*(rules.subjectsList.at(i));

	int nat=rules.activityTagsList.count();
	stream<<nat;
	for(int i=0; i<nat; i++)
		stream<<*(rules.activityTagsList.at(i));

	/*int ny=rules.yearsList.count();
	stream<<ny;
	for(int i=0; i<ny; i++)
		stream<<*(rules.yearsList.at(i));*/
	QList<StudentsSet*> allStudentsSetsList;
	QHash<StudentsSet*, int> indexForStudentsSet;
	int cnt=0;

	////////////////
	for(StudentsYear* year : std::as_const(rules.yearsList)){
		assert(!indexForStudentsSet.contains(year));
		allStudentsSetsList.append(year);
		indexForStudentsSet.insert(year, cnt);
		cnt++;
		
		for(StudentsGroup* group : std::as_const(year->groupsList)){
			if(!indexForStudentsSet.contains(group)){
				allStudentsSetsList.append(group);
				indexForStudentsSet.insert(group, cnt);
				cnt++;

				for(StudentsSubgroup* subgroup : std::as_const(group->subgroupsList)){
					if(!indexForStudentsSet.contains(subgroup)){
						allStudentsSetsList.append(subgroup);
						indexForStudentsSet.insert(subgroup, cnt);
						cnt++;
					}
				}
			}
		}
	}

	QHash<StudentsSet*, QList<int>> containedStudentsSetsList;
	for(StudentsSet* ss : std::as_const(allStudentsSetsList)){
		if(ss->type==STUDENTS_YEAR){
			StudentsYear* year=(StudentsYear*)ss;
			QList<int> cg;
			for(StudentsGroup* group : std::as_const(year->groupsList)){
				assert(indexForStudentsSet.contains(group));
				cg.append(indexForStudentsSet.value(group));
			}
			assert(!containedStudentsSetsList.contains(year));
			if(!cg.isEmpty()){
				containedStudentsSetsList.insert(year, cg);
			}
		}
		else if(ss->type==STUDENTS_GROUP){
			StudentsGroup* group=(StudentsGroup*)ss;
			QList<int> cs;
			for(StudentsSubgroup* subgroup : std::as_const(group->subgroupsList)){
				assert(indexForStudentsSet.contains(subgroup));
				cs.append(indexForStudentsSet.value(subgroup));
			}
			assert(!containedStudentsSetsList.contains(group));
			if(!cs.isEmpty()){
				containedStudentsSetsList.insert(group, cs);
			}
		}
	}
	/////////////////

	assert(cnt==allStudentsSetsList.count());
	stream<<cnt;
	for(int i=0; i<cnt; i++){
		StudentsSet* ss=allStudentsSetsList.at(i);
		stream<<ss->type;
		if(ss->type==STUDENTS_YEAR){
			StudentsYear* year=(StudentsYear*)ss;
			stream<<year->name;
			stream<<year->longName;
			stream<<year->code;
			stream<<year->numberOfStudents;
			//stream<<year->type;

			stream<<year->comments;

			//NOT: assert(containedStudentsSetsList.contains(year));
			stream<<containedStudentsSetsList.value(year, QList<int>());

			stream<<year->divisions;
			stream<<year->separator; //The separator when dividing a year by categories.

			stream<<year->firstCategoryIsPermanent;
		}
		else if(ss->type==STUDENTS_GROUP){
			StudentsGroup* group=(StudentsGroup*)ss;
			stream<<group->name;
			stream<<group->longName;
			stream<<group->code;
			stream<<group->numberOfStudents;
			//stream<<group->type;

			stream<<group->comments;

			//NOT: assert(containedStudentsSetsList.contains(group));
			stream<<containedStudentsSetsList.value(group, QList<int>());
		}
		else if(ss->type==STUDENTS_SUBGROUP){
			StudentsSubgroup* subgroup=(StudentsSubgroup*)ss;
			stream<<subgroup->name;
			stream<<subgroup->longName;
			stream<<subgroup->code;
			stream<<subgroup->numberOfStudents;
			//stream<<subgroup->type;

			stream<<subgroup->comments;

			assert(!containedStudentsSetsList.contains(subgroup));
		}
		else{
			assert(0);
		}
	}

	int na=rules.activitiesList.count();
	stream<<na;
	for(int i=0; i<na; i++)
		stream<<*(rules.activitiesList.at(i));

	int nrm=rules.roomsList.count();
	stream<<nrm;
	for(int i=0; i<nrm; i++)
		stream<<*(rules.roomsList.at(i));

	int nbd=rules.buildingsList.count();
	stream<<nbd;
	for(int i=0; i<nbd; i++)
		stream<<*(rules.buildingsList.at(i));

	int ntc=rules.timeConstraintsList.count();
	stream<<ntc;
	for(int i=0; i<ntc; i++){
		TimeConstraint* ctr=rules.timeConstraintsList.at(i);
		stream<<ctr->type;

		switch(ctr->type){
			//1
			case CONSTRAINT_BASIC_COMPULSORY_TIME:
				{
					ConstraintBasicCompulsoryTime* c=(ConstraintBasicCompulsoryTime*)ctr;
					stream<<*c;
					break;
				}
			//2
			case CONSTRAINT_TWO_ACTIVITIES_CONSECUTIVE:
				{
					ConstraintTwoActivitiesConsecutive* c=(ConstraintTwoActivitiesConsecutive*)ctr;
					stream<<*c;
					break;
				}
			//3
			case CONSTRAINT_TWO_ACTIVITIES_ORDERED:
				{
					ConstraintTwoActivitiesOrdered* c=(ConstraintTwoActivitiesOrdered*)ctr;
					stream<<*c;
					break;
				}
			//4
			case CONSTRAINT_ACTIVITY_PREFERRED_TIME_SLOTS:
				{
					ConstraintActivityPreferredTimeSlots* c=(ConstraintActivityPreferredTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			//5
			case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIMES:
				{
					ConstraintActivityPreferredStartingTimes* c=(ConstraintActivityPreferredStartingTimes*)ctr;
					stream<<*c;
					break;
				}
			//6
			case CONSTRAINT_ACTIVITIES_PREFERRED_TIME_SLOTS:
				{
					ConstraintActivitiesPreferredTimeSlots* c=(ConstraintActivitiesPreferredTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			//7
			case CONSTRAINT_ACTIVITIES_PREFERRED_STARTING_TIMES:
				{
					ConstraintActivitiesPreferredStartingTimes* c=(ConstraintActivitiesPreferredStartingTimes*)ctr;
					stream<<*c;
					break;
				}
			//8
			case CONSTRAINT_SUBACTIVITIES_PREFERRED_TIME_SLOTS:
				{
					ConstraintSubactivitiesPreferredTimeSlots* c=(ConstraintSubactivitiesPreferredTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			//9
			case CONSTRAINT_SUBACTIVITIES_PREFERRED_STARTING_TIMES:
				{
					ConstraintSubactivitiesPreferredStartingTimes* c=(ConstraintSubactivitiesPreferredStartingTimes*)ctr;
					stream<<*c;
					break;
				}
			//10
			case CONSTRAINT_ACTIVITIES_SAME_STARTING_TIME:
				{
					ConstraintActivitiesSameStartingTime* c=(ConstraintActivitiesSameStartingTime*)ctr;
					stream<<*c;
					break;
				}
			//11
			case CONSTRAINT_ACTIVITIES_SAME_STARTING_HOUR:
				{
					ConstraintActivitiesSameStartingHour* c=(ConstraintActivitiesSameStartingHour*)ctr;
					stream<<*c;
					break;
				}
			//12
			case CONSTRAINT_ACTIVITIES_SAME_STARTING_DAY:
				{
					ConstraintActivitiesSameStartingDay* c=(ConstraintActivitiesSameStartingDay*)ctr;
					stream<<*c;
					break;
				}
			//13
			case CONSTRAINT_TEACHER_NOT_AVAILABLE_TIMES:
				{
					ConstraintTeacherNotAvailableTimes* c=(ConstraintTeacherNotAvailableTimes*)ctr;
					stream<<*c;
					break;
				}
			//14
			case CONSTRAINT_STUDENTS_SET_NOT_AVAILABLE_TIMES:
				{
					ConstraintStudentsSetNotAvailableTimes* c=(ConstraintStudentsSetNotAvailableTimes*)ctr;
					stream<<*c;
					break;
				}
			//15
			case CONSTRAINT_BREAK_TIMES:
				{
					ConstraintBreakTimes* c=(ConstraintBreakTimes*)ctr;
					stream<<*c;
					break;
				}
			//16
			case CONSTRAINT_TEACHER_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeacherMaxDaysPerWeek* c=(ConstraintTeacherMaxDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//17
			case CONSTRAINT_TEACHERS_MAX_HOURS_DAILY:
				{
					ConstraintTeachersMaxHoursDaily* c=(ConstraintTeachersMaxHoursDaily*)ctr;
					stream<<*c;
					break;
				}
			//18
			case CONSTRAINT_TEACHER_MAX_HOURS_DAILY:
				{
					ConstraintTeacherMaxHoursDaily* c=(ConstraintTeacherMaxHoursDaily*)ctr;
					stream<<*c;
					break;
				}
			//19
			case CONSTRAINT_TEACHERS_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintTeachersMaxHoursContinuously* c=(ConstraintTeachersMaxHoursContinuously*)ctr;
					stream<<*c;
					break;
				}
			//20
			case CONSTRAINT_TEACHER_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintTeacherMaxHoursContinuously* c=(ConstraintTeacherMaxHoursContinuously*)ctr;
					stream<<*c;
					break;
				}
			//21
			case CONSTRAINT_TEACHERS_MIN_HOURS_DAILY:
				{
					ConstraintTeachersMinHoursDaily* c=(ConstraintTeachersMinHoursDaily*)ctr;
					stream<<*c;
					break;
				}
			//22
			case CONSTRAINT_TEACHER_MIN_HOURS_DAILY:
				{
					ConstraintTeacherMinHoursDaily* c=(ConstraintTeacherMinHoursDaily*)ctr;
					stream<<*c;
					break;
				}
			//23
			case CONSTRAINT_TEACHERS_MAX_GAPS_PER_WEEK:
				{
					ConstraintTeachersMaxGapsPerWeek* c=(ConstraintTeachersMaxGapsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//24
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_WEEK:
				{
					ConstraintTeacherMaxGapsPerWeek* c=(ConstraintTeacherMaxGapsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//25
			case CONSTRAINT_TEACHERS_MAX_GAPS_PER_DAY:
				{
					ConstraintTeachersMaxGapsPerDay* c=(ConstraintTeachersMaxGapsPerDay*)ctr;
					stream<<*c;
					break;
				}
			//26
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_DAY:
				{
					ConstraintTeacherMaxGapsPerDay* c=(ConstraintTeacherMaxGapsPerDay*)ctr;
					stream<<*c;
					break;
				}
			//27
			case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIME:
				{
					ConstraintActivityPreferredStartingTime* c=(ConstraintActivityPreferredStartingTime*)ctr;
					stream<<*c;
					break;
				}
			//28
			case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_WEEK:
				{
					ConstraintStudentsSetMaxGapsPerWeek* c=(ConstraintStudentsSetMaxGapsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//29
			case CONSTRAINT_STUDENTS_MAX_GAPS_PER_WEEK:
				{
					ConstraintStudentsMaxGapsPerWeek* c=(ConstraintStudentsMaxGapsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//30
			case CONSTRAINT_STUDENTS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintStudentsEarlyMaxBeginningsAtSecondHour* c=(ConstraintStudentsEarlyMaxBeginningsAtSecondHour*)ctr;
					stream<<*c;
					break;
				}
			//31
			case CONSTRAINT_STUDENTS_SET_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour* c=(ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour*)ctr;
					stream<<*c;
					break;
				}
			//32
			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY:
				{
					ConstraintStudentsSetMaxHoursDaily* c=(ConstraintStudentsSetMaxHoursDaily*)ctr;
					stream<<*c;
					break;
				}
			//33
			case CONSTRAINT_STUDENTS_MAX_HOURS_DAILY:
				{
					ConstraintStudentsMaxHoursDaily* c=(ConstraintStudentsMaxHoursDaily*)ctr;
					stream<<*c;
					break;
				}
			//34
			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintStudentsSetMaxHoursContinuously* c=(ConstraintStudentsSetMaxHoursContinuously*)ctr;
					stream<<*c;
					break;
				}
			//35
			case CONSTRAINT_STUDENTS_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintStudentsMaxHoursContinuously* c=(ConstraintStudentsMaxHoursContinuously*)ctr;
					stream<<*c;
					break;
				}
			//36
			case CONSTRAINT_STUDENTS_SET_MIN_HOURS_DAILY:
				{
					ConstraintStudentsSetMinHoursDaily* c=(ConstraintStudentsSetMinHoursDaily*)ctr;
					stream<<*c;
					break;
				}
			//37
			case CONSTRAINT_STUDENTS_MIN_HOURS_DAILY:
				{
					ConstraintStudentsMinHoursDaily* c=(ConstraintStudentsMinHoursDaily*)ctr;
					stream<<*c;
					break;
				}
			//38
			case CONSTRAINT_ACTIVITIES_NOT_OVERLAPPING:
				{
					ConstraintActivitiesNotOverlapping* c=(ConstraintActivitiesNotOverlapping*)ctr;
					stream<<*c;
					break;
				}
			//39
			case CONSTRAINT_MIN_DAYS_BETWEEN_ACTIVITIES:
				{
					ConstraintMinDaysBetweenActivities* c=(ConstraintMinDaysBetweenActivities*)ctr;
					stream<<*c;
					break;
				}
			//40
			case CONSTRAINT_MIN_GAPS_BETWEEN_ACTIVITIES:
				{
					ConstraintMinGapsBetweenActivities* c=(ConstraintMinGapsBetweenActivities*)ctr;
					stream<<*c;
					break;
				}
			//41
			case CONSTRAINT_ACTIVITY_ENDS_STUDENTS_DAY:
				{
					ConstraintActivityEndsStudentsDay* c=(ConstraintActivityEndsStudentsDay*)ctr;
					stream<<*c;
					break;
				}
			//42
			case CONSTRAINT_TEACHER_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeacherIntervalMaxDaysPerWeek* c=(ConstraintTeacherIntervalMaxDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//43
			case CONSTRAINT_TEACHERS_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeachersIntervalMaxDaysPerWeek* c=(ConstraintTeachersIntervalMaxDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//44
			case CONSTRAINT_STUDENTS_SET_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetIntervalMaxDaysPerWeek* c=(ConstraintStudentsSetIntervalMaxDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//45
			case CONSTRAINT_STUDENTS_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsIntervalMaxDaysPerWeek* c=(ConstraintStudentsIntervalMaxDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//46
			case CONSTRAINT_ACTIVITIES_END_STUDENTS_DAY:
				{
					ConstraintActivitiesEndStudentsDay* c=(ConstraintActivitiesEndStudentsDay*)ctr;
					stream<<*c;
					break;
				}
			//47
			case CONSTRAINT_TWO_ACTIVITIES_GROUPED:
				{
					ConstraintTwoActivitiesGrouped* c=(ConstraintTwoActivitiesGrouped*)ctr;
					stream<<*c;
					break;
				}
			//48
			case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintTeachersActivityTagMaxHoursContinuously* c=(ConstraintTeachersActivityTagMaxHoursContinuously*)ctr;
					stream<<*c;
					break;
				}
			//49
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintTeacherActivityTagMaxHoursContinuously* c=(ConstraintTeacherActivityTagMaxHoursContinuously*)ctr;
					stream<<*c;
					break;
				}
			//50
			case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintStudentsActivityTagMaxHoursContinuously* c=(ConstraintStudentsActivityTagMaxHoursContinuously*)ctr;
					stream<<*c;
					break;
				}
			//51
			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintStudentsSetActivityTagMaxHoursContinuously* c=(ConstraintStudentsSetActivityTagMaxHoursContinuously*)ctr;
					stream<<*c;
					break;
				}
			//52
			case CONSTRAINT_TEACHERS_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeachersMaxDaysPerWeek* c=(ConstraintTeachersMaxDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//53
			case CONSTRAINT_THREE_ACTIVITIES_GROUPED:
				{
					ConstraintThreeActivitiesGrouped* c=(ConstraintThreeActivitiesGrouped*)ctr;
					stream<<*c;
					break;
				}
			//54
			case CONSTRAINT_MAX_DAYS_BETWEEN_ACTIVITIES:
				{
					ConstraintMaxDaysBetweenActivities* c=(ConstraintMaxDaysBetweenActivities*)ctr;
					stream<<*c;
					break;
				}
			//55
			case CONSTRAINT_TEACHERS_MIN_DAYS_PER_WEEK:
				{
					ConstraintTeachersMinDaysPerWeek* c=(ConstraintTeachersMinDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//56
			case CONSTRAINT_TEACHER_MIN_DAYS_PER_WEEK:
				{
					ConstraintTeacherMinDaysPerWeek* c=(ConstraintTeacherMinDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//57
			case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_DAILY:
				{
					ConstraintTeachersActivityTagMaxHoursDaily* c=(ConstraintTeachersActivityTagMaxHoursDaily*)ctr;
					stream<<*c;
					break;
				}
			//58
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_DAILY:
				{
					ConstraintTeacherActivityTagMaxHoursDaily* c=(ConstraintTeacherActivityTagMaxHoursDaily*)ctr;
					stream<<*c;
					break;
				}
			//59
			case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_DAILY:
				{
					ConstraintStudentsActivityTagMaxHoursDaily* c=(ConstraintStudentsActivityTagMaxHoursDaily*)ctr;
					stream<<*c;
					break;
				}
			//60
			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY:
				{
					ConstraintStudentsSetActivityTagMaxHoursDaily* c=(ConstraintStudentsSetActivityTagMaxHoursDaily*)ctr;
					stream<<*c;
					break;
				}

			//61
			case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_DAY:
				{
					ConstraintStudentsSetMaxGapsPerDay* c=(ConstraintStudentsSetMaxGapsPerDay*)ctr;
					stream<<*c;
					break;
				}
			//62
			case CONSTRAINT_STUDENTS_MAX_GAPS_PER_DAY:
				{
					ConstraintStudentsMaxGapsPerDay* c=(ConstraintStudentsMaxGapsPerDay*)ctr;
					stream<<*c;
					break;
				}
			//63
			case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintActivitiesOccupyMaxTimeSlotsFromSelection* c=(ConstraintActivitiesOccupyMaxTimeSlotsFromSelection*)ctr;
					stream<<*c;
					break;
				}
			//64
			case CONSTRAINT_ACTIVITIES_MAX_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots* c=(ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			//65
			case CONSTRAINT_STUDENTS_SET_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetMaxDaysPerWeek* c=(ConstraintStudentsSetMaxDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//66
			case CONSTRAINT_STUDENTS_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsMaxDaysPerWeek* c=(ConstraintStudentsMaxDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//2017-02-07
			//67
			case CONSTRAINT_TEACHER_MAX_SPAN_PER_DAY:
				{
					ConstraintTeacherMaxSpanPerDay* c=(ConstraintTeacherMaxSpanPerDay*)ctr;
					stream<<*c;
					break;
				}
			//68
			case CONSTRAINT_TEACHERS_MAX_SPAN_PER_DAY:
				{
					ConstraintTeachersMaxSpanPerDay* c=(ConstraintTeachersMaxSpanPerDay*)ctr;
					stream<<*c;
					break;
				}
			//69
			case CONSTRAINT_STUDENTS_SET_MAX_SPAN_PER_DAY:
				{
					ConstraintStudentsSetMaxSpanPerDay* c=(ConstraintStudentsSetMaxSpanPerDay*)ctr;
					stream<<*c;
					break;
				}
			//70
			case CONSTRAINT_STUDENTS_MAX_SPAN_PER_DAY:
				{
					ConstraintStudentsMaxSpanPerDay* c=(ConstraintStudentsMaxSpanPerDay*)ctr;
					stream<<*c;
					break;
				}
			//71
			case CONSTRAINT_TEACHER_MIN_RESTING_HOURS:
				{
					ConstraintTeacherMinRestingHours* c=(ConstraintTeacherMinRestingHours*)ctr;
					stream<<*c;
					break;
				}
			//72
			case CONSTRAINT_TEACHERS_MIN_RESTING_HOURS:
				{
					ConstraintTeachersMinRestingHours* c=(ConstraintTeachersMinRestingHours*)ctr;
					stream<<*c;
					break;
				}
			//73
			case CONSTRAINT_STUDENTS_SET_MIN_RESTING_HOURS:
				{
					ConstraintStudentsSetMinRestingHours* c=(ConstraintStudentsSetMinRestingHours*)ctr;
					stream<<*c;
					break;
				}
			//74
			case CONSTRAINT_STUDENTS_MIN_RESTING_HOURS:
				{
					ConstraintStudentsMinRestingHours* c=(ConstraintStudentsMinRestingHours*)ctr;
					stream<<*c;
					break;
				}
			//2018-06-13
			//75
			case CONSTRAINT_TWO_ACTIVITIES_ORDERED_IF_SAME_DAY:
				{
					ConstraintTwoActivitiesOrderedIfSameDay* c=(ConstraintTwoActivitiesOrderedIfSameDay*)ctr;
					stream<<*c;
					break;
				}
			//2019-06-09
			//76
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
				{
					ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTags* c=(ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTags*)ctr;
					stream<<*c;
					break;
				}
			//77
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
				{
					ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTags* c=(ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTags*)ctr;
					stream<<*c;
					break;
				}
			//78
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
				{
					ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTags* c=(ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTags*)ctr;
					stream<<*c;
					break;
				}
			//79
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
				{
					ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTags* c=(ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTags*)ctr;
					stream<<*c;
					break;
				}
			//80
			case CONSTRAINT_ACTIVITY_TAGS_NOT_OVERLAPPING:
				{
					ConstraintActivityTagsNotOverlapping* c=(ConstraintActivityTagsNotOverlapping*)ctr;
					stream<<*c;
					break;
				}
			//81
			case CONSTRAINT_ACTIVITIES_OCCUPY_MIN_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintActivitiesOccupyMinTimeSlotsFromSelection* c=(ConstraintActivitiesOccupyMinTimeSlotsFromSelection*)ctr;
					stream<<*c;
					break;
				}
			//82
			case CONSTRAINT_ACTIVITIES_MIN_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintActivitiesMinSimultaneousInSelectedTimeSlots* c=(ConstraintActivitiesMinSimultaneousInSelectedTimeSlots*)ctr;
					stream<<*c;
					break;
				}

			//83
			case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MIN_HOURS_DAILY:
				{
					ConstraintTeachersActivityTagMinHoursDaily* c=(ConstraintTeachersActivityTagMinHoursDaily*)ctr;
					stream<<*c;
					break;
				}
			//84
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MIN_HOURS_DAILY:
				{
					ConstraintTeacherActivityTagMinHoursDaily* c=(ConstraintTeacherActivityTagMinHoursDaily*)ctr;
					stream<<*c;
					break;
				}
			//85
			case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MIN_HOURS_DAILY:
				{
					ConstraintStudentsActivityTagMinHoursDaily* c=(ConstraintStudentsActivityTagMinHoursDaily*)ctr;
					stream<<*c;
					break;
				}
			//86
			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MIN_HOURS_DAILY:
				{
					ConstraintStudentsSetActivityTagMinHoursDaily* c=(ConstraintStudentsSetActivityTagMinHoursDaily*)ctr;
					stream<<*c;
					break;
				}
			//87
			case CONSTRAINT_ACTIVITY_ENDS_TEACHERS_DAY:
				{
					ConstraintActivityEndsTeachersDay* c=(ConstraintActivityEndsTeachersDay*)ctr;
					stream<<*c;
					break;
				}
			//88
			case CONSTRAINT_ACTIVITIES_END_TEACHERS_DAY:
				{
					ConstraintActivitiesEndTeachersDay* c=(ConstraintActivitiesEndTeachersDay*)ctr;
					stream<<*c;
					break;
				}

			//mornings-afternoons
			//89
			case CONSTRAINT_TEACHER_MAX_AFTERNOONS_PER_WEEK:
				{
					ConstraintTeacherMaxAfternoonsPerWeek* c=(ConstraintTeacherMaxAfternoonsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//90
			case CONSTRAINT_TEACHERS_MAX_AFTERNOONS_PER_WEEK:
				{
					ConstraintTeachersMaxAfternoonsPerWeek* c=(ConstraintTeachersMaxAfternoonsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//91
			case CONSTRAINT_TEACHER_MAX_MORNINGS_PER_WEEK:
				{
					ConstraintTeacherMaxMorningsPerWeek* c=(ConstraintTeacherMaxMorningsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//92
			case CONSTRAINT_TEACHERS_MAX_MORNINGS_PER_WEEK:
				{
					ConstraintTeachersMaxMorningsPerWeek* c=(ConstraintTeachersMaxMorningsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//93
			case CONSTRAINT_TEACHER_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintTeacherMaxActivityTagsPerDayFromSet* c=(ConstraintTeacherMaxActivityTagsPerDayFromSet*)ctr;
					stream<<*c;
					break;
				}
			//94
			case CONSTRAINT_TEACHERS_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintTeachersMaxActivityTagsPerDayFromSet* c=(ConstraintTeachersMaxActivityTagsPerDayFromSet*)ctr;
					stream<<*c;
					break;
				}
			//95
			case CONSTRAINT_TEACHER_MIN_MORNINGS_PER_WEEK:
				{
					ConstraintTeacherMinMorningsPerWeek* c=(ConstraintTeacherMinMorningsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//96
			case CONSTRAINT_TEACHERS_MIN_MORNINGS_PER_WEEK:
				{
					ConstraintTeachersMinMorningsPerWeek* c=(ConstraintTeachersMinMorningsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//97
			case CONSTRAINT_TEACHER_MIN_AFTERNOONS_PER_WEEK:
				{
					ConstraintTeacherMinAfternoonsPerWeek* c=(ConstraintTeacherMinAfternoonsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//98
			case CONSTRAINT_TEACHERS_MIN_AFTERNOONS_PER_WEEK:
				{
					ConstraintTeachersMinAfternoonsPerWeek* c=(ConstraintTeachersMinAfternoonsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//99
			case CONSTRAINT_TEACHER_MAX_TWO_CONSECUTIVE_MORNINGS:
				{
					ConstraintTeacherMaxTwoConsecutiveMornings* c=(ConstraintTeacherMaxTwoConsecutiveMornings*)ctr;
					stream<<*c;
					break;
				}
			//100
			case CONSTRAINT_TEACHERS_MAX_TWO_CONSECUTIVE_MORNINGS:
				{
					ConstraintTeachersMaxTwoConsecutiveMornings* c=(ConstraintTeachersMaxTwoConsecutiveMornings*)ctr;
					stream<<*c;
					break;
				}
			//101
			case CONSTRAINT_TEACHER_MAX_TWO_CONSECUTIVE_AFTERNOONS:
				{
					ConstraintTeacherMaxTwoConsecutiveAfternoons* c=(ConstraintTeacherMaxTwoConsecutiveAfternoons*)ctr;
					stream<<*c;
					break;
				}
			//102
			case CONSTRAINT_TEACHERS_MAX_TWO_CONSECUTIVE_AFTERNOONS:
				{
					ConstraintTeachersMaxTwoConsecutiveAfternoons* c=(ConstraintTeachersMaxTwoConsecutiveAfternoons*)ctr;
					stream<<*c;
					break;
				}
			//103
			case CONSTRAINT_TEACHERS_MAX_GAPS_PER_REAL_DAY:
				{
					ConstraintTeachersMaxGapsPerRealDay* c=(ConstraintTeachersMaxGapsPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//104
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_REAL_DAY:
				{
					ConstraintTeacherMaxGapsPerRealDay* c=(ConstraintTeacherMaxGapsPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//105
			case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_REAL_DAY:
				{
					ConstraintStudentsSetMaxGapsPerRealDay* c=(ConstraintStudentsSetMaxGapsPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//106
			case CONSTRAINT_STUDENTS_MAX_GAPS_PER_REAL_DAY:
				{
					ConstraintStudentsMaxGapsPerRealDay* c=(ConstraintStudentsMaxGapsPerRealDay*)ctr;
					stream<<*c;
					break;
				}

			//107
			case CONSTRAINT_TEACHERS_MIN_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeachersMinHoursDailyRealDays* c=(ConstraintTeachersMinHoursDailyRealDays*)ctr;
					stream<<*c;
					break;
				}
			//108
			case CONSTRAINT_TEACHER_MIN_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeacherMinHoursDailyRealDays* c=(ConstraintTeacherMinHoursDailyRealDays*)ctr;
					stream<<*c;
					break;
				}

			//109
			case CONSTRAINT_TEACHERS_MIN_HOURS_PER_MORNING:
				{
					ConstraintTeachersMinHoursPerMorning* c=(ConstraintTeachersMinHoursPerMorning*)ctr;
					stream<<*c;
					break;
				}
			//110
			case CONSTRAINT_TEACHER_MIN_HOURS_PER_MORNING:
				{
					ConstraintTeacherMinHoursPerMorning* c=(ConstraintTeacherMinHoursPerMorning*)ctr;
					stream<<*c;
					break;
				}
			//2017-02-07
			//111
			case CONSTRAINT_TEACHER_MAX_SPAN_PER_REAL_DAY:
				{
					ConstraintTeacherMaxSpanPerRealDay* c=(ConstraintTeacherMaxSpanPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//112
			case CONSTRAINT_TEACHERS_MAX_SPAN_PER_REAL_DAY:
				{
					ConstraintTeachersMaxSpanPerRealDay* c=(ConstraintTeachersMaxSpanPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//113
			case CONSTRAINT_STUDENTS_SET_MAX_SPAN_PER_REAL_DAY:
				{
					ConstraintStudentsSetMaxSpanPerRealDay* c=(ConstraintStudentsSetMaxSpanPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//114
			case CONSTRAINT_STUDENTS_MAX_SPAN_PER_REAL_DAY:
				{
					ConstraintStudentsMaxSpanPerRealDay* c=(ConstraintStudentsMaxSpanPerRealDay*)ctr;
					stream<<*c;
					break;
				}

			//115
			case CONSTRAINT_TEACHER_MORNING_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeacherMorningIntervalMaxDaysPerWeek* c=(ConstraintTeacherMorningIntervalMaxDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//116
			case CONSTRAINT_TEACHERS_MORNING_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeachersMorningIntervalMaxDaysPerWeek* c=(ConstraintTeachersMorningIntervalMaxDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}

			//117
			case CONSTRAINT_TEACHER_AFTERNOON_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeacherAfternoonIntervalMaxDaysPerWeek* c=(ConstraintTeacherAfternoonIntervalMaxDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//118
			case CONSTRAINT_TEACHERS_AFTERNOON_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeachersAfternoonIntervalMaxDaysPerWeek* c=(ConstraintTeachersAfternoonIntervalMaxDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//119
			case CONSTRAINT_STUDENTS_SET_MIN_HOURS_PER_MORNING:
				{
					ConstraintStudentsSetMinHoursPerMorning* c=(ConstraintStudentsSetMinHoursPerMorning*)ctr;
					stream<<*c;
					break;
				}
			//120
			case CONSTRAINT_STUDENTS_MIN_HOURS_PER_MORNING:
				{
					ConstraintStudentsMinHoursPerMorning* c=(ConstraintStudentsMinHoursPerMorning*)ctr;
					stream<<*c;
					break;
				}

			//121
			case CONSTRAINT_TEACHERS_MAX_ZERO_GAPS_PER_AFTERNOON:
				{
					ConstraintTeachersMaxZeroGapsPerAfternoon* c=(ConstraintTeachersMaxZeroGapsPerAfternoon*)ctr;
					stream<<*c;
					break;
				}
			//122
			case CONSTRAINT_TEACHER_MAX_ZERO_GAPS_PER_AFTERNOON:
				{
					ConstraintTeacherMaxZeroGapsPerAfternoon* c=(ConstraintTeacherMaxZeroGapsPerAfternoon*)ctr;
					stream<<*c;
					break;
				}
			//123
			case CONSTRAINT_STUDENTS_SET_MAX_AFTERNOONS_PER_WEEK:
				{
					ConstraintStudentsSetMaxAfternoonsPerWeek* c=(ConstraintStudentsSetMaxAfternoonsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//124
			case CONSTRAINT_STUDENTS_MAX_AFTERNOONS_PER_WEEK:
				{
					ConstraintStudentsMaxAfternoonsPerWeek* c=(ConstraintStudentsMaxAfternoonsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//125
			case CONSTRAINT_STUDENTS_SET_MAX_MORNINGS_PER_WEEK:
				{
					ConstraintStudentsSetMaxMorningsPerWeek* c=(ConstraintStudentsSetMaxMorningsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//126
			case CONSTRAINT_STUDENTS_MAX_MORNINGS_PER_WEEK:
				{
					ConstraintStudentsMaxMorningsPerWeek* c=(ConstraintStudentsMaxMorningsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			/////
			//127
			case CONSTRAINT_STUDENTS_SET_MIN_AFTERNOONS_PER_WEEK:
				{
					ConstraintStudentsSetMinAfternoonsPerWeek* c=(ConstraintStudentsSetMinAfternoonsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//128
			case CONSTRAINT_STUDENTS_MIN_AFTERNOONS_PER_WEEK:
				{
					ConstraintStudentsMinAfternoonsPerWeek* c=(ConstraintStudentsMinAfternoonsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//129
			case CONSTRAINT_STUDENTS_SET_MIN_MORNINGS_PER_WEEK:
				{
					ConstraintStudentsSetMinMorningsPerWeek* c=(ConstraintStudentsSetMinMorningsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//130
			case CONSTRAINT_STUDENTS_MIN_MORNINGS_PER_WEEK:
				{
					ConstraintStudentsMinMorningsPerWeek* c=(ConstraintStudentsMinMorningsPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//131
			case CONSTRAINT_STUDENTS_SET_MORNING_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetMorningIntervalMaxDaysPerWeek* c=(ConstraintStudentsSetMorningIntervalMaxDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//132
			case CONSTRAINT_STUDENTS_MORNING_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsMorningIntervalMaxDaysPerWeek* c=(ConstraintStudentsMorningIntervalMaxDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//133
			case CONSTRAINT_STUDENTS_SET_AFTERNOON_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetAfternoonIntervalMaxDaysPerWeek* c=(ConstraintStudentsSetAfternoonIntervalMaxDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//134
			case CONSTRAINT_STUDENTS_AFTERNOON_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsAfternoonIntervalMaxDaysPerWeek* c=(ConstraintStudentsAfternoonIntervalMaxDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//2020-06-28
			//135
			case CONSTRAINT_TEACHER_MAX_HOURS_PER_ALL_AFTERNOONS:
				{
					ConstraintTeacherMaxHoursPerAllAfternoons* c=(ConstraintTeacherMaxHoursPerAllAfternoons*)ctr;
					stream<<*c;
					break;
				}
			//136
			case CONSTRAINT_TEACHERS_MAX_HOURS_PER_ALL_AFTERNOONS:
				{
					ConstraintTeachersMaxHoursPerAllAfternoons* c=(ConstraintTeachersMaxHoursPerAllAfternoons*)ctr;
					stream<<*c;
					break;
				}
			//137
			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_PER_ALL_AFTERNOONS:
				{
					ConstraintStudentsSetMaxHoursPerAllAfternoons* c=(ConstraintStudentsSetMaxHoursPerAllAfternoons*)ctr;
					stream<<*c;
					break;
				}
			//138
			case CONSTRAINT_STUDENTS_MAX_HOURS_PER_ALL_AFTERNOONS:
				{
					ConstraintStudentsMaxHoursPerAllAfternoons* c=(ConstraintStudentsMaxHoursPerAllAfternoons*)ctr;
					stream<<*c;
					break;
				}

			//139
			case CONSTRAINT_TEACHER_MIN_RESTING_HOURS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeacherMinRestingHoursBetweenMorningAndAfternoon* c=(ConstraintTeacherMinRestingHoursBetweenMorningAndAfternoon*)ctr;
					stream<<*c;
					break;
				}
			//140
			case CONSTRAINT_TEACHERS_MIN_RESTING_HOURS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeachersMinRestingHoursBetweenMorningAndAfternoon* c=(ConstraintTeachersMinRestingHoursBetweenMorningAndAfternoon*)ctr;
					stream<<*c;
					break;
				}
			//141
			case CONSTRAINT_STUDENTS_SET_MIN_RESTING_HOURS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsSetMinRestingHoursBetweenMorningAndAfternoon* c=(ConstraintStudentsSetMinRestingHoursBetweenMorningAndAfternoon*)ctr;
					stream<<*c;
					break;
				}
			//142
			case CONSTRAINT_STUDENTS_MIN_RESTING_HOURS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsMinRestingHoursBetweenMorningAndAfternoon* c=(ConstraintStudentsMinRestingHoursBetweenMorningAndAfternoon*)ctr;
					stream<<*c;
					break;
				}
			/////////
			//143
			case CONSTRAINT_STUDENTS_AFTERNOONS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintStudentsAfternoonsEarlyMaxBeginningsAtSecondHour* c=(ConstraintStudentsAfternoonsEarlyMaxBeginningsAtSecondHour*)ctr;
					stream<<*c;
					break;
				}
			//144
			case CONSTRAINT_STUDENTS_SET_AFTERNOONS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintStudentsSetAfternoonsEarlyMaxBeginningsAtSecondHour* c=(ConstraintStudentsSetAfternoonsEarlyMaxBeginningsAtSecondHour*)ctr;
					stream<<*c;
					break;
				}

			//145
			case CONSTRAINT_TEACHERS_MAX_GAPS_PER_WEEK_FOR_REAL_DAYS:
				{
					ConstraintTeachersMaxGapsPerWeekForRealDays* c=(ConstraintTeachersMaxGapsPerWeekForRealDays*)ctr;
					stream<<*c;
					break;
				}
			//146
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_WEEK_FOR_REAL_DAYS:
				{
					ConstraintTeacherMaxGapsPerWeekForRealDays* c=(ConstraintTeacherMaxGapsPerWeekForRealDays*)ctr;
					stream<<*c;
					break;
				}
			//147
			case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_WEEK_FOR_REAL_DAYS:
				{
					ConstraintStudentsSetMaxGapsPerWeekForRealDays* c=(ConstraintStudentsSetMaxGapsPerWeekForRealDays*)ctr;
					stream<<*c;
					break;
				}
			//148
			case CONSTRAINT_STUDENTS_MAX_GAPS_PER_WEEK_FOR_REAL_DAYS:
				{
					ConstraintStudentsMaxGapsPerWeekForRealDays* c=(ConstraintStudentsMaxGapsPerWeekForRealDays*)ctr;
					stream<<*c;
					break;
				}

			//149
			case CONSTRAINT_TEACHER_MAX_REAL_DAYS_PER_WEEK:
				{
					ConstraintTeacherMaxRealDaysPerWeek* c=(ConstraintTeacherMaxRealDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//150
			case CONSTRAINT_TEACHERS_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeachersMaxHoursDailyRealDays* c=(ConstraintTeachersMaxHoursDailyRealDays*)ctr;
					stream<<*c;
					break;
				}
			//151
			case CONSTRAINT_TEACHER_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeacherMaxHoursDailyRealDays* c=(ConstraintTeacherMaxHoursDailyRealDays*)ctr;
					stream<<*c;
					break;
				}
			//152
			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintStudentsSetMaxHoursDailyRealDays* c=(ConstraintStudentsSetMaxHoursDailyRealDays*)ctr;
					stream<<*c;
					break;
				}
			//153
			case CONSTRAINT_STUDENTS_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintStudentsMaxHoursDailyRealDays* c=(ConstraintStudentsMaxHoursDailyRealDays*)ctr;
					stream<<*c;
					break;
				}
			//154
			case CONSTRAINT_TEACHERS_MAX_REAL_DAYS_PER_WEEK:
				{
					ConstraintTeachersMaxRealDaysPerWeek* c=(ConstraintTeachersMaxRealDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//155
			case CONSTRAINT_TEACHERS_MIN_REAL_DAYS_PER_WEEK:
				{
					ConstraintTeachersMinRealDaysPerWeek* c=(ConstraintTeachersMinRealDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//156
			case CONSTRAINT_TEACHER_MIN_REAL_DAYS_PER_WEEK:
				{
					ConstraintTeacherMinRealDaysPerWeek* c=(ConstraintTeacherMinRealDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//157
			case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeachersActivityTagMaxHoursDailyRealDays* c=(ConstraintTeachersActivityTagMaxHoursDailyRealDays*)ctr;
					stream<<*c;
					break;
				}
			//158
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeacherActivityTagMaxHoursDailyRealDays* c=(ConstraintTeacherActivityTagMaxHoursDailyRealDays*)ctr;
					stream<<*c;
					break;
				}
			//159
			case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintStudentsActivityTagMaxHoursDailyRealDays* c=(ConstraintStudentsActivityTagMaxHoursDailyRealDays*)ctr;
					stream<<*c;
					break;
				}
			//160
			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintStudentsSetActivityTagMaxHoursDailyRealDays* c=(ConstraintStudentsSetActivityTagMaxHoursDailyRealDays*)ctr;
					stream<<*c;
					break;
				}

			//161
			case CONSTRAINT_STUDENTS_SET_MAX_REAL_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetMaxRealDaysPerWeek* c=(ConstraintStudentsSetMaxRealDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//162
			case CONSTRAINT_STUDENTS_MAX_REAL_DAYS_PER_WEEK:
				{
					ConstraintStudentsMaxRealDaysPerWeek* c=(ConstraintStudentsMaxRealDaysPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//163
			case CONSTRAINT_TEACHERS_AFTERNOONS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintTeachersAfternoonsEarlyMaxBeginningsAtSecondHour* c=(ConstraintTeachersAfternoonsEarlyMaxBeginningsAtSecondHour*)ctr;
					stream<<*c;
					break;
				}
			//164
			case CONSTRAINT_TEACHER_AFTERNOONS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintTeacherAfternoonsEarlyMaxBeginningsAtSecondHour* c=(ConstraintTeacherAfternoonsEarlyMaxBeginningsAtSecondHour*)ctr;
					stream<<*c;
					break;
				}
			//block-planning
			//165
			case CONSTRAINT_MAX_TOTAL_ACTIVITIES_FROM_SET_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots* c=(ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			//166
			case CONSTRAINT_MAX_GAPS_BETWEEN_ACTIVITIES:
				{
					ConstraintMaxGapsBetweenActivities* c=(ConstraintMaxGapsBetweenActivities*)ctr;
					stream<<*c;
					break;
				}
			//terms
			//167
			case CONSTRAINT_ACTIVITIES_MAX_IN_A_TERM:
				{
					ConstraintActivitiesMaxInATerm* c=(ConstraintActivitiesMaxInATerm*)ctr;
					stream<<*c;
					break;
				}
			//168
			case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_TERMS:
				{
					ConstraintActivitiesOccupyMaxTerms* c=(ConstraintActivitiesOccupyMaxTerms*)ctr;
					stream<<*c;
					break;
				}
			//169
			case CONSTRAINT_TEACHERS_MAX_GAPS_PER_MORNING_AND_AFTERNOON:
				{
					ConstraintTeachersMaxGapsPerMorningAndAfternoon* c=(ConstraintTeachersMaxGapsPerMorningAndAfternoon*)ctr;
					stream<<*c;
					break;
				}
			//170
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_MORNING_AND_AFTERNOON:
				{
					ConstraintTeacherMaxGapsPerMorningAndAfternoon* c=(ConstraintTeacherMaxGapsPerMorningAndAfternoon*)ctr;
					stream<<*c;
					break;
				}
			//171
			case CONSTRAINT_STUDENTS_MORNINGS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintStudentsMorningsEarlyMaxBeginningsAtSecondHour* c=(ConstraintStudentsMorningsEarlyMaxBeginningsAtSecondHour*)ctr;
					stream<<*c;
					break;
				}
			//172
			case CONSTRAINT_STUDENTS_SET_MORNINGS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintStudentsSetMorningsEarlyMaxBeginningsAtSecondHour* c=(ConstraintStudentsSetMorningsEarlyMaxBeginningsAtSecondHour*)ctr;
					stream<<*c;
					break;
				}
			//173
			case CONSTRAINT_TEACHERS_MORNINGS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintTeachersMorningsEarlyMaxBeginningsAtSecondHour* c=(ConstraintTeachersMorningsEarlyMaxBeginningsAtSecondHour*)ctr;
					stream<<*c;
					break;
				}
			//174
			case CONSTRAINT_TEACHER_MORNINGS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintTeacherMorningsEarlyMaxBeginningsAtSecondHour* c=(ConstraintTeacherMorningsEarlyMaxBeginningsAtSecondHour*)ctr;
					stream<<*c;
					break;
				}
			//175
			case CONSTRAINT_TWO_SETS_OF_ACTIVITIES_ORDERED:
				{
					ConstraintTwoSetsOfActivitiesOrdered* c=(ConstraintTwoSetsOfActivitiesOrdered*)ctr;
					stream<<*c;
					break;
				}
			//176
			case CONSTRAINT_TEACHER_MAX_THREE_CONSECUTIVE_DAYS:
				{
					ConstraintTeacherMaxThreeConsecutiveDays* c=(ConstraintTeacherMaxThreeConsecutiveDays*)ctr;
					stream<<*c;
					break;
				}
			//177
			case CONSTRAINT_TEACHERS_MAX_THREE_CONSECUTIVE_DAYS:
				{
					ConstraintTeachersMaxThreeConsecutiveDays* c=(ConstraintTeachersMaxThreeConsecutiveDays*)ctr;
					stream<<*c;
					break;
				}
			//2021-12-15
			//178
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
				{
					ConstraintStudentsSetMinGapsBetweenActivityTag* c=(ConstraintStudentsSetMinGapsBetweenActivityTag*)ctr;
					stream<<*c;
					break;
				}
			//179
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
				{
					ConstraintStudentsMinGapsBetweenActivityTag* c=(ConstraintStudentsMinGapsBetweenActivityTag*)ctr;
					stream<<*c;
					break;
				}
			//180
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
				{
					ConstraintTeacherMinGapsBetweenActivityTag* c=(ConstraintTeacherMinGapsBetweenActivityTag*)ctr;
					stream<<*c;
					break;
				}
			//181
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
				{
					ConstraintTeachersMinGapsBetweenActivityTag* c=(ConstraintTeachersMinGapsBetweenActivityTag*)ctr;
					stream<<*c;
					break;
				}
			//2022-02-15
			//182
			case CONSTRAINT_STUDENTS_SET_MAX_THREE_CONSECUTIVE_DAYS:
				{
					ConstraintStudentsSetMaxThreeConsecutiveDays* c=(ConstraintStudentsSetMaxThreeConsecutiveDays*)ctr;
					stream<<*c;
					break;
				}
			//183
			case CONSTRAINT_STUDENTS_MAX_THREE_CONSECUTIVE_DAYS:
				{
					ConstraintStudentsMaxThreeConsecutiveDays* c=(ConstraintStudentsMaxThreeConsecutiveDays*)ctr;
					stream<<*c;
					break;
				}
			//184
			case CONSTRAINT_MIN_HALF_DAYS_BETWEEN_ACTIVITIES:
				{
					ConstraintMinHalfDaysBetweenActivities* c=(ConstraintMinHalfDaysBetweenActivities*)ctr;
					stream<<*c;
					break;
				}
			//185
			case CONSTRAINT_ACTIVITY_PREFERRED_DAY:
				{
					ConstraintActivityPreferredDay* c=(ConstraintActivityPreferredDay*)ctr;
					stream<<*c;
					break;
				}
			//186
			case CONSTRAINT_ACTIVITIES_MIN_IN_A_TERM:
				{
					ConstraintActivitiesMinInATerm* c=(ConstraintActivitiesMinInATerm*)ctr;
					stream<<*c;
					break;
				}
			//187
			case CONSTRAINT_MAX_TERMS_BETWEEN_ACTIVITIES:
				{
					ConstraintMaxTermsBetweenActivities* c=(ConstraintMaxTermsBetweenActivities*)ctr;
					stream<<*c;
					break;
				}
			//188
			case CONSTRAINT_STUDENTS_SET_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintStudentsSetMaxActivityTagsPerDayFromSet* c=(ConstraintStudentsSetMaxActivityTagsPerDayFromSet*)ctr;
					stream<<*c;
					break;
				}
			//189
			case CONSTRAINT_STUDENTS_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintStudentsMaxActivityTagsPerDayFromSet* c=(ConstraintStudentsMaxActivityTagsPerDayFromSet*)ctr;
					stream<<*c;
					break;
				}
			//190
			case CONSTRAINT_TEACHER_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintTeacherMaxActivityTagsPerRealDayFromSet* c=(ConstraintTeacherMaxActivityTagsPerRealDayFromSet*)ctr;
					stream<<*c;
					break;
				}
			//191
			case CONSTRAINT_TEACHERS_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintTeachersMaxActivityTagsPerRealDayFromSet* c=(ConstraintTeachersMaxActivityTagsPerRealDayFromSet*)ctr;
					stream<<*c;
					break;
				}
			//192
			case CONSTRAINT_STUDENTS_SET_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintStudentsSetMaxActivityTagsPerRealDayFromSet* c=(ConstraintStudentsSetMaxActivityTagsPerRealDayFromSet*)ctr;
					stream<<*c;
					break;
				}
			//193
			case CONSTRAINT_STUDENTS_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintStudentsMaxActivityTagsPerRealDayFromSet* c=(ConstraintStudentsMaxActivityTagsPerRealDayFromSet*)ctr;
					stream<<*c;
					break;
				}
			//194
			case CONSTRAINT_MAX_HALF_DAYS_BETWEEN_ACTIVITIES:
				{
					ConstraintMaxHalfDaysBetweenActivities* c=(ConstraintMaxHalfDaysBetweenActivities*)ctr;
					stream<<*c;
					break;
				}
			//195
			case CONSTRAINT_ACTIVITY_BEGINS_STUDENTS_DAY:
				{
					ConstraintActivityBeginsStudentsDay* c=(ConstraintActivityBeginsStudentsDay*)ctr;
					stream<<*c;
					break;
				}
			//196
			case CONSTRAINT_ACTIVITIES_BEGIN_STUDENTS_DAY:
				{
					ConstraintActivitiesBeginStudentsDay* c=(ConstraintActivitiesBeginStudentsDay*)ctr;
					stream<<*c;
					break;
				}
			//197
			case CONSTRAINT_ACTIVITY_BEGINS_TEACHERS_DAY:
				{
					ConstraintActivityBeginsTeachersDay* c=(ConstraintActivityBeginsTeachersDay*)ctr;
					stream<<*c;
					break;
				}
			//198
			case CONSTRAINT_ACTIVITIES_BEGIN_TEACHERS_DAY:
				{
					ConstraintActivitiesBeginTeachersDay* c=(ConstraintActivitiesBeginTeachersDay*)ctr;
					stream<<*c;
					break;
				}

			//199
			case CONSTRAINT_TEACHERS_MIN_HOURS_PER_AFTERNOON:
				{
					ConstraintTeachersMinHoursPerAfternoon* c=(ConstraintTeachersMinHoursPerAfternoon*)ctr;
					stream<<*c;
					break;
				}
			//200
			case CONSTRAINT_TEACHER_MIN_HOURS_PER_AFTERNOON:
				{
					ConstraintTeacherMinHoursPerAfternoon* c=(ConstraintTeacherMinHoursPerAfternoon*)ctr;
					stream<<*c;
					break;
				}
			//201
			case CONSTRAINT_STUDENTS_SET_MIN_HOURS_PER_AFTERNOON:
				{
					ConstraintStudentsSetMinHoursPerAfternoon* c=(ConstraintStudentsSetMinHoursPerAfternoon*)ctr;
					stream<<*c;
					break;
				}
			//202
			case CONSTRAINT_STUDENTS_MIN_HOURS_PER_AFTERNOON:
				{
					ConstraintStudentsMinHoursPerAfternoon* c=(ConstraintStudentsMinHoursPerAfternoon*)ctr;
					stream<<*c;
					break;
				}

			//203
			case CONSTRAINT_ACTIVITIES_MAX_HOURLY_SPAN:
				{
					ConstraintActivitiesMaxHourlySpan* c=(ConstraintActivitiesMaxHourlySpan*)ctr;
					stream<<*c;
					break;
				}

			//204
			case CONSTRAINT_TEACHERS_MAX_HOURS_DAILY_IN_INTERVAL:
				{
					ConstraintTeachersMaxHoursDailyInInterval* c=(ConstraintTeachersMaxHoursDailyInInterval*)ctr;
					stream<<*c;
					break;
				}
			//205
			case CONSTRAINT_TEACHER_MAX_HOURS_DAILY_IN_INTERVAL:
				{
					ConstraintTeacherMaxHoursDailyInInterval* c=(ConstraintTeacherMaxHoursDailyInInterval*)ctr;
					stream<<*c;
					break;
				}
			//206
			case CONSTRAINT_STUDENTS_MAX_HOURS_DAILY_IN_INTERVAL:
				{
					ConstraintStudentsMaxHoursDailyInInterval* c=(ConstraintStudentsMaxHoursDailyInInterval*)ctr;
					stream<<*c;
					break;
				}
			//207
			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxHoursDailyInInterval* c=(ConstraintStudentsSetMaxHoursDailyInInterval*)ctr;
					stream<<*c;
					break;
				}
			//208
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
				{
					ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* c=(ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//209
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
				{
					ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* c=(ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//210
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
				{
					ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* c=(ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//211
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
				{
					ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* c=(ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//212
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
				{
					ConstraintStudentsSetMinGapsBetweenActivityTagPerRealDay* c=(ConstraintStudentsSetMinGapsBetweenActivityTagPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//213
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
				{
					ConstraintStudentsMinGapsBetweenActivityTagPerRealDay* c=(ConstraintStudentsMinGapsBetweenActivityTagPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//214
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
				{
					ConstraintTeacherMinGapsBetweenActivityTagPerRealDay* c=(ConstraintTeacherMinGapsBetweenActivityTagPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//215
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
				{
					ConstraintTeachersMinGapsBetweenActivityTagPerRealDay* c=(ConstraintTeachersMinGapsBetweenActivityTagPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//216
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* c=(ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon*)ctr;
					stream<<*c;
					break;
				}
			//217
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* c=(ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon*)ctr;
					stream<<*c;
					break;
				}
			//218
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* c=(ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon*)ctr;
					stream<<*c;
					break;
				}
			//219
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* c=(ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon*)ctr;
					stream<<*c;
					break;
				}
			//220
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon* c=(ConstraintStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon*)ctr;
					stream<<*c;
					break;
				}
			//221
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsMinGapsBetweenActivityTagBetweenMorningAndAfternoon* c=(ConstraintStudentsMinGapsBetweenActivityTagBetweenMorningAndAfternoon*)ctr;
					stream<<*c;
					break;
				}
			//222
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeacherMinGapsBetweenActivityTagBetweenMorningAndAfternoon* c=(ConstraintTeacherMinGapsBetweenActivityTagBetweenMorningAndAfternoon*)ctr;
					stream<<*c;
					break;
				}
			//223
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeachersMinGapsBetweenActivityTagBetweenMorningAndAfternoon* c=(ConstraintTeachersMinGapsBetweenActivityTagBetweenMorningAndAfternoon*)ctr;
					stream<<*c;
					break;
				}
			//224
			case CONSTRAINT_TEACHER_NO_TWO_CONSECUTIVE_DAYS:
				{
					ConstraintTeacherNoTwoConsecutiveDays* c=(ConstraintTeacherNoTwoConsecutiveDays*)ctr;
					stream<<*c;
					break;
				}
			//225
			case CONSTRAINT_TEACHERS_NO_TWO_CONSECUTIVE_DAYS:
				{
					ConstraintTeachersNoTwoConsecutiveDays* c=(ConstraintTeachersNoTwoConsecutiveDays*)ctr;
					stream<<*c;
					break;
				}
			//226
			case CONSTRAINT_TEACHER_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
				{
					ConstraintTeacherPairOfMutuallyExclusiveTimeSlots* c=(ConstraintTeacherPairOfMutuallyExclusiveTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			//227
			case CONSTRAINT_TEACHERS_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
				{
					ConstraintTeachersPairOfMutuallyExclusiveTimeSlots* c=(ConstraintTeachersPairOfMutuallyExclusiveTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			//228
			case CONSTRAINT_STUDENTS_SET_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
				{
					ConstraintStudentsSetPairOfMutuallyExclusiveTimeSlots* c=(ConstraintStudentsSetPairOfMutuallyExclusiveTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			//229
			case CONSTRAINT_STUDENTS_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
				{
					ConstraintStudentsPairOfMutuallyExclusiveTimeSlots* c=(ConstraintStudentsPairOfMutuallyExclusiveTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			//230
			case CONSTRAINT_TWO_SETS_OF_ACTIVITIES_SAME_SECTIONS:
				{
					ConstraintTwoSetsOfActivitiesSameSections* c=(ConstraintTwoSetsOfActivitiesSameSections*)ctr;
					stream<<*c;
					break;
				}
			//2025-05-15
			//231
			case CONSTRAINT_STUDENTS_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintStudentsMaxSingleGapsInSelectedTimeSlots* c=(ConstraintStudentsMaxSingleGapsInSelectedTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			//232
			case CONSTRAINT_STUDENTS_SET_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintStudentsSetMaxSingleGapsInSelectedTimeSlots* c=(ConstraintStudentsSetMaxSingleGapsInSelectedTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			//2025-05-17
			//233
			case CONSTRAINT_TEACHERS_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintTeachersMaxSingleGapsInSelectedTimeSlots* c=(ConstraintTeachersMaxSingleGapsInSelectedTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			//234
			case CONSTRAINT_TEACHER_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintTeacherMaxSingleGapsInSelectedTimeSlots* c=(ConstraintTeacherMaxSingleGapsInSelectedTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			//235
			case CONSTRAINT_TEACHER_MAX_HOURS_PER_TERM:
				{
					ConstraintTeacherMaxHoursPerTerm* c=(ConstraintTeacherMaxHoursPerTerm*)ctr;
					stream<<*c;
					break;
				}
			//236
			case CONSTRAINT_TEACHERS_MAX_HOURS_PER_TERM:
				{
					ConstraintTeachersMaxHoursPerTerm* c=(ConstraintTeachersMaxHoursPerTerm*)ctr;
					stream<<*c;
					break;
				}
			//237
			case CONSTRAINT_TEACHER_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
				{
					ConstraintTeacherPairOfMutuallyExclusiveSetsOfTimeSlots* c=(ConstraintTeacherPairOfMutuallyExclusiveSetsOfTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			//238
			case CONSTRAINT_TEACHERS_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
				{
					ConstraintTeachersPairOfMutuallyExclusiveSetsOfTimeSlots* c=(ConstraintTeachersPairOfMutuallyExclusiveSetsOfTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			//239
			case CONSTRAINT_STUDENTS_SET_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
				{
					ConstraintStudentsSetPairOfMutuallyExclusiveSetsOfTimeSlots* c=(ConstraintStudentsSetPairOfMutuallyExclusiveSetsOfTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			//240
			case CONSTRAINT_STUDENTS_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
				{
					ConstraintStudentsPairOfMutuallyExclusiveSetsOfTimeSlots* c=(ConstraintStudentsPairOfMutuallyExclusiveSetsOfTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			//241
			case CONSTRAINT_ACTIVITIES_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
				{
					ConstraintActivitiesPairOfMutuallyExclusiveSetsOfTimeSlots* c=(ConstraintActivitiesPairOfMutuallyExclusiveSetsOfTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			//242
			case CONSTRAINT_ACTIVITIES_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
				{
					ConstraintActivitiesPairOfMutuallyExclusiveTimeSlots* c=(ConstraintActivitiesPairOfMutuallyExclusiveTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			//243
			case CONSTRAINT_TEACHER_OCCUPIES_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintTeacherOccupiesMaxSetsOfTimeSlotsFromSelection* c=(ConstraintTeacherOccupiesMaxSetsOfTimeSlotsFromSelection*)ctr;
					stream<<*c;
					break;
				}
			//244
			case CONSTRAINT_TEACHERS_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintTeachersOccupyMaxSetsOfTimeSlotsFromSelection* c=(ConstraintTeachersOccupyMaxSetsOfTimeSlotsFromSelection*)ctr;
					stream<<*c;
					break;
				}
			//245
			case CONSTRAINT_STUDENTS_SET_OCCUPIES_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintStudentsSetOccupiesMaxSetsOfTimeSlotsFromSelection* c=(ConstraintStudentsSetOccupiesMaxSetsOfTimeSlotsFromSelection*)ctr;
					stream<<*c;
					break;
				}
			//246
			case CONSTRAINT_STUDENTS_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintStudentsOccupyMaxSetsOfTimeSlotsFromSelection* c=(ConstraintStudentsOccupyMaxSetsOfTimeSlotsFromSelection*)ctr;
					stream<<*c;
					break;
				}
			//247
			case CONSTRAINT_ACTIVITIES_OVERLAP_COMPLETELY_OR_DO_NOT_OVERLAP:
				{
					ConstraintActivitiesOverlapCompletelyOrDoNotOverlap* c=(ConstraintActivitiesOverlapCompletelyOrDoNotOverlap*)ctr;
					stream<<*c;
					break;
				}
			//248
			case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintActivitiesOccupyMaxSetsOfTimeSlotsFromSelection* c=(ConstraintActivitiesOccupyMaxSetsOfTimeSlotsFromSelection*)ctr;
					stream<<*c;
					break;
				}
				
			//249
			case CONSTRAINT_ACTIVITY_BEGINS_OR_ENDS_STUDENTS_DAY:
				{
					ConstraintActivityBeginsOrEndsStudentsDay* c=(ConstraintActivityBeginsOrEndsStudentsDay*)ctr;
					stream<<*c;
					break;
				}
			//250
			case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_STUDENTS_DAY:
				{
					ConstraintActivitiesBeginOrEndStudentsDay* c=(ConstraintActivitiesBeginOrEndStudentsDay*)ctr;
					stream<<*c;
					break;
				}
			//251
			case CONSTRAINT_ACTIVITY_BEGINS_OR_ENDS_TEACHERS_DAY:
				{
					ConstraintActivityBeginsOrEndsTeachersDay* c=(ConstraintActivityBeginsOrEndsTeachersDay*)ctr;
					stream<<*c;
					break;
				}
			//252
			case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_TEACHERS_DAY:
				{
					ConstraintActivitiesBeginOrEndTeachersDay* c=(ConstraintActivitiesBeginOrEndTeachersDay*)ctr;
					stream<<*c;
					break;
				}
			//253
			case CONSTRAINT_ACTIVITIES_MAX_TOTAL_NUMBER_OF_STUDENTS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintActivitiesMaxTotalNumberOfStudentsInSelectedTimeSlots* c=(ConstraintActivitiesMaxTotalNumberOfStudentsInSelectedTimeSlots*)ctr;
					stream<<*c;
					break;
				}
			
			default:
				assert(0);
				break;
		}
	}
	
	//stream<<rules.spaceConstraintsList;
	int nsc=rules.spaceConstraintsList.count();
	stream<<nsc;
	for(int i=0; i<nsc; i++){
		SpaceConstraint* ctr=rules.spaceConstraintsList.at(i);
		stream<<ctr->type;

		switch(ctr->type){
			//1
			case CONSTRAINT_BASIC_COMPULSORY_SPACE:
				{
					ConstraintBasicCompulsorySpace* c=(ConstraintBasicCompulsorySpace*)ctr;
					stream<<*c;
					break;
				}
			//2
			case CONSTRAINT_ROOM_NOT_AVAILABLE_TIMES:
				{
					ConstraintRoomNotAvailableTimes* c=(ConstraintRoomNotAvailableTimes*)ctr;
					stream<<*c;
					break;
				}
			//3
			case CONSTRAINT_ACTIVITY_PREFERRED_ROOM:
				{
					ConstraintActivityPreferredRoom* c=(ConstraintActivityPreferredRoom*)ctr;
					stream<<*c;
					break;
				}
			//4
			case CONSTRAINT_ACTIVITY_PREFERRED_ROOMS:
				{
					ConstraintActivityPreferredRooms* c=(ConstraintActivityPreferredRooms*)ctr;
					stream<<*c;
					break;
				}
			//5
			case CONSTRAINT_STUDENTS_SET_HOME_ROOM:
				{
					ConstraintStudentsSetHomeRoom* c=(ConstraintStudentsSetHomeRoom*)ctr;
					stream<<*c;
					break;
				}
			//6
			case CONSTRAINT_STUDENTS_SET_HOME_ROOMS:
				{
					ConstraintStudentsSetHomeRooms* c=(ConstraintStudentsSetHomeRooms*)ctr;
					stream<<*c;
					break;
				}
			//7
			case CONSTRAINT_TEACHER_HOME_ROOM:
				{
					ConstraintTeacherHomeRoom* c=(ConstraintTeacherHomeRoom*)ctr;
					stream<<*c;
					break;
				}
			//8
			case CONSTRAINT_TEACHER_HOME_ROOMS:
				{
					ConstraintTeacherHomeRooms* c=(ConstraintTeacherHomeRooms*)ctr;
					stream<<*c;
					break;
				}
			//9
			case CONSTRAINT_SUBJECT_PREFERRED_ROOM:
				{
					ConstraintSubjectPreferredRoom* c=(ConstraintSubjectPreferredRoom*)ctr;
					stream<<*c;
					break;
				}
			//10
			case CONSTRAINT_SUBJECT_PREFERRED_ROOMS:
				{
					ConstraintSubjectPreferredRooms* c=(ConstraintSubjectPreferredRooms*)ctr;
					stream<<*c;
					break;
				}
			//11
			case CONSTRAINT_SUBJECT_ACTIVITY_TAG_PREFERRED_ROOM:
				{
					ConstraintSubjectActivityTagPreferredRoom* c=(ConstraintSubjectActivityTagPreferredRoom*)ctr;
					stream<<*c;
					break;
				}
			//12
			case CONSTRAINT_SUBJECT_ACTIVITY_TAG_PREFERRED_ROOMS:
				{
					ConstraintSubjectActivityTagPreferredRooms* c=(ConstraintSubjectActivityTagPreferredRooms*)ctr;
					stream<<*c;
					break;
				}
			///6 apr 2009
			//13
			case CONSTRAINT_ACTIVITY_TAG_PREFERRED_ROOM:
				{
					ConstraintActivityTagPreferredRoom* c=(ConstraintActivityTagPreferredRoom*)ctr;
					stream<<*c;
					break;
				}
			//14
			case CONSTRAINT_ACTIVITY_TAG_PREFERRED_ROOMS:
				{
					ConstraintActivityTagPreferredRooms* c=(ConstraintActivityTagPreferredRooms*)ctr;
					stream<<*c;
					break;
				}
			///
			//15
			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_DAY:
				{
					ConstraintStudentsSetMaxBuildingChangesPerDay* c=(ConstraintStudentsSetMaxBuildingChangesPerDay*)ctr;
					stream<<*c;
					break;
				}
			//16
			case CONSTRAINT_STUDENTS_MAX_BUILDING_CHANGES_PER_DAY:
				{
					ConstraintStudentsMaxBuildingChangesPerDay* c=(ConstraintStudentsMaxBuildingChangesPerDay*)ctr;
					stream<<*c;
					break;
				}
			//17
			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_WEEK:
				{
					ConstraintStudentsSetMaxBuildingChangesPerWeek* c=(ConstraintStudentsSetMaxBuildingChangesPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//18
			case CONSTRAINT_STUDENTS_MAX_BUILDING_CHANGES_PER_WEEK:
				{
					ConstraintStudentsMaxBuildingChangesPerWeek* c=(ConstraintStudentsMaxBuildingChangesPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//19
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_BUILDING_CHANGES:
				{
					ConstraintStudentsSetMinGapsBetweenBuildingChanges* c=(ConstraintStudentsSetMinGapsBetweenBuildingChanges*)ctr;
					stream<<*c;
					break;
				}
			//20
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_BUILDING_CHANGES:
				{
					ConstraintStudentsMinGapsBetweenBuildingChanges* c=(ConstraintStudentsMinGapsBetweenBuildingChanges*)ctr;
					stream<<*c;
					break;
				}
			//21
			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_DAY:
				{
					ConstraintTeacherMaxBuildingChangesPerDay* c=(ConstraintTeacherMaxBuildingChangesPerDay*)ctr;
					stream<<*c;
					break;
				}
			//22
			case CONSTRAINT_TEACHERS_MAX_BUILDING_CHANGES_PER_DAY:
				{
					ConstraintTeachersMaxBuildingChangesPerDay* c=(ConstraintTeachersMaxBuildingChangesPerDay*)ctr;
					stream<<*c;
					break;
				}
			//23
			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_WEEK:
				{
					ConstraintTeacherMaxBuildingChangesPerWeek* c=(ConstraintTeacherMaxBuildingChangesPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//24
			case CONSTRAINT_TEACHERS_MAX_BUILDING_CHANGES_PER_WEEK:
				{
					ConstraintTeachersMaxBuildingChangesPerWeek* c=(ConstraintTeachersMaxBuildingChangesPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//25
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_BUILDING_CHANGES:
				{
					ConstraintTeacherMinGapsBetweenBuildingChanges* c=(ConstraintTeacherMinGapsBetweenBuildingChanges*)ctr;
					stream<<*c;
					break;
				}
			//26
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_BUILDING_CHANGES:
				{
					ConstraintTeachersMinGapsBetweenBuildingChanges* c=(ConstraintTeachersMinGapsBetweenBuildingChanges*)ctr;
					stream<<*c;
					break;
				}
			//27
			case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_DIFFERENT_ROOMS:
				{
					ConstraintActivitiesOccupyMaxDifferentRooms* c=(ConstraintActivitiesOccupyMaxDifferentRooms*)ctr;
					stream<<*c;
					break;
				}
			//28
			case CONSTRAINT_ACTIVITIES_SAME_ROOM_IF_CONSECUTIVE:
				{
					ConstraintActivitiesSameRoomIfConsecutive* c=(ConstraintActivitiesSameRoomIfConsecutive*)ctr;
					stream<<*c;
					break;
				}
			//2019-11-14
			//29
			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_DAY:
				{
					ConstraintStudentsSetMaxRoomChangesPerDay* c=(ConstraintStudentsSetMaxRoomChangesPerDay*)ctr;
					stream<<*c;
					break;
				}
			//30
			case CONSTRAINT_STUDENTS_MAX_ROOM_CHANGES_PER_DAY:
				{
					ConstraintStudentsMaxRoomChangesPerDay* c=(ConstraintStudentsMaxRoomChangesPerDay*)ctr;
					stream<<*c;
					break;
				}
			//31
			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_WEEK:
				{
					ConstraintStudentsSetMaxRoomChangesPerWeek* c=(ConstraintStudentsSetMaxRoomChangesPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//32
			case CONSTRAINT_STUDENTS_MAX_ROOM_CHANGES_PER_WEEK:
				{
					ConstraintStudentsMaxRoomChangesPerWeek* c=(ConstraintStudentsMaxRoomChangesPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//33
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ROOM_CHANGES:
				{
					ConstraintStudentsSetMinGapsBetweenRoomChanges* c=(ConstraintStudentsSetMinGapsBetweenRoomChanges*)ctr;
					stream<<*c;
					break;
				}
			//34
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ROOM_CHANGES:
				{
					ConstraintStudentsMinGapsBetweenRoomChanges* c=(ConstraintStudentsMinGapsBetweenRoomChanges*)ctr;
					stream<<*c;
					break;
				}
			//35
			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_DAY:
				{
					ConstraintTeacherMaxRoomChangesPerDay* c=(ConstraintTeacherMaxRoomChangesPerDay*)ctr;
					stream<<*c;
					break;
				}
			//36
			case CONSTRAINT_TEACHERS_MAX_ROOM_CHANGES_PER_DAY:
				{
					ConstraintTeachersMaxRoomChangesPerDay* c=(ConstraintTeachersMaxRoomChangesPerDay*)ctr;
					stream<<*c;
					break;
				}
			//37
			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_WEEK:
				{
					ConstraintTeacherMaxRoomChangesPerWeek* c=(ConstraintTeacherMaxRoomChangesPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//38
			case CONSTRAINT_TEACHERS_MAX_ROOM_CHANGES_PER_WEEK:
				{
					ConstraintTeachersMaxRoomChangesPerWeek* c=(ConstraintTeachersMaxRoomChangesPerWeek*)ctr;
					stream<<*c;
					break;
				}
			//39
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ROOM_CHANGES:
				{
					ConstraintTeacherMinGapsBetweenRoomChanges* c=(ConstraintTeacherMinGapsBetweenRoomChanges*)ctr;
					stream<<*c;
					break;
				}
			//40
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ROOM_CHANGES:
				{
					ConstraintTeachersMinGapsBetweenRoomChanges* c=(ConstraintTeachersMinGapsBetweenRoomChanges*)ctr;
					stream<<*c;
					break;
				}
			//41
			case CONSTRAINT_TEACHER_ROOM_NOT_AVAILABLE_TIMES:
				{
					ConstraintTeacherRoomNotAvailableTimes* c=(ConstraintTeacherRoomNotAvailableTimes*)ctr;
					stream<<*c;
					break;
				}
			//for mornings-afternoons
			//42
			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_REAL_DAY:
				{
					ConstraintStudentsSetMaxRoomChangesPerRealDay* c=(ConstraintStudentsSetMaxRoomChangesPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//43
			case CONSTRAINT_STUDENTS_MAX_ROOM_CHANGES_PER_REAL_DAY:
				{
					ConstraintStudentsMaxRoomChangesPerRealDay* c=(ConstraintStudentsMaxRoomChangesPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//44
			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_REAL_DAY:
				{
					ConstraintTeacherMaxRoomChangesPerRealDay* c=(ConstraintTeacherMaxRoomChangesPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//45
			case CONSTRAINT_TEACHERS_MAX_ROOM_CHANGES_PER_REAL_DAY:
				{
					ConstraintTeachersMaxRoomChangesPerRealDay* c=(ConstraintTeachersMaxRoomChangesPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//46
			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_REAL_DAY:
				{
					ConstraintStudentsSetMaxBuildingChangesPerRealDay* c=(ConstraintStudentsSetMaxBuildingChangesPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//47
			case CONSTRAINT_STUDENTS_MAX_BUILDING_CHANGES_PER_REAL_DAY:
				{
					ConstraintStudentsMaxBuildingChangesPerRealDay* c=(ConstraintStudentsMaxBuildingChangesPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//48
			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_REAL_DAY:
				{
					ConstraintTeacherMaxBuildingChangesPerRealDay* c=(ConstraintTeacherMaxBuildingChangesPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//49
			case CONSTRAINT_TEACHERS_MAX_BUILDING_CHANGES_PER_REAL_DAY:
				{
					ConstraintTeachersMaxBuildingChangesPerRealDay* c=(ConstraintTeachersMaxBuildingChangesPerRealDay*)ctr;
					stream<<*c;
					break;
				}
			//50
			case CONSTRAINT_STUDENTS_MAX_BUILDING_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintStudentsMaxBuildingChangesPerDayInInterval* c=(ConstraintStudentsMaxBuildingChangesPerDayInInterval*)ctr;
					stream<<*c;
					break;
				}
			//51
			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxBuildingChangesPerDayInInterval* c=(ConstraintStudentsSetMaxBuildingChangesPerDayInInterval*)ctr;
					stream<<*c;
					break;
				}
			//52
			case CONSTRAINT_TEACHERS_MAX_BUILDING_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintTeachersMaxBuildingChangesPerDayInInterval* c=(ConstraintTeachersMaxBuildingChangesPerDayInInterval*)ctr;
					stream<<*c;
					break;
				}
			//53
			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintTeacherMaxBuildingChangesPerDayInInterval* c=(ConstraintTeacherMaxBuildingChangesPerDayInInterval*)ctr;
					stream<<*c;
					break;
				}
			//54
			case CONSTRAINT_STUDENTS_MAX_BUILDING_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintStudentsMaxBuildingChangesPerRealDayInInterval* c=(ConstraintStudentsMaxBuildingChangesPerRealDayInInterval*)ctr;
					stream<<*c;
					break;
				}
			//55
			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxBuildingChangesPerRealDayInInterval* c=(ConstraintStudentsSetMaxBuildingChangesPerRealDayInInterval*)ctr;
					stream<<*c;
					break;
				}
			//56
			case CONSTRAINT_TEACHERS_MAX_BUILDING_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintTeachersMaxBuildingChangesPerRealDayInInterval* c=(ConstraintTeachersMaxBuildingChangesPerRealDayInInterval*)ctr;
					stream<<*c;
					break;
				}
			//57
			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintTeacherMaxBuildingChangesPerRealDayInInterval* c=(ConstraintTeacherMaxBuildingChangesPerRealDayInInterval*)ctr;
					stream<<*c;
					break;
				}
			//58
			case CONSTRAINT_STUDENTS_MAX_ROOM_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintStudentsMaxRoomChangesPerDayInInterval* c=(ConstraintStudentsMaxRoomChangesPerDayInInterval*)ctr;
					stream<<*c;
					break;
				}
			//59
			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxRoomChangesPerDayInInterval* c=(ConstraintStudentsSetMaxRoomChangesPerDayInInterval*)ctr;
					stream<<*c;
					break;
				}
			//60
			case CONSTRAINT_TEACHERS_MAX_ROOM_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintTeachersMaxRoomChangesPerDayInInterval* c=(ConstraintTeachersMaxRoomChangesPerDayInInterval*)ctr;
					stream<<*c;
					break;
				}
			//61
			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintTeacherMaxRoomChangesPerDayInInterval* c=(ConstraintTeacherMaxRoomChangesPerDayInInterval*)ctr;
					stream<<*c;
					break;
				}
			//62
			case CONSTRAINT_STUDENTS_MAX_ROOM_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintStudentsMaxRoomChangesPerRealDayInInterval* c=(ConstraintStudentsMaxRoomChangesPerRealDayInInterval*)ctr;
					stream<<*c;
					break;
				}
			//63
			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxRoomChangesPerRealDayInInterval* c=(ConstraintStudentsSetMaxRoomChangesPerRealDayInInterval*)ctr;
					stream<<*c;
					break;
				}
			//64
			case CONSTRAINT_TEACHERS_MAX_ROOM_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintTeachersMaxRoomChangesPerRealDayInInterval* c=(ConstraintTeachersMaxRoomChangesPerRealDayInInterval*)ctr;
					stream<<*c;
					break;
				}
			//65
			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintTeacherMaxRoomChangesPerRealDayInInterval* c=(ConstraintTeacherMaxRoomChangesPerRealDayInInterval*)ctr;
					stream<<*c;
					break;
				}
			//66
			case CONSTRAINT_ROOM_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintRoomMaxActivityTagsPerDayFromSet* c=(ConstraintRoomMaxActivityTagsPerDayFromSet*)ctr;
					stream<<*c;
					break;
				}
			//67
			case CONSTRAINT_ROOM_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintRoomMaxActivityTagsPerRealDayFromSet* c=(ConstraintRoomMaxActivityTagsPerRealDayFromSet*)ctr;
					stream<<*c;
					break;
				}
			//68
			case CONSTRAINT_ROOM_MAX_ACTIVITY_TAGS_PER_WEEK_FROM_SET:
				{
					ConstraintRoomMaxActivityTagsPerWeekFromSet* c=(ConstraintRoomMaxActivityTagsPerWeekFromSet*)ctr;
					stream<<*c;
					break;
				}
			
			default:
				assert(0);
				break;
		}
	}

	//stream<<rules.groupActivitiesInInitialOrderList;
	int nga=rules.groupActivitiesInInitialOrderList.count();
	stream<<nga;
	for(int i=0; i<nga; i++)
		stream<<*(rules.groupActivitiesInInitialOrderList.at(i));

	return stream;
}

QDataStream& operator>>(QDataStream& stream, Rules& rules)
{
	rules.clear();
	rules.init();

	stream>>rules.mode;

	stream>>rules.institutionName;
	stream>>rules.comments;

	stream>>rules.nTerms;
	stream>>rules.nDaysPerTerm;

	stream>>rules.nDaysPerWeek;
	stream>>rules.daysOfTheWeek;
	stream>>rules.daysOfTheWeek_longNames;

	stream>>rules.nRealDaysPerWeek;
	stream>>rules.realDaysOfTheWeek;
	stream>>rules.realDaysOfTheWeek_longNames;

	stream>>rules.nHoursPerDay;
	stream>>rules.hoursOfTheDay;
	stream>>rules.hoursOfTheDay_longNames;

	stream>>rules.nRealHoursPerDay;
	stream>>rules.realHoursOfTheDay;
	stream>>rules.realHoursOfTheDay_longNames;

	int ntch;
	stream>>ntch;
	for(int i=0; i<ntch; i++){
		Teacher* tch=new Teacher;
		stream>>*tch;
		rules.teachersList.append(tch);
		tch->recomputeQualifiedSubjectsHash();
	}

	int nsbj;
	stream>>nsbj;
	for(int i=0; i<nsbj; i++){
		Subject* sbj=new Subject;
		stream>>*sbj;
		rules.subjectsList.append(sbj);
	}

	int nat;
	stream>>nat;
	for(int i=0; i<nat; i++){
		ActivityTag* at=new ActivityTag;
		stream>>*at;
		rules.activityTagsList.append(at);
	}

	/*int ny;
	stream>>ny;
	//cout<<"ny="<<ny<<endl;
	for(int i=0; i<ny; i++){
		StudentsYear* year=new StudentsYear;
		stream>>*year;
		rules.yearsList.append(year);
	}*/
	int nss;
	stream>>nss;
	//cout<<"nss="<<nss<<endl;
	QHash<StudentsSet*, QList<int>> containedStudentsSetsList;
	QList<StudentsSet*> readStudentsSetsList;
	for(int i=0; i<nss; i++){
		int type;
		stream>>type;
		if(type==STUDENTS_YEAR){
			StudentsYear* year=new StudentsYear;
			rules.yearsList.append(year);
			readStudentsSetsList.append(year);
			stream>>year->name;
			stream>>year->longName;
			stream>>year->code;
			stream>>year->numberOfStudents;
			//stream>>year->type;
			
			stream>>year->comments;
			
			QList<int> tl;
			stream>>tl;
			if(!tl.empty())
				containedStudentsSetsList.insert(year, tl);
			
			stream>>year->divisions;
			stream>>year->separator;

			stream>>year->firstCategoryIsPermanent;
		}
		else if(type==STUDENTS_GROUP){
			StudentsGroup* group=new StudentsGroup;
			readStudentsSetsList.append(group);
			stream>>group->name;
			stream>>group->longName;
			stream>>group->code;
			stream>>group->numberOfStudents;
			//stream>>group->type;
			
			stream>>group->comments;
			
			QList<int> tl;
			stream>>tl;
			if(!tl.empty())
				containedStudentsSetsList.insert(group, tl);
		}
		else if(type==STUDENTS_SUBGROUP){
			StudentsSubgroup* subgroup=new StudentsSubgroup;
			readStudentsSetsList.append(subgroup);
			stream>>subgroup->name;
			stream>>subgroup->longName;
			stream>>subgroup->code;
			stream>>subgroup->numberOfStudents;
			//stream>>subgroup->type;
			
			stream>>subgroup->comments;
		}
		else{
			//commented, so that the program won't crash on wrong history files.
			//assert(0);
		}
	}
	for(int i=0; i<nss; i++){
		StudentsSet* ss=readStudentsSetsList.at(i);
		if(ss->type==STUDENTS_YEAR){
			StudentsYear* year=(StudentsYear*)ss;
			QList<int> tl=containedStudentsSetsList.value(year, QList<int>());
			for(int gi : std::as_const(tl)){
				StudentsSet* ss2=readStudentsSetsList.at(gi);
				assert(ss2->type==STUDENTS_GROUP);
				year->groupsList.append((StudentsGroup*)ss2);
			}
		}
		else if(ss->type==STUDENTS_GROUP){
			StudentsGroup* group=(StudentsGroup*)ss;
			QList<int> tl=containedStudentsSetsList.value(group, QList<int>());
			for(int si : std::as_const(tl)){
				StudentsSet* ss2=readStudentsSetsList.at(si);
				assert(ss2->type==STUDENTS_SUBGROUP);
				group->subgroupsList.append((StudentsSubgroup*)ss2);
			}
		}
		else{
			assert(ss->type==STUDENTS_SUBGROUP);
		}
	}
	assert(rules.permanentStudentsHash.isEmpty()); //done in init() above. Also, it will be cleared again in computePermanentStudentsHash() below.
	rules.computePermanentStudentsHash();

	int na;
	stream>>na;
	//cout<<"na="<<na<<endl;
	for(int i=0; i<na; i++){
		Activity* act=new Activity;
		stream>>*act;
		
		//cout<<"act->id="<<act->id<<endl;
		//cout<<"act->agid="<<act->activityGroupId<<endl;
		//cout<<endl;
		
		rules.activitiesList.append(act);
	}
	//rules.activitiesPointerHash.clear();
	assert(rules.activitiesPointerHash.isEmpty()); //done in init() above
	for(Activity* act : std::as_const(rules.activitiesList)){
		//if(rules.activitiesPointerHash.contains(act->id))
		//	cout<<"act->id="<<act->id<<endl;
		assert(!rules.activitiesPointerHash.contains(act->id));
		rules.activitiesPointerHash.insert(act->id, act);
	}

	int nrm;
	stream>>nrm;
	for(int i=0; i<nrm; i++){
		Room* rm=new Room;
		stream>>*rm;
		rules.roomsList.append(rm);
	}

	int nbd;
	stream>>nbd;
	for(int i=0; i<nbd; i++){
		Building* bd=new Building;
		stream>>*bd;
		rules.buildingsList.append(bd);
	}

	//stream>>rules.timeConstraintsList;
	int ntc;
	stream>>ntc;
	//cout<<"ntc="<<ntc<<endl;
	for(int i=0; i<ntc; i++){
		int type;
		stream>>type;
		
		switch(type){
			//1
			case CONSTRAINT_BASIC_COMPULSORY_TIME:
				{
					ConstraintBasicCompulsoryTime* c=new ConstraintBasicCompulsoryTime;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//2
			case CONSTRAINT_TWO_ACTIVITIES_CONSECUTIVE:
				{
					ConstraintTwoActivitiesConsecutive* c=new ConstraintTwoActivitiesConsecutive;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//3
			case CONSTRAINT_TWO_ACTIVITIES_ORDERED:
				{
					ConstraintTwoActivitiesOrdered* c=new ConstraintTwoActivitiesOrdered;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//4
			case CONSTRAINT_ACTIVITY_PREFERRED_TIME_SLOTS:
				{
					ConstraintActivityPreferredTimeSlots* c=new ConstraintActivityPreferredTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//5
			case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIMES:
				{
					ConstraintActivityPreferredStartingTimes* c=new ConstraintActivityPreferredStartingTimes;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//6
			case CONSTRAINT_ACTIVITIES_PREFERRED_TIME_SLOTS:
				{
					ConstraintActivitiesPreferredTimeSlots* c=new ConstraintActivitiesPreferredTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//7
			case CONSTRAINT_ACTIVITIES_PREFERRED_STARTING_TIMES:
				{
					ConstraintActivitiesPreferredStartingTimes* c=new ConstraintActivitiesPreferredStartingTimes;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//8
			case CONSTRAINT_SUBACTIVITIES_PREFERRED_TIME_SLOTS:
				{
					ConstraintSubactivitiesPreferredTimeSlots* c=new ConstraintSubactivitiesPreferredTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//9
			case CONSTRAINT_SUBACTIVITIES_PREFERRED_STARTING_TIMES:
				{
					ConstraintSubactivitiesPreferredStartingTimes* c=new ConstraintSubactivitiesPreferredStartingTimes;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//10
			case CONSTRAINT_ACTIVITIES_SAME_STARTING_TIME:
				{
					ConstraintActivitiesSameStartingTime* c=new ConstraintActivitiesSameStartingTime;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//11
			case CONSTRAINT_ACTIVITIES_SAME_STARTING_HOUR:
				{
					ConstraintActivitiesSameStartingHour* c=new ConstraintActivitiesSameStartingHour;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//12
			case CONSTRAINT_ACTIVITIES_SAME_STARTING_DAY:
				{
					ConstraintActivitiesSameStartingDay* c=new ConstraintActivitiesSameStartingDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//13
			case CONSTRAINT_TEACHER_NOT_AVAILABLE_TIMES:
				{
					ConstraintTeacherNotAvailableTimes* c=new ConstraintTeacherNotAvailableTimes;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//14
			case CONSTRAINT_STUDENTS_SET_NOT_AVAILABLE_TIMES:
				{
					ConstraintStudentsSetNotAvailableTimes* c=new ConstraintStudentsSetNotAvailableTimes;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//15
			case CONSTRAINT_BREAK_TIMES:
				{
					ConstraintBreakTimes* c=new ConstraintBreakTimes;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//16
			case CONSTRAINT_TEACHER_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeacherMaxDaysPerWeek* c=new ConstraintTeacherMaxDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//17
			case CONSTRAINT_TEACHERS_MAX_HOURS_DAILY:
				{
					ConstraintTeachersMaxHoursDaily* c=new ConstraintTeachersMaxHoursDaily;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//18
			case CONSTRAINT_TEACHER_MAX_HOURS_DAILY:
				{
					ConstraintTeacherMaxHoursDaily* c=new ConstraintTeacherMaxHoursDaily;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//19
			case CONSTRAINT_TEACHERS_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintTeachersMaxHoursContinuously* c=new ConstraintTeachersMaxHoursContinuously;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//20
			case CONSTRAINT_TEACHER_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintTeacherMaxHoursContinuously* c=new ConstraintTeacherMaxHoursContinuously;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//21
			case CONSTRAINT_TEACHERS_MIN_HOURS_DAILY:
				{
					ConstraintTeachersMinHoursDaily* c=new ConstraintTeachersMinHoursDaily;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//22
			case CONSTRAINT_TEACHER_MIN_HOURS_DAILY:
				{
					ConstraintTeacherMinHoursDaily* c=new ConstraintTeacherMinHoursDaily;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//23
			case CONSTRAINT_TEACHERS_MAX_GAPS_PER_WEEK:
				{
					ConstraintTeachersMaxGapsPerWeek* c=new ConstraintTeachersMaxGapsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//24
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_WEEK:
				{
					ConstraintTeacherMaxGapsPerWeek* c=new ConstraintTeacherMaxGapsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//25
			case CONSTRAINT_TEACHERS_MAX_GAPS_PER_DAY:
				{
					ConstraintTeachersMaxGapsPerDay* c=new ConstraintTeachersMaxGapsPerDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//26
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_DAY:
				{
					ConstraintTeacherMaxGapsPerDay* c=new ConstraintTeacherMaxGapsPerDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//27
			case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIME:
				{
					ConstraintActivityPreferredStartingTime* c=new ConstraintActivityPreferredStartingTime;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//28
			case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_WEEK:
				{
					ConstraintStudentsSetMaxGapsPerWeek* c=new ConstraintStudentsSetMaxGapsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//29
			case CONSTRAINT_STUDENTS_MAX_GAPS_PER_WEEK:
				{
					ConstraintStudentsMaxGapsPerWeek* c=new ConstraintStudentsMaxGapsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//30
			case CONSTRAINT_STUDENTS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintStudentsEarlyMaxBeginningsAtSecondHour* c=new ConstraintStudentsEarlyMaxBeginningsAtSecondHour;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//31
			case CONSTRAINT_STUDENTS_SET_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour* c=new ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//32
			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY:
				{
					ConstraintStudentsSetMaxHoursDaily* c=new ConstraintStudentsSetMaxHoursDaily;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//33
			case CONSTRAINT_STUDENTS_MAX_HOURS_DAILY:
				{
					ConstraintStudentsMaxHoursDaily* c=new ConstraintStudentsMaxHoursDaily;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//34
			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintStudentsSetMaxHoursContinuously* c=new ConstraintStudentsSetMaxHoursContinuously;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//35
			case CONSTRAINT_STUDENTS_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintStudentsMaxHoursContinuously* c=new ConstraintStudentsMaxHoursContinuously;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//36
			case CONSTRAINT_STUDENTS_SET_MIN_HOURS_DAILY:
				{
					ConstraintStudentsSetMinHoursDaily* c=new ConstraintStudentsSetMinHoursDaily;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//37
			case CONSTRAINT_STUDENTS_MIN_HOURS_DAILY:
				{
					ConstraintStudentsMinHoursDaily* c=new ConstraintStudentsMinHoursDaily;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//38
			case CONSTRAINT_ACTIVITIES_NOT_OVERLAPPING:
				{
					ConstraintActivitiesNotOverlapping* c=new ConstraintActivitiesNotOverlapping;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//39
			case CONSTRAINT_MIN_DAYS_BETWEEN_ACTIVITIES:
				{
					ConstraintMinDaysBetweenActivities* c=new ConstraintMinDaysBetweenActivities;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//40
			case CONSTRAINT_MIN_GAPS_BETWEEN_ACTIVITIES:
				{
					ConstraintMinGapsBetweenActivities* c=new ConstraintMinGapsBetweenActivities;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//41
			case CONSTRAINT_ACTIVITY_ENDS_STUDENTS_DAY:
				{
					ConstraintActivityEndsStudentsDay* c=new ConstraintActivityEndsStudentsDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//42
			case CONSTRAINT_TEACHER_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeacherIntervalMaxDaysPerWeek* c=new ConstraintTeacherIntervalMaxDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//43
			case CONSTRAINT_TEACHERS_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeachersIntervalMaxDaysPerWeek* c=new ConstraintTeachersIntervalMaxDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//44
			case CONSTRAINT_STUDENTS_SET_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetIntervalMaxDaysPerWeek* c=new ConstraintStudentsSetIntervalMaxDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//45
			case CONSTRAINT_STUDENTS_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsIntervalMaxDaysPerWeek* c=new ConstraintStudentsIntervalMaxDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//46
			case CONSTRAINT_ACTIVITIES_END_STUDENTS_DAY:
				{
					ConstraintActivitiesEndStudentsDay* c=new ConstraintActivitiesEndStudentsDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//47
			case CONSTRAINT_TWO_ACTIVITIES_GROUPED:
				{
					ConstraintTwoActivitiesGrouped* c=new ConstraintTwoActivitiesGrouped;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//48
			case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintTeachersActivityTagMaxHoursContinuously* c=new ConstraintTeachersActivityTagMaxHoursContinuously;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//49
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintTeacherActivityTagMaxHoursContinuously* c=new ConstraintTeacherActivityTagMaxHoursContinuously;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//50
			case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintStudentsActivityTagMaxHoursContinuously* c=new ConstraintStudentsActivityTagMaxHoursContinuously;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//51
			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintStudentsSetActivityTagMaxHoursContinuously* c=new ConstraintStudentsSetActivityTagMaxHoursContinuously;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//52
			case CONSTRAINT_TEACHERS_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeachersMaxDaysPerWeek* c=new ConstraintTeachersMaxDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//53
			case CONSTRAINT_THREE_ACTIVITIES_GROUPED:
				{
					ConstraintThreeActivitiesGrouped* c=new ConstraintThreeActivitiesGrouped;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//54
			case CONSTRAINT_MAX_DAYS_BETWEEN_ACTIVITIES:
				{
					ConstraintMaxDaysBetweenActivities* c=new ConstraintMaxDaysBetweenActivities;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//55
			case CONSTRAINT_TEACHERS_MIN_DAYS_PER_WEEK:
				{
					ConstraintTeachersMinDaysPerWeek* c=new ConstraintTeachersMinDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//56
			case CONSTRAINT_TEACHER_MIN_DAYS_PER_WEEK:
				{
					ConstraintTeacherMinDaysPerWeek* c=new ConstraintTeacherMinDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//57
			case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_DAILY:
				{
					ConstraintTeachersActivityTagMaxHoursDaily* c=new ConstraintTeachersActivityTagMaxHoursDaily;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//58
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_DAILY:
				{
					ConstraintTeacherActivityTagMaxHoursDaily* c=new ConstraintTeacherActivityTagMaxHoursDaily;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//59
			case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_DAILY:
				{
					ConstraintStudentsActivityTagMaxHoursDaily* c=new ConstraintStudentsActivityTagMaxHoursDaily;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//60
			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY:
				{
					ConstraintStudentsSetActivityTagMaxHoursDaily* c=new ConstraintStudentsSetActivityTagMaxHoursDaily;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}

			//61
			case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_DAY:
				{
					ConstraintStudentsSetMaxGapsPerDay* c=new ConstraintStudentsSetMaxGapsPerDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//62
			case CONSTRAINT_STUDENTS_MAX_GAPS_PER_DAY:
				{
					ConstraintStudentsMaxGapsPerDay* c=new ConstraintStudentsMaxGapsPerDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//63
			case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintActivitiesOccupyMaxTimeSlotsFromSelection* c=new ConstraintActivitiesOccupyMaxTimeSlotsFromSelection;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//64
			case CONSTRAINT_ACTIVITIES_MAX_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots* c=new ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//65
			case CONSTRAINT_STUDENTS_SET_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetMaxDaysPerWeek* c=new ConstraintStudentsSetMaxDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//66
			case CONSTRAINT_STUDENTS_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsMaxDaysPerWeek* c=new ConstraintStudentsMaxDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//2017-02-07
			//67
			case CONSTRAINT_TEACHER_MAX_SPAN_PER_DAY:
				{
					ConstraintTeacherMaxSpanPerDay* c=new ConstraintTeacherMaxSpanPerDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//68
			case CONSTRAINT_TEACHERS_MAX_SPAN_PER_DAY:
				{
					ConstraintTeachersMaxSpanPerDay* c=new ConstraintTeachersMaxSpanPerDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//69
			case CONSTRAINT_STUDENTS_SET_MAX_SPAN_PER_DAY:
				{
					ConstraintStudentsSetMaxSpanPerDay* c=new ConstraintStudentsSetMaxSpanPerDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//70
			case CONSTRAINT_STUDENTS_MAX_SPAN_PER_DAY:
				{
					ConstraintStudentsMaxSpanPerDay* c=new ConstraintStudentsMaxSpanPerDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//71
			case CONSTRAINT_TEACHER_MIN_RESTING_HOURS:
				{
					ConstraintTeacherMinRestingHours* c=new ConstraintTeacherMinRestingHours;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//72
			case CONSTRAINT_TEACHERS_MIN_RESTING_HOURS:
				{
					ConstraintTeachersMinRestingHours* c=new ConstraintTeachersMinRestingHours;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//73
			case CONSTRAINT_STUDENTS_SET_MIN_RESTING_HOURS:
				{
					ConstraintStudentsSetMinRestingHours* c=new ConstraintStudentsSetMinRestingHours;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//74
			case CONSTRAINT_STUDENTS_MIN_RESTING_HOURS:
				{
					ConstraintStudentsMinRestingHours* c=new ConstraintStudentsMinRestingHours;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//2018-06-13
			//75
			case CONSTRAINT_TWO_ACTIVITIES_ORDERED_IF_SAME_DAY:
				{
					ConstraintTwoActivitiesOrderedIfSameDay* c=new ConstraintTwoActivitiesOrderedIfSameDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//2019-06-09
			//76
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
				{
					ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTags* c=new ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTags;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//77
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
				{
					ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTags* c=new ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTags;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//78
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
				{
					ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTags* c=new ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTags;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//79
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
				{
					ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTags* c=new ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTags;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//80
			case CONSTRAINT_ACTIVITY_TAGS_NOT_OVERLAPPING:
				{
					ConstraintActivityTagsNotOverlapping* c=new ConstraintActivityTagsNotOverlapping;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//81
			case CONSTRAINT_ACTIVITIES_OCCUPY_MIN_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintActivitiesOccupyMinTimeSlotsFromSelection* c=new ConstraintActivitiesOccupyMinTimeSlotsFromSelection;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//82
			case CONSTRAINT_ACTIVITIES_MIN_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintActivitiesMinSimultaneousInSelectedTimeSlots* c=new ConstraintActivitiesMinSimultaneousInSelectedTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}

			//83
			case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MIN_HOURS_DAILY:
				{
					ConstraintTeachersActivityTagMinHoursDaily* c=new ConstraintTeachersActivityTagMinHoursDaily;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//84
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MIN_HOURS_DAILY:
				{
					ConstraintTeacherActivityTagMinHoursDaily* c=new ConstraintTeacherActivityTagMinHoursDaily;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//85
			case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MIN_HOURS_DAILY:
				{
					ConstraintStudentsActivityTagMinHoursDaily* c=new ConstraintStudentsActivityTagMinHoursDaily;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//86
			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MIN_HOURS_DAILY:
				{
					ConstraintStudentsSetActivityTagMinHoursDaily* c=new ConstraintStudentsSetActivityTagMinHoursDaily;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//87
			case CONSTRAINT_ACTIVITY_ENDS_TEACHERS_DAY:
				{
					ConstraintActivityEndsTeachersDay* c=new ConstraintActivityEndsTeachersDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//88
			case CONSTRAINT_ACTIVITIES_END_TEACHERS_DAY:
				{
					ConstraintActivitiesEndTeachersDay* c=new ConstraintActivitiesEndTeachersDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}

			//mornings-afternoons
			//89
			case CONSTRAINT_TEACHER_MAX_AFTERNOONS_PER_WEEK:
				{
					ConstraintTeacherMaxAfternoonsPerWeek* c=new ConstraintTeacherMaxAfternoonsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//90
			case CONSTRAINT_TEACHERS_MAX_AFTERNOONS_PER_WEEK:
				{
					ConstraintTeachersMaxAfternoonsPerWeek* c=new ConstraintTeachersMaxAfternoonsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//91
			case CONSTRAINT_TEACHER_MAX_MORNINGS_PER_WEEK:
				{
					ConstraintTeacherMaxMorningsPerWeek* c=new ConstraintTeacherMaxMorningsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//92
			case CONSTRAINT_TEACHERS_MAX_MORNINGS_PER_WEEK:
				{
					ConstraintTeachersMaxMorningsPerWeek* c=new ConstraintTeachersMaxMorningsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//93
			case CONSTRAINT_TEACHER_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintTeacherMaxActivityTagsPerDayFromSet* c=new ConstraintTeacherMaxActivityTagsPerDayFromSet;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//94
			case CONSTRAINT_TEACHERS_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintTeachersMaxActivityTagsPerDayFromSet* c=new ConstraintTeachersMaxActivityTagsPerDayFromSet;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//95
			case CONSTRAINT_TEACHER_MIN_MORNINGS_PER_WEEK:
				{
					ConstraintTeacherMinMorningsPerWeek* c=new ConstraintTeacherMinMorningsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//96
			case CONSTRAINT_TEACHERS_MIN_MORNINGS_PER_WEEK:
				{
					ConstraintTeachersMinMorningsPerWeek* c=new ConstraintTeachersMinMorningsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//97
			case CONSTRAINT_TEACHER_MIN_AFTERNOONS_PER_WEEK:
				{
					ConstraintTeacherMinAfternoonsPerWeek* c=new ConstraintTeacherMinAfternoonsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//98
			case CONSTRAINT_TEACHERS_MIN_AFTERNOONS_PER_WEEK:
				{
					ConstraintTeachersMinAfternoonsPerWeek* c=new ConstraintTeachersMinAfternoonsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//99
			case CONSTRAINT_TEACHER_MAX_TWO_CONSECUTIVE_MORNINGS:
				{
					ConstraintTeacherMaxTwoConsecutiveMornings* c=new ConstraintTeacherMaxTwoConsecutiveMornings;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//100
			case CONSTRAINT_TEACHERS_MAX_TWO_CONSECUTIVE_MORNINGS:
				{
					ConstraintTeachersMaxTwoConsecutiveMornings* c=new ConstraintTeachersMaxTwoConsecutiveMornings;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//101
			case CONSTRAINT_TEACHER_MAX_TWO_CONSECUTIVE_AFTERNOONS:
				{
					ConstraintTeacherMaxTwoConsecutiveAfternoons* c=new ConstraintTeacherMaxTwoConsecutiveAfternoons;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//102
			case CONSTRAINT_TEACHERS_MAX_TWO_CONSECUTIVE_AFTERNOONS:
				{
					ConstraintTeachersMaxTwoConsecutiveAfternoons* c=new ConstraintTeachersMaxTwoConsecutiveAfternoons;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//103
			case CONSTRAINT_TEACHERS_MAX_GAPS_PER_REAL_DAY:
				{
					ConstraintTeachersMaxGapsPerRealDay* c=new ConstraintTeachersMaxGapsPerRealDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//104
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_REAL_DAY:
				{
					ConstraintTeacherMaxGapsPerRealDay* c=new ConstraintTeacherMaxGapsPerRealDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//105
			case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_REAL_DAY:
				{
					ConstraintStudentsSetMaxGapsPerRealDay* c=new ConstraintStudentsSetMaxGapsPerRealDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//106
			case CONSTRAINT_STUDENTS_MAX_GAPS_PER_REAL_DAY:
				{
					ConstraintStudentsMaxGapsPerRealDay* c=new ConstraintStudentsMaxGapsPerRealDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}

			//107
			case CONSTRAINT_TEACHERS_MIN_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeachersMinHoursDailyRealDays* c=new ConstraintTeachersMinHoursDailyRealDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//108
			case CONSTRAINT_TEACHER_MIN_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeacherMinHoursDailyRealDays* c=new ConstraintTeacherMinHoursDailyRealDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}

			//109
			case CONSTRAINT_TEACHERS_MIN_HOURS_PER_MORNING:
				{
					ConstraintTeachersMinHoursPerMorning* c=new ConstraintTeachersMinHoursPerMorning;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//110
			case CONSTRAINT_TEACHER_MIN_HOURS_PER_MORNING:
				{
					ConstraintTeacherMinHoursPerMorning* c=new ConstraintTeacherMinHoursPerMorning;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//2017-02-07
			//111
			case CONSTRAINT_TEACHER_MAX_SPAN_PER_REAL_DAY:
				{
					ConstraintTeacherMaxSpanPerRealDay* c=new ConstraintTeacherMaxSpanPerRealDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//112
			case CONSTRAINT_TEACHERS_MAX_SPAN_PER_REAL_DAY:
				{
					ConstraintTeachersMaxSpanPerRealDay* c=new ConstraintTeachersMaxSpanPerRealDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//113
			case CONSTRAINT_STUDENTS_SET_MAX_SPAN_PER_REAL_DAY:
				{
					ConstraintStudentsSetMaxSpanPerRealDay* c=new ConstraintStudentsSetMaxSpanPerRealDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//114
			case CONSTRAINT_STUDENTS_MAX_SPAN_PER_REAL_DAY:
				{
					ConstraintStudentsMaxSpanPerRealDay* c=new ConstraintStudentsMaxSpanPerRealDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}

			//115
			case CONSTRAINT_TEACHER_MORNING_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeacherMorningIntervalMaxDaysPerWeek* c=new ConstraintTeacherMorningIntervalMaxDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//116
			case CONSTRAINT_TEACHERS_MORNING_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeachersMorningIntervalMaxDaysPerWeek* c=new ConstraintTeachersMorningIntervalMaxDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}

			//117
			case CONSTRAINT_TEACHER_AFTERNOON_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeacherAfternoonIntervalMaxDaysPerWeek* c=new ConstraintTeacherAfternoonIntervalMaxDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//118
			case CONSTRAINT_TEACHERS_AFTERNOON_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeachersAfternoonIntervalMaxDaysPerWeek* c=new ConstraintTeachersAfternoonIntervalMaxDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//119
			case CONSTRAINT_STUDENTS_SET_MIN_HOURS_PER_MORNING:
				{
					ConstraintStudentsSetMinHoursPerMorning* c=new ConstraintStudentsSetMinHoursPerMorning;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//120
			case CONSTRAINT_STUDENTS_MIN_HOURS_PER_MORNING:
				{
					ConstraintStudentsMinHoursPerMorning* c=new ConstraintStudentsMinHoursPerMorning;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}

			//121
			case CONSTRAINT_TEACHERS_MAX_ZERO_GAPS_PER_AFTERNOON:
				{
					ConstraintTeachersMaxZeroGapsPerAfternoon* c=new ConstraintTeachersMaxZeroGapsPerAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//122
			case CONSTRAINT_TEACHER_MAX_ZERO_GAPS_PER_AFTERNOON:
				{
					ConstraintTeacherMaxZeroGapsPerAfternoon* c=new ConstraintTeacherMaxZeroGapsPerAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//123
			case CONSTRAINT_STUDENTS_SET_MAX_AFTERNOONS_PER_WEEK:
				{
					ConstraintStudentsSetMaxAfternoonsPerWeek* c=new ConstraintStudentsSetMaxAfternoonsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//124
			case CONSTRAINT_STUDENTS_MAX_AFTERNOONS_PER_WEEK:
				{
					ConstraintStudentsMaxAfternoonsPerWeek* c=new ConstraintStudentsMaxAfternoonsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//125
			case CONSTRAINT_STUDENTS_SET_MAX_MORNINGS_PER_WEEK:
				{
					ConstraintStudentsSetMaxMorningsPerWeek* c=new ConstraintStudentsSetMaxMorningsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//126
			case CONSTRAINT_STUDENTS_MAX_MORNINGS_PER_WEEK:
				{
					ConstraintStudentsMaxMorningsPerWeek* c=new ConstraintStudentsMaxMorningsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			/////
			//127
			case CONSTRAINT_STUDENTS_SET_MIN_AFTERNOONS_PER_WEEK:
				{
					ConstraintStudentsSetMinAfternoonsPerWeek* c=new ConstraintStudentsSetMinAfternoonsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//128
			case CONSTRAINT_STUDENTS_MIN_AFTERNOONS_PER_WEEK:
				{
					ConstraintStudentsMinAfternoonsPerWeek* c=new ConstraintStudentsMinAfternoonsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//129
			case CONSTRAINT_STUDENTS_SET_MIN_MORNINGS_PER_WEEK:
				{
					ConstraintStudentsSetMinMorningsPerWeek* c=new ConstraintStudentsSetMinMorningsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//130
			case CONSTRAINT_STUDENTS_MIN_MORNINGS_PER_WEEK:
				{
					ConstraintStudentsMinMorningsPerWeek* c=new ConstraintStudentsMinMorningsPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//131
			case CONSTRAINT_STUDENTS_SET_MORNING_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetMorningIntervalMaxDaysPerWeek* c=new ConstraintStudentsSetMorningIntervalMaxDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//132
			case CONSTRAINT_STUDENTS_MORNING_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsMorningIntervalMaxDaysPerWeek* c=new ConstraintStudentsMorningIntervalMaxDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//133
			case CONSTRAINT_STUDENTS_SET_AFTERNOON_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetAfternoonIntervalMaxDaysPerWeek* c=new ConstraintStudentsSetAfternoonIntervalMaxDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//134
			case CONSTRAINT_STUDENTS_AFTERNOON_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsAfternoonIntervalMaxDaysPerWeek* c=new ConstraintStudentsAfternoonIntervalMaxDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//2020-06-28
			//135
			case CONSTRAINT_TEACHER_MAX_HOURS_PER_ALL_AFTERNOONS:
				{
					ConstraintTeacherMaxHoursPerAllAfternoons* c=new ConstraintTeacherMaxHoursPerAllAfternoons;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//136
			case CONSTRAINT_TEACHERS_MAX_HOURS_PER_ALL_AFTERNOONS:
				{
					ConstraintTeachersMaxHoursPerAllAfternoons* c=new ConstraintTeachersMaxHoursPerAllAfternoons;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//137
			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_PER_ALL_AFTERNOONS:
				{
					ConstraintStudentsSetMaxHoursPerAllAfternoons* c=new ConstraintStudentsSetMaxHoursPerAllAfternoons;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//138
			case CONSTRAINT_STUDENTS_MAX_HOURS_PER_ALL_AFTERNOONS:
				{
					ConstraintStudentsMaxHoursPerAllAfternoons* c=new ConstraintStudentsMaxHoursPerAllAfternoons;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}

			//139
			case CONSTRAINT_TEACHER_MIN_RESTING_HOURS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeacherMinRestingHoursBetweenMorningAndAfternoon* c=new ConstraintTeacherMinRestingHoursBetweenMorningAndAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//140
			case CONSTRAINT_TEACHERS_MIN_RESTING_HOURS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeachersMinRestingHoursBetweenMorningAndAfternoon* c=new ConstraintTeachersMinRestingHoursBetweenMorningAndAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//141
			case CONSTRAINT_STUDENTS_SET_MIN_RESTING_HOURS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsSetMinRestingHoursBetweenMorningAndAfternoon* c=new ConstraintStudentsSetMinRestingHoursBetweenMorningAndAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//142
			case CONSTRAINT_STUDENTS_MIN_RESTING_HOURS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsMinRestingHoursBetweenMorningAndAfternoon* c=new ConstraintStudentsMinRestingHoursBetweenMorningAndAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			/////////
			//143
			case CONSTRAINT_STUDENTS_AFTERNOONS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintStudentsAfternoonsEarlyMaxBeginningsAtSecondHour* c=new ConstraintStudentsAfternoonsEarlyMaxBeginningsAtSecondHour;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//144
			case CONSTRAINT_STUDENTS_SET_AFTERNOONS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintStudentsSetAfternoonsEarlyMaxBeginningsAtSecondHour* c=new ConstraintStudentsSetAfternoonsEarlyMaxBeginningsAtSecondHour;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}

			//145
			case CONSTRAINT_TEACHERS_MAX_GAPS_PER_WEEK_FOR_REAL_DAYS:
				{
					ConstraintTeachersMaxGapsPerWeekForRealDays* c=new ConstraintTeachersMaxGapsPerWeekForRealDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//146
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_WEEK_FOR_REAL_DAYS:
				{
					ConstraintTeacherMaxGapsPerWeekForRealDays* c=new ConstraintTeacherMaxGapsPerWeekForRealDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//147
			case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_WEEK_FOR_REAL_DAYS:
				{
					ConstraintStudentsSetMaxGapsPerWeekForRealDays* c=new ConstraintStudentsSetMaxGapsPerWeekForRealDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//148
			case CONSTRAINT_STUDENTS_MAX_GAPS_PER_WEEK_FOR_REAL_DAYS:
				{
					ConstraintStudentsMaxGapsPerWeekForRealDays* c=new ConstraintStudentsMaxGapsPerWeekForRealDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}

			//149
			case CONSTRAINT_TEACHER_MAX_REAL_DAYS_PER_WEEK:
				{
					ConstraintTeacherMaxRealDaysPerWeek* c=new ConstraintTeacherMaxRealDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//150
			case CONSTRAINT_TEACHERS_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeachersMaxHoursDailyRealDays* c=new ConstraintTeachersMaxHoursDailyRealDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//151
			case CONSTRAINT_TEACHER_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeacherMaxHoursDailyRealDays* c=new ConstraintTeacherMaxHoursDailyRealDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//152
			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintStudentsSetMaxHoursDailyRealDays* c=new ConstraintStudentsSetMaxHoursDailyRealDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//153
			case CONSTRAINT_STUDENTS_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintStudentsMaxHoursDailyRealDays* c=new ConstraintStudentsMaxHoursDailyRealDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//154
			case CONSTRAINT_TEACHERS_MAX_REAL_DAYS_PER_WEEK:
				{
					ConstraintTeachersMaxRealDaysPerWeek* c=new ConstraintTeachersMaxRealDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//155
			case CONSTRAINT_TEACHERS_MIN_REAL_DAYS_PER_WEEK:
				{
					ConstraintTeachersMinRealDaysPerWeek* c=new ConstraintTeachersMinRealDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//156
			case CONSTRAINT_TEACHER_MIN_REAL_DAYS_PER_WEEK:
				{
					ConstraintTeacherMinRealDaysPerWeek* c=new ConstraintTeacherMinRealDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//157
			case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeachersActivityTagMaxHoursDailyRealDays* c=new ConstraintTeachersActivityTagMaxHoursDailyRealDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//158
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeacherActivityTagMaxHoursDailyRealDays* c=new ConstraintTeacherActivityTagMaxHoursDailyRealDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//159
			case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintStudentsActivityTagMaxHoursDailyRealDays* c=new ConstraintStudentsActivityTagMaxHoursDailyRealDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//160
			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintStudentsSetActivityTagMaxHoursDailyRealDays* c=new ConstraintStudentsSetActivityTagMaxHoursDailyRealDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}

			//161
			case CONSTRAINT_STUDENTS_SET_MAX_REAL_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetMaxRealDaysPerWeek* c=new ConstraintStudentsSetMaxRealDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//162
			case CONSTRAINT_STUDENTS_MAX_REAL_DAYS_PER_WEEK:
				{
					ConstraintStudentsMaxRealDaysPerWeek* c=new ConstraintStudentsMaxRealDaysPerWeek;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//163
			case CONSTRAINT_TEACHERS_AFTERNOONS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintTeachersAfternoonsEarlyMaxBeginningsAtSecondHour* c=new ConstraintTeachersAfternoonsEarlyMaxBeginningsAtSecondHour;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//164
			case CONSTRAINT_TEACHER_AFTERNOONS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintTeacherAfternoonsEarlyMaxBeginningsAtSecondHour* c=new ConstraintTeacherAfternoonsEarlyMaxBeginningsAtSecondHour;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//block-planning
			//165
			case CONSTRAINT_MAX_TOTAL_ACTIVITIES_FROM_SET_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots* c=new ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//166
			case CONSTRAINT_MAX_GAPS_BETWEEN_ACTIVITIES:
				{
					ConstraintMaxGapsBetweenActivities* c=new ConstraintMaxGapsBetweenActivities;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//terms
			//167
			case CONSTRAINT_ACTIVITIES_MAX_IN_A_TERM:
				{
					ConstraintActivitiesMaxInATerm* c=new ConstraintActivitiesMaxInATerm;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//168
			case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_TERMS:
				{
					ConstraintActivitiesOccupyMaxTerms* c=new ConstraintActivitiesOccupyMaxTerms;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//169
			case CONSTRAINT_TEACHERS_MAX_GAPS_PER_MORNING_AND_AFTERNOON:
				{
					ConstraintTeachersMaxGapsPerMorningAndAfternoon* c=new ConstraintTeachersMaxGapsPerMorningAndAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//170
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_MORNING_AND_AFTERNOON:
				{
					ConstraintTeacherMaxGapsPerMorningAndAfternoon* c=new ConstraintTeacherMaxGapsPerMorningAndAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//171
			case CONSTRAINT_STUDENTS_MORNINGS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintStudentsMorningsEarlyMaxBeginningsAtSecondHour* c=new ConstraintStudentsMorningsEarlyMaxBeginningsAtSecondHour;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//172
			case CONSTRAINT_STUDENTS_SET_MORNINGS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintStudentsSetMorningsEarlyMaxBeginningsAtSecondHour* c=new ConstraintStudentsSetMorningsEarlyMaxBeginningsAtSecondHour;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//173
			case CONSTRAINT_TEACHERS_MORNINGS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintTeachersMorningsEarlyMaxBeginningsAtSecondHour* c=new ConstraintTeachersMorningsEarlyMaxBeginningsAtSecondHour;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//174
			case CONSTRAINT_TEACHER_MORNINGS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintTeacherMorningsEarlyMaxBeginningsAtSecondHour* c=new ConstraintTeacherMorningsEarlyMaxBeginningsAtSecondHour;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//175
			case CONSTRAINT_TWO_SETS_OF_ACTIVITIES_ORDERED:
				{
					ConstraintTwoSetsOfActivitiesOrdered* c=new ConstraintTwoSetsOfActivitiesOrdered;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//176
			case CONSTRAINT_TEACHER_MAX_THREE_CONSECUTIVE_DAYS:
				{
					ConstraintTeacherMaxThreeConsecutiveDays* c=new ConstraintTeacherMaxThreeConsecutiveDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//177
			case CONSTRAINT_TEACHERS_MAX_THREE_CONSECUTIVE_DAYS:
				{
					ConstraintTeachersMaxThreeConsecutiveDays* c=new ConstraintTeachersMaxThreeConsecutiveDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//2021-12-15
			//178
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
				{
					ConstraintStudentsSetMinGapsBetweenActivityTag* c=new ConstraintStudentsSetMinGapsBetweenActivityTag;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//179
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
				{
					ConstraintStudentsMinGapsBetweenActivityTag* c=new ConstraintStudentsMinGapsBetweenActivityTag;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//180
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
				{
					ConstraintTeacherMinGapsBetweenActivityTag* c=new ConstraintTeacherMinGapsBetweenActivityTag;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//181
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
				{
					ConstraintTeachersMinGapsBetweenActivityTag* c=new ConstraintTeachersMinGapsBetweenActivityTag;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//2022-02-15
			//182
			case CONSTRAINT_STUDENTS_SET_MAX_THREE_CONSECUTIVE_DAYS:
				{
					ConstraintStudentsSetMaxThreeConsecutiveDays* c=new ConstraintStudentsSetMaxThreeConsecutiveDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//183
			case CONSTRAINT_STUDENTS_MAX_THREE_CONSECUTIVE_DAYS:
				{
					ConstraintStudentsMaxThreeConsecutiveDays* c=new ConstraintStudentsMaxThreeConsecutiveDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//184
			case CONSTRAINT_MIN_HALF_DAYS_BETWEEN_ACTIVITIES:
				{
					ConstraintMinHalfDaysBetweenActivities* c=new ConstraintMinHalfDaysBetweenActivities;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//185
			case CONSTRAINT_ACTIVITY_PREFERRED_DAY:
				{
					ConstraintActivityPreferredDay* c=new ConstraintActivityPreferredDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//186
			case CONSTRAINT_ACTIVITIES_MIN_IN_A_TERM:
				{
					ConstraintActivitiesMinInATerm* c=new ConstraintActivitiesMinInATerm;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//187
			case CONSTRAINT_MAX_TERMS_BETWEEN_ACTIVITIES:
				{
					ConstraintMaxTermsBetweenActivities* c=new ConstraintMaxTermsBetweenActivities;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//188
			case CONSTRAINT_STUDENTS_SET_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintStudentsSetMaxActivityTagsPerDayFromSet* c=new ConstraintStudentsSetMaxActivityTagsPerDayFromSet;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//189
			case CONSTRAINT_STUDENTS_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintStudentsMaxActivityTagsPerDayFromSet* c=new ConstraintStudentsMaxActivityTagsPerDayFromSet;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//190
			case CONSTRAINT_TEACHER_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintTeacherMaxActivityTagsPerRealDayFromSet* c=new ConstraintTeacherMaxActivityTagsPerRealDayFromSet;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//191
			case CONSTRAINT_TEACHERS_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintTeachersMaxActivityTagsPerRealDayFromSet* c=new ConstraintTeachersMaxActivityTagsPerRealDayFromSet;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//192
			case CONSTRAINT_STUDENTS_SET_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintStudentsSetMaxActivityTagsPerRealDayFromSet* c=new ConstraintStudentsSetMaxActivityTagsPerRealDayFromSet;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//193
			case CONSTRAINT_STUDENTS_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintStudentsMaxActivityTagsPerRealDayFromSet* c=new ConstraintStudentsMaxActivityTagsPerRealDayFromSet;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//194
			case CONSTRAINT_MAX_HALF_DAYS_BETWEEN_ACTIVITIES:
				{
					ConstraintMaxHalfDaysBetweenActivities* c=new ConstraintMaxHalfDaysBetweenActivities;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//195
			case CONSTRAINT_ACTIVITY_BEGINS_STUDENTS_DAY:
				{
					ConstraintActivityBeginsStudentsDay* c=new ConstraintActivityBeginsStudentsDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//196
			case CONSTRAINT_ACTIVITIES_BEGIN_STUDENTS_DAY:
				{
					ConstraintActivitiesBeginStudentsDay* c=new ConstraintActivitiesBeginStudentsDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//197
			case CONSTRAINT_ACTIVITY_BEGINS_TEACHERS_DAY:
				{
					ConstraintActivityBeginsTeachersDay* c=new ConstraintActivityBeginsTeachersDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//198
			case CONSTRAINT_ACTIVITIES_BEGIN_TEACHERS_DAY:
				{
					ConstraintActivitiesBeginTeachersDay* c=new ConstraintActivitiesBeginTeachersDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}

			//199
			case CONSTRAINT_TEACHERS_MIN_HOURS_PER_AFTERNOON:
				{
					ConstraintTeachersMinHoursPerAfternoon* c=new ConstraintTeachersMinHoursPerAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//200
			case CONSTRAINT_TEACHER_MIN_HOURS_PER_AFTERNOON:
				{
					ConstraintTeacherMinHoursPerAfternoon* c=new ConstraintTeacherMinHoursPerAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//201
			case CONSTRAINT_STUDENTS_SET_MIN_HOURS_PER_AFTERNOON:
				{
					ConstraintStudentsSetMinHoursPerAfternoon* c=new ConstraintStudentsSetMinHoursPerAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//202
			case CONSTRAINT_STUDENTS_MIN_HOURS_PER_AFTERNOON:
				{
					ConstraintStudentsMinHoursPerAfternoon* c=new ConstraintStudentsMinHoursPerAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}

			//203
			case CONSTRAINT_ACTIVITIES_MAX_HOURLY_SPAN:
				{
					ConstraintActivitiesMaxHourlySpan* c=new ConstraintActivitiesMaxHourlySpan;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}

			//204
			case CONSTRAINT_TEACHERS_MAX_HOURS_DAILY_IN_INTERVAL:
				{
					ConstraintTeachersMaxHoursDailyInInterval* c=new ConstraintTeachersMaxHoursDailyInInterval;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//205
			case CONSTRAINT_TEACHER_MAX_HOURS_DAILY_IN_INTERVAL:
				{
					ConstraintTeacherMaxHoursDailyInInterval* c=new ConstraintTeacherMaxHoursDailyInInterval;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//206
			case CONSTRAINT_STUDENTS_MAX_HOURS_DAILY_IN_INTERVAL:
				{
					ConstraintStudentsMaxHoursDailyInInterval* c=new ConstraintStudentsMaxHoursDailyInInterval;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//207
			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxHoursDailyInInterval* c=new ConstraintStudentsSetMaxHoursDailyInInterval;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//208
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
				{
					ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* c=new ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//209
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
				{
					ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* c=new ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsPerRealDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//210
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
				{
					ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* c=new ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsPerRealDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//211
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
				{
					ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* c=new ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsPerRealDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//212
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
				{
					ConstraintStudentsSetMinGapsBetweenActivityTagPerRealDay* c=new ConstraintStudentsSetMinGapsBetweenActivityTagPerRealDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//213
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
				{
					ConstraintStudentsMinGapsBetweenActivityTagPerRealDay* c=new ConstraintStudentsMinGapsBetweenActivityTagPerRealDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//214
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
				{
					ConstraintTeacherMinGapsBetweenActivityTagPerRealDay* c=new ConstraintTeacherMinGapsBetweenActivityTagPerRealDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//215
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
				{
					ConstraintTeachersMinGapsBetweenActivityTagPerRealDay* c=new ConstraintTeachersMinGapsBetweenActivityTagPerRealDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//216
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* c=new ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//217
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* c=new ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//218
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* c=new ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//219
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* c=new ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//220
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon* c=new ConstraintStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//221
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsMinGapsBetweenActivityTagBetweenMorningAndAfternoon* c=new ConstraintStudentsMinGapsBetweenActivityTagBetweenMorningAndAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//222
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeacherMinGapsBetweenActivityTagBetweenMorningAndAfternoon* c=new ConstraintTeacherMinGapsBetweenActivityTagBetweenMorningAndAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//223
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeachersMinGapsBetweenActivityTagBetweenMorningAndAfternoon* c=new ConstraintTeachersMinGapsBetweenActivityTagBetweenMorningAndAfternoon;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//224
			case CONSTRAINT_TEACHER_NO_TWO_CONSECUTIVE_DAYS:
				{
					ConstraintTeacherNoTwoConsecutiveDays* c=new ConstraintTeacherNoTwoConsecutiveDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//225
			case CONSTRAINT_TEACHERS_NO_TWO_CONSECUTIVE_DAYS:
				{
					ConstraintTeachersNoTwoConsecutiveDays* c=new ConstraintTeachersNoTwoConsecutiveDays;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//226
			case CONSTRAINT_TEACHER_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
				{
					ConstraintTeacherPairOfMutuallyExclusiveTimeSlots* c=new ConstraintTeacherPairOfMutuallyExclusiveTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//227
			case CONSTRAINT_TEACHERS_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
				{
					ConstraintTeachersPairOfMutuallyExclusiveTimeSlots* c=new ConstraintTeachersPairOfMutuallyExclusiveTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//228
			case CONSTRAINT_STUDENTS_SET_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
				{
					ConstraintStudentsSetPairOfMutuallyExclusiveTimeSlots* c=new ConstraintStudentsSetPairOfMutuallyExclusiveTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//229
			case CONSTRAINT_STUDENTS_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
				{
					ConstraintStudentsPairOfMutuallyExclusiveTimeSlots* c=new ConstraintStudentsPairOfMutuallyExclusiveTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//230
			case CONSTRAINT_TWO_SETS_OF_ACTIVITIES_SAME_SECTIONS:
				{
					ConstraintTwoSetsOfActivitiesSameSections* c=new ConstraintTwoSetsOfActivitiesSameSections;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//2025-05-15
			//231
			case CONSTRAINT_STUDENTS_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintStudentsMaxSingleGapsInSelectedTimeSlots* c=new ConstraintStudentsMaxSingleGapsInSelectedTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//232
			case CONSTRAINT_STUDENTS_SET_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintStudentsSetMaxSingleGapsInSelectedTimeSlots* c=new ConstraintStudentsSetMaxSingleGapsInSelectedTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//2025-05-17
			//233
			case CONSTRAINT_TEACHERS_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintTeachersMaxSingleGapsInSelectedTimeSlots* c=new ConstraintTeachersMaxSingleGapsInSelectedTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//234
			case CONSTRAINT_TEACHER_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintTeacherMaxSingleGapsInSelectedTimeSlots* c=new ConstraintTeacherMaxSingleGapsInSelectedTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//235
			case CONSTRAINT_TEACHER_MAX_HOURS_PER_TERM:
				{
					ConstraintTeacherMaxHoursPerTerm* c=new ConstraintTeacherMaxHoursPerTerm;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//236
			case CONSTRAINT_TEACHERS_MAX_HOURS_PER_TERM:
				{
					ConstraintTeachersMaxHoursPerTerm* c=new ConstraintTeachersMaxHoursPerTerm;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//237
			case CONSTRAINT_TEACHER_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
				{
					ConstraintTeacherPairOfMutuallyExclusiveSetsOfTimeSlots* c=new ConstraintTeacherPairOfMutuallyExclusiveSetsOfTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//238
			case CONSTRAINT_TEACHERS_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
				{
					ConstraintTeachersPairOfMutuallyExclusiveSetsOfTimeSlots* c=new ConstraintTeachersPairOfMutuallyExclusiveSetsOfTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//239
			case CONSTRAINT_STUDENTS_SET_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
				{
					ConstraintStudentsSetPairOfMutuallyExclusiveSetsOfTimeSlots* c=new ConstraintStudentsSetPairOfMutuallyExclusiveSetsOfTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//240
			case CONSTRAINT_STUDENTS_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
				{
					ConstraintStudentsPairOfMutuallyExclusiveSetsOfTimeSlots* c=new ConstraintStudentsPairOfMutuallyExclusiveSetsOfTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//241
			case CONSTRAINT_ACTIVITIES_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
				{
					ConstraintActivitiesPairOfMutuallyExclusiveSetsOfTimeSlots* c=new ConstraintActivitiesPairOfMutuallyExclusiveSetsOfTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//242
			case CONSTRAINT_ACTIVITIES_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
				{
					ConstraintActivitiesPairOfMutuallyExclusiveTimeSlots* c=new ConstraintActivitiesPairOfMutuallyExclusiveTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//243
			case CONSTRAINT_TEACHER_OCCUPIES_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintTeacherOccupiesMaxSetsOfTimeSlotsFromSelection* c=new ConstraintTeacherOccupiesMaxSetsOfTimeSlotsFromSelection;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//244
			case CONSTRAINT_TEACHERS_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintTeachersOccupyMaxSetsOfTimeSlotsFromSelection* c=new ConstraintTeachersOccupyMaxSetsOfTimeSlotsFromSelection;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//245
			case CONSTRAINT_STUDENTS_SET_OCCUPIES_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintStudentsSetOccupiesMaxSetsOfTimeSlotsFromSelection* c=new ConstraintStudentsSetOccupiesMaxSetsOfTimeSlotsFromSelection;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//246
			case CONSTRAINT_STUDENTS_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintStudentsOccupyMaxSetsOfTimeSlotsFromSelection* c=new ConstraintStudentsOccupyMaxSetsOfTimeSlotsFromSelection;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//247
			case CONSTRAINT_ACTIVITIES_OVERLAP_COMPLETELY_OR_DO_NOT_OVERLAP:
				{
					ConstraintActivitiesOverlapCompletelyOrDoNotOverlap* c=new ConstraintActivitiesOverlapCompletelyOrDoNotOverlap;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//248
			case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintActivitiesOccupyMaxSetsOfTimeSlotsFromSelection* c=new ConstraintActivitiesOccupyMaxSetsOfTimeSlotsFromSelection;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}

			//249
			case CONSTRAINT_ACTIVITY_BEGINS_OR_ENDS_STUDENTS_DAY:
				{
					ConstraintActivityBeginsOrEndsStudentsDay* c=new ConstraintActivityBeginsOrEndsStudentsDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//250
			case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_STUDENTS_DAY:
				{
					ConstraintActivitiesBeginOrEndStudentsDay* c=new ConstraintActivitiesBeginOrEndStudentsDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//251
			case CONSTRAINT_ACTIVITY_BEGINS_OR_ENDS_TEACHERS_DAY:
				{
					ConstraintActivityBeginsOrEndsTeachersDay* c=new ConstraintActivityBeginsOrEndsTeachersDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//252
			case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_TEACHERS_DAY:
				{
					ConstraintActivitiesBeginOrEndTeachersDay* c=new ConstraintActivitiesBeginOrEndTeachersDay;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			//253
			case CONSTRAINT_ACTIVITIES_MAX_TOTAL_NUMBER_OF_STUDENTS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintActivitiesMaxTotalNumberOfStudentsInSelectedTimeSlots* c=new ConstraintActivitiesMaxTotalNumberOfStudentsInSelectedTimeSlots;
					stream>>*c;
					rules.timeConstraintsList.append(c);
					break;
				}
			
			default:
				//commented, so that the program won't crash on wrong history files.
				//assert(0);
				break;
		}
	}

	assert(rules.bctSet.isEmpty()); //done in init() above
	assert(rules.btSet.isEmpty());
	assert(rules.apstHash.isEmpty());
	assert(rules.apdHash.isEmpty());
	assert(rules.mdbaHash.isEmpty());
	assert(rules.mhdbaHash.isEmpty());
	assert(rules.tnatHash.isEmpty());
	assert(rules.ssnatHash.isEmpty());
	for(TimeConstraint* ctr : std::as_const(rules.timeConstraintsList)){
		rules.recomputeActivitiesSetForTimeConstraint(ctr);
		rules.insertTimeConstraintInHash(ctr);
	}

	//stream>>rules.spaceConstraintsList;
	int nsc;
	stream>>nsc;
	//cout<<"nsc="<<nsc<<endl;
	for(int i=0; i<nsc; i++){
		int type;
		stream>>type;

		switch(type){
			//1
			case CONSTRAINT_BASIC_COMPULSORY_SPACE:
				{
					ConstraintBasicCompulsorySpace* c=new ConstraintBasicCompulsorySpace;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//2
			case CONSTRAINT_ROOM_NOT_AVAILABLE_TIMES:
				{
					ConstraintRoomNotAvailableTimes* c=new ConstraintRoomNotAvailableTimes;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//3
			case CONSTRAINT_ACTIVITY_PREFERRED_ROOM:
				{
					ConstraintActivityPreferredRoom* c=new ConstraintActivityPreferredRoom;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//4
			case CONSTRAINT_ACTIVITY_PREFERRED_ROOMS:
				{
					ConstraintActivityPreferredRooms* c=new ConstraintActivityPreferredRooms;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//5
			case CONSTRAINT_STUDENTS_SET_HOME_ROOM:
				{
					ConstraintStudentsSetHomeRoom* c=new ConstraintStudentsSetHomeRoom;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//6
			case CONSTRAINT_STUDENTS_SET_HOME_ROOMS:
				{
					ConstraintStudentsSetHomeRooms* c=new ConstraintStudentsSetHomeRooms;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//7
			case CONSTRAINT_TEACHER_HOME_ROOM:
				{
					ConstraintTeacherHomeRoom* c=new ConstraintTeacherHomeRoom;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//8
			case CONSTRAINT_TEACHER_HOME_ROOMS:
				{
					ConstraintTeacherHomeRooms* c=new ConstraintTeacherHomeRooms;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//9
			case CONSTRAINT_SUBJECT_PREFERRED_ROOM:
				{
					ConstraintSubjectPreferredRoom* c=new ConstraintSubjectPreferredRoom;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//10
			case CONSTRAINT_SUBJECT_PREFERRED_ROOMS:
				{
					ConstraintSubjectPreferredRooms* c=new ConstraintSubjectPreferredRooms;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//11
			case CONSTRAINT_SUBJECT_ACTIVITY_TAG_PREFERRED_ROOM:
				{
					ConstraintSubjectActivityTagPreferredRoom* c=new ConstraintSubjectActivityTagPreferredRoom;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//12
			case CONSTRAINT_SUBJECT_ACTIVITY_TAG_PREFERRED_ROOMS:
				{
					ConstraintSubjectActivityTagPreferredRooms* c=new ConstraintSubjectActivityTagPreferredRooms;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			///6 apr 2009
			//13
			case CONSTRAINT_ACTIVITY_TAG_PREFERRED_ROOM:
				{
					ConstraintActivityTagPreferredRoom* c=new ConstraintActivityTagPreferredRoom;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//14
			case CONSTRAINT_ACTIVITY_TAG_PREFERRED_ROOMS:
				{
					ConstraintActivityTagPreferredRooms* c=new ConstraintActivityTagPreferredRooms;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			///
			//15
			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_DAY:
				{
					ConstraintStudentsSetMaxBuildingChangesPerDay* c=new ConstraintStudentsSetMaxBuildingChangesPerDay;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//16
			case CONSTRAINT_STUDENTS_MAX_BUILDING_CHANGES_PER_DAY:
				{
					ConstraintStudentsMaxBuildingChangesPerDay* c=new ConstraintStudentsMaxBuildingChangesPerDay;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//17
			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_WEEK:
				{
					ConstraintStudentsSetMaxBuildingChangesPerWeek* c=new ConstraintStudentsSetMaxBuildingChangesPerWeek;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//18
			case CONSTRAINT_STUDENTS_MAX_BUILDING_CHANGES_PER_WEEK:
				{
					ConstraintStudentsMaxBuildingChangesPerWeek* c=new ConstraintStudentsMaxBuildingChangesPerWeek;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//19
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_BUILDING_CHANGES:
				{
					ConstraintStudentsSetMinGapsBetweenBuildingChanges* c=new ConstraintStudentsSetMinGapsBetweenBuildingChanges;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//20
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_BUILDING_CHANGES:
				{
					ConstraintStudentsMinGapsBetweenBuildingChanges* c=new ConstraintStudentsMinGapsBetweenBuildingChanges;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//21
			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_DAY:
				{
					ConstraintTeacherMaxBuildingChangesPerDay* c=new ConstraintTeacherMaxBuildingChangesPerDay;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//22
			case CONSTRAINT_TEACHERS_MAX_BUILDING_CHANGES_PER_DAY:
				{
					ConstraintTeachersMaxBuildingChangesPerDay* c=new ConstraintTeachersMaxBuildingChangesPerDay;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//23
			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_WEEK:
				{
					ConstraintTeacherMaxBuildingChangesPerWeek* c=new ConstraintTeacherMaxBuildingChangesPerWeek;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//24
			case CONSTRAINT_TEACHERS_MAX_BUILDING_CHANGES_PER_WEEK:
				{
					ConstraintTeachersMaxBuildingChangesPerWeek* c=new ConstraintTeachersMaxBuildingChangesPerWeek;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//25
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_BUILDING_CHANGES:
				{
					ConstraintTeacherMinGapsBetweenBuildingChanges* c=new ConstraintTeacherMinGapsBetweenBuildingChanges;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//26
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_BUILDING_CHANGES:
				{
					ConstraintTeachersMinGapsBetweenBuildingChanges* c=new ConstraintTeachersMinGapsBetweenBuildingChanges;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//27
			case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_DIFFERENT_ROOMS:
				{
					ConstraintActivitiesOccupyMaxDifferentRooms* c=new ConstraintActivitiesOccupyMaxDifferentRooms;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//28
			case CONSTRAINT_ACTIVITIES_SAME_ROOM_IF_CONSECUTIVE:
				{
					ConstraintActivitiesSameRoomIfConsecutive* c=new ConstraintActivitiesSameRoomIfConsecutive;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//2019-11-14
			//29
			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_DAY:
				{
					ConstraintStudentsSetMaxRoomChangesPerDay* c=new ConstraintStudentsSetMaxRoomChangesPerDay;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//30
			case CONSTRAINT_STUDENTS_MAX_ROOM_CHANGES_PER_DAY:
				{
					ConstraintStudentsMaxRoomChangesPerDay* c=new ConstraintStudentsMaxRoomChangesPerDay;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//31
			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_WEEK:
				{
					ConstraintStudentsSetMaxRoomChangesPerWeek* c=new ConstraintStudentsSetMaxRoomChangesPerWeek;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//32
			case CONSTRAINT_STUDENTS_MAX_ROOM_CHANGES_PER_WEEK:
				{
					ConstraintStudentsMaxRoomChangesPerWeek* c=new ConstraintStudentsMaxRoomChangesPerWeek;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//33
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ROOM_CHANGES:
				{
					ConstraintStudentsSetMinGapsBetweenRoomChanges* c=new ConstraintStudentsSetMinGapsBetweenRoomChanges;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//34
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ROOM_CHANGES:
				{
					ConstraintStudentsMinGapsBetweenRoomChanges* c=new ConstraintStudentsMinGapsBetweenRoomChanges;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//35
			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_DAY:
				{
					ConstraintTeacherMaxRoomChangesPerDay* c=new ConstraintTeacherMaxRoomChangesPerDay;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//36
			case CONSTRAINT_TEACHERS_MAX_ROOM_CHANGES_PER_DAY:
				{
					ConstraintTeachersMaxRoomChangesPerDay* c=new ConstraintTeachersMaxRoomChangesPerDay;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//37
			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_WEEK:
				{
					ConstraintTeacherMaxRoomChangesPerWeek* c=new ConstraintTeacherMaxRoomChangesPerWeek;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//38
			case CONSTRAINT_TEACHERS_MAX_ROOM_CHANGES_PER_WEEK:
				{
					ConstraintTeachersMaxRoomChangesPerWeek* c=new ConstraintTeachersMaxRoomChangesPerWeek;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//39
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ROOM_CHANGES:
				{
					ConstraintTeacherMinGapsBetweenRoomChanges* c=new ConstraintTeacherMinGapsBetweenRoomChanges;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//40
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ROOM_CHANGES:
				{
					ConstraintTeachersMinGapsBetweenRoomChanges* c=new ConstraintTeachersMinGapsBetweenRoomChanges;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//41
			case CONSTRAINT_TEACHER_ROOM_NOT_AVAILABLE_TIMES:
				{
					ConstraintTeacherRoomNotAvailableTimes* c=new ConstraintTeacherRoomNotAvailableTimes;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//for mornings-afternoons
			//42
			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_REAL_DAY:
				{
					ConstraintStudentsSetMaxRoomChangesPerRealDay* c=new ConstraintStudentsSetMaxRoomChangesPerRealDay;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//43
			case CONSTRAINT_STUDENTS_MAX_ROOM_CHANGES_PER_REAL_DAY:
				{
					ConstraintStudentsMaxRoomChangesPerRealDay* c=new ConstraintStudentsMaxRoomChangesPerRealDay;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//44
			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_REAL_DAY:
				{
					ConstraintTeacherMaxRoomChangesPerRealDay* c=new ConstraintTeacherMaxRoomChangesPerRealDay;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//45
			case CONSTRAINT_TEACHERS_MAX_ROOM_CHANGES_PER_REAL_DAY:
				{
					ConstraintTeachersMaxRoomChangesPerRealDay* c=new ConstraintTeachersMaxRoomChangesPerRealDay;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//46
			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_REAL_DAY:
				{
					ConstraintStudentsSetMaxBuildingChangesPerRealDay* c=new ConstraintStudentsSetMaxBuildingChangesPerRealDay;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//47
			case CONSTRAINT_STUDENTS_MAX_BUILDING_CHANGES_PER_REAL_DAY:
				{
					ConstraintStudentsMaxBuildingChangesPerRealDay* c=new ConstraintStudentsMaxBuildingChangesPerRealDay;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//48
			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_REAL_DAY:
				{
					ConstraintTeacherMaxBuildingChangesPerRealDay* c=new ConstraintTeacherMaxBuildingChangesPerRealDay;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//49
			case CONSTRAINT_TEACHERS_MAX_BUILDING_CHANGES_PER_REAL_DAY:
				{
					ConstraintTeachersMaxBuildingChangesPerRealDay* c=new ConstraintTeachersMaxBuildingChangesPerRealDay;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//50
			case CONSTRAINT_STUDENTS_MAX_BUILDING_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintStudentsMaxBuildingChangesPerDayInInterval* c=new ConstraintStudentsMaxBuildingChangesPerDayInInterval;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//51
			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxBuildingChangesPerDayInInterval* c=new ConstraintStudentsSetMaxBuildingChangesPerDayInInterval;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//52
			case CONSTRAINT_TEACHERS_MAX_BUILDING_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintTeachersMaxBuildingChangesPerDayInInterval* c=new ConstraintTeachersMaxBuildingChangesPerDayInInterval;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//53
			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintTeacherMaxBuildingChangesPerDayInInterval* c=new ConstraintTeacherMaxBuildingChangesPerDayInInterval;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//54
			case CONSTRAINT_STUDENTS_MAX_BUILDING_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintStudentsMaxBuildingChangesPerRealDayInInterval* c=new ConstraintStudentsMaxBuildingChangesPerRealDayInInterval;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//55
			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxBuildingChangesPerRealDayInInterval* c=new ConstraintStudentsSetMaxBuildingChangesPerRealDayInInterval;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//56
			case CONSTRAINT_TEACHERS_MAX_BUILDING_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintTeachersMaxBuildingChangesPerRealDayInInterval* c=new ConstraintTeachersMaxBuildingChangesPerRealDayInInterval;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//57
			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintTeacherMaxBuildingChangesPerRealDayInInterval* c=new ConstraintTeacherMaxBuildingChangesPerRealDayInInterval;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//58
			case CONSTRAINT_STUDENTS_MAX_ROOM_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintStudentsMaxRoomChangesPerDayInInterval* c=new ConstraintStudentsMaxRoomChangesPerDayInInterval;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//59
			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxRoomChangesPerDayInInterval* c=new ConstraintStudentsSetMaxRoomChangesPerDayInInterval;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//60
			case CONSTRAINT_TEACHERS_MAX_ROOM_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintTeachersMaxRoomChangesPerDayInInterval* c=new ConstraintTeachersMaxRoomChangesPerDayInInterval;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//61
			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintTeacherMaxRoomChangesPerDayInInterval* c=new ConstraintTeacherMaxRoomChangesPerDayInInterval;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//62
			case CONSTRAINT_STUDENTS_MAX_ROOM_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintStudentsMaxRoomChangesPerRealDayInInterval* c=new ConstraintStudentsMaxRoomChangesPerRealDayInInterval;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//63
			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxRoomChangesPerRealDayInInterval* c=new ConstraintStudentsSetMaxRoomChangesPerRealDayInInterval;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//64
			case CONSTRAINT_TEACHERS_MAX_ROOM_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintTeachersMaxRoomChangesPerRealDayInInterval* c=new ConstraintTeachersMaxRoomChangesPerRealDayInInterval;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//65
			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintTeacherMaxRoomChangesPerRealDayInInterval* c=new ConstraintTeacherMaxRoomChangesPerRealDayInInterval;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//66
			case CONSTRAINT_ROOM_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintRoomMaxActivityTagsPerDayFromSet* c=new ConstraintRoomMaxActivityTagsPerDayFromSet;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//67
			case CONSTRAINT_ROOM_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintRoomMaxActivityTagsPerRealDayFromSet* c=new ConstraintRoomMaxActivityTagsPerRealDayFromSet;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			//68
			case CONSTRAINT_ROOM_MAX_ACTIVITY_TAGS_PER_WEEK_FROM_SET:
				{
					ConstraintRoomMaxActivityTagsPerWeekFromSet* c=new ConstraintRoomMaxActivityTagsPerWeekFromSet;
					stream>>*c;
					rules.spaceConstraintsList.append(c);
					break;
				}
			
			default:
				//commented, so that the program won't crash on wrong history files.
				//assert(0);
				break;
		}
	}

	assert(rules.bcsSet.isEmpty()); //done in init() above
	assert(rules.aprHash.isEmpty());
	for(SpaceConstraint* ctr : std::as_const(rules.spaceConstraintsList)){
		rules.recomputeActivitiesSetForSpaceConstraint(ctr);
		rules.insertSpaceConstraintInHash(ctr);
	}

	//stream>>rules.groupActivitiesInInitialOrderList;
	int nga;
	stream>>nga;
	//cout<<"nga="<<nga<<endl;
	for(int i=0; i<nga; i++){
		GroupActivitiesInInitialOrderItem* it=new GroupActivitiesInInitialOrderItem;
		stream>>*it;
		rules.groupActivitiesInInitialOrderList.append(it);
	}

	//Done in the first line above: rules.clear();
	/*students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
	teachers_schedule_ready=false;*/
	
	//Assertions failed fixed on 22 November 2023, reported by Vangelis Karafillidis.
	LockUnlock::computeLockedUnlockedActivitiesTimeSpace();
	LockUnlock::increaseCommunicationSpinBox();
	
	return stream;
}

void Rules::addUndoPoint(const QString& description, bool autosave, bool resetCounter)
{
	//cout<<"Enter addUndoPoint, autosave="<<autosave<<", resetCounter="<<resetCounter<<endl;

	if(USE_AUTOSAVE){
		static qint64 cnt=0;
		
		if(resetCounter)
			cnt=0;
		
		static time_t oldtime=0;
		if(cnt==0)
			time(&oldtime);
		
		if(autosave){
			cnt++;
		
			time_t newtime;
			time(&newtime);
			
			//cout<<"cnt="<<cnt<<", newtime-oldtime="<<int(difftime(newtime, oldtime))<<endl;
			
			if(int(difftime(newtime, oldtime))>=60*MINUTES_AUTOSAVE && cnt%OPERATIONS_AUTOSAVE==0){
				QString sfn;
				if(INPUT_FILENAME_XML!="")
					sfn=QFileInfo(INPUT_FILENAME_XML).fileName();
				else
					sfn=QString("untitled.fet");
				//assert(sfn.length()>=5);
				//assert(sfn.endsWith(".fet"));
				if(sfn.endsWith(".fet"))
					sfn.chop(4);

				QString das;
				if(DIRECTORY_AUTOSAVE==""){
					if(INPUT_FILENAME_XML=="")
						das=WORKING_DIRECTORY;
					else
						das=QFileInfo(INPUT_FILENAME_XML).canonicalPath();
				}
				else{
					das=DIRECTORY_AUTOSAVE;
				}

				QDir dir;
				bool t=true;
				if(!dir.exists(das))
					t=dir.mkpath(das);
				if(!t){
					RulesIrreconcilableMessage::warning((QWidget*)pFetMainForm, tr("FET warning"), tr("Cannot create or use directory %1 - cannot autosave your data file - please change"
					 " the chosen autosave directory or disable the autosave.")
					 .arg(QDir::toNativeSeparators(das)));
				}
				else{
					bool t2=this->write((QWidget*)pFetMainForm, das+FILE_SEP+sfn+SUFFIX_FILENAME_AUTOSAVE+".fet");
					//cout<<"Autosaved in "<<qPrintable(das+FILE_SEP+sfn+SUFFIX_FILENAME_AUTOSAVE+".fet")<<endl;
					if(t2)
						showStatusBarAutosaved();
				}
				
				oldtime=newtime;
			}
		}
	}

	if(!USE_UNDO_REDO)
		return;

	QByteArray oldRulesBA;
#if QT_VERSION >= QT_VERSION_CHECK(6,0,0)
	QDataStream dsr(&oldRulesBA, QIODeviceBase::WriteOnly);
#else
	QDataStream dsr(&oldRulesBA, QIODevice::WriteOnly);
#endif
	dsr<<*this;

	//ds>>oldRulesBA;

	//QByteArray oldRulesArchivedBA=qCompress(oldRulesBA, UNDO_REDO_COMPRESSION_LEVEL);
	QByteArray oldRulesArchivedBA=qCompress(oldRulesBA);

	//cout<<"Adding an undo point with uncompressed size="<<oldRulesBA.size()<<" and compressed size="<<oldRulesArchivedBA.size()
	// <<" and description: "<<qPrintable(description)<<endl;

	assert(oldRulesArchived.size()==operationWhichWasDoneArchived.size());
	assert(oldRulesArchived.size()==operationDateTime.size());
	assert(oldRulesArchived.size()==unarchivedSizes.size());
	//assert(oldRulesArchived.size()==stateFileName.size());
	assert(cntUndoRedoStackIterator>=0);
	//if(cntUndoRedoStackIterator>int(oldRulesArchived.size()))
	//	cout<<"cntUndoRedoStackIterator="<<cntUndoRedoStackIterator<<", oldRulesArchived.size()="<<oldRulesArchived.size()<<endl;
	assert(cntUndoRedoStackIterator<=int(oldRulesArchived.size()));
	int statesToRemove=int(oldRulesArchived.size())-cntUndoRedoStackIterator;
	//cout<<"Removing "<<statesToRemove<<" saved positions from the end"<<endl;
	for(int i=0; i<statesToRemove; i++){
		assert(!oldRulesArchived.empty());
		oldRulesArchived.pop_back();
		
		assert(!operationWhichWasDoneArchived.empty());
		//cout<<"Removing operation: "<<qPrintable(operationWhichWasDone.back())<<endl;
		operationWhichWasDoneArchived.pop_back();
		
		assert(!operationDateTime.empty());
		operationDateTime.pop_back();
		
		assert(!unarchivedSizes.empty());
		unarchivedSizes.pop_back();
		
		//assert(!stateFileName.empty());
		//stateFileName.pop_back();
	}
	if(savedStateIterator>int(oldRulesArchived.size()))
		savedStateIterator=0;

	oldRulesArchived.push_back(oldRulesArchivedBA);

	QByteArray descrBA;
#if QT_VERSION >= QT_VERSION_CHECK(6,0,0)
	QDataStream dsd(&descrBA, QIODeviceBase::WriteOnly);
#else
	QDataStream dsd(&descrBA, QIODevice::WriteOnly);
#endif
	if(description.length()<=20000){
		dsd<<description;
	}
	else{
#if QT_VERSION >= QT_VERSION_CHECK(6,0,0)
		QString shortDescr=description.first(20000);
#else
		QString shortDescr=description.left(20000);
#endif
		shortDescr+=QString("\n...");
		dsd<<shortDescr;
	}

	//QByteArray oldRulesArchivedBA=qCompress(oldRulesBA, UNDO_REDO_COMPRESSION_LEVEL);
	QByteArray descrArchivedBA=qCompress(descrBA);
	operationWhichWasDoneArchived.push_back(descrArchivedBA);

	//cout<<"Adding an undo point with uncompressed size="<<descrBA.size()<<" and compressed size="<<descrArchivedBA.size()<<endl;

	operationDateTime.push_back(QPair<QDate, QTime>(QDate::currentDate(), QTime::currentTime()));
	unarchivedSizes.push_back(oldRulesBA.size());
	//stateFileName.push_back(INPUT_FILENAME_XML);

	assert(oldRulesArchived.size()==operationWhichWasDoneArchived.size());
	assert(oldRulesArchived.size()==operationDateTime.size());
	assert(oldRulesArchived.size()==unarchivedSizes.size());
	//assert(oldRulesArchived.size()==stateFileName.size());

	int ts=int(oldRulesArchived.size());
	if(ts>UNDO_REDO_STEPS){
		assert(ts==UNDO_REDO_STEPS+1);
	
		assert(!oldRulesArchived.empty());
		oldRulesArchived.pop_front();
		
		assert(!operationWhichWasDoneArchived.empty());
		operationWhichWasDoneArchived.pop_front();
		
		assert(!operationDateTime.empty());
		operationDateTime.pop_front();
		
		assert(!unarchivedSizes.empty());
		unarchivedSizes.pop_front();

		//assert(!stateFileName.empty());
		//stateFileName.pop_front();

		savedStateIterator--;
		if(savedStateIterator<0)
			savedStateIterator=0;
	}

	cntUndoRedoStackIterator=int(oldRulesArchived.size());
	crtBAIt=std::prev(oldRulesArchived.cend());
	//crtDIt=std::prev(operationWhichWasDone.cend());
	//crtDTIt=std::prev(operationDateTime.cend());
	//crtFNIt=std::prev(stateFileName.cend());
}

void Rules::restoreState(QWidget* parent, int iterationsBackward)
{
	assert(USE_UNDO_REDO);

	std::deque<QByteArray>::const_iterator savedCrtBAIt=crtBAIt;
	int savedCntUndoRedoStackIterator=cntUndoRedoStackIterator;

	if(iterationsBackward==0){
		assert(0);
	}
	else if(iterationsBackward>0){
		if(iterationsBackward>=cntUndoRedoStackIterator){
			//cout<<"iterationsBackward="<<iterationsBackward<<", cntUndoRedoStackIterator="<<cntUndoRedoStackIterator<<endl;
			assert(0);
		}
		else{
			cntUndoRedoStackIterator-=iterationsBackward;
			/*for(int i=0; i<iterationsBackward; i++){
				crtBAIt--;
				//crtDIt--;
				//crtDTIt--;
				//crtFNIt--;
			}*/
			std::advance(crtBAIt, -iterationsBackward);
		}
	}
	else if(iterationsBackward<0){
		int iterationsForward=-iterationsBackward;
		if(iterationsForward>int(oldRulesArchived.size())-cntUndoRedoStackIterator){
			//cout<<"iterationsForward="<<iterationsForward<<", cntUndoRedoStackIterator="<<cntUndoRedoStackIterator
			//  <<", oldRulesArchived.size()="<<oldRulesArchived.size()<<endl;
			assert(0);
		}
		else{
			cntUndoRedoStackIterator+=iterationsForward;
			/*for(int i=0; i<iterationsForward; i++){
				crtBAIt++;
				//crtDIt++;
				//crtDTIt++;
				//crtFNIt++;
			}*/
			std::advance(crtBAIt, iterationsForward);
		}
	}
	QByteArray oldRulesArchivedBA=*crtBAIt;
	QByteArray oldRulesBA=qUncompress(oldRulesArchivedBA);
	//qUncompress(...) should have the same behavior with other (older, and also hopefully newer) versions of Qt, see this Qt function's doc.
	//We need this compatibility for the disk history, where the user might have saved the history on disk from a different Qt version.
	if(oldRulesBA.isEmpty()){
		QMessageBox::critical(parent, tr("FET critical"), tr("Corrupted state read from the memory or from the hard disk ... returning to the previous state.")+
		 QString("\n\n")+tr("If the problem is caused by the history file saved on the disk, you might want to exit FET, remove the corresponding history file"
		 " ending in '%1', open FET again, and open your .fet data file again. Or just ignore the problem, until the history will be replaced with new, valid entries.")
		 .arg(SUFFIX_FILENAME_SAVE_HISTORY));
		crtBAIt=savedCrtBAIt;
		cntUndoRedoStackIterator=savedCntUndoRedoStackIterator;
	}
	else{
#if QT_VERSION >= QT_VERSION_CHECK(6,0,0)
		QDataStream dsr(&oldRulesBA, QIODeviceBase::ReadOnly);
#else
		QDataStream dsr(&oldRulesBA, QIODevice::ReadOnly);
#endif
		//ds<<oldRulesBA;
		dsr>>*this;
		
		//this->modified=true;
		this->modified = (cntUndoRedoStackIterator!=savedStateIterator);
		
		//INPUT_FILENAME_XML=*crtFNIt;
		updateFetMainFormAfterHistoryRestored(iterationsBackward);
	}
}
#endif

void Rules::init() //initializes the rules (empty, but with default hours and days)
{
	//keep the current mode, do not change it.

	//defaults
	this->institutionName=tr("Default institution");
	this->comments=tr("Default comments");

	//default for terms (Finland)
	this->nTerms=5;
	this->nDaysPerTerm=5;

	this->nDaysPerWeek=5;
	this->daysOfTheWeek.clear();
	this->daysOfTheWeek.append(QString("D1"));
	this->daysOfTheWeek.append(QString("D2"));
	this->daysOfTheWeek.append(QString("D3"));
	this->daysOfTheWeek.append(QString("D4"));
	this->daysOfTheWeek.append(QString("D5"));
	
	this->nRealDaysPerWeek=2;
	this->realDaysOfTheWeek.clear();
	this->realDaysOfTheWeek.append(QString("RD1"));
	this->realDaysOfTheWeek.append(QString("RD2"));
	
	this->nHoursPerDay=12;
	this->hoursOfTheDay.clear();
	this->hoursOfTheDay.append(QString("H1"));
	this->hoursOfTheDay.append(QString("H2"));
	this->hoursOfTheDay.append(QString("H3"));
	this->hoursOfTheDay.append(QString("H4"));
	this->hoursOfTheDay.append(QString("H5"));
	this->hoursOfTheDay.append(QString("H6"));
	this->hoursOfTheDay.append(QString("H7"));
	this->hoursOfTheDay.append(QString("H8"));
	this->hoursOfTheDay.append(QString("H9"));
	this->hoursOfTheDay.append(QString("H10"));
	this->hoursOfTheDay.append(QString("H11"));
	this->hoursOfTheDay.append(QString("H12"));

	this->nRealHoursPerDay=24;
	this->realHoursOfTheDay.clear();
	this->realHoursOfTheDay.append(QString("RH1"));
	this->realHoursOfTheDay.append(QString("RH2"));
	this->realHoursOfTheDay.append(QString("RH3"));
	this->realHoursOfTheDay.append(QString("RH4"));
	this->realHoursOfTheDay.append(QString("RH5"));
	this->realHoursOfTheDay.append(QString("RH6"));
	this->realHoursOfTheDay.append(QString("RH7"));
	this->realHoursOfTheDay.append(QString("RH8"));
	this->realHoursOfTheDay.append(QString("RH9"));
	this->realHoursOfTheDay.append(QString("RH10"));
	this->realHoursOfTheDay.append(QString("RH11"));
	this->realHoursOfTheDay.append(QString("RH12"));
	this->realHoursOfTheDay.append(QString("RH13"));
	this->realHoursOfTheDay.append(QString("RH14"));
	this->realHoursOfTheDay.append(QString("RH15"));
	this->realHoursOfTheDay.append(QString("RH16"));
	this->realHoursOfTheDay.append(QString("RH17"));
	this->realHoursOfTheDay.append(QString("RH18"));
	this->realHoursOfTheDay.append(QString("RH19"));
	this->realHoursOfTheDay.append(QString("RH20"));
	this->realHoursOfTheDay.append(QString("RH21"));
	this->realHoursOfTheDay.append(QString("RH22"));
	this->realHoursOfTheDay.append(QString("RH23"));
	this->realHoursOfTheDay.append(QString("RH24"));

	this->daysOfTheWeek_longNames.clear();
	this->daysOfTheWeek_longNames.append(tr("Monday"));
	this->daysOfTheWeek_longNames.append(tr("Tuesday"));
	this->daysOfTheWeek_longNames.append(tr("Wednesday"));
	this->daysOfTheWeek_longNames.append(tr("Thursday"));
	this->daysOfTheWeek_longNames.append(tr("Friday"));
	
	this->realDaysOfTheWeek_longNames.clear();
	this->realDaysOfTheWeek_longNames.append(tr("Monday"));
	this->realDaysOfTheWeek_longNames.append(tr("Tuesday"));
	
	this->hoursOfTheDay_longNames.clear();
	this->hoursOfTheDay_longNames.append(tr("08:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("09:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("10:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("11:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("12:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("13:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("14:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("15:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("16:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("17:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("18:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("19:00", "Hour name"));

	this->realHoursOfTheDay_longNames.clear();
	this->realHoursOfTheDay_longNames.append(tr("08:00", "Hour name")+QString(" ")+tr("AM", "Ante Meridiem, before noon"));
	this->realHoursOfTheDay_longNames.append(tr("09:00", "Hour name")+QString(" ")+tr("AM", "Ante Meridiem, before noon"));
	this->realHoursOfTheDay_longNames.append(tr("10:00", "Hour name")+QString(" ")+tr("AM", "Ante Meridiem, before noon"));
	this->realHoursOfTheDay_longNames.append(tr("11:00", "Hour name")+QString(" ")+tr("AM", "Ante Meridiem, before noon"));
	this->realHoursOfTheDay_longNames.append(tr("12:00", "Hour name")+QString(" ")+tr("AM", "Ante Meridiem, before noon"));
	this->realHoursOfTheDay_longNames.append(tr("13:00", "Hour name")+QString(" ")+tr("AM", "Ante Meridiem, before noon"));
	this->realHoursOfTheDay_longNames.append(tr("14:00", "Hour name")+QString(" ")+tr("AM", "Ante Meridiem, before noon"));
	this->realHoursOfTheDay_longNames.append(tr("15:00", "Hour name")+QString(" ")+tr("AM", "Ante Meridiem, before noon"));
	this->realHoursOfTheDay_longNames.append(tr("16:00", "Hour name")+QString(" ")+tr("AM", "Ante Meridiem, before noon"));
	this->realHoursOfTheDay_longNames.append(tr("17:00", "Hour name")+QString(" ")+tr("AM", "Ante Meridiem, before noon"));
	this->realHoursOfTheDay_longNames.append(tr("18:00", "Hour name")+QString(" ")+tr("AM", "Ante Meridiem, before noon"));
	this->realHoursOfTheDay_longNames.append(tr("19:00", "Hour name")+QString(" ")+tr("AM", "Ante Meridiem, before noon"));
	this->realHoursOfTheDay_longNames.append(tr("08:00", "Hour name")+QString(" ")+tr("PM", "Post Meridiem, afternoon"));
	this->realHoursOfTheDay_longNames.append(tr("09:00", "Hour name")+QString(" ")+tr("PM", "Post Meridiem, afternoon"));
	this->realHoursOfTheDay_longNames.append(tr("10:00", "Hour name")+QString(" ")+tr("PM", "Post Meridiem, afternoon"));
	this->realHoursOfTheDay_longNames.append(tr("11:00", "Hour name")+QString(" ")+tr("PM", "Post Meridiem, afternoon"));
	this->realHoursOfTheDay_longNames.append(tr("12:00", "Hour name")+QString(" ")+tr("PM", "Post Meridiem, afternoon"));
	this->realHoursOfTheDay_longNames.append(tr("13:00", "Hour name")+QString(" ")+tr("PM", "Post Meridiem, afternoon"));
	this->realHoursOfTheDay_longNames.append(tr("14:00", "Hour name")+QString(" ")+tr("PM", "Post Meridiem, afternoon"));
	this->realHoursOfTheDay_longNames.append(tr("15:00", "Hour name")+QString(" ")+tr("PM", "Post Meridiem, afternoon"));
	this->realHoursOfTheDay_longNames.append(tr("16:00", "Hour name")+QString(" ")+tr("PM", "Post Meridiem, afternoon"));
	this->realHoursOfTheDay_longNames.append(tr("17:00", "Hour name")+QString(" ")+tr("PM", "Post Meridiem, afternoon"));
	this->realHoursOfTheDay_longNames.append(tr("18:00", "Hour name")+QString(" ")+tr("PM", "Post Meridiem, afternoon"));
	this->realHoursOfTheDay_longNames.append(tr("19:00", "Hour name")+QString(" ")+tr("PM", "Post Meridiem, afternoon"));

	permanentStudentsHash.clear();
	
	activitiesPointerHash.clear();
	bctSet.clear();
	btSet.clear();
	bcsSet.clear();
	apstHash.clear();
	apdHash.clear();
	aprHash.clear();
	mdbaHash.clear();
	mhdbaHash.clear();
	tnatHash.clear();
	ssnatHash.clear();
	
	this->initialized=true;
}

bool Rules::computeInternalStructure(QWidget* parent)
{
	//To fix a bug reported by Frans on forum, on 7 May 2010.
	//If user generates, then changes some activities (changes teachers of them), then tries to generate but FET cannot precompute in generate_pre.cpp,
	//then if user views the timetable, the timetable of a teacher contains activities of other teacher.
	//The bug appeared because it is possible to compute internal structure, so internal activities change the teacher, but the timetables remain the same,
	//with the same activities indexes.
	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
	
	//The order is important - firstly the teachers, subjects, activity tags and students.
	//After that, the buildings.
	//After that, the rooms.
	//After that, the activities.
	//After that, the time constraints.
	//After that, the space constraints.

	//clear augmented students sets
	QList<StudentsYear*> ayears;
	QList<StudentsGroup*> agroups;
	QList<StudentsSubgroup*> asubgroups;
	for(StudentsYear* year : std::as_const(augmentedYearsList)){
		if(!ayears.contains(year))
			ayears.append(year);
		for(StudentsGroup* group : std::as_const(year->groupsList)){
			if(!agroups.contains(group))
				agroups.append(group);
			for(StudentsSubgroup* subgroup : std::as_const(group->subgroupsList)){
				if(!asubgroups.contains(subgroup))
					asubgroups.append(subgroup);
			}
		}
	}
	for(StudentsYear* year : std::as_const(ayears)){
		assert(year!=nullptr);
		delete year;
	}
	for(StudentsGroup* group : std::as_const(agroups)){
		assert(group!=nullptr);
		delete group;
	}
	for(StudentsSubgroup* subgroup : std::as_const(asubgroups)){
		assert(subgroup!=nullptr);
		delete subgroup;
	}
	augmentedYearsList.clear();
	
	correspondingRealStudentsSetName.clear();
	//////////////////
	
	//copy list of students sets into augmented list
	QHash<QString, StudentsSet*> augmentedHash;
	
	for(StudentsYear* y : std::as_const(yearsList)){
		StudentsYear* ay=new StudentsYear();
		ay->name=y->name;
		ay->longName=y->longName;
		ay->code=y->code;
		ay->numberOfStudents=y->numberOfStudents;
		
		//2020-09-04 - this is not really important
		ay->divisions=y->divisions;
		ay->separator=y->separator;
		
		//2024-12-24 - this is not really important
		ay->firstCategoryIsPermanent=y->firstCategoryIsPermanent;
		
		ay->comments=y->comments;
		
		ay->groupsList.clear();
		augmentedYearsList << ay;
		
		assert(!augmentedHash.contains(ay->name));
		augmentedHash.insert(ay->name, ay);
		
		for(StudentsGroup* g : std::as_const(y->groupsList)){
			if(augmentedHash.contains(g->name)){
				StudentsSet* tmpg=augmentedHash.value(g->name);
				assert(tmpg->type==STUDENTS_GROUP);
				ay->groupsList<<((StudentsGroup*)tmpg);
			}
			else{
				StudentsGroup* ag=new StudentsGroup();
				ag->name=g->name;
				ag->longName=g->longName;
				ag->code=g->code;
				ag->numberOfStudents=g->numberOfStudents;
				
				ag->comments=g->comments;
				
				ag->subgroupsList.clear();
				ay->groupsList << ag;
				
				assert(!augmentedHash.contains(ag->name));
				augmentedHash.insert(ag->name, ag);
			
				for(StudentsSubgroup* s : std::as_const(g->subgroupsList)){
					if(augmentedHash.contains(s->name)){
						StudentsSet* tmps=augmentedHash.value(s->name);
						assert(tmps->type==STUDENTS_SUBGROUP);
						ag->subgroupsList<<((StudentsSubgroup*)tmps);
					}
					else{
						StudentsSubgroup* as=new StudentsSubgroup();
						as->name=s->name;
						as->longName=s->longName;
						as->code=s->code;
						as->numberOfStudents=s->numberOfStudents;
						
						as->comments=s->comments;
						
						ag->subgroupsList << as;
						
						assert(!augmentedHash.contains(as->name));
						augmentedHash.insert(as->name, as);
					}
				}
			}
		}
	}

	/////////
	for(int i=0; i<this->augmentedYearsList.size(); i++){
		StudentsYear* sty=this->augmentedYearsList[i];

		//if this year has no groups, insert something to simulate the whole year
		if(sty->groupsList.count()==0){
			StudentsGroup* tmpGroup = new StudentsGroup();
			tmpGroup->name = sty->name+" "+tr("Automatic Group", "Please keep the translation short. It is used when a year contains no groups and an automatic group "
			 "is added in the year, in the timetable (when viewing the students timetable from FET and also in the HTML timetables for students groups or subgroups)"
			 ". In the empty year there will be added a group with name = yearName+a space character+your translation of 'Automatic Group'.");
			
			//to avoid rare/very improbable, but possible name crashes
			if(augmentedHash.contains(tmpGroup->name)){
				int i=2;
				for(;;){
					QString tgn=tmpGroup->name+" "+QString::number(i);
					if(!augmentedHash.contains(tgn)){
						tmpGroup->name=tgn;
						break;
					}
					i++;
				}
			}
			augmentedHash.insert(tmpGroup->name, tmpGroup);
			
			tmpGroup->longName = sty->longName+" "+tr("Automatic Group", "Please keep the translation short. It is used when a year contains no groups and an automatic group "
			 "is added in the year, in the timetable (when viewing the students timetable from FET and also in the HTML timetables for students groups or subgroups)"
			 ". In the empty year there will be added a group with name = yearName+a space character+your translation of 'Automatic Group'.");
			tmpGroup->code = sty->code+" "+tr("Automatic Group", "Please keep the translation short. It is used when a year contains no groups and an automatic group "
			 "is added in the year, in the timetable (when viewing the students timetable from FET and also in the HTML timetables for students groups or subgroups)"
			 ". In the empty year there will be added a group with name = yearName+a space character+your translation of 'Automatic Group'.");
			tmpGroup->numberOfStudents = sty->numberOfStudents;
			sty->groupsList << tmpGroup;
			
			correspondingRealStudentsSetName.insert(tmpGroup->name, sty->name);
		}
		
		for(int j=0; j<sty->groupsList.size(); j++){
			StudentsGroup* stg=sty->groupsList[j];

			//if this group has no subgroups, insert something to simulate the whole group
			if(stg->subgroupsList.size()==0){
				StudentsSubgroup* tmpSubgroup = new StudentsSubgroup();
				tmpSubgroup->name = stg->name+" "+tr("Automatic Subgroup", "Please keep the translation short. It is used when a group contains no subgroups and an automatic subgroup "
				 "is added in the group, in the timetable (when viewing the students timetable from FET and also in the HTML timetables for students subgroups)"
				 ". In the empty group there will be added a subgroup with name = groupName+a space character+your translation of 'Automatic Subgroup'.");
				
				//to avoid rare/very improbable, but possible name crashes
				if(augmentedHash.contains(tmpSubgroup->name)){
					int i=2;
					for(;;){
						QString tsn=tmpSubgroup->name+" "+QString::number(i);
						if(!augmentedHash.contains(tsn)){
							tmpSubgroup->name=tsn;
							break;
						}
						i++;
					}
				}
				augmentedHash.insert(tmpSubgroup->name, tmpSubgroup);
				
				tmpSubgroup->longName = stg->longName+" "+tr("Automatic Subgroup", "Please keep the translation short. It is used when a group contains no subgroups and an automatic subgroup "
				 "is added in the group, in the timetable (when viewing the students timetable from FET and also in the HTML timetables for students subgroups)"
				 ". In the empty group there will be added a subgroup with name = groupName+a space character+your translation of 'Automatic Subgroup'.");
				tmpSubgroup->code = stg->code+" "+tr("Automatic Subgroup", "Please keep the translation short. It is used when a group contains no subgroups and an automatic subgroup "
				 "is added in the group, in the timetable (when viewing the students timetable from FET and also in the HTML timetables for students subgroups)"
				 ". In the empty group there will be added a subgroup with name = groupName+a space character+your translation of 'Automatic Subgroup'.");
				tmpSubgroup->numberOfStudents=stg->numberOfStudents;
				stg->subgroupsList << tmpSubgroup;
				
				if(!correspondingRealStudentsSetName.contains(stg->name))
					correspondingRealStudentsSetName.insert(tmpSubgroup->name, stg->name);
				else
					correspondingRealStudentsSetName.insert(tmpSubgroup->name, correspondingRealStudentsSetName.value(stg->name));
			}
		}
	}
	//////////
	
	QSet<StudentsGroup*> allGroupsSet;
	QSet<StudentsSubgroup*> allSubgroupsSet;
	QList<StudentsGroup*> allGroupsList;
	QList<StudentsSubgroup*> allSubgroupsList;
	
	for(int i=0; i<this->augmentedYearsList.size(); i++){
		StudentsYear* sty=this->augmentedYearsList.at(i);
		sty->indexInAugmentedYearsList=i;

		for(int j=0; j<sty->groupsList.size(); j++){
			StudentsGroup* stg=sty->groupsList.at(j);
			if(!allGroupsSet.contains(stg)){
				allGroupsSet.insert(stg);
				allGroupsList.append(stg);
				stg->indexInInternalGroupsList=allGroupsSet.count()-1;
			}
			
			for(int k=0; k<stg->subgroupsList.size(); k++)
				if(!allSubgroupsSet.contains(stg->subgroupsList.at(k))){
					allSubgroupsSet.insert(stg->subgroupsList.at(k));
					allSubgroupsList.append(stg->subgroupsList.at(k));
					stg->subgroupsList.at(k)->indexInInternalSubgroupsList=allSubgroupsSet.count()-1;
				}
		}
	}
	int tmpNSubgroups=allSubgroupsList.count();
	if(tmpNSubgroups>MAX_TOTAL_SUBGROUPS){
		RulesImpossible::warning(parent, tr("FET information"),
		 tr("You have too many total subgroups. You need to increase the variable MAX_TOTAL_SUBGROUPS (which is currently %1).")
		 .arg(MAX_TOTAL_SUBGROUPS));
		return false;
	}
	this->internalSubgroupsList.resize(tmpNSubgroups);

	int counter=0;
	for(int i=0; i<this->activitiesList.size(); i++){
		Activity* act=this->activitiesList.at(i);
		if(act->active)
			counter++;
	}
	if(counter>MAX_ACTIVITIES){
		RulesImpossible::warning(parent, tr("FET information"),
		 tr("You have too many active activities. You need to increase the variable MAX_ACTIVITIES (which is currently %1).")
		 .arg(MAX_ACTIVITIES));
		return false;
	}

	if(this->buildingsList.size()>MAX_BUILDINGS){
		RulesImpossible::warning(parent, tr("FET information"),
		 tr("You have too many buildings. You need to increase the variable MAX_BUILDINGS (which is currently %1).")
		 .arg(MAX_BUILDINGS));
		return false;
	}
	
	if(this->roomsList.size()>MAX_ROOMS){
		RulesImpossible::warning(parent, tr("FET information"),
		 tr("You have too many rooms. You need to increase the variable MAX_ROOMS (which is currently %1).")
		 .arg(MAX_ROOMS));
		return false;
	}
	
	assert(this->initialized);

	//days and hours
	assert(this->nHoursPerDay>0);
	assert(this->nDaysPerWeek>0);
	this->nHoursPerWeek=this->nHoursPerDay*this->nDaysPerWeek;

	//teachers
	int i;
	Teacher* tch;
	this->nInternalTeachers=this->teachersList.size();
	this->internalTeachersList.resize(this->nInternalTeachers);
	for(i=0; i<this->teachersList.size(); i++){
		tch=teachersList[i];
		this->internalTeachersList[i]=tch;
	}
	assert(i==this->nInternalTeachers);

	teachersHash.clear();
	for(int i=0; i<nInternalTeachers; i++)
		teachersHash.insert(internalTeachersList[i]->name, i);

	//subjects
	Subject* sbj;
	this->nInternalSubjects=this->subjectsList.size();
	this->internalSubjectsList.resize(this->nInternalSubjects);
	for(i=0; i<this->subjectsList.size(); i++){
		sbj=this->subjectsList[i];
		this->internalSubjectsList[i]=sbj;
	}
	assert(i==this->nInternalSubjects);

	subjectsHash.clear();
	for(int i=0; i<nInternalSubjects; i++)
		subjectsHash.insert(internalSubjectsList[i]->name, i);

	//activity tags
	ActivityTag* at;
	this->nInternalActivityTags=this->activityTagsList.size();
	this->internalActivityTagsList.resize(this->nInternalActivityTags);
	for(i=0; i<this->activityTagsList.size(); i++){
		at=this->activityTagsList[i];
		this->internalActivityTagsList[i]=at;
	}
	assert(i==this->nInternalActivityTags);

	activityTagsHash.clear();
	for(int i=0; i<nInternalActivityTags; i++)
		activityTagsHash.insert(internalActivityTagsList[i]->name, i);

	//students
	this->nInternalSubgroups=0;
	for(int i=0; i<allSubgroupsList.count(); i++){
		assert(allSubgroupsList.at(i)->indexInInternalSubgroupsList==i);
		this->internalSubgroupsList[this->nInternalSubgroups]=allSubgroupsList.at(i);
		this->nInternalSubgroups++;
	}

	this->internalGroupsList.clear();
	for(int i=0; i<allGroupsList.count(); i++){
		assert(allGroupsList.at(i)->indexInInternalGroupsList==i);
		this->internalGroupsList.append(allGroupsList.at(i));
	}
	
	studentsHash.clear();
	for(StudentsYear* year : std::as_const(augmentedYearsList)){
		studentsHash.insert(year->name, year);
		for(StudentsGroup* group : std::as_const(year->groupsList)){
			studentsHash.insert(group->name, group);
			for(StudentsSubgroup* subgroup : std::as_const(group->subgroupsList))
				studentsHash.insert(subgroup->name, subgroup);
		}
	}
	
	assert(this->nInternalSubgroups==tmpNSubgroups);

	//buildings
	internalBuildingsList.resize(buildingsList.size());
	this->nInternalBuildings=0;
	assert(this->buildingsList.size()<=MAX_BUILDINGS);
	for(int i=0; i<this->buildingsList.size(); i++){
		Building* bu=this->buildingsList[i];
		bu->computeInternalStructure(*this);
	}
	
	for(int i=0; i<this->buildingsList.size(); i++){
		Building* bu=this->buildingsList[i];
		this->internalBuildingsList[this->nInternalBuildings++]=bu;
	}
	assert(this->nInternalBuildings==this->buildingsList.size());

	buildingsHash.clear();
	for(int i=0; i<nInternalBuildings; i++)
		buildingsHash.insert(internalBuildingsList[i]->name, i);

	//rooms
	internalRoomsList.resize(roomsList.size());
	this->nInternalRooms=0;
	assert(this->roomsList.size()<=MAX_ROOMS);
	for(int i=0; i<this->roomsList.size(); i++){
		Room* rm=this->roomsList[i];
		rm->computeInternalStructure(*this);
	}
	
	for(int i=0; i<this->roomsList.size(); i++){
		Room* rm=this->roomsList[i];
		this->internalRoomsList[this->nInternalRooms++]=rm;
	}
	assert(this->nInternalRooms==this->roomsList.size());

	roomsHash.clear();
	for(int i=0; i<nInternalRooms; i++)
		roomsHash.insert(internalRoomsList[i]->name, i);
		
	for(int i=0; i<nInternalRooms; i++){
		Room* rm=internalRoomsList[i];
		
		if(rm->isVirtual){
			if(rm->realRoomsSetsList.count()==0){
				RulesImpossible::warning(parent, tr("FET information"), tr("Virtual room %1 has 0 sets of real rooms to choose"
				 " from. The number of sets of real rooms must be at least 2. Please correct this.").arg(rm->name));
				return false;
			}
			if(rm->realRoomsSetsList.count()==1){
				RulesImpossible::warning(parent, tr("FET information"), tr("Virtual room %1 has only 1 set of real rooms to choose"
				 " from. The number of sets of real rooms must be at least 2. Please correct this.").arg(rm->name));
				return false;
			}
			
			int i=0;
			for(const QStringList& tl : std::as_const(rm->realRoomsSetsList)){
				if(tl.count()==0){
					RulesImpossible::warning(parent, tr("FET information"), tr("Virtual room %1, in set number %2, has 0 real rooms"
					 " to choose from. The number of real rooms from each set must be at least 1. Please correct this.").arg(rm->name).arg(i+1));
					return false;
				}
				
				QStringList tl2;
				QSet<QString> ts;
				for(const QString& t : std::as_const(tl))
					if(!ts.contains(t))
						ts.insert(t);
					else
						tl2.append(t);
				if(!tl2.isEmpty()){
					RulesImpossible::warning(parent, tr("FET information"), tr("Virtual room %1, in set number %2, has these duplicate real rooms names: %3."
					 " Please correct this.").arg(rm->name).arg(i+1).arg(tl2.join(translatedCommaSpace())));
					return false;
				}
				
				for(const QString& rr : std::as_const(tl)){
					int rri=roomsHash.value(rr, -1);

					if(rri==-1){
						RulesImpossible::warning(parent, tr("FET information"),
						 tr("The virtual room %1 contains the unrecognized real room %2 in the sets of real rooms - please correct this.").arg(rm->name).arg(rr));
						
						return false;
					}
					
					assert(rri>=0);
					if(internalRoomsList[rri]->isVirtual==true){
						RulesImpossible::warning(parent, tr("FET information"), tr("Virtual room %1, in set number %2, contains the virtual room"
						 " %3 - please correct this (a virtual room can only contain sets with real rooms).").arg(rm->name).arg(i+1).arg(rr));
						return false;
					}
				}
				
				i++;
			}
		}

		rm->computeInternalStructureRealRoomsSetsList(*this);
	}

	//activities
	int range=0;
	for(Activity* act : std::as_const(this->activitiesList))
		if(act->active)
			range++;
	QProgressDialog progress(parent);
	progress.setWindowTitle(tr("Computing internal structure", "Title of a progress dialog"));
	progress.setLabelText(tr("Processing internally the activities ... please wait"));
	progress.setRange(0, qMax(range, 1));
	progress.setModal(true);
	int ttt=0;
	
	Activity* act;
	counter=0;
	
	this->inactiveActivities.clear();
	
	for(int i=0; i<this->activitiesList.size(); i++){
		act=this->activitiesList[i];
		if(act->active){
			progress.setValue(ttt);
			//pqapplication->processEvents();
			if(progress.wasCanceled()){
				progress.setValue(range);
				RulesImpossible::warning(parent, tr("FET information"), tr("Canceled"));
				return false;
			}
			ttt++;

			counter++;
			act->computeInternalStructure(*this);
		}
		else
			inactiveActivities.insert(act->id);
	}
	
	progress.setValue(qMax(range, 1));

	for(int i=0; i<nInternalSubgroups; i++)
		internalSubgroupsList[i]->activitiesForSubgroup.clear();
	for(int i=0; i<nInternalTeachers; i++)
		internalTeachersList[i]->activitiesForTeacher.clear();

	assert(counter<=MAX_ACTIVITIES);
	this->nInternalActivities=counter;
	this->internalActivitiesList.resize(this->nInternalActivities);
	int activei=0;
	for(int ai=0; ai<this->activitiesList.size(); ai++){
		act=this->activitiesList[ai];
		if(act->active){
			this->internalActivitiesList[activei]=*act;
			
			for(int j=0; j<act->iSubgroupsList.count(); j++){
				int k=act->iSubgroupsList.at(j);
				//The test below would take too much time
				//assert(!internalSubgroupsList[k]->activitiesForSubgroup.contains(activei));
				internalSubgroupsList[k]->activitiesForSubgroup.append(activei);
			}
			
			for(int j=0; j<act->iTeachersList.count(); j++){
				int k=act->iTeachersList.at(j);
				//The test below would take too much time
				//assert(!internalTeachersList[k]->activitiesForTeacher.contains(activei));
				internalTeachersList[k]->activitiesForTeacher.append(activei);
			}
			
			activei++;
		}
	}

	activitiesHash.clear();
	for(int i=0; i<nInternalActivities; i++){
		assert(!activitiesHash.contains(internalActivitiesList[i].id));
		activitiesHash.insert(internalActivitiesList[i].id, i);
	}

	//activities list for each subject - used for subjects timetable - in order for students and teachers
	activitiesForSubjectList.resize(nInternalSubjects);
	activitiesForSubjectSet.resize(nInternalSubjects);
	for(int sb=0; sb<nInternalSubjects; sb++){
		activitiesForSubjectList[sb].clear();
		activitiesForSubjectSet[sb].clear();
	}

	for(int i=0; i<this->augmentedYearsList.size(); i++){
		StudentsYear* sty=this->augmentedYearsList[i];

		for(int j=0; j<sty->groupsList.size(); j++){
			StudentsGroup* stg=sty->groupsList[j];

			for(int k=0; k<stg->subgroupsList.size(); k++){
				StudentsSubgroup* sts=stg->subgroupsList[k];
				
				for(int ai : std::as_const(internalSubgroupsList[sts->indexInInternalSubgroupsList]->activitiesForSubgroup))
					if(!activitiesForSubjectSet[internalActivitiesList[ai].subjectIndex].contains(ai)){
						activitiesForSubjectList[internalActivitiesList[ai].subjectIndex].append(ai);
						activitiesForSubjectSet[internalActivitiesList[ai].subjectIndex].insert(ai);
					}
			}
		}
	}
	
	for(int i=0; i<nInternalTeachers; i++){
		for(int ai : std::as_const(internalTeachersList[i]->activitiesForTeacher))
			if(!activitiesForSubjectSet[internalActivitiesList[ai].subjectIndex].contains(ai)){
				activitiesForSubjectList[internalActivitiesList[ai].subjectIndex].append(ai);
				activitiesForSubjectSet[internalActivitiesList[ai].subjectIndex].insert(ai);
			}
	}
	
	//for activities without students or teachers
	for(int ai=0; ai<nInternalActivities; ai++){
		int si=internalActivitiesList[ai].subjectIndex;
		if(!activitiesForSubjectSet[si].contains(ai)){
			activitiesForSubjectList[si].append(ai);
			activitiesForSubjectSet[si].insert(ai);
		}
	}
	/////////////////////////////////////////////////////////////////
	
	//activities list for each activity tag - used for activity tags timetable - in order for students and teachers
	activitiesForActivityTagList.resize(nInternalActivityTags);
	activitiesForActivityTagSet.resize(nInternalActivityTags);
	for(int a=0; a<nInternalActivityTags; a++){
		activitiesForActivityTagList[a].clear();
		activitiesForActivityTagSet[a].clear();
	}

	for(int i=0; i<this->augmentedYearsList.size(); i++){
		StudentsYear* sty=this->augmentedYearsList[i];

		for(int j=0; j<sty->groupsList.size(); j++){
			StudentsGroup* stg=sty->groupsList[j];

			for(int k=0; k<stg->subgroupsList.size(); k++){
				StudentsSubgroup* sts=stg->subgroupsList[k];
				
				for(int ai : std::as_const(internalSubgroupsList[sts->indexInInternalSubgroupsList]->activitiesForSubgroup))
					for(int activityTagInt : std::as_const(internalActivitiesList[ai].iActivityTagsSet))
						if(!activitiesForActivityTagSet[activityTagInt].contains(ai)){
							activitiesForActivityTagList[activityTagInt].append(ai);
							activitiesForActivityTagSet[activityTagInt].insert(ai);
						}
			}
		}
	}
	
	for(int i=0; i<nInternalTeachers; i++){
		for(int ai : std::as_const(internalTeachersList[i]->activitiesForTeacher))
			for(int activityTagInt : std::as_const(internalActivitiesList[ai].iActivityTagsSet))
				if(!activitiesForActivityTagSet[activityTagInt].contains(ai)){
					activitiesForActivityTagList[activityTagInt].append(ai);
					activitiesForActivityTagSet[activityTagInt].insert(ai);
				}
	}

	//for activities without students or teachers
	for(int ai=0; ai<nInternalActivities; ai++){
		for(int ati : std::as_const(internalActivitiesList[ai].iActivityTagsSet)){
			if(!activitiesForActivityTagSet[ati].contains(ai)){
				activitiesForActivityTagList[ati].append(ai);
				activitiesForActivityTagSet[ati].insert(ai);
			}
		}
	}
	/////////////////////////////////////////////////////////////////

	bool ok=true;

	//time constraints
	//progress.reset();
	
	bool skipInactiveTimeConstraints=false;
	
	TimeConstraint* tctr;
	
	QSet<int> toSkipTimeSet;
	
	int _c=0;
	
	for(int tctrindex=0; tctrindex<this->timeConstraintsList.size(); tctrindex++){
		tctr=this->timeConstraintsList[tctrindex];

		if(!tctr->active){
			toSkipTimeSet.insert(tctrindex);
		}
		else if(tctr->hasInactiveActivities(*this)){
			//toSkipTime[tctrindex]=true;
			toSkipTimeSet.insert(tctrindex);
		
			if(!skipInactiveTimeConstraints){
				QString s=tr("The following time constraint is ignored, because it refers to inactive activities:");
				s+="\n";
				s+=tctr->getDetailedDescription(*this);
				
				int t=RulesConstraintIgnored::mediumConfirmation(parent, tr("FET information"), s,
				 tr("Skip rest"), tr("See next"), QString(),
 				 1, 0 );

				if(t==0)
					skipInactiveTimeConstraints=true;
			}
		}
		else{
			//toSkipTime[tctrindex]=false;
			_c++;
		}
	}
	
	internalTimeConstraintsList.resize(_c);
	
	progress.setLabelText(tr("Processing internally the time constraints ... please wait"));
	progress.setRange(0, qMax(timeConstraintsList.size(), 1));
	ttt=0;
		
	//assert(this->timeConstraintsList.size()<=MAX_TIME_CONSTRAINTS);
	int tctri=0;
	
	for(int tctrindex=0; tctrindex<this->timeConstraintsList.size(); tctrindex++){
		progress.setValue(ttt);
		//pqapplication->processEvents();
		if(progress.wasCanceled()){
			progress.setValue(timeConstraintsList.size());
			RulesImpossible::warning(parent, tr("FET information"), tr("Canceled"));
			return false;
		}
		ttt++;

		tctr=this->timeConstraintsList[tctrindex];
		
		if(toSkipTimeSet.contains(tctrindex))
			continue;
		
		if(!tctr->computeInternalStructure(parent, *this)){
			//assert(0);
			ok=false;
			continue;
		}
		this->internalTimeConstraintsList[tctri++]=tctr;
	}

	progress.setValue(qMax(timeConstraintsList.size(), 1));

	this->nInternalTimeConstraints=tctri;
	if(VERBOSE){
		std::cout<<_c<<" time constraints after first pass (after removing inactive ones)"<<std::endl;
		std::cout<<"  "<<this->nInternalTimeConstraints<<" time constraints after second pass (after removing wrong ones)"<<std::endl;
	}
	assert(_c>=this->nInternalTimeConstraints); //because some constraints may have toSkipTime false, but computeInternalStructure also false
	//assert(this->nInternalTimeConstraints<=MAX_TIME_CONSTRAINTS);
	
	//space constraints
	//progress.reset();
	
	bool skipInactiveSpaceConstraints=false;
	
	SpaceConstraint* sctr;
	
	QSet<int> toSkipSpaceSet;
	
	_c=0;

	for(int sctrindex=0; sctrindex<this->spaceConstraintsList.size(); sctrindex++){
		sctr=this->spaceConstraintsList[sctrindex];

		if(!sctr->active){
			toSkipSpaceSet.insert(sctrindex);
		}
		else if(sctr->hasInactiveActivities(*this)){
			//toSkipSpace[sctrindex]=true;
			toSkipSpaceSet.insert(sctrindex);
		
			if(!skipInactiveSpaceConstraints){
				QString s=tr("The following space constraint is ignored, because it refers to inactive activities:");
				s+="\n";
				s+=sctr->getDetailedDescription(*this);
				
				int t=RulesConstraintIgnored::mediumConfirmation(parent, tr("FET information"), s,
				 tr("Skip rest"), tr("See next"), QString(),
 				 1, 0 );

				if(t==0)
					skipInactiveSpaceConstraints=true;
			}
		}
		else{
			_c++;
			//toSkipSpace[sctrindex]=false;
		}
	}
	
	internalSpaceConstraintsList.resize(_c);
	
	progress.setLabelText(tr("Processing internally the space constraints ... please wait"));
	progress.setRange(0, qMax(spaceConstraintsList.size(), 1));
	ttt=0;
	//assert(this->spaceConstraintsList.size()<=MAX_SPACE_CONSTRAINTS);

	int sctri=0;

	for(int sctrindex=0; sctrindex<this->spaceConstraintsList.size(); sctrindex++){
		progress.setValue(ttt);
		//pqapplication->processEvents();
		if(progress.wasCanceled()){
			progress.setValue(spaceConstraintsList.size());
			RulesImpossible::warning(parent, tr("FET information"), tr("Canceled"));
			return false;
		}
		ttt++;

		sctr=this->spaceConstraintsList[sctrindex];
	
		if(toSkipSpaceSet.contains(sctrindex))
			continue;
		
		if(!sctr->computeInternalStructure(parent, *this)){
			//assert(0);
			ok=false;
			continue;
		}
		this->internalSpaceConstraintsList[sctri++]=sctr;
	}

	progress.setValue(qMax(spaceConstraintsList.size(), 1));

	this->nInternalSpaceConstraints=sctri;
	if(VERBOSE){
		std::cout<<_c<<" space constraints after first pass (after removing inactive ones)"<<std::endl;
		std::cout<<"  "<<this->nInternalSpaceConstraints<<" space constraints after second pass (after removing wrong ones)"<<std::endl;
	}
	assert(_c>=this->nInternalSpaceConstraints); //because some constraints may have toSkipSpace false, but computeInternalStructure also false
	//assert(this->nInternalSpaceConstraints<=MAX_SPACE_CONSTRAINTS);
	
	//group activities in the initial order
	if(groupActivitiesInInitialOrderList.count()>0){
		QStringList fetBugs;
		QStringList userErrors;
	
		QSet<int> visitedIds;
		for(int j=0; j<groupActivitiesInInitialOrderList.count(); j++){
			GroupActivitiesInInitialOrderItem* item=groupActivitiesInInitialOrderList[j];
			
			if(!item->active)
				continue;
			
			if(item->ids.count()<2){
				fetBugs.append(tr("All 'group activities in the initial order for timetable generation' items should contain at least two activities ids."
				 " This is not true for item number %1. Please report potential bug.").arg(j+1));
			}

			item->indices.clear();
			for(int id : std::as_const(item->ids)){
				if(visitedIds.contains(id)){
					userErrors.append(tr("All 'group activities in the initial order for timetable generation' items should have different activities ids."
					 " (Each activity id must appear at most once in all the items.) This is not true for item number %1 and activity id %2.").arg(j+1).arg(id));
				}
				else{
					visitedIds.insert(id);
					int index=activitiesHash.value(id, -1);
					if(index>=0)
						item->indices.append(index);
				}
			}

			if(!fetBugs.isEmpty() || !userErrors.isEmpty()){
				RulesImpossible::warning(parent, tr("FET information"), fetBugs.join("\n\n")+userErrors.join("\n\n"));
				return false;
			}
		}
	}

	//done.
	this->internalStructureComputed=ok;
	
	return ok;
}

void Rules::clear() //clears the memory for the rules.
{
	//Teachers
	for(Teacher* tch : std::as_const(teachersList))
		delete tch;
	teachersList.clear();
	//while(!teachersList.isEmpty())
	//	delete teachersList.takeFirst();

	//Subjects
	for(Subject* sbj : std::as_const(subjectsList))
		delete sbj;
	subjectsList.clear();
	//while(!subjectsList.isEmpty())
	//	delete subjectsList.takeFirst();

	//Activity tags
	for(ActivityTag* at : std::as_const(activityTagsList))
		delete at;
	activityTagsList.clear();
	//while(!activityTagsList.isEmpty())
	//	delete activityTagsList.takeFirst();

	//Years
	/*while(!yearsList.isEmpty())
		delete yearsList.takeFirst();*/
		
	//students sets
	QSet<StudentsYear*> iyears;
	QSet<StudentsGroup*> igroups;
	QSet<StudentsSubgroup*> isubgroups;
	for(StudentsYear* year : std::as_const(yearsList)){
		if(!iyears.contains(year))
			iyears.insert(year);
		for(StudentsGroup* group : std::as_const(year->groupsList)){
			if(!igroups.contains(group))
				igroups.insert(group);
			for(StudentsSubgroup* subgroup : std::as_const(group->subgroupsList)){
				if(!isubgroups.contains(subgroup))
					isubgroups.insert(subgroup);
			}
		}
	}
	for(StudentsYear* year : std::as_const(iyears)){
		assert(year!=nullptr);
		delete year;
	}
	for(StudentsGroup* group : std::as_const(igroups)){
		assert(group!=nullptr);
		delete group;
	}
	for(StudentsSubgroup* subgroup : std::as_const(isubgroups)){
		assert(subgroup!=nullptr);
		delete subgroup;
	}
	yearsList.clear();
	
	permanentStudentsHash.clear();
	//////////////////

	//clear augmented students sets
	QList<StudentsYear*> ayears;
	QList<StudentsGroup*> agroups;
	QList<StudentsSubgroup*> asubgroups;
	for(StudentsYear* year : std::as_const(augmentedYearsList)){
		if(!ayears.contains(year))
			ayears.append(year);
		for(StudentsGroup* group : std::as_const(year->groupsList)){
			if(!agroups.contains(group))
				agroups.append(group);
			for(StudentsSubgroup* subgroup : std::as_const(group->subgroupsList)){
				if(!asubgroups.contains(subgroup))
					asubgroups.append(subgroup);
			}
		}
	}
	for(StudentsYear* year : std::as_const(ayears)){
		assert(year!=nullptr);
		delete year;
	}
	for(StudentsGroup* group : std::as_const(agroups)){
		assert(group!=nullptr);
		delete group;
	}
	for(StudentsSubgroup* subgroup : std::as_const(asubgroups)){
		assert(subgroup!=nullptr);
		delete subgroup;
	}
	internalGroupsList.clear();
	
	augmentedYearsList.clear();

	correspondingRealStudentsSetName.clear();
	//////////////////
	
	//Activities
	for(Activity* act : std::as_const(activitiesList))
		delete act;
	activitiesList.clear();
	//while(!activitiesList.isEmpty())
	//	delete activitiesList.takeFirst();

	//Time constraints
	for(TimeConstraint* tc : std::as_const(timeConstraintsList))
		delete tc;
	timeConstraintsList.clear();
	//while(!timeConstraintsList.isEmpty())
	//	delete timeConstraintsList.takeFirst();

	//Space constraints
	for(SpaceConstraint* sc : std::as_const(spaceConstraintsList))
		delete sc;
	spaceConstraintsList.clear();
	//while(!spaceConstraintsList.isEmpty())
	//	delete spaceConstraintsList.takeFirst();

	//Buildings
	for(Building* bu : std::as_const(buildingsList))
		delete bu;
	buildingsList.clear();
	//while(!buildingsList.isEmpty())
	//	delete buildingsList.takeFirst();

	//Rooms
	for(Room* rm : std::as_const(roomsList))
		delete rm;
	roomsList.clear();
	//while(!roomsList.isEmpty())
	//	delete roomsList.takeFirst();
		
	for(GroupActivitiesInInitialOrderItem* ga : std::as_const(groupActivitiesInInitialOrderList))
		delete ga;
	groupActivitiesInInitialOrderList.clear();
	//while(!groupActivitiesInInitialOrderList.isEmpty())
	//	delete groupActivitiesInInitialOrderList.takeFirst();

	activitiesPointerHash.clear();
	bctSet.clear();
	btSet.clear();
	bcsSet.clear();
	apstHash.clear();
	apdHash.clear();
	aprHash.clear();
	mdbaHash.clear();
	mhdbaHash.clear();
	tnatHash.clear();
	ssnatHash.clear();
	
	teachersHash.clear();
	subjectsHash.clear();
	activityTagsHash.clear();
	studentsHash.clear();
	buildingsHash.clear();
	roomsHash.clear();
	activitiesHash.clear();

	//done
	this->internalStructureComputed=false;
	this->initialized=false;

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
}

Rules::Rules()
{
	this->initialized=false;
	this->modified=false;

	//cntUndoRedoStackIterator=0;
	
	this->mode=OFFICIAL;
}

Rules::~Rules()
{
	if(this->initialized)
		this->clear();
}

void Rules::setMode(int newMode)
{
	if(newMode==mode)
		return;

	if(newMode==OFFICIAL || newMode==BLOCK_PLANNING || newMode==TERMS){
		//just to free this memory
		this->nRealDaysPerWeek=0;
		this->realDaysOfTheWeek.clear();
		this->realDaysOfTheWeek_longNames.clear();
		
		this->nRealHoursPerDay=0;
		this->realHoursOfTheDay.clear();
		this->realHoursOfTheDay_longNames.clear();
		//
		
		for(Teacher* tch : std::as_const(teachersList))
			tch->morningsAfternoonsBehavior=TEACHER_MORNINGS_AFTERNOONS_BEHAVIOR_NOT_INITIALIZED;
	}
	else if(newMode==MORNINGS_AFTERNOONS){
		this->nRealDaysPerWeek=this->nDaysPerWeek/2;
		this->realDaysOfTheWeek.clear();
		this->realDaysOfTheWeek_longNames.clear();
		for(int rd=0; rd<this->nRealDaysPerWeek; rd++){
			this->realDaysOfTheWeek.append(this->daysOfTheWeek.at(2*rd));
			this->realDaysOfTheWeek_longNames.append(this->daysOfTheWeek_longNames.at(2*rd));
		}
		
		this->nRealHoursPerDay=2*this->nHoursPerDay;
		this->realHoursOfTheDay.clear();
		this->realHoursOfTheDay_longNames.clear();
		for(int h=0; h<this->nHoursPerDay; h++){
			this->realHoursOfTheDay.append(QString("H")+QString::number(h+1));
			this->realHoursOfTheDay_longNames.append(this->hoursOfTheDay_longNames.at(h)+QString(" ")+tr("AM", "Ante Meridiem, before noon"));
		}
		for(int h=0; h<this->nHoursPerDay; h++){
			this->realHoursOfTheDay.append(QString("H")+QString::number(this->nHoursPerDay+h+1));
			this->realHoursOfTheDay_longNames.append(this->hoursOfTheDay_longNames.at(h)+QString(" ")+tr("PM", "Post Meridiem, afternoon"));
		}
		
		for(Teacher* tch : std::as_const(teachersList))
			if(tch->morningsAfternoonsBehavior==TEACHER_MORNINGS_AFTERNOONS_BEHAVIOR_NOT_INITIALIZED)
				tch->morningsAfternoonsBehavior=TEACHER_UNRESTRICTED_MORNINGS_AFTERNOONS;
	}
	else{
		assert(0);
	}
	
	this->mode=newMode;

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
}

void Rules::setTerms(int numberOfTerms, int numberOfDaysPerTerm)
{
	assert(this->mode==TERMS);
	
	this->nTerms=numberOfTerms;
	this->nDaysPerTerm=numberOfDaysPerTerm;
	
	//If you add more types of constraints which are affected, like these below, update the code below and also
	//do not forget to update the similar code in src/interface/termsform.cpp, function TermsForm::ok().
	for(TimeConstraint* tc : std::as_const(this->timeConstraintsList)){
		switch(tc->type){
			case CONSTRAINT_MAX_TERMS_BETWEEN_ACTIVITIES:
				{
					ConstraintMaxTermsBetweenActivities* cmt=(ConstraintMaxTermsBetweenActivities*)tc;
					if(cmt->maxTerms>=this->nTerms)
						cmt->maxTerms=this->nTerms-1;
					break;
				}
			case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_TERMS:
				{
					ConstraintActivitiesOccupyMaxTerms* camt=(ConstraintActivitiesOccupyMaxTerms*)tc;
					if(camt->maxOccupiedTerms>this->nTerms)
						camt->maxOccupiedTerms=this->nTerms;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_HOURS_PER_TERM:
				{
					ConstraintTeacherMaxHoursPerTerm* ctmht=(ConstraintTeacherMaxHoursPerTerm*)tc;
					if(ctmht->maxHoursPerTerm > this->nDaysPerTerm * this->nHoursPerDay)
						ctmht->maxHoursPerTerm = this->nDaysPerTerm * this->nHoursPerDay;
					break;
				}
			case CONSTRAINT_TEACHERS_MAX_HOURS_PER_TERM:
				{
					ConstraintTeachersMaxHoursPerTerm* ctsmht=(ConstraintTeachersMaxHoursPerTerm*)tc;
					if(ctsmht->maxHoursPerTerm > this->nDaysPerTerm * this->nHoursPerDay)
						ctsmht->maxHoursPerTerm = this->nDaysPerTerm * this->nHoursPerDay;
					break;
				}
				
			default:
				//do nothing.
				break;
		}
	}

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
}

void Rules::setInstitutionName(const QString& newInstitutionName)
{
	this->institutionName=newInstitutionName;
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);
}

void Rules::setComments(const QString& newComments)
{
	this->comments=newComments;
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);
}

bool Rules::addTeacher(Teacher* teacher)
{
	for(int i=0; i<this->teachersList.size(); i++){
		Teacher* tch=this->teachersList[i];
		if(tch->name==teacher->name)
			return false;
	}
	
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	this->teachersList.append(teacher);
	return true;
}

bool Rules::addTeacherFast(Teacher* teacher)
{
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	this->teachersList.append(teacher);
	return true;
}

int Rules::searchTeacher(const QString& teacherName)
{
	for(int i=0; i<this->teachersList.size(); i++)
		if(this->teachersList.at(i)->name==teacherName)
			return i;

	return -1;
}

bool Rules::removeTeacher(const QString& teacherName)
{
	QList<int> idsToBeRemoved;
	for(Activity* act : std::as_const(activitiesList)){
		bool t=act->removeTeacher(teacherName);
		if(t && act->teachersNames.count()==0)
			idsToBeRemoved.append(act->id);
	}
	removeActivities(idsToBeRemoved, false);

	for(int i=0; i<this->teachersList.size(); i++)
		if(this->teachersList.at(i)->name==teacherName){
			Teacher* tch=this->teachersList[i];
			this->teachersList.removeAt(i);
			delete tch;
			break;
		}
	
	updateConstraintsAfterRemoval();

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

bool Rules::modifyTeacher(const QString& initialTeacherName, const QString& finalTeacherName)
{
	assert(this->searchTeacher(finalTeacherName)==-1);
	assert(this->searchTeacher(initialTeacherName)>=0);

	for(int i=0; i<this->activitiesList.size(); i++)
		this->activitiesList.at(i)->renameTeacher(initialTeacherName, finalTeacherName);
		
	for(TimeConstraint* ctr : std::as_const(timeConstraintsList)){
		switch(ctr->type){
			case CONSTRAINT_TEACHER_NOT_AVAILABLE_TIMES:
				{
					ConstraintTeacherNotAvailableTimes* crt_constraint=(ConstraintTeacherNotAvailableTimes*)ctr;
					if(initialTeacherName == crt_constraint->teacher)
						crt_constraint->teacher=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_WEEK:
				{
					ConstraintTeacherMaxGapsPerWeek* crt_constraint=(ConstraintTeacherMaxGapsPerWeek*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_DAY:
				{
					ConstraintTeacherMaxGapsPerDay* crt_constraint=(ConstraintTeacherMaxGapsPerDay*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_MORNING_AND_AFTERNOON:
				{
					ConstraintTeacherMaxGapsPerMorningAndAfternoon* crt_constraint=(ConstraintTeacherMaxGapsPerMorningAndAfternoon*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_HOURS_DAILY:
				{
					ConstraintTeacherMaxHoursDaily* crt_constraint=(ConstraintTeacherMaxHoursDaily*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintTeacherMaxHoursContinuously* crt_constraint=(ConstraintTeacherMaxHoursContinuously*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintTeacherActivityTagMaxHoursContinuously* crt_constraint=(ConstraintTeacherActivityTagMaxHoursContinuously*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_DAILY:
				{
					ConstraintTeacherActivityTagMaxHoursDaily* crt_constraint=(ConstraintTeacherActivityTagMaxHoursDaily*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MIN_HOURS_DAILY:
				{
					ConstraintTeacherActivityTagMinHoursDaily* crt_constraint=(ConstraintTeacherActivityTagMinHoursDaily*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_HOURS_DAILY:
				{
					ConstraintTeacherMinHoursDaily* crt_constraint=(ConstraintTeacherMinHoursDaily*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
				{
					ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTags* crt_constraint=(ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTags*)ctr;
					if(initialTeacherName == crt_constraint->teacher)
						crt_constraint->teacher=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
				{
					ConstraintTeacherMinGapsBetweenActivityTag* crt_constraint=(ConstraintTeacherMinGapsBetweenActivityTag*)ctr;
					if(initialTeacherName == crt_constraint->teacher)
						crt_constraint->teacher=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
				{
					ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* crt_constraint=(ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsPerRealDay*)ctr;
					if(initialTeacherName == crt_constraint->teacher)
						crt_constraint->teacher=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
				{
					ConstraintTeacherMinGapsBetweenActivityTagPerRealDay* crt_constraint=(ConstraintTeacherMinGapsBetweenActivityTagPerRealDay*)ctr;
					if(initialTeacherName == crt_constraint->teacher)
						crt_constraint->teacher=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* crt_constraint=(ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon*)ctr;
					if(initialTeacherName == crt_constraint->teacher)
						crt_constraint->teacher=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeacherMinGapsBetweenActivityTagBetweenMorningAndAfternoon* crt_constraint=(ConstraintTeacherMinGapsBetweenActivityTagBetweenMorningAndAfternoon*)ctr;
					if(initialTeacherName == crt_constraint->teacher)
						crt_constraint->teacher=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeacherMaxDaysPerWeek* crt_constraint=(ConstraintTeacherMaxDaysPerWeek*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_NO_TWO_CONSECUTIVE_DAYS:
				{
					ConstraintTeacherNoTwoConsecutiveDays* crt_constraint=(ConstraintTeacherNoTwoConsecutiveDays*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_THREE_CONSECUTIVE_DAYS:
				{
					ConstraintTeacherMaxThreeConsecutiveDays* crt_constraint=(ConstraintTeacherMaxThreeConsecutiveDays*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_DAYS_PER_WEEK:
				{
					ConstraintTeacherMinDaysPerWeek* crt_constraint=(ConstraintTeacherMinDaysPerWeek*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeacherIntervalMaxDaysPerWeek* crt_constraint=(ConstraintTeacherIntervalMaxDaysPerWeek*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_ACTIVITIES_PREFERRED_TIME_SLOTS:
				{
					ConstraintActivitiesPreferredTimeSlots* crt_constraint=(ConstraintActivitiesPreferredTimeSlots*)ctr;
					if(initialTeacherName == crt_constraint->p_teacherName)
						crt_constraint->p_teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_ACTIVITIES_PREFERRED_STARTING_TIMES:
				{
					ConstraintActivitiesPreferredStartingTimes* crt_constraint=(ConstraintActivitiesPreferredStartingTimes*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_ACTIVITIES_END_STUDENTS_DAY:
				{
					ConstraintActivitiesEndStudentsDay* crt_constraint=(ConstraintActivitiesEndStudentsDay*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_ACTIVITIES_END_TEACHERS_DAY:
				{
					ConstraintActivitiesEndTeachersDay* crt_constraint=(ConstraintActivitiesEndTeachersDay*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}

			case CONSTRAINT_ACTIVITIES_BEGIN_STUDENTS_DAY:
				{
					ConstraintActivitiesBeginStudentsDay* crt_constraint=(ConstraintActivitiesBeginStudentsDay*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_ACTIVITIES_BEGIN_TEACHERS_DAY:
				{
					ConstraintActivitiesBeginTeachersDay* crt_constraint=(ConstraintActivitiesBeginTeachersDay*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}

			case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_STUDENTS_DAY:
				{
					ConstraintActivitiesBeginOrEndStudentsDay* crt_constraint=(ConstraintActivitiesBeginOrEndStudentsDay*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_TEACHERS_DAY:
				{
					ConstraintActivitiesBeginOrEndTeachersDay* crt_constraint=(ConstraintActivitiesBeginOrEndTeachersDay*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}

			case CONSTRAINT_SUBACTIVITIES_PREFERRED_TIME_SLOTS:
				{
					ConstraintSubactivitiesPreferredTimeSlots* crt_constraint=(ConstraintSubactivitiesPreferredTimeSlots*)ctr;
					if(initialTeacherName == crt_constraint->p_teacherName)
						crt_constraint->p_teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_SUBACTIVITIES_PREFERRED_STARTING_TIMES:
				{
					ConstraintSubactivitiesPreferredStartingTimes* crt_constraint=(ConstraintSubactivitiesPreferredStartingTimes*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			//2017-02-07
			case CONSTRAINT_TEACHER_MAX_SPAN_PER_DAY:
				{
					ConstraintTeacherMaxSpanPerDay* crt_constraint=(ConstraintTeacherMaxSpanPerDay*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_RESTING_HOURS:
				{
					ConstraintTeacherMinRestingHours* crt_constraint=(ConstraintTeacherMinRestingHours*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}

			//mornings-afternoons
			case CONSTRAINT_TEACHER_AFTERNOONS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintTeacherAfternoonsEarlyMaxBeginningsAtSecondHour* crt_constraint=(ConstraintTeacherAfternoonsEarlyMaxBeginningsAtSecondHour*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MORNINGS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintTeacherMorningsEarlyMaxBeginningsAtSecondHour* crt_constraint=(ConstraintTeacherMorningsEarlyMaxBeginningsAtSecondHour*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_REAL_DAY:
				{
					ConstraintTeacherMaxGapsPerRealDay* crt_constraint=(ConstraintTeacherMaxGapsPerRealDay*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_WEEK_FOR_REAL_DAYS:
				{
					ConstraintTeacherMaxGapsPerWeekForRealDays* crt_constraint=(ConstraintTeacherMaxGapsPerWeekForRealDays*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_ZERO_GAPS_PER_AFTERNOON:
				{
					ConstraintTeacherMaxZeroGapsPerAfternoon* crt_constraint=(ConstraintTeacherMaxZeroGapsPerAfternoon*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeacherMaxHoursDailyRealDays* crt_constraint=(ConstraintTeacherMaxHoursDailyRealDays*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeacherActivityTagMaxHoursDailyRealDays* crt_constraint=(ConstraintTeacherActivityTagMaxHoursDailyRealDays*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			//2020-06-28
			case CONSTRAINT_TEACHER_MAX_HOURS_PER_ALL_AFTERNOONS:
				{
					ConstraintTeacherMaxHoursPerAllAfternoons* crt_constraint=(ConstraintTeacherMaxHoursPerAllAfternoons*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			//
			case CONSTRAINT_TEACHER_MIN_HOURS_PER_MORNING:
				{
					ConstraintTeacherMinHoursPerMorning* crt_constraint=(ConstraintTeacherMinHoursPerMorning*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_HOURS_PER_AFTERNOON:
				{
					ConstraintTeacherMinHoursPerAfternoon* crt_constraint=(ConstraintTeacherMinHoursPerAfternoon*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeacherMinHoursDailyRealDays* crt_constraint=(ConstraintTeacherMinHoursDailyRealDays*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_REAL_DAYS_PER_WEEK:
				{
					ConstraintTeacherMaxRealDaysPerWeek* crt_constraint=(ConstraintTeacherMaxRealDaysPerWeek*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_AFTERNOONS_PER_WEEK:
				{
					ConstraintTeacherMaxAfternoonsPerWeek* crt_constraint=(ConstraintTeacherMaxAfternoonsPerWeek*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintTeacherMaxActivityTagsPerDayFromSet* crt_constraint=(ConstraintTeacherMaxActivityTagsPerDayFromSet*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintTeacherMaxActivityTagsPerRealDayFromSet* crt_constraint=(ConstraintTeacherMaxActivityTagsPerRealDayFromSet*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}

			case CONSTRAINT_TEACHER_MAX_MORNINGS_PER_WEEK:
				{
					ConstraintTeacherMaxMorningsPerWeek* crt_constraint=(ConstraintTeacherMaxMorningsPerWeek*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_TWO_CONSECUTIVE_MORNINGS:
				{
					ConstraintTeacherMaxTwoConsecutiveMornings* crt_constraint=(ConstraintTeacherMaxTwoConsecutiveMornings*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_TWO_CONSECUTIVE_AFTERNOONS:
				{
					ConstraintTeacherMaxTwoConsecutiveAfternoons* crt_constraint=(ConstraintTeacherMaxTwoConsecutiveAfternoons*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_REAL_DAYS_PER_WEEK:
				{
					ConstraintTeacherMinRealDaysPerWeek* crt_constraint=(ConstraintTeacherMinRealDaysPerWeek*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_MORNINGS_PER_WEEK:
				{
					ConstraintTeacherMinMorningsPerWeek* crt_constraint=(ConstraintTeacherMinMorningsPerWeek*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_AFTERNOONS_PER_WEEK:
				{
					ConstraintTeacherMinAfternoonsPerWeek* crt_constraint=(ConstraintTeacherMinAfternoonsPerWeek*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}

			case CONSTRAINT_TEACHER_MORNING_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeacherMorningIntervalMaxDaysPerWeek* crt_constraint=(ConstraintTeacherMorningIntervalMaxDaysPerWeek*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_AFTERNOON_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeacherAfternoonIntervalMaxDaysPerWeek* crt_constraint=(ConstraintTeacherAfternoonIntervalMaxDaysPerWeek*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}

			case CONSTRAINT_TEACHER_MAX_SPAN_PER_REAL_DAY:
				{
					ConstraintTeacherMaxSpanPerRealDay* crt_constraint=(ConstraintTeacherMaxSpanPerRealDay*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_RESTING_HOURS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeacherMinRestingHoursBetweenMorningAndAfternoon* crt_constraint=(ConstraintTeacherMinRestingHoursBetweenMorningAndAfternoon*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}

			case CONSTRAINT_TEACHER_MAX_HOURS_DAILY_IN_INTERVAL:
				{
					ConstraintTeacherMaxHoursDailyInInterval* crt_constraint=(ConstraintTeacherMaxHoursDailyInInterval*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}

			case CONSTRAINT_TEACHER_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
				{
					ConstraintTeacherPairOfMutuallyExclusiveTimeSlots* crt_constraint=(ConstraintTeacherPairOfMutuallyExclusiveTimeSlots*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}

			case CONSTRAINT_TEACHER_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
				{
					ConstraintTeacherPairOfMutuallyExclusiveSetsOfTimeSlots* crt_constraint=(ConstraintTeacherPairOfMutuallyExclusiveSetsOfTimeSlots*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}

			case CONSTRAINT_TEACHER_OCCUPIES_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintTeacherOccupiesMaxSetsOfTimeSlotsFromSelection* crt_constraint=(ConstraintTeacherOccupiesMaxSetsOfTimeSlotsFromSelection*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}

			case CONSTRAINT_TEACHER_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintTeacherMaxSingleGapsInSelectedTimeSlots* crt_constraint=(ConstraintTeacherMaxSingleGapsInSelectedTimeSlots*)ctr;
					if(initialTeacherName == crt_constraint->teacher)
						crt_constraint->teacher=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_HOURS_PER_TERM:
				{
					ConstraintTeacherMaxHoursPerTerm* crt_constraint=(ConstraintTeacherMaxHoursPerTerm*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}

			default:
				//do nothing.
				break;
		}
	}
	
	for(SpaceConstraint* ctr : std::as_const(spaceConstraintsList)){
		switch(ctr->type){
			case CONSTRAINT_TEACHER_ROOM_NOT_AVAILABLE_TIMES:
				{
					ConstraintTeacherRoomNotAvailableTimes* crt_constraint=(ConstraintTeacherRoomNotAvailableTimes*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_HOME_ROOM:
				{
					ConstraintTeacherHomeRoom* crt_constraint=(ConstraintTeacherHomeRoom*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_HOME_ROOMS:
				{
					ConstraintTeacherHomeRooms* crt_constraint=(ConstraintTeacherHomeRooms*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_DAY:
				{
					ConstraintTeacherMaxBuildingChangesPerDay* crt_constraint=(ConstraintTeacherMaxBuildingChangesPerDay*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_WEEK:
				{
					ConstraintTeacherMaxBuildingChangesPerWeek* crt_constraint=(ConstraintTeacherMaxBuildingChangesPerWeek*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_BUILDING_CHANGES:
				{
					ConstraintTeacherMinGapsBetweenBuildingChanges* crt_constraint=(ConstraintTeacherMinGapsBetweenBuildingChanges*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_DAY:
				{
					ConstraintTeacherMaxRoomChangesPerDay* crt_constraint=(ConstraintTeacherMaxRoomChangesPerDay*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_WEEK:
				{
					ConstraintTeacherMaxRoomChangesPerWeek* crt_constraint=(ConstraintTeacherMaxRoomChangesPerWeek*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ROOM_CHANGES:
				{
					ConstraintTeacherMinGapsBetweenRoomChanges* crt_constraint=(ConstraintTeacherMinGapsBetweenRoomChanges*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}

			//mornings-afternoons
			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_REAL_DAY:
				{
					ConstraintTeacherMaxRoomChangesPerRealDay* crt_constraint=(ConstraintTeacherMaxRoomChangesPerRealDay*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_REAL_DAY:
				{
					ConstraintTeacherMaxBuildingChangesPerRealDay* crt_constraint=(ConstraintTeacherMaxBuildingChangesPerRealDay*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}

			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintTeacherMaxBuildingChangesPerDayInInterval* crt_constraint=(ConstraintTeacherMaxBuildingChangesPerDayInInterval*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintTeacherMaxBuildingChangesPerRealDayInInterval* crt_constraint=(ConstraintTeacherMaxBuildingChangesPerRealDayInInterval*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}

			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintTeacherMaxRoomChangesPerDayInInterval* crt_constraint=(ConstraintTeacherMaxRoomChangesPerDayInInterval*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}
			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintTeacherMaxRoomChangesPerRealDayInInterval* crt_constraint=(ConstraintTeacherMaxRoomChangesPerRealDayInInterval*)ctr;
					if(initialTeacherName == crt_constraint->teacherName)
						crt_constraint->teacherName=finalTeacherName;
					break;
				}

			default:
				//do nothing.
				break;
		}
	}
	
	int t=0;
	for(int i=0; i<this->teachersList.size(); i++){
		Teacher* tch=this->teachersList[i];

		if(tch->name==initialTeacherName){
			tch->name=finalTeacherName;
			t++;
		}
	}
	assert(t==1);
	
	if(tnatHash.contains(initialTeacherName)){
		QSet<ConstraintTeacherNotAvailableTimes*> cs=tnatHash.value(initialTeacherName);
		tnatHash.remove(initialTeacherName);
		assert(!tnatHash.contains(finalTeacherName));
		tnatHash.insert(finalTeacherName, cs);
	}

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

void Rules::sortTeachersAlphabetically()
{
	std::stable_sort(this->teachersList.begin(), this->teachersList.end(), teachersAscending);

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
}

bool Rules::addSubject(Subject* subject)
{
	for(int i=0; i<this->subjectsList.size(); i++){
		Subject* sbj=this->subjectsList[i];
		if(sbj->name==subject->name)
			return false;
	}
	
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	this->subjectsList << subject;
	return true;
}

bool Rules::addSubjectFast(Subject* subject)
{
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	this->subjectsList << subject;
	return true;
}

int Rules::searchSubject(const QString& subjectName)
{
	for(int i=0; i<this->subjectsList.size(); i++)
		if(this->subjectsList.at(i)->name == subjectName)
			return i;

	return -1;
}

bool Rules::removeSubject(const QString& subjectName)
{
	//check the qualified subjects for teachers
	for(Teacher* tch : std::as_const(teachersList)){
		if(tch->qualifiedSubjectsHash.contains(subjectName)){
			std::list<QString>::iterator it=tch->qualifiedSubjectsHash.value(subjectName);
			assert((*it)==subjectName);
			
			tch->qualifiedSubjectsList.erase(it);
			
			tch->qualifiedSubjectsHash.remove(subjectName);
		}
	}

	QList<int> idsToBeRemoved;
	for(Activity* act : std::as_const(activitiesList)){
		if(act->subjectName==subjectName)
			idsToBeRemoved.append(act->id);
	}
	removeActivities(idsToBeRemoved, false);

	//remove the subject from the list
	for(int i=0; i<this->subjectsList.size(); i++)
		if(this->subjectsList[i]->name==subjectName){
			Subject* sbj=this->subjectsList[i];
			this->subjectsList.removeAt(i);
			delete sbj;
			break;
		}
	
	updateConstraintsAfterRemoval();

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

bool Rules::modifySubject(const QString& initialSubjectName, const QString& finalSubjectName)
{
	assert(this->searchSubject(finalSubjectName)==-1);
	assert(this->searchSubject(initialSubjectName)>=0);

	//check the qualified subjects for teachers
	for(Teacher* tch : std::as_const(teachersList)){
		if(tch->qualifiedSubjectsHash.contains(initialSubjectName)){
			std::list<QString>::iterator it=tch->qualifiedSubjectsHash.value(initialSubjectName);
			assert((*it)==initialSubjectName);
			
			(*it)=finalSubjectName;
			
			tch->qualifiedSubjectsHash.remove(initialSubjectName);
			tch->qualifiedSubjectsHash.insert(finalSubjectName, it);
		}
	}

	//check the activities
	for(int i=0; i<this->activitiesList.size(); i++){
		Activity* act=this->activitiesList[i];

		if( act->subjectName == initialSubjectName)
			act->subjectName=finalSubjectName;
	}
	
	//modify the time constraints related to this subject
	for(TimeConstraint* ctr : std::as_const(timeConstraintsList)){
		switch(ctr->type){
			case CONSTRAINT_ACTIVITIES_PREFERRED_TIME_SLOTS:
				{
					ConstraintActivitiesPreferredTimeSlots* crt_constraint=(ConstraintActivitiesPreferredTimeSlots*)ctr;
					if(initialSubjectName == crt_constraint->p_subjectName)
						crt_constraint->p_subjectName=finalSubjectName;
					break;
				}
			case CONSTRAINT_ACTIVITIES_PREFERRED_STARTING_TIMES:
				{
					ConstraintActivitiesPreferredStartingTimes* crt_constraint=(ConstraintActivitiesPreferredStartingTimes*)ctr;
					if(initialSubjectName == crt_constraint->subjectName)
						crt_constraint->subjectName=finalSubjectName;
					break;
				}
			case CONSTRAINT_ACTIVITIES_END_STUDENTS_DAY:
				{
					ConstraintActivitiesEndStudentsDay* crt_constraint=(ConstraintActivitiesEndStudentsDay*)ctr;
					if(initialSubjectName == crt_constraint->subjectName)
						crt_constraint->subjectName=finalSubjectName;
					break;
				}
			case CONSTRAINT_ACTIVITIES_END_TEACHERS_DAY:
				{
					ConstraintActivitiesEndTeachersDay* crt_constraint=(ConstraintActivitiesEndTeachersDay*)ctr;
					if(initialSubjectName == crt_constraint->subjectName)
						crt_constraint->subjectName=finalSubjectName;
					break;
				}

			case CONSTRAINT_ACTIVITIES_BEGIN_STUDENTS_DAY:
				{
					ConstraintActivitiesBeginStudentsDay* crt_constraint=(ConstraintActivitiesBeginStudentsDay*)ctr;
					if(initialSubjectName == crt_constraint->subjectName)
						crt_constraint->subjectName=finalSubjectName;
					break;
				}
			case CONSTRAINT_ACTIVITIES_BEGIN_TEACHERS_DAY:
				{
					ConstraintActivitiesBeginTeachersDay* crt_constraint=(ConstraintActivitiesBeginTeachersDay*)ctr;
					if(initialSubjectName == crt_constraint->subjectName)
						crt_constraint->subjectName=finalSubjectName;
					break;
				}

			case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_STUDENTS_DAY:
				{
					ConstraintActivitiesBeginOrEndStudentsDay* crt_constraint=(ConstraintActivitiesBeginOrEndStudentsDay*)ctr;
					if(initialSubjectName == crt_constraint->subjectName)
						crt_constraint->subjectName=finalSubjectName;
					break;
				}
			case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_TEACHERS_DAY:
				{
					ConstraintActivitiesBeginOrEndTeachersDay* crt_constraint=(ConstraintActivitiesBeginOrEndTeachersDay*)ctr;
					if(initialSubjectName == crt_constraint->subjectName)
						crt_constraint->subjectName=finalSubjectName;
					break;
				}

			case CONSTRAINT_SUBACTIVITIES_PREFERRED_TIME_SLOTS:
				{
					ConstraintSubactivitiesPreferredTimeSlots* crt_constraint=(ConstraintSubactivitiesPreferredTimeSlots*)ctr;
					if(initialSubjectName == crt_constraint->p_subjectName)
						crt_constraint->p_subjectName=finalSubjectName;
					break;
				}
			case CONSTRAINT_SUBACTIVITIES_PREFERRED_STARTING_TIMES:
				{
					ConstraintSubactivitiesPreferredStartingTimes* crt_constraint=(ConstraintSubactivitiesPreferredStartingTimes*)ctr;
					if(initialSubjectName == crt_constraint->subjectName)
						crt_constraint->subjectName=finalSubjectName;
					break;
				}
			default:
				//do nothing.
				break;
		}
	}
	
	//modify the space constraints related to this subject
	for(SpaceConstraint* ctr : std::as_const(spaceConstraintsList)){
		switch(ctr->type){
			case CONSTRAINT_SUBJECT_PREFERRED_ROOM:
				{
					ConstraintSubjectPreferredRoom* c=(ConstraintSubjectPreferredRoom*)ctr;
					if(c->subjectName == initialSubjectName)
						c->subjectName=finalSubjectName;
					break;
				}
			case CONSTRAINT_SUBJECT_PREFERRED_ROOMS:
				{
					ConstraintSubjectPreferredRooms* c=(ConstraintSubjectPreferredRooms*)ctr;
					if(c->subjectName == initialSubjectName)
						c->subjectName=finalSubjectName;
					break;
				}
			case CONSTRAINT_SUBJECT_ACTIVITY_TAG_PREFERRED_ROOM:
				{
					ConstraintSubjectActivityTagPreferredRoom* c=(ConstraintSubjectActivityTagPreferredRoom*)ctr;
					if(c->subjectName == initialSubjectName)
						c->subjectName=finalSubjectName;
					break;
				}
			case CONSTRAINT_SUBJECT_ACTIVITY_TAG_PREFERRED_ROOMS:
				{
					ConstraintSubjectActivityTagPreferredRooms* c=(ConstraintSubjectActivityTagPreferredRooms*)ctr;
					if(c->subjectName == initialSubjectName)
						c->subjectName=finalSubjectName;
					break;
				}
			default:
				//do nothing.
				break;
		}
	}

	//rename the subject in the list
	int t=0;
	for(int i=0; i<this->subjectsList.size(); i++){
		Subject* sbj=this->subjectsList[i];

		if(sbj->name==initialSubjectName){
			t++;
			sbj->name=finalSubjectName;
		}
	}
	assert(t==1);

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

void Rules::sortSubjectsAlphabetically()
{
	std::stable_sort(this->subjectsList.begin(), this->subjectsList.end(), subjectsAscending);

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
}

bool Rules::addActivityTag(ActivityTag* activityTag)
{
	for(int i=0; i<this->activityTagsList.size(); i++){
		ActivityTag* sbt=this->activityTagsList[i];

		if(sbt->name==activityTag->name)
			return false;
	}

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	this->activityTagsList << activityTag;
	return true;
}

bool Rules::addActivityTagFast(ActivityTag* activityTag)
{
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	this->activityTagsList << activityTag;
	return true;
}

int Rules::searchActivityTag(const QString& activityTagName)
{
	for(int i=0; i<this->activityTagsList.size(); i++)
		if(this->activityTagsList.at(i)->name==activityTagName)
			return i;

	return -1;
}

bool Rules::removeActivityTag(const QString& activityTagName)
{
	for(Activity* act : std::as_const(activitiesList))
		if(act->activityTagsNames.contains(activityTagName))
			act->activityTagsNames.removeAll(activityTagName);

	//remove the activity tag from the list
	for(int i=0; i<this->activityTagsList.size(); i++)
		if(this->activityTagsList[i]->name==activityTagName){
			ActivityTag* sbt=this->activityTagsList[i];
			this->activityTagsList.removeAt(i);
			delete sbt;
			break;
		}
	
	updateConstraintsAfterRemoval();

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

bool Rules::modifyActivityTag(const QString& initialActivityTagName, const QString& finalActivityTagName)
{
	assert(this->searchActivityTag(finalActivityTagName)==-1);
	assert(this->searchActivityTag(initialActivityTagName)>=0);

	//check the activities first
	for(int i=0; i<this->activitiesList.size(); i++){
		Activity* act=this->activitiesList[i];

		for(int kk=0; kk<act->activityTagsNames.count(); kk++)
			if(act->activityTagsNames.at(kk)==initialActivityTagName)
				act->activityTagsNames[kk]=finalActivityTagName;
	}
	
	//modify the time constraints related to this activity tag
	for(TimeConstraint* ctr : std::as_const(timeConstraintsList)){
		switch(ctr->type){
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintTeacherActivityTagMaxHoursContinuously* crt_constraint=(ConstraintTeacherActivityTagMaxHoursContinuously*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_DAILY:
				{
					ConstraintTeacherActivityTagMaxHoursDaily* crt_constraint=(ConstraintTeacherActivityTagMaxHoursDaily*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MIN_HOURS_DAILY:
				{
					ConstraintTeacherActivityTagMinHoursDaily* crt_constraint=(ConstraintTeacherActivityTagMinHoursDaily*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
				{
					ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTags* crt_constraint=(ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTags*)ctr;
					if(initialActivityTagName == crt_constraint->firstActivityTag)
						crt_constraint->firstActivityTag=finalActivityTagName;
					if(initialActivityTagName == crt_constraint->secondActivityTag)
						crt_constraint->secondActivityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
				{
					ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTags* crt_constraint=(ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTags*)ctr;
					if(initialActivityTagName == crt_constraint->firstActivityTag)
						crt_constraint->firstActivityTag=finalActivityTagName;
					if(initialActivityTagName == crt_constraint->secondActivityTag)
						crt_constraint->secondActivityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
				{
					ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTags* crt_constraint=(ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTags*)ctr;
					if(initialActivityTagName == crt_constraint->firstActivityTag)
						crt_constraint->firstActivityTag=finalActivityTagName;
					if(initialActivityTagName == crt_constraint->secondActivityTag)
						crt_constraint->secondActivityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
				{
					ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTags* crt_constraint=(ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTags*)ctr;
					if(initialActivityTagName == crt_constraint->firstActivityTag)
						crt_constraint->firstActivityTag=finalActivityTagName;
					if(initialActivityTagName == crt_constraint->secondActivityTag)
						crt_constraint->secondActivityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
				{
					ConstraintStudentsSetMinGapsBetweenActivityTag* crt_constraint=(ConstraintStudentsSetMinGapsBetweenActivityTag*)ctr;
					if(initialActivityTagName == crt_constraint->activityTag)
						crt_constraint->activityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
				{
					ConstraintStudentsMinGapsBetweenActivityTag* crt_constraint=(ConstraintStudentsMinGapsBetweenActivityTag*)ctr;
					if(initialActivityTagName == crt_constraint->activityTag)
						crt_constraint->activityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
				{
					ConstraintTeacherMinGapsBetweenActivityTag* crt_constraint=(ConstraintTeacherMinGapsBetweenActivityTag*)ctr;
					if(initialActivityTagName == crt_constraint->activityTag)
						crt_constraint->activityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
				{
					ConstraintTeachersMinGapsBetweenActivityTag* crt_constraint=(ConstraintTeachersMinGapsBetweenActivityTag*)ctr;
					if(initialActivityTagName == crt_constraint->activityTag)
						crt_constraint->activityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
				{
					ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* crt_constraint=(ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay*)ctr;
					if(initialActivityTagName == crt_constraint->firstActivityTag)
						crt_constraint->firstActivityTag=finalActivityTagName;
					if(initialActivityTagName == crt_constraint->secondActivityTag)
						crt_constraint->secondActivityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
				{
					ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* crt_constraint=(ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsPerRealDay*)ctr;
					if(initialActivityTagName == crt_constraint->firstActivityTag)
						crt_constraint->firstActivityTag=finalActivityTagName;
					if(initialActivityTagName == crt_constraint->secondActivityTag)
						crt_constraint->secondActivityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
				{
					ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* crt_constraint=(ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsPerRealDay*)ctr;
					if(initialActivityTagName == crt_constraint->firstActivityTag)
						crt_constraint->firstActivityTag=finalActivityTagName;
					if(initialActivityTagName == crt_constraint->secondActivityTag)
						crt_constraint->secondActivityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
				{
					ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* crt_constraint=(ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsPerRealDay*)ctr;
					if(initialActivityTagName == crt_constraint->firstActivityTag)
						crt_constraint->firstActivityTag=finalActivityTagName;
					if(initialActivityTagName == crt_constraint->secondActivityTag)
						crt_constraint->secondActivityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
				{
					ConstraintStudentsSetMinGapsBetweenActivityTagPerRealDay* crt_constraint=(ConstraintStudentsSetMinGapsBetweenActivityTagPerRealDay*)ctr;
					if(initialActivityTagName == crt_constraint->activityTag)
						crt_constraint->activityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
				{
					ConstraintStudentsMinGapsBetweenActivityTagPerRealDay* crt_constraint=(ConstraintStudentsMinGapsBetweenActivityTagPerRealDay*)ctr;
					if(initialActivityTagName == crt_constraint->activityTag)
						crt_constraint->activityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
				{
					ConstraintTeacherMinGapsBetweenActivityTagPerRealDay* crt_constraint=(ConstraintTeacherMinGapsBetweenActivityTagPerRealDay*)ctr;
					if(initialActivityTagName == crt_constraint->activityTag)
						crt_constraint->activityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
				{
					ConstraintTeachersMinGapsBetweenActivityTagPerRealDay* crt_constraint=(ConstraintTeachersMinGapsBetweenActivityTagPerRealDay*)ctr;
					if(initialActivityTagName == crt_constraint->activityTag)
						crt_constraint->activityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* crt_constraint=(ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon*)ctr;
					if(initialActivityTagName == crt_constraint->firstActivityTag)
						crt_constraint->firstActivityTag=finalActivityTagName;
					if(initialActivityTagName == crt_constraint->secondActivityTag)
						crt_constraint->secondActivityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* crt_constraint=(ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon*)ctr;
					if(initialActivityTagName == crt_constraint->firstActivityTag)
						crt_constraint->firstActivityTag=finalActivityTagName;
					if(initialActivityTagName == crt_constraint->secondActivityTag)
						crt_constraint->secondActivityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* crt_constraint=(ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon*)ctr;
					if(initialActivityTagName == crt_constraint->firstActivityTag)
						crt_constraint->firstActivityTag=finalActivityTagName;
					if(initialActivityTagName == crt_constraint->secondActivityTag)
						crt_constraint->secondActivityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* crt_constraint=(ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon*)ctr;
					if(initialActivityTagName == crt_constraint->firstActivityTag)
						crt_constraint->firstActivityTag=finalActivityTagName;
					if(initialActivityTagName == crt_constraint->secondActivityTag)
						crt_constraint->secondActivityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon* crt_constraint=(ConstraintStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon*)ctr;
					if(initialActivityTagName == crt_constraint->activityTag)
						crt_constraint->activityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsMinGapsBetweenActivityTagBetweenMorningAndAfternoon* crt_constraint=(ConstraintStudentsMinGapsBetweenActivityTagBetweenMorningAndAfternoon*)ctr;
					if(initialActivityTagName == crt_constraint->activityTag)
						crt_constraint->activityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeacherMinGapsBetweenActivityTagBetweenMorningAndAfternoon* crt_constraint=(ConstraintTeacherMinGapsBetweenActivityTagBetweenMorningAndAfternoon*)ctr;
					if(initialActivityTagName == crt_constraint->activityTag)
						crt_constraint->activityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeachersMinGapsBetweenActivityTagBetweenMorningAndAfternoon* crt_constraint=(ConstraintTeachersMinGapsBetweenActivityTagBetweenMorningAndAfternoon*)ctr;
					if(initialActivityTagName == crt_constraint->activityTag)
						crt_constraint->activityTag=finalActivityTagName;
					break;
				}
			case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintTeachersActivityTagMaxHoursContinuously* crt_constraint=(ConstraintTeachersActivityTagMaxHoursContinuously*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_DAILY:
				{
					ConstraintTeachersActivityTagMaxHoursDaily* crt_constraint=(ConstraintTeachersActivityTagMaxHoursDaily*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MIN_HOURS_DAILY:
				{
					ConstraintTeachersActivityTagMinHoursDaily* crt_constraint=(ConstraintTeachersActivityTagMinHoursDaily*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintStudentsActivityTagMaxHoursContinuously* crt_constraint=(ConstraintStudentsActivityTagMaxHoursContinuously*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_DAILY:
				{
					ConstraintStudentsActivityTagMaxHoursDaily* crt_constraint=(ConstraintStudentsActivityTagMaxHoursDaily*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MIN_HOURS_DAILY:
				{
					ConstraintStudentsActivityTagMinHoursDaily* crt_constraint=(ConstraintStudentsActivityTagMinHoursDaily*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintStudentsSetActivityTagMaxHoursContinuously* crt_constraint=(ConstraintStudentsSetActivityTagMaxHoursContinuously*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY:
				{
					ConstraintStudentsSetActivityTagMaxHoursDaily* crt_constraint=(ConstraintStudentsSetActivityTagMaxHoursDaily*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MIN_HOURS_DAILY:
				{
					ConstraintStudentsSetActivityTagMinHoursDaily* crt_constraint=(ConstraintStudentsSetActivityTagMinHoursDaily*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_ACTIVITIES_PREFERRED_TIME_SLOTS:
				{
					ConstraintActivitiesPreferredTimeSlots* crt_constraint=(ConstraintActivitiesPreferredTimeSlots*)ctr;
					if(initialActivityTagName == crt_constraint->p_activityTagName)
						crt_constraint->p_activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_ACTIVITIES_PREFERRED_STARTING_TIMES:
				{
					ConstraintActivitiesPreferredStartingTimes* crt_constraint=(ConstraintActivitiesPreferredStartingTimes*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_ACTIVITIES_END_STUDENTS_DAY:
				{
					ConstraintActivitiesEndStudentsDay* crt_constraint=(ConstraintActivitiesEndStudentsDay*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_ACTIVITIES_END_TEACHERS_DAY:
				{
					ConstraintActivitiesEndTeachersDay* crt_constraint=(ConstraintActivitiesEndTeachersDay*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}

			case CONSTRAINT_ACTIVITIES_BEGIN_STUDENTS_DAY:
				{
					ConstraintActivitiesBeginStudentsDay* crt_constraint=(ConstraintActivitiesBeginStudentsDay*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_ACTIVITIES_BEGIN_TEACHERS_DAY:
				{
					ConstraintActivitiesBeginTeachersDay* crt_constraint=(ConstraintActivitiesBeginTeachersDay*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}

			case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_STUDENTS_DAY:
				{
					ConstraintActivitiesBeginOrEndStudentsDay* crt_constraint=(ConstraintActivitiesBeginOrEndStudentsDay*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_TEACHERS_DAY:
				{
					ConstraintActivitiesBeginOrEndTeachersDay* crt_constraint=(ConstraintActivitiesBeginOrEndTeachersDay*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}

			case CONSTRAINT_SUBACTIVITIES_PREFERRED_TIME_SLOTS:
				{
					ConstraintSubactivitiesPreferredTimeSlots* crt_constraint=(ConstraintSubactivitiesPreferredTimeSlots*)ctr;
					if(initialActivityTagName == crt_constraint->p_activityTagName)
						crt_constraint->p_activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_SUBACTIVITIES_PREFERRED_STARTING_TIMES:
				{
					ConstraintSubactivitiesPreferredStartingTimes* crt_constraint=(ConstraintSubactivitiesPreferredStartingTimes*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_ACTIVITY_TAGS_NOT_OVERLAPPING:
				{
					ConstraintActivityTagsNotOverlapping* crt_constraint=(ConstraintActivityTagsNotOverlapping*)ctr;
					int cnt=0;
					for(int i=0; i<crt_constraint->activityTagsNames.count(); i++){
						if(crt_constraint->activityTagsNames.at(i)==initialActivityTagName){
							crt_constraint->activityTagsNames[i]=finalActivityTagName;
							cnt++;
						}
					}
					assert(cnt<=1);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintTeacherMaxActivityTagsPerDayFromSet* crt_constraint=(ConstraintTeacherMaxActivityTagsPerDayFromSet*)ctr;
					int cnt=0;
					for(int i=0; i<crt_constraint->tagsList.count(); i++){
						if(crt_constraint->tagsList.at(i)==initialActivityTagName){
							crt_constraint->tagsList[i]=finalActivityTagName;
							cnt++;
						}
					}
					assert(cnt<=1);
					break;
				}
			case CONSTRAINT_TEACHERS_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintTeachersMaxActivityTagsPerDayFromSet* crt_constraint=(ConstraintTeachersMaxActivityTagsPerDayFromSet*)ctr;
					int cnt=0;
					for(int i=0; i<crt_constraint->tagsList.count(); i++){
						if(crt_constraint->tagsList.at(i)==initialActivityTagName){
							crt_constraint->tagsList[i]=finalActivityTagName;
							cnt++;
						}
					}
					assert(cnt<=1);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintStudentsSetMaxActivityTagsPerDayFromSet* crt_constraint=(ConstraintStudentsSetMaxActivityTagsPerDayFromSet*)ctr;
					int cnt=0;
					for(int i=0; i<crt_constraint->tagsList.count(); i++){
						if(crt_constraint->tagsList.at(i)==initialActivityTagName){
							crt_constraint->tagsList[i]=finalActivityTagName;
							cnt++;
						}
					}
					assert(cnt<=1);
					break;
				}
			case CONSTRAINT_STUDENTS_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintStudentsMaxActivityTagsPerDayFromSet* crt_constraint=(ConstraintStudentsMaxActivityTagsPerDayFromSet*)ctr;
					int cnt=0;
					for(int i=0; i<crt_constraint->tagsList.count(); i++){
						if(crt_constraint->tagsList.at(i)==initialActivityTagName){
							crt_constraint->tagsList[i]=finalActivityTagName;
							cnt++;
						}
					}
					assert(cnt<=1);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintTeacherMaxActivityTagsPerRealDayFromSet* crt_constraint=(ConstraintTeacherMaxActivityTagsPerRealDayFromSet*)ctr;
					int cnt=0;
					for(int i=0; i<crt_constraint->tagsList.count(); i++){
						if(crt_constraint->tagsList.at(i)==initialActivityTagName){
							crt_constraint->tagsList[i]=finalActivityTagName;
							cnt++;
						}
					}
					assert(cnt<=1);
					break;
				}
			case CONSTRAINT_TEACHERS_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintTeachersMaxActivityTagsPerRealDayFromSet* crt_constraint=(ConstraintTeachersMaxActivityTagsPerRealDayFromSet*)ctr;
					int cnt=0;
					for(int i=0; i<crt_constraint->tagsList.count(); i++){
						if(crt_constraint->tagsList.at(i)==initialActivityTagName){
							crt_constraint->tagsList[i]=finalActivityTagName;
							cnt++;
						}
					}
					assert(cnt<=1);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintStudentsSetMaxActivityTagsPerRealDayFromSet* crt_constraint=(ConstraintStudentsSetMaxActivityTagsPerRealDayFromSet*)ctr;
					int cnt=0;
					for(int i=0; i<crt_constraint->tagsList.count(); i++){
						if(crt_constraint->tagsList.at(i)==initialActivityTagName){
							crt_constraint->tagsList[i]=finalActivityTagName;
							cnt++;
						}
					}
					assert(cnt<=1);
					break;
				}
			case CONSTRAINT_STUDENTS_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintStudentsMaxActivityTagsPerRealDayFromSet* crt_constraint=(ConstraintStudentsMaxActivityTagsPerRealDayFromSet*)ctr;
					int cnt=0;
					for(int i=0; i<crt_constraint->tagsList.count(); i++){
						if(crt_constraint->tagsList.at(i)==initialActivityTagName){
							crt_constraint->tagsList[i]=finalActivityTagName;
							cnt++;
						}
					}
					assert(cnt<=1);
					break;
				}
			//mornings-afternoons
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeacherActivityTagMaxHoursDailyRealDays* crt_constraint=(ConstraintTeacherActivityTagMaxHoursDailyRealDays*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeachersActivityTagMaxHoursDailyRealDays* crt_constraint=(ConstraintTeachersActivityTagMaxHoursDailyRealDays*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintStudentsActivityTagMaxHoursDailyRealDays* crt_constraint=(ConstraintStudentsActivityTagMaxHoursDailyRealDays*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintStudentsSetActivityTagMaxHoursDailyRealDays* crt_constraint=(ConstraintStudentsSetActivityTagMaxHoursDailyRealDays*)ctr;
					if(initialActivityTagName == crt_constraint->activityTagName)
						crt_constraint->activityTagName=finalActivityTagName;
					break;
				}
			default:
				//do nothing.
				break;
		}
	}

	//modify the space constraints related to this activity tag
	for(SpaceConstraint* ctr : std::as_const(spaceConstraintsList)){
		switch(ctr->type){
			case CONSTRAINT_SUBJECT_ACTIVITY_TAG_PREFERRED_ROOM:
				{
					ConstraintSubjectActivityTagPreferredRoom* c=(ConstraintSubjectActivityTagPreferredRoom*)ctr;
					if(c->activityTagName == initialActivityTagName)
						c->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_SUBJECT_ACTIVITY_TAG_PREFERRED_ROOMS:
				{
					ConstraintSubjectActivityTagPreferredRooms* c=(ConstraintSubjectActivityTagPreferredRooms*)ctr;
					if(c->activityTagName == initialActivityTagName)
						c->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_ACTIVITY_TAG_PREFERRED_ROOM:
				{
					ConstraintActivityTagPreferredRoom* c=(ConstraintActivityTagPreferredRoom*)ctr;
					if(c->activityTagName == initialActivityTagName)
						c->activityTagName=finalActivityTagName;
					break;
				}
			case CONSTRAINT_ACTIVITY_TAG_PREFERRED_ROOMS:
				{
					ConstraintActivityTagPreferredRooms* c=(ConstraintActivityTagPreferredRooms*)ctr;
					if(c->activityTagName == initialActivityTagName)
						c->activityTagName=finalActivityTagName;
					break;
				}
			default:
				//do nothing.
				break;
		}
	}

	//rename the activity tag in the list
	int t=0;
	
	for(int i=0; i<this->activityTagsList.size(); i++){
		ActivityTag* sbt=this->activityTagsList[i];

		if(sbt->name==initialActivityTagName){
			t++;
			sbt->name=finalActivityTagName;
		}
	}
	
	assert(t==1);

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

void Rules::sortActivityTagsAlphabetically()
{
	std::stable_sort(this->activityTagsList.begin(), this->activityTagsList.end(), activityTagsAscending);

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
}

bool Rules::setsShareStudents(const QString& studentsSet1, const QString& studentsSet2)
{
	StudentsSet* s1=this->searchStudentsSet(studentsSet1);
	StudentsSet* s2=this->searchStudentsSet(studentsSet2);
	assert(s1!=nullptr);
	assert(s2!=nullptr);
	
	QSet<QString> downwardSets1;
	
	if(s1->type==STUDENTS_YEAR){
		StudentsYear* year1=(StudentsYear*)s1;
		downwardSets1.insert(year1->name);
		for(StudentsGroup* group1 : std::as_const(year1->groupsList)){
			downwardSets1.insert(group1->name);
			for(StudentsSubgroup* subgroup1 : std::as_const(group1->subgroupsList))
				downwardSets1.insert(subgroup1->name);
		}
	}
	else if(s1->type==STUDENTS_GROUP){
		StudentsGroup* group1=(StudentsGroup*)s1;
		downwardSets1.insert(group1->name);
		for(StudentsSubgroup* subgroup1 : std::as_const(group1->subgroupsList))
			downwardSets1.insert(subgroup1->name);
	}
	else if(s1->type==STUDENTS_SUBGROUP){
		StudentsSubgroup* subgroup1=(StudentsSubgroup*)s1;
		downwardSets1.insert(subgroup1->name);
	}
	else
		assert(0);
		
	if(s2->type==STUDENTS_YEAR){
		StudentsYear* year2=(StudentsYear*)s2;
		if(downwardSets1.contains(year2->name))
			return true;
		for(StudentsGroup* group2 : std::as_const(year2->groupsList)){
			if(downwardSets1.contains(group2->name))
				return true;
			for(StudentsSubgroup* subgroup2 : std::as_const(group2->subgroupsList))
				if(downwardSets1.contains(subgroup2->name))
					return true;
		}
	}
	else if(s2->type==STUDENTS_GROUP){
		StudentsGroup* group2=(StudentsGroup*)s2;
		if(downwardSets1.contains(group2->name))
			return true;
		for(StudentsSubgroup* subgroup2 : std::as_const(group2->subgroupsList))
			if(downwardSets1.contains(subgroup2->name))
				return true;
	}
	else if(s2->type==STUDENTS_SUBGROUP){
		StudentsSubgroup* subgroup2=(StudentsSubgroup*)s2;
		if(downwardSets1.contains(subgroup2->name))
			return true;
	}
	else
		assert(0);
	
	return false;
}

bool Rules::augmentedSetsShareStudentsFaster(const QString& studentsSet1, const QString& studentsSet2)
{
	//StudentsSet* s1=this->searchStudentsSet(studentsSet1);
	StudentsSet* s1=studentsHash.value(studentsSet1, nullptr);
	//StudentsSet* s2=this->searchStudentsSet(studentsSet2);
	StudentsSet* s2=studentsHash.value(studentsSet2, nullptr);
	assert(s1!=nullptr);
	assert(s2!=nullptr);
	
	QSet<QString> downwardSets1;
	
	if(s1->type==STUDENTS_YEAR){
		StudentsYear* year1=(StudentsYear*)s1;
		downwardSets1.insert(year1->name);
		for(StudentsGroup* group1 : std::as_const(year1->groupsList)){
			downwardSets1.insert(group1->name);
			for(StudentsSubgroup* subgroup1 : std::as_const(group1->subgroupsList))
				downwardSets1.insert(subgroup1->name);
		}
	}
	else if(s1->type==STUDENTS_GROUP){
		StudentsGroup* group1=(StudentsGroup*)s1;
		downwardSets1.insert(group1->name);
		for(StudentsSubgroup* subgroup1 : std::as_const(group1->subgroupsList))
			downwardSets1.insert(subgroup1->name);
	}
	else if(s1->type==STUDENTS_SUBGROUP){
		StudentsSubgroup* subgroup1=(StudentsSubgroup*)s1;
		downwardSets1.insert(subgroup1->name);
	}
	else
		assert(0);
		
	if(s2->type==STUDENTS_YEAR){
		StudentsYear* year2=(StudentsYear*)s2;
		if(downwardSets1.contains(year2->name))
			return true;
		for(StudentsGroup* group2 : std::as_const(year2->groupsList)){
			if(downwardSets1.contains(group2->name))
				return true;
			for(StudentsSubgroup* subgroup2 : std::as_const(group2->subgroupsList))
				if(downwardSets1.contains(subgroup2->name))
					return true;
		}
	}
	else if(s2->type==STUDENTS_GROUP){
		StudentsGroup* group2=(StudentsGroup*)s2;
		if(downwardSets1.contains(group2->name))
			return true;
		for(StudentsSubgroup* subgroup2 : std::as_const(group2->subgroupsList))
			if(downwardSets1.contains(subgroup2->name))
				return true;
	}
	else if(s2->type==STUDENTS_SUBGROUP){
		StudentsSubgroup* subgroup2=(StudentsSubgroup*)s2;
		if(downwardSets1.contains(subgroup2->name))
			return true;
	}
	else
		assert(0);
	
	return false;
}

void Rules::computePermanentStudentsHash()
{
	//The commented tests are good, but can lead to a small slowdown.
	permanentStudentsHash.clear();
	
	for(StudentsYear* year : std::as_const(yearsList)){
		assert(!permanentStudentsHash.contains(year->name));
		permanentStudentsHash.insert(year->name, year);
		
		//QSet<QString> groupsInYear;
		
		for(StudentsGroup* group : std::as_const(year->groupsList)){
			//assert(!groupsInYear.contains(group->name));
			//groupsInYear.insert(group->name);
		
			if(!permanentStudentsHash.contains(group->name))
				permanentStudentsHash.insert(group->name, group);
			else
				assert(permanentStudentsHash.value(group->name)==group);
			
			//QSet<QString> subgroupsInGroup;
			
			for(StudentsSubgroup* subgroup : std::as_const(group->subgroupsList)){
				//assert(!subgroupsInGroup.contains(subgroup->name));
				//subgroupsInGroup.insert(subgroup->name);
			
				if(!permanentStudentsHash.contains(subgroup->name))
					permanentStudentsHash.insert(subgroup->name, subgroup);
				else
					assert(permanentStudentsHash.value(subgroup->name)==subgroup);
			}
		}
	}
}

StudentsSet* Rules::searchStudentsSet(const QString& setName)
{
	return permanentStudentsHash.value(setName, nullptr);

	/*for(int i=0; i<this->yearsList.size(); i++){
		StudentsYear* sty=this->yearsList[i];
		if(sty->name==setName)
			return sty;
		for(int j=0; j<sty->groupsList.size(); j++){
			StudentsGroup* stg=sty->groupsList[j];
			if(stg->name==setName)
				return stg;
			for(int k=0; k<stg->subgroupsList.size(); k++){
				StudentsSubgroup* sts=stg->subgroupsList[k];
				if(sts->name==setName)
					return sts;
			}
		}
	}
	return nullptr;*/
}

/*StudentsSet* Rules::searchAugmentedStudentsSet(const QString& setName)
{
	for(int i=0; i<this->augmentedYearsList.size(); i++){
		StudentsYear* sty=this->augmentedYearsList[i];
		if(sty->name==setName)
			return sty;
		for(int j=0; j<sty->groupsList.size(); j++){
			StudentsGroup* stg=sty->groupsList[j];
			if(stg->name==setName)
				return stg;
			for(int k=0; k<stg->subgroupsList.size(); k++){
				StudentsSubgroup* sts=stg->subgroupsList[k];
				if(sts->name==setName)
					return sts;
			}
		}
	}
	return nullptr;
}*/

bool Rules::addYear(StudentsYear* year)
{
	//already existing?
	for(StudentsYear* ty : std::as_const(yearsList))
		if(ty->name==year->name)
			return false;
	//if(this->searchStudentsSet(year->name)!=nullptr)
	//	return false;
	this->yearsList << year;
	
	assert(!permanentStudentsHash.contains(year->name));
	permanentStudentsHash.insert(year->name, year);
	
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

bool Rules::addYearFast(StudentsYear* year)
{
	this->yearsList << year;
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

/*bool Rules::removeYear(const QString& yearName)
{
	return removeYear(yearName, true);
}

bool Rules::emptyYear(const QString& yearName)
{
	return removeYear(yearName, false);
}*/

bool Rules::removeYear(const QString& yearName/*, bool removeAlsoThisYear*/)
{
	const bool removeAlsoThisYear=true;

	StudentsYear* yearPointer=nullptr;
	for(StudentsYear* ty : std::as_const(this->yearsList)){
		if(ty->name==yearName){
			yearPointer=ty;
			break;
		}
	}

	assert(yearPointer!=nullptr);
	
	//pointers
	QSet<StudentsSet*> tmpSet;
	for(StudentsYear* year : std::as_const(yearsList))
		if(year->name!=yearName){
			tmpSet.insert(year);
			for(StudentsGroup* group : std::as_const(year->groupsList)){
				tmpSet.insert(group);
				for(StudentsSubgroup* subgroup : std::as_const(group->subgroupsList))
					tmpSet.insert(subgroup);
			}
		}
	
	QSet<StudentsSet*> toBeRemoved;
	if(removeAlsoThisYear)
		toBeRemoved.insert(yearPointer);
	for(StudentsGroup* group : std::as_const(yearPointer->groupsList)){
		assert(!toBeRemoved.contains(group));
		if(!tmpSet.contains(group))
			toBeRemoved.insert(group);
		for(StudentsSubgroup* subgroup : std::as_const(group->subgroupsList)){
			//assert(!toBeRemoved.contains(subgroup));
			if(!tmpSet.contains(subgroup) && !toBeRemoved.contains(subgroup))
				toBeRemoved.insert(subgroup);
		}
	}
	
	updateActivitiesWhenRemovingStudents(toBeRemoved, false);
	
	if(removeAlsoThisYear){
		for(int i=0; i<yearsList.count(); i++)
			if(yearsList.at(i)==yearPointer){
				yearsList.removeAt(i);
				break;
			}
	}
	else{
		yearPointer->groupsList.clear();
	}
	
	for(StudentsSet* studentsSet : std::as_const(toBeRemoved)){
		assert(permanentStudentsHash.contains(studentsSet->name));
		permanentStudentsHash.remove(studentsSet->name);
	
		delete studentsSet;
	}
	
	if(toBeRemoved.count()>0)
		updateConstraintsAfterRemoval();
	
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

bool Rules::removeYearPointerAfterSplit(StudentsYear* yearPointer)
{
	assert(yearPointer!=nullptr);
	
	//names
	QSet<StudentsSet*> toBeRemoved;

	//Not here, because there exists another pointer (to the new year) with the same name,
	//and I don't want to remove the activities with this year name
	//toBeRemoved.insert(yearPointer);
	for(StudentsGroup* group : std::as_const(yearPointer->groupsList)){
		assert(!toBeRemoved.contains(group));
		if(!permanentStudentsHash.contains(group->name))
			toBeRemoved.insert(group);
		for(StudentsSubgroup* subgroup : std::as_const(group->subgroupsList)){
			//assert(!toBeRemoved.contains(subgroup));
			if(!permanentStudentsHash.contains(subgroup->name) && !toBeRemoved.contains(subgroup))
				toBeRemoved.insert(subgroup);
		}
	}
	
	updateActivitiesWhenRemovingStudents(toBeRemoved, false);
	
	toBeRemoved.insert(yearPointer);
	for(StudentsSet* studentsSet : std::as_const(toBeRemoved))
		delete studentsSet;
	
	if(toBeRemoved.count()>1)
		updateConstraintsAfterRemoval();
	
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

int Rules::searchYear(const QString& yearName)
{
	for(int i=0; i<this->yearsList.size(); i++)
		if(this->yearsList[i]->name==yearName)
			return i;

	return -1;
}

int Rules::searchAugmentedYear(const QString& yearName)
{
	for(int i=0; i<this->augmentedYearsList.size(); i++)
		if(this->augmentedYearsList[i]->name==yearName)
			return i;

	return -1;
}

bool Rules::modifyStudentsSet(const QString& initialStudentsSetName, const QString& finalStudentsSetName, int finalNumberOfStudents)
{
	StudentsSet* studentsSet=searchStudentsSet(initialStudentsSetName);
	assert(studentsSet!=nullptr);
	if(initialStudentsSetName!=finalStudentsSetName)
		assert(searchStudentsSet(finalStudentsSetName)==nullptr);
	int initialNumberOfStudents=studentsSet->numberOfStudents;
	
	for(Activity* act : std::as_const(activitiesList))
		act->renameStudents(*this, initialStudentsSetName, finalStudentsSetName, initialNumberOfStudents, finalNumberOfStudents);
	
	if(initialStudentsSetName!=finalStudentsSetName){
		for(TimeConstraint* ctr : std::as_const(timeConstraintsList)){
			switch(ctr->type){
				case CONSTRAINT_STUDENTS_SET_NOT_AVAILABLE_TIMES:
					{
						ConstraintStudentsSetNotAvailableTimes* crt_constraint=(ConstraintStudentsSetNotAvailableTimes*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY:
					{
						ConstraintStudentsSetMaxHoursDaily* crt_constraint=(ConstraintStudentsSetMaxHoursDaily*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MAX_DAYS_PER_WEEK:
					{
						ConstraintStudentsSetMaxDaysPerWeek* crt_constraint=(ConstraintStudentsSetMaxDaysPerWeek*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_INTERVAL_MAX_DAYS_PER_WEEK:
					{
						ConstraintStudentsSetIntervalMaxDaysPerWeek* crt_constraint=(ConstraintStudentsSetIntervalMaxDaysPerWeek*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MAX_HOURS_CONTINUOUSLY:
					{
						ConstraintStudentsSetMaxHoursContinuously* crt_constraint=(ConstraintStudentsSetMaxHoursContinuously*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
					{
						ConstraintStudentsSetActivityTagMaxHoursContinuously* crt_constraint=(ConstraintStudentsSetActivityTagMaxHoursContinuously*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY:
					{
						ConstraintStudentsSetActivityTagMaxHoursDaily* crt_constraint=(ConstraintStudentsSetActivityTagMaxHoursDaily*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MIN_HOURS_DAILY:
					{
						ConstraintStudentsSetActivityTagMinHoursDaily* crt_constraint=(ConstraintStudentsSetActivityTagMinHoursDaily*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MIN_HOURS_DAILY:
					{
						ConstraintStudentsSetMinHoursDaily* crt_constraint=(ConstraintStudentsSetMinHoursDaily*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
					{
						ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTags* crt_constraint=(ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTags*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
					{
						ConstraintStudentsSetMinGapsBetweenActivityTag* crt_constraint=(ConstraintStudentsSetMinGapsBetweenActivityTag*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
					{
						ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* crt_constraint=(ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
					{
						ConstraintStudentsSetMinGapsBetweenActivityTagPerRealDay* crt_constraint=(ConstraintStudentsSetMinGapsBetweenActivityTagPerRealDay*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
					{
						ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* crt_constraint=(ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
					{
						ConstraintStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon* crt_constraint=(ConstraintStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
					{
						ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour* crt_constraint=(ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_WEEK:
					{
						ConstraintStudentsSetMaxGapsPerWeek* crt_constraint=(ConstraintStudentsSetMaxGapsPerWeek*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_DAY:
					{
						ConstraintStudentsSetMaxGapsPerDay* crt_constraint=(ConstraintStudentsSetMaxGapsPerDay*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
					{
						ConstraintStudentsSetMaxActivityTagsPerDayFromSet* crt_constraint=(ConstraintStudentsSetMaxActivityTagsPerDayFromSet*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
					{
						ConstraintStudentsSetMaxActivityTagsPerRealDayFromSet* crt_constraint=(ConstraintStudentsSetMaxActivityTagsPerRealDayFromSet*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_ACTIVITIES_PREFERRED_TIME_SLOTS:
					{
						ConstraintActivitiesPreferredTimeSlots* crt_constraint=(ConstraintActivitiesPreferredTimeSlots*)ctr;
						if(initialStudentsSetName == crt_constraint->p_studentsName)
							crt_constraint->p_studentsName=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_ACTIVITIES_PREFERRED_STARTING_TIMES:
					{
						ConstraintActivitiesPreferredStartingTimes* crt_constraint=(ConstraintActivitiesPreferredStartingTimes*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_ACTIVITIES_END_STUDENTS_DAY:
					{
						ConstraintActivitiesEndStudentsDay* crt_constraint=(ConstraintActivitiesEndStudentsDay*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_ACTIVITIES_END_TEACHERS_DAY:
					{
						ConstraintActivitiesEndTeachersDay* crt_constraint=(ConstraintActivitiesEndTeachersDay*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}

				case CONSTRAINT_ACTIVITIES_BEGIN_STUDENTS_DAY:
					{
						ConstraintActivitiesBeginStudentsDay* crt_constraint=(ConstraintActivitiesBeginStudentsDay*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_ACTIVITIES_BEGIN_TEACHERS_DAY:
					{
						ConstraintActivitiesBeginTeachersDay* crt_constraint=(ConstraintActivitiesBeginTeachersDay*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}

				case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_STUDENTS_DAY:
					{
						ConstraintActivitiesBeginOrEndStudentsDay* crt_constraint=(ConstraintActivitiesBeginOrEndStudentsDay*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_TEACHERS_DAY:
					{
						ConstraintActivitiesBeginOrEndTeachersDay* crt_constraint=(ConstraintActivitiesBeginOrEndTeachersDay*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}

				case CONSTRAINT_SUBACTIVITIES_PREFERRED_TIME_SLOTS:
					{
						ConstraintSubactivitiesPreferredTimeSlots* crt_constraint=(ConstraintSubactivitiesPreferredTimeSlots*)ctr;
						if(initialStudentsSetName == crt_constraint->p_studentsName)
							crt_constraint->p_studentsName=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_SUBACTIVITIES_PREFERRED_STARTING_TIMES:
					{
						ConstraintSubactivitiesPreferredStartingTimes* crt_constraint=(ConstraintSubactivitiesPreferredStartingTimes*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}
				//2017-02-07
				case CONSTRAINT_STUDENTS_SET_MAX_SPAN_PER_DAY:
					{
						ConstraintStudentsSetMaxSpanPerDay* crt_constraint=(ConstraintStudentsSetMaxSpanPerDay*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MIN_RESTING_HOURS:
					{
						ConstraintStudentsSetMinRestingHours* crt_constraint=(ConstraintStudentsSetMinRestingHours*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}

				//mornings-afternoons
				case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY_REAL_DAYS:
					{
						ConstraintStudentsSetMaxHoursDailyRealDays* crt_constraint=(ConstraintStudentsSetMaxHoursDailyRealDays*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MAX_REAL_DAYS_PER_WEEK:
					{
						ConstraintStudentsSetMaxRealDaysPerWeek* crt_constraint=(ConstraintStudentsSetMaxRealDaysPerWeek*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				//2020-06-25
				case CONSTRAINT_STUDENTS_SET_MAX_AFTERNOONS_PER_WEEK:
					{
						ConstraintStudentsSetMaxAfternoonsPerWeek* crt_constraint=(ConstraintStudentsSetMaxAfternoonsPerWeek*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MAX_MORNINGS_PER_WEEK:
					{
						ConstraintStudentsSetMaxMorningsPerWeek* crt_constraint=(ConstraintStudentsSetMaxMorningsPerWeek*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				//2020-06-26
				case CONSTRAINT_STUDENTS_SET_MIN_AFTERNOONS_PER_WEEK:
					{
						ConstraintStudentsSetMinAfternoonsPerWeek* crt_constraint=(ConstraintStudentsSetMinAfternoonsPerWeek*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MIN_MORNINGS_PER_WEEK:
					{
						ConstraintStudentsSetMinMorningsPerWeek* crt_constraint=(ConstraintStudentsSetMinMorningsPerWeek*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				//

				case CONSTRAINT_STUDENTS_SET_MORNING_INTERVAL_MAX_DAYS_PER_WEEK:
					{
						ConstraintStudentsSetMorningIntervalMaxDaysPerWeek* crt_constraint=(ConstraintStudentsSetMorningIntervalMaxDaysPerWeek*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_AFTERNOON_INTERVAL_MAX_DAYS_PER_WEEK:
					{
						ConstraintStudentsSetAfternoonIntervalMaxDaysPerWeek* crt_constraint=(ConstraintStudentsSetAfternoonIntervalMaxDaysPerWeek*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}

				case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
					{
						ConstraintStudentsSetActivityTagMaxHoursDailyRealDays* crt_constraint=(ConstraintStudentsSetActivityTagMaxHoursDailyRealDays*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MIN_HOURS_PER_MORNING:
					{
						ConstraintStudentsSetMinHoursPerMorning* crt_constraint=(ConstraintStudentsSetMinHoursPerMorning*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MIN_HOURS_PER_AFTERNOON:
					{
						ConstraintStudentsSetMinHoursPerAfternoon* crt_constraint=(ConstraintStudentsSetMinHoursPerAfternoon*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_AFTERNOONS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
					{
						ConstraintStudentsSetAfternoonsEarlyMaxBeginningsAtSecondHour* crt_constraint=(ConstraintStudentsSetAfternoonsEarlyMaxBeginningsAtSecondHour*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MORNINGS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
					{
						ConstraintStudentsSetMorningsEarlyMaxBeginningsAtSecondHour* crt_constraint=(ConstraintStudentsSetMorningsEarlyMaxBeginningsAtSecondHour*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				//2020-06-28
				case CONSTRAINT_STUDENTS_SET_MAX_HOURS_PER_ALL_AFTERNOONS:
					{
						ConstraintStudentsSetMaxHoursPerAllAfternoons* crt_constraint=(ConstraintStudentsSetMaxHoursPerAllAfternoons*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				//
				case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_REAL_DAY:
					{
						ConstraintStudentsSetMaxGapsPerRealDay* crt_constraint=(ConstraintStudentsSetMaxGapsPerRealDay*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_WEEK_FOR_REAL_DAYS:
					{
						ConstraintStudentsSetMaxGapsPerWeekForRealDays* crt_constraint=(ConstraintStudentsSetMaxGapsPerWeekForRealDays*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MAX_SPAN_PER_REAL_DAY:
					{
						ConstraintStudentsSetMaxSpanPerRealDay* crt_constraint=(ConstraintStudentsSetMaxSpanPerRealDay*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MIN_RESTING_HOURS_BETWEEN_MORNING_AND_AFTERNOON:
					{
						ConstraintStudentsSetMinRestingHoursBetweenMorningAndAfternoon* crt_constraint=(ConstraintStudentsSetMinRestingHoursBetweenMorningAndAfternoon*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}
				//2022-02-15
				case CONSTRAINT_STUDENTS_SET_MAX_THREE_CONSECUTIVE_DAYS:
					{
						ConstraintStudentsSetMaxThreeConsecutiveDays* crt_constraint=(ConstraintStudentsSetMaxThreeConsecutiveDays*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}

				case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY_IN_INTERVAL:
					{
						ConstraintStudentsSetMaxHoursDailyInInterval* crt_constraint=(ConstraintStudentsSetMaxHoursDailyInInterval*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}

				case CONSTRAINT_STUDENTS_SET_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
					{
						ConstraintStudentsSetPairOfMutuallyExclusiveTimeSlots* crt_constraint=(ConstraintStudentsSetPairOfMutuallyExclusiveTimeSlots*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}

				case CONSTRAINT_STUDENTS_SET_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
					{
						ConstraintStudentsSetPairOfMutuallyExclusiveSetsOfTimeSlots* crt_constraint=(ConstraintStudentsSetPairOfMutuallyExclusiveSetsOfTimeSlots*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}

				case CONSTRAINT_STUDENTS_SET_OCCUPIES_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
					{
						ConstraintStudentsSetOccupiesMaxSetsOfTimeSlotsFromSelection* crt_constraint=(ConstraintStudentsSetOccupiesMaxSetsOfTimeSlotsFromSelection*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}

				case CONSTRAINT_STUDENTS_SET_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
					{
						ConstraintStudentsSetMaxSingleGapsInSelectedTimeSlots* crt_constraint=(ConstraintStudentsSetMaxSingleGapsInSelectedTimeSlots*)ctr;
						if(initialStudentsSetName == crt_constraint->students)
							crt_constraint->students=finalStudentsSetName;
						break;
					}

				default:
					//do nothing.
					break;
			}
		}

		for(SpaceConstraint* ctr : std::as_const(spaceConstraintsList)){
			switch(ctr->type){
				case CONSTRAINT_STUDENTS_SET_HOME_ROOM:
					{
						ConstraintStudentsSetHomeRoom* crt_constraint=(ConstraintStudentsSetHomeRoom*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_HOME_ROOMS:
					{
						ConstraintStudentsSetHomeRooms* crt_constraint=(ConstraintStudentsSetHomeRooms*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_DAY:
					{
						ConstraintStudentsSetMaxBuildingChangesPerDay* crt_constraint=(ConstraintStudentsSetMaxBuildingChangesPerDay*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_WEEK:
					{
						ConstraintStudentsSetMaxBuildingChangesPerWeek* crt_constraint=(ConstraintStudentsSetMaxBuildingChangesPerWeek*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_BUILDING_CHANGES:
					{
						ConstraintStudentsSetMinGapsBetweenBuildingChanges* crt_constraint=(ConstraintStudentsSetMinGapsBetweenBuildingChanges*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_DAY:
					{
						ConstraintStudentsSetMaxRoomChangesPerDay* crt_constraint=(ConstraintStudentsSetMaxRoomChangesPerDay*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_WEEK:
					{
						ConstraintStudentsSetMaxRoomChangesPerWeek* crt_constraint=(ConstraintStudentsSetMaxRoomChangesPerWeek*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ROOM_CHANGES:
					{
						ConstraintStudentsSetMinGapsBetweenRoomChanges* crt_constraint=(ConstraintStudentsSetMinGapsBetweenRoomChanges*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}

				//mornings-afternoons
				case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_REAL_DAY:
					{
						ConstraintStudentsSetMaxRoomChangesPerRealDay* crt_constraint=(ConstraintStudentsSetMaxRoomChangesPerRealDay*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_REAL_DAY:
					{
						ConstraintStudentsSetMaxBuildingChangesPerRealDay* crt_constraint=(ConstraintStudentsSetMaxBuildingChangesPerRealDay*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}

				case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_DAY_IN_INTERVAL:
					{
						ConstraintStudentsSetMaxBuildingChangesPerDayInInterval* crt_constraint=(ConstraintStudentsSetMaxBuildingChangesPerDayInInterval*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_REAL_DAY_IN_INTERVAL:
					{
						ConstraintStudentsSetMaxBuildingChangesPerRealDayInInterval* crt_constraint=(ConstraintStudentsSetMaxBuildingChangesPerRealDayInInterval*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}

				case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_DAY_IN_INTERVAL:
					{
						ConstraintStudentsSetMaxRoomChangesPerDayInInterval* crt_constraint=(ConstraintStudentsSetMaxRoomChangesPerDayInInterval*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}
				case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_REAL_DAY_IN_INTERVAL:
					{
						ConstraintStudentsSetMaxRoomChangesPerRealDayInInterval* crt_constraint=(ConstraintStudentsSetMaxRoomChangesPerRealDayInInterval*)ctr;
						if(initialStudentsSetName == crt_constraint->studentsName)
							crt_constraint->studentsName=finalStudentsSetName;
						break;
					}

				default:
					//do nothing.
					break;
			}
		}
	}

	assert(studentsSet->name==initialStudentsSetName);
	assert(studentsSet->numberOfStudents==initialNumberOfStudents);
	studentsSet->name=finalStudentsSetName;
	studentsSet->numberOfStudents=finalNumberOfStudents;
	
	assert(permanentStudentsHash.contains(initialStudentsSetName));
	if(initialStudentsSetName!=finalStudentsSetName){
		permanentStudentsHash.remove(initialStudentsSetName);
		permanentStudentsHash.insert(studentsSet->name, studentsSet);

		if(ssnatHash.contains(initialStudentsSetName)){
			QSet<ConstraintStudentsSetNotAvailableTimes*> cs=ssnatHash.value(initialStudentsSetName);
			ssnatHash.remove(initialStudentsSetName);
			assert(!ssnatHash.contains(finalStudentsSetName));
			ssnatHash.insert(finalStudentsSetName, cs);
		}
	}
	
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
	
	return true;
}

//by Volker Dirr (start) - very similar to Liviu's modifyStudentsSet
bool Rules::modifyStudentsSets(const QHash<QString, QString>& oldAndNewStudentsSetNames){
	if(oldAndNewStudentsSetNames.isEmpty())
		return true;

	for(Activity* act : std::as_const(activitiesList)){
		for(int i=0; i<act->studentsNames.count(); i++)
			if(oldAndNewStudentsSetNames.contains(act->studentsNames.at(i)))
				act->studentsNames[i]=oldAndNewStudentsSetNames.value(act->studentsNames.at(i));
	}
	
	for(TimeConstraint* ctr : std::as_const(timeConstraintsList)){
		switch(ctr->type){
			case CONSTRAINT_STUDENTS_SET_NOT_AVAILABLE_TIMES:
				{
					ConstraintStudentsSetNotAvailableTimes* crt_constraint=(ConstraintStudentsSetNotAvailableTimes*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY:
				{
					ConstraintStudentsSetMaxHoursDaily* crt_constraint=(ConstraintStudentsSetMaxHoursDaily*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetMaxDaysPerWeek* crt_constraint=(ConstraintStudentsSetMaxDaysPerWeek*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetIntervalMaxDaysPerWeek* crt_constraint=(ConstraintStudentsSetIntervalMaxDaysPerWeek*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintStudentsSetMaxHoursContinuously* crt_constraint=(ConstraintStudentsSetMaxHoursContinuously*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintStudentsSetActivityTagMaxHoursContinuously* crt_constraint=(ConstraintStudentsSetActivityTagMaxHoursContinuously*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY:
				{
					ConstraintStudentsSetActivityTagMaxHoursDaily* crt_constraint=(ConstraintStudentsSetActivityTagMaxHoursDaily*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MIN_HOURS_DAILY:
				{
					ConstraintStudentsSetActivityTagMinHoursDaily* crt_constraint=(ConstraintStudentsSetActivityTagMinHoursDaily*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_HOURS_DAILY:
				{
					ConstraintStudentsSetMinHoursDaily* crt_constraint=(ConstraintStudentsSetMinHoursDaily*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
				{
					ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTags* crt_constraint=(ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTags*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
				{
					ConstraintStudentsSetMinGapsBetweenActivityTag* crt_constraint=(ConstraintStudentsSetMinGapsBetweenActivityTag*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
				{
					ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* crt_constraint=(ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
				{
					ConstraintStudentsSetMinGapsBetweenActivityTagPerRealDay* crt_constraint=(ConstraintStudentsSetMinGapsBetweenActivityTagPerRealDay*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* crt_constraint=(ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon* crt_constraint=(ConstraintStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour* crt_constraint=(ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_WEEK:
				{
					ConstraintStudentsSetMaxGapsPerWeek* crt_constraint=(ConstraintStudentsSetMaxGapsPerWeek*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_DAY:
				{
					ConstraintStudentsSetMaxGapsPerDay* crt_constraint=(ConstraintStudentsSetMaxGapsPerDay*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintStudentsSetMaxActivityTagsPerDayFromSet* crt_constraint=(ConstraintStudentsSetMaxActivityTagsPerDayFromSet*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintStudentsSetMaxActivityTagsPerRealDayFromSet* crt_constraint=(ConstraintStudentsSetMaxActivityTagsPerRealDayFromSet*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_ACTIVITIES_PREFERRED_TIME_SLOTS:
				{
					ConstraintActivitiesPreferredTimeSlots* crt_constraint=(ConstraintActivitiesPreferredTimeSlots*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->p_studentsName))
						crt_constraint->p_studentsName=oldAndNewStudentsSetNames.value(crt_constraint->p_studentsName);
					break;
				}
			case CONSTRAINT_ACTIVITIES_PREFERRED_STARTING_TIMES:
				{
					ConstraintActivitiesPreferredStartingTimes* crt_constraint=(ConstraintActivitiesPreferredStartingTimes*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}
			case CONSTRAINT_ACTIVITIES_END_STUDENTS_DAY:
				{
					ConstraintActivitiesEndStudentsDay* crt_constraint=(ConstraintActivitiesEndStudentsDay*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}
			case CONSTRAINT_ACTIVITIES_END_TEACHERS_DAY:
				{
					ConstraintActivitiesEndTeachersDay* crt_constraint=(ConstraintActivitiesEndTeachersDay*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}

			case CONSTRAINT_ACTIVITIES_BEGIN_STUDENTS_DAY:
				{
					ConstraintActivitiesBeginStudentsDay* crt_constraint=(ConstraintActivitiesBeginStudentsDay*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}
			case CONSTRAINT_ACTIVITIES_BEGIN_TEACHERS_DAY:
				{
					ConstraintActivitiesBeginTeachersDay* crt_constraint=(ConstraintActivitiesBeginTeachersDay*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}

			case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_STUDENTS_DAY:
				{
					ConstraintActivitiesBeginOrEndStudentsDay* crt_constraint=(ConstraintActivitiesBeginOrEndStudentsDay*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}
			case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_TEACHERS_DAY:
				{
					ConstraintActivitiesBeginOrEndTeachersDay* crt_constraint=(ConstraintActivitiesBeginOrEndTeachersDay*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}

			case CONSTRAINT_SUBACTIVITIES_PREFERRED_TIME_SLOTS:
				{
					ConstraintSubactivitiesPreferredTimeSlots* crt_constraint=(ConstraintSubactivitiesPreferredTimeSlots*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->p_studentsName))
						crt_constraint->p_studentsName=oldAndNewStudentsSetNames.value(crt_constraint->p_studentsName);
					break;
				}
			case CONSTRAINT_SUBACTIVITIES_PREFERRED_STARTING_TIMES:
				{
					ConstraintSubactivitiesPreferredStartingTimes* crt_constraint=(ConstraintSubactivitiesPreferredStartingTimes*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}
			//2017-02-07
			case CONSTRAINT_STUDENTS_SET_MAX_SPAN_PER_DAY:
				{
					ConstraintStudentsSetMaxSpanPerDay* crt_constraint=(ConstraintStudentsSetMaxSpanPerDay*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_RESTING_HOURS:
				{
					ConstraintStudentsSetMinRestingHours* crt_constraint=(ConstraintStudentsSetMinRestingHours*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
			}

			//mornings-afternoons
			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintStudentsSetMaxHoursDailyRealDays* crt_constraint=(ConstraintStudentsSetMaxHoursDailyRealDays*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_REAL_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetMaxRealDaysPerWeek* crt_constraint=(ConstraintStudentsSetMaxRealDaysPerWeek*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			//2020-06-25
			case CONSTRAINT_STUDENTS_SET_MAX_AFTERNOONS_PER_WEEK:
				{
					ConstraintStudentsSetMaxAfternoonsPerWeek* crt_constraint=(ConstraintStudentsSetMaxAfternoonsPerWeek*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_MORNINGS_PER_WEEK:
				{
					ConstraintStudentsSetMaxMorningsPerWeek* crt_constraint=(ConstraintStudentsSetMaxMorningsPerWeek*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			//2020-06-26
			case CONSTRAINT_STUDENTS_SET_MIN_AFTERNOONS_PER_WEEK:
				{
					ConstraintStudentsSetMinAfternoonsPerWeek* crt_constraint=(ConstraintStudentsSetMinAfternoonsPerWeek*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_MORNINGS_PER_WEEK:
				{
					ConstraintStudentsSetMinMorningsPerWeek* crt_constraint=(ConstraintStudentsSetMinMorningsPerWeek*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			//

			case CONSTRAINT_STUDENTS_SET_MORNING_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetMorningIntervalMaxDaysPerWeek* crt_constraint=(ConstraintStudentsSetMorningIntervalMaxDaysPerWeek*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_AFTERNOON_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetAfternoonIntervalMaxDaysPerWeek* crt_constraint=(ConstraintStudentsSetAfternoonIntervalMaxDaysPerWeek*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}

			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintStudentsSetActivityTagMaxHoursDailyRealDays* crt_constraint=(ConstraintStudentsSetActivityTagMaxHoursDailyRealDays*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_HOURS_PER_MORNING:
				{
					ConstraintStudentsSetMinHoursPerMorning* crt_constraint=(ConstraintStudentsSetMinHoursPerMorning*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_HOURS_PER_AFTERNOON:
				{
					ConstraintStudentsSetMinHoursPerAfternoon* crt_constraint=(ConstraintStudentsSetMinHoursPerAfternoon*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_AFTERNOONS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintStudentsSetAfternoonsEarlyMaxBeginningsAtSecondHour* crt_constraint=(ConstraintStudentsSetAfternoonsEarlyMaxBeginningsAtSecondHour*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MORNINGS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintStudentsSetMorningsEarlyMaxBeginningsAtSecondHour* crt_constraint=(ConstraintStudentsSetMorningsEarlyMaxBeginningsAtSecondHour*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			//2020-06-28
			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_PER_ALL_AFTERNOONS:
				{
					ConstraintStudentsSetMaxHoursPerAllAfternoons* crt_constraint=(ConstraintStudentsSetMaxHoursPerAllAfternoons*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			//
			case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_REAL_DAY:
				{
					ConstraintStudentsSetMaxGapsPerRealDay* crt_constraint=(ConstraintStudentsSetMaxGapsPerRealDay*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_WEEK_FOR_REAL_DAYS:
				{
					ConstraintStudentsSetMaxGapsPerWeekForRealDays* crt_constraint=(ConstraintStudentsSetMaxGapsPerWeekForRealDays*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_SPAN_PER_REAL_DAY:
				{
					ConstraintStudentsSetMaxSpanPerRealDay* crt_constraint=(ConstraintStudentsSetMaxSpanPerRealDay*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_RESTING_HOURS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsSetMinRestingHoursBetweenMorningAndAfternoon* crt_constraint=(ConstraintStudentsSetMinRestingHoursBetweenMorningAndAfternoon*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}
			//2022-02-15
			case CONSTRAINT_STUDENTS_SET_MAX_THREE_CONSECUTIVE_DAYS:
				{
					ConstraintStudentsSetMaxThreeConsecutiveDays* crt_constraint=(ConstraintStudentsSetMaxThreeConsecutiveDays*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}

			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxHoursDailyInInterval* crt_constraint=(ConstraintStudentsSetMaxHoursDailyInInterval*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}

			case CONSTRAINT_STUDENTS_SET_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
				{
					ConstraintStudentsSetPairOfMutuallyExclusiveTimeSlots* crt_constraint=(ConstraintStudentsSetPairOfMutuallyExclusiveTimeSlots*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}

			case CONSTRAINT_STUDENTS_SET_OCCUPIES_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintStudentsSetOccupiesMaxSetsOfTimeSlotsFromSelection* crt_constraint=(ConstraintStudentsSetOccupiesMaxSetsOfTimeSlotsFromSelection*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}

			case CONSTRAINT_STUDENTS_SET_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
				{
					ConstraintStudentsSetPairOfMutuallyExclusiveSetsOfTimeSlots* crt_constraint=(ConstraintStudentsSetPairOfMutuallyExclusiveSetsOfTimeSlots*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}

			case CONSTRAINT_STUDENTS_SET_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintStudentsSetMaxSingleGapsInSelectedTimeSlots* crt_constraint=(ConstraintStudentsSetMaxSingleGapsInSelectedTimeSlots*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->students))
						crt_constraint->students=oldAndNewStudentsSetNames.value(crt_constraint->students);
					break;
				}

			default:
				//do nothing.
				break;
		}
	}

	for(SpaceConstraint* ctr : std::as_const(spaceConstraintsList)){
		switch(ctr->type){
			case CONSTRAINT_STUDENTS_SET_HOME_ROOM:
				{
					ConstraintStudentsSetHomeRoom* crt_constraint=(ConstraintStudentsSetHomeRoom*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_HOME_ROOMS:
				{
					ConstraintStudentsSetHomeRooms* crt_constraint=(ConstraintStudentsSetHomeRooms*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_DAY:
				{
					ConstraintStudentsSetMaxBuildingChangesPerDay* crt_constraint=(ConstraintStudentsSetMaxBuildingChangesPerDay*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_WEEK:
				{
					ConstraintStudentsSetMaxBuildingChangesPerWeek* crt_constraint=(ConstraintStudentsSetMaxBuildingChangesPerWeek*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_BUILDING_CHANGES:
				{
					ConstraintStudentsSetMinGapsBetweenBuildingChanges* crt_constraint=(ConstraintStudentsSetMinGapsBetweenBuildingChanges*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_DAY:
				{
					ConstraintStudentsSetMaxRoomChangesPerDay* crt_constraint=(ConstraintStudentsSetMaxRoomChangesPerDay*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_WEEK:
				{
					ConstraintStudentsSetMaxRoomChangesPerWeek* crt_constraint=(ConstraintStudentsSetMaxRoomChangesPerWeek*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ROOM_CHANGES:
				{
					ConstraintStudentsSetMinGapsBetweenRoomChanges* crt_constraint=(ConstraintStudentsSetMinGapsBetweenRoomChanges*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}

			//mornings-afternoons
			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_REAL_DAY:
				{
					ConstraintStudentsSetMaxRoomChangesPerRealDay* crt_constraint=(ConstraintStudentsSetMaxRoomChangesPerRealDay*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_REAL_DAY:
				{
					ConstraintStudentsSetMaxBuildingChangesPerRealDay* crt_constraint=(ConstraintStudentsSetMaxBuildingChangesPerRealDay*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}

			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxBuildingChangesPerDayInInterval* crt_constraint=(ConstraintStudentsSetMaxBuildingChangesPerDayInInterval*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxBuildingChangesPerRealDayInInterval* crt_constraint=(ConstraintStudentsSetMaxBuildingChangesPerRealDayInInterval*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}

			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxRoomChangesPerDayInInterval* crt_constraint=(ConstraintStudentsSetMaxRoomChangesPerDayInInterval*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxRoomChangesPerRealDayInInterval* crt_constraint=(ConstraintStudentsSetMaxRoomChangesPerRealDayInInterval*)ctr;
					if(oldAndNewStudentsSetNames.contains(crt_constraint->studentsName))
						crt_constraint->studentsName=oldAndNewStudentsSetNames.value(crt_constraint->studentsName);
					break;
				}

			default:
				//do nothing.
				break;
		}
	}

	QHash<QString, QString>::const_iterator i=oldAndNewStudentsSetNames.constBegin();
	while(i!=oldAndNewStudentsSetNames.constEnd()) {
		StudentsSet* studentsSet=searchStudentsSet(i.key());
		assert(studentsSet!=nullptr);
		studentsSet->name=i.value();
		
		assert(permanentStudentsHash.contains(i.key()));
		permanentStudentsHash.remove(i.key());
		permanentStudentsHash.insert(studentsSet->name, studentsSet);

		assert(i.key()!=i.value());
		if(ssnatHash.contains(i.key())){
			QSet<ConstraintStudentsSetNotAvailableTimes*> cs=ssnatHash.value(i.key());
			ssnatHash.remove(i.key());
			assert(!ssnatHash.contains(i.value()));
			ssnatHash.insert(i.value(), cs);
		}
		i++;
	}
	
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);
	
	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}
//by Volker Dirr (end) - very similar to Liviu's modifyStudentsSet

void Rules::sortYearsAlphabetically()
{
	std::stable_sort(this->yearsList.begin(), this->yearsList.end(), yearsAscending);

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
}

bool Rules::addGroup(const QString& yearName, StudentsGroup* group)
{
	StudentsYear* sty=nullptr;
	for(int i=0; i<this->yearsList.size(); i++){
		sty=yearsList[i];
		if(sty->name==yearName)
			break;
	}
	assert(sty!=nullptr);
	
	for(int i=0; i<sty->groupsList.size(); i++){
		StudentsGroup* stg=sty->groupsList[i];
		if(stg->name==group->name)
			return false;
	}
	
	sty->groupsList << group; //append
	
	if(!permanentStudentsHash.contains(group->name))
		permanentStudentsHash.insert(group->name, group);

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

bool Rules::addGroupFast(StudentsYear* year, StudentsGroup* group)
{
	year->groupsList << group; //append

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

bool Rules::removeGroup(const QString& yearName, const QString& groupName)
{
	StudentsYear* yearPointer=nullptr;
	for(StudentsYear* ty : std::as_const(this->yearsList)){
		if(ty->name==yearName){
			yearPointer=ty;
			break;
		}
	}

	assert(yearPointer!=nullptr);
	
	StudentsGroup* groupPointer=nullptr;
	for(StudentsGroup* tg : std::as_const(yearPointer->groupsList)){
		if(tg->name==groupName){
			groupPointer=tg;
			break;
		}
	}
	
	assert(groupPointer!=nullptr);

	//pointers
	QSet<StudentsSet*> tmpSet;
	for(StudentsYear* year : std::as_const(yearsList)){
		if(year->name!=yearName){
			//tmpSet.insert(year); useless
			for(StudentsGroup* group : std::as_const(year->groupsList)){
				if(group->name==groupName) //we shall not purge groupName, because it still exists in the current year
					tmpSet.insert(group);
				for(StudentsSubgroup* subgroup : std::as_const(group->subgroupsList))
					tmpSet.insert(subgroup);
			}
		}
		else{
			for(StudentsGroup* group : std::as_const(year->groupsList))
				if(group->name!=groupName){
					//tmpSet.insert(group); //useless
					for(StudentsSubgroup* subgroup : std::as_const(group->subgroupsList))
						tmpSet.insert(subgroup);
				}
		}
	}
	
	QSet<StudentsSet*> toBeRemoved;
	if(!tmpSet.contains(groupPointer))
		toBeRemoved.insert(groupPointer);
	for(StudentsSubgroup* subgroup : std::as_const(groupPointer->subgroupsList)){
		assert(!toBeRemoved.contains(subgroup));
		if(!tmpSet.contains(subgroup))
			toBeRemoved.insert(subgroup);
	}
	
	updateActivitiesWhenRemovingStudents(toBeRemoved, false);
	
	for(int i=0; i<yearPointer->groupsList.count(); i++)
		if(yearPointer->groupsList.at(i)==groupPointer){
			yearPointer->groupsList.removeAt(i);
			break;
		}
	
	for(StudentsSet* studentsSet : std::as_const(toBeRemoved)){
		assert(permanentStudentsHash.contains(studentsSet->name));
		permanentStudentsHash.remove(studentsSet->name);
	
		delete studentsSet;
	}
	
	if(toBeRemoved.count()>0)
		updateConstraintsAfterRemoval();
	
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

bool Rules::purgeGroup(const QString& groupName)
{
	StudentsGroup* groupPointer=nullptr;
	for(StudentsYear* year : std::as_const(yearsList)){
		int j=-1;
		for(int i=0; i<year->groupsList.count(); i++){
			if(year->groupsList.at(i)->name==groupName){
				j=i;
				if(groupPointer==nullptr)
					groupPointer=year->groupsList.at(i);
				else
					assert(groupPointer==year->groupsList.at(i));
				break;
			}
		}
		if(j>=0)
			year->groupsList.removeAt(j);
	}
	
	assert(groupPointer!=nullptr);

	//pointers
	QSet<StudentsSet*> tmpSet;
	for(StudentsYear* year : std::as_const(yearsList))
		for(StudentsGroup* group : std::as_const(year->groupsList))
			for(StudentsSubgroup* subgroup : std::as_const(group->subgroupsList))
				tmpSet.insert(subgroup);
	
	QSet<StudentsSet*> toBeRemoved;
	if(!tmpSet.contains(groupPointer))
		toBeRemoved.insert(groupPointer);
	else
		assert(0);
	for(StudentsSubgroup* subgroup : std::as_const(groupPointer->subgroupsList)){
		assert(!toBeRemoved.contains(subgroup));
		if(!tmpSet.contains(subgroup))
			toBeRemoved.insert(subgroup);
	}
	
	updateActivitiesWhenRemovingStudents(toBeRemoved, false);
	
	for(StudentsSet* studentsSet : std::as_const(toBeRemoved)){
		assert(permanentStudentsHash.contains(studentsSet->name));
		permanentStudentsHash.remove(studentsSet->name);
	
		delete studentsSet;
	}
	
	if(toBeRemoved.count()>0)
		updateConstraintsAfterRemoval();
	
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

int Rules::searchGroup(const QString& yearName, const QString& groupName)
{
	StudentsYear* sty=nullptr;
	for(StudentsYear* ty : std::as_const(yearsList))
		if(ty->name==yearName){
			sty=ty;
			break;
		}
	assert(sty!=nullptr);

	for(int i=0; i<sty->groupsList.size(); i++)
		if(sty->groupsList[i]->name==groupName)
			return i;
	
	return -1;
}

int Rules::searchAugmentedGroup(const QString& yearName, const QString& groupName)
{
	StudentsYear* sty=nullptr;
	for(StudentsYear* ty : std::as_const(augmentedYearsList))
		if(ty->name==yearName){
			sty=ty;
			break;
		}
	assert(sty!=nullptr);
	
	for(int i=0; i<sty->groupsList.size(); i++)
		if(sty->groupsList[i]->name==groupName)
			return i;
	
	return -1;
}

void Rules::sortGroupsAlphabetically(const QString& yearName)
{
	StudentsYear* sty=this->yearsList[this->searchYear(yearName)];
	assert(sty!=nullptr);

	std::stable_sort(sty->groupsList.begin(), sty->groupsList.end(), groupsAscending);

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
}

bool Rules::addSubgroup(const QString& yearName, const QString& groupName, StudentsSubgroup* subgroup)
{
	StudentsYear* sty=this->yearsList.at(this->searchYear(yearName));
	assert(sty!=nullptr);
	StudentsGroup* stg=sty->groupsList.at(this->searchGroup(yearName, groupName));
	assert(stg!=nullptr);

	for(int i=0; i<stg->subgroupsList.size(); i++){
		StudentsSubgroup* sts=stg->subgroupsList[i];
		if(sts->name==subgroup->name)
			return false;
	}
	
	stg->subgroupsList << subgroup; //append
	
	if(!permanentStudentsHash.contains(subgroup->name))
		permanentStudentsHash.insert(subgroup->name, subgroup);

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

bool Rules::addSubgroupFast(StudentsYear* year, StudentsGroup* group, StudentsSubgroup* subgroup)
{
	Q_UNUSED(year);

	group->subgroupsList << subgroup; //append

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

bool Rules::removeSubgroup(const QString& yearName, const QString& groupName, const QString& subgroupName)
{
	StudentsYear* yearPointer=nullptr;
	for(StudentsYear* ty : std::as_const(this->yearsList)){
		if(ty->name==yearName){
			yearPointer=ty;
			break;
		}
	}

	assert(yearPointer!=nullptr);
	
	StudentsGroup* groupPointer=nullptr;
	for(StudentsGroup* tg : std::as_const(yearPointer->groupsList)){
		if(tg->name==groupName){
			groupPointer=tg;
			break;
		}
	}
	
	assert(groupPointer!=nullptr);
	
	StudentsSubgroup* subgroupPointer=nullptr;
	for(StudentsSubgroup* ts : std::as_const(groupPointer->subgroupsList)){
		if(ts->name==subgroupName){
			subgroupPointer=ts;
			break;
		}
	}
	
	assert(subgroupPointer!=nullptr);
	
	//pointers
	QSet<StudentsSet*> toBeRemoved;
	toBeRemoved.insert(subgroupPointer);
	for(StudentsYear* year : std::as_const(yearsList))
		for(StudentsGroup* group : std::as_const(year->groupsList))
			for(StudentsSubgroup* subgroup : std::as_const(group->subgroupsList))
				if(subgroup->name==subgroupName && (year->name!=yearName || group->name!=groupName))
					toBeRemoved.remove(subgroupPointer);
					
	updateActivitiesWhenRemovingStudents(toBeRemoved, false);
	
	for(int i=0; i<groupPointer->subgroupsList.count(); i++)
		if(groupPointer->subgroupsList.at(i)==subgroupPointer){
			groupPointer->subgroupsList.removeAt(i);
			break;
		}
	
	for(StudentsSet* studentsSet : std::as_const(toBeRemoved)){
		assert(permanentStudentsHash.contains(studentsSet->name));
		permanentStudentsHash.remove(studentsSet->name);
	
		delete studentsSet;
	}
		
	if(toBeRemoved.count()>0)
		updateConstraintsAfterRemoval();
	
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

bool Rules::purgeSubgroup(const QString& subgroupName)
{
	StudentsSubgroup* subgroupPointer=nullptr;
	for(StudentsYear* year : std::as_const(yearsList))
		for(StudentsGroup* group : std::as_const(year->groupsList)){
			int j=-1;
			for(int i=0; i<group->subgroupsList.count(); i++){
				if(group->subgroupsList.at(i)->name==subgroupName){
					j=i;
					if(subgroupPointer==nullptr)
						subgroupPointer=group->subgroupsList.at(i);
					else
						assert(subgroupPointer==group->subgroupsList.at(i));
					break;
				}
			}
			if(j>=0)
				group->subgroupsList.removeAt(j);
		}

	assert(subgroupPointer!=nullptr);
	
	//pointers
	QSet<StudentsSet*> toBeRemoved;
	toBeRemoved.insert(subgroupPointer);
	
	updateActivitiesWhenRemovingStudents(toBeRemoved, false);
	
	for(StudentsSet* studentsSet : std::as_const(toBeRemoved)){
		assert(permanentStudentsHash.contains(studentsSet->name));
		permanentStudentsHash.remove(studentsSet->name);
	
		delete studentsSet;
	}
	
	if(toBeRemoved.count()>0)
		updateConstraintsAfterRemoval();
	
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

int Rules::searchSubgroup(const QString& yearName, const QString& groupName, const QString& subgroupName)
{
	StudentsYear* sty=nullptr;
	for(StudentsYear* ty : std::as_const(yearsList))
		if(ty->name==yearName){
			sty=ty;
			break;
		}
	assert(sty!=nullptr);

	StudentsGroup* stg=nullptr;
	for(StudentsGroup* tg : std::as_const(sty->groupsList))
		if(tg->name==groupName){
			stg=tg;
			break;
		}
	assert(stg!=nullptr);

	for(int i=0; i<stg->subgroupsList.size(); i++)
		if(stg->subgroupsList[i]->name==subgroupName)
			return i;
	
	return -1;
}

int Rules::searchAugmentedSubgroup(const QString& yearName, const QString& groupName, const QString& subgroupName)
{
	StudentsYear* sty=nullptr;
	for(StudentsYear* ty : std::as_const(augmentedYearsList))
		if(ty->name==yearName){
			sty=ty;
			break;
		}
	assert(sty!=nullptr);

	StudentsGroup* stg=nullptr;
	for(StudentsGroup* tg : std::as_const(sty->groupsList))
		if(tg->name==groupName){
			stg=tg;
			break;
		}
	assert(stg!=nullptr);

	for(int i=0; i<stg->subgroupsList.size(); i++)
		if(stg->subgroupsList[i]->name==subgroupName)
			return i;
	
	return -1;
}

void Rules::sortSubgroupsAlphabetically(const QString& yearName, const QString& groupName)
{
	StudentsYear* sty=this->yearsList.at(this->searchYear(yearName));
	assert(sty!=nullptr);
	StudentsGroup* stg=sty->groupsList.at(this->searchGroup(yearName, groupName));
	assert(stg!=nullptr);

	std::stable_sort(stg->subgroupsList.begin(), stg->subgroupsList.end(), subgroupsAscending);
	
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
}

bool Rules::addSimpleActivityFast(
	QWidget* parent,
	int _id,
	int _activityGroupId,
	const QStringList& _teachersNames,
	const QString& _subjectName,
	const QStringList& _activityTagsNames,
	const QStringList& _studentsNames,
	int _duration,
	int _totalDuration,
	bool _active,
	bool _computeNTotalStudents,
	int _nTotalStudents,
	int _computedNumberOfStudents)
{
	//check for duplicates - idea and code by Volker Dirr
	int t=QStringList(_teachersNames).removeDuplicates();
	if(t>0)
		RulesReconcilableMessage::warning(parent, tr("FET warning"), tr("Activity with Id=%1 contains %2 duplicate teachers - please correct that")
		 .arg(_id).arg(t));

	t=QStringList(_studentsNames).removeDuplicates();
	if(t>0)
		RulesReconcilableMessage::warning(parent, tr("FET warning"), tr("Activity with Id=%1 contains %2 duplicate students sets - please correct that")
		 .arg(_id).arg(t));

	t=QStringList(_activityTagsNames).removeDuplicates();
	if(t>0)
		RulesReconcilableMessage::warning(parent, tr("FET warning"), tr("Activity with Id=%1 contains %2 duplicate activity tags - please correct that")
		 .arg(_id).arg(t));

	Activity *act=new Activity(*this, _id, _activityGroupId, _teachersNames, _subjectName, _activityTagsNames,
		_studentsNames, _duration, _totalDuration, _active, _computeNTotalStudents, _nTotalStudents, _computedNumberOfStudents);

	this->activitiesList << act; //append

	assert(!activitiesPointerHash.contains(act->id));
	activitiesPointerHash.insert(act->id, act);

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

bool Rules::addSplitActivityFast(
	QWidget* parent,
	int _firstActivityId,
	int _activityGroupId,
	const QStringList& _teachersNames,
	const QString& _subjectName,
	const QStringList& _activityTagsNames,
	const QStringList& _studentsNames,
	int _nSplits,
	int _totalDuration,
	const QList<int>& _durations,
	const QList<bool>& _active,
	int _minDayDistance,
	double _weightPercentage,
	bool _consecutiveIfSameDay,
	bool _computeNTotalStudents,
	int _nTotalStudents,
	int _computedNumberOfStudents,
	bool _halfDays)
{
	//check for duplicates - idea and code by Volker Dirr
	int t=QStringList(_teachersNames).removeDuplicates();
	if(t>0)
		RulesReconcilableMessage::warning(parent, tr("FET warning"), tr("Activities with group_Id=%1 contain %2 duplicate teachers - please correct that")
		 .arg(_activityGroupId).arg(t));

	t=QStringList(_studentsNames).removeDuplicates();
	if(t>0)
		RulesReconcilableMessage::warning(parent, tr("FET warning"), tr("Activities with group_Id=%1 contain %2 duplicate students sets - please correct that")
		 .arg(_activityGroupId).arg(t));

	t=QStringList(_activityTagsNames).removeDuplicates();
	if(t>0)
		RulesReconcilableMessage::warning(parent, tr("FET warning"), tr("Activities with group_Id=%1 contain %2 duplicate activity tags - please correct that")
		 .arg(_activityGroupId).arg(t));

	assert(_firstActivityId==_activityGroupId);

	QList<int> acts;

	acts.clear();
	for(int i=0; i<_nSplits; i++){
		Activity *act=new Activity(*this, _firstActivityId+i, _activityGroupId,
		 _teachersNames, _subjectName, _activityTagsNames, _studentsNames,
		 _durations[i], _totalDuration, _active[i], _computeNTotalStudents, _nTotalStudents, _computedNumberOfStudents);

		this->activitiesList << act; //append

		assert(!activitiesPointerHash.contains(act->id));
		activitiesPointerHash.insert(act->id, act);

		acts.append(_firstActivityId+i);
	}

	if(_minDayDistance>0){
		TimeConstraint *constr;
		if(!_halfDays)
			constr=new ConstraintMinDaysBetweenActivities(_weightPercentage, _consecutiveIfSameDay, _nSplits, acts, _minDayDistance);
		else
			constr=new ConstraintMinHalfDaysBetweenActivities(_weightPercentage, _consecutiveIfSameDay, _nSplits, acts, _minDayDistance);
		bool tmp=this->addTimeConstraint(constr);
		assert(tmp);
	}

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

bool Rules::addSplitActivityFastWithComponents(
	QWidget* parent,
	int _firstActivityId,
	int _activityGroupId,
	const QList<QStringList>& _teachersNames,
	const QList<QString>& _subjectName,
	const QList<QStringList>& _activityTagsNames,
	const QList<QStringList>& _studentsNames,
	int _nSplits,
	int _totalDuration,
	const QList<int>& _durations,
	const QList<bool>& _active,
	int _minDayDistance,
	double _weightPercentage,
	bool _consecutiveIfSameDay,
	bool _computeNTotalStudents,
	int _nTotalStudents,
	const QList<int>& _computedNumberOfStudents,
	bool _halfDays)
{
	QList<QStringList> tempTN=_teachersNames;
	if(_teachersNames.count()<_nSplits){
		for(int i=0; i<_nSplits-_teachersNames.count(); i++){
			tempTN.append(_teachersNames.at(0));
		}
	}
	
	QList<QString> tempSN=_subjectName;
	if(_subjectName.count()<_nSplits){
		for(int i=0; i<_nSplits-_subjectName.count(); i++){
			tempSN.append(_subjectName.at(0));
		}
	}
	
	QList<QStringList> tempATN=_activityTagsNames;
	if(_activityTagsNames.count()<_nSplits){
		for(int i=0; i<_nSplits-_activityTagsNames.count(); i++){
			tempATN.append(_activityTagsNames.at(0));
		}
	}
	
	QList<QStringList> tempSTN=_studentsNames;
	if(_studentsNames.count()<_nSplits){
		for(int i=0; i<_nSplits-_studentsNames.count(); i++){
			tempSTN.append(_studentsNames.at(0));
		}
	}
	
	QList<int> tempCNOS=_computedNumberOfStudents;
	if(_computedNumberOfStudents.count()<_nSplits){
		for(int i=0; i<_nSplits-_computedNumberOfStudents.count(); i++){
			tempCNOS.append(_computedNumberOfStudents.at(0));
		}
	}

	//check for duplicates - idea and code by Volker Dirr
	for(int i=0; i<_nSplits; i++){
		const QStringList& tl=tempTN.at(i);
		int t=QStringList(tl).removeDuplicates();
		if(t>0)
			RulesReconcilableMessage::warning(parent, tr("FET warning"), tr("The activity with id=%1 contains %2 duplicate teachers - please correct that")
			 .arg(_firstActivityId+i).arg(t));

		const QStringList& stl=tempSTN.at(i);
		t=QStringList(stl).removeDuplicates();
		if(t>0)
			RulesReconcilableMessage::warning(parent, tr("FET warning"), tr("The activity with id=%1 contains %2 duplicate students sets - please correct that")
			 .arg(_firstActivityId+i).arg(t));

		const QStringList& atl=tempATN.at(i);
		t=QStringList(atl).removeDuplicates();
		if(t>0)
			RulesReconcilableMessage::warning(parent, tr("FET warning"), tr("The activity with id=%1 contains %2 duplicate activity tags - please correct that")
			 .arg(_firstActivityId+i).arg(t));
	}

	assert(_firstActivityId==_activityGroupId);

	QList<int> acts;

	acts.clear();
	for(int i=0; i<_nSplits; i++){
		Activity *act=new Activity(*this, _firstActivityId+i, _activityGroupId,
		 tempTN.at(i), tempSN.at(i), tempATN.at(i), tempSTN.at(i),
		 _durations[i], _totalDuration, _active[i], _computeNTotalStudents, _nTotalStudents, /*_computedNumberOfStudents*/ tempCNOS.at(i));

		this->activitiesList << act; //append

		assert(!activitiesPointerHash.contains(act->id));
		activitiesPointerHash.insert(act->id, act);

		acts.append(_firstActivityId+i);
	}

	if(_minDayDistance>0){
		TimeConstraint *constr;
		if(!_halfDays)
			constr=new ConstraintMinDaysBetweenActivities(_weightPercentage, _consecutiveIfSameDay, _nSplits, acts, _minDayDistance);
		else
			constr=new ConstraintMinHalfDaysBetweenActivities(_weightPercentage, _consecutiveIfSameDay, _nSplits, acts, _minDayDistance);
		bool tmp=this->addTimeConstraint(constr);
		assert(tmp);
	}

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

/*void Rules::removeActivity(int _id)
{
	QList<int> tmpList;
	tmpList.append(_id);
	removeActivities(tmpList, true);
}*/

void Rules::removeActivity(int _id, int _activityGroupId)
{
	QList<int> tmpList;
	for(Activity* act : std::as_const(activitiesList))
		if(_id==act->id || (_activityGroupId>0 && _activityGroupId==act->activityGroupId))
			tmpList.append(act->id);
	removeActivities(tmpList, true);
}

void Rules::removeActivities(const QList<int>& _idsList, bool updateConstraints)
{
	if(_idsList.isEmpty())
		return;

	QSet<int> _removedIdsSet(_idsList.constBegin(), _idsList.constEnd());
	
	QSet<int> _groupIdsSet;
	for(Activity* act : std::as_const(activitiesList))
		if(act->activityGroupId>0 && _removedIdsSet.contains(act->id))
			_groupIdsSet.insert(act->activityGroupId);
	for(Activity* act : std::as_const(activitiesList))
		if(act->activityGroupId>0 && _groupIdsSet.contains(act->activityGroupId))
			_removedIdsSet.insert(act->id);
	
	ActivitiesList newActivitiesList;
	ActivitiesList toBeRemoved;
	
	for(int i=0; i<activitiesList.count(); i++){
		int id=activitiesList.at(i)->id;
		if(!_removedIdsSet.contains(id)){
			newActivitiesList.append(activitiesList[i]);
		}
		else{
			toBeRemoved.append(activitiesList[i]);

			assert(activitiesPointerHash.contains(id));
			activitiesPointerHash.remove(id);
			
			if(mdbaHash.contains(id)){
				int t=mdbaHash.remove(id);
				assert(t==1);
			}
			if(mhdbaHash.contains(id)){
				int t=mhdbaHash.remove(id);
				assert(t==1);
			}
		}
	}

	for(Activity* act : std::as_const(toBeRemoved))
		delete act;
	toBeRemoved.clear();
	//while(!toBeRemoved.isEmpty())
	//	delete toBeRemoved.takeFirst();
	
	activitiesList=newActivitiesList;
	
	updateGroupActivitiesInInitialOrderAfterRemoval();
	if(updateConstraints)
		updateConstraintsAfterRemoval();
	
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
}

void Rules::modifyActivity(
	int _id,
	int _activityGroupId,
	const QStringList& _teachersNames,
	const QString& _subjectName,
	const QStringList& _activityTagsNames,
	const QStringList& _studentsNames,
	//int _nTotalStudents,
	int _nSplits,
	int _totalDuration,
	const QList<int>& _durations,
	//int _parities[],
	const QList<bool>& _active,
	bool _computeNTotalStudents,
	int _nTotalStudents)
{
	int i=0;
	for(int j=0; j<this->activitiesList.size(); j++){
		Activity* act=this->activitiesList[j];
		if((_activityGroupId==0 && act->id==_id) || (_activityGroupId!=0 && act->activityGroupId==_activityGroupId)){
			act->teachersNames=_teachersNames;
			act->subjectName=_subjectName;
			act->activityTagsNames=_activityTagsNames;
			act->studentsNames=_studentsNames;
			act->duration=_durations[i];
			//act->parity=_parities[i];
			act->active=_active[i];
			act->totalDuration=_totalDuration;
			act->computeNTotalStudents=_computeNTotalStudents;
			act->nTotalStudents=_nTotalStudents;
			i++;
		}
	}
	
	assert(i==_nSplits);
	
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
}

void Rules::modifySubactivity(
	int _id,
	int _activityGroupId,
	const QStringList& _teachersNames,
	const QString& _subjectName,
	const QStringList& _activityTagsNames,
	const QStringList& _studentsNames,
	int _duration,
	bool _active,
	bool _computeNTotalStudents,
	int _nTotalStudents)
{
	QList<Activity*> actsList;
	Activity* crtAct=nullptr;
	
	for(Activity* act : std::as_const(this->activitiesList)){
		if(act->id==_id && act->activityGroupId==_activityGroupId){
			crtAct=act;
			//actsList.append(act);
		}
		else if(act->activityGroupId!=0 && _activityGroupId!=0 && act->activityGroupId==_activityGroupId){
			actsList.append(act);
		}
	}
	
	assert(crtAct!=nullptr);
	
	int td=0;
	for(Activity* act : std::as_const(actsList))
		td+=act->duration;
	td+=_duration; //crtAct->duration;
	for(Activity* act : std::as_const(actsList))
		act->totalDuration=td;

	crtAct->teachersNames=_teachersNames;
	crtAct->subjectName=_subjectName;
	crtAct->activityTagsNames=_activityTagsNames;
	crtAct->studentsNames=_studentsNames;
	crtAct->duration=_duration;
	crtAct->totalDuration=td;
	crtAct->active=_active;
	crtAct->computeNTotalStudents=_computeNTotalStudents;
	crtAct->nTotalStudents=_nTotalStudents;
	
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
}

bool Rules::addRoom(Room* rm)
{
	if(this->searchRoom(rm->name) >= 0)
		return false;
	this->roomsList << rm; //append
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

bool Rules::addRoomFast(Room* rm)
{
	this->roomsList << rm; //append
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

int Rules::searchRoom(const QString& roomName)
{
	for(int i=0; i<this->roomsList.size(); i++)
		if(this->roomsList[i]->name==roomName)
			return i;
	
	return -1;
}

bool Rules::removeRoom(const QString& roomName)
{
	int i=this->searchRoom(roomName);
	if(i<0)
		return false;

	Room* searchedRoom=this->roomsList[i];
	assert(searchedRoom->name==roomName);
	
	//the real room to be removed may be found in some virtual rooms' sets
	if(searchedRoom->isVirtual==false){
		for(Room* r : std::as_const(roomsList)){
			if(r->isVirtual==true){
				for(int j=0; j<r->realRoomsSetsList.count(); j++){
					QStringList& sl=r->realRoomsSetsList[j];
					if(sl.contains(roomName)){
						int t=sl.removeAll(roomName);
						assert(t==1);
					}
				}
			}
		}
	}
	
	for(SpaceConstraint* ctr : std::as_const(spaceConstraintsList)){
		switch(ctr->type){
			case CONSTRAINT_ACTIVITY_PREFERRED_ROOM:
				{
					ConstraintActivityPreferredRoom* c=(ConstraintActivityPreferredRoom*)ctr;
				
					if(c->preferredRealRoomsNames.contains(roomName))
						c->preferredRealRoomsNames.removeAll(roomName);
					
					break;
				}
			default:
				//do nothing.
				break;
		}
	}

	delete this->roomsList[i];
	this->roomsList.removeAt(i);

	updateConstraintsAfterRemoval();

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

bool Rules::modifyRoom(const QString& initialRoomName, const QString& finalRoomName, const QString& building, int capacity)
{
	int i=this->searchRoom(initialRoomName);
	if(i<0)
		return false;

	Room* searchedRoom=this->roomsList[i];
	assert(searchedRoom->name==initialRoomName);
	
	//the real room to be renamed may be found in some virtual rooms' sets
	if(initialRoomName!=finalRoomName){
		if(searchedRoom->isVirtual==false){
			for(Room* r : std::as_const(roomsList)){
				if(r->isVirtual==true){
					for(int j=0; j<r->realRoomsSetsList.count(); j++){
						QStringList& sl=r->realRoomsSetsList[j];
						for(int k=0; k<sl.count(); k++){
							if(sl[k]==initialRoomName){
								sl[k]=finalRoomName;
							}
						}
					}
				}
			}
		}
	}

	for(SpaceConstraint* ctr : std::as_const(spaceConstraintsList)){
		switch(ctr->type){
			case CONSTRAINT_ROOM_NOT_AVAILABLE_TIMES:
				{
					ConstraintRoomNotAvailableTimes* crna=(ConstraintRoomNotAvailableTimes*)ctr;
					if(crna->room==initialRoomName)
						crna->room=finalRoomName;
					break;
				}
			case CONSTRAINT_TEACHER_ROOM_NOT_AVAILABLE_TIMES:
				{
					ConstraintTeacherRoomNotAvailableTimes* crna=(ConstraintTeacherRoomNotAvailableTimes*)ctr;
					if(crna->room==initialRoomName)
						crna->room=finalRoomName;
					break;
				}
			case CONSTRAINT_ACTIVITY_PREFERRED_ROOM:
				{
					ConstraintActivityPreferredRoom* c=(ConstraintActivityPreferredRoom*)ctr;
					if(c->roomName==initialRoomName)
						c->roomName=finalRoomName;
						
					for(int i=0; i<c->preferredRealRoomsNames.count(); i++)
						if(c->preferredRealRoomsNames.at(i)==initialRoomName)
							c->preferredRealRoomsNames[i]=finalRoomName;
					break;
				}
			case CONSTRAINT_ACTIVITY_PREFERRED_ROOMS:
				{
					ConstraintActivityPreferredRooms* c=(ConstraintActivityPreferredRooms*)ctr;
					int t=0;
					for(QStringList::iterator it=c->roomsNames.begin(); it!=c->roomsNames.end(); it++){
						if((*it)==initialRoomName){
							*it=finalRoomName;
							t++;
						}
					}
					assert(t<=1);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_HOME_ROOM:
				{
					ConstraintStudentsSetHomeRoom* c=(ConstraintStudentsSetHomeRoom*)ctr;
					if(c->roomName==initialRoomName)
						c->roomName=finalRoomName;
					break;
				}
			case CONSTRAINT_STUDENTS_SET_HOME_ROOMS:
				{
					ConstraintStudentsSetHomeRooms* c=(ConstraintStudentsSetHomeRooms*)ctr;
					int t=0;
					for(QStringList::iterator it=c->roomsNames.begin(); it!=c->roomsNames.end(); it++){
						if((*it)==initialRoomName){
							*it=finalRoomName;
							t++;
						}
					}
					assert(t<=1);
					break;
				}
			case CONSTRAINT_TEACHER_HOME_ROOM:
				{
					ConstraintTeacherHomeRoom* c=(ConstraintTeacherHomeRoom*)ctr;
					if(c->roomName==initialRoomName)
						c->roomName=finalRoomName;
					break;
				}
			case CONSTRAINT_TEACHER_HOME_ROOMS:
				{
					ConstraintTeacherHomeRooms* c=(ConstraintTeacherHomeRooms*)ctr;
					int t=0;
					for(QStringList::iterator it=c->roomsNames.begin(); it!=c->roomsNames.end(); it++){
						if((*it)==initialRoomName){
							*it=finalRoomName;
							t++;
						}
					}
					assert(t<=1);
					break;
				}
			case CONSTRAINT_SUBJECT_PREFERRED_ROOM:
				{
					ConstraintSubjectPreferredRoom* c=(ConstraintSubjectPreferredRoom*)ctr;
					if(c->roomName==initialRoomName)
						c->roomName=finalRoomName;
					break;
				}
			case CONSTRAINT_SUBJECT_PREFERRED_ROOMS:
				{
					ConstraintSubjectPreferredRooms* c=(ConstraintSubjectPreferredRooms*)ctr;
					int t=0;
					for(QStringList::iterator it=c->roomsNames.begin(); it!=c->roomsNames.end(); it++){
						if((*it)==initialRoomName){
							*it=finalRoomName;
							t++;
						}
					}
					assert(t<=1);
					break;
				}
			case CONSTRAINT_SUBJECT_ACTIVITY_TAG_PREFERRED_ROOM:
				{
					ConstraintSubjectActivityTagPreferredRoom* c=(ConstraintSubjectActivityTagPreferredRoom*)ctr;
					if(c->roomName==initialRoomName)
						c->roomName=finalRoomName;
					break;
				}
			case CONSTRAINT_SUBJECT_ACTIVITY_TAG_PREFERRED_ROOMS:
				{
					ConstraintSubjectActivityTagPreferredRooms* c=(ConstraintSubjectActivityTagPreferredRooms*)ctr;
					int t=0;
					for(QStringList::iterator it=c->roomsNames.begin(); it!=c->roomsNames.end(); it++){
						if((*it)==initialRoomName){
							*it=finalRoomName;
							t++;
						}
					}
					assert(t<=1);
					break;
				}
			case CONSTRAINT_ACTIVITY_TAG_PREFERRED_ROOM:
				{
					ConstraintActivityTagPreferredRoom* c=(ConstraintActivityTagPreferredRoom*)ctr;
					if(c->roomName==initialRoomName)
						c->roomName=finalRoomName;
					break;
				}
			case CONSTRAINT_ACTIVITY_TAG_PREFERRED_ROOMS:
				{
					ConstraintActivityTagPreferredRooms* c=(ConstraintActivityTagPreferredRooms*)ctr;
					int t=0;
					for(QStringList::iterator it=c->roomsNames.begin(); it!=c->roomsNames.end(); it++){
						if((*it)==initialRoomName){
							*it=finalRoomName;
							t++;
						}
					}
					assert(t<=1);
					break;
				}
			case CONSTRAINT_ROOM_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintRoomMaxActivityTagsPerDayFromSet* crna=(ConstraintRoomMaxActivityTagsPerDayFromSet*)ctr;
					if(crna->room==initialRoomName)
						crna->room=finalRoomName;
					break;
				}
			case CONSTRAINT_ROOM_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintRoomMaxActivityTagsPerRealDayFromSet* crna=(ConstraintRoomMaxActivityTagsPerRealDayFromSet*)ctr;
					if(crna->room==initialRoomName)
						crna->room=finalRoomName;
					break;
				}
			case CONSTRAINT_ROOM_MAX_ACTIVITY_TAGS_PER_WEEK_FROM_SET:
				{
					ConstraintRoomMaxActivityTagsPerWeekFromSet* crna=(ConstraintRoomMaxActivityTagsPerWeekFromSet*)ctr;
					if(crna->room==initialRoomName)
						crna->room=finalRoomName;
					break;
				}

			default:
				//do nothing.
				break;
		}
	}

	searchedRoom->name=finalRoomName;
	searchedRoom->building=building;
	searchedRoom->capacity=capacity;

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

void Rules::sortRoomsAlphabetically()
{
	std::stable_sort(this->roomsList.begin(), this->roomsList.end(), roomsAscending);

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
}

bool Rules::addBuilding(Building* bu)
{
	if(this->searchBuilding(bu->name) >= 0)
		return false;
	this->buildingsList << bu; //append
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

bool Rules::addBuildingFast(Building* bu)
{
	this->buildingsList << bu; //append
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

int Rules::searchBuilding(const QString& buildingName)
{
	for(int i=0; i<this->buildingsList.size(); i++)
		if(this->buildingsList[i]->name==buildingName)
			return i;
	
	return -1;
}

bool Rules::removeBuilding(const QString& buildingName)
{
	for(Room* rm : std::as_const(this->roomsList))
		if(rm->building==buildingName)
			rm->building="";

	int i=this->searchBuilding(buildingName);
	if(i<0)
		return false;

	Building* searchedBuilding=this->buildingsList[i];
	assert(searchedBuilding->name==buildingName);

	delete this->buildingsList[i];
	this->buildingsList.removeAt(i);
	
	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

bool Rules::modifyBuilding(const QString& initialBuildingName, const QString& finalBuildingName)
{
	for(Room* rm : std::as_const(roomsList))
		if(rm->building==initialBuildingName)
			rm->building=finalBuildingName;

	int i=this->searchBuilding(initialBuildingName);
	if(i<0)
		return false;

	Building* searchedBuilding=this->buildingsList[i];
	assert(searchedBuilding->name==initialBuildingName);
	searchedBuilding->name=finalBuildingName;

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;

	return true;
}

void Rules::sortBuildingsAlphabetically()
{
	std::stable_sort(this->buildingsList.begin(), this->buildingsList.end(), buildingsAscending);

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
}

void Rules::recomputeActivitiesSetForTimeConstraint(TimeConstraint* ctr)
{
	switch(ctr->type){
		case CONSTRAINT_ACTIVITIES_SAME_STARTING_TIME:
			{
				ConstraintActivitiesSameStartingTime* c=(ConstraintActivitiesSameStartingTime*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_ACTIVITIES_NOT_OVERLAPPING:
			{
				ConstraintActivitiesNotOverlapping* c=(ConstraintActivitiesNotOverlapping*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_MIN_DAYS_BETWEEN_ACTIVITIES:
			{
				ConstraintMinDaysBetweenActivities* c=(ConstraintMinDaysBetweenActivities*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_MAX_DAYS_BETWEEN_ACTIVITIES:
			{
				ConstraintMaxDaysBetweenActivities* c=(ConstraintMaxDaysBetweenActivities*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_ACTIVITIES_MAX_HOURLY_SPAN:
			{
				ConstraintActivitiesMaxHourlySpan* c=(ConstraintActivitiesMaxHourlySpan*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_MIN_GAPS_BETWEEN_ACTIVITIES:
			{
				ConstraintMinGapsBetweenActivities* c=(ConstraintMinGapsBetweenActivities*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_MAX_GAPS_BETWEEN_ACTIVITIES:
			{
				ConstraintMaxGapsBetweenActivities* c=(ConstraintMaxGapsBetweenActivities*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_ACTIVITIES_SAME_STARTING_HOUR:
			{
				ConstraintActivitiesSameStartingHour* c=(ConstraintActivitiesSameStartingHour*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_ACTIVITIES_SAME_STARTING_DAY:
			{
				ConstraintActivitiesSameStartingDay* c=(ConstraintActivitiesSameStartingDay*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_TWO_SETS_OF_ACTIVITIES_ORDERED:
			{
				ConstraintTwoSetsOfActivitiesOrdered* c=(ConstraintTwoSetsOfActivitiesOrdered*) ctr;
				c->recomputeActivitiesSets();
				break;
			}
		case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_TIME_SLOTS_FROM_SELECTION:
			{
				ConstraintActivitiesOccupyMaxTimeSlotsFromSelection* c=(ConstraintActivitiesOccupyMaxTimeSlotsFromSelection*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_ACTIVITIES_OCCUPY_MIN_TIME_SLOTS_FROM_SELECTION:
			{
				ConstraintActivitiesOccupyMinTimeSlotsFromSelection* c=(ConstraintActivitiesOccupyMinTimeSlotsFromSelection*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_ACTIVITIES_MAX_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS:
			{
				ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots* c=(ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_ACTIVITIES_MIN_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS:
			{
				ConstraintActivitiesMinSimultaneousInSelectedTimeSlots* c=(ConstraintActivitiesMinSimultaneousInSelectedTimeSlots*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_MAX_TOTAL_ACTIVITIES_FROM_SET_IN_SELECTED_TIME_SLOTS:
			{
				ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots* c=(ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_ACTIVITIES_MAX_IN_A_TERM:
			{
				ConstraintActivitiesMaxInATerm* c=(ConstraintActivitiesMaxInATerm*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_TERMS:
			{
				ConstraintActivitiesOccupyMaxTerms* c=(ConstraintActivitiesOccupyMaxTerms*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_MIN_HALF_DAYS_BETWEEN_ACTIVITIES:
			{
				ConstraintMinHalfDaysBetweenActivities* c=(ConstraintMinHalfDaysBetweenActivities*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_ACTIVITIES_MIN_IN_A_TERM:
			{
				ConstraintActivitiesMinInATerm* c=(ConstraintActivitiesMinInATerm*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_MAX_TERMS_BETWEEN_ACTIVITIES:
			{
				ConstraintMaxTermsBetweenActivities* c=(ConstraintMaxTermsBetweenActivities*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_MAX_HALF_DAYS_BETWEEN_ACTIVITIES:
			{
				ConstraintMaxHalfDaysBetweenActivities* c=(ConstraintMaxHalfDaysBetweenActivities*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_TWO_SETS_OF_ACTIVITIES_SAME_SECTIONS:
			{
				ConstraintTwoSetsOfActivitiesSameSections* c=(ConstraintTwoSetsOfActivitiesSameSections*) ctr;
				c->recomputeActivitiesSets();
				break;
			}
		case CONSTRAINT_ACTIVITIES_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
			{
				ConstraintActivitiesPairOfMutuallyExclusiveSetsOfTimeSlots* c=(ConstraintActivitiesPairOfMutuallyExclusiveSetsOfTimeSlots*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_ACTIVITIES_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
			{
				ConstraintActivitiesPairOfMutuallyExclusiveTimeSlots* c=(ConstraintActivitiesPairOfMutuallyExclusiveTimeSlots*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_ACTIVITIES_OVERLAP_COMPLETELY_OR_DO_NOT_OVERLAP:
			{
				ConstraintActivitiesOverlapCompletelyOrDoNotOverlap* c=(ConstraintActivitiesOverlapCompletelyOrDoNotOverlap*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
			{
				ConstraintActivitiesOccupyMaxSetsOfTimeSlotsFromSelection* c=(ConstraintActivitiesOccupyMaxSetsOfTimeSlotsFromSelection*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_ACTIVITIES_MAX_TOTAL_NUMBER_OF_STUDENTS_IN_SELECTED_TIME_SLOTS:
			{
				ConstraintActivitiesMaxTotalNumberOfStudentsInSelectedTimeSlots* c=(ConstraintActivitiesMaxTotalNumberOfStudentsInSelectedTimeSlots*) ctr;
				c->recomputeActivitiesSet();
				break;
			}

		default:
			//do nothing.
			break;
	}
}

void Rules::insertTimeConstraintInHash(TimeConstraint* ctr)
{
	switch(ctr->type){
		case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIME:
			{
				ConstraintActivityPreferredStartingTime* c=(ConstraintActivityPreferredStartingTime*) ctr;
				QSet<ConstraintActivityPreferredStartingTime*> cs=apstHash.value(c->activityId, QSet<ConstraintActivityPreferredStartingTime*>());
				assert(!cs.contains(c));
				cs.insert(c);
				apstHash.insert(c->activityId, cs);
				break;
			}

		case CONSTRAINT_ACTIVITY_PREFERRED_DAY:
			{
				ConstraintActivityPreferredDay* c=(ConstraintActivityPreferredDay*) ctr;
				QSet<ConstraintActivityPreferredDay*> cs=apdHash.value(c->activityId, QSet<ConstraintActivityPreferredDay*>());
				assert(!cs.contains(c));
				cs.insert(c);
				apdHash.insert(c->activityId, cs);
				break;
			}

		case CONSTRAINT_MIN_DAYS_BETWEEN_ACTIVITIES:
			{
				ConstraintMinDaysBetweenActivities* c=(ConstraintMinDaysBetweenActivities*) ctr;
				for(int aid : std::as_const(c->activitiesIds)){
					QSet<ConstraintMinDaysBetweenActivities*> cs=mdbaHash.value(aid, QSet<ConstraintMinDaysBetweenActivities*>());
					assert(!cs.contains(c));
					cs.insert(c);
					mdbaHash.insert(aid, cs);
				}
				break;
			}

		case CONSTRAINT_MIN_HALF_DAYS_BETWEEN_ACTIVITIES:
			{
				ConstraintMinHalfDaysBetweenActivities* c=(ConstraintMinHalfDaysBetweenActivities*) ctr;
				for(int aid : std::as_const(c->activitiesIds)){
					QSet<ConstraintMinHalfDaysBetweenActivities*> cs=mhdbaHash.value(aid, QSet<ConstraintMinHalfDaysBetweenActivities*>());
					assert(!cs.contains(c));
					cs.insert(c);
					mhdbaHash.insert(aid, cs);
				}
				break;
			}

		case CONSTRAINT_TEACHER_NOT_AVAILABLE_TIMES:
			{
				ConstraintTeacherNotAvailableTimes* c=(ConstraintTeacherNotAvailableTimes*) ctr;
				QSet<ConstraintTeacherNotAvailableTimes*> cs=tnatHash.value(c->teacher, QSet<ConstraintTeacherNotAvailableTimes*>());
				assert(!cs.contains(c));
				cs.insert(c);
				tnatHash.insert(c->teacher, cs);
				break;
			}

		case CONSTRAINT_STUDENTS_SET_NOT_AVAILABLE_TIMES:
			{
				ConstraintStudentsSetNotAvailableTimes* c=(ConstraintStudentsSetNotAvailableTimes*) ctr;
				QSet<ConstraintStudentsSetNotAvailableTimes*> cs=ssnatHash.value(c->students, QSet<ConstraintStudentsSetNotAvailableTimes*>());
				assert(!cs.contains(c));
				cs.insert(c);
				ssnatHash.insert(c->students, cs);
				break;
			}
		case CONSTRAINT_BASIC_COMPULSORY_TIME:
			{
				ConstraintBasicCompulsoryTime* c=(ConstraintBasicCompulsoryTime*) ctr;
				QSet<ConstraintBasicCompulsoryTime*> &cs=bctSet;
				assert(!cs.contains(c));
				cs.insert(c);
				break;
			}
		case CONSTRAINT_BREAK_TIMES:
			{
				ConstraintBreakTimes* c=(ConstraintBreakTimes*) ctr;
				QSet<ConstraintBreakTimes*> &cs=btSet;
				assert(!cs.contains(c));
				cs.insert(c);
				break;
			}
		default:
			//do nothing.
			break;
	}
}

bool Rules::addTimeConstraint(TimeConstraint* ctr)
{
	bool ok=true;

	//TODO: improve this

	switch(ctr->type){
		//check if this constraint is already added, for ConstraintActivityPreferredStartingTime
		case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIME:
			{
				ConstraintActivityPreferredStartingTime* c=(ConstraintActivityPreferredStartingTime*) ctr;
				QSet<ConstraintActivityPreferredStartingTime*> cs=apstHash.value(c->activityId, QSet<ConstraintActivityPreferredStartingTime*>());
				for(ConstraintActivityPreferredStartingTime* oldc : std::as_const(cs)){
					if((*oldc)==(*c)){
						ok=false;
						break;
					}
				}
				break;
			}

		//check if this constraint is already added, for ConstraintActivityPreferredDay
		case CONSTRAINT_ACTIVITY_PREFERRED_DAY:
			{
				ConstraintActivityPreferredDay* c=(ConstraintActivityPreferredDay*) ctr;
				QSet<ConstraintActivityPreferredDay*> cs=apdHash.value(c->activityId, QSet<ConstraintActivityPreferredDay*>());
				for(ConstraintActivityPreferredDay* oldc : std::as_const(cs)){
					if((*oldc)==(*c)){
						ok=false;
						break;
					}
				}
				break;
			}

		//check if this constraint is already added, for ConstraintMinDaysBetweenActivities
		case CONSTRAINT_MIN_DAYS_BETWEEN_ACTIVITIES:
			{
				ConstraintMinDaysBetweenActivities* c=(ConstraintMinDaysBetweenActivities*) ctr;
				for(int aid : std::as_const(c->activitiesIds)){
					QSet<ConstraintMinDaysBetweenActivities*> cs=mdbaHash.value(aid, QSet<ConstraintMinDaysBetweenActivities*>());
					for(ConstraintMinDaysBetweenActivities* oldc : std::as_const(cs)){
						if((*oldc)==(*c)){
							ok=false;
							break;
						}
					}
					if(!ok)
						break;
				}
				break;
			}

		//check if this constraint is already added, for ConstraintMinHalfDaysBetweenActivities
		case CONSTRAINT_MIN_HALF_DAYS_BETWEEN_ACTIVITIES:
			{
				ConstraintMinHalfDaysBetweenActivities* c=(ConstraintMinHalfDaysBetweenActivities*) ctr;
				for(int aid : std::as_const(c->activitiesIds)){
					QSet<ConstraintMinHalfDaysBetweenActivities*> cs=mhdbaHash.value(aid, QSet<ConstraintMinHalfDaysBetweenActivities*>());
					for(ConstraintMinHalfDaysBetweenActivities* oldc : std::as_const(cs)){
						if((*oldc)==(*c)){
							ok=false;
							break;
						}
					}
					if(!ok)
						break;
				}
				break;
			}

		case CONSTRAINT_STUDENTS_SET_NOT_AVAILABLE_TIMES:
			{
				ConstraintStudentsSetNotAvailableTimes* c=(ConstraintStudentsSetNotAvailableTimes*) ctr;
				QSet<ConstraintStudentsSetNotAvailableTimes*> cs=ssnatHash.value(c->students, QSet<ConstraintStudentsSetNotAvailableTimes*>());
				for(ConstraintStudentsSetNotAvailableTimes* oldc : std::as_const(cs)){
					if(oldc->students==c->students){
						ok=false;
						break;
					}
				}
				break;
			}

		case CONSTRAINT_TEACHER_NOT_AVAILABLE_TIMES:
			{
				ConstraintTeacherNotAvailableTimes* c=(ConstraintTeacherNotAvailableTimes*) ctr;
				QSet<ConstraintTeacherNotAvailableTimes*> cs=tnatHash.value(c->teacher, QSet<ConstraintTeacherNotAvailableTimes*>());
				for(ConstraintTeacherNotAvailableTimes* oldc : std::as_const(cs)){
					if(oldc->teacher==c->teacher){
						ok=false;
						break;
					}
				}
				break;
			}

		case CONSTRAINT_BREAK_TIMES:
			{
				QSet<ConstraintBreakTimes*> cs=btSet;
				if(cs.count()>0)
					ok=false;
				break;
			}

		case CONSTRAINT_BASIC_COMPULSORY_TIME:
			{
				QSet<ConstraintBasicCompulsoryTime*> cs=bctSet;
				if(cs.count()>0)
					ok=false;
				break;
			}
		default:
			//do nothing.
			break;
	}
	
	if(ok){
		recomputeActivitiesSetForTimeConstraint(ctr);
		
		this->timeConstraintsList << ctr; //append

		insertTimeConstraintInHash(ctr);

		this->internalStructureComputed=false;
		setRulesModifiedAndOtherThings(this);

		return true;
	}
	else
		return false;
}

bool Rules::removeTimeConstraint(TimeConstraint* ctr)
{
	for(int i=0; i<this->timeConstraintsList.size(); i++){
		if(this->timeConstraintsList[i]==ctr){
			switch(ctr->type){
				case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIME:
					{
						ConstraintActivityPreferredStartingTime* c=(ConstraintActivityPreferredStartingTime*) ctr;
						QSet<ConstraintActivityPreferredStartingTime*> cs=apstHash.value(c->activityId, QSet<ConstraintActivityPreferredStartingTime*>());
						assert(cs.contains(c));
						cs.remove(c);
						if(!cs.isEmpty()){
							apstHash.insert(c->activityId, cs);
						}
						else{
							int t=apstHash.remove(c->activityId);
							assert(t==1);
						}
						break;
					}

				case CONSTRAINT_ACTIVITY_PREFERRED_DAY:
					{
						ConstraintActivityPreferredDay* c=(ConstraintActivityPreferredDay*) ctr;
						QSet<ConstraintActivityPreferredDay*> cs=apdHash.value(c->activityId, QSet<ConstraintActivityPreferredDay*>());
						assert(cs.contains(c));
						cs.remove(c);
						if(!cs.isEmpty()){
							apdHash.insert(c->activityId, cs);
						}
						else{
							int t=apdHash.remove(c->activityId);
							assert(t==1);
						}
						break;
					}

				case CONSTRAINT_MIN_DAYS_BETWEEN_ACTIVITIES:
					{
						ConstraintMinDaysBetweenActivities* c=(ConstraintMinDaysBetweenActivities*) ctr;
						for(int aid : std::as_const(c->activitiesIds)){
							QSet<ConstraintMinDaysBetweenActivities*> cs=mdbaHash.value(aid, QSet<ConstraintMinDaysBetweenActivities*>());
							assert(cs.contains(c));
							cs.remove(c);
							if(!cs.isEmpty()){
								mdbaHash.insert(aid, cs);
							}
							else{
								int t=mdbaHash.remove(aid);
								assert(t==1);
							}
						}
						break;
					}

				case CONSTRAINT_MIN_HALF_DAYS_BETWEEN_ACTIVITIES:
					{
						ConstraintMinHalfDaysBetweenActivities* c=(ConstraintMinHalfDaysBetweenActivities*) ctr;
						for(int aid : std::as_const(c->activitiesIds)){
							QSet<ConstraintMinHalfDaysBetweenActivities*> cs=mhdbaHash.value(aid, QSet<ConstraintMinHalfDaysBetweenActivities*>());
							assert(cs.contains(c));
							cs.remove(c);
							if(!cs.isEmpty()){
								mhdbaHash.insert(aid, cs);
							}
							else{
								int t=mhdbaHash.remove(aid);
								assert(t==1);
							}
						}
						break;
					}

				case CONSTRAINT_TEACHER_NOT_AVAILABLE_TIMES:
					{
						ConstraintTeacherNotAvailableTimes* c=(ConstraintTeacherNotAvailableTimes*) ctr;
						QSet<ConstraintTeacherNotAvailableTimes*> cs=tnatHash.value(c->teacher, QSet<ConstraintTeacherNotAvailableTimes*>());
						assert(cs.contains(c));
						cs.remove(c);
						if(!cs.isEmpty()){
							assert(0);
							tnatHash.insert(c->teacher, cs);
						}
						else{
							int t=tnatHash.remove(c->teacher);
							assert(t==1);
						}
						break;
					}

				case CONSTRAINT_STUDENTS_SET_NOT_AVAILABLE_TIMES:
					{
						ConstraintStudentsSetNotAvailableTimes* c=(ConstraintStudentsSetNotAvailableTimes*) ctr;
						QSet<ConstraintStudentsSetNotAvailableTimes*> cs=ssnatHash.value(c->students, QSet<ConstraintStudentsSetNotAvailableTimes*>());
						assert(cs.contains(c));
						cs.remove(c);
						if(!cs.isEmpty()){
							assert(0);
							ssnatHash.insert(c->students, cs);
						}
						else{
							int t=ssnatHash.remove(c->students);
							assert(t==1);
						}
						break;
					}
				case CONSTRAINT_BASIC_COMPULSORY_TIME:
					{
						ConstraintBasicCompulsoryTime* c=(ConstraintBasicCompulsoryTime*) ctr;
						QSet<ConstraintBasicCompulsoryTime*> &cs=bctSet;
						assert(cs.contains(c));
						cs.remove(c);
						break;
					}
				case CONSTRAINT_BREAK_TIMES:
					{
						ConstraintBreakTimes* c=(ConstraintBreakTimes*) ctr;
						QSet<ConstraintBreakTimes*> &cs=btSet;
						assert(cs.contains(c));
						cs.remove(c);
						break;
					}
				default:
					//do nothing.
					break;
			}

			delete ctr;
			this->timeConstraintsList.removeAt(i);
			this->internalStructureComputed=false;
			setRulesModifiedAndOtherThings(this);

			return true;
		}
	}

	return false;
}

bool Rules::removeTimeConstraints(const QList<TimeConstraint*>& _tcl)
{
	if(_tcl.isEmpty())
		return true;

	QSet<TimeConstraint*> _tcs(_tcl.constBegin(), _tcl.constEnd());
	QList<TimeConstraint*> remaining;

	for(int i=0; i<this->timeConstraintsList.size(); i++){
		TimeConstraint* ctr=timeConstraintsList[i];
		if(_tcs.contains(ctr)){
			switch(ctr->type){
				case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIME:
					{
						ConstraintActivityPreferredStartingTime* c=(ConstraintActivityPreferredStartingTime*) ctr;
						QSet<ConstraintActivityPreferredStartingTime*> cs=apstHash.value(c->activityId, QSet<ConstraintActivityPreferredStartingTime*>());
						assert(cs.contains(c));
						cs.remove(c);
						if(!cs.isEmpty()){
							apstHash.insert(c->activityId, cs);
						}
						else{
							int t=apstHash.remove(c->activityId);
							assert(t==1);
						}
						break;
					}

				case CONSTRAINT_ACTIVITY_PREFERRED_DAY:
					{
						ConstraintActivityPreferredDay* c=(ConstraintActivityPreferredDay*) ctr;
						QSet<ConstraintActivityPreferredDay*> cs=apdHash.value(c->activityId, QSet<ConstraintActivityPreferredDay*>());
						assert(cs.contains(c));
						cs.remove(c);
						if(!cs.isEmpty()){
							apdHash.insert(c->activityId, cs);
						}
						else{
							int t=apdHash.remove(c->activityId);
							assert(t==1);
						}
						break;
					}

				case CONSTRAINT_MIN_DAYS_BETWEEN_ACTIVITIES:
					{
						ConstraintMinDaysBetweenActivities* c=(ConstraintMinDaysBetweenActivities*) ctr;
						for(int aid : std::as_const(c->activitiesIds)){
							QSet<ConstraintMinDaysBetweenActivities*> cs=mdbaHash.value(aid, QSet<ConstraintMinDaysBetweenActivities*>());
							assert(cs.contains(c));
							cs.remove(c);
							if(!cs.isEmpty()){
								mdbaHash.insert(aid, cs);
							}
							else{
								int t=mdbaHash.remove(aid);
								assert(t==1);
							}
						}
						break;
					}

				case CONSTRAINT_MIN_HALF_DAYS_BETWEEN_ACTIVITIES:
					{
						ConstraintMinHalfDaysBetweenActivities* c=(ConstraintMinHalfDaysBetweenActivities*) ctr;
						for(int aid : std::as_const(c->activitiesIds)){
							QSet<ConstraintMinHalfDaysBetweenActivities*> cs=mhdbaHash.value(aid, QSet<ConstraintMinHalfDaysBetweenActivities*>());
							assert(cs.contains(c));
							cs.remove(c);
							if(!cs.isEmpty()){
								mhdbaHash.insert(aid, cs);
							}
							else{
								int t=mhdbaHash.remove(aid);
								assert(t==1);
							}
						}
						break;
					}

				case CONSTRAINT_TEACHER_NOT_AVAILABLE_TIMES:
					{
						ConstraintTeacherNotAvailableTimes* c=(ConstraintTeacherNotAvailableTimes*) ctr;
						QSet<ConstraintTeacherNotAvailableTimes*> cs=tnatHash.value(c->teacher, QSet<ConstraintTeacherNotAvailableTimes*>());
						assert(cs.contains(c));
						cs.remove(c);
						if(!cs.isEmpty()){
							assert(0);
							tnatHash.insert(c->teacher, cs);
						}
						else{
							int t=tnatHash.remove(c->teacher);
							assert(t==1);
						}
						break;
					}

				case CONSTRAINT_STUDENTS_SET_NOT_AVAILABLE_TIMES:
					{
						ConstraintStudentsSetNotAvailableTimes* c=(ConstraintStudentsSetNotAvailableTimes*) ctr;
						QSet<ConstraintStudentsSetNotAvailableTimes*> cs=ssnatHash.value(c->students, QSet<ConstraintStudentsSetNotAvailableTimes*>());
						assert(cs.contains(c));
						cs.remove(c);
						if(!cs.isEmpty()){
							assert(0);
							ssnatHash.insert(c->students, cs);
						}
						else{
							int t=ssnatHash.remove(c->students);
							assert(t==1);
						}
						break;
					}
				case CONSTRAINT_BASIC_COMPULSORY_TIME:
					{
						ConstraintBasicCompulsoryTime* c=(ConstraintBasicCompulsoryTime*) ctr;
						QSet<ConstraintBasicCompulsoryTime*> &cs=bctSet;
						assert(cs.contains(c));
						cs.remove(c);
						break;
					}
				case CONSTRAINT_BREAK_TIMES:
					{
						ConstraintBreakTimes* c=(ConstraintBreakTimes*) ctr;
						QSet<ConstraintBreakTimes*> &cs=btSet;
						assert(cs.contains(c));
						cs.remove(c);
						break;
					}
				default:
					//do nothing.
					break;
			}
	
			//_tcs.remove(ctr);
			delete ctr;
		}
		else
			remaining.append(ctr);
	}
	
	bool ok;
	assert(timeConstraintsList.count()<=remaining.count()+_tcs.count());
	if(timeConstraintsList.count()==remaining.count()+_tcs.count())
		ok=true;
	else
		ok=false;

	if(remaining.count()!=timeConstraintsList.count()){
		timeConstraintsList=remaining;
	
		this->internalStructureComputed=false;
		setRulesModifiedAndOtherThings(this);
	}

	return ok;
}

void Rules::recomputeActivitiesSetForSpaceConstraint(SpaceConstraint* ctr)
{
	switch(ctr->type){
		case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_DIFFERENT_ROOMS:
			{
				ConstraintActivitiesOccupyMaxDifferentRooms* c=(ConstraintActivitiesOccupyMaxDifferentRooms*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		case CONSTRAINT_ACTIVITIES_SAME_ROOM_IF_CONSECUTIVE:
			{
				ConstraintActivitiesSameRoomIfConsecutive* c=(ConstraintActivitiesSameRoomIfConsecutive*) ctr;
				c->recomputeActivitiesSet();
				break;
			}
		default:
			//do nothing.
			break;
	}
}

void Rules::insertSpaceConstraintInHash(SpaceConstraint* ctr)
{
	switch(ctr->type){
		case CONSTRAINT_ACTIVITY_PREFERRED_ROOM:
			{
				ConstraintActivityPreferredRoom* c=(ConstraintActivityPreferredRoom*) ctr;
				QSet<ConstraintActivityPreferredRoom*> cs=aprHash.value(c->activityId, QSet<ConstraintActivityPreferredRoom*>());
				assert(!cs.contains(c));
				cs.insert(c);
				aprHash.insert(c->activityId, cs);
				break;
			}
		case CONSTRAINT_BASIC_COMPULSORY_SPACE:
			{
				ConstraintBasicCompulsorySpace* c=(ConstraintBasicCompulsorySpace*) ctr;
				QSet<ConstraintBasicCompulsorySpace*> &cs=bcsSet;
				assert(!cs.contains(c));
				cs.insert(c);
				break;
			}
		default:
			//do nothing.
			break;
	}
}

bool Rules::addSpaceConstraint(SpaceConstraint* ctr)
{
	bool ok=true;

	//TODO: check if this constraint is already added...(if any possibility of duplicates)
	switch(ctr->type){
		case CONSTRAINT_ACTIVITY_PREFERRED_ROOM:
			{
				ConstraintActivityPreferredRoom* c=(ConstraintActivityPreferredRoom*) ctr;
				QSet<ConstraintActivityPreferredRoom*> cs=aprHash.value(c->activityId, QSet<ConstraintActivityPreferredRoom*>());
				for(ConstraintActivityPreferredRoom* oldc : std::as_const(cs)){
					if((*oldc)==(*c)){
						ok=false;
						break;
					}
				}
				break;
			}
		case CONSTRAINT_BASIC_COMPULSORY_SPACE:
			{
				QSet<ConstraintBasicCompulsorySpace*> cs=bcsSet;
				if(cs.count()>0)
					ok=false;
				break;
			}
		default:
			//do nothing.
			break;
	}

	if(ok){
		recomputeActivitiesSetForSpaceConstraint(ctr);
	
		this->spaceConstraintsList << ctr; //append

		insertSpaceConstraintInHash(ctr);
		
		this->internalStructureComputed=false;
		setRulesModifiedAndOtherThings(this);

		return true;
	}
	else
		return false;
}

bool Rules::removeSpaceConstraint(SpaceConstraint* ctr)
{
	for(int i=0; i<this->spaceConstraintsList.size(); i++){
		if(this->spaceConstraintsList[i]==ctr){
			switch(ctr->type){
				case CONSTRAINT_ACTIVITY_PREFERRED_ROOM:
					{
						ConstraintActivityPreferredRoom* c=(ConstraintActivityPreferredRoom*) ctr;
						QSet<ConstraintActivityPreferredRoom*> cs=aprHash.value(c->activityId, QSet<ConstraintActivityPreferredRoom*>());
						assert(cs.contains(c));
						cs.remove(c);
						aprHash.insert(c->activityId, cs);
						break;
					}

				case CONSTRAINT_BASIC_COMPULSORY_SPACE:
					{
						ConstraintBasicCompulsorySpace* c=(ConstraintBasicCompulsorySpace*) ctr;
						QSet<ConstraintBasicCompulsorySpace*> &cs=bcsSet;
						assert(cs.contains(c));
						cs.remove(c);
						break;
					}
				default:
					//do nothing.
					break;
			}
	
			delete ctr;
			this->spaceConstraintsList.removeAt(i);
			this->internalStructureComputed=false;
			setRulesModifiedAndOtherThings(this);

			return true;
		}
	}

	return false;
}

bool Rules::removeSpaceConstraints(const QList<SpaceConstraint*>& _scl)
{
	if(_scl.isEmpty())
		return true;

	QSet<SpaceConstraint*> _scs(_scl.constBegin(), _scl.constEnd());
	QList<SpaceConstraint*> remaining;

	for(int i=0; i<this->spaceConstraintsList.size(); i++){
		SpaceConstraint* ctr=spaceConstraintsList[i];
		if(_scs.contains(ctr)){
			switch(ctr->type){
				case CONSTRAINT_ACTIVITY_PREFERRED_ROOM:
					{
						ConstraintActivityPreferredRoom* c=(ConstraintActivityPreferredRoom*) ctr;
						QSet<ConstraintActivityPreferredRoom*> cs=aprHash.value(c->activityId, QSet<ConstraintActivityPreferredRoom*>());
						assert(cs.contains(c));
						cs.remove(c);
						aprHash.insert(c->activityId, cs);
						break;
					}

				case CONSTRAINT_BASIC_COMPULSORY_SPACE:
					{
						ConstraintBasicCompulsorySpace* c=(ConstraintBasicCompulsorySpace*) ctr;
						QSet<ConstraintBasicCompulsorySpace*> &cs=bcsSet;
						assert(cs.contains(c));
						cs.remove(c);
						break;
					}
				default:
					//do nothing.
					break;
			}

			//_scs.remove(ctr);
			delete ctr;
		}
		else
			remaining.append(ctr);
	}

	bool ok;
	assert(spaceConstraintsList.count()<=remaining.count()+_scs.count());
	if(spaceConstraintsList.count()==remaining.count()+_scs.count())
		ok=true;
	else
		ok=false;
	
	if(remaining.count()!=spaceConstraintsList.count()){
		spaceConstraintsList=remaining;
		
		this->internalStructureComputed=false;
		setRulesModifiedAndOtherThings(this);
	}
	
	return ok;
}

void Rules::updateGroupActivitiesInInitialOrderAfterRemoval()
{
	GroupActivitiesInInitialOrderList newList;
	GroupActivitiesInInitialOrderList toBeRemovedList;
	
	for(GroupActivitiesInInitialOrderItem* item : std::as_const(groupActivitiesInInitialOrderList)){
		item->removeUseless(*this);
		if(item->ids.count()<2)
			toBeRemovedList.append(item);
		else
			newList.append(item);
	}
	
	groupActivitiesInInitialOrderList=newList;
	
	for(GroupActivitiesInInitialOrderItem* ga : std::as_const(toBeRemovedList))
		delete ga;
	toBeRemovedList.clear();
	//while(!toBeRemovedList.isEmpty())
	//	delete toBeRemovedList.takeFirst();

	for(GroupActivitiesInInitialOrderItem* item : std::as_const(groupActivitiesInInitialOrderList))
		item->recomputeActivitiesSet();
}

void Rules::updateActivitiesWhenRemovingStudents(const QSet<StudentsSet*>& studentsSets, bool updateConstraints)
{
	if(studentsSets.count()==0)
		return;

	QList<int> toBeRemovedIds;

	QHash<QString, int> numberOfStudentsPerSet;
	
	for(StudentsSet* studentsSet : std::as_const(studentsSets))
		numberOfStudentsPerSet.insert(studentsSet->name, studentsSet->numberOfStudents);
		
	for(Activity* act : std::as_const(activitiesList)){
		QStringList newStudents;
		for(const QString& st : std::as_const(act->studentsNames)){
			if(!numberOfStudentsPerSet.contains(st)){
				newStudents.append(st);
			}
			else{
				if(act->computeNTotalStudents){
					act->nTotalStudents-=numberOfStudentsPerSet.value(st);
					assert(act->nTotalStudents>=0);
				}
			}
		}
		if(act->studentsNames.count()>0 && newStudents.count()==0)
			toBeRemovedIds.append(act->id);
		act->studentsNames=newStudents;
	}
	
	removeActivities(toBeRemovedIds, updateConstraints);
}

void Rules::updateConstraintsAfterRemoval()
{
	bool recomputeTime=false;
	bool recomputeSpace=false;

	QSet<int> existingActivitiesIds;
	QSet<QString> existingTeachersNames;
	//QSet<QString> existingStudentsNames;
	QSet<QString> existingSubjectsNames;
	QSet<QString> existingActivityTagsNames;
	QSet<QString> existingRoomsNames;
	
	QList<TimeConstraint*> toBeRemovedTime;
	QList<SpaceConstraint*> toBeRemovedSpace;
	
	for(Activity* act : std::as_const(activitiesList))
		existingActivitiesIds.insert(act->id);
		
	for(Teacher* tch : std::as_const(teachersList))
		existingTeachersNames.insert(tch->name);
		
	for(Subject* sbj : std::as_const(subjectsList))
		existingSubjectsNames.insert(sbj->name);
		
	for(ActivityTag* at : std::as_const(activityTagsList))
		existingActivityTagsNames.insert(at->name);
		
	for(Room* rm : std::as_const(roomsList))
		existingRoomsNames.insert(rm->name);
		
	for(TimeConstraint* tc : std::as_const(timeConstraintsList)){
		switch(tc->type){
			case CONSTRAINT_TEACHER_NOT_AVAILABLE_TIMES:
				{
					ConstraintTeacherNotAvailableTimes* c=(ConstraintTeacherNotAvailableTimes*)tc;
					if(!existingTeachersNames.contains(c->teacher))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_NOT_AVAILABLE_TIMES:
				{
					ConstraintStudentsSetNotAvailableTimes* c=(ConstraintStudentsSetNotAvailableTimes*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_SAME_STARTING_TIME:
				{
					ConstraintActivitiesSameStartingTime* c=(ConstraintActivitiesSameStartingTime*)tc;
					c->removeUseless(*this);
					if(c->n_activities<2)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_NOT_OVERLAPPING:
				{
					ConstraintActivitiesNotOverlapping* c=(ConstraintActivitiesNotOverlapping*)tc;
					c->removeUseless(*this);
					if(c->n_activities<2)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITY_TAGS_NOT_OVERLAPPING:
				{
					ConstraintActivityTagsNotOverlapping* c=(ConstraintActivityTagsNotOverlapping*)tc;

					QStringList atl;
					for(const QString& at : std::as_const(c->activityTagsNames))
						if(existingActivityTagsNames.contains(at))
							atl.append(at);
					c->activityTagsNames=atl;

					if(c->activityTagsNames.count()<2)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_MIN_DAYS_BETWEEN_ACTIVITIES:
				{
					ConstraintMinDaysBetweenActivities* c=(ConstraintMinDaysBetweenActivities*)tc;
					c->removeUseless(*this);
					if(c->n_activities<2)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_MIN_HALF_DAYS_BETWEEN_ACTIVITIES:
				{
					ConstraintMinHalfDaysBetweenActivities* c=(ConstraintMinHalfDaysBetweenActivities*)tc;
					c->removeUseless(*this);
					if(c->n_activities<2)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_MAX_DAYS_BETWEEN_ACTIVITIES:
				{
					ConstraintMaxDaysBetweenActivities* c=(ConstraintMaxDaysBetweenActivities*)tc;
					c->removeUseless(*this);
					if(c->n_activities<2)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_MAX_HOURLY_SPAN:
				{
					ConstraintActivitiesMaxHourlySpan* c=(ConstraintActivitiesMaxHourlySpan*)tc;
					c->removeUseless(*this);
					if(c->n_activities<2)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_MAX_HALF_DAYS_BETWEEN_ACTIVITIES:
				{
					ConstraintMaxHalfDaysBetweenActivities* c=(ConstraintMaxHalfDaysBetweenActivities*)tc;
					c->removeUseless(*this);
					if(c->n_activities<2)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_MAX_TERMS_BETWEEN_ACTIVITIES:
				{
					ConstraintMaxTermsBetweenActivities* c=(ConstraintMaxTermsBetweenActivities*)tc;
					c->removeUseless(*this);
					if(c->n_activities<2)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_MIN_GAPS_BETWEEN_ACTIVITIES:
				{
					ConstraintMinGapsBetweenActivities* c=(ConstraintMinGapsBetweenActivities*)tc;
					c->removeUseless(*this);
					if(c->n_activities<2)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_MAX_GAPS_BETWEEN_ACTIVITIES:
				{
					ConstraintMaxGapsBetweenActivities* c=(ConstraintMaxGapsBetweenActivities*)tc;
					c->removeUseless(*this);
					if(c->n_activities<2)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_HOURS_DAILY:
				{
					ConstraintTeacherMaxHoursDaily* c=(ConstraintTeacherMaxHoursDaily*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintTeacherMaxHoursContinuously* c=(ConstraintTeacherMaxHoursContinuously*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintTeachersActivityTagMaxHoursContinuously* c=(ConstraintTeachersActivityTagMaxHoursContinuously*)tc;
					if(!existingActivityTagsNames.contains(c->activityTagName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintTeacherActivityTagMaxHoursContinuously* c=(ConstraintTeacherActivityTagMaxHoursContinuously*)tc;
					if(!existingActivityTagsNames.contains(c->activityTagName) || !existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeacherMaxDaysPerWeek* c=(ConstraintTeacherMaxDaysPerWeek*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_NO_TWO_CONSECUTIVE_DAYS:
				{
					ConstraintTeacherNoTwoConsecutiveDays* c=(ConstraintTeacherNoTwoConsecutiveDays*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_THREE_CONSECUTIVE_DAYS:
				{
					ConstraintTeacherMaxThreeConsecutiveDays* c=(ConstraintTeacherMaxThreeConsecutiveDays*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MIN_DAYS_PER_WEEK:
				{
					ConstraintTeacherMinDaysPerWeek* c=(ConstraintTeacherMinDaysPerWeek*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_WEEK:
				{
					ConstraintStudentsSetMaxGapsPerWeek* c=(ConstraintStudentsSetMaxGapsPerWeek*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_WEEK:
				{
					ConstraintTeacherMaxGapsPerWeek* c=(ConstraintTeacherMaxGapsPerWeek*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_DAY:
				{
					ConstraintTeacherMaxGapsPerDay* c=(ConstraintTeacherMaxGapsPerDay*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_MORNING_AND_AFTERNOON:
				{
					ConstraintTeacherMaxGapsPerMorningAndAfternoon* c=(ConstraintTeacherMaxGapsPerMorningAndAfternoon*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour* c=(ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY:
				{
					ConstraintStudentsSetMaxHoursDaily* c=(ConstraintStudentsSetMaxHoursDaily*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintStudentsSetMaxHoursContinuously* c=(ConstraintStudentsSetMaxHoursContinuously*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintStudentsActivityTagMaxHoursContinuously* c=(ConstraintStudentsActivityTagMaxHoursContinuously*)tc;
					if(!existingActivityTagsNames.contains(c->activityTagName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_CONTINUOUSLY:
				{
					ConstraintStudentsSetActivityTagMaxHoursContinuously* c=(ConstraintStudentsSetActivityTagMaxHoursContinuously*)tc;
					if(!existingActivityTagsNames.contains(c->activityTagName) || !permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_HOURS_DAILY:
				{
					ConstraintStudentsSetMinHoursDaily* c=(ConstraintStudentsSetMinHoursDaily*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
				{
					ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTags* c=(ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTags*)tc;
					if(!permanentStudentsHash.contains(c->students) ||
					!existingActivityTagsNames.contains(c->firstActivityTag) ||
					!existingActivityTagsNames.contains(c->secondActivityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
				{
					ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTags* c=(ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTags*)tc;
					if(!existingActivityTagsNames.contains(c->firstActivityTag) ||
					!existingActivityTagsNames.contains(c->secondActivityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
				{
					ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTags* c=(ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTags*)tc;
					if(!existingTeachersNames.contains(c->teacher) ||
					!existingActivityTagsNames.contains(c->firstActivityTag) ||
					!existingActivityTagsNames.contains(c->secondActivityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS:
				{
					ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTags* c=(ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTags*)tc;
					if(!existingActivityTagsNames.contains(c->firstActivityTag) ||
					!existingActivityTagsNames.contains(c->secondActivityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
				{
					ConstraintStudentsSetMinGapsBetweenActivityTag* c=(ConstraintStudentsSetMinGapsBetweenActivityTag*)tc;
					if(!permanentStudentsHash.contains(c->students) ||
					!existingActivityTagsNames.contains(c->activityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
				{
					ConstraintStudentsMinGapsBetweenActivityTag* c=(ConstraintStudentsMinGapsBetweenActivityTag*)tc;
					if(!existingActivityTagsNames.contains(c->activityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
				{
					ConstraintTeacherMinGapsBetweenActivityTag* c=(ConstraintTeacherMinGapsBetweenActivityTag*)tc;
					if(!existingTeachersNames.contains(c->teacher) ||
					!existingActivityTagsNames.contains(c->activityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ACTIVITY_TAG:
				{
					ConstraintTeachersMinGapsBetweenActivityTag* c=(ConstraintTeachersMinGapsBetweenActivityTag*)tc;
					if(!existingActivityTagsNames.contains(c->activityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
				{
					ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* c=(ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay*)tc;
					if(!permanentStudentsHash.contains(c->students) ||
					!existingActivityTagsNames.contains(c->firstActivityTag) ||
					!existingActivityTagsNames.contains(c->secondActivityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
				{
					ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* c=(ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsPerRealDay*)tc;
					if(!existingActivityTagsNames.contains(c->firstActivityTag) ||
					!existingActivityTagsNames.contains(c->secondActivityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
				{
					ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* c=(ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsPerRealDay*)tc;
					if(!existingTeachersNames.contains(c->teacher) ||
					!existingActivityTagsNames.contains(c->firstActivityTag) ||
					!existingActivityTagsNames.contains(c->secondActivityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_PER_REAL_DAY:
				{
					ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* c=(ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsPerRealDay*)tc;
					if(!existingActivityTagsNames.contains(c->firstActivityTag) ||
					!existingActivityTagsNames.contains(c->secondActivityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
				{
					ConstraintStudentsSetMinGapsBetweenActivityTagPerRealDay* c=(ConstraintStudentsSetMinGapsBetweenActivityTagPerRealDay*)tc;
					if(!permanentStudentsHash.contains(c->students) ||
					!existingActivityTagsNames.contains(c->activityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
				{
					ConstraintStudentsMinGapsBetweenActivityTagPerRealDay* c=(ConstraintStudentsMinGapsBetweenActivityTagPerRealDay*)tc;
					if(!existingActivityTagsNames.contains(c->activityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
				{
					ConstraintTeacherMinGapsBetweenActivityTagPerRealDay* c=(ConstraintTeacherMinGapsBetweenActivityTagPerRealDay*)tc;
					if(!existingTeachersNames.contains(c->teacher) ||
					!existingActivityTagsNames.contains(c->activityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_PER_REAL_DAY:
				{
					ConstraintTeachersMinGapsBetweenActivityTagPerRealDay* c=(ConstraintTeachersMinGapsBetweenActivityTagPerRealDay*)tc;
					if(!existingActivityTagsNames.contains(c->activityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* c=(ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon*)tc;
					if(!permanentStudentsHash.contains(c->students) ||
					!existingActivityTagsNames.contains(c->firstActivityTag) ||
					!existingActivityTagsNames.contains(c->secondActivityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* c=(ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon*)tc;
					if(!existingActivityTagsNames.contains(c->firstActivityTag) ||
					!existingActivityTagsNames.contains(c->secondActivityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* c=(ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon*)tc;
					if(!existingTeachersNames.contains(c->teacher) ||
					!existingActivityTagsNames.contains(c->firstActivityTag) ||
					!existingActivityTagsNames.contains(c->secondActivityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ORDERED_PAIR_OF_ACTIVITY_TAGS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* c=(ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon*)tc;
					if(!existingActivityTagsNames.contains(c->firstActivityTag) ||
					!existingActivityTagsNames.contains(c->secondActivityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon* c=(ConstraintStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon*)tc;
					if(!permanentStudentsHash.contains(c->students) ||
					!existingActivityTagsNames.contains(c->activityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsMinGapsBetweenActivityTagBetweenMorningAndAfternoon* c=(ConstraintStudentsMinGapsBetweenActivityTagBetweenMorningAndAfternoon*)tc;
					if(!existingActivityTagsNames.contains(c->activityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeacherMinGapsBetweenActivityTagBetweenMorningAndAfternoon* c=(ConstraintTeacherMinGapsBetweenActivityTagBetweenMorningAndAfternoon*)tc;
					if(!existingTeachersNames.contains(c->teacher) ||
					!existingActivityTagsNames.contains(c->activityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHERS_MIN_GAPS_BETWEEN_ACTIVITY_TAG_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeachersMinGapsBetweenActivityTagBetweenMorningAndAfternoon* c=(ConstraintTeachersMinGapsBetweenActivityTagBetweenMorningAndAfternoon*)tc;
					if(!existingActivityTagsNames.contains(c->activityTag))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIME:
				{
					ConstraintActivityPreferredStartingTime* c=(ConstraintActivityPreferredStartingTime*)tc;
					if(!existingActivitiesIds.contains(c->activityId)){
						toBeRemovedTime.append(tc);
						recomputeTime=true;
					}
					break;
				}
			case CONSTRAINT_ACTIVITY_PREFERRED_DAY:
				{
					ConstraintActivityPreferredDay* c=(ConstraintActivityPreferredDay*)tc;
					if(!existingActivitiesIds.contains(c->activityId))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITY_PREFERRED_TIME_SLOTS:
				{
					ConstraintActivityPreferredTimeSlots* c=(ConstraintActivityPreferredTimeSlots*)tc;
					if(!existingActivitiesIds.contains(c->p_activityId))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITY_PREFERRED_STARTING_TIMES:
				{
					ConstraintActivityPreferredStartingTimes* c=(ConstraintActivityPreferredStartingTimes*)tc;
					if(!existingActivitiesIds.contains(c->activityId))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_PREFERRED_TIME_SLOTS:
				{
					ConstraintActivitiesPreferredTimeSlots* c=(ConstraintActivitiesPreferredTimeSlots*)tc;
					if( (c->p_teacherName!="" && !existingTeachersNames.contains(c->p_teacherName)) ||
					(c->p_studentsName!="" && !permanentStudentsHash.contains(c->p_studentsName)) ||
					(c->p_subjectName!="" && !existingSubjectsNames.contains(c->p_subjectName)) ||
					(c->p_activityTagName!="" && !existingActivityTagsNames.contains(c->p_activityTagName)) )
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_SUBACTIVITIES_PREFERRED_TIME_SLOTS:
				{
					ConstraintSubactivitiesPreferredTimeSlots* c=(ConstraintSubactivitiesPreferredTimeSlots*)tc;
					if( (c->p_teacherName!="" && !existingTeachersNames.contains(c->p_teacherName)) ||
					(c->p_studentsName!="" && !permanentStudentsHash.contains(c->p_studentsName)) ||
					(c->p_subjectName!="" && !existingSubjectsNames.contains(c->p_subjectName)) ||
					(c->p_activityTagName!="" && !existingActivityTagsNames.contains(c->p_activityTagName)) )
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_PREFERRED_STARTING_TIMES:
				{
					ConstraintActivitiesPreferredStartingTimes* c=(ConstraintActivitiesPreferredStartingTimes*)tc;
					if( (c->teacherName!="" && !existingTeachersNames.contains(c->teacherName)) ||
					(c->studentsName!="" && !permanentStudentsHash.contains(c->studentsName)) ||
					(c->subjectName!="" && !existingSubjectsNames.contains(c->subjectName)) ||
					(c->activityTagName!="" && !existingActivityTagsNames.contains(c->activityTagName)) )
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_SUBACTIVITIES_PREFERRED_STARTING_TIMES:
				{
					ConstraintSubactivitiesPreferredStartingTimes* c=(ConstraintSubactivitiesPreferredStartingTimes*)tc;
					if( (c->teacherName!="" && !existingTeachersNames.contains(c->teacherName)) ||
					(c->studentsName!="" && !permanentStudentsHash.contains(c->studentsName)) ||
					(c->subjectName!="" && !existingSubjectsNames.contains(c->subjectName)) ||
					(c->activityTagName!="" && !existingActivityTagsNames.contains(c->activityTagName)) )
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_SAME_STARTING_HOUR:
				{
					ConstraintActivitiesSameStartingHour* c=(ConstraintActivitiesSameStartingHour*)tc;
					c->removeUseless(*this);
					if(c->n_activities<2)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_SAME_STARTING_DAY:
				{
					ConstraintActivitiesSameStartingDay* c=(ConstraintActivitiesSameStartingDay*)tc;
					c->removeUseless(*this);
					if(c->n_activities<2)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TWO_ACTIVITIES_CONSECUTIVE:
				{
					ConstraintTwoActivitiesConsecutive* c=(ConstraintTwoActivitiesConsecutive*)tc;
					if( !existingActivitiesIds.contains(c->firstActivityId) ||
					!existingActivitiesIds.contains(c->secondActivityId) )
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TWO_ACTIVITIES_GROUPED:
				{
					ConstraintTwoActivitiesGrouped* c=(ConstraintTwoActivitiesGrouped*)tc;
					if( !existingActivitiesIds.contains(c->firstActivityId) ||
					!existingActivitiesIds.contains(c->secondActivityId) )
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_THREE_ACTIVITIES_GROUPED:
				{
					ConstraintThreeActivitiesGrouped* c=(ConstraintThreeActivitiesGrouped*)tc;
					if( !existingActivitiesIds.contains(c->firstActivityId) ||
					!existingActivitiesIds.contains(c->secondActivityId) ||
					!existingActivitiesIds.contains(c->thirdActivityId) )
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TWO_ACTIVITIES_ORDERED:
				{
					ConstraintTwoActivitiesOrdered* c=(ConstraintTwoActivitiesOrdered*)tc;
					if( !existingActivitiesIds.contains(c->firstActivityId) ||
					!existingActivitiesIds.contains(c->secondActivityId) )
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TWO_SETS_OF_ACTIVITIES_ORDERED:
				{
					ConstraintTwoSetsOfActivitiesOrdered* c=(ConstraintTwoSetsOfActivitiesOrdered*)tc;
					c->removeUseless(*this);
					if(c->firstActivitiesIdsList.isEmpty() || c->secondActivitiesIdsList.isEmpty())
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TWO_ACTIVITIES_ORDERED_IF_SAME_DAY:
				{
					ConstraintTwoActivitiesOrderedIfSameDay* c=(ConstraintTwoActivitiesOrderedIfSameDay*)tc;
					if( !existingActivitiesIds.contains(c->firstActivityId) ||
					!existingActivitiesIds.contains(c->secondActivityId) )
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITY_ENDS_STUDENTS_DAY:
				{
					ConstraintActivityEndsStudentsDay* c=(ConstraintActivityEndsStudentsDay*)tc;
					if(!existingActivitiesIds.contains(c->activityId))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITY_ENDS_TEACHERS_DAY:
				{
					ConstraintActivityEndsTeachersDay* c=(ConstraintActivityEndsTeachersDay*)tc;
					if(!existingActivitiesIds.contains(c->activityId))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITY_BEGINS_STUDENTS_DAY:
				{
					ConstraintActivityBeginsStudentsDay* c=(ConstraintActivityBeginsStudentsDay*)tc;
					if(!existingActivitiesIds.contains(c->activityId))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITY_BEGINS_TEACHERS_DAY:
				{
					ConstraintActivityBeginsTeachersDay* c=(ConstraintActivityBeginsTeachersDay*)tc;
					if(!existingActivitiesIds.contains(c->activityId))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITY_BEGINS_OR_ENDS_STUDENTS_DAY:
				{
					ConstraintActivityBeginsOrEndsStudentsDay* c=(ConstraintActivityBeginsOrEndsStudentsDay*)tc;
					if(!existingActivitiesIds.contains(c->activityId))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITY_BEGINS_OR_ENDS_TEACHERS_DAY:
				{
					ConstraintActivityBeginsOrEndsTeachersDay* c=(ConstraintActivityBeginsOrEndsTeachersDay*)tc;
					if(!existingActivitiesIds.contains(c->activityId))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MIN_HOURS_DAILY:
				{
					ConstraintTeacherMinHoursDaily* c=(ConstraintTeacherMinHoursDaily*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeacherIntervalMaxDaysPerWeek* c=(ConstraintTeacherIntervalMaxDaysPerWeek*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetIntervalMaxDaysPerWeek* c=(ConstraintStudentsSetIntervalMaxDaysPerWeek*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_END_STUDENTS_DAY:
				{
					ConstraintActivitiesEndStudentsDay* c=(ConstraintActivitiesEndStudentsDay*)tc;
					if( (c->teacherName!="" && !existingTeachersNames.contains(c->teacherName)) ||
					(c->studentsName!="" && !permanentStudentsHash.contains(c->studentsName)) ||
					(c->subjectName!="" && !existingSubjectsNames.contains(c->subjectName)) ||
					(c->activityTagName!="" && !existingActivityTagsNames.contains(c->activityTagName)) )
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_END_TEACHERS_DAY:
				{
					ConstraintActivitiesEndTeachersDay* c=(ConstraintActivitiesEndTeachersDay*)tc;
					if( (c->teacherName!="" && !existingTeachersNames.contains(c->teacherName)) ||
					(c->studentsName!="" && !permanentStudentsHash.contains(c->studentsName)) ||
					(c->subjectName!="" && !existingSubjectsNames.contains(c->subjectName)) ||
					(c->activityTagName!="" && !existingActivityTagsNames.contains(c->activityTagName)) )
						toBeRemovedTime.append(tc);
					break;
				}

			case CONSTRAINT_ACTIVITIES_BEGIN_STUDENTS_DAY:
				{
					ConstraintActivitiesBeginStudentsDay* c=(ConstraintActivitiesBeginStudentsDay*)tc;
					if( (c->teacherName!="" && !existingTeachersNames.contains(c->teacherName)) ||
					(c->studentsName!="" && !permanentStudentsHash.contains(c->studentsName)) ||
					(c->subjectName!="" && !existingSubjectsNames.contains(c->subjectName)) ||
					(c->activityTagName!="" && !existingActivityTagsNames.contains(c->activityTagName)) )
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_BEGIN_TEACHERS_DAY:
				{
					ConstraintActivitiesBeginTeachersDay* c=(ConstraintActivitiesBeginTeachersDay*)tc;
					if( (c->teacherName!="" && !existingTeachersNames.contains(c->teacherName)) ||
					(c->studentsName!="" && !permanentStudentsHash.contains(c->studentsName)) ||
					(c->subjectName!="" && !existingSubjectsNames.contains(c->subjectName)) ||
					(c->activityTagName!="" && !existingActivityTagsNames.contains(c->activityTagName)) )
						toBeRemovedTime.append(tc);
					break;
				}

			case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_STUDENTS_DAY:
				{
					ConstraintActivitiesBeginOrEndStudentsDay* c=(ConstraintActivitiesBeginOrEndStudentsDay*)tc;
					if( (c->teacherName!="" && !existingTeachersNames.contains(c->teacherName)) ||
					(c->studentsName!="" && !permanentStudentsHash.contains(c->studentsName)) ||
					(c->subjectName!="" && !existingSubjectsNames.contains(c->subjectName)) ||
					(c->activityTagName!="" && !existingActivityTagsNames.contains(c->activityTagName)) )
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_BEGIN_OR_END_TEACHERS_DAY:
				{
					ConstraintActivitiesBeginOrEndTeachersDay* c=(ConstraintActivitiesBeginOrEndTeachersDay*)tc;
					if( (c->teacherName!="" && !existingTeachersNames.contains(c->teacherName)) ||
					(c->studentsName!="" && !permanentStudentsHash.contains(c->studentsName)) ||
					(c->subjectName!="" && !existingSubjectsNames.contains(c->subjectName)) ||
					(c->activityTagName!="" && !existingActivityTagsNames.contains(c->activityTagName)) )
						toBeRemovedTime.append(tc);
					break;
				}

			case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_DAILY:
				{
					ConstraintTeachersActivityTagMaxHoursDaily* c=(ConstraintTeachersActivityTagMaxHoursDaily*)tc;
					if(!existingActivityTagsNames.contains(c->activityTagName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_DAILY:
				{
					ConstraintTeacherActivityTagMaxHoursDaily* c=(ConstraintTeacherActivityTagMaxHoursDaily*)tc;
					if(!existingActivityTagsNames.contains(c->activityTagName) || !existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_DAILY:
				{
					ConstraintStudentsActivityTagMaxHoursDaily* c=(ConstraintStudentsActivityTagMaxHoursDaily*)tc;
					if(!existingActivityTagsNames.contains(c->activityTagName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY:
				{
					ConstraintStudentsSetActivityTagMaxHoursDaily* c=(ConstraintStudentsSetActivityTagMaxHoursDaily*)tc;
					if(!existingActivityTagsNames.contains(c->activityTagName) || !permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MIN_HOURS_DAILY:
				{
					ConstraintTeachersActivityTagMinHoursDaily* c=(ConstraintTeachersActivityTagMinHoursDaily*)tc;
					if(!existingActivityTagsNames.contains(c->activityTagName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MIN_HOURS_DAILY:
				{
					ConstraintTeacherActivityTagMinHoursDaily* c=(ConstraintTeacherActivityTagMinHoursDaily*)tc;
					if(!existingActivityTagsNames.contains(c->activityTagName) || !existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MIN_HOURS_DAILY:
				{
					ConstraintStudentsActivityTagMinHoursDaily* c=(ConstraintStudentsActivityTagMinHoursDaily*)tc;
					if(!existingActivityTagsNames.contains(c->activityTagName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MIN_HOURS_DAILY:
				{
					ConstraintStudentsSetActivityTagMinHoursDaily* c=(ConstraintStudentsSetActivityTagMinHoursDaily*)tc;
					if(!existingActivityTagsNames.contains(c->activityTagName) || !permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_DAY:
				{
					ConstraintStudentsSetMaxGapsPerDay* c=(ConstraintStudentsSetMaxGapsPerDay*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintStudentsSetMaxActivityTagsPerDayFromSet* c=(ConstraintStudentsSetMaxActivityTagsPerDayFromSet*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					else{
						QStringList atl;
						for(const QString& at : std::as_const(c->tagsList))
							if(existingActivityTagsNames.contains(at))
								atl.append(at);
						c->tagsList=atl;

						if(c->tagsList.count()<2)
							toBeRemovedTime.append(tc);
					}
					
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintStudentsSetMaxActivityTagsPerRealDayFromSet* c=(ConstraintStudentsSetMaxActivityTagsPerRealDayFromSet*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					else{
						QStringList atl;
						for(const QString& at : std::as_const(c->tagsList))
							if(existingActivityTagsNames.contains(at))
								atl.append(at);
						c->tagsList=atl;

						if(c->tagsList.count()<2)
							toBeRemovedTime.append(tc);
					}
					
					break;
				}
			case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintActivitiesOccupyMaxTimeSlotsFromSelection* c=(ConstraintActivitiesOccupyMaxTimeSlotsFromSelection*)tc;
					c->removeUseless(*this);
					if(c->activitiesIds.count()<1)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_OCCUPY_MIN_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintActivitiesOccupyMinTimeSlotsFromSelection* c=(ConstraintActivitiesOccupyMinTimeSlotsFromSelection*)tc;
					c->removeUseless(*this);
					if(c->activitiesIds.count()<1)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_MAX_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots* c=(ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots*)tc;
					c->removeUseless(*this);
					if(c->activitiesIds.count()<1)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_MIN_SIMULTANEOUS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintActivitiesMinSimultaneousInSelectedTimeSlots* c=(ConstraintActivitiesMinSimultaneousInSelectedTimeSlots*)tc;
					c->removeUseless(*this);
					if(c->activitiesIds.count()<1)
						toBeRemovedTime.append(tc);
					break;
				}
				//2020-05-02
			case CONSTRAINT_MAX_TOTAL_ACTIVITIES_FROM_SET_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots* c=(ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots*)tc;
					c->removeUseless(*this);
					if(c->activitiesIds.count()<1)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_MAX_IN_A_TERM:
				{
					ConstraintActivitiesMaxInATerm* c=(ConstraintActivitiesMaxInATerm*)tc;
					c->removeUseless(*this);
					if(c->activitiesIds.count()<1)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_MIN_IN_A_TERM:
				{
					ConstraintActivitiesMinInATerm* c=(ConstraintActivitiesMinInATerm*)tc;
					c->removeUseless(*this);
					if(c->activitiesIds.count()<1)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_TERMS:
				{
					ConstraintActivitiesOccupyMaxTerms* c=(ConstraintActivitiesOccupyMaxTerms*)tc;
					c->removeUseless(*this);
					if(c->activitiesIds.count()<1)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetMaxDaysPerWeek* c=(ConstraintStudentsSetMaxDaysPerWeek*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
				//2017-02-07
			case CONSTRAINT_TEACHER_MAX_SPAN_PER_DAY:
				{
					ConstraintTeacherMaxSpanPerDay* c=(ConstraintTeacherMaxSpanPerDay*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MIN_RESTING_HOURS:
				{
					ConstraintTeacherMinRestingHours* c=(ConstraintTeacherMinRestingHours*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_SPAN_PER_DAY:
				{
					ConstraintStudentsSetMaxSpanPerDay* c=(ConstraintStudentsSetMaxSpanPerDay*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_RESTING_HOURS:
				{
					ConstraintStudentsSetMinRestingHours* c=(ConstraintStudentsSetMinRestingHours*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}

				//mornings-afternoons
			case CONSTRAINT_TEACHER_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeacherMaxHoursDailyRealDays* c=(ConstraintTeacherMaxHoursDailyRealDays*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_REAL_DAYS_PER_WEEK:
				{
					ConstraintTeacherMaxRealDaysPerWeek* c=(ConstraintTeacherMaxRealDaysPerWeek*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_AFTERNOONS_PER_WEEK:
				{
					ConstraintTeacherMaxAfternoonsPerWeek* c=(ConstraintTeacherMaxAfternoonsPerWeek*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintTeacherMaxActivityTagsPerDayFromSet* c=(ConstraintTeacherMaxActivityTagsPerDayFromSet*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					else{
						QStringList atl;
						for(const QString& at : std::as_const(c->tagsList))
							if(existingActivityTagsNames.contains(at))
								atl.append(at);
						c->tagsList=atl;

						if(c->tagsList.count()<2)
							toBeRemovedTime.append(tc);
					}
					
					break;
				}
			case CONSTRAINT_TEACHER_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintTeacherMaxActivityTagsPerRealDayFromSet* c=(ConstraintTeacherMaxActivityTagsPerRealDayFromSet*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					else{
						QStringList atl;
						for(const QString& at : std::as_const(c->tagsList))
							if(existingActivityTagsNames.contains(at))
								atl.append(at);
						c->tagsList=atl;

						if(c->tagsList.count()<2)
							toBeRemovedTime.append(tc);
					}
					
					break;
				}
			case CONSTRAINT_TEACHER_MAX_MORNINGS_PER_WEEK:
				{
					ConstraintTeacherMaxMorningsPerWeek* c=(ConstraintTeacherMaxMorningsPerWeek*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_TWO_CONSECUTIVE_MORNINGS:
				{
					ConstraintTeacherMaxTwoConsecutiveMornings* c=(ConstraintTeacherMaxTwoConsecutiveMornings*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_TWO_CONSECUTIVE_AFTERNOONS:
				{
					ConstraintTeacherMaxTwoConsecutiveAfternoons* c=(ConstraintTeacherMaxTwoConsecutiveAfternoons*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MIN_REAL_DAYS_PER_WEEK:
				{
					ConstraintTeacherMinRealDaysPerWeek* c=(ConstraintTeacherMinRealDaysPerWeek*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MIN_MORNINGS_PER_WEEK:
				{
					ConstraintTeacherMinMorningsPerWeek* c=(ConstraintTeacherMinMorningsPerWeek*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MIN_AFTERNOONS_PER_WEEK:
				{
					ConstraintTeacherMinAfternoonsPerWeek* c=(ConstraintTeacherMinAfternoonsPerWeek*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
				//2020-06-28
			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_PER_ALL_AFTERNOONS:
				{
					ConstraintStudentsSetMaxHoursPerAllAfternoons* c=(ConstraintStudentsSetMaxHoursPerAllAfternoons*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
				//
			case CONSTRAINT_TEACHER_AFTERNOONS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintTeacherAfternoonsEarlyMaxBeginningsAtSecondHour* c=(ConstraintTeacherAfternoonsEarlyMaxBeginningsAtSecondHour*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MORNINGS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintTeacherMorningsEarlyMaxBeginningsAtSecondHour* c=(ConstraintTeacherMorningsEarlyMaxBeginningsAtSecondHour*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_REAL_DAY:
				{
					ConstraintTeacherMaxGapsPerRealDay* c=(ConstraintTeacherMaxGapsPerRealDay*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_GAPS_PER_WEEK_FOR_REAL_DAYS:
				{
					ConstraintTeacherMaxGapsPerWeekForRealDays* c=(ConstraintTeacherMaxGapsPerWeekForRealDays*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_ZERO_GAPS_PER_AFTERNOON:
				{
					ConstraintTeacherMaxZeroGapsPerAfternoon* c=(ConstraintTeacherMaxZeroGapsPerAfternoon*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_AFTERNOONS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintStudentsSetAfternoonsEarlyMaxBeginningsAtSecondHour* c=(ConstraintStudentsSetAfternoonsEarlyMaxBeginningsAtSecondHour*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MORNINGS_EARLY_MAX_BEGINNINGS_AT_SECOND_HOUR:
				{
					ConstraintStudentsSetMorningsEarlyMaxBeginningsAtSecondHour* c=(ConstraintStudentsSetMorningsEarlyMaxBeginningsAtSecondHour*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintStudentsSetMaxHoursDailyRealDays* c=(ConstraintStudentsSetMaxHoursDailyRealDays*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_HOURS_PER_MORNING:
				{
					ConstraintStudentsSetMinHoursPerMorning* c=(ConstraintStudentsSetMinHoursPerMorning*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_HOURS_PER_AFTERNOON:
				{
					ConstraintStudentsSetMinHoursPerAfternoon* c=(ConstraintStudentsSetMinHoursPerAfternoon*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
				//2020-06-28
			case CONSTRAINT_TEACHER_MAX_HOURS_PER_ALL_AFTERNOONS:
				{
					ConstraintTeacherMaxHoursPerAllAfternoons* c=(ConstraintTeacherMaxHoursPerAllAfternoons*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
				//
			case CONSTRAINT_TEACHER_MIN_HOURS_PER_MORNING:
				{
					ConstraintTeacherMinHoursPerMorning* c=(ConstraintTeacherMinHoursPerMorning*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MIN_HOURS_PER_AFTERNOON:
				{
					ConstraintTeacherMinHoursPerAfternoon* c=(ConstraintTeacherMinHoursPerAfternoon*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_MIN_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeacherMinHoursDailyRealDays* c=(ConstraintTeacherMinHoursDailyRealDays*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}

			case CONSTRAINT_TEACHER_MORNING_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeacherMorningIntervalMaxDaysPerWeek* c=(ConstraintTeacherMorningIntervalMaxDaysPerWeek*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_AFTERNOON_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintTeacherAfternoonIntervalMaxDaysPerWeek* c=(ConstraintTeacherAfternoonIntervalMaxDaysPerWeek*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}

			case CONSTRAINT_STUDENTS_SET_MORNING_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetMorningIntervalMaxDaysPerWeek* c=(ConstraintStudentsSetMorningIntervalMaxDaysPerWeek*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_AFTERNOON_INTERVAL_MAX_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetAfternoonIntervalMaxDaysPerWeek* c=(ConstraintStudentsSetAfternoonIntervalMaxDaysPerWeek*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}

			case CONSTRAINT_TEACHERS_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeachersActivityTagMaxHoursDailyRealDays* c=(ConstraintTeachersActivityTagMaxHoursDailyRealDays*)tc;
					if(!existingActivityTagsNames.contains(c->activityTagName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_TEACHER_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintTeacherActivityTagMaxHoursDailyRealDays* c=(ConstraintTeacherActivityTagMaxHoursDailyRealDays*)tc;
					if(!existingActivityTagsNames.contains(c->activityTagName) || !existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintStudentsActivityTagMaxHoursDailyRealDays* c=(ConstraintStudentsActivityTagMaxHoursDailyRealDays*)tc;
					if(!existingActivityTagsNames.contains(c->activityTagName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_ACTIVITY_TAG_MAX_HOURS_DAILY_REAL_DAYS:
				{
					ConstraintStudentsSetActivityTagMaxHoursDailyRealDays* c=(ConstraintStudentsSetActivityTagMaxHoursDailyRealDays*)tc;
					if(!existingActivityTagsNames.contains(c->activityTagName) || !permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_REAL_DAY:
				{
					ConstraintStudentsSetMaxGapsPerRealDay* c=(ConstraintStudentsSetMaxGapsPerRealDay*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_GAPS_PER_WEEK_FOR_REAL_DAYS:
				{
					ConstraintStudentsSetMaxGapsPerWeekForRealDays* c=(ConstraintStudentsSetMaxGapsPerWeekForRealDays*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_REAL_DAYS_PER_WEEK:
				{
					ConstraintStudentsSetMaxRealDaysPerWeek* c=(ConstraintStudentsSetMaxRealDaysPerWeek*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
				//2020-06-25
			case CONSTRAINT_STUDENTS_SET_MAX_AFTERNOONS_PER_WEEK:
				{
					ConstraintStudentsSetMaxAfternoonsPerWeek* c=(ConstraintStudentsSetMaxAfternoonsPerWeek*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_MORNINGS_PER_WEEK:
				{
					ConstraintStudentsSetMaxMorningsPerWeek* c=(ConstraintStudentsSetMaxMorningsPerWeek*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
				//2020-06-26
			case CONSTRAINT_STUDENTS_SET_MIN_AFTERNOONS_PER_WEEK:
				{
					ConstraintStudentsSetMinAfternoonsPerWeek* c=(ConstraintStudentsSetMinAfternoonsPerWeek*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_MORNINGS_PER_WEEK:
				{
					ConstraintStudentsSetMinMorningsPerWeek* c=(ConstraintStudentsSetMinMorningsPerWeek*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
				//
			case CONSTRAINT_TEACHER_MAX_SPAN_PER_REAL_DAY:
				{
					ConstraintTeacherMaxSpanPerRealDay* c=(ConstraintTeacherMaxSpanPerRealDay*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_SPAN_PER_REAL_DAY:
				{
					ConstraintStudentsSetMaxSpanPerRealDay* c=(ConstraintStudentsSetMaxSpanPerRealDay*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
				//
			case CONSTRAINT_TEACHER_MIN_RESTING_HOURS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintTeacherMinRestingHoursBetweenMorningAndAfternoon* c=(ConstraintTeacherMinRestingHoursBetweenMorningAndAfternoon*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_RESTING_HOURS_BETWEEN_MORNING_AND_AFTERNOON:
				{
					ConstraintStudentsSetMinRestingHoursBetweenMorningAndAfternoon* c=(ConstraintStudentsSetMinRestingHoursBetweenMorningAndAfternoon*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}
				//2022-02-15
			case CONSTRAINT_STUDENTS_SET_MAX_THREE_CONSECUTIVE_DAYS:
				{
					ConstraintStudentsSetMaxThreeConsecutiveDays* c=(ConstraintStudentsSetMaxThreeConsecutiveDays*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}

			case CONSTRAINT_TEACHER_MAX_HOURS_DAILY_IN_INTERVAL:
				{
					ConstraintTeacherMaxHoursDailyInInterval* c=(ConstraintTeacherMaxHoursDailyInInterval*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_HOURS_DAILY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxHoursDailyInInterval* c=(ConstraintStudentsSetMaxHoursDailyInInterval*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}

			case CONSTRAINT_TEACHER_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
				{
					ConstraintTeacherPairOfMutuallyExclusiveTimeSlots* c=(ConstraintTeacherPairOfMutuallyExclusiveTimeSlots*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
				{
					ConstraintStudentsSetPairOfMutuallyExclusiveTimeSlots* c=(ConstraintStudentsSetPairOfMutuallyExclusiveTimeSlots*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}

			case CONSTRAINT_TEACHER_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
				{
					ConstraintTeacherPairOfMutuallyExclusiveSetsOfTimeSlots* c=(ConstraintTeacherPairOfMutuallyExclusiveSetsOfTimeSlots*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}

			case CONSTRAINT_TEACHER_OCCUPIES_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintTeacherOccupiesMaxSetsOfTimeSlotsFromSelection* c=(ConstraintTeacherOccupiesMaxSetsOfTimeSlotsFromSelection*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}

			case CONSTRAINT_STUDENTS_SET_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
				{
					ConstraintStudentsSetPairOfMutuallyExclusiveSetsOfTimeSlots* c=(ConstraintStudentsSetPairOfMutuallyExclusiveSetsOfTimeSlots*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}

			case CONSTRAINT_STUDENTS_SET_OCCUPIES_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintStudentsSetOccupiesMaxSetsOfTimeSlotsFromSelection* c=(ConstraintStudentsSetOccupiesMaxSetsOfTimeSlotsFromSelection*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}

			case CONSTRAINT_TWO_SETS_OF_ACTIVITIES_SAME_SECTIONS:
				{
					ConstraintTwoSetsOfActivitiesSameSections* c=(ConstraintTwoSetsOfActivitiesSameSections*)tc;
					c->removeUseless(*this);
					if(c->activitiesAIds.count()<1 && c->activitiesBIds.count()<1)
						toBeRemovedTime.append(tc);
					break;
				}

			case CONSTRAINT_STUDENTS_SET_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintStudentsSetMaxSingleGapsInSelectedTimeSlots* c=(ConstraintStudentsSetMaxSingleGapsInSelectedTimeSlots*)tc;
					if(!permanentStudentsHash.contains(c->students))
						toBeRemovedTime.append(tc);
					break;
				}

			case CONSTRAINT_TEACHER_MAX_SINGLE_GAPS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintTeacherMaxSingleGapsInSelectedTimeSlots* c=(ConstraintTeacherMaxSingleGapsInSelectedTimeSlots*)tc;
					if(!existingTeachersNames.contains(c->teacher))
						toBeRemovedTime.append(tc);
					break;
				}

			case CONSTRAINT_TEACHER_MAX_HOURS_PER_TERM:
				{
					ConstraintTeacherMaxHoursPerTerm* c=(ConstraintTeacherMaxHoursPerTerm*)tc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedTime.append(tc);
					break;
				}

			case CONSTRAINT_ACTIVITIES_PAIR_OF_MUTUALLY_EXCLUSIVE_SETS_OF_TIME_SLOTS:
				{
					ConstraintActivitiesPairOfMutuallyExclusiveSetsOfTimeSlots* c=(ConstraintActivitiesPairOfMutuallyExclusiveSetsOfTimeSlots*)tc;
					c->removeUseless(*this);
					if(c->activitiesIds.count()<1)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_PAIR_OF_MUTUALLY_EXCLUSIVE_TIME_SLOTS:
				{
					ConstraintActivitiesPairOfMutuallyExclusiveTimeSlots* c=(ConstraintActivitiesPairOfMutuallyExclusiveTimeSlots*)tc;
					c->removeUseless(*this);
					if(c->activitiesIds.count()<1)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_OVERLAP_COMPLETELY_OR_DO_NOT_OVERLAP:
				{
					ConstraintActivitiesOverlapCompletelyOrDoNotOverlap* c=(ConstraintActivitiesOverlapCompletelyOrDoNotOverlap*)tc;
					c->removeUseless(*this);
					if(c->activitiesIds.count()<2)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_SETS_OF_TIME_SLOTS_FROM_SELECTION:
				{
					ConstraintActivitiesOccupyMaxSetsOfTimeSlotsFromSelection* c=(ConstraintActivitiesOccupyMaxSetsOfTimeSlotsFromSelection*)tc;
					c->removeUseless(*this);
					if(c->activitiesIds.count()<1)
						toBeRemovedTime.append(tc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_MAX_TOTAL_NUMBER_OF_STUDENTS_IN_SELECTED_TIME_SLOTS:
				{
					ConstraintActivitiesMaxTotalNumberOfStudentsInSelectedTimeSlots* c=(ConstraintActivitiesMaxTotalNumberOfStudentsInSelectedTimeSlots*)tc;
					c->removeUseless(*this);
					if(c->activitiesIds.count()<1)
						toBeRemovedTime.append(tc);
					break;
				}

			default:
				//do nothing.
				break;
		}
	}

	for(SpaceConstraint* sc : std::as_const(spaceConstraintsList)){
		switch(sc->type){
			case CONSTRAINT_ROOM_NOT_AVAILABLE_TIMES:
				{
					ConstraintRoomNotAvailableTimes* c=(ConstraintRoomNotAvailableTimes*)sc;
					if(!existingRoomsNames.contains(c->room))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_TEACHER_ROOM_NOT_AVAILABLE_TIMES:
				{
					ConstraintTeacherRoomNotAvailableTimes* c=(ConstraintTeacherRoomNotAvailableTimes*)sc;
					if(!existingTeachersNames.contains(c->teacherName) || !existingRoomsNames.contains(c->room))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_ACTIVITY_PREFERRED_ROOM:
				{
					ConstraintActivityPreferredRoom* c=(ConstraintActivityPreferredRoom*)sc;
					if(!existingActivitiesIds.contains(c->activityId) || !existingRoomsNames.contains(c->roomName)){
						toBeRemovedSpace.append(sc);
						recomputeSpace=true;
					}
					break;
				}
			case CONSTRAINT_ACTIVITY_PREFERRED_ROOMS:
				{
					ConstraintActivityPreferredRooms* c=(ConstraintActivityPreferredRooms*)sc;
					if(!existingActivitiesIds.contains(c->activityId))
						toBeRemovedSpace.append(sc);
					else{
						QStringList newRooms;
						for(const QString& room : std::as_const(c->roomsNames))
							if(existingRoomsNames.contains(room))
								newRooms.append(room);
						c->roomsNames=newRooms;
						if(c->roomsNames.count()==0)
							toBeRemovedSpace.append(sc);
					}
					break;
				}
			case CONSTRAINT_STUDENTS_SET_HOME_ROOM:
				{
					ConstraintStudentsSetHomeRoom* c=(ConstraintStudentsSetHomeRoom*)sc;
					if(!permanentStudentsHash.contains(c->studentsName) || !existingRoomsNames.contains(c->roomName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_HOME_ROOMS:
				{
					ConstraintStudentsSetHomeRooms* c=(ConstraintStudentsSetHomeRooms*)sc;
					if(!permanentStudentsHash.contains(c->studentsName))
						toBeRemovedSpace.append(sc);
					else{
						QStringList newRooms;
						for(const QString& room : std::as_const(c->roomsNames))
							if(existingRoomsNames.contains(room))
								newRooms.append(room);
						c->roomsNames=newRooms;
						if(c->roomsNames.count()==0)
							toBeRemovedSpace.append(sc);
					}
					break;
				}
			case CONSTRAINT_TEACHER_HOME_ROOM:
				{
					ConstraintTeacherHomeRoom* c=(ConstraintTeacherHomeRoom*)sc;
					if(!existingTeachersNames.contains(c->teacherName) || !existingRoomsNames.contains(c->roomName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_TEACHER_HOME_ROOMS:
				{
					ConstraintTeacherHomeRooms* c=(ConstraintTeacherHomeRooms*)sc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedSpace.append(sc);
					else{
						QStringList newRooms;
						for(const QString& room : std::as_const(c->roomsNames))
							if(existingRoomsNames.contains(room))
								newRooms.append(room);
						c->roomsNames=newRooms;
						if(c->roomsNames.count()==0)
							toBeRemovedSpace.append(sc);
					}
					break;
				}
			case CONSTRAINT_SUBJECT_PREFERRED_ROOM:
				{
					ConstraintSubjectPreferredRoom* c=(ConstraintSubjectPreferredRoom*)sc;
					if(!existingSubjectsNames.contains(c->subjectName) || !existingRoomsNames.contains(c->roomName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_SUBJECT_PREFERRED_ROOMS:
				{
					ConstraintSubjectPreferredRooms* c=(ConstraintSubjectPreferredRooms*)sc;
					if(!existingSubjectsNames.contains(c->subjectName))
						toBeRemovedSpace.append(sc);
					else{
						QStringList newRooms;
						for(const QString& room : std::as_const(c->roomsNames))
							if(existingRoomsNames.contains(room))
								newRooms.append(room);
						c->roomsNames=newRooms;
						if(c->roomsNames.count()==0)
							toBeRemovedSpace.append(sc);
					}
					break;
				}
			case CONSTRAINT_SUBJECT_ACTIVITY_TAG_PREFERRED_ROOM:
				{
					ConstraintSubjectActivityTagPreferredRoom* c=(ConstraintSubjectActivityTagPreferredRoom*)sc;
					if(!existingSubjectsNames.contains(c->subjectName) || !existingActivityTagsNames.contains(c->activityTagName) ||
					!existingRoomsNames.contains(c->roomName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_SUBJECT_ACTIVITY_TAG_PREFERRED_ROOMS:
				{
					ConstraintSubjectActivityTagPreferredRooms* c=(ConstraintSubjectActivityTagPreferredRooms*)sc;
					if(!existingSubjectsNames.contains(c->subjectName) || !existingActivityTagsNames.contains(c->activityTagName))
						toBeRemovedSpace.append(sc);
					else{
						QStringList newRooms;
						for(const QString& room : std::as_const(c->roomsNames))
							if(existingRoomsNames.contains(room))
								newRooms.append(room);
						c->roomsNames=newRooms;
						if(c->roomsNames.count()==0)
							toBeRemovedSpace.append(sc);
					}
					break;
				}
			case CONSTRAINT_ACTIVITY_TAG_PREFERRED_ROOM:
				{
					ConstraintActivityTagPreferredRoom* c=(ConstraintActivityTagPreferredRoom*)sc;
					if(!existingActivityTagsNames.contains(c->activityTagName) || !existingRoomsNames.contains(c->roomName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_ACTIVITY_TAG_PREFERRED_ROOMS:
				{
					ConstraintActivityTagPreferredRooms* c=(ConstraintActivityTagPreferredRooms*)sc;
					if(!existingActivityTagsNames.contains(c->activityTagName))
						toBeRemovedSpace.append(sc);
					else{
						QStringList newRooms;
						for(const QString& room : std::as_const(c->roomsNames))
							if(existingRoomsNames.contains(room))
								newRooms.append(room);
						c->roomsNames=newRooms;
						if(c->roomsNames.count()==0)
							toBeRemovedSpace.append(sc);
					}
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_DAY:
				{
					ConstraintStudentsSetMaxBuildingChangesPerDay* c=(ConstraintStudentsSetMaxBuildingChangesPerDay*)sc;
					if(!permanentStudentsHash.contains(c->studentsName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_WEEK:
				{
					ConstraintStudentsSetMaxBuildingChangesPerWeek* c=(ConstraintStudentsSetMaxBuildingChangesPerWeek*)sc;
					if(!permanentStudentsHash.contains(c->studentsName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_BUILDING_CHANGES:
				{
					ConstraintStudentsSetMinGapsBetweenBuildingChanges* c=(ConstraintStudentsSetMinGapsBetweenBuildingChanges*)sc;
					if(!permanentStudentsHash.contains(c->studentsName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_DAY:
				{
					ConstraintTeacherMaxBuildingChangesPerDay* c=(ConstraintTeacherMaxBuildingChangesPerDay*)sc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_WEEK:
				{
					ConstraintTeacherMaxBuildingChangesPerWeek* c=(ConstraintTeacherMaxBuildingChangesPerWeek*)sc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_BUILDING_CHANGES:
				{
					ConstraintTeacherMinGapsBetweenBuildingChanges* c=(ConstraintTeacherMinGapsBetweenBuildingChanges*)sc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_DAY:
				{
					ConstraintStudentsSetMaxRoomChangesPerDay* c=(ConstraintStudentsSetMaxRoomChangesPerDay*)sc;
					if(!permanentStudentsHash.contains(c->studentsName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_WEEK:
				{
					ConstraintStudentsSetMaxRoomChangesPerWeek* c=(ConstraintStudentsSetMaxRoomChangesPerWeek*)sc;
					if(!permanentStudentsHash.contains(c->studentsName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MIN_GAPS_BETWEEN_ROOM_CHANGES:
				{
					ConstraintStudentsSetMinGapsBetweenRoomChanges* c=(ConstraintStudentsSetMinGapsBetweenRoomChanges*)sc;
					if(!permanentStudentsHash.contains(c->studentsName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_DAY:
				{
					ConstraintTeacherMaxRoomChangesPerDay* c=(ConstraintTeacherMaxRoomChangesPerDay*)sc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_WEEK:
				{
					ConstraintTeacherMaxRoomChangesPerWeek* c=(ConstraintTeacherMaxRoomChangesPerWeek*)sc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_TEACHER_MIN_GAPS_BETWEEN_ROOM_CHANGES:
				{
					ConstraintTeacherMinGapsBetweenRoomChanges* c=(ConstraintTeacherMinGapsBetweenRoomChanges*)sc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_OCCUPY_MAX_DIFFERENT_ROOMS:
				{
					ConstraintActivitiesOccupyMaxDifferentRooms* c=(ConstraintActivitiesOccupyMaxDifferentRooms*)sc;
					c->removeUseless(*this);
					if(c->activitiesIds.count()<2)
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_ACTIVITIES_SAME_ROOM_IF_CONSECUTIVE:
				{
					ConstraintActivitiesSameRoomIfConsecutive* c=(ConstraintActivitiesSameRoomIfConsecutive*)sc;
					c->removeUseless(*this);
					if(c->activitiesIds.count()<2)
						toBeRemovedSpace.append(sc);
					break;
				}

				//mornings-afternoons
			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_REAL_DAY:
				{
					ConstraintStudentsSetMaxRoomChangesPerRealDay* c=(ConstraintStudentsSetMaxRoomChangesPerRealDay*)sc;
					if(!permanentStudentsHash.contains(c->studentsName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_REAL_DAY:
				{
					ConstraintTeacherMaxRoomChangesPerRealDay* c=(ConstraintTeacherMaxRoomChangesPerRealDay*)sc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedSpace.append(sc);
					break;
				}

			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_REAL_DAY:
				{
					ConstraintStudentsSetMaxBuildingChangesPerRealDay* c=(ConstraintStudentsSetMaxBuildingChangesPerRealDay*)sc;
					if(!permanentStudentsHash.contains(c->studentsName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_REAL_DAY:
				{
					ConstraintTeacherMaxBuildingChangesPerRealDay* c=(ConstraintTeacherMaxBuildingChangesPerRealDay*)sc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedSpace.append(sc);
					break;
				}

			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxBuildingChangesPerDayInInterval* c=(ConstraintStudentsSetMaxBuildingChangesPerDayInInterval*)sc;
					if(!permanentStudentsHash.contains(c->studentsName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_BUILDING_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxBuildingChangesPerRealDayInInterval* c=(ConstraintStudentsSetMaxBuildingChangesPerRealDayInInterval*)sc;
					if(!permanentStudentsHash.contains(c->studentsName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintTeacherMaxBuildingChangesPerDayInInterval* c=(ConstraintTeacherMaxBuildingChangesPerDayInInterval*)sc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_BUILDING_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintTeacherMaxBuildingChangesPerRealDayInInterval* c=(ConstraintTeacherMaxBuildingChangesPerRealDayInInterval*)sc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedSpace.append(sc);
					break;
				}

			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxRoomChangesPerDayInInterval* c=(ConstraintStudentsSetMaxRoomChangesPerDayInInterval*)sc;
					if(!permanentStudentsHash.contains(c->studentsName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_STUDENTS_SET_MAX_ROOM_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintStudentsSetMaxRoomChangesPerRealDayInInterval* c=(ConstraintStudentsSetMaxRoomChangesPerRealDayInInterval*)sc;
					if(!permanentStudentsHash.contains(c->studentsName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_DAY_IN_INTERVAL:
				{
					ConstraintTeacherMaxRoomChangesPerDayInInterval* c=(ConstraintTeacherMaxRoomChangesPerDayInInterval*)sc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_TEACHER_MAX_ROOM_CHANGES_PER_REAL_DAY_IN_INTERVAL:
				{
					ConstraintTeacherMaxRoomChangesPerRealDayInInterval* c=(ConstraintTeacherMaxRoomChangesPerRealDayInInterval*)sc;
					if(!existingTeachersNames.contains(c->teacherName))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_ROOM_MAX_ACTIVITY_TAGS_PER_DAY_FROM_SET:
				{
					ConstraintRoomMaxActivityTagsPerDayFromSet* c=(ConstraintRoomMaxActivityTagsPerDayFromSet*)sc;
					if(!existingRoomsNames.contains(c->room))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_ROOM_MAX_ACTIVITY_TAGS_PER_REAL_DAY_FROM_SET:
				{
					ConstraintRoomMaxActivityTagsPerRealDayFromSet* c=(ConstraintRoomMaxActivityTagsPerRealDayFromSet*)sc;
					if(!existingRoomsNames.contains(c->room))
						toBeRemovedSpace.append(sc);
					break;
				}
			case CONSTRAINT_ROOM_MAX_ACTIVITY_TAGS_PER_WEEK_FROM_SET:
				{
					ConstraintRoomMaxActivityTagsPerWeekFromSet* c=(ConstraintRoomMaxActivityTagsPerWeekFromSet*)sc;
					if(!existingRoomsNames.contains(c->room))
						toBeRemovedSpace.append(sc);
					break;
				}

			default:
				//do nothing.
				break;
		}
	}
	
	bool t;
	if(toBeRemovedTime.count()>0){
		t=removeTimeConstraints(toBeRemovedTime);
		assert(t);
	}
	if(toBeRemovedSpace.count()>0){
		t=removeSpaceConstraints(toBeRemovedSpace);
		assert(t);
	}
	
	if(recomputeTime){
		LockUnlock::computeLockedUnlockedActivitiesOnlyTime();
	}
	if(recomputeSpace){
		LockUnlock::computeLockedUnlockedActivitiesOnlySpace();
	}
	if(recomputeTime || recomputeSpace){
		LockUnlock::increaseCommunicationSpinBox();
	}
}

bool Rules::read(QWidget* parent, const QString& fileName, bool commandLine, const QString& commandLineDirectory) //commandLineDirectory has trailing FILE_SEP
{
	//Clear old rules, initialize new rules
	if(this->initialized)
		this->clear();
	this->init();
	
	QFile file(fileName);
#if QT_VERSION >= QT_VERSION_CHECK(6,0,0)
	if(!file.open(QIODeviceBase::ReadOnly)){
#else
	if(!file.open(QIODevice::ReadOnly)){
#endif
		//cout<<"Could not open file - not existing or in use\n";
		RulesIrreconcilableMessage::warning(parent, tr("FET warning"), tr("Could not open file - not existing or in use"));
		return false;
	}
	
	xmlReaderNumberOfUnrecognizedFields=0;
	
	unrecognizedXmlTags.clear();
	unrecognizedXmlLineNumbers.clear();
	unrecognizedXmlColumnNumbers.clear();
	
	QXmlStreamReader xmlReader(&file);
	
	////////////////////////////////////////

	if(!commandLine){
		//logging part
		QDir dir;
		bool t=true;
		if(!dir.exists(OUTPUT_DIR+FILE_SEP+"logs"))
			t=dir.mkpath(OUTPUT_DIR+FILE_SEP+"logs");
		if(!t){
			RulesIrreconcilableMessage::warning(parent, tr("FET warning"), tr("Cannot create or use directory %1 - cannot continue").arg(QDir::toNativeSeparators(OUTPUT_DIR+FILE_SEP+"logs")));
			return false;
		}
		assert(t);
	}
	else{
		QDir dir;
		bool t=true;
		if(!dir.exists(commandLineDirectory+"logs"))
			t=dir.mkpath(commandLineDirectory+"logs");
		if(!t){
			RulesIrreconcilableMessage::warning(parent, tr("FET warning"), tr("Cannot create or use directory %1 - cannot continue").arg(QDir::toNativeSeparators(commandLineDirectory+"logs")));
			return false;
		}
		assert(t);
	}
	
	FakeString xmlReadingLog;
	xmlReadingLog="";

	QDate dat=QDate::currentDate();
	QTime tim=QTime::currentTime();
	QLocale loc(FET_LANGUAGE_WITH_LOCALE);
	QString sTime=loc.toString(dat, QLocale::ShortFormat)+" "+loc.toString(tim, QLocale::ShortFormat);

	QString reducedXmlLog="";
	reducedXmlLog+="Log generated by FET "+FET_VERSION+" on "+sTime+"\n\n";
	QString shortFileName=fileName.right(fileName.length()-fileName.lastIndexOf(FILE_SEP)-1);
	reducedXmlLog+="Reading file "+shortFileName+"\n";
	QFileInfo fileinfo(fileName);
	reducedXmlLog+="Complete file name, including path: "+QDir::toNativeSeparators(fileinfo.canonicalFilePath())+"\n";
	reducedXmlLog+="\n";

	QString tmp;
	if(commandLine)
		tmp=commandLineDirectory+"logs"+FILE_SEP+XML_PARSING_LOG_FILENAME;
	else
		tmp=OUTPUT_DIR+FILE_SEP+"logs"+FILE_SEP+XML_PARSING_LOG_FILENAME;
	QFile file2(tmp);
	bool canWriteLogFile=true;
#if QT_VERSION >= QT_VERSION_CHECK(6,0,0)
	if(!file2.open(QIODeviceBase::WriteOnly)){
#else
	if(!file2.open(QIODevice::WriteOnly)){
#endif
		QString s=tr("FET cannot open the log file %1 for writing. This might mean that you don't"
			" have write permissions in this location. You can continue operation, but you might not be able to save the generated timetables"
			" as HTML files").arg(QDir::toNativeSeparators(tmp))+
			"\n\n"+tr("A solution is to remove that file (if it exists already) or set its permissions to allow writing")+
			"\n\n"+tr("Please report possible bug");
		IrreconcilableCriticalMessage::critical(parent, tr("FET critical"), s);
		canWriteLogFile=false;
	}
	QTextStream logStream;
	if(canWriteLogFile){
		logStream.setDevice(&file2);
#if QT_VERSION >= QT_VERSION_CHECK(6,0,0)
		logStream.setEncoding(QStringConverter::Utf8);
#else
		logStream.setCodec("UTF-8");
#endif
		logStream.setGenerateByteOrderMark(true);
	}
	
	bool okAbove3_12_17=true;
	bool version5AndAbove=false;
	bool warning=false;

	bool version6AndAbove=false;
	bool probably5Morocco=false;
	bool probably5Algeria=false;
	bool probably5MA=false;
	
	bool probably5BP=false;

	bool probably5Terms=false;
	
	QString file_version;
	
	if(xmlReader.readNextStartElement()){
		xmlReadingLog+=" Found "+xmlReader.name().toString()+" tag\n";
	
		bool okfetTag;
		if(xmlReader.name()==QString("fet") || xmlReader.name()==QString("FET")) //the new tag is fet, the old tag - FET
			okfetTag=true;
		else
			okfetTag=false;
	
		if(!okfetTag)
			okAbove3_12_17=false;
		else{
			assert(xmlReader.isStartElement());
			assert(okAbove3_12_17==true);
			/*QDomDocumentType dt=doc.doctype();
			if(dt.isNull() || dt.name()!="FET")
				okAbove3_12_17=false;
			else*/
			int filev[3], fetv[3];
			QString fileVersionSuffix;
			
			assert(xmlReader.name()==QString("fet") || xmlReader.name()==QString("FET"));
			QString version=xmlReader.attributes().value("version").toString();
			file_version=version;
		
/*			QDomAttr a=elem1.attributeNode("version");
			
			QString version=a.value();
			file_version=version;*/
			
			QRegularExpression fileVerReCap("^(\\d+)\\.(\\d+)\\.(\\d+)(.*)$");
			QRegularExpressionMatch match=fileVerReCap.match(file_version);
			filev[0]=filev[1]=filev[2]=-1;
			if(!match.hasMatch()){
				RulesReconcilableMessage::warning(parent, tr("FET warning"), tr("File contains a version numbering scheme which"
				" is not matched by v.v.va (3 numbers separated by points, followed by any string a, which may be empty). File will be opened, but you are advised"
				" to check the version of the .fet file (in the beginning of the file). If this is a FET bug, please report it")+"\n\n"+
				tr("If you are opening a file older than FET format version 5, it will be converted to latest FET data format"));
				if(VERBOSE){
					std::cout<<"Opened file version not matched by regexp"<<std::endl;
				}
			}
			else{
				bool ok;
				filev[0]=match.captured(1).toInt(&ok);
				assert(ok);
				filev[1]=match.captured(2).toInt(&ok);
				assert(ok);
				filev[2]=match.captured(3).toInt(&ok);
				assert(ok);
				fileVersionSuffix=match.captured(4);
				if(VERBOSE){
					std::cout<<"Opened file version matched by regexp: major="<<filev[0]<<", minor="<<filev[1]<<", revision="<<filev[2];
					std::cout<<", additional text="<<qPrintable(match.captured(4))<<"."<<std::endl;
				}
			}
		
			QRegularExpression fetVerReCap("^(\\d+)\\.(\\d+)\\.(\\d+)(.*)$");
			match=fetVerReCap.match(FET_VERSION);
			
			fetv[0]=fetv[1]=fetv[2]=-1;
			if(!match.hasMatch()){
				RulesReconcilableMessage::warning(parent, tr("FET warning"), tr("FET version does not respect the format v.v.va"
				" (3 numbers separated by points, followed by any string a, which may be empty). This is probably a bug in FET - please report it"));
				if(VERBOSE){
					std::cout<<"FET version not matched by regexp"<<std::endl;
				}
			}
			else{
				bool ok;
				fetv[0]=match.captured(1).toInt(&ok);
				assert(ok);
				fetv[1]=match.captured(2).toInt(&ok);
				assert(ok);
				fetv[2]=match.captured(3).toInt(&ok);
				assert(ok);
				if(VERBOSE){
					std::cout<<"FET version matched by regexp: major="<<fetv[0]<<", minor="<<fetv[1]<<", revision="<<fetv[2];
					std::cout<<", additional text="<<qPrintable(match.captured(4))<<"."<<std::endl;
				}
			}
			
			if(filev[0]>=0 && fetv[0]>=0 && filev[1]>=0 && fetv[1]>=0 && filev[2]>=0 && fetv[2]>=0){
				if(filev[0]>fetv[0] || (filev[0]==fetv[0] && filev[1]>fetv[1]) || (filev[0]==fetv[0]&&filev[1]==fetv[1]&&filev[2]>fetv[2])){
					warning=true;
				}
			}
		
			if(filev[0]>=5 || (filev[0]==-1 && filev[1]==-1 && filev[2]==-1))
			//if major is >= 5 or major cannot be read
				version5AndAbove=true;

			if(filev[0]>=6 || (filev[0]==-1 && filev[1]==-1 && filev[2]==-1))
			//if major is >= 6 or major cannot be read
				version6AndAbove=true;
				
			if(version5AndAbove && !version6AndAbove){
				if(fileVersionSuffix==QString("-ma") || (fileVersionSuffix.length()>3 && fileVersionSuffix.startsWith(QString("-ma"))
				 && ((fileVersionSuffix[3]>='0' && fileVersionSuffix[3]<='9') || fileVersionSuffix[3]=='-' || fileVersionSuffix[3]=='_' )))
					probably5MA=true;
				else if(fileVersionSuffix==QString("-morocco") || (fileVersionSuffix.length()>8 && fileVersionSuffix.startsWith(QString("-morocco"))
				 && ((fileVersionSuffix[8]>='0' && fileVersionSuffix[8]<='9') || fileVersionSuffix[8]=='-' || fileVersionSuffix[8]=='_' )))
					probably5Morocco=true;
				else if(fileVersionSuffix==QString("-algeria") || (fileVersionSuffix.length()>8 && fileVersionSuffix.startsWith(QString("-algeria"))
				 && ((fileVersionSuffix[8]>='0' && fileVersionSuffix[8]<='9') || fileVersionSuffix[8]=='-' || fileVersionSuffix[8]=='_' )))
					probably5Algeria=true;
				
				//maybe block-planning
				else if(fileVersionSuffix==QString("-bp") || (fileVersionSuffix.length()>3 && fileVersionSuffix.startsWith(QString("-bp"))
				 && ((fileVersionSuffix[3]>='0' && fileVersionSuffix[3]<='9') || fileVersionSuffix[3]=='-' || fileVersionSuffix[3]=='_' )))
					probably5BP=true;

				//maybe terms
				else if(fileVersionSuffix==QString("-mathmake") || (fileVersionSuffix.length()>9 && fileVersionSuffix.startsWith(QString("-mathmake"))
				 && ((fileVersionSuffix[9]>='0' && fileVersionSuffix[9]<='9') || fileVersionSuffix[9]=='-' || fileVersionSuffix[9]=='_' )))
					probably5Terms=true;
			}
		}
	}
	else{
		okAbove3_12_17=false;
	}
	if(!okAbove3_12_17){
		if(VERBOSE){
			std::cout<<"Invalid fet 3.12.17 or above input file"<<std::endl;
		}
		file.close();
		
		if(canWriteLogFile){
			xmlReadingLog+="  Incorrect/incomplete FET XML data file.\n";

			reducedXmlLog+="\n";
			reducedXmlLog+="Incorrect/incomplete FET XML data file.\n";
			logStream<<reducedXmlLog;

			file2.close();
		}
		
		RulesIrreconcilableMessage::warning(parent, tr("FET warning"), tr("File is incorrect...it cannot be opened"));
		return false;
	}
	
	if(!version5AndAbove){
		RulesReconcilableMessage::warning(parent, tr("FET information"),
		 tr("Opening older file - it will be converted to latest format, automatically "
		 "assigning weight percentages to constraints and dropping parity (weekly/fortnightly) for activities. "
		 "You are advised to make a backup of your old file before saving in new format.\n\n"
		 "Please note that the default weight percentage of constraints min days between activities "
		 "will be 95% (mainly satisfied, not always) and 'consecutive if on the same day' will be set to true "
		 "(meaning that if the activities are on the same day, they will be placed continuously, in a bigger duration activity). "
		 "If you want, you can modify this percent to be 100%, manually in the fet input file "
		 "or from the interface"));
	}
	else if(!version6AndAbove){
		QString s="";
		if(probably5MA)
			s=tr("Opening an older file - it will be converted to the latest format. FET detected that this file was generated with a custom FET-5-MA version for mornings-afternoons,"
			 " because the file version contains the string '-ma'. Some constraints will be renamed. The new style will refer to half days as 'days' and to real days as 'real days'."
			 " Please be very careful and check once more the list of your constraints. If this is not true, please report the bug.");
		else if(probably5Morocco)
			s=tr("Opening an older file - it will be converted to the latest format. FET detected that this file was generated with a custom FET-5-Morocco version for mornings-afternoons,"
			 " because the file version contains the string '-morocco'. Some constraints will be renamed. The new style will refer to half days as 'days' and to real days as 'real days'."
			 " Please be very careful and check once more the list of your constraints. If this is not true, please report the bug.");
		else if(probably5Algeria)
			s=tr("Opening an older file - it will be converted to the latest format. FET detected that this file was generated with a custom FET-5-Algeria version for mornings-afternoons,"
			 " because the file version contains the string '-algeria'. Some constraints will be renamed. The new style will refer to half days as 'days' and to real days as 'real days'."
			 " Please be very careful and check once more the list of your constraints. If this is not true, please report the bug.");
		else if(probably5BP)
			s=tr("Opening an older file - it will be converted to the latest format. FET detected that this file was generated with a custom FET-5-BP (block-planning) version,"
			 " because the file version contains the string '-bp'. Please be very careful and check once more the list of your constraints. If this is not true, please report the bug.");
		else if(probably5Terms)
			s=tr("Opening an older file - it will be converted to the latest format. FET detected that this file was generated with a custom FET-5-mathmake (terms) version,"
			 " because the file version contains the string '-mathmake'. Please be very careful and check once more the list of your constraints. If this is not true, please report the bug.");
		else
			s=tr("Opening an older file - it will be converted to the latest format. FET detected that this file was generated with a FET-5 version."
			" After opening, please check your constraints. If this is not true, please report the bug.");
		s+="\n\n";
		s+=tr("It is advisable to keep a backup copy of your old file.");
		RulesReconcilableMessage::warning(parent, tr("FET information"), s);
	}
	
	if(warning){
		RulesReconcilableMessage::warning(parent, tr("FET information"),
		 tr("Opening a file generated with a newer version than your current FET software ... file will be opened but it is recommended to update your FET software to the latest version")
		 +"\n\n"+tr("Your FET version: %1, file version: %2").arg(FET_VERSION).arg(file_version));
	}
	
	//int oldMode=this->mode;
	this->mode=OFFICIAL;
	if(probably5Morocco || probably5Algeria || probably5MA)
		this->mode=MORNINGS_AFTERNOONS;
	else if(probably5BP)
		this->mode=BLOCK_PLANNING;
	else if(probably5Terms)
		this->mode=TERMS;
	
	this->institutionName=tr("Default institution");
	this->comments=tr("Default comments");

	//default for terms (Finland)
	this->nTerms=5;
	this->nDaysPerTerm=5;

	this->nDaysPerWeek=5;
	this->daysOfTheWeek.clear();
	this->daysOfTheWeek.append(QString("D1"));
	this->daysOfTheWeek.append(QString("D2"));
	this->daysOfTheWeek.append(QString("D3"));
	this->daysOfTheWeek.append(QString("D4"));
	this->daysOfTheWeek.append(QString("D5"));
	
	this->nRealDaysPerWeek=-1;
	this->realDaysOfTheWeek.clear();

	this->nHoursPerDay=12;
	this->hoursOfTheDay.clear();
	this->hoursOfTheDay.append(QString("H1"));
	this->hoursOfTheDay.append(QString("H2"));
	this->hoursOfTheDay.append(QString("H3"));
	this->hoursOfTheDay.append(QString("H4"));
	this->hoursOfTheDay.append(QString("H5"));
	this->hoursOfTheDay.append(QString("H6"));
	this->hoursOfTheDay.append(QString("H7"));
	this->hoursOfTheDay.append(QString("H8"));
	this->hoursOfTheDay.append(QString("H9"));
	this->hoursOfTheDay.append(QString("H10"));
	this->hoursOfTheDay.append(QString("H11"));
	this->hoursOfTheDay.append(QString("H12"));

	this->nRealHoursPerDay=-1;
	this->realHoursOfTheDay.clear();

	this->daysOfTheWeek_longNames.clear();
	this->daysOfTheWeek_longNames.append(tr("Monday"));
	this->daysOfTheWeek_longNames.append(tr("Tuesday"));
	this->daysOfTheWeek_longNames.append(tr("Wednesday"));
	this->daysOfTheWeek_longNames.append(tr("Thursday"));
	this->daysOfTheWeek_longNames.append(tr("Friday"));
	
	this->realDaysOfTheWeek_longNames.clear();
	
	this->hoursOfTheDay_longNames.clear();
	this->hoursOfTheDay_longNames.append(tr("08:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("09:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("10:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("11:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("12:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("13:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("14:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("15:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("16:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("17:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("18:00", "Hour name"));
	this->hoursOfTheDay_longNames.append(tr("19:00", "Hour name"));

	this->realHoursOfTheDay.clear();
	
	bool skipDeprecatedConstraints=false;
	
	bool skipDuplicatedStudentsSets=false;
	
	assert(xmlReader.isStartElement() && (xmlReader.name()==QString("fet") || xmlReader.name()==QString("FET")));
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="  Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Mode")){
			QString text=xmlReader.readElementText();
			if(text=="Official")
				this->mode=OFFICIAL;
			else if(text=="Mornings_Afternoons")
				this->mode=MORNINGS_AFTERNOONS;
			else if(text=="Block_Planning")
				this->mode=BLOCK_PLANNING;
			else if(text=="Terms")
				this->mode=TERMS;
			else
				xmlReader.raiseError(tr("Incorrect mode - it has to be %1, %2, %3, or %4.").arg("Official").arg("Mornings_Afternoons").arg("Block_Planning").arg("Terms"));
			xmlReadingLog+="  Found mode="+text+"\n";
			reducedXmlLog+="Read mode="+text+"\n";
		}
		else if(xmlReader.name()==QString("Institution_Name")){
			QString text=xmlReader.readElementText();
			this->institutionName=text;
			xmlReadingLog+="  Found institution name="+this->institutionName+"\n";
			reducedXmlLog+="Read institution name="+this->institutionName+"\n";
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			this->comments=text;
			xmlReadingLog+="  Found comments="+this->comments+"\n";
			reducedXmlLog+="Read comments="+this->comments+"\n";
		}
		else if(xmlReader.name()==QString("Number_of_Terms")){
			QString text=xmlReader.readElementText();
			this->nTerms=text.toInt();
			xmlReadingLog+="  Found number of terms="+QString::number(this->nTerms)+"\n";
			reducedXmlLog+="Read number of terms="+QString::number(this->nTerms)+"\n";

			if(nTerms<=0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Number_of_Terms"));
			}
			else if(nTerms>MAX_DAYS_PER_WEEK){
				xmlReader.raiseError(tr("%1 is too large. Maximum allowed is %2.").arg("Number_of_Terms").arg(MAX_DAYS_PER_WEEK));
			}
			else{
				assert(nTerms>0 && nTerms<=MAX_DAYS_PER_WEEK);
			}
		}
		else if(xmlReader.name()==QString("Number_of_Days_Per_Term")){
			QString text=xmlReader.readElementText();
			this->nDaysPerTerm=text.toInt();
			xmlReadingLog+="  Found number of days per term="+QString::number(this->nDaysPerTerm)+"\n";
			reducedXmlLog+="Read number of days per term="+QString::number(this->nDaysPerTerm)+"\n";

			if(nDaysPerTerm<=0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Number_of_Days_Per_Term"));
			}
			else if(nDaysPerTerm>MAX_DAYS_PER_WEEK){
				xmlReader.raiseError(tr("%1 is too large. Maximum allowed is %2.").arg("Number_of_Days_Per_Term").arg(MAX_DAYS_PER_WEEK));
			}
			else{
				assert(nDaysPerTerm>0 && nDaysPerTerm<=MAX_DAYS_PER_WEEK);
			}
		}
		else if(xmlReader.name()==QString("Days_List")){
			this->daysOfTheWeek.clear();
			this->daysOfTheWeek_longNames.clear();
			int tmp=0;
			int tmp_longNames=0;
			bool numberWasFound=false;
			assert(xmlReader.isStartElement());
			QString numberString="Number_of_Days";
			QString dayString="Name";
			QString dayString_longNames="Long_Name";
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				if(xmlReader.name()==QString("Number") || xmlReader.name()==QString("Number_of_Days") ){
					numberString=xmlReader.name().toString();
					QString text=xmlReader.readElementText();
					this->nDaysPerWeek=text.toInt();
					numberWasFound=true;
					xmlReadingLog+="   Found the number of days per week = "+
					 CustomFETString::number(this->nDaysPerWeek)+"\n";
					reducedXmlLog+="Added "+
					 CustomFETString::number(this->nDaysPerWeek)+" days per week\n";
					if(nDaysPerWeek<=0){
						xmlReader.raiseError(tr("%1 is incorrect").arg(numberString));
					}
					else if(nDaysPerWeek>MAX_DAYS_PER_WEEK){
						xmlReader.raiseError(tr("%1 is too large. Maximum allowed is %2.").arg(numberString).arg(MAX_DAYS_PER_WEEK));
					}
					else{
						assert(this->nDaysPerWeek>0 && nDaysPerWeek<=MAX_DAYS_PER_WEEK);
					}
				}
				//old .fet XML format
				else if(xmlReader.name()==QString("Name")){
					dayString=xmlReader.name().toString();
					if(tmp>=MAX_DAYS_PER_WEEK){
						xmlReader.raiseError(tr("Too many %1 items. Maximum allowed is %2.").arg(dayString).arg(MAX_DAYS_PER_WEEK));
						xmlReader.skipCurrentElement();
					}
					else{
						QString text=xmlReader.readElementText();
						//this->daysOfTheWeek[tmp]=text;
						this->daysOfTheWeek.append(text);
						xmlReadingLog+="   Found day "+this->daysOfTheWeek[tmp]+"\n";
						tmp++;
					}
				}
				//end old .fet XML format
				else if(xmlReader.name()==QString("Day")){
					assert(xmlReader.isStartElement());
					while(xmlReader.readNextStartElement()){
						xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
						if(xmlReader.name()==QString("Name")){
							dayString=xmlReader.name().toString();
							if(tmp>=MAX_DAYS_PER_WEEK){
								xmlReader.raiseError(tr("Too many %1 items. Maximum allowed is %2.").arg(dayString).arg(MAX_DAYS_PER_WEEK));
								xmlReader.skipCurrentElement();
							}
							else{
								QString text=xmlReader.readElementText();
								this->daysOfTheWeek.append(text);
								//this->daysOfTheWeek[tmp]=text;
								xmlReadingLog+="   Found day "+this->daysOfTheWeek[tmp]+"\n";
								tmp++;
							}
						}
						else if(xmlReader.name()==QString("Long_Name")){
							dayString_longNames=xmlReader.name().toString();
							if(tmp_longNames>=MAX_DAYS_PER_WEEK){
								xmlReader.raiseError(tr("Too many %1 items. Maximum allowed is %2.").arg(dayString_longNames).arg(MAX_DAYS_PER_WEEK));
								xmlReader.skipCurrentElement();
							}
							else{
								QString text=xmlReader.readElementText();
								this->daysOfTheWeek_longNames.append(text);
								//this->daysOfTheWeek[tmp]=text;
								xmlReadingLog+="   Found day long name "+this->daysOfTheWeek_longNames[tmp_longNames]+"\n";
								tmp_longNames++;
							}
						}
						else{
							unrecognizedXmlTags.append(xmlReader.name().toString());
							unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
							unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

							xmlReader.skipCurrentElement();
							xmlReaderNumberOfUnrecognizedFields++;
						}
					}
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			if(!xmlReader.error()){
				if(!numberWasFound){
					xmlReader.raiseError(tr("%1 not found").arg(numberString));
				}
				else{
					if(!(tmp==nDaysPerWeek)){
						xmlReader.raiseError(tr("%1: %2 and the number of %3 read do not correspond", "%1 is an XML string, %2 is the specified number of days,"
						 " %3 is the number of actually read days.")
						 .arg("Days_List").arg(numberString).arg(dayString));
					}
					else if(tmp_longNames>0 && !(tmp_longNames==nDaysPerWeek)){
						xmlReader.raiseError(tr("%1: %2 and the number of %3 read do not correspond", "%1 is an XML string, %2 is the specified number of days,"
						 " %3 is the number of actually read days long names.")
						 .arg("Days_List").arg(numberString).arg(dayString_longNames));
					}
					else{
						if(tmp_longNames==0){
							tmp_longNames=nDaysPerWeek;
							for(int i=0; i<tmp_longNames; i++)
								this->daysOfTheWeek_longNames.append(QString(""));
						}
						
						assert(tmp==this->nDaysPerWeek);
						assert(tmp_longNames==this->nDaysPerWeek);
					}
				}
			}
		}
		else if(xmlReader.name()==QString("Real_Days_List")){
			this->realDaysOfTheWeek.clear();
			this->realDaysOfTheWeek_longNames.clear();
			int tmp=0;
			int tmp_longNames=0;
			bool numberWasFound=false;
			assert(xmlReader.isStartElement());
			QString numberString="Number_of_Real_Days";
			QString realDayString="Name";
			QString realDayString_longNames="Long_Name";
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				if(xmlReader.name()==QString("Number") || xmlReader.name()==QString("Number_of_Real_Days") ){
					numberString=xmlReader.name().toString();
					QString text=xmlReader.readElementText();
					this->nRealDaysPerWeek=text.toInt();
					numberWasFound=true;
					xmlReadingLog+="   Found the number of real days per week = "+
					 CustomFETString::number(this->nRealDaysPerWeek)+"\n";
					reducedXmlLog+="Added "+
					 CustomFETString::number(this->nRealDaysPerWeek)+" real days per week\n";
					if(nRealDaysPerWeek<0){ //may be 0 if there is a single FET (half) day
						xmlReader.raiseError(tr("%1 is incorrect").arg(numberString));
					}
					else if(nRealDaysPerWeek>MAX_DAYS_PER_WEEK/2){
						xmlReader.raiseError(tr("%1 is too large. Maximum allowed is %2.").arg(numberString).arg(MAX_DAYS_PER_WEEK/2));
					}
					else{
						assert(this->nRealDaysPerWeek>=0 && nRealDaysPerWeek<=MAX_DAYS_PER_WEEK/2);
					}
				}
				//old .fet XML format
				/*else if(xmlReader.name()==QString("Name")){
					dayString=xmlReader.name().toString();
					if(tmp>=MAX_DAYS_PER_WEEK){
						xmlReader.raiseError(tr("Too many %1 items. Maximum allowed is %2.").arg(dayString).arg(MAX_DAYS_PER_WEEK));
						xmlReader.skipCurrentElement();
					}
					else{
						QString text=xmlReader.readElementText();
						//this->daysOfTheWeek[tmp]=text;
						this->daysOfTheWeek.append(text);
						xmlReadingLog+="   Found day "+this->daysOfTheWeek[tmp]+"\n";
						tmp++;
					}
				}*/
				//end old .fet XML format
				else if(xmlReader.name()==QString("Real_Day")){
					assert(xmlReader.isStartElement());
					while(xmlReader.readNextStartElement()){
						xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
						if(xmlReader.name()==QString("Name")){
							realDayString=xmlReader.name().toString();
							if(tmp>=MAX_DAYS_PER_WEEK/2){
								xmlReader.raiseError(tr("Too many %1 items. Maximum allowed is %2.").arg(realDayString).arg(MAX_DAYS_PER_WEEK/2));
								xmlReader.skipCurrentElement();
							}
							else{
								QString text=xmlReader.readElementText();
								this->realDaysOfTheWeek.append(text);
								//this->daysOfTheWeek[tmp]=text;
								xmlReadingLog+="   Found real day "+this->realDaysOfTheWeek[tmp]+"\n";
								tmp++;
							}
						}
						else if(xmlReader.name()==QString("Long_Name")){
							realDayString_longNames=xmlReader.name().toString();
							if(tmp>=MAX_DAYS_PER_WEEK/2){
								xmlReader.raiseError(tr("Too many %1 items. Maximum allowed is %2.").arg(realDayString_longNames).arg(MAX_DAYS_PER_WEEK/2));
								xmlReader.skipCurrentElement();
							}
							else{
								QString text=xmlReader.readElementText();
								this->realDaysOfTheWeek_longNames.append(text);
								//this->daysOfTheWeek[tmp]=text;
								xmlReadingLog+="   Found real day long name"+this->realDaysOfTheWeek_longNames[tmp_longNames]+"\n";
								tmp_longNames++;
							}
						}
						else{
							unrecognizedXmlTags.append(xmlReader.name().toString());
							unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
							unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

							xmlReader.skipCurrentElement();
							xmlReaderNumberOfUnrecognizedFields++;
						}
					}
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			if(!xmlReader.error()){
				if(!numberWasFound){
					xmlReader.raiseError(tr("%1 not found").arg(numberString));
				}
				else{
					if(!(tmp==nRealDaysPerWeek)){
						xmlReader.raiseError(tr("%1: %2 and the number of %3 read do not correspond", "%1 is an XML string, %2 is the specified number of real days,"
						 " %3 is the number of actually read real days.")
						 .arg("Real_Days_List").arg(numberString).arg(realDayString));
					}
					else if(tmp_longNames>0 && !(tmp_longNames==nRealDaysPerWeek)){
						xmlReader.raiseError(tr("%1: %2 and the number of %3 read do not correspond", "%1 is an XML string, %2 is the specified number of real days,"
						 " %3 is the number of actually read real days long names.")
						 .arg("Real_Days_List").arg(numberString).arg(realDayString_longNames));
					}
					else{
						if(tmp_longNames==0){
							tmp_longNames=nRealDaysPerWeek;
							for(int i=0; i<tmp_longNames; i++)
								this->realDaysOfTheWeek_longNames.append(QString(""));
						}

						assert(tmp==this->nRealDaysPerWeek);
						assert(tmp_longNames==this->nRealDaysPerWeek);
					}
				}
			}
		}
		else if(xmlReader.name()==QString("Hours_List")){
			this->hoursOfTheDay.clear();
			this->hoursOfTheDay_longNames.clear();
			int tmp=0;
			int tmp_longNames=0;
			bool numberWasFound=false;
			assert(xmlReader.isStartElement());
			QString numberString="Number_of_Hours";
			QString hourString="Name";
			QString hourString_longNames="Long_Name";
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				if(xmlReader.name()==QString("Number") || xmlReader.name()==QString("Number_of_Hours")){
					numberString=xmlReader.name().toString();
					QString text=xmlReader.readElementText();
					this->nHoursPerDay=text.toInt();
					numberWasFound=true;
					xmlReadingLog+="   Found the number of hours per day = "+
					 CustomFETString::number(this->nHoursPerDay)+"\n";
					reducedXmlLog+="Added "+
					 CustomFETString::number(this->nHoursPerDay)+" hours per day\n";
					if(nHoursPerDay<=0){
						xmlReader.raiseError(tr("%1 is incorrect").arg(numberString));
					}
					else if(nHoursPerDay>MAX_HOURS_PER_DAY){
						xmlReader.raiseError(tr("%1 is too large. Maximum allowed is %2.").arg("Number").arg(MAX_HOURS_PER_DAY));
					}
					else{
						assert(this->nHoursPerDay>0 && nHoursPerDay<=MAX_HOURS_PER_DAY);
					}
				}
				//old .fet XML format
				else if(xmlReader.name()==QString("Name")){
					hourString=xmlReader.name().toString();
					if(tmp>=MAX_HOURS_PER_DAY){
						xmlReader.raiseError(tr("Too many %1 items. Maximum allowed is %2.").arg(hourString).arg(MAX_HOURS_PER_DAY));
						xmlReader.skipCurrentElement();
					}
					else{
						QString text=xmlReader.readElementText();
						//this->hoursOfTheDay[tmp]=text;
						this->hoursOfTheDay.append(text);
						xmlReadingLog+="   Found hour "+this->hoursOfTheDay[tmp]+"\n";
						tmp++;
					}
				}
				//end old .fet XML format
				else if(xmlReader.name()==QString("Hour")){
					assert(xmlReader.isStartElement());
					while(xmlReader.readNextStartElement()){
						xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
						if(xmlReader.name()==QString("Name")){
							hourString=xmlReader.name().toString();
							if(tmp>=MAX_HOURS_PER_DAY){
								xmlReader.raiseError(tr("Too many %1 items. Maximum allowed is %2.").arg(hourString).arg(MAX_HOURS_PER_DAY));
								xmlReader.skipCurrentElement();
							}
							else{
								QString text=xmlReader.readElementText();
								//this->hoursOfTheDay[tmp]=text;
								this->hoursOfTheDay.append(text);
								xmlReadingLog+="    Found hour "+this->hoursOfTheDay[tmp]+"\n";
								tmp++;
							}
						}
						else if(xmlReader.name()==QString("Long_Name")){
							hourString_longNames=xmlReader.name().toString();
							if(tmp_longNames>=MAX_HOURS_PER_DAY){
								xmlReader.raiseError(tr("Too many %1 items. Maximum allowed is %2.").arg(hourString_longNames).arg(MAX_HOURS_PER_DAY));
								xmlReader.skipCurrentElement();
							}
							else{
								QString text=xmlReader.readElementText();
								//this->hoursOfTheDay[tmp]=text;
								this->hoursOfTheDay_longNames.append(text);
								xmlReadingLog+="    Found hour long name "+this->hoursOfTheDay_longNames[tmp_longNames]+"\n";
								tmp_longNames++;
							}
						}
						else{
							unrecognizedXmlTags.append(xmlReader.name().toString());
							unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
							unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

							xmlReader.skipCurrentElement();
							xmlReaderNumberOfUnrecognizedFields++;
						}
					}
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			if(!xmlReader.error()){
				if(!numberWasFound){
					xmlReader.raiseError(tr("%1 not found").arg(numberString));
				}
				else{
					if(numberString=="Number"){
						//some older files contain also the end of day hour, so tmp==nHoursPerDay+1 in this case
						if(!(tmp==nHoursPerDay || tmp==nHoursPerDay+1))
							xmlReader.raiseError(tr("%1: %2 and the number of %3 read do not correspond", "%1 is an XML string, %2 is the specified number of hours,"
							 " %3 is the number of actually read hours.")
							 .arg("Hours_List").arg(numberString).arg(hourString));
						else{
							assert(tmp==nHoursPerDay || tmp==nHoursPerDay+1);

							for(int i=0; i<nHoursPerDay; i++)
								this->hoursOfTheDay_longNames.append(QString(""));
						}
					}
					else{
						assert(numberString=="Number_of_Hours");
						if(!(tmp==nHoursPerDay)){
							xmlReader.raiseError(tr("%1: %2 and the number of %3 read do not correspond", "%1 is an XML string, %2 is the specified number of hours,"
							 " %3 is the number of actually read hours.")
							 .arg("Hours_List").arg(numberString).arg(hourString));
						}
						else if(tmp_longNames>0 && !(tmp_longNames==nHoursPerDay)){
							xmlReader.raiseError(tr("%1: %2 and the number of %3 read do not correspond", "%1 is an XML string, %2 is the specified number of hours,"
							 " %3 is the number of actually read hours long names.")
							 .arg("Hours_List").arg(numberString).arg(hourString_longNames));
						}
						else{
							if(tmp_longNames==0){
								tmp_longNames=nHoursPerDay;
								for(int i=0; i<tmp_longNames; i++)
									this->hoursOfTheDay_longNames.append(QString(""));
							}

							assert(tmp==nHoursPerDay);
							assert(tmp_longNames==nHoursPerDay);
						}
					}
				}
			}
		}
		else if(xmlReader.name()==QString("Real_Hours_List")){
			this->realHoursOfTheDay.clear();
			this->realHoursOfTheDay_longNames.clear();
			int tmp=0;
			int tmp_longNames=0;
			bool numberWasFound=false;
			assert(xmlReader.isStartElement());
			QString numberString="Number_of_Real_Hours";
			QString realHourString="Name";
			QString realHourString_longNames="Long_Name";
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				if(xmlReader.name()==QString("Number") || xmlReader.name()==QString("Number_of_Real_Hours")){
					numberString=xmlReader.name().toString();
					QString text=xmlReader.readElementText();
					this->nRealHoursPerDay=text.toInt();
					numberWasFound=true;
					xmlReadingLog+="   Found the number of real hours per day = "+
					 CustomFETString::number(this->nRealHoursPerDay)+"\n";
					reducedXmlLog+="Added "+
					 CustomFETString::number(this->nRealHoursPerDay)+" real hours per day\n";
					if(nRealHoursPerDay<0){
						xmlReader.raiseError(tr("%1 is incorrect").arg(numberString));
					}
					else if(nRealHoursPerDay>2*MAX_HOURS_PER_DAY){
						xmlReader.raiseError(tr("%1 is too large. Maximum allowed is %2.").arg("Number").arg(2*MAX_HOURS_PER_DAY));
					}
					else{
						assert(this->nRealHoursPerDay>=0 && nRealHoursPerDay<=2*MAX_HOURS_PER_DAY);
					}
				}
				//old .fet XML format
				/*else if(xmlReader.name()==QString("Name")){
					hourString=xmlReader.name().toString();
					if(tmp>=MAX_HOURS_PER_DAY){
						xmlReader.raiseError(tr("Too many %1 items. Maximum allowed is %2.").arg(hourString).arg(MAX_HOURS_PER_DAY));
						xmlReader.skipCurrentElement();
					}
					else{
						QString text=xmlReader.readElementText();
						//this->hoursOfTheDay[tmp]=text;
						this->hoursOfTheDay.append(text);
						xmlReadingLog+="   Found hour "+this->hoursOfTheDay[tmp]+"\n";
						tmp++;
					}
				}*/
				//end old .fet XML format
				else if(xmlReader.name()==QString("Real_Hour")){
					assert(xmlReader.isStartElement());
					while(xmlReader.readNextStartElement()){
						xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
						if(xmlReader.name()==QString("Name")){
							realHourString=xmlReader.name().toString();
							if(tmp>=2*MAX_HOURS_PER_DAY){
								xmlReader.raiseError(tr("Too many %1 items. Maximum allowed is %2.").arg(realHourString).arg(2*MAX_HOURS_PER_DAY));
								xmlReader.skipCurrentElement();
							}
							else{
								QString text=xmlReader.readElementText();
								//this->hoursOfTheDay[tmp]=text;
								this->realHoursOfTheDay.append(text);
								xmlReadingLog+="    Found real hour "+this->realHoursOfTheDay[tmp]+"\n";
								tmp++;
							}
						}
						else if(xmlReader.name()==QString("Long_Name")){
							realHourString_longNames=xmlReader.name().toString();
							if(tmp>=2*MAX_HOURS_PER_DAY){
								xmlReader.raiseError(tr("Too many %1 items. Maximum allowed is %2.").arg(realHourString_longNames).arg(2*MAX_HOURS_PER_DAY));
								xmlReader.skipCurrentElement();
							}
							else{
								QString text=xmlReader.readElementText();
								//this->hoursOfTheDay[tmp]=text;
								this->realHoursOfTheDay_longNames.append(text);
								xmlReadingLog+="    Found real hour long name"+this->realHoursOfTheDay_longNames[tmp_longNames]+"\n";
								tmp_longNames++;
							}
						}
						else{
							unrecognizedXmlTags.append(xmlReader.name().toString());
							unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
							unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

							xmlReader.skipCurrentElement();
							xmlReaderNumberOfUnrecognizedFields++;
						}
					}
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			/*if(!xmlReader.error()){
				if(!numberWasFound){
					xmlReader.raiseError(tr("%1 not found").arg(numberString));
				}
				else{
					if(numberString=="Number"){
						//some older files contain also the end of day hour, so tmp==nHoursPerDay+1 in this case
						if(!(tmp==nHoursPerDay || tmp==nHoursPerDay+1))
							xmlReader.raiseError(tr("%1: %2 and the number of %3 read do not correspond", "%1 is an XML string, %2 is the specified number of hours,"
							 " %3 is the number of actually read hours.")
							 .arg("Hours_List").arg(numberString).arg(hourString));
						else
							assert(tmp==nHoursPerDay || tmp==nHoursPerDay+1);
					}
					else{
						assert(numberString=="Number_of_Hours");
						if(!(tmp==nHoursPerDay))
							xmlReader.raiseError(tr("%1: %2 and the number of %3 read do not correspond", "%1 is an XML string, %2 is the specified number of hours,"
							 " %3 is the number of actually read hours.")
							 .arg("Hours_List").arg(numberString).arg(hourString));
						else
							assert(tmp==nHoursPerDay);
					}
				}
			}*/
			if(!xmlReader.error()){
				if(!numberWasFound){
					xmlReader.raiseError(tr("%1 not found").arg(numberString));
				}
				else{
					if(!(tmp==nRealHoursPerDay)){
						xmlReader.raiseError(tr("%1: %2 and the number of %3 read do not correspond", "%1 is an XML string, %2 is the specified number of real hours,"
						 " %3 is the number of actually read real hours.")
						 .arg("Real_Hours_List").arg(numberString).arg(realHourString));
					}
					else if(tmp_longNames>0 && !(tmp_longNames==nRealHoursPerDay)){
						xmlReader.raiseError(tr("%1: %2 and the number of %3 read do not correspond", "%1 is an XML string, %2 is the specified number of real hours,"
						 " %3 is the number of actually read real hours long names.")
						 .arg("Real_Hours_List").arg(numberString).arg(realHourString_longNames));
					}
					else{
						if(tmp_longNames==0){
							tmp_longNames=nRealHoursPerDay;
							for(int i=0; i<tmp_longNames; i++)
								this->realHoursOfTheDay_longNames.append(QString(""));
						}

						assert(tmp==this->nRealHoursPerDay);
						assert(tmp_longNames==this->nRealHoursPerDay);
					}
				}
			}
		}
		else if(xmlReader.name()==QString("Subjects_List")){
			QSet<QString> subjectsRead;
		
			int tmp=0;
			assert(xmlReader.isStartElement());
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				if(xmlReader.name()==QString("Subject")){
					Subject* subject=new Subject();
					assert(xmlReader.isStartElement());
					while(xmlReader.readNextStartElement()){
						xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
						if(xmlReader.name()==QString("Name")){
							QString text=xmlReader.readElementText();
							subject->name=text;
							xmlReadingLog+="    Read subject name: "+subject->name+"\n";
						}
						else if(xmlReader.name()==QString("Long_Name")){
							QString text=xmlReader.readElementText();
							subject->longName=text;
							xmlReadingLog+="    Read subject long name: "+subject->longName+"\n";
						}
						else if(xmlReader.name()==QString("Code")){
							QString text=xmlReader.readElementText();
							subject->code=text;
							xmlReadingLog+="    Read subject code: "+subject->code+"\n";
						}
						else if(xmlReader.name()==QString("Comments")){
							QString text=xmlReader.readElementText();
							subject->comments=text;
							xmlReadingLog+="    Crt. subject comments="+subject->comments+"\n";
						}
						else{
							unrecognizedXmlTags.append(xmlReader.name().toString());
							unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
							unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

							xmlReader.skipCurrentElement();
							xmlReaderNumberOfUnrecognizedFields++;
						}
					}
					bool tmp2=subjectsRead.contains(subject->name);
					if(tmp2){
						RulesReconcilableMessage::warning(parent, tr("FET warning"),
						 tr("Duplicate subject %1 found - ignoring").arg(subject->name));
						xmlReadingLog+="   Subject not added - duplicate\n";
						
						delete subject;
					}
					else{
						subjectsRead.insert(subject->name);
						this->addSubjectFast(subject);
						tmp++;
						xmlReadingLog+="   Subject inserted\n";
					}
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			if(!(tmp==this->subjectsList.size()))
				xmlReader.raiseError(tr("%1 is incorrect").arg("Subjects_List"));
			else{
				assert(tmp==this->subjectsList.size());
				xmlReadingLog+="  Added "+CustomFETString::number(tmp)+" subjects\n";
				reducedXmlLog+="Added "+CustomFETString::number(tmp)+" subjects\n";
			}
		}
		else if(xmlReader.name()==QString("Subject_Tags_List")){
			QSet<QString> activityTagsRead;
		
			RulesReconcilableMessage::information(parent, tr("FET information"), tr("Your file contains subject tags list"
			  ", which is named in versions>=5.5.0 activity tags list"));
		
			int tmp=0;
			assert(xmlReader.isStartElement());
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				if(xmlReader.name()==QString("Subject_Tag")){
					ActivityTag* activityTag=new ActivityTag();
					assert(xmlReader.isStartElement());
					while(xmlReader.readNextStartElement()){
						xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
						if(xmlReader.name()==QString("Name")){
							QString text=xmlReader.readElementText();
							activityTag->name=text;
							xmlReadingLog+="    Read activity tag name: "+activityTag->name+"\n";
						}
						else if(xmlReader.name()==QString("Comments")){
							QString text=xmlReader.readElementText();
							activityTag->comments=text;
							xmlReadingLog+="    Crt. activity tag comments="+activityTag->comments+"\n";
						}
						else{
							unrecognizedXmlTags.append(xmlReader.name().toString());
							unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
							unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

							xmlReader.skipCurrentElement();
							xmlReaderNumberOfUnrecognizedFields++;
						}
					}
					bool tmp2=activityTagsRead.contains(activityTag->name);
					if(tmp2){
						RulesReconcilableMessage::warning(parent, tr("FET warning"),
						 tr("Duplicate activity tag %1 found - ignoring").arg(activityTag->name));
						xmlReadingLog+="   Activity tag not added - duplicate\n";
						
						delete activityTag;
					}
					else{
						activityTagsRead.insert(activityTag->name);
						addActivityTagFast(activityTag);
						tmp++;
						xmlReadingLog+="   Activity tag inserted\n";
					}
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			if(!(tmp==this->activityTagsList.size()))
				xmlReader.raiseError(tr("%1 is incorrect").arg("Subject_Tags_List"));
			else{
				assert(tmp==this->activityTagsList.size());
				xmlReadingLog+="  Added "+CustomFETString::number(tmp)+" activity tags\n";
				reducedXmlLog+="Added "+CustomFETString::number(tmp)+" activity tags\n";
			}
		}
		else if(xmlReader.name()==QString("Activity_Tags_List")){
			QSet<QString> activityTagsRead;
		
			int tmp=0;
			assert(xmlReader.isStartElement());
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				if(xmlReader.name()==QString("Activity_Tag")){
					ActivityTag* activityTag=new ActivityTag();
					assert(xmlReader.isStartElement());
					while(xmlReader.readNextStartElement()){
						xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
						if(xmlReader.name()==QString("Name")){
							QString text=xmlReader.readElementText();
							activityTag->name=text;
							xmlReadingLog+="    Read activity tag name: "+activityTag->name+"\n";
						}
						else if(xmlReader.name()==QString("Long_Name")){
							QString text=xmlReader.readElementText();
							activityTag->longName=text;
							xmlReadingLog+="    Read activity tag long name: "+activityTag->longName+"\n";
						}
						else if(xmlReader.name()==QString("Code")){
							QString text=xmlReader.readElementText();
							activityTag->code=text;
							xmlReadingLog+="    Read activity tag code: "+activityTag->code+"\n";
						}
						else if(xmlReader.name()==QString("Printable")){
							QString text=xmlReader.readElementText();
							if(text=="true")
								activityTag->printable=true;
							else
								activityTag->printable=false;
							xmlReadingLog+="    Read activity tag printable="+text+"\n";
						}
						else if(xmlReader.name()==QString("Comments")){
							QString text=xmlReader.readElementText();
							activityTag->comments=text;
							xmlReadingLog+="    Crt. activity tag comments="+activityTag->comments+"\n";
						}
						else{
							unrecognizedXmlTags.append(xmlReader.name().toString());
							unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
							unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

							xmlReader.skipCurrentElement();
							xmlReaderNumberOfUnrecognizedFields++;
						}
					}
					bool tmp2=activityTagsRead.contains(activityTag->name);
					if(tmp2){
						RulesReconcilableMessage::warning(parent, tr("FET warning"),
						 tr("Duplicate activity tag %1 found - ignoring").arg(activityTag->name));
						xmlReadingLog+="   Activity tag not added - duplicate\n";
						
						delete activityTag;
					}
					else{
						activityTagsRead.insert(activityTag->name);
						addActivityTagFast(activityTag);
						tmp++;
						xmlReadingLog+="   Activity tag inserted\n";
					}
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			if(!(tmp==this->activityTagsList.size()))
				xmlReader.raiseError(tr("%1 is incorrect").arg("Activity_Tags_List"));
			else{
				assert(tmp==this->activityTagsList.size());
				xmlReadingLog+="  Added "+CustomFETString::number(tmp)+" activity tags\n";
				reducedXmlLog+="Added "+CustomFETString::number(tmp)+" activity tags\n";
			}
		}
		else if(xmlReader.name()==QString("Teachers_List")){
			QSet<QString> teachersRead;
			
			QSet<QString> subjectsRead; //we assume that the reading of the subjects is done before the reading of the teachers
			for(Subject* sbj : std::as_const(subjectsList))
				subjectsRead.insert(sbj->name);
		
			int tmp=0;
			assert(xmlReader.isStartElement());
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				if(xmlReader.name()==QString("Teacher")){
					Teacher* teacher=new Teacher();

					if(probably5Morocco)
						teacher->morningsAfternoonsBehavior=TEACHER_MORNING_OR_EXCLUSIVELY_AFTERNOON;
					else if(probably5Algeria)
						teacher->morningsAfternoonsBehavior=TEACHER_UNRESTRICTED_MORNINGS_AFTERNOONS;
					
					assert(xmlReader.isStartElement());
					while(xmlReader.readNextStartElement()){
						xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
						if(xmlReader.name()==QString("Name")){
							QString text=xmlReader.readElementText();
							teacher->name=text;
							xmlReadingLog+="    Read teacher name: "+teacher->name+"\n";
						}
						else if(xmlReader.name()==QString("Long_Name")){
							QString text=xmlReader.readElementText();
							teacher->longName=text;
							xmlReadingLog+="    Read teacher long name: "+teacher->longName+"\n";
						}
						else if(xmlReader.name()==QString("Code")){
							QString text=xmlReader.readElementText();
							teacher->code=text;
							xmlReadingLog+="    Read teacher code: "+teacher->code+"\n";
						}
						else if(xmlReader.name()==QString("Mornings_Afternoons_Behavior")){
							//it is best to allow to read the teacher mornings-afternoons behavior even if the mode is not Mornings-Afternoons
							if(true || this->mode==MORNINGS_AFTERNOONS){
								QString text=xmlReader.readElementText();
								if(text=="Unrestricted")
									teacher->morningsAfternoonsBehavior=TEACHER_UNRESTRICTED_MORNINGS_AFTERNOONS;
								else if(text=="Exclusive")
									teacher->morningsAfternoonsBehavior=TEACHER_MORNING_OR_EXCLUSIVELY_AFTERNOON;
								else if(text=="One day exception")
									teacher->morningsAfternoonsBehavior=TEACHER_ONE_DAY_EXCEPTION;
								else if(text=="Two days exception")
									teacher->morningsAfternoonsBehavior=TEACHER_TWO_DAYS_EXCEPTION;
								else if(text=="Three days exception")
									teacher->morningsAfternoonsBehavior=TEACHER_THREE_DAYS_EXCEPTION;
								else if(text=="Four days exception")
									teacher->morningsAfternoonsBehavior=TEACHER_FOUR_DAYS_EXCEPTION;
								else if(text=="Five days exception")
									teacher->morningsAfternoonsBehavior=TEACHER_FIVE_DAYS_EXCEPTION;
								xmlReadingLog+="    Read teacher mornings-afternoons behavior: "+QString::number(teacher->morningsAfternoonsBehavior)+"\n";
							}
							else{
								unrecognizedXmlTags.append(xmlReader.name().toString());
								unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
								unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

								xmlReader.skipCurrentElement();
								xmlReaderNumberOfUnrecognizedFields++;
							}
						}
						else if(xmlReader.name()==QString("Target_Number_of_Hours")){
							QString text=xmlReader.readElementText();
							teacher->targetNumberOfHours=text.toInt();
							xmlReadingLog+="    Read teacher target number of hours: "+CustomFETString::number(teacher->targetNumberOfHours)+"\n";
						}
						else if(xmlReader.name()==QString("Qualified_Subjects")){
							assert(xmlReader.isStartElement());
							while(xmlReader.readNextStartElement()){
								xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
								if(xmlReader.name()==QString("Qualified_Subject")){
									QString text=xmlReader.readElementText();
									if(teacher->qualifiedSubjectsHash.contains(text)){
										xmlReader.raiseError(tr("The teacher %1 has duplicate qualified subject %2.").arg(teacher->name).arg(text));
									}
									else if(!subjectsRead.contains(text)){
										xmlReader.raiseError(tr("The teacher %1 has attached an nonexistent qualified subject %2."
										 " Please note that starting with FET version %3 the list of subjects (tag <Subjects_List> in the .fet XML file)"
										 " must appear before the list of teachers (tag <Teachers_List> in the .fet XML file)",
										 "%3 is the FET version number. Please keep <Subjects_List> and <Teachers_List> untranslated, as in the"
										 " original English string")
										 .arg(teacher->name).arg(text).arg("5.30.0"));
									}
									else{
										teacher->qualifiedSubjectsList.push_back(text);
										teacher->qualifiedSubjectsHash.insert(text, std::prev(teacher->qualifiedSubjectsList.end()));
									}
								}
								else{
									unrecognizedXmlTags.append(xmlReader.name().toString());
									unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
									unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

									xmlReader.skipCurrentElement();
									xmlReaderNumberOfUnrecognizedFields++;
								}
							}
						}
						else if(xmlReader.name()==QString("Comments")){
							QString text=xmlReader.readElementText();
							teacher->comments=text;
							xmlReadingLog+="    Crt. teacher comments="+teacher->comments+"\n";
						}
						else{
							unrecognizedXmlTags.append(xmlReader.name().toString());
							unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
							unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

							xmlReader.skipCurrentElement();
							xmlReaderNumberOfUnrecognizedFields++;
						}
					}
					bool tmp2=teachersRead.contains(teacher->name);
					if(tmp2){
						RulesReconcilableMessage::warning(parent, tr("FET warning"),
						 tr("Duplicate teacher %1 found - ignoring").arg(teacher->name));
						xmlReadingLog+="   Teacher not added - duplicate\n";
						
						delete teacher;
					}
					else{
						teachersRead.insert(teacher->name);
						this->addTeacherFast(teacher);
						tmp++;
						xmlReadingLog+="   Teacher added\n";
					}
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			if(!(tmp==this->teachersList.size()))
				xmlReader.raiseError(tr("%1 is incorrect").arg("Teachers_List"));
			else{
				assert(tmp==this->teachersList.size());
				xmlReadingLog+="  Added "+CustomFETString::number(tmp)+" teachers\n";
				reducedXmlLog+="Added "+CustomFETString::number(tmp)+" teachers\n";
			}
		}
		//start 2021-03-20
		else if(xmlReader.name()==QString("Exception_Teachers_One_Day_List")){
			//this tag is met only in the old FET Morocco files.
			bool reportMoroccoTeachers=true;

			this->mode=MORNINGS_AFTERNOONS;

			for(Teacher* tch : std::as_const(teachersList))
				if(tch->morningsAfternoonsBehavior==TEACHER_UNRESTRICTED_MORNINGS_AFTERNOONS ||
				 tch->morningsAfternoonsBehavior==TEACHER_MORNINGS_AFTERNOONS_BEHAVIOR_NOT_INITIALIZED)
					tch->morningsAfternoonsBehavior=TEACHER_MORNING_OR_EXCLUSIVELY_AFTERNOON;

			if(reportMoroccoTeachers && !probably5Morocco){
				RulesReconcilableMessage::information(parent, tr("FET information"),
				 tr("You are opening an old Morocco file. All the teachers will have mornings-afternoons behavior"
				 " 'Exclusive mornings/afternoons' by default, and the exceptions will be recognized correctly."
				 " If this is a mistake and your file is not an old Morocco file, please report the bug.")+QString(" ")+
				 tr("(The program detected this because your file contains the section %1.)").arg("'Exception_Teachers_One_Day_List'")+
				 QString("\n\n")+
				 tr("Please note that if you save now your file, you won't be able to open it correctly again later using"
				 " the old version of FET Morocco."));
				reportMoroccoTeachers=false;
			}
			
			int tmp=0;
			assert(xmlReader.isStartElement());
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				
				if(xmlReader.name()==QString("Teacher")){
					QString t;
				
					if(xmlReader.readNext()==QXmlStreamReader::Characters){
						t=xmlReader.text().toString();
						xmlReader.skipCurrentElement();
					}
					else{
						assert(xmlReader.isStartElement());
						do{
							xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
							if(xmlReader.name()==QString("Name")){ //old style
								t=xmlReader.readElementText();
							}
							else{
								unrecognizedXmlTags.append(xmlReader.name().toString());
								unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
								unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

								xmlReader.skipCurrentElement();
								xmlReaderNumberOfUnrecognizedFields++;
							}
						}
						while(xmlReader.readNextStartElement());
					}
					
					tmp++;
					//this->exceptionTeachersList.append(t);
					teachersList.at(searchTeacher(t))->morningsAfternoonsBehavior=TEACHER_ONE_DAY_EXCEPTION;
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			xmlReadingLog+="  Added "+QString::number(tmp)+" exception 1 teachers\n";
			reducedXmlLog+="Added "+QString::number(tmp)+" exception 1 teachers\n";
		}
		else if(xmlReader.name()==QString("Exception_Teachers_Two_Days_List")){
			int tmp=0;
			assert(xmlReader.isStartElement());
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				
				if(xmlReader.name()==QString("Teacher")){
					QString t;
				
					if(xmlReader.readNext()==QXmlStreamReader::Characters){
						t=xmlReader.text().toString();
						xmlReader.skipCurrentElement();
					}
					else{
						assert(xmlReader.isStartElement());
						do{
							xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
							if(xmlReader.name()==QString("Name")){ //old style
								t=xmlReader.readElementText();
							}
							else{
								unrecognizedXmlTags.append(xmlReader.name().toString());
								unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
								unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

								xmlReader.skipCurrentElement();
								xmlReaderNumberOfUnrecognizedFields++;
							}
						}
						while(xmlReader.readNextStartElement());
					}
					
					tmp++;
					//this->exceptionTeachers2List.append(t);
					teachersList.at(searchTeacher(t))->morningsAfternoonsBehavior=TEACHER_TWO_DAYS_EXCEPTION;
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			xmlReadingLog+="  Added "+QString::number(tmp)+" exception 2 teachers\n";
			reducedXmlLog+="Added "+QString::number(tmp)+" exception 2 teachers\n";
		}
		else if(xmlReader.name()==QString("Exception_Teachers_Three_Days_List")){
			int tmp=0;
			assert(xmlReader.isStartElement());
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				
				if(xmlReader.name()==QString("Teacher")){
					QString t;
				
					if(xmlReader.readNext()==QXmlStreamReader::Characters){
						t=xmlReader.text().toString();
						xmlReader.skipCurrentElement();
					}
					else{
						assert(xmlReader.isStartElement());
						do{
							xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
							if(xmlReader.name()==QString("Name")){ //old style
								t=xmlReader.readElementText();
							}
							else{
								unrecognizedXmlTags.append(xmlReader.name().toString());
								unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
								unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

								xmlReader.skipCurrentElement();
								xmlReaderNumberOfUnrecognizedFields++;
							}
						}
						while(xmlReader.readNextStartElement());
					}
					
					tmp++;
					//this->exceptionTeachers3List.append(t);
					teachersList.at(searchTeacher(t))->morningsAfternoonsBehavior=TEACHER_THREE_DAYS_EXCEPTION;
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			xmlReadingLog+="  Added "+QString::number(tmp)+" exception 3 teachers\n";
			reducedXmlLog+="Added "+QString::number(tmp)+" exception 3 teachers\n";
		}
		else if(xmlReader.name()==QString("Exception_Teachers_Four_Days_List")){
			int tmp=0;
			assert(xmlReader.isStartElement());
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				
				if(xmlReader.name()==QString("Teacher")){
					QString t;
				
					if(xmlReader.readNext()==QXmlStreamReader::Characters){
						t=xmlReader.text().toString();
						xmlReader.skipCurrentElement();
					}
					else{
						assert(xmlReader.isStartElement());
						do{
							xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
							if(xmlReader.name()==QString("Name")){ //old style
								t=xmlReader.readElementText();
							}
							else{
								unrecognizedXmlTags.append(xmlReader.name().toString());
								unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
								unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

								xmlReader.skipCurrentElement();
								xmlReaderNumberOfUnrecognizedFields++;
							}
						}
						while(xmlReader.readNextStartElement());
					}
					
					tmp++;
					//this->exceptionTeachers4List.append(t);
					teachersList.at(searchTeacher(t))->morningsAfternoonsBehavior=TEACHER_FOUR_DAYS_EXCEPTION;
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			xmlReadingLog+="  Added "+QString::number(tmp)+" exception 4 teachers\n";
			reducedXmlLog+="Added "+QString::number(tmp)+" exception 4 teachers\n";
		}
		else if(xmlReader.name()==QString("Exception_Teachers_Five_Days_List")){
			int tmp=0;
			assert(xmlReader.isStartElement());
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				
				if(xmlReader.name()==QString("Teacher")){
					QString t;
				
					if(xmlReader.readNext()==QXmlStreamReader::Characters){
						t=xmlReader.text().toString();
						xmlReader.skipCurrentElement();
					}
					else{
						assert(xmlReader.isStartElement());
						do{
							xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
							if(xmlReader.name()==QString("Name")){ //old style
								t=xmlReader.readElementText();
							}
							else{
								unrecognizedXmlTags.append(xmlReader.name().toString());
								unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
								unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

								xmlReader.skipCurrentElement();
								xmlReaderNumberOfUnrecognizedFields++;
							}
						}
						while(xmlReader.readNextStartElement());
					}
					
					tmp++;
					//this->exceptionTeachers5List.append(t);
					teachersList.at(searchTeacher(t))->morningsAfternoonsBehavior=TEACHER_FIVE_DAYS_EXCEPTION;
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			xmlReadingLog+="  Added "+QString::number(tmp)+" exception 5 teachers\n";
			reducedXmlLog+="Added "+QString::number(tmp)+" exception 5 teachers\n";
		}
		//end 2021-03-20
		else if(xmlReader.name()==QString("Students_List")){
			QSet<StudentsSet*> allAllocatedStudentsSets;
		
			bool okStudents=true;
	
			//permanentStudentsHash.clear();
		
			QHash<QString, StudentsSet*> currentStudentsHash;
		
			int tsgr=0;
			int tgr=0;
		
			int ny=0;
			assert(xmlReader.isStartElement());
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				if(xmlReader.name()==QString("Year")){
					StudentsYear* sty=new StudentsYear();
					allAllocatedStudentsSets.insert(sty);
					int ng=0;
					
					//sty->divisions.clear();
					//sty->separator="";
					sty->firstCategoryIsPermanent=false;
					int readCategories=-1;
					int metCategories=0;
					
					QSet<QString> groupsInYear;

					bool tmp2=this->addYearFast(sty);
					assert(tmp2==true);
					ny++;
					
					int cntYearNameFound=0;

					assert(xmlReader.isStartElement());
					while(xmlReader.readNextStartElement()){
						xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
						if(xmlReader.name()==QString("Name")){
							cntYearNameFound++;
							if(cntYearNameFound>=2){
								xmlReader.raiseError(tr("The field '%1' is met more than once in the students year's description.").arg("Name"));
								okStudents=false;
							}
							
							QString text=xmlReader.readElementText();
							if(!skipDuplicatedStudentsSets){
								QString nn=text;
								//StudentsSet* ss=this->searchStudentsSet(nn);
								StudentsSet* ss=currentStudentsHash.value(nn, nullptr);
								if(ss!=nullptr){
									QString str;
									
									if(ss->type==STUDENTS_YEAR)
										str=tr("Trying to add year %1, which is already added as another year.").arg(nn);
									else if(ss->type==STUDENTS_GROUP)
										str=tr("Trying to add year %1, which is already added as another group.").arg(nn);
									else if(ss->type==STUDENTS_SUBGROUP)
										str=tr("Trying to add year %1, which is already added as another subgroup.").arg(nn);
									
									xmlReader.raiseError(str);
									okStudents=false;

									//int t=1;
									
									/*str=tr("Could not read file - XML parse error at line %1, column %2:\n%3", "The error description is %3")
									 .arg(xmlReader.lineNumber()).arg(xmlReader.columnNumber()).arg(str);
								
									int t=RulesIrreconcilableMessage::warning(parent, tr("FET warning"), str,
									 tr("Skip rest"), tr("See next"), QString(),
									 1, 0 );
									
									if(okStudents){
										//xmlReader.raiseError(tr("Students structure error(s)."));
										okStudents=false;
									}*/
					
									/*if(t==0)
										skipDuplicatedStudentsSets=true;*/
								}
							}
						
							sty->name=text;
							if(!currentStudentsHash.contains(sty->name))
								currentStudentsHash.insert(sty->name, sty);
							xmlReadingLog+="    Read year name: "+sty->name+"\n";
						}
						else if(xmlReader.name()==QString("Long_Name")){
							QString text=xmlReader.readElementText();
							sty->longName=text;
							xmlReadingLog+="    Read year long name: "+sty->longName+"\n";
						}
						else if(xmlReader.name()==QString("Code")){
							QString text=xmlReader.readElementText();
							sty->code=text;
							xmlReadingLog+="    Read year code: "+sty->code+"\n";
						}
						else if(xmlReader.name()==QString("Number_of_Students")){
							QString text=xmlReader.readElementText();
							sty->numberOfStudents=text.toInt();
							xmlReadingLog+="    Read year number of students: "+CustomFETString::number(sty->numberOfStudents)+"\n";
						}
						else if(xmlReader.name()==QString("Comments")){
							QString text=xmlReader.readElementText();
							sty->comments=text;
							xmlReadingLog+="    Crt. year comments="+sty->comments+"\n";
						}
						
						//2020-09-03
						else if(xmlReader.name()==QString("Number_of_Categories")){
							QString text=xmlReader.readElementText();
							readCategories=text.toInt();
							xmlReadingLog+="    Read number of categories: "+CustomFETString::number(readCategories)+"\n";
						}
						else if(xmlReader.name()==QString("Category")){
							xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";

							metCategories++;
							
							int readDivisions=-1;
							int metDivisions=0;
							QStringList divisionsTL;

							assert(xmlReader.isStartElement());
							while(xmlReader.readNextStartElement()){
								xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
								if(xmlReader.name()==QString("Number_of_Divisions")){
									QString text=xmlReader.readElementText();
									readDivisions=text.toInt();
									xmlReadingLog+="     Read number of divisions: "+CustomFETString::number(readDivisions)+"\n";
								}
								else if(xmlReader.name()==QString("Division")){
									xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
									
									metDivisions++;
									
									QString text=xmlReader.readElementText();
									divisionsTL.append(text);
									xmlReadingLog+="     Read new division: "+divisionsTL.last()+"\n";
								}
								else{
									unrecognizedXmlTags.append(xmlReader.name().toString());
									unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
									unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

									xmlReader.skipCurrentElement();
									xmlReaderNumberOfUnrecognizedFields++;
								}
							}
							
							if(readDivisions==-1){
								if(metDivisions==0){
									//ok
								}
								else{
									xmlReader.raiseError(tr("The specified number of divisions was not found, but there were found specified the divisions."));
									okStudents=false;
								}
							}
							else if(readDivisions!=metDivisions){
								xmlReader.raiseError(tr("The specified number of divisions is not equal with the met number of divisions."));
								okStudents=false;
							}
							else{
								sty->divisions.append(divisionsTL);
							}
						}
						else if(xmlReader.name()==QString("Separator")){
							QString text=xmlReader.readElementText();
							sty->separator=text;
							xmlReadingLog+="    Read year separator="+sty->separator+"\n";
						}
						else if(xmlReader.name()==QString("First_Category_Is_Permanent")){
							QString text=xmlReader.readElementText();
							if(text=="true")
								sty->firstCategoryIsPermanent=true;
							else
								sty->firstCategoryIsPermanent=false;
							xmlReadingLog+="    Read first category is permanent="+text+"\n";
						}
						
						else if(xmlReader.name()==QString("Group")){
							QSet<StudentsSubgroup*> allocatedSubgroups;
						
							StudentsGroup* stg=new StudentsGroup();
							allAllocatedStudentsSets.insert(stg);
							int ns=0;

							QSet<QString> subgroupsInGroup;
							
							/*bool tmp4=this->addGroupFast(sty, stg);
							assert(tmp4==true);
							ng++;*/
							
							int cntGroupNameFound=0;

							assert(xmlReader.isStartElement());
							while(xmlReader.readNextStartElement()){
								xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
								if(xmlReader.name()==QString("Name")){
									cntGroupNameFound++;
									if(cntGroupNameFound>=2){
										xmlReader.raiseError(tr("The field '%1' is met more than once in the students group's description.").arg("Name"));
										okStudents=false;
									}

									QString text=xmlReader.readElementText();
									if(!skipDuplicatedStudentsSets){
										QString nn=text;
										StudentsSet* ss=currentStudentsHash.value(nn, nullptr);
										if(ss!=nullptr){
											QString str;
											bool haveError=false;
									
											if(ss->type==STUDENTS_YEAR){
												str=tr("Trying to add group %1, which is already added as another year.").arg(nn);
												haveError=true;
											}
											else if(ss->type==STUDENTS_GROUP){
												if(groupsInYear.contains(nn)){
													str=tr("Trying to add group %1 in year %2 but it is already added.").arg(nn).arg(sty->name);
													haveError=true;
												}
												else{
													str="";
													assert(haveError==false);
												}
											}
											else if(ss->type==STUDENTS_SUBGROUP){
												str=tr("Trying to add group %1, which is already added as another subgroup.").arg(nn);
												haveError=true;
											}
								
											//int t=1;
											if(haveError){
												xmlReader.raiseError(str);
												okStudents=false;

												/*str=tr("Could not read file - XML parse error at line %1, column %2:\n%3", "The error description is %3")
												 .arg(xmlReader.lineNumber()).arg(xmlReader.columnNumber()).arg(str);

												t=RulesIrreconcilableMessage::warning(parent, tr("FET warning"), str,
												 tr("Skip rest"), tr("See next"), QString(),
												 1, 0 );
												
												if(okStudents){
													//xmlReader.raiseError(tr("Students structure error(s)."));
													okStudents=false;
												}*/
											}
					
											//if(t==0)
											//	skipDuplicatedStudentsSets=true;
										}
									}
									
									groupsInYear.insert(text);

									if(currentStudentsHash.contains(text)){
										for(StudentsSubgroup* sts : std::as_const(allocatedSubgroups)){
											assert(currentStudentsHash.contains(sts->name));
											currentStudentsHash.remove(sts->name);
											
											assert(allAllocatedStudentsSets.contains(sts));
											allAllocatedStudentsSets.remove(sts);
											delete sts;
										}
										allocatedSubgroups.clear(); //not really needed
									
										assert(allAllocatedStudentsSets.contains(stg));
										allAllocatedStudentsSets.remove(stg);
										delete stg;
										
										if(okStudents){
											assert(currentStudentsHash.value(text)->type==STUDENTS_GROUP);
											stg=(StudentsGroup*)(currentStudentsHash.value(text));
	
											bool tmp4=this->addGroupFast(sty, stg);
											assert(tmp4==true);
											//ng++;
										}
										
										xmlReader.skipCurrentElement();
										break;
									}

									bool tmp4=this->addGroupFast(sty, stg);
									assert(tmp4==true);
									ng++;

									stg->name=text;
									if(!currentStudentsHash.contains(stg->name))
										currentStudentsHash.insert(stg->name, stg);
									xmlReadingLog+="     Read group name: "+stg->name+"\n";
								}
								else if(xmlReader.name()==QString("Long_Name")){
									QString text=xmlReader.readElementText();
									stg->longName=text;
									xmlReadingLog+="     Read group long name: "+stg->longName+"\n";
								}
								else if(xmlReader.name()==QString("Code")){
									QString text=xmlReader.readElementText();
									stg->code=text;
									xmlReadingLog+="     Read group code: "+stg->code+"\n";
								}
								else if(xmlReader.name()==QString("Number_of_Students")){
									QString text=xmlReader.readElementText();
									stg->numberOfStudents=text.toInt();
									xmlReadingLog+="     Read group number of students: "+CustomFETString::number(stg->numberOfStudents)+"\n";
								}
								else if(xmlReader.name()==QString("Comments")){
									QString text=xmlReader.readElementText();
									stg->comments=text;
									xmlReadingLog+="    Crt. group comments="+stg->comments+"\n";
								}
								else if(xmlReader.name()==QString("Subgroup")){
									StudentsSubgroup* sts=new StudentsSubgroup();
									allAllocatedStudentsSets.insert(sts);

									/*bool tmp6=this->addSubgroupFast(sty, stg, sts);
									assert(tmp6==true);
									ns++;*/
									
									int cntSubgroupNameFound=0;

									assert(xmlReader.isStartElement());
									while(xmlReader.readNextStartElement()){
										xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
										if(xmlReader.name()==QString("Name")){
											cntSubgroupNameFound++;
											if(cntSubgroupNameFound>=2){
												xmlReader.raiseError(tr("The field '%1' is met more than once in the students subgroup's description.").arg("Name"));
												okStudents=false;
											}

											QString text=xmlReader.readElementText();
											if(!skipDuplicatedStudentsSets){
												QString nn=text;
												StudentsSet* ss=currentStudentsHash.value(nn, nullptr);
												if(ss!=nullptr){
													QString str;
													bool haveError=false;
									
													if(ss->type==STUDENTS_YEAR){
														str=tr("Trying to add subgroup %1, which is already added as another year.").arg(nn);
														haveError=true;
													}
													else if(ss->type==STUDENTS_GROUP){
														str=tr("Trying to add subgroup %1, which is already added as another group.").arg(nn);
														haveError=true;
													}
													else if(ss->type==STUDENTS_SUBGROUP){
														if(subgroupsInGroup.contains(nn)){
															str=tr("Trying to add subgroup %1 in year %2, group %3 but it is already added.").arg(nn).arg(sty->name).arg(stg->name);
															haveError=true;
														}
														else{
															str="";
															assert(haveError==false);
														}
													}
								
													//int t=1;
													if(haveError){
														xmlReader.raiseError(str);
														okStudents=false;

														/*str=tr("Could not read file - XML parse error at line %1, column %2:\n%3", "The error description is %3")
														 .arg(xmlReader.lineNumber()).arg(xmlReader.columnNumber()).arg(str);

														t=RulesIrreconcilableMessage::warning(parent, tr("FET warning"), str,
														 tr("Skip rest"), tr("See next"), QString(),
														 1, 0 );
														
														if(okStudents){
															//xmlReader.raiseError(tr("Students structure error(s)."));
															okStudents=false;
														}*/
													}
							
													//if(t==0)
													//	skipDuplicatedStudentsSets=true;
												}
											}
											
											subgroupsInGroup.insert(text);

											if(currentStudentsHash.contains(text)){
												assert(allAllocatedStudentsSets.contains(sts));
												allAllocatedStudentsSets.remove(sts);
												delete sts;
												
												if(okStudents){
													assert(currentStudentsHash.value(text)->type==STUDENTS_SUBGROUP);
													sts=(StudentsSubgroup*)(currentStudentsHash.value(text));
	
													bool tmp6=this->addSubgroupFast(sty, stg, sts);
													assert(tmp6==true);
													//ns++;
												}
												
												xmlReader.skipCurrentElement();
												break;
											}
											else{
												allocatedSubgroups.insert(sts);
											}

											bool tmp6=this->addSubgroupFast(sty, stg, sts);
											assert(tmp6==true);
											ns++;
											
											sts->name=text;
											if(!currentStudentsHash.contains(sts->name))
												currentStudentsHash.insert(sts->name, sts);
											xmlReadingLog+="     Read subgroup name: "+sts->name+"\n";
										}
										else if(xmlReader.name()==QString("Long_Name")){
											QString text=xmlReader.readElementText();
											sts->longName=text;
											xmlReadingLog+="     Read subgroup long name: "+sts->longName+"\n";
										}
										else if(xmlReader.name()==QString("Code")){
											QString text=xmlReader.readElementText();
											sts->code=text;
											xmlReadingLog+="     Read subgroup code: "+sts->code+"\n";
										}
										else if(xmlReader.name()==QString("Number_of_Students")){
											QString text=xmlReader.readElementText();
											sts->numberOfStudents=text.toInt();
											xmlReadingLog+="     Read subgroup number of students: "+CustomFETString::number(sts->numberOfStudents)+"\n";
										}
										else if(xmlReader.name()==QString("Comments")){
											QString text=xmlReader.readElementText();
											sts->comments=text;
											xmlReadingLog+="    Crt. subgroup comments="+sts->comments+"\n";
										}
										else{
											unrecognizedXmlTags.append(xmlReader.name().toString());
											unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
											unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

											xmlReader.skipCurrentElement();
											xmlReaderNumberOfUnrecognizedFields++;
										}
									}
								}
								else{
									unrecognizedXmlTags.append(xmlReader.name().toString());
									unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
									unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

									xmlReader.skipCurrentElement();
									xmlReaderNumberOfUnrecognizedFields++;
								}
							}
							if(ns == stg->subgroupsList.size()){
								xmlReadingLog+="    Added "+CustomFETString::number(ns)+" subgroups\n";
								tsgr+=ns;
								//reducedXmlLog+="		Added "+CustomFETString::number(ns)+" subgroups\n";
							}
						}
						else{
							unrecognizedXmlTags.append(xmlReader.name().toString());
							unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
							unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

							xmlReader.skipCurrentElement();
							xmlReaderNumberOfUnrecognizedFields++;
						}
					}
					if(ng == sty->groupsList.size()){
						xmlReadingLog+="   Added "+CustomFETString::number(ng)+" groups\n";
						tgr+=ng;
						//reducedXmlLog+="	Added "+CustomFETString::number(ng)+" groups\n";
					}
					
					if(readCategories==-1){
						if(metCategories==0){
							//ok
						}
						else{
							xmlReader.raiseError(tr("The specified number of categories was not found, but there were found specified the categories."));
							okStudents=false;
						}
					}
					else if(readCategories!=metCategories){
						xmlReader.raiseError(tr("The specified number of categories is not equal with the met number of categories."));
						okStudents=false;
					}
					else{
						//ok
					}
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			xmlReadingLog+="  Added "+CustomFETString::number(ny)+" years\n";
			reducedXmlLog+="Added "+CustomFETString::number(ny)+" students years\n";
			//reducedXmlLog+="Added "+CustomFETString::number(tgr)+" students groups (see note below)\n";
			reducedXmlLog+="Added "+CustomFETString::number(tgr)+" students groups\n";
			//reducedXmlLog+="Added "+CustomFETString::number(tsgr)+" students subgroups (see note below)\n";
			reducedXmlLog+="Added "+CustomFETString::number(tsgr)+" students subgroups\n";
			assert(this->yearsList.size()==ny);
			
			if(okStudents){
				//This is redundant, but I make this an additional test, just in case anything was wrong.
				computePermanentStudentsHash();
				assert(permanentStudentsHash==currentStudentsHash);
			}
			else{
				for(StudentsSet* studentsSet : std::as_const(allAllocatedStudentsSets))
					delete studentsSet;
				yearsList.clear();
			}
		}
		else if(xmlReader.name()==QString("Activities_List")){
			QSet<QString> allTeachers;
			QHash<QString, int> studentsSetsCount;
			QSet<QString> allSubjects;
			QSet<QString> allActivityTags;
			
			for(Teacher* tch : std::as_const(this->teachersList))
				allTeachers.insert(tch->name);

			for(Subject* sbj : std::as_const(this->subjectsList))
				allSubjects.insert(sbj->name);

			for(ActivityTag* at : std::as_const(this->activityTagsList))
				allActivityTags.insert(at->name);

			for(StudentsYear* year : std::as_const(this->yearsList)){
				if(!studentsSetsCount.contains(year->name))
					studentsSetsCount.insert(year->name, year->numberOfStudents);
				else if(studentsSetsCount.value(year->name)!=year->numberOfStudents){
					//cout<<"Mistake: year "<<qPrintable(year->name)<<" appears in more places with different number of students"<<endl;
				}

				for(StudentsGroup* group : std::as_const(year->groupsList)){
					if(!studentsSetsCount.contains(group->name))
						studentsSetsCount.insert(group->name, group->numberOfStudents);
					else if(studentsSetsCount.value(group->name)!=group->numberOfStudents){
						//cout<<"Mistake: group "<<qPrintable(group->name)<<" appears in more places with different number of students"<<endl;
					}
			
					for(StudentsSubgroup* subgroup : std::as_const(group->subgroupsList)){
						if(!studentsSetsCount.contains(subgroup->name))
							studentsSetsCount.insert(subgroup->name, subgroup->numberOfStudents);
						else if(studentsSetsCount.value(subgroup->name)!=subgroup->numberOfStudents){
							//cout<<"Mistake: subgroup "<<qPrintable(subgroup->name)<<" appears in more places with different number of students"<<endl;
						}
					}
				}
			}

			//int nchildrennodes=elem2.childNodes().length();
			
			/*QProgressDialog progress(parent);
			progress.setLabelText(tr("Loading activities ... please wait"));
			progress.setRange(0, nchildrennodes);
			progress.setModal(true);*/
			//progress.setCancelButton(parent);
			
			//int ttt=0;
		
			int na=0;
			assert(xmlReader.isStartElement());
			while(xmlReader.readNextStartElement()){
			
				/*progress.setValue(ttt);
				pqapplication->processEvents();
				if(progress.wasCanceled()){
					QMessageBox::information(parent, tr("FET information"), tr("Interrupted - only partial file was loaded"));
					return true;
				}
				
				ttt++;*/
			
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				if(xmlReader.name()==QString("Activity")){
					bool correct=true;
					QStringList additionalErrorMessages; //in case correct is false
				
					QString cm=""; //comments
					QString tn="";
					QStringList tl;
					QString sjn="";
					bool subjectFieldMet=false;
					QString atn="";
					QStringList atl;
					QString stn="";
					QStringList stl;
					//int p=PARITY_NOT_INITIALIZED;
					int td=-1;
					int d=-1;
					int id=-1;
					int gid=-1;
					bool ac=true;
					int nos=-1;
					bool cnos=true;
					
					QSet<QString> _teachersSet;
					QSet<QString> _studentsSet;
					QSet<QString> _activityTagsSet;
					int _duplicateTeachersCount=0;
					int _duplicateStudentsCount=0;
					int _duplicateActivityTagsCount=0;
					
					assert(xmlReader.isStartElement());
					while(xmlReader.readNextStartElement()){
						xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
						if(xmlReader.name()==QString("Weekly")){
							xmlReader.skipCurrentElement();
							xmlReadingLog+="    Current activity is weekly - ignoring tag\n";
							//assert(p==PARITY_NOT_INITIALIZED);
							//p=PARITY_WEEKLY;
						}
						//old tag
						else if(xmlReader.name()==QString("Biweekly")){
							xmlReader.skipCurrentElement();
							xmlReadingLog+="    Current activity is fortnightly - ignoring tag\n";
							//assert(p==PARITY_NOT_INITIALIZED);
							//p=PARITY_FORTNIGHTLY;
						}
						else if(xmlReader.name()==QString("Fortnightly")){
							xmlReader.skipCurrentElement();
							xmlReadingLog+="    Current activity is fortnightly - ignoring tag\n";
							//assert(p==PARITY_NOT_INITIALIZED);
							//p=PARITY_FORTNIGHTLY;
						}
						else if(xmlReader.name()==QString("Active")){
							QString text=xmlReader.readElementText();
							if(text=="yes" || text=="true" || text=="1"){
								ac=true;
								xmlReadingLog+="    Current activity is active\n";
							}
							else{
								if(!(text=="no" || text=="false" || text=="0")){
									RulesReconcilableMessage::warning(parent, tr("FET warning"),
									 tr("Found activity active tag which is not 'true', 'false', 'yes', 'no', '1' or '0'."
									 " The activity will be considered not active",
									 "Instructions for translators: please leave the 'true', 'false', 'yes' and 'no' fields untranslated, as they are in English"));
								}
								//assert(text=="no" || text=="false" || text=="0");
								ac=false;
								xmlReadingLog+="    Current activity is not active\n";
							}
						}
						else if(xmlReader.name()==QString("Comments")){
							QString text=xmlReader.readElementText();
							cm=text;
							xmlReadingLog+="    Crt. activity comments="+cm+"\n";
						}
						else if(xmlReader.name()==QString("Teacher")){
							QString text=xmlReader.readElementText();
							tn=text;
							xmlReadingLog+="    Crt. activity teacher="+tn+"\n";
							
							if(_teachersSet.contains(tn))
								_duplicateTeachersCount++;
							else
								_teachersSet.insert(tn);
							
							tl.append(tn);
							if(!allTeachers.contains(tn)){
							//if(this->searchTeacher(tn)<0)
								correct=false;
								additionalErrorMessages.append(tr("Line %1, column %2: Teacher %3 was not found in the teachers list.")
								 .arg(xmlReader.lineNumber()).arg(xmlReader.columnNumber()).arg(tn));
							}
						}
						else if(xmlReader.name()==QString("Subject")){
							subjectFieldMet=true;
							QString text=xmlReader.readElementText();
							sjn=text;
							xmlReadingLog+="    Crt. activity subject="+sjn+"\n";
							if(!allSubjects.contains(sjn)){
							//if(this->searchSubject(sjn)<0)
								correct=false;
								additionalErrorMessages.append(tr("Line %1, column %2: Subject %3 was not found in the subjects list.")
								 .arg(xmlReader.lineNumber()).arg(xmlReader.columnNumber()).arg(sjn));
							}
						}
						else if(xmlReader.name()==QString("Subject_Tag")){
							QString text=xmlReader.readElementText();
							atn=text;
							xmlReadingLog+="    Crt. activity activity_tag="+atn+"\n";

							if(_activityTagsSet.contains(atn))
								_duplicateActivityTagsCount++;
							else
								_activityTagsSet.insert(atn);
							
							if(atn!="")
								atl.append(atn);
							if(atn!="" && !allActivityTags.contains(atn)){
							//if(atn!="" && this->searchActivityTag(atn)<0)
								correct=false;
								additionalErrorMessages.append(tr("Line %1, column %2: Activity tag %3 was not found in the activity tags list.")
								 .arg(xmlReader.lineNumber()).arg(xmlReader.columnNumber()).arg(atn));
							}
						}
						else if(xmlReader.name()==QString("Activity_Tag")){
							QString text=xmlReader.readElementText();
							atn=text;
							xmlReadingLog+="    Crt. activity activity_tag="+atn+"\n";

							if(_activityTagsSet.contains(atn))
								_duplicateActivityTagsCount++;
							else
								_activityTagsSet.insert(atn);
							
							if(atn!="")
								atl.append(atn);
							if(atn!="" && !allActivityTags.contains(atn)){
							//if(atn!="" && this->searchActivityTag(atn)<0)
								correct=false;
								additionalErrorMessages.append(tr("Line %1, column %2: Activity tag %3 was not found in the activity tags list.")
								 .arg(xmlReader.lineNumber()).arg(xmlReader.columnNumber()).arg(atn));
							}
						}
						else if(xmlReader.name()==QString("Students")){
							QString text=xmlReader.readElementText();
							stn=text;
							xmlReadingLog+="    Crt. activity students+="+stn+"\n";

							if(_studentsSet.contains(stn))
								_duplicateStudentsCount++;
							else
								_studentsSet.insert(stn);

							stl.append(stn);
							if(!studentsSetsCount.contains(stn)){
							//if(this->searchStudentsSet(stn)==nullptr)
								correct=false;
								additionalErrorMessages.append(tr("Line %1, column %2: Students set %3 was not found in the students sets list.")
								 .arg(xmlReader.lineNumber()).arg(xmlReader.columnNumber()).arg(stn));
							}
						}
						else if(xmlReader.name()==QString("Duration")){
							QString text=xmlReader.readElementText();
							d=text.toInt();
							xmlReadingLog+="    Crt. activity duration="+CustomFETString::number(d)+"\n";
						}
						else if(xmlReader.name()==QString("Total_Duration")){
							QString text=xmlReader.readElementText();
							td=text.toInt();
							xmlReadingLog+="    Crt. activity total duration="+CustomFETString::number(td)+"\n";
						}
						else if(xmlReader.name()==QString("Id")){
							QString text=xmlReader.readElementText();
							id=text.toInt();
							xmlReadingLog+="    Crt. activity id="+CustomFETString::number(id)+"\n";
						}
						else if(xmlReader.name()==QString("Activity_Group_Id")){
							QString text=xmlReader.readElementText();
							gid=text.toInt();
							xmlReadingLog+="    Crt. activity group id="+CustomFETString::number(gid)+"\n";
						}
						else if(xmlReader.name()==QString("Number_Of_Students")){
							QString text=xmlReader.readElementText();
							cnos=false;
							nos=text.toInt();
							xmlReadingLog+="    Crt. activity number of students="+CustomFETString::number(nos)+"\n";
						}
						else{
							unrecognizedXmlTags.append(xmlReader.name().toString());
							unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
							unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

							xmlReader.skipCurrentElement();
							xmlReaderNumberOfUnrecognizedFields++;
						}
					}
					if(id<0)
						xmlReader.raiseError(tr("%1 is incorrect").arg("Id"));
					else if(activitiesPointerHash.contains(id))
						xmlReader.raiseError(tr("%1 is incorrect (already existing)").arg("Id")); //duplicate Id
					else if(gid<0)
						xmlReader.raiseError(tr("%1 is incorrect").arg("Activity_Group_Id"));
					else if(d<=0)
						xmlReader.raiseError(tr("%1 is incorrect").arg("Duration"));
					else if(!subjectFieldMet)
						xmlReader.raiseError(tr("Field %1 not met").arg("Subject"));
					else if(_duplicateTeachersCount>0)
						xmlReader.raiseError(tr("Activity with Id=%1 contains %2 duplicate teachers - please correct that").arg(id).arg(_duplicateTeachersCount));
					else if(_duplicateStudentsCount>0)
						xmlReader.raiseError(tr("Activity with Id=%1 contains %2 duplicate students sets - please correct that").arg(id).arg(_duplicateStudentsCount));
					else if(_duplicateActivityTagsCount>0)
						xmlReader.raiseError(tr("Activity with Id=%1 contains %2 duplicate activity tags - please correct that").arg(id).arg(_duplicateActivityTagsCount));
					else if(correct){
						assert(id>=0 && gid>=0);
						assert(d>0);
						if(td<0)
							td=d;
						
						if(cnos==true){
							assert(nos==-1);
							int _ns=0;
							for(const QString& _s : std::as_const(stl)){
								assert(studentsSetsCount.contains(_s));
								_ns+=studentsSetsCount.value(_s);
							}
							this->addSimpleActivityFast(parent, id, gid, tl, sjn, atl, stl,
								d, td, ac, cnos, nos, _ns);
						}
						else{
							this->addSimpleActivityFast(parent, id, gid, tl, sjn, atl, stl,
								d, td, ac, cnos, nos, nos);
						}
						
						this->activitiesList[this->activitiesList.count()-1]->comments=cm;
						
						na++;
						xmlReadingLog+="   Added the activity\n";
					}
					else{
						QString s=tr("The activity with id=%1 contains incorrect data.").arg(id);
						s+="\n\n";
						s+=tr("Additional details:");
						s+="\n";
						assert(additionalErrorMessages.count()>=1);
						s+=additionalErrorMessages.join("\n");
						xmlReader.raiseError(s);
						/*xmlReadingLog+="   Activity with id ="+CustomFETString::number(id)+" contains invalid data - skipping\n";
						RulesReconcilableMessage::warning(parent, tr("FET information"),
						 tr("Activity with id=%1 contains invalid data - skipping").arg(id));*/
					}
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			xmlReadingLog+="  Added "+CustomFETString::number(na)+" activities\n";
			reducedXmlLog+="Added "+CustomFETString::number(na)+" activities\n";
		}
		else if(xmlReader.name()==QString("Equipments_List")){
			RulesReconcilableMessage::warning(parent, tr("FET warning"),
			 tr("File contains deprecated equipments list - will be ignored"));
			xmlReader.skipCurrentElement();
			//NOT! xmlReaderNumberOfUnrecognizedFields++; because this entry was once allowed
		}
		else if(xmlReader.name()==QString("Buildings_List")){
			QSet<QString> buildingsRead;
		
			int tmp=0;
			assert(xmlReader.isStartElement());
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				if(xmlReader.name()==QString("Building")){
					Building* bu=new Building();
					bu->name="";
					
					assert(xmlReader.isStartElement());
					while(xmlReader.readNextStartElement()){
						xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
						if(xmlReader.name()==QString("Name")){
							QString text=xmlReader.readElementText();
							bu->name=text;
							xmlReadingLog+="    Read building name: "+bu->name+"\n";
						}
						else if(xmlReader.name()==QString("Long_Name")){
							QString text=xmlReader.readElementText();
							bu->longName=text;
							xmlReadingLog+="    Read building long name: "+bu->longName+"\n";
						}
						else if(xmlReader.name()==QString("Code")){
							QString text=xmlReader.readElementText();
							bu->code=text;
							xmlReadingLog+="    Read building code: "+bu->code+"\n";
						}
						else if(xmlReader.name()==QString("Comments")){
							QString text=xmlReader.readElementText();
							bu->comments=text;
							xmlReadingLog+="    Crt. building comments="+bu->comments+"\n";
						}
						else{
							unrecognizedXmlTags.append(xmlReader.name().toString());
							unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
							unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

							xmlReader.skipCurrentElement();
							xmlReaderNumberOfUnrecognizedFields++;
						}
					}

					bool tmp2=buildingsRead.contains(bu->name);
					if(tmp2){
						RulesReconcilableMessage::warning(parent, tr("FET warning"),
						 tr("Duplicate building %1 found - ignoring").arg(bu->name));
						xmlReadingLog+="   Building not added - duplicate\n";
						
						delete bu;
					}
					else{
						buildingsRead.insert(bu->name);
						addBuildingFast(bu);
						tmp++;
						xmlReadingLog+="   Building inserted\n";
					}
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			if(!(tmp==this->buildingsList.size()))
				xmlReader.raiseError(tr("%1 is incorrect").arg("Buildings_List"));
			else{
				assert(tmp==this->buildingsList.size());
				xmlReadingLog+="  Added "+CustomFETString::number(tmp)+" buildings\n";
				reducedXmlLog+="Added "+CustomFETString::number(tmp)+" buildings\n";
			}
		}
		else if(xmlReader.name()==QString("Rooms_List")){
			QSet<QString> roomsRead;
		
			int tmp=0;
			assert(xmlReader.isStartElement());
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				if(xmlReader.name()==QString("Room")){
					Room* rm=new Room();
					rm->name="";
					rm->capacity=MAX_ROOM_CAPACITY; //infinite, if not specified
					rm->building="";
					rm->isVirtual=false;
					rm->realRoomsSetsList.clear();
					int specifiedNumberOfSetsOfRooms=-1;
					int metNumberOfSetsOfRooms=0;
					bool correct=true;
					assert(xmlReader.isStartElement());
					while(xmlReader.readNextStartElement()){
						xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
						if(xmlReader.name()==QString("Name")){
							QString text=xmlReader.readElementText();
							rm->name=text;
							xmlReadingLog+="    Read room name: "+rm->name+"\n";
						}
						else if(xmlReader.name()==QString("Long_Name")){
							QString text=xmlReader.readElementText();
							rm->longName=text;
							xmlReadingLog+="    Read room long name: "+rm->longName+"\n";
						}
						else if(xmlReader.name()==QString("Code")){
							QString text=xmlReader.readElementText();
							rm->code=text;
							xmlReadingLog+="    Read room code: "+rm->code+"\n";
						}
						else if(xmlReader.name()==QString("Type")){
							//rm->type=text;
							xmlReader.skipCurrentElement();
							xmlReadingLog+="    Ignoring old tag room type:\n";
						}
						else if(xmlReader.name()==QString("Capacity")){
							QString text=xmlReader.readElementText();
							rm->capacity=text.toInt();
							xmlReadingLog+="    Read room capacity: "+CustomFETString::number(rm->capacity)+"\n";
						}
						else if(xmlReader.name()==QString("Virtual")){
							QString text=xmlReader.readElementText();
							if(text=="true"){
								rm->isVirtual=true;
							}
						}
						else if(xmlReader.name()==QString("Number_of_Sets_of_Real_Rooms")){
							QString text=xmlReader.readElementText();
							specifiedNumberOfSetsOfRooms=text.toInt();
						}
						else if(xmlReader.name()==QString("Set_of_Real_Rooms")){
							metNumberOfSetsOfRooms++;
							
							QStringList rl;
							
							int metNumberOfRooms=0;
							int specifiedNumberOfRooms=-1;
							assert(xmlReader.isStartElement());
							while(xmlReader.readNextStartElement()){
								if(xmlReader.name()==QString("Number_of_Real_Rooms")){
									QString text=xmlReader.readElementText();
									specifiedNumberOfRooms=text.toInt();
								}
								else if(xmlReader.name()==QString("Real_Room")){
									metNumberOfRooms++;
									QString text=xmlReader.readElementText();
									rl.append(text);
								}
								else{
									unrecognizedXmlTags.append(xmlReader.name().toString());
									unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
									unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

									xmlReader.skipCurrentElement();
									xmlReaderNumberOfUnrecognizedFields++;
								}
							}
							
							if(specifiedNumberOfRooms==-1){
								xmlReader.raiseError(tr("The specified number of real rooms was not found in the input file"
								 " for the virtual room %1, for the set of real rooms number %2").arg(rm->name).arg(metNumberOfSetsOfRooms));
								correct=false;
							}
							else if(metNumberOfRooms!=specifiedNumberOfRooms){
								xmlReader.raiseError(tr("The specified number of real rooms is not equal with the met number of real rooms"
								 " for the virtual room %1").arg(rm->name));
								correct=false;
							}
							else{
								rm->realRoomsSetsList.append(rl);
							}
						}
						else if(xmlReader.name()==QString("Equipment")){
							//rm->addEquipment(text);
							xmlReader.skipCurrentElement();
							xmlReadingLog+="    Ignoring old tag - room equipment:\n";
						}
						else if(xmlReader.name()==QString("Building")){
							QString text=xmlReader.readElementText();
							rm->building=text;
							xmlReadingLog+="    Read room building:\n"+rm->building;
						}
						else if(xmlReader.name()==QString("Comments")){
							QString text=xmlReader.readElementText();
							rm->comments=text;
							xmlReadingLog+="    Crt. room comments="+rm->comments+"\n";
						}
						else{
							unrecognizedXmlTags.append(xmlReader.name().toString());
							unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
							unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

							xmlReader.skipCurrentElement();
							xmlReaderNumberOfUnrecognizedFields++;
						}
					}
					
					if(!correct)
						delete rm;
					
					if(correct){
						if(rm->isVirtual){
							if(specifiedNumberOfSetsOfRooms==-1){
								xmlReader.raiseError(tr("The specified number of sets of real rooms was not found in the input file"
								 " for the virtual room %1").arg(rm->name));
								correct=false;
								
								delete rm;
							}
							else if(metNumberOfSetsOfRooms!=specifiedNumberOfSetsOfRooms){
								xmlReader.raiseError(tr("The specified number of sets of real rooms is not equal with the met number of sets of real rooms"
								 " for the virtual room %1").arg(rm->name));
								correct=false;
								
								delete rm;
							}
						}
					}
					
					if(correct){
						bool tmp2=roomsRead.contains(rm->name);
						if(tmp2){
							RulesReconcilableMessage::warning(parent, tr("FET warning"),
							 tr("Duplicate room %1 found - ignoring").arg(rm->name));
							xmlReadingLog+="   Room not added - duplicate\n";
							
							delete rm;
						}
						else{
							roomsRead.insert(rm->name);
							addRoomFast(rm);
							tmp++;
							xmlReadingLog+="   Room inserted\n";
						}
					}
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			if(!(tmp==this->roomsList.size()))
				xmlReader.raiseError(tr("%1 is incorrect").arg("Rooms_List"));
			else{
				assert(tmp==this->roomsList.size());
				xmlReadingLog+="  Added "+CustomFETString::number(tmp)+" rooms\n";
				reducedXmlLog+="Added "+CustomFETString::number(tmp)+" rooms\n";
			}
		}
		else if(xmlReader.name()==QString("Time_Constraints_List")){
			bool reportMaxBeginningsAtSecondHourChange=true;
			bool reportMaxGapsChange=true;
			bool reportStudentsSetNotAvailableChange=true;
			bool reportTeacherNotAvailableChange=true;
			bool reportBreakChange=true;
			
			bool reportActivityPreferredTimeChange=true;
			
			bool reportActivityPreferredTimesChange=true;
			bool reportActivitiesPreferredTimesChange=true;
			
			bool reportN1N2N3Change=true;
			
			bool reportUnspecifiedPermanentlyLockedTime=true;
			
			bool reportUnspecifiedDayOrHourPreferredStartingTime=true;

			bool reportMA5OldTimeConstraintsChange=true;
			
#if 0
			bool reportIncorrectMinDays=true;
#endif
		
			bool seeNextWarnNotAddedTimeConstraint=true;
			
			int nc=0;
			TimeConstraint *crt_constraint;
			assert(xmlReader.isStartElement());
			
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				crt_constraint=nullptr;
				if(xmlReader.name()==QString("ConstraintBasicCompulsoryTime")){
					crt_constraint=readBasicCompulsoryTime(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherNotAvailable")){
					if(reportTeacherNotAvailableChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						 tr("File contains constraint teacher not available, which is old (it was improved in FET 5.5.0), and will be converted"
						 " to the similar constraint of this type, constraint teacher not available times (a matrix)."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportTeacherNotAvailableChange=false;
					}

					crt_constraint=readTeacherNotAvailable(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherNotAvailableTimes")){
					crt_constraint=readTeacherNotAvailableTimes(xmlReader, xmlReadingLog);
				}
				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintTeacherMaxDaysPerWeek")){
					crt_constraint=readTeacherMaxDaysPerWeek(xmlReader, xmlReadingLog);
				}
				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintTeachersMaxDaysPerWeek")){
					crt_constraint=readTeachersMaxDaysPerWeek(xmlReader, xmlReadingLog);
				}

				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintTeacherMinDaysPerWeek")){
					crt_constraint=readTeacherMinDaysPerWeek(xmlReader, xmlReadingLog);
				}
				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintTeachersMinDaysPerWeek")){
					crt_constraint=readTeachersMinDaysPerWeek(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintTeacherIntervalMaxDaysPerWeek")){
					crt_constraint=readTeacherIntervalMaxDaysPerWeek(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersIntervalMaxDaysPerWeek")){
					crt_constraint=readTeachersIntervalMaxDaysPerWeek(parent, xmlReader, xmlReadingLog);
				}
				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsSetMaxDaysPerWeek")){
					crt_constraint=readStudentsSetMaxDaysPerWeek(parent, xmlReader, xmlReadingLog);
				}
				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsMaxDaysPerWeek")){
					crt_constraint=readStudentsMaxDaysPerWeek(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetIntervalMaxDaysPerWeek")){
					crt_constraint=readStudentsSetIntervalMaxDaysPerWeek(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsIntervalMaxDaysPerWeek")){
					crt_constraint=readStudentsIntervalMaxDaysPerWeek(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetNotAvailable")){
					if(reportStudentsSetNotAvailableChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						 tr("File contains constraint students set not available, which is old (it was improved in FET 5.5.0), and will be converted"
						 " to the similar constraint of this type, constraint students set not available times (a matrix)."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportStudentsSetNotAvailableChange=false;
					}

					crt_constraint=readStudentsSetNotAvailable(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetNotAvailableTimes")){
					crt_constraint=readStudentsSetNotAvailableTimes(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintMinNDaysBetweenActivities")){
					crt_constraint=readMinNDaysBetweenActivities(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintMinDaysBetweenActivities")){
					crt_constraint=readMinDaysBetweenActivities(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintMinHalfDaysBetweenActivities")){
					crt_constraint=readMinHalfDaysBetweenActivities(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintMaxDaysBetweenActivities")){
					crt_constraint=readMaxDaysBetweenActivities(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivitiesMaxHourlySpan")){
					crt_constraint=readActivitiesMaxHourlySpan(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintMaxHalfDaysBetweenActivities")){
					crt_constraint=readMaxHalfDaysBetweenActivities(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintMaxTermsBetweenActivities")){
					crt_constraint=readMaxTermsBetweenActivities(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintMinGapsBetweenActivities")){
					crt_constraint=readMinGapsBetweenActivities(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintMaxGapsBetweenActivities")){
					crt_constraint=readMaxGapsBetweenActivities(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivitiesNotOverlapping")){
					crt_constraint=readActivitiesNotOverlapping(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivityTagsNotOverlapping")){
					crt_constraint=readActivityTagsNotOverlapping(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivitiesSameStartingTime")){
					crt_constraint=readActivitiesSameStartingTime(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivitiesSameStartingHour")){
					crt_constraint=readActivitiesSameStartingHour(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivitiesSameStartingDay")){
					crt_constraint=readActivitiesSameStartingDay(xmlReader, xmlReadingLog);
				}
				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintTeachersMaxHoursDaily")){
					crt_constraint=readTeachersMaxHoursDaily(xmlReader, xmlReadingLog);
				}
				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintTeacherMaxHoursDaily")){
					crt_constraint=readTeacherMaxHoursDaily(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxHoursContinuously")){
					crt_constraint=readTeachersMaxHoursContinuously(xmlReader, xmlReadingLog);
				}
				//2025-05-30
				else if(xmlReader.name()==QString("ConstraintTeacherMaxHoursPerTerm")){
					crt_constraint=readTeacherMaxHoursPerTerm(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxHoursPerTerm")){
					crt_constraint=readTeachersMaxHoursPerTerm(xmlReader, xmlReadingLog);
				}
				//
				else if(xmlReader.name()==QString("ConstraintTeacherMaxHoursContinuously")){
					crt_constraint=readTeacherMaxHoursContinuously(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherActivityTagMaxHoursContinuously")){
					crt_constraint=readTeacherActivityTagMaxHoursContinuously(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersActivityTagMaxHoursContinuously")){
					crt_constraint=readTeachersActivityTagMaxHoursContinuously(xmlReader, xmlReadingLog);
				}

				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintTeacherActivityTagMaxHoursDaily")){
					crt_constraint=readTeacherActivityTagMaxHoursDaily(xmlReader, xmlReadingLog);
				}
				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintTeachersActivityTagMaxHoursDaily")){
					crt_constraint=readTeachersActivityTagMaxHoursDaily(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintTeacherActivityTagMinHoursDaily")){
					crt_constraint=readTeacherActivityTagMinHoursDaily(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersActivityTagMinHoursDaily")){
					crt_constraint=readTeachersActivityTagMinHoursDaily(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintTeachersMinHoursDaily")){
					crt_constraint=readTeachersMinHoursDaily(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMinHoursDaily")){
					crt_constraint=readTeacherMinHoursDaily(parent, xmlReader, xmlReadingLog);
				}
				else if((xmlReader.name()==QString("ConstraintTeachersSubgroupsMaxHoursDaily")
				 //TODO: erase the line below. It is only kept for compatibility with older versions
				 || xmlReader.name()==QString("ConstraintTeachersSubgroupsNoMoreThanXHoursDaily")) && !skipDeprecatedConstraints){
					int t=RulesReconcilableMessage::warning(parent, tr("FET warning"),
					 tr("File contains deprecated constraint teachers subgroups max hours daily - will be ignored"),
					 tr("Skip rest"), tr("See next"), QString(),
					 1, 0 );
					
					if(t==0)
						skipDeprecatedConstraints=true;
					crt_constraint=nullptr;
					xmlReader.skipCurrentElement();
				}
				else if(xmlReader.name()==QString("ConstraintStudentsNHoursDaily") && !skipDeprecatedConstraints){
					int t=RulesReconcilableMessage::warning(parent, tr("FET warning"),
					 tr("File contains deprecated constraint students n hours daily - will be ignored"),
					 tr("Skip rest"), tr("See next"), QString(),
					 1, 0 );
					
					if(t==0)
						skipDeprecatedConstraints=true;
					crt_constraint=nullptr;
					xmlReader.skipCurrentElement();
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetNHoursDaily") && !skipDeprecatedConstraints){
					int t=RulesReconcilableMessage::warning(parent, tr("FET warning"),
					 tr("File contains deprecated constraint students set n hours daily - will be ignored"),
					 tr("Skip rest"), tr("See next"), QString(),
					 1, 0 );
					
					if(t==0)
						skipDeprecatedConstraints=true;
					crt_constraint=nullptr;
					xmlReader.skipCurrentElement();
				}
				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsMaxHoursDaily")){
					crt_constraint=readStudentsMaxHoursDaily(xmlReader, xmlReadingLog);
				}
				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsSetMaxHoursDaily")){
					crt_constraint=readStudentsSetMaxHoursDaily(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxHoursContinuously")){
					crt_constraint=readStudentsMaxHoursContinuously(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxHoursContinuously")){
					crt_constraint=readStudentsSetMaxHoursContinuously(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetActivityTagMaxHoursContinuously")){
					crt_constraint=readStudentsSetActivityTagMaxHoursContinuously(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsActivityTagMaxHoursContinuously")){
					crt_constraint=readStudentsActivityTagMaxHoursContinuously(xmlReader, xmlReadingLog);
				}

				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsSetActivityTagMaxHoursDaily")){
					crt_constraint=readStudentsSetActivityTagMaxHoursDaily(xmlReader, xmlReadingLog);
				}
				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsActivityTagMaxHoursDaily")){
					crt_constraint=readStudentsActivityTagMaxHoursDaily(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintStudentsSetActivityTagMinHoursDaily")){
					crt_constraint=readStudentsSetActivityTagMinHoursDaily(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsActivityTagMinHoursDaily")){
					crt_constraint=readStudentsActivityTagMinHoursDaily(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintStudentsMinHoursDaily")){
					crt_constraint=readStudentsMinHoursDaily(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMinHoursDaily")){
					crt_constraint=readStudentsSetMinHoursDaily(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTags")){
					crt_constraint=readStudentsSetMinGapsBetweenOrderedPairOfActivityTags(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTags")){
					crt_constraint=readStudentsMinGapsBetweenOrderedPairOfActivityTags(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTags")){
					crt_constraint=readTeacherMinGapsBetweenOrderedPairOfActivityTags(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTags")){
					crt_constraint=readTeachersMinGapsBetweenOrderedPairOfActivityTags(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMinGapsBetweenActivityTag")){
					crt_constraint=readStudentsSetMinGapsBetweenActivityTag(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMinGapsBetweenActivityTag")){
					crt_constraint=readStudentsMinGapsBetweenActivityTag(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMinGapsBetweenActivityTag")){
					crt_constraint=readTeacherMinGapsBetweenActivityTag(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMinGapsBetweenActivityTag")){
					crt_constraint=readTeachersMinGapsBetweenActivityTag(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay")){
					crt_constraint=readStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsPerRealDay")){
					crt_constraint=readStudentsMinGapsBetweenOrderedPairOfActivityTagsPerRealDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsPerRealDay")){
					crt_constraint=readTeacherMinGapsBetweenOrderedPairOfActivityTagsPerRealDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsPerRealDay")){
					crt_constraint=readTeachersMinGapsBetweenOrderedPairOfActivityTagsPerRealDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMinGapsBetweenActivityTagPerRealDay")){
					crt_constraint=readStudentsSetMinGapsBetweenActivityTagPerRealDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMinGapsBetweenActivityTagPerRealDay")){
					crt_constraint=readStudentsMinGapsBetweenActivityTagPerRealDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMinGapsBetweenActivityTagPerRealDay")){
					crt_constraint=readTeacherMinGapsBetweenActivityTagPerRealDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMinGapsBetweenActivityTagPerRealDay")){
					crt_constraint=readTeachersMinGapsBetweenActivityTagPerRealDay(xmlReader, xmlReadingLog);
				}
				/////
				else if(xmlReader.name()==QString("ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon")){
					crt_constraint=readStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon")){
					crt_constraint=readStudentsMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon")){
					crt_constraint=readTeacherMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon")){
					crt_constraint=readTeachersMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon")){
					crt_constraint=readStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMinGapsBetweenActivityTagBetweenMorningAndAfternoon")){
					crt_constraint=readStudentsMinGapsBetweenActivityTagBetweenMorningAndAfternoon(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMinGapsBetweenActivityTagBetweenMorningAndAfternoon")){
					crt_constraint=readTeacherMinGapsBetweenActivityTagBetweenMorningAndAfternoon(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMinGapsBetweenActivityTagBetweenMorningAndAfternoon")){
					crt_constraint=readTeachersMinGapsBetweenActivityTagBetweenMorningAndAfternoon(xmlReader, xmlReadingLog);
				}
				/////
				else if(xmlReader.name()==QString("ConstraintActivityPreferredTime")){
					if(reportActivityPreferredTimeChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						 tr("File contains old constraint type activity preferred time, which will be converted"
						 " to the newer similar constraint of this type, constraint activity preferred STARTING time."
						 " This improvement is done in versions 5.5.9 and above"),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportActivityPreferredTimeChange=false;
					}
					
					crt_constraint=readActivityPreferredTime(parent, xmlReader, xmlReadingLog,
						reportUnspecifiedPermanentlyLockedTime, reportUnspecifiedDayOrHourPreferredStartingTime);
				}
				
				else if(xmlReader.name()==QString("ConstraintActivityPreferredStartingTime")){
					crt_constraint=readActivityPreferredStartingTime(parent, xmlReader, xmlReadingLog,
						reportUnspecifiedPermanentlyLockedTime, reportUnspecifiedDayOrHourPreferredStartingTime);
				}
				else if(xmlReader.name()==QString("ConstraintActivityPreferredDay")){
					crt_constraint=readActivityPreferredDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivityEndsStudentsDay")){
					crt_constraint=readActivityEndsStudentsDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivitiesEndStudentsDay")){
					crt_constraint=readActivitiesEndStudentsDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivityEndsTeachersDay")){
					crt_constraint=readActivityEndsTeachersDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivitiesEndTeachersDay")){
					crt_constraint=readActivitiesEndTeachersDay(xmlReader, xmlReadingLog);
				}
				//
				else if(xmlReader.name()==QString("ConstraintActivityBeginsStudentsDay")){
					crt_constraint=readActivityBeginsStudentsDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivitiesBeginStudentsDay")){
					crt_constraint=readActivitiesBeginStudentsDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivityBeginsTeachersDay")){
					crt_constraint=readActivityBeginsTeachersDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivitiesBeginTeachersDay")){
					crt_constraint=readActivitiesBeginTeachersDay(xmlReader, xmlReadingLog);
				}
				//
				else if(xmlReader.name()==QString("ConstraintActivityBeginsOrEndsStudentsDay")){
					crt_constraint=readActivityBeginsOrEndsStudentsDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivitiesBeginOrEndStudentsDay")){
					crt_constraint=readActivitiesBeginOrEndStudentsDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivityBeginsOrEndsTeachersDay")){
					crt_constraint=readActivityBeginsOrEndsTeachersDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivitiesBeginOrEndTeachersDay")){
					crt_constraint=readActivitiesBeginOrEndTeachersDay(xmlReader, xmlReadingLog);
				}
				//
				//old, with 2 and 3
				else if(xmlReader.name()==QString("Constraint2ActivitiesConsecutive")){
					crt_constraint=read2ActivitiesConsecutive(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("Constraint2ActivitiesGrouped")){
					crt_constraint=read2ActivitiesGrouped(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("Constraint3ActivitiesGrouped")){
					crt_constraint=read3ActivitiesGrouped(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("Constraint2ActivitiesOrdered")){
					crt_constraint=read2ActivitiesOrdered(xmlReader, xmlReadingLog);
				}
				//end old
				else if(xmlReader.name()==QString("ConstraintTwoActivitiesConsecutive")){
					crt_constraint=readTwoActivitiesConsecutive(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTwoActivitiesGrouped")){
					crt_constraint=readTwoActivitiesGrouped(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintThreeActivitiesGrouped")){
					crt_constraint=readThreeActivitiesGrouped(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTwoActivitiesOrdered")){
					crt_constraint=readTwoActivitiesOrdered(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTwoSetsOfActivitiesOrdered")){
					crt_constraint=readTwoSetsOfActivitiesOrdered(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTwoActivitiesOrderedIfSameDay")){
					crt_constraint=readTwoActivitiesOrderedIfSameDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivityEndsDay") && !skipDeprecatedConstraints ){
					int t=RulesReconcilableMessage::warning(parent, tr("FET warning"),
					 tr("File contains deprecated constraint activity ends day - will be ignored"),
					 tr("Skip rest"), tr("See next"), QString(),
					 1, 0 );
					
					if(t==0)
						skipDeprecatedConstraints=true;
					crt_constraint=nullptr;
					xmlReader.skipCurrentElement();
				}
				else if(xmlReader.name()==QString("ConstraintActivityPreferredTimes")){
					if(reportActivityPreferredTimesChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						 tr("Your file contains old constraint activity preferred times, which will be converted to"
						 " new equivalent constraint activity preferred starting times. Beginning with FET-5.5.9 it is possible"
						 " to specify: 1. the starting times of an activity (constraint activity preferred starting times)"
						 " or: 2. the accepted time slots (constraint activity preferred time slots)."
						 " If what you need is type 2 of this constraint, you will have to add it by yourself from the interface."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportActivityPreferredTimesChange=false;
					}
					
					crt_constraint=readActivityPreferredTimes(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivityPreferredTimeSlots")){
					crt_constraint=readActivityPreferredTimeSlots(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivityPreferredStartingTimes")){
					crt_constraint=readActivityPreferredStartingTimes(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintBreak")){
					if(reportBreakChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						 tr("File contains constraint break, which is old (it was improved in FET 5.5.0), and will be converted"
						 " to the similar constraint of this type, constraint break times (a matrix)."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportBreakChange=false;
					}
					
					crt_constraint=readBreak(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintBreakTimes")){
					crt_constraint=readBreakTimes(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersNoGaps")){
					crt_constraint=readTeachersNoGaps(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxGapsPerWeek")){
					crt_constraint=readTeachersMaxGapsPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMaxGapsPerWeek")){
					crt_constraint=readTeacherMaxGapsPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxGapsPerDay")){
					crt_constraint=readTeachersMaxGapsPerDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMaxGapsPerDay")){
					crt_constraint=readTeacherMaxGapsPerDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxGapsPerMorningAndAfternoon")){
					crt_constraint=readTeachersMaxGapsPerMorningAndAfternoon(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMaxGapsPerMorningAndAfternoon")){
					crt_constraint=readTeacherMaxGapsPerMorningAndAfternoon(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsNoGaps")){
					if(reportMaxGapsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						 tr("File contains constraint students no gaps, which is old (it was improved in FET 5.5.0), and will be converted"
						 " to the similar constraint of this type, constraint students max gaps per week,"
						 " with max gaps=0. If you like, you can modify this constraint to allow"
						 " more gaps per week (normally not accepted in schools)"),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMaxGapsChange=false;
					}
					
					crt_constraint=readStudentsNoGaps(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetNoGaps")){
					if(reportMaxGapsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						 tr("File contains constraint students set no gaps, which is old (it was improved in FET 5.5.0), and will be converted"
						 " to the similar constraint of this type, constraint students set max gaps per week,"
						 " with max gaps=0. If you like, you can modify this constraint to allow"
						 " more gaps per week (normally not accepted in schools)"),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMaxGapsChange=false;
					}
					
					crt_constraint=readStudentsSetNoGaps(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxGapsPerWeek")){
					crt_constraint=readStudentsMaxGapsPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxGapsPerWeek")){
					crt_constraint=readStudentsSetMaxGapsPerWeek(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintStudentsMaxGapsPerDay")){
					crt_constraint=readStudentsMaxGapsPerDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxGapsPerDay")){
					crt_constraint=readStudentsSetMaxGapsPerDay(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxSingleGapsInSelectedTimeSlots")){
					crt_constraint=readStudentsSetMaxSingleGapsInSelectedTimeSlots(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxSingleGapsInSelectedTimeSlots")){
					crt_constraint=readStudentsMaxSingleGapsInSelectedTimeSlots(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintTeacherMaxSingleGapsInSelectedTimeSlots")){
					crt_constraint=readTeacherMaxSingleGapsInSelectedTimeSlots(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxSingleGapsInSelectedTimeSlots")){
					crt_constraint=readTeachersMaxSingleGapsInSelectedTimeSlots(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintStudentsEarly")){
					if(reportMaxBeginningsAtSecondHourChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						 tr("File contains constraint students early, which is old (it was improved in FET 5.5.0), and will be converted"
						 " to the similar constraint of this type, constraint students early max beginnings at second hour,"
						 " with max beginnings=0. If you like, you can modify this constraint to allow"
						 " more beginnings at second available hour (above 0 - this will make the timetable easier)"),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
 						if(t==0)
							reportMaxBeginningsAtSecondHourChange=false;
					}
					
					crt_constraint=readStudentsEarly(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsEarlyMaxBeginningsAtSecondHour")){
					crt_constraint=readStudentsEarlyMaxBeginningsAtSecondHour(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetEarly")){
					if(reportMaxBeginningsAtSecondHourChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						 tr("File contains constraint students set early, which is old (it was improved in FET 5.5.0), and will be converted"
						 " to the similar constraint of this type, constraint students set early max beginnings at second hour,"
						 " with max beginnings=0. If you like, you can modify this constraint to allow"
						 " more beginnings at second available hour (above 0 - this will make the timetable easier)"),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMaxBeginningsAtSecondHourChange=false;
					}
					
					crt_constraint=readStudentsSetEarly(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetEarlyMaxBeginningsAtSecondHour")){
					crt_constraint=readStudentsSetEarlyMaxBeginningsAtSecondHour(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivitiesPreferredTimes")){
					if(reportActivitiesPreferredTimesChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						 tr("Your file contains old constraint activities preferred times, which will be converted to"
						 " new equivalent constraint activities preferred starting times. Beginning with FET-5.5.9 it is possible"
						 " to specify: 1. the starting times of several activities (constraint activities preferred starting times)"
						 " or: 2. the accepted time slots (constraint activities preferred time slots)."
						 " If what you need is type 2 of this constraint, you will have to add it by yourself from the interface."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportActivitiesPreferredTimesChange=false;
					}
					
					crt_constraint=readActivitiesPreferredTimes(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivitiesPreferredTimeSlots")){
					crt_constraint=readActivitiesPreferredTimeSlots(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivitiesPreferredStartingTimes")){
					crt_constraint=readActivitiesPreferredStartingTimes(xmlReader, xmlReadingLog);
				}
////////////////
				else if(xmlReader.name()==QString("ConstraintSubactivitiesPreferredTimeSlots")){
					crt_constraint=readSubactivitiesPreferredTimeSlots(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintSubactivitiesPreferredStartingTimes")){
					crt_constraint=readSubactivitiesPreferredStartingTimes(xmlReader, xmlReadingLog);
				}
////////////////2025-04-02
				else if(xmlReader.name()==QString("ConstraintTwoSetsOfActivitiesSameSections")){
					crt_constraint=readTwoSetsOfActivitiesSameSections(xmlReader, xmlReadingLog);
				}
////////////////2025-08-09
				else if(xmlReader.name()==QString("ConstraintActivitiesPairOfMutuallyExclusiveSetsOfTimeSlots")){
					crt_constraint=readActivitiesPairOfMutuallyExclusiveSetsOfTimeSlots(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivitiesPairOfMutuallyExclusiveTimeSlots")){
					crt_constraint=readActivitiesPairOfMutuallyExclusiveTimeSlots(xmlReader, xmlReadingLog);
				}
////////////////2025-09-22
				//old deprecated name
				else if(xmlReader.name()==QString("ConstraintActivitiesOverlapCompletelyOrDontOverlap")){
					crt_constraint=readActivitiesOverlapCompletelyOrDontOverlap(xmlReader, xmlReadingLog);
				}
				//2025-09-26
				else if(xmlReader.name()==QString("ConstraintActivitiesOverlapCompletelyOrDoNotOverlap")){
					crt_constraint=readActivitiesOverlapCompletelyOrDoNotOverlap(xmlReader, xmlReadingLog);
				}
////////////////2011-09-25
				else if(xmlReader.name()==QString("ConstraintActivitiesOccupyMaxTimeSlotsFromSelection")){
					crt_constraint=readActivitiesOccupyMaxTimeSlotsFromSelection(xmlReader, xmlReadingLog);
				}
////////////////
////////////////2025-10-18
				else if(xmlReader.name()==QString("ConstraintActivitiesMaxTotalNumberOfStudentsInSelectedTimeSlots")){
					crt_constraint=readActivitiesMaxTotalNumberOfStudentsInSelectedTimeSlots(xmlReader, xmlReadingLog);
				}
////////////////
////////////////2019-11-16
				else if(xmlReader.name()==QString("ConstraintActivitiesOccupyMinTimeSlotsFromSelection")){
					crt_constraint=readActivitiesOccupyMinTimeSlotsFromSelection(xmlReader, xmlReadingLog);
				}
////////////////
////////////////2011-09-30
				else if(xmlReader.name()==QString("ConstraintActivitiesMaxSimultaneousInSelectedTimeSlots")){
					crt_constraint=readActivitiesMaxSimultaneousInSelectedTimeSlots(xmlReader, xmlReadingLog);
				}
////////////////
////////////////2019-11-16
				else if(xmlReader.name()==QString("ConstraintActivitiesMinSimultaneousInSelectedTimeSlots")){
					crt_constraint=readActivitiesMinSimultaneousInSelectedTimeSlots(xmlReader, xmlReadingLog);
				}
////////////////
////////////////2020-05-02
				else if(xmlReader.name()==QString("ConstraintMaxTotalActivitiesFromSetInSelectedTimeSlots")){
					crt_constraint=readMaxTotalActivitiesFromSetInSelectedTimeSlots(xmlReader, xmlReadingLog);
				}
////////////////
////////////////2020-01-14
				else if(xmlReader.name()==QString("ConstraintActivitiesMaxInATerm")){
					crt_constraint=readActivitiesMaxInATerm(xmlReader, xmlReadingLog);
				}
////////////////
////////////////2022-05-20
				else if(xmlReader.name()==QString("ConstraintActivitiesMinInATerm")){
					crt_constraint=readActivitiesMinInATerm(xmlReader, xmlReadingLog);
				}
////////////////
////////////////2020-01-14
				else if(xmlReader.name()==QString("ConstraintActivitiesOccupyMaxTerms")){
					crt_constraint=readActivitiesOccupyMaxTerms(xmlReader, xmlReadingLog);
				}
////////////////

				else if(xmlReader.name()==QString("ConstraintTeachersSubjectTagsMaxHoursContinuously") && !skipDeprecatedConstraints){
					int t=RulesReconcilableMessage::warning(parent, tr("FET warning"),
					 tr("File contains deprecated constraint teachers subject tags max hours continuously - will be ignored"),
					 tr("Skip rest"), tr("See next"), QString(),
					 1, 0 );
					
					if(t==0)
						skipDeprecatedConstraints=true;
					crt_constraint=nullptr;
					xmlReader.skipCurrentElement();
				}
				else if(xmlReader.name()==QString("ConstraintTeachersSubjectTagMaxHoursContinuously") && !skipDeprecatedConstraints){
					int t=RulesReconcilableMessage::warning(parent, tr("FET warning"),
					 tr("File contains deprecated constraint teachers subject tag max hours continuously - will be ignored"),
					 tr("Skip rest"), tr("See next"), QString(),
					 1, 0 );
					
					if(t==0)
						skipDeprecatedConstraints=true;
					crt_constraint=nullptr;
					xmlReader.skipCurrentElement();
				}
				/////////begin 2017-02-07
				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintTeacherMaxSpanPerDay")){
					crt_constraint=readTeacherMaxSpanPerDay(xmlReader, xmlReadingLog);
				}
				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintTeachersMaxSpanPerDay")){
					crt_constraint=readTeachersMaxSpanPerDay(xmlReader, xmlReadingLog);
				}
				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsSetMaxSpanPerDay")){
					crt_constraint=readStudentsSetMaxSpanPerDay(xmlReader, xmlReadingLog);
				}
				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsMaxSpanPerDay")){
					crt_constraint=readStudentsMaxSpanPerDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMinRestingHours")){
					crt_constraint=readTeacherMinRestingHours(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMinRestingHours")){
					crt_constraint=readTeachersMinRestingHours(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMinRestingHours")){
					crt_constraint=readStudentsSetMinRestingHours(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMinRestingHours")){
					crt_constraint=readStudentsMinRestingHours(xmlReader, xmlReadingLog);
				}

				/////////  end 2017-02-07
				//mornings-afternoons

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintTeacherMaxDaysPerWeek")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type teacher max days per week, which will be converted"
						  " to a constraint of type teacher max real days per week."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMATeacherMaxDaysPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMaxRealDaysPerWeek")){
					crt_constraint=readTeacherMaxRealDaysPerWeek(xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintTeachersMaxDaysPerWeek")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type teachers max days per week, which will be converted"
						  " to a constraint of type teachers max real days per week."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMATeachersMaxDaysPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxRealDaysPerWeek")){
					crt_constraint=readTeachersMaxRealDaysPerWeek(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintTeacherMaxAfternoonsPerWeek")){
					crt_constraint=readTeacherMaxAfternoonsPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxAfternoonsPerWeek")){
					crt_constraint=readTeachersMaxAfternoonsPerWeek(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintTeacherMaxTwoActivityTagsPerDayFromN1N2N3")){
					if(reportN1N2N3Change){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						 tr("Your file contains a constraint of type teacher(s)/students (set) max two activity tags"
						 " per day/real day from N1, N2, N3, which will be converted to the newer constraint,"
						 " teacher(s)/students (set) max activity tags per day/real day from a set"),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportN1N2N3Change=false;
					}

					crt_constraint=readTeacherMaxTwoActivityTagsPerDayFromN1N2N3(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxTwoActivityTagsPerDayFromN1N2N3")){
					if(reportN1N2N3Change){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						 tr("Your file contains a constraint of type teacher(s)/students (set) max two activity tags"
						 " per day/real day from N1, N2, N3, which will be converted to the newer constraint,"
						 " teacher(s)/students (set) max activity tags per day/real day from a set"),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportN1N2N3Change=false;
					}

					crt_constraint=readTeachersMaxTwoActivityTagsPerDayFromN1N2N3(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxTwoActivityTagsPerDayFromN1N2N3")){
					if(reportN1N2N3Change){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						 tr("Your file contains a constraint of type teacher(s)/students (set) max two activity tags"
						 " per day/real day from N1, N2, N3, which will be converted to the newer constraint,"
						 " teacher(s)/students (set) max activity tags per day/real day from a set"),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportN1N2N3Change=false;
					}

					crt_constraint=readStudentsSetMaxTwoActivityTagsPerDayFromN1N2N3(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxTwoActivityTagsPerDayFromN1N2N3")){
					if(reportN1N2N3Change){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						 tr("Your file contains a constraint of type teacher(s)/students (set) max two activity tags"
						 " per day/real day from N1, N2, N3, which will be converted to the newer constraint,"
						 " teacher(s)/students (set) max activity tags per day/real day from a set"),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportN1N2N3Change=false;
					}

					crt_constraint=readStudentsMaxTwoActivityTagsPerDayFromN1N2N3(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintTeacherMaxTwoActivityTagsPerRealDayFromN1N2N3")){
					if(reportN1N2N3Change){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						 tr("Your file contains a constraint of type teacher(s)/students (set) max two activity tags"
						 " per day/real day from N1, N2, N3, which will be converted to the newer constraint,"
						 " teacher(s)/students (set) max activity tags per day/real day from a set"),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportN1N2N3Change=false;
					}

					crt_constraint=readTeacherMaxTwoActivityTagsPerRealDayFromN1N2N3(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxTwoActivityTagsPerRealDayFromN1N2N3")){
					if(reportN1N2N3Change){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						 tr("Your file contains a constraint of type teacher(s)/students (set) max two activity tags"
						 " per day/real day from N1, N2, N3, which will be converted to the newer constraint,"
						 " teacher(s)/students (set) max activity tags per day/real day from a set"),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportN1N2N3Change=false;
					}

					crt_constraint=readTeachersMaxTwoActivityTagsPerRealDayFromN1N2N3(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxTwoActivityTagsPerRealDayFromN1N2N3")){
					if(reportN1N2N3Change){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						 tr("Your file contains a constraint of type teacher(s)/students (set) max two activity tags"
						 " per day/real day from N1, N2, N3, which will be converted to the newer constraint,"
						 " teacher(s)/students (set) max activity tags per day/real day from a set"),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportN1N2N3Change=false;
					}

					crt_constraint=readStudentsSetMaxTwoActivityTagsPerRealDayFromN1N2N3(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxTwoActivityTagsPerRealDayFromN1N2N3")){
					if(reportN1N2N3Change){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						 tr("Your file contains a constraint of type teacher(s)/students (set) max two activity tags"
						 " per day/real day from N1, N2, N3, which will be converted to the newer constraint,"
						 " teacher(s)/students (set) max activity tags per day/real day from a set"),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportN1N2N3Change=false;
					}

					crt_constraint=readStudentsMaxTwoActivityTagsPerRealDayFromN1N2N3(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintTeacherMaxActivityTagsPerDayFromSet")){
					crt_constraint=readTeacherMaxActivityTagsPerDayFromSet(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxActivityTagsPerDayFromSet")){
					crt_constraint=readTeachersMaxActivityTagsPerDayFromSet(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxActivityTagsPerDayFromSet")){
					crt_constraint=readStudentsSetMaxActivityTagsPerDayFromSet(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxActivityTagsPerDayFromSet")){
					crt_constraint=readStudentsMaxActivityTagsPerDayFromSet(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintTeacherMaxActivityTagsPerRealDayFromSet")){
					crt_constraint=readTeacherMaxActivityTagsPerRealDayFromSet(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxActivityTagsPerRealDayFromSet")){
					crt_constraint=readTeachersMaxActivityTagsPerRealDayFromSet(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxActivityTagsPerRealDayFromSet")){
					crt_constraint=readStudentsSetMaxActivityTagsPerRealDayFromSet(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxActivityTagsPerRealDayFromSet")){
					crt_constraint=readStudentsMaxActivityTagsPerRealDayFromSet(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintTeacherMaxMorningsPerWeek")){
					crt_constraint=readTeacherMaxMorningsPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxMorningsPerWeek")){
					crt_constraint=readTeachersMaxMorningsPerWeek(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintTeacherMaxTwoConsecutiveMornings")){
					crt_constraint=readTeacherMaxTwoConsecutiveMornings(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxTwoConsecutiveMornings")){
					crt_constraint=readTeachersMaxTwoConsecutiveMornings(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMaxTwoConsecutiveAfternoons")){
					crt_constraint=readTeacherMaxTwoConsecutiveAfternoons(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxTwoConsecutiveAfternoons")){
					crt_constraint=readTeachersMaxTwoConsecutiveAfternoons(xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintTeacherMinDaysPerWeek")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type teacher min days per week, which will be converted"
						  " to a constraint of type teacher min real days per week."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMATeacherMinDaysPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMinRealDaysPerWeek")){
					crt_constraint=readTeacherMinRealDaysPerWeek(xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintTeachersMinDaysPerWeek")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type teachers min days per week, which will be converted"
						  " to a constraint of type teachers min real days per week."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMATeachersMinDaysPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMinRealDaysPerWeek")){
					crt_constraint=readTeachersMinRealDaysPerWeek(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintTeacherMinMorningsPerWeek")){
					crt_constraint=readTeacherMinMorningsPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMinMorningsPerWeek")){
					crt_constraint=readTeachersMinMorningsPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMinAfternoonsPerWeek")){
					crt_constraint=readTeacherMinAfternoonsPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMinAfternoonsPerWeek")){
					crt_constraint=readTeachersMinAfternoonsPerWeek(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintTeacherMorningIntervalMaxDaysPerWeek")){
					crt_constraint=readTeacherMorningIntervalMaxDaysPerWeek(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMorningIntervalMaxDaysPerWeek")){
					crt_constraint=readTeachersMorningIntervalMaxDaysPerWeek(parent, xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintTeacherAfternoonIntervalMaxDaysPerWeek")){
					crt_constraint=readTeacherAfternoonIntervalMaxDaysPerWeek(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersAfternoonIntervalMaxDaysPerWeek")){
					crt_constraint=readTeachersAfternoonIntervalMaxDaysPerWeek(parent, xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsSetMaxDaysPerWeek")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type students set max days per week, which will be converted"
						  " to a constraint of type students set max real days per week."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMAStudentsSetMaxDaysPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxRealDaysPerWeek")){
					crt_constraint=readStudentsSetMaxRealDaysPerWeek(xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsMaxDaysPerWeek")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type students max days per week, which will be converted"
						  " to a constraint of type students max real days per week."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMAStudentsMaxDaysPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxRealDaysPerWeek")){
					crt_constraint=readStudentsMaxRealDaysPerWeek(xmlReader, xmlReadingLog);
				}
				//2020-06-25
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxAfternoonsPerWeek")){
					crt_constraint=readStudentsSetMaxAfternoonsPerWeek(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxAfternoonsPerWeek")){
					crt_constraint=readStudentsMaxAfternoonsPerWeek(parent, xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxMorningsPerWeek")){
					crt_constraint=readStudentsSetMaxMorningsPerWeek(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxMorningsPerWeek")){
					crt_constraint=readStudentsMaxMorningsPerWeek(parent, xmlReader, xmlReadingLog);
				}
				//2020-06-26
				else if(xmlReader.name()==QString("ConstraintStudentsSetMinAfternoonsPerWeek")){
					crt_constraint=readStudentsSetMinAfternoonsPerWeek(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMinAfternoonsPerWeek")){
					crt_constraint=readStudentsMinAfternoonsPerWeek(parent, xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintStudentsSetMinMorningsPerWeek")){
					crt_constraint=readStudentsSetMinMorningsPerWeek(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMinMorningsPerWeek")){
					crt_constraint=readStudentsMinMorningsPerWeek(parent, xmlReader, xmlReadingLog);
				}
				//

				else if(xmlReader.name()==QString("ConstraintStudentsSetMorningIntervalMaxDaysPerWeek")){
					crt_constraint=readStudentsSetMorningIntervalMaxDaysPerWeek(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMorningIntervalMaxDaysPerWeek")){
					crt_constraint=readStudentsMorningIntervalMaxDaysPerWeek(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetAfternoonIntervalMaxDaysPerWeek")){
					crt_constraint=readStudentsSetAfternoonIntervalMaxDaysPerWeek(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsAfternoonIntervalMaxDaysPerWeek")){
					crt_constraint=readStudentsAfternoonIntervalMaxDaysPerWeek(parent, xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintTeachersMaxHoursDaily")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type teachers max hours daily, which will be converted"
						  " to a constraint of type teachers max hours daily real days."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMATeachersMaxHoursDaily(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxHoursDailyRealDays")){
					crt_constraint=readTeachersMaxHoursDailyRealDays(xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintTeacherMaxHoursDaily")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type teacher max hours daily, which will be converted"
						  " to a constraint of type teacher max hours daily real days."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMATeacherMaxHoursDaily(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMaxHoursDailyRealDays")){
					crt_constraint=readTeacherMaxHoursDailyRealDays(xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintTeachersMaxHoursDailyHalfDays")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type teachers max hours daily for half days, which will be converted"
						  " to a constraint of type teachers max hours daily."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMATeachersMaxHoursDailyHalfDays(xmlReader, xmlReadingLog);
				}
				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintTeacherMaxHoursDailyHalfDays")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type teacher max hours daily for half days, which will be converted"
						  " to a constraint of type teacher max hours daily."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMATeacherMaxHoursDailyHalfDays(xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintTeacherActivityTagMaxHoursDaily")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type teacher activity tag max hours daily, which will be converted"
						  " to a constraint of type teacher activity tag max hours daily real days."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMATeacherActivityTagMaxHoursDaily(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherActivityTagMaxHoursDailyRealDays")){
					crt_constraint=readTeacherActivityTagMaxHoursDailyRealDays(xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintTeachersActivityTagMaxHoursDaily")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type teachers activity tag max hours daily, which will be converted"
						  " to a constraint of type teachers activity tag max hours daily real days."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMATeachersActivityTagMaxHoursDaily(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersActivityTagMaxHoursDailyRealDays")){
					crt_constraint=readTeachersActivityTagMaxHoursDailyRealDays(xmlReader, xmlReadingLog);
				}

				//2020-06-28
				else if(xmlReader.name()==QString("ConstraintTeacherMaxHoursPerAllAfternoons")){
					crt_constraint=readTeacherMaxHoursPerAllAfternoons(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxHoursPerAllAfternoons")){
					crt_constraint=readTeachersMaxHoursPerAllAfternoons(xmlReader, xmlReadingLog);
				}
				//2020-06-28
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxHoursPerAllAfternoons")){
					crt_constraint=readStudentsSetMaxHoursPerAllAfternoons(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxHoursPerAllAfternoons")){
					crt_constraint=readStudentsMaxHoursPerAllAfternoons(xmlReader, xmlReadingLog);
				}
				//

				else if(xmlReader.name()==QString("ConstraintTeachersMinHoursDailyRealDays")){
					crt_constraint=readTeachersMinHoursDailyRealDays(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMinHoursDailyRealDays")){
					crt_constraint=readTeacherMinHoursDailyRealDays(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMinHoursPerMorning")){
					crt_constraint=readTeachersMinHoursPerMorning(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMinHoursPerMorning")){
					crt_constraint=readTeacherMinHoursPerMorning(parent, xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintTeachersMinHoursPerAfternoon")){
					crt_constraint=readTeachersMinHoursPerAfternoon(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMinHoursPerAfternoon")){
					crt_constraint=readTeacherMinHoursPerAfternoon(parent, xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsMaxHoursDaily")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type students max hours daily, which will be converted"
						  " to a constraint of type students max hours daily real days."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMAStudentsMaxHoursDaily(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxHoursDailyRealDays")){
					crt_constraint=readStudentsMaxHoursDailyRealDays(xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsSetMaxHoursDaily")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type student set max hours daily, which will be converted"
						  " to a constraint of type students set max hours daily real days."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMAStudentsSetMaxHoursDaily(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxHoursDailyRealDays")){
					crt_constraint=readStudentsSetMaxHoursDailyRealDays(xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsSetActivityTagMaxHoursDaily")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type student set activity tag max hours daily, which will be converted"
						  " to a constraint of type students set activity tag max hours daily real days."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMAStudentsSetActivityTagMaxHoursDaily(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetActivityTagMaxHoursDailyRealDays")){
					crt_constraint=readStudentsSetActivityTagMaxHoursDailyRealDays(xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsActivityTagMaxHoursDaily")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type students activity tag max hours daily, which will be converted"
						  " to a constraint of type students activity tag max hours daily real days."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMAStudentsActivityTagMaxHoursDaily(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsActivityTagMaxHoursDailyRealDays")){
					crt_constraint=readStudentsActivityTagMaxHoursDailyRealDays(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintStudentsMinHoursPerMorning")){
					crt_constraint=readStudentsMinHoursPerMorning(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMinHoursPerMorning")){
					crt_constraint=readStudentsSetMinHoursPerMorning(parent, xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintStudentsMinHoursPerAfternoon")){
					crt_constraint=readStudentsMinHoursPerAfternoon(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMinHoursPerAfternoon")){
					crt_constraint=readStudentsSetMinHoursPerAfternoon(parent, xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintTeachersAfternoonsEarlyMaxBeginningsAtSecondHour")){
					crt_constraint=readTeachersAfternoonsEarlyMaxBeginningsAtSecondHour(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherAfternoonsEarlyMaxBeginningsAtSecondHour")){
					crt_constraint=readTeacherAfternoonsEarlyMaxBeginningsAtSecondHour(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMorningsEarlyMaxBeginningsAtSecondHour")){
					crt_constraint=readTeachersMorningsEarlyMaxBeginningsAtSecondHour(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMorningsEarlyMaxBeginningsAtSecondHour")){
					crt_constraint=readTeacherMorningsEarlyMaxBeginningsAtSecondHour(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxGapsPerRealDay")){
					crt_constraint=readTeachersMaxGapsPerRealDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMaxGapsPerRealDay")){
					crt_constraint=readTeacherMaxGapsPerRealDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMaxZeroGapsPerAfternoon")){
					crt_constraint=readTeacherMaxZeroGapsPerAfternoon(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxZeroGapsPerAfternoon")){
					crt_constraint=readTeachersMaxZeroGapsPerAfternoon(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintStudentsMaxGapsPerRealDay")){
					crt_constraint=readStudentsMaxGapsPerRealDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxGapsPerRealDay")){
					crt_constraint=readStudentsSetMaxGapsPerRealDay(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintTeachersMaxGapsPerWeekForRealDays")){
					crt_constraint=readTeachersMaxGapsPerWeekForRealDays(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMaxGapsPerWeekForRealDays")){
					crt_constraint=readTeacherMaxGapsPerWeekForRealDays(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxGapsPerWeekForRealDays")){
					crt_constraint=readStudentsMaxGapsPerWeekForRealDays(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxGapsPerWeekForRealDays")){
					crt_constraint=readStudentsSetMaxGapsPerWeekForRealDays(xmlReader, xmlReadingLog);
				}

				//////////
				else if(xmlReader.name()==QString("ConstraintStudentsAfternoonsEarlyMaxBeginningsAtSecondHour")){
					crt_constraint=readStudentsAfternoonsEarlyMaxBeginningsAtSecondHour(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetAfternoonsEarlyMaxBeginningsAtSecondHour")){
					crt_constraint=readStudentsSetAfternoonsEarlyMaxBeginningsAtSecondHour(xmlReader, xmlReadingLog);
				}
				//////////
				else if(xmlReader.name()==QString("ConstraintStudentsMorningsEarlyMaxBeginningsAtSecondHour")){
					crt_constraint=readStudentsMorningsEarlyMaxBeginningsAtSecondHour(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMorningsEarlyMaxBeginningsAtSecondHour")){
					crt_constraint=readStudentsSetMorningsEarlyMaxBeginningsAtSecondHour(xmlReader, xmlReadingLog);
				}
				//////////

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintTeacherMaxSpanPerDay")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type teacher max span per day, which will be converted"
						  " to a constraint of type teacher max span per real day."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMATeacherMaxSpanPerDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMaxSpanPerRealDay")){
					crt_constraint=readTeacherMaxSpanPerRealDay(xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintTeachersMaxSpanPerDay")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type teachers max span per day, which will be converted"
						  " to a constraint of type teachers max span per real day."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMATeachersMaxSpanPerDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxSpanPerRealDay")){
					crt_constraint=readTeachersMaxSpanPerRealDay(xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsSetMaxSpanPerDay")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type students set max span per day, which will be converted"
						  " to a constraint of type students set max span per real day."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMAStudentsSetMaxSpanPerDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxSpanPerRealDay")){
					crt_constraint=readStudentsSetMaxSpanPerRealDay(xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsMaxSpanPerDay")){
					if(reportMA5OldTimeConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type students max span per day, which will be converted"
						  " to a constraint of type students max span per real day."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldTimeConstraintsChange=false;
					}
					crt_constraint=readOldMAStudentsMaxSpanPerDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxSpanPerRealDay")){
					crt_constraint=readStudentsMaxSpanPerRealDay(xmlReader, xmlReadingLog);
				}

				//
				else if(xmlReader.name()==QString("ConstraintTeacherMinRestingHoursBetweenMorningAndAfternoon")){
					crt_constraint=readTeacherMinRestingHoursBetweenMorningAndAfternoon(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMinRestingHoursBetweenMorningAndAfternoon")){
					crt_constraint=readTeachersMinRestingHoursBetweenMorningAndAfternoon(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMinRestingHoursBetweenMorningAndAfternoon")){
					crt_constraint=readStudentsSetMinRestingHoursBetweenMorningAndAfternoon(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMinRestingHoursBetweenMorningAndAfternoon")){
					crt_constraint=readStudentsMinRestingHoursBetweenMorningAndAfternoon(xmlReader, xmlReadingLog);
				}
				//
				else if(xmlReader.name()==QString("ConstraintTeacherNoTwoConsecutiveDays")){
					crt_constraint=readTeacherNoTwoConsecutiveDays(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersNoTwoConsecutiveDays")){
					crt_constraint=readTeachersNoTwoConsecutiveDays(xmlReader, xmlReadingLog);
				}
				//
				else if(xmlReader.name()==QString("ConstraintTeacherMaxThreeConsecutiveDays")){
					crt_constraint=readTeacherMaxThreeConsecutiveDays(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxThreeConsecutiveDays")){
					crt_constraint=readTeachersMaxThreeConsecutiveDays(parent, xmlReader, xmlReadingLog);
				}
				//2022-02-15
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxThreeConsecutiveDays")){
					crt_constraint=readStudentsSetMaxThreeConsecutiveDays(parent, xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxThreeConsecutiveDays")){
					crt_constraint=readStudentsMaxThreeConsecutiveDays(parent, xmlReader, xmlReadingLog);
				}
				//
				else if(xmlReader.name()==QString("ConstraintTeacherMaxHoursDailyInInterval")){
					crt_constraint=readTeacherMaxHoursDailyInInterval(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxHoursDailyInInterval")){
					crt_constraint=readTeachersMaxHoursDailyInInterval(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxHoursDailyInInterval")){
					crt_constraint=readStudentsSetMaxHoursDailyInInterval(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxHoursDailyInInterval")){
					crt_constraint=readStudentsMaxHoursDailyInInterval(xmlReader, xmlReadingLog);
				}
				//
				else if(xmlReader.name()==QString("ConstraintTeacherPairOfMutuallyExclusiveTimeSlots")){
					crt_constraint=readTeacherPairOfMutuallyExclusiveTimeSlots(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersPairOfMutuallyExclusiveTimeSlots")){
					crt_constraint=readTeachersPairOfMutuallyExclusiveTimeSlots(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetPairOfMutuallyExclusiveTimeSlots")){
					crt_constraint=readStudentsSetPairOfMutuallyExclusiveTimeSlots(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsPairOfMutuallyExclusiveTimeSlots")){
					crt_constraint=readStudentsPairOfMutuallyExclusiveTimeSlots(xmlReader, xmlReadingLog);
				}
				//
				else if(xmlReader.name()==QString("ConstraintTeacherPairOfMutuallyExclusiveSetsOfTimeSlots")){
					crt_constraint=readTeacherPairOfMutuallyExclusiveSetsOfTimeSlots(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersPairOfMutuallyExclusiveSetsOfTimeSlots")){
					crt_constraint=readTeachersPairOfMutuallyExclusiveSetsOfTimeSlots(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetPairOfMutuallyExclusiveSetsOfTimeSlots")){
					crt_constraint=readStudentsSetPairOfMutuallyExclusiveSetsOfTimeSlots(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsPairOfMutuallyExclusiveSetsOfTimeSlots")){
					crt_constraint=readStudentsPairOfMutuallyExclusiveSetsOfTimeSlots(xmlReader, xmlReadingLog);
				}
				//
				else if(xmlReader.name()==QString("ConstraintTeacherOccupiesMaxSetsOfTimeSlotsFromSelection")){
					crt_constraint=readTeacherOccupiesMaxSetsOfTimeSlotsFromSelection(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersOccupyMaxSetsOfTimeSlotsFromSelection")){
					crt_constraint=readTeachersOccupyMaxSetsOfTimeSlotsFromSelection(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetOccupiesMaxSetsOfTimeSlotsFromSelection")){
					crt_constraint=readStudentsSetOccupiesMaxSetsOfTimeSlotsFromSelection(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsOccupyMaxSetsOfTimeSlotsFromSelection")){
					crt_constraint=readStudentsOccupyMaxSetsOfTimeSlotsFromSelection(xmlReader, xmlReadingLog);
				}
				//
				else if(xmlReader.name()==QString("ConstraintActivitiesOccupyMaxSetsOfTimeSlotsFromSelection")){
					crt_constraint=readActivitiesOccupyMaxSetsOfTimeSlotsFromSelection(xmlReader, xmlReadingLog);
				}
				//
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}

//corruptConstraintTime:
				//here we skip an invalid constraint or add a valid one
				if(crt_constraint!=nullptr){
					assert(crt_constraint!=nullptr);
					bool tmp=this->addTimeConstraint(crt_constraint);
					if(!tmp){
						if(seeNextWarnNotAddedTimeConstraint){
							int t=RulesReconcilableMessage::warning(parent, tr("FET information"),
							 tr("Constraint\n%1\nnot added - must be a duplicate").
							 arg(crt_constraint->getDetailedDescription(*this)), tr("Skip rest"), tr("See next"), QString(""), 1, 0);
							if(t==0)
								seeNextWarnNotAddedTimeConstraint=false;
						}
						delete crt_constraint;
					}
					else
						nc++;
				}
			}
			xmlReadingLog+="  Added "+CustomFETString::number(nc)+" time constraints\n";
			reducedXmlLog+="Added "+CustomFETString::number(nc)+" time constraints\n";
		}
		else if(xmlReader.name()==QString("Space_Constraints_List")){
			bool reportRoomNotAvailableChange=true;

			bool reportUnspecifiedPermanentlyLockedSpace=true;
			
			bool seeNextWarnNotAddedSpaceConstraint=true;

			bool reportMA5OldSpaceConstraintsChange=true;
			
			int nc=0;
			SpaceConstraint *crt_constraint;
			
			assert(xmlReader.isStartElement());
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				crt_constraint=nullptr;
				if(xmlReader.name()==QString("ConstraintBasicCompulsorySpace")){
					crt_constraint=readBasicCompulsorySpace(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintRoomNotAvailable")){
					if(reportRoomNotAvailableChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						 tr("File contains constraint room not available, which is old (it was improved in FET 5.5.0), and will be converted"
						 " to the similar constraint of this type, constraint room not available times (a matrix)."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportRoomNotAvailableChange=false;
					}
					
					crt_constraint=readRoomNotAvailable(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintRoomNotAvailableTimes")){
					crt_constraint=readRoomNotAvailableTimes(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherRoomNotAvailableTimes")){
					crt_constraint=readTeacherRoomNotAvailableTimes(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintRoomTypeNotAllowedSubjects") && !skipDeprecatedConstraints){
				
					int t=RulesReconcilableMessage::warning(parent, tr("FET warning"),
					 tr("File contains deprecated constraint room type not allowed subjects - will be ignored"),
					 tr("Skip rest"), tr("See next"), QString(),
					 1, 0);
					
					if(t==0)
						skipDeprecatedConstraints=true;
					crt_constraint=nullptr;
					xmlReader.skipCurrentElement();
				}
				else if(xmlReader.name()==QString("ConstraintSubjectRequiresEquipments") && !skipDeprecatedConstraints){
				
					int t=RulesReconcilableMessage::warning(parent, tr("FET warning"),
					 tr("File contains deprecated constraint subject requires equipments - will be ignored"),
					 tr("Skip rest"), tr("See next"), QString(),
					 1, 0);
					
					if(t==0)
						skipDeprecatedConstraints=true;
				
					crt_constraint=nullptr;
					xmlReader.skipCurrentElement();
				}
				else if(xmlReader.name()==QString("ConstraintSubjectSubjectTagRequireEquipments") && !skipDeprecatedConstraints){
				
					int t=RulesReconcilableMessage::warning(parent, tr("FET warning"),
					 tr("File contains deprecated constraint subject tag requires equipments - will be ignored"),
					 tr("Skip rest"), tr("See next"), QString(),
					 1, 0);
					
					if(t==0)
						skipDeprecatedConstraints=true;
					crt_constraint=nullptr;
					xmlReader.skipCurrentElement();
				}
				else if(xmlReader.name()==QString("ConstraintTeacherRequiresRoom") && !skipDeprecatedConstraints){
				
					int t=RulesReconcilableMessage::warning(parent, tr("FET warning"),
					 tr("File contains deprecated constraint teacher requires room - will be ignored"),
					 tr("Skip rest"), tr("See next"), QString(),
					 1, 0);
					
					if(t==0)
						skipDeprecatedConstraints=true;
					crt_constraint=nullptr;
					xmlReader.skipCurrentElement();
				}
				else if(xmlReader.name()==QString("ConstraintTeacherSubjectRequireRoom") && !skipDeprecatedConstraints){
				
					int t=RulesReconcilableMessage::warning(parent, tr("FET warning"),
					 tr("File contains deprecated constraint teacher subject require room - will be ignored"),
					 tr("Skip rest"), tr("See next"), QString(),
					 1, 0);
					
					if(t==0)
						skipDeprecatedConstraints=true;
					crt_constraint=nullptr;
					xmlReader.skipCurrentElement();
				}
				else if(xmlReader.name()==QString("ConstraintMinimizeNumberOfRoomsForStudents") && !skipDeprecatedConstraints){
				
					int t=RulesReconcilableMessage::warning(parent, tr("FET warning"),
					 tr("File contains deprecated constraint minimize number of rooms for students - will be ignored"),
					 tr("Skip rest"), tr("See next"), QString(),
					 1, 0);
					
					if(t==0)
						skipDeprecatedConstraints=true;
					crt_constraint=nullptr;
					xmlReader.skipCurrentElement();
				}
				else if(xmlReader.name()==QString("ConstraintMinimizeNumberOfRoomsForTeachers") && !skipDeprecatedConstraints){
				
					int t=RulesReconcilableMessage::warning(parent, tr("FET warning"),
					 tr("File contains deprecated constraint minimize number of rooms for teachers - will be ignored"),
					 tr("Skip rest"), tr("See next"), QString(),
					 1, 0);
					
					if(t==0)
						skipDeprecatedConstraints=true;
					crt_constraint=nullptr;
					xmlReader.skipCurrentElement();
				}
				else if(xmlReader.name()==QString("ConstraintActivityPreferredRoom")){
					crt_constraint=readActivityPreferredRoom(parent, xmlReader, xmlReadingLog, reportUnspecifiedPermanentlyLockedSpace);
				}
				else if(xmlReader.name()==QString("ConstraintActivityPreferredRooms")){
					crt_constraint=readActivityPreferredRooms(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivitiesSameRoom") && !skipDeprecatedConstraints){
				
					int t=RulesReconcilableMessage::warning(parent, tr("FET warning"),
					 tr("File contains deprecated constraint activities same room - will be ignored"),
					 tr("Skip rest"), tr("See next"), QString(),
					 1, 0);
					
					if(t==0)
						skipDeprecatedConstraints=true;
					crt_constraint=nullptr;
					xmlReader.skipCurrentElement();
				}
				else if(xmlReader.name()==QString("ConstraintSubjectPreferredRoom")){
					crt_constraint=readSubjectPreferredRoom(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintSubjectPreferredRooms")){
					crt_constraint=readSubjectPreferredRooms(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintSubjectSubjectTagPreferredRoom")){
					crt_constraint=readSubjectSubjectTagPreferredRoom(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintSubjectSubjectTagPreferredRooms")){
					crt_constraint=readSubjectSubjectTagPreferredRooms(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintSubjectActivityTagPreferredRoom")){
					crt_constraint=readSubjectActivityTagPreferredRoom(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintSubjectActivityTagPreferredRooms")){
					crt_constraint=readSubjectActivityTagPreferredRooms(xmlReader, xmlReadingLog);
				}
				//added 6 apr 2009
				else if(xmlReader.name()==QString("ConstraintActivityTagPreferredRoom")){
					crt_constraint=readActivityTagPreferredRoom(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintActivityTagPreferredRooms")){
					crt_constraint=readActivityTagPreferredRooms(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetHomeRoom")){
					crt_constraint=readStudentsSetHomeRoom(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetHomeRooms")){
					crt_constraint=readStudentsSetHomeRooms(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherHomeRoom")){
					crt_constraint=readTeacherHomeRoom(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherHomeRooms")){
					crt_constraint=readTeacherHomeRooms(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintMaxBuildingChangesPerDayForTeachers") && !skipDeprecatedConstraints){
				
					int t=RulesReconcilableMessage::warning(parent, tr("FET warning"),
					 tr("File contains deprecated constraint max building changes per day for teachers - will be ignored"),
					 tr("Skip rest"), tr("See next"), QString(),
					 1, 0);
					
					if(t==0)
						skipDeprecatedConstraints=true;
					crt_constraint=nullptr;
					xmlReader.skipCurrentElement();
				}
				else if(xmlReader.name()==QString("ConstraintMaxBuildingChangesPerDayForStudents") && !skipDeprecatedConstraints){
				
					int t=RulesReconcilableMessage::warning(parent, tr("FET warning"),
					 tr("File contains deprecated constraint max building changes per day for students - will be ignored"),
					 tr("Skip rest"), tr("See next"), QString(),
					 1, 0);
					
					if(t==0)
						skipDeprecatedConstraints=true;
					crt_constraint=nullptr;
					xmlReader.skipCurrentElement();
				}
				else if(xmlReader.name()==QString("ConstraintMaxRoomChangesPerDayForTeachers") && !skipDeprecatedConstraints){
				
					int t=RulesReconcilableMessage::warning(parent, tr("FET warning"),
					 tr("File contains deprecated constraint max room changes per day for teachers - will be ignored"),
					 tr("Skip rest"), tr("See next"), QString(),
					 1, 0);
					
					if(t==0)
						skipDeprecatedConstraints=true;
					crt_constraint=nullptr;
					xmlReader.skipCurrentElement();
				}
				else if(xmlReader.name()==QString("ConstraintMaxRoomChangesPerDayForStudents") && !skipDeprecatedConstraints){
				
					int t=RulesReconcilableMessage::warning(parent, tr("FET warning"),
					 tr("File contains deprecated constraint max room changes per day for students - will be ignored"),
					 tr("Skip rest"), tr("See next"), QString(),
					 1, 0);
					
					if(t==0)
						skipDeprecatedConstraints=true;

					crt_constraint=nullptr;
					xmlReader.skipCurrentElement();
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMaxBuildingChangesPerDay")){
					crt_constraint=readTeacherMaxBuildingChangesPerDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxBuildingChangesPerDay")){
					crt_constraint=readTeachersMaxBuildingChangesPerDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMaxBuildingChangesPerWeek")){
					crt_constraint=readTeacherMaxBuildingChangesPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxBuildingChangesPerWeek")){
					crt_constraint=readTeachersMaxBuildingChangesPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMinGapsBetweenBuildingChanges")){
					crt_constraint=readTeacherMinGapsBetweenBuildingChanges(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMinGapsBetweenBuildingChanges")){
					crt_constraint=readTeachersMinGapsBetweenBuildingChanges(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxBuildingChangesPerDay")){
					crt_constraint=readStudentsSetMaxBuildingChangesPerDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxBuildingChangesPerDay")){
					crt_constraint=readStudentsMaxBuildingChangesPerDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxBuildingChangesPerWeek")){
					crt_constraint=readStudentsSetMaxBuildingChangesPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxBuildingChangesPerWeek")){
					crt_constraint=readStudentsMaxBuildingChangesPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMinGapsBetweenBuildingChanges")){
					crt_constraint=readStudentsSetMinGapsBetweenBuildingChanges(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMinGapsBetweenBuildingChanges")){
					crt_constraint=readStudentsMinGapsBetweenBuildingChanges(xmlReader, xmlReadingLog);
				}
				//2019-11-14
				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintTeacherMaxRoomChangesPerDay")){
					crt_constraint=readTeacherMaxRoomChangesPerDay(xmlReader, xmlReadingLog);
				}
				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintTeachersMaxRoomChangesPerDay")){
					crt_constraint=readTeachersMaxRoomChangesPerDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMaxRoomChangesPerWeek")){
					crt_constraint=readTeacherMaxRoomChangesPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxRoomChangesPerWeek")){
					crt_constraint=readTeachersMaxRoomChangesPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMinGapsBetweenRoomChanges")){
					crt_constraint=readTeacherMinGapsBetweenRoomChanges(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMinGapsBetweenRoomChanges")){
					crt_constraint=readTeachersMinGapsBetweenRoomChanges(xmlReader, xmlReadingLog);
				}
				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsSetMaxRoomChangesPerDay")){
					crt_constraint=readStudentsSetMaxRoomChangesPerDay(xmlReader, xmlReadingLog);
				}
				else if((version6AndAbove || (!probably5Morocco && !probably5Algeria && !probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsMaxRoomChangesPerDay")){
					crt_constraint=readStudentsMaxRoomChangesPerDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxRoomChangesPerWeek")){
					crt_constraint=readStudentsSetMaxRoomChangesPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxRoomChangesPerWeek")){
					crt_constraint=readStudentsMaxRoomChangesPerWeek(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMinGapsBetweenRoomChanges")){
					crt_constraint=readStudentsSetMinGapsBetweenRoomChanges(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMinGapsBetweenRoomChanges")){
					crt_constraint=readStudentsMinGapsBetweenRoomChanges(xmlReader, xmlReadingLog);
				}
////////////////2012-04-29
				else if(xmlReader.name()==QString("ConstraintActivitiesOccupyMaxDifferentRooms")){
					crt_constraint=readActivitiesOccupyMaxDifferentRooms(xmlReader, xmlReadingLog);
				}
////////////////
////////////////2013-09-14
				else if(xmlReader.name()==QString("ConstraintActivitiesSameRoomIfConsecutive")){
					crt_constraint=readActivitiesSameRoomIfConsecutive(xmlReader, xmlReadingLog);
				}
////////////////

				//mornings-afternoons
				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintTeacherMaxRoomChangesPerDay")){
					if(reportMA5OldSpaceConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type teacher max room changes per day, which will be converted"
						  " to a constraint of type teacher max room changes per real day."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldSpaceConstraintsChange=false;
					}
					crt_constraint=readOldMATeacherMaxRoomChangesPerDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMaxRoomChangesPerRealDay")){
					crt_constraint=readTeacherMaxRoomChangesPerRealDay(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintTeacherMaxBuildingChangesPerRealDay")){
					crt_constraint=readTeacherMaxBuildingChangesPerRealDay(xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintTeachersMaxRoomChangesPerDay")){
					if(reportMA5OldSpaceConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type teachers max room changes per day, which will be converted"
						  " to a constraint of type teachers max room changes per real day."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldSpaceConstraintsChange=false;
					}
					crt_constraint=readOldMATeachersMaxRoomChangesPerDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxRoomChangesPerRealDay")){
					crt_constraint=readTeachersMaxRoomChangesPerRealDay(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintTeachersMaxBuildingChangesPerRealDay")){
					crt_constraint=readTeachersMaxBuildingChangesPerRealDay(xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsSetMaxRoomChangesPerDay")){
					if(reportMA5OldSpaceConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type students set max room changes per day, which will be converted"
						  " to a constraint of type students set max room changes per real day."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldSpaceConstraintsChange=false;
					}
					crt_constraint=readOldMAStudentsSetMaxRoomChangesPerDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxRoomChangesPerRealDay")){
					crt_constraint=readStudentsSetMaxRoomChangesPerRealDay(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxBuildingChangesPerRealDay")){
					crt_constraint=readStudentsSetMaxBuildingChangesPerRealDay(xmlReader, xmlReadingLog);
				}

				else if((!version6AndAbove && (probably5Morocco || probably5Algeria || probably5MA))
				 && xmlReader.name()==QString("ConstraintStudentsMaxRoomChangesPerDay")){
					if(reportMA5OldSpaceConstraintsChange){
						int t=RulesReconcilableMessage::information(parent, tr("FET information"),
						  tr("Your file was detected as an old FET-5 MA, Morocco, or Algeria file, and"
						  " contains a constraint of type students max room changes per day, which will be converted"
						  " to a constraint of type students max room changes per real day."),
						  tr("Skip rest"), tr("See next"), QString(), 1, 0 );
						if(t==0)
							reportMA5OldSpaceConstraintsChange=false;
					}
					crt_constraint=readOldMAStudentsMaxRoomChangesPerDay(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsMaxRoomChangesPerRealDay")){
					crt_constraint=readStudentsMaxRoomChangesPerRealDay(xmlReader, xmlReadingLog);
				}

				else if(xmlReader.name()==QString("ConstraintStudentsMaxBuildingChangesPerRealDay")){
					crt_constraint=readStudentsMaxBuildingChangesPerRealDay(xmlReader, xmlReadingLog);
				}

				//2024-02-09
				else if(xmlReader.name()==QString("ConstraintStudentsMaxBuildingChangesPerDayInInterval")){
					crt_constraint=readStudentsMaxBuildingChangesPerDayInInterval(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxBuildingChangesPerDayInInterval")){
					crt_constraint=readStudentsSetMaxBuildingChangesPerDayInInterval(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxBuildingChangesPerDayInInterval")){
					crt_constraint=readTeachersMaxBuildingChangesPerDayInInterval(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMaxBuildingChangesPerDayInInterval")){
					crt_constraint=readTeacherMaxBuildingChangesPerDayInInterval(xmlReader, xmlReadingLog);
				}
				////////////
				else if(xmlReader.name()==QString("ConstraintStudentsMaxBuildingChangesPerRealDayInInterval")){
					crt_constraint=readStudentsMaxBuildingChangesPerRealDayInInterval(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxBuildingChangesPerRealDayInInterval")){
					crt_constraint=readStudentsSetMaxBuildingChangesPerRealDayInInterval(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxBuildingChangesPerRealDayInInterval")){
					crt_constraint=readTeachersMaxBuildingChangesPerRealDayInInterval(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMaxBuildingChangesPerRealDayInInterval")){
					crt_constraint=readTeacherMaxBuildingChangesPerRealDayInInterval(xmlReader, xmlReadingLog);
				}

				//2024-02-19
				else if(xmlReader.name()==QString("ConstraintStudentsMaxRoomChangesPerDayInInterval")){
					crt_constraint=readStudentsMaxRoomChangesPerDayInInterval(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxRoomChangesPerDayInInterval")){
					crt_constraint=readStudentsSetMaxRoomChangesPerDayInInterval(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxRoomChangesPerDayInInterval")){
					crt_constraint=readTeachersMaxRoomChangesPerDayInInterval(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMaxRoomChangesPerDayInInterval")){
					crt_constraint=readTeacherMaxRoomChangesPerDayInInterval(xmlReader, xmlReadingLog);
				}
				////////////
				else if(xmlReader.name()==QString("ConstraintStudentsMaxRoomChangesPerRealDayInInterval")){
					crt_constraint=readStudentsMaxRoomChangesPerRealDayInInterval(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintStudentsSetMaxRoomChangesPerRealDayInInterval")){
					crt_constraint=readStudentsSetMaxRoomChangesPerRealDayInInterval(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeachersMaxRoomChangesPerRealDayInInterval")){
					crt_constraint=readTeachersMaxRoomChangesPerRealDayInInterval(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintTeacherMaxRoomChangesPerRealDayInInterval")){
					crt_constraint=readTeacherMaxRoomChangesPerRealDayInInterval(xmlReader, xmlReadingLog);
				}
				////////////
				else if(xmlReader.name()==QString("ConstraintRoomMaxActivityTagsPerDayFromSet")){
					crt_constraint=readRoomMaxActivityTagsPerDayFromSet(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintRoomMaxActivityTagsPerRealDayFromSet")){
					crt_constraint=readRoomMaxActivityTagsPerRealDayFromSet(xmlReader, xmlReadingLog);
				}
				else if(xmlReader.name()==QString("ConstraintRoomMaxActivityTagsPerWeekFromSet")){
					crt_constraint=readRoomMaxActivityTagsPerWeekFromSet(xmlReader, xmlReadingLog);
				}

				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}

//corruptConstraintSpace:
				//here we skip an invalid constraint or add a valid one
				if(crt_constraint!=nullptr){
					assert(crt_constraint!=nullptr);
					
					bool tmp=this->addSpaceConstraint(crt_constraint);
					if(!tmp){
						if(seeNextWarnNotAddedSpaceConstraint){
							int t=RulesReconcilableMessage::warning(parent, tr("FET information"),
							 tr("Constraint\n%1\nnot added - must be a duplicate").
							 arg(crt_constraint->getDetailedDescription(*this)), tr("Skip rest"), tr("See next"), QString(""), 1, 0);
							if(t==0)
								seeNextWarnNotAddedSpaceConstraint=false;
						}
						delete crt_constraint;
					}
					else
						nc++;
				}
			}
			xmlReadingLog+="  Added "+CustomFETString::number(nc)+" space constraints\n";
			reducedXmlLog+="Added "+CustomFETString::number(nc)+" space constraints\n";
		}
		else if(xmlReader.name()==QString("Timetable_Generation_Options_List")){
			int tgol=0;
			assert(xmlReader.isStartElement());
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";
				
				if(xmlReader.name()==QString("GroupActivitiesInInitialOrder")){
					tgol++;
					GroupActivitiesInInitialOrderItem* item=new GroupActivitiesInInitialOrderItem();
					int nActs=-1;
					assert(xmlReader.isStartElement());
					while(xmlReader.readNextStartElement()){
						xmlReadingLog+="   Found "+xmlReader.name().toString()+" tag\n";

						if(xmlReader.name()==QString("Number_of_Activities")){
							QString text=xmlReader.readElementText();
							nActs=text.toInt();
							xmlReadingLog+="    Read n_activities="+CustomFETString::number(nActs)+"\n";
						}
						else if(xmlReader.name()==QString("Activity_Id")){
							QString text=xmlReader.readElementText();
							int id=text.toInt();
							xmlReadingLog+="    Activity id="+CustomFETString::number(id)+"\n";
							item->ids.append(id);
						}
						else if(xmlReader.name()==QString("Active")){
							QString text=xmlReader.readElementText();
							if(text=="false"){
								item->active=false;
							}
						}
						else if(xmlReader.name()==QString("Comments")){
							QString text=xmlReader.readElementText();
							item->comments=text;
						}
						else{
							unrecognizedXmlTags.append(xmlReader.name().toString());
							unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
							unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

							xmlReader.skipCurrentElement();
							xmlReaderNumberOfUnrecognizedFields++;
						}
					}
					if(!(nActs==item->ids.count())){
						xmlReader.raiseError(tr("%1 does not coincide with the number of %2 which were read").arg("Number_of_Activities").arg("Activity_Id"));
						delete item;
					}
					else{
						assert(nActs==item->ids.count());
						item->recomputeActivitiesSet();
						groupActivitiesInInitialOrderList.append(item);
					}
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			xmlReadingLog+="  Added "+CustomFETString::number(tgol)+" timetable generation options\n";
			reducedXmlLog+="Added "+CustomFETString::number(tgol)+" timetable generation options\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	
	if(xmlReader.error()){
		RulesIrreconcilableMessage::warning(parent, tr("FET warning"),
		 tr("Could not read file - XML parse error at line %1, column %2:\n%3", "The error description is %3")
		 .arg(xmlReader.lineNumber())
		 .arg(xmlReader.columnNumber())
		 .arg(xmlReader.errorString()));
	
		file.close();
		//this->mode=oldMode;

		if(canWriteLogFile){
			xmlReadingLog+="  Incorrect/incomplete FET XML data file.\n";

			reducedXmlLog+="\n";
			reducedXmlLog+="Incorrect/incomplete FET XML data file.\n";
			logStream<<reducedXmlLog;

			file2.close();
		}

		return false;
	}
	file.close();
	
	if(unrecognizedXmlTags.count()>0){
		QString s;
		if(unrecognizedXmlTags.count()>=2){
			s+=tr("There are %1 unrecognized XML tags in your input file. They are written below. Your file will be opened, but"
			 " these tags will be ignored and they probably represent mistakes in your input file:", "You can assume that %1 is at least 2")
			 .arg(unrecognizedXmlTags.count());
		}
		else{
			assert(unrecognizedXmlTags.count()==1);
			s+=tr("There is an unrecognized XML tag in your input file. It is written below. Your file will be opened, but"
			 " this tag will be ignored and it probably represents a mistake in your input file:");
		}
		s+="\n\n";
		
		for(int i=0; i<unrecognizedXmlTags.count(); i++){
			s+=tr("Line %1, column %2: %3", "%3 is the unrecognized XML tag which is met in the .fet input file in line %1, column %2")
			 .arg(unrecognizedXmlLineNumbers.at(i)).arg(unrecognizedXmlColumnNumbers.at(i)).arg(unrecognizedXmlTags.at(i));
			s+="\n";
		}
		s.chop(1);
		
		RulesReconcilableMessage::warning(parent, tr("FET information"), s);
	}
	
	if(this->mode==MORNINGS_AFTERNOONS){
		if(this->nRealDaysPerWeek==-1 || this->nRealDaysPerWeek!=this->nDaysPerWeek/2){
			this->nRealDaysPerWeek=this->nDaysPerWeek/2;
			this->realDaysOfTheWeek.clear();
			this->realDaysOfTheWeek_longNames.clear();
			for(int rd=0; rd<this->nRealDaysPerWeek; rd++){
				this->realDaysOfTheWeek.append(this->daysOfTheWeek.at(2*rd));
				this->realDaysOfTheWeek_longNames.append(QString(""));
			}
		}
		
		if(this->nRealHoursPerDay==-1 || this->nRealHoursPerDay!=2*this->nHoursPerDay){
			this->nRealHoursPerDay=2*this->nHoursPerDay;
			this->realHoursOfTheDay.clear();
			this->realHoursOfTheDay_longNames.clear();
			for(int h=0; h<this->nHoursPerDay; h++){
				this->realHoursOfTheDay.append(this->hoursOfTheDay.at(h)+QString(" ")+tr("AM", "Ante Meridiem, before noon"));
				this->realHoursOfTheDay_longNames.append(QString(""));
			}
			for(int h=0; h<this->nHoursPerDay; h++){
				this->realHoursOfTheDay.append(this->hoursOfTheDay.at(h)+QString(" ")+tr("PM", "Post Meridiem, afternoon"));
				this->realHoursOfTheDay_longNames.append(QString(""));
			}
		}
	}

	this->internalStructureComputed=false;
	
	/*reducedXmlLog+="\n";
	reducedXmlLog+="Note: if you have overlapping students sets (years or groups), a group or a subgroup may be counted more than once. "
		"A unique group name is counted once for each year it belongs to and a unique subgroup name is counted once for each year+group it belongs to.\n";*/

	if(xmlReaderNumberOfUnrecognizedFields>0){
		xmlReadingLog+="  Warning: There were "+CustomFETString::number(xmlReaderNumberOfUnrecognizedFields)+" unrecognized fields in the input file\n";

		reducedXmlLog+="\n";
		reducedXmlLog+="Warning: There were "+CustomFETString::number(xmlReaderNumberOfUnrecognizedFields)+" unrecognized fields in the input file\n";
	}

	if(canWriteLogFile){
		//logStream<<xmlReadingLog;
		logStream<<reducedXmlLog;
	}

	if(file2.error()!=QFileDevice::NoError){
		IrreconcilableCriticalMessage::critical(parent, tr("FET critical"),
		 tr("Saving the logging file gave the error message '%1', which means you cannot see the data file reading log. Please check your disk's free space.",
		 "It means you cannot see the log of the operation of reading the data file.")
		 .arg(file2.errorString()));
	}

	if(canWriteLogFile)
		file2.close();

	////////////////////////////////////////

	return true;
}

bool Rules::write(QWidget* parent, const QString& filename)
{
	assert(this->initialized);

	//QString s;
	
	/*bool exists=false;
	QString filenameTmp=filename;
	if(QFile::exists(filenameTmp)){
		exists=true;

		filenameTmp.append(QString(".tmp"));
		
		if(QFile::exists(filenameTmp)){
			int i=1;
			for(;;){
				QString t2=filenameTmp+CustomFETString::number(i);
				if(!QFile::exists(t2)){
					filenameTmp=t2;
					break;
				}
				i++;
			}
		}
	}

	assert(!QFile::exists(filenameTmp));

	QFile file(filenameTmp);*/
	
	QSaveFile file(filename);
	
#if QT_VERSION >= QT_VERSION_CHECK(6,0,0)
	if(!file.open(QIODeviceBase::WriteOnly | QIODeviceBase::Truncate)){
#else
	if(!file.open(QIODevice::WriteOnly | QIODevice::Truncate)){
#endif
		IrreconcilableCriticalMessage::critical(parent, tr("FET critical"),
		 tr("Cannot open %1 for writing ... please check the write permissions of the selected directory and your disk's free space. Saving of the data file aborted.").arg(QFileInfo(filename).fileName()));
		
		return false;
	}

	QTextStream tos(&file);
	
#if QT_VERSION >= QT_VERSION_CHECK(6,0,0)
	tos.setEncoding(QStringConverter::Utf8);
#else
	tos.setCodec("UTF-8");
#endif
	tos.setGenerateByteOrderMark(true);
	//tos.setEncoding(QTextStream::UnicodeUTF8);
	
	tos<<"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";

//	tos<<"<!DOCTYPE FET><FET version=\""+FET_VERSION+"\">\n\n";
	tos<<"<fet version=\""+FET_VERSION+"\">\n";
	
	QString ms;
	if(this->mode==OFFICIAL)
		ms="Official";
	else if(this->mode==MORNINGS_AFTERNOONS)
		ms="Mornings_Afternoons";
	else if(this->mode==BLOCK_PLANNING)
		ms="Block_Planning";
	else if(this->mode==TERMS)
		ms="Terms";
	else
		assert(0);
	tos<<IL1+"<Mode>"+ms+"</Mode>\n";
	
	//the institution name and the comments
	tos<<IL1+"<Institution_Name>"+protect(this->institutionName)+"</Institution_Name>\n";
	tos<<IL1+"<Comments>"+protect(this->comments)+"</Comments>\n";

	//for terms (Finland)
	if(this->mode==TERMS){
		tos<<IL1+"<Number_of_Terms>"+CustomFETString::number(this->nTerms)+"</Number_of_Terms>\n";
		tos<<IL1+"<Number_of_Days_Per_Term>"+CustomFETString::number(this->nDaysPerTerm)+"</Number_of_Days_Per_Term>\n";
	}

	//the days and the hours
	tos<<IL1+"<Days_List>\n"+IL2+"<Number_of_Days>"+CustomFETString::number(this->nDaysPerWeek)+"</Number_of_Days>\n";
	for(int i=0; i<this->nDaysPerWeek; i++){
		tos<<IL2+"<Day>\n";
		tos<<IL3+"<Name>"+protect(this->daysOfTheWeek[i])+"</Name>\n";
		tos<<IL3+"<Long_Name>"+protect(this->daysOfTheWeek_longNames[i])+"</Long_Name>\n";
		tos<<IL2+"</Day>\n";
	}
	tos<<IL1+"</Days_List>\n";

	//the real days, for the Mornings-Afternoons mode
	if(this->mode==MORNINGS_AFTERNOONS){
		tos<<IL1+"<Real_Days_List>\n"+IL2+"<Number_of_Real_Days>"+CustomFETString::number(this->nRealDaysPerWeek)+"</Number_of_Real_Days>\n";
		for(int i=0; i<this->nRealDaysPerWeek; i++){
			tos<<IL2+"<Real_Day>\n";
			tos<<IL3+"<Name>"+protect(this->realDaysOfTheWeek[i])+"</Name>\n";
			tos<<IL3+"<Long_Name>"+protect(this->realDaysOfTheWeek_longNames[i])+"</Long_Name>\n";
			tos<<IL2+"</Real_Day>\n";
		}
		tos<<IL1+"</Real_Days_List>\n";
	}
	
	tos<<IL1+"<Hours_List>\n"+IL2+"<Number_of_Hours>"+CustomFETString::number(this->nHoursPerDay)+"</Number_of_Hours>\n";
	for(int i=0; i<this->nHoursPerDay; i++){
		tos<<IL2+"<Hour>\n";
		tos<<IL3+"<Name>"+protect(this->hoursOfTheDay[i])+"</Name>\n";
		tos<<IL3+"<Long_Name>"+protect(this->hoursOfTheDay_longNames[i])+"</Long_Name>\n";
		tos<<IL2+"</Hour>\n";
	}
	tos<<IL1+"</Hours_List>\n";

	//the real hours, for the Mornings-Afternoons mode
	if(this->mode==MORNINGS_AFTERNOONS){
		tos<<IL1+"<Real_Hours_List>\n"+IL2+"<Number_of_Real_Hours>"+CustomFETString::number(this->nRealHoursPerDay)+"</Number_of_Real_Hours>\n";
		for(int i=0; i<this->nRealHoursPerDay; i++){
			tos<<IL2+"<Real_Hour>\n";
			tos<<IL3+"<Name>"+protect(this->realHoursOfTheDay[i])+"</Name>\n";
			tos<<IL3+"<Long_Name>"+protect(this->realHoursOfTheDay_longNames[i])+"</Long_Name>\n";
			tos<<IL2+"</Real_Hour>\n";
		}
		tos<<IL1+"</Real_Hours_List>\n";
	}

	//subjects list - should be before teachers list, because each teacher has a list of associated qualified subjects
	tos << IL1+"<Subjects_List>\n";
	for(int i=0; i<this->subjectsList.size(); i++){
		Subject* sbj=this->subjectsList[i];
		tos << sbj->getXmlDescription();
	}
	tos << IL1+"</Subjects_List>\n";

	//activity tags list
	tos << IL1+"<Activity_Tags_List>\n";
	for(int i=0; i<this->activityTagsList.size(); i++){
		ActivityTag* stg=this->activityTagsList[i];
		tos << stg->getXmlDescription();
	}
	tos << IL1+"</Activity_Tags_List>\n";

	//teachers list
	tos << IL1+"<Teachers_List>\n";
	for(int i=0; i<this->teachersList.size(); i++){
		Teacher* tch=this->teachersList[i];
		tos << tch->getXmlDescription(*this);
	}
	tos << IL1+"</Teachers_List>\n";

	//students list
	tos<<IL1+"<Students_List>\n";
	for(int i=0; i<this->yearsList.size(); i++){
		StudentsYear* sty=this->yearsList[i];
		tos << sty->getXmlDescription();
	}
	tos<<IL1+"</Students_List>\n";

	//activities list
	tos << IL1+"<Activities_List>\n";
	for(int i=0; i<this->activitiesList.size(); i++){
		Activity* act=this->activitiesList[i];
		tos << act->getXmlDescription(*this);
		tos << "\n";
	}
	tos << IL1+"</Activities_List>\n";

	//buildings list
	tos << IL1+"<Buildings_List>\n";
	for(int i=0; i<this->buildingsList.size(); i++){
		Building* bu=this->buildingsList[i];
		tos << bu->getXmlDescription();
	}
	tos << IL1+"</Buildings_List>\n";

	//rooms list
	tos << IL1+"<Rooms_List>\n";
	for(int i=0; i<this->roomsList.size(); i++){
		Room* rm=this->roomsList[i];
		tos << rm->getXmlDescription();
	}
	tos << IL1+"</Rooms_List>\n";

	//time constraints list
	tos << IL1+"<Time_Constraints_List>\n";
	for(int i=0; i<this->timeConstraintsList.size(); i++){
		TimeConstraint* ctr=this->timeConstraintsList[i];
		tos << ctr->getXmlDescription(*this);
	}
	tos << IL1+"</Time_Constraints_List>\n";

	//constraints list
	tos << IL1+"<Space_Constraints_List>\n";
	for(int i=0; i<this->spaceConstraintsList.size(); i++){
		SpaceConstraint* ctr=this->spaceConstraintsList[i];
		tos << ctr->getXmlDescription(*this);
	}
	tos << IL1+"</Space_Constraints_List>\n";
	
	if(true || groupActivitiesInInitialOrderList.count()>0){
		tos << IL1+"<Timetable_Generation_Options_List>\n";
		for(int i=0; i<groupActivitiesInInitialOrderList.count(); i++){
			GroupActivitiesInInitialOrderItem* item=groupActivitiesInInitialOrderList[i];
			tos << item->getXmlDescription(*this);
		}
		tos << IL1+"</Timetable_Generation_Options_List>\n";
	}

//	tos<<"</FET>\n";
	tos<<"</fet>\n";

	//tos<<s;
	
	if(file.error()!=QFileDevice::NoError){
		IrreconcilableCriticalMessage::critical(parent, tr("FET critical"),
		 tr("Saving the data file gave the error message '%1', which means the saving is compromised. Please check your disk's free space.")
		 .arg(file.errorString()));
		
		//file.close();
		//return false;
	}
	
	/*if(exists){
		bool tf=QFile::remove(filename);
		assert(tf);
		tf=QFile::rename(filenameTmp, filename);
		assert(tf);
	}*/
	
	bool res=file.commit();
	return res;
}

int Rules::activateTeacher(const QString& teacherName)
{
	int count=0;
	for(int i=0; i<this->activitiesList.size(); i++){
		Activity* act=this->activitiesList[i];
		if(act->searchTeacher(teacherName)){
			if(!act->active)
				count++;
			act->active=true;
		}
	}

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
	
	return count;
}

int Rules::activateStudents(const QString& studentsName)
{
	QSet<QString> allSets;
	
	StudentsSet* studentsSet=this->searchStudentsSet(studentsName);
	assert(studentsSet!=nullptr);
	if(studentsSet->type==STUDENTS_SUBGROUP)
		allSets.insert(studentsName);
	else if(studentsSet->type==STUDENTS_GROUP){
		allSets.insert(studentsName);
		StudentsGroup* g=(StudentsGroup*)studentsSet;
		for(StudentsSubgroup* s : std::as_const(g->subgroupsList))
			allSets.insert(s->name);
	}
	else if(studentsSet->type==STUDENTS_YEAR){
		allSets.insert(studentsName);
		StudentsYear* y=(StudentsYear*)studentsSet;
		for(StudentsGroup* g : std::as_const(y->groupsList)){
			allSets.insert(g->name);
			for(StudentsSubgroup* s : std::as_const(g->subgroupsList))
				allSets.insert(s->name);
		}
	}

	int count=0;
	for(int i=0; i<this->activitiesList.size(); i++){
		Activity* act=this->activitiesList[i];
		if(!act->active){
			for(const QString& studentsSetName : std::as_const(act->studentsNames)){
				if(allSets.contains(studentsSetName)){
					count++;
					act->active=true;
					break;
				}
			}
		}
	}

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
	
	return count;
}

int Rules::activateSubject(const QString& subjectName)
{
	int count=0;
	for(int i=0; i<this->activitiesList.size(); i++){
		Activity* act=this->activitiesList[i];
		if(act->subjectName==subjectName){
			if(!act->active)
				count++;
			act->active=true;
		}
	}

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
	
	return count;
}

int Rules::activateActivityTag(const QString& activityTagName)
{
	int count=0;
	for(int i=0; i<this->activitiesList.size(); i++){
		Activity* act=this->activitiesList[i];
		if(act->activityTagsNames.contains(activityTagName)){
			if(!act->active)
				count++;
			act->active=true;
		}
	}
	
	if(count==0)
		return count;

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
	
	return count;
}

int Rules::deactivateTeacher(const QString& teacherName)
{
	int count=0;
	for(int i=0; i<this->activitiesList.size(); i++){
		Activity* act=this->activitiesList[i];
		if(act->searchTeacher(teacherName)){
			if(act->active)
				count++;
			act->active=false;
		}
	}

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
	
	return count;
}

int Rules::deactivateStudents(const QString& studentsName)
{
	QSet<QString> allSets;
	
	StudentsSet* studentsSet=this->searchStudentsSet(studentsName);
	assert(studentsSet!=nullptr);
	if(studentsSet->type==STUDENTS_SUBGROUP)
		allSets.insert(studentsName);
	else if(studentsSet->type==STUDENTS_GROUP){
		allSets.insert(studentsName);
		StudentsGroup* g=(StudentsGroup*)studentsSet;
		for(StudentsSubgroup* s : std::as_const(g->subgroupsList))
			allSets.insert(s->name);
	}
	else if(studentsSet->type==STUDENTS_YEAR){
		allSets.insert(studentsName);
		StudentsYear* y=(StudentsYear*)studentsSet;
		for(StudentsGroup* g : std::as_const(y->groupsList)){
			allSets.insert(g->name);
			for(StudentsSubgroup* s : std::as_const(g->subgroupsList))
				allSets.insert(s->name);
		}
	}

	int count=0;
	for(int i=0; i<this->activitiesList.size(); i++){
		Activity* act=this->activitiesList[i];
		if(act->active){
			for(const QString& studentsSetName : std::as_const(act->studentsNames)){
				if(allSets.contains(studentsSetName)){
					count++;
					act->active=false;
					break;
				}
			}
		}
	}

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
	
	return count;
}

int Rules::deactivateSubject(const QString& subjectName)
{
	int count=0;
	for(int i=0; i<this->activitiesList.size(); i++){
		Activity* act=this->activitiesList[i];
		if(act->subjectName==subjectName){
			if(act->active)
				count++;
			act->active=false;
		}
	}

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
	
	return count;
}

int Rules::deactivateActivityTag(const QString& activityTagName)
{
	int count=0;
	for(int i=0; i<this->activitiesList.size(); i++){
		Activity* act=this->activitiesList[i];
		if(act->activityTagsNames.contains(activityTagName)){
			if(act->active)
				count++;
			act->active=false;
		}
	}
	
	if(count==0)
		return count;

	this->internalStructureComputed=false;
	setRulesModifiedAndOtherThings(this);

	teachers_schedule_ready=false;
	students_schedule_ready=false;
	rooms_buildings_schedule_ready=false;
	
	return count;
}

bool Rules::makeActivityTagPrintable(const QString& activityTagName)
{
	int i=searchActivityTag(activityTagName);
	assert(i>=0 && i<activityTagsList.count());
	
	ActivityTag* at=activityTagsList[i];
	
	if(at->printable==false){
		at->printable=true;

		this->internalStructureComputed=false;
		setRulesModifiedAndOtherThings(this);

		teachers_schedule_ready=false;
		students_schedule_ready=false;
		rooms_buildings_schedule_ready=false;
		
		return true;
	}
	
	return false;
}

bool Rules::makeActivityTagNotPrintable(const QString& activityTagName)
{
	int i=searchActivityTag(activityTagName);
	assert(i>=0 && i<activityTagsList.count());
	
	ActivityTag* at=activityTagsList[i];
	
	if(at->printable==true){
		at->printable=false;

		this->internalStructureComputed=false;
		setRulesModifiedAndOtherThings(this);

		teachers_schedule_ready=false;
		students_schedule_ready=false;
		rooms_buildings_schedule_ready=false;
		
		return true;
	}
	
	return false;
}

TimeConstraint* Rules::readBasicCompulsoryTime(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintBasicCompulsoryTime"));
	ConstraintBasicCompulsoryTime* cn=new ConstraintBasicCompulsoryTime();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - generating automatic 100% weight percentage\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTeacherNotAvailable(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeacherNotAvailable"));

	QList<int> days;
	QList<int> hours;
	QString teacher;
	double weightPercentage=100;
	int d=-1, h1=-1, h2=-1;
	bool active=true;
	QString comments="";
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			weightPercentage=customFETStrToDouble(text);
			if(weightPercentage<0){
				xmlReader.raiseError(tr("Weight percentage incorrect"));
				return nullptr;
			}
			assert(weightPercentage>=0);
			xmlReadingLog+="    Read weight percentage="+CustomFETString::number(weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			comments=text;
		}
		else if(xmlReader.name()==QString("Day")){
			QString text=xmlReader.readElementText();
			for(d=0; d<this->nDaysPerWeek; d++)
				if(this->daysOfTheWeek[d]==text)
					break;
			if(d>=this->nDaysPerWeek){
				xmlReader.raiseError(tr("Day %1 is nonexistent").arg(text));
				/*RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint TeacherNotAvailable day corrupt for teacher %1, day %2 is nonexistent ... ignoring constraint")
					.arg(teacher)
					.arg(text));*/
				//cn=nullptr;
				
				return nullptr;
				//goto corruptConstraintTime;
			}
			assert(d<this->nDaysPerWeek);
			xmlReadingLog+="    Crt. day="+this->daysOfTheWeek[d]+"\n";
		}
		else if(xmlReader.name()==QString("Start_Hour")){
			QString text=xmlReader.readElementText();
			for(h1=0; h1 < this->nHoursPerDay; h1++)
				if(this->hoursOfTheDay[h1]==text)
					break;
			if(h1==this->nHoursPerDay){
				xmlReader.raiseError(tr("Hour %1 is the last hour - impossible").arg(text));
				return nullptr;
			}
			else if(h1>this->nHoursPerDay){
				xmlReader.raiseError(tr("Hour %1 is nonexistent").arg(text));
				/*RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint TeacherNotAvailable start hour corrupt for teacher %1, hour %2 is nonexistent ... ignoring constraint")
					.arg(teacher)
					.arg(text));*/
				//cn=nullptr;
				
				return nullptr;
				//goto corruptConstraintTime;
			}
			assert(h1>=0 && h1 < this->nHoursPerDay);
			xmlReadingLog+="    Start hour="+this->hoursOfTheDay[h1]+"\n";
		}
		else if(xmlReader.name()==QString("End_Hour")){
			QString text=xmlReader.readElementText();
			for(h2=0; h2 < this->nHoursPerDay; h2++)
				if(this->hoursOfTheDay[h2]==text)
					break;
			if(h2==0){
				xmlReader.raiseError(tr("Hour %1 is the first hour - impossible").arg(text));
				return nullptr;
			}
			else if(h2>this->nHoursPerDay){
				xmlReader.raiseError(tr("Hour %1 is nonexistent").arg(text));
				return nullptr;
			}
			/*if(h2<=0 || h2>this->nHoursPerDay){
				RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint TeacherNotAvailable end hour corrupt for teacher %1, hour %2 is nonexistent ... ignoring constraint")
					.arg(teacher)
					.arg(text));
					
				return nullptr;
				//goto corruptConstraintTime;
			}*/
			assert(h2>0 && h2 <= this->nHoursPerDay);
			xmlReadingLog+="    End hour="+this->hoursOfTheDay[h2]+"\n";
		}
		else if(xmlReader.name()==QString("Teacher_Name")){
			QString text=xmlReader.readElementText();
			teacher=text;
			xmlReadingLog+="    Read teacher name="+teacher+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			teacher=text;
			xmlReadingLog+="    Read teacher name="+teacher+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	
	assert(weightPercentage>=0);
	if(d<0){
		xmlReader.raiseError(tr("Field missing: %1").arg("Day"));
		return nullptr;
	}
	else if(h1<0){
		xmlReader.raiseError(tr("Field missing: %1").arg("Start_Hour"));
		return nullptr;
	}
	else if(h2<0){
		xmlReader.raiseError(tr("Field missing: %1").arg("End_Hour"));
		return nullptr;
	}
	assert(d>=0 && h1>=0 && h2>=0);
	
	ConstraintTeacherNotAvailableTimes* cn = nullptr;
	
	bool found=false;
	for(TimeConstraint* c : std::as_const(this->timeConstraintsList))
		if(c->type==CONSTRAINT_TEACHER_NOT_AVAILABLE_TIMES){
			ConstraintTeacherNotAvailableTimes* tna=(ConstraintTeacherNotAvailableTimes*) c;
			if(tna->teacher==teacher){
				found=true;
				
				for(int hh=h1; hh<h2; hh++){
					int k;
					for(k=0; k<tna->days.count(); k++)
						if(tna->days.at(k)==d && tna->hours.at(k)==hh)
							break;
					if(k==tna->days.count()){
						tna->days.append(d);
						tna->hours.append(hh);
					}
				}
				
				assert(tna->days.count()==tna->hours.count());
			}
		}
	if(!found){
		days.clear();
		hours.clear();
		for(int hh=h1; hh<h2; hh++){
			days.append(d);
			hours.append(hh);
		}
	
		cn=new ConstraintTeacherNotAvailableTimes(weightPercentage, teacher, days, hours);
		cn->active=active;
		cn->comments=comments;

		return cn;
	}
	else
		return nullptr;
}

TimeConstraint* Rules::readTeacherNotAvailableTimes(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeacherNotAvailableTimes"));
	
	ConstraintTeacherNotAvailableTimes* cn=new ConstraintTeacherNotAvailableTimes();
	int nNotAvailableSlots=-1;
	int i=0;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Read weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}

		else if(xmlReader.name()==QString("Number_of_Not_Available_Times")){
			QString text=xmlReader.readElementText();
			nNotAvailableSlots=text.toInt();
			xmlReadingLog+="    Read number of not available times="+CustomFETString::number(nNotAvailableSlots)+"\n";
		}

		else if(xmlReader.name()==QString("Not_Available_Time")){
			xmlReadingLog+="    Read: not available time\n";
			
			int d=-1;
			int h=-1;

			assert(xmlReader.isStartElement());
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
				if(xmlReader.name()==QString("Day")){
					QString text=xmlReader.readElementText();
					for(d=0; d<this->nDaysPerWeek; d++)
						if(this->daysOfTheWeek[d]==text)
							break;

					if(d>=this->nDaysPerWeek){
						xmlReader.raiseError(tr("Day %1 is nonexistent").arg(text));
						/*RulesReconcilableMessage::information(parent, tr("FET information"),
							tr("Constraint TeacherNotAvailableTimes day corrupt for teacher %1, day %2 is nonexistent ... ignoring constraint")
							.arg(cn->teacher)
							.arg(text));*/
						delete cn;
						cn=nullptr;
						//goto corruptConstraintTime;
						return nullptr;
					}
		
					assert(d<this->nDaysPerWeek);
					xmlReadingLog+="    Day="+this->daysOfTheWeek[d]+"("+CustomFETString::number(i)+")"+"\n";
				}
				else if(xmlReader.name()==QString("Hour")){
					QString text=xmlReader.readElementText();
					for(h=0; h < this->nHoursPerDay; h++)
						if(this->hoursOfTheDay[h]==text)
							break;
					
					if(h>=this->nHoursPerDay){
						xmlReader.raiseError(tr("Hour %1 is nonexistent").arg(text));
						/*RulesReconcilableMessage::information(parent, tr("FET information"),
							tr("Constraint TeacherNotAvailableTimes hour corrupt for teacher %1, hour %2 is nonexistent ... ignoring constraint")
							.arg(cn->teacher)
							.arg(text));*/
						delete cn;
						cn=nullptr;
						//goto corruptConstraintTime;
						return nullptr;
					}
					
					assert(h>=0 && h < this->nHoursPerDay);
					xmlReadingLog+="    Hour="+this->hoursOfTheDay[h]+"\n";
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			i++;
			
			cn->days.append(d);
			cn->hours.append(h);

			if(d==-1 || h==-1){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Not_Available_Time"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacher=text;
			xmlReadingLog+="    Read teacher name="+cn->teacher+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	assert(i==cn->days.count() && i==cn->hours.count());
	if(!(i==nNotAvailableSlots)){
		xmlReader.raiseError(tr("%1 does not coincide with the number of %2 which were read").arg("Number_of_Not_Available_Times").arg("Not_Available_Time"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(i==nNotAvailableSlots);

	return cn;
}

TimeConstraint* Rules::readTeacherMaxDaysPerWeek(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeacherMaxDaysPerWeek"));
	
	ConstraintTeacherMaxDaysPerWeek* cn=new ConstraintTeacherMaxDaysPerWeek();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - generating 100% weight percentage\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Teacher_Name")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Max_Days_Per_Week")){
			QString text=xmlReader.readElementText();
			cn->maxDaysPerWeek=text.toInt();
			if(cn->maxDaysPerWeek<=0 || cn->maxDaysPerWeek>this->nDaysPerWeek){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Max_Days_Per_Week"));
				/*RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint TeacherMaxDaysPerWeek max days corrupt for teacher %1, max days %2 <= 0 or >nDaysPerWeek, ignoring constraint")
					.arg(cn->teacherName)
					.arg(text));*/
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			assert(cn->maxDaysPerWeek>0 && cn->maxDaysPerWeek <= this->nDaysPerWeek);
			xmlReadingLog+="    Max. days per week="+CustomFETString::number(cn->maxDaysPerWeek)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTeachersMaxDaysPerWeek(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeachersMaxDaysPerWeek"));
	
	ConstraintTeachersMaxDaysPerWeek* cn=new ConstraintTeachersMaxDaysPerWeek();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Max_Days_Per_Week")){
			QString text=xmlReader.readElementText();
			cn->maxDaysPerWeek=text.toInt();
			if(cn->maxDaysPerWeek<=0 || cn->maxDaysPerWeek>this->nDaysPerWeek){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Max_Days_Per_Week"));
				/*RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint TeachersMaxDaysPerWeek max days corrupt, max days %1 <= 0 or >nDaysPerWeek, ignoring constraint")
					.arg(text));*/
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			assert(cn->maxDaysPerWeek>0 && cn->maxDaysPerWeek <= this->nDaysPerWeek);
			xmlReadingLog+="    Max. days per week="+CustomFETString::number(cn->maxDaysPerWeek)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTeacherMinDaysPerWeek(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeacherMinDaysPerWeek"));
	
	ConstraintTeacherMinDaysPerWeek* cn=new ConstraintTeacherMinDaysPerWeek();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Teacher_Name")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Minimum_Days_Per_Week")){
			QString text=xmlReader.readElementText();
			cn->minDaysPerWeek=text.toInt();
			if(cn->minDaysPerWeek<=0 || cn->minDaysPerWeek>this->nDaysPerWeek){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Minimum_Days_Per_Week"));
				/*RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint TeacherMinDaysPerWeek min days corrupt for teacher %1, min days %2 <= 0 or >nDaysPerWeek, ignoring constraint")
					.arg(cn->teacherName)
					.arg(text));*/
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			assert(cn->minDaysPerWeek>0 && cn->minDaysPerWeek <= this->nDaysPerWeek);
			xmlReadingLog+="    Min. days per week="+CustomFETString::number(cn->minDaysPerWeek)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTeachersMinDaysPerWeek(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeachersMinDaysPerWeek"));
	
	ConstraintTeachersMinDaysPerWeek* cn=new ConstraintTeachersMinDaysPerWeek();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Minimum_Days_Per_Week")){
			QString text=xmlReader.readElementText();
			cn->minDaysPerWeek=text.toInt();
			if(cn->minDaysPerWeek<=0 || cn->minDaysPerWeek>this->nDaysPerWeek){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Minimum_Days_Per_Week"));
				/*RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint TeachersMinDaysPerWeek min days corrupt, min days %1 <= 0 or >nDaysPerWeek, ignoring constraint")
					.arg(text));*/
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			assert(cn->minDaysPerWeek>0 && cn->minDaysPerWeek <= this->nDaysPerWeek);
			xmlReadingLog+="    Min. days per week="+CustomFETString::number(cn->minDaysPerWeek)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTeacherIntervalMaxDaysPerWeek(QWidget* parent, QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeacherIntervalMaxDaysPerWeek"));
	ConstraintTeacherIntervalMaxDaysPerWeek* cn=new ConstraintTeacherIntervalMaxDaysPerWeek();
	cn->maxDaysPerWeek=this->nDaysPerWeek;
	cn->startHour=this->nHoursPerDay;
	cn->endHour=this->nHoursPerDay;
	int h1, h2;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - generating 100% weight percentage\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Teacher_Name")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Max_Days_Per_Week")){
			QString text=xmlReader.readElementText();
			cn->maxDaysPerWeek=text.toInt();
			if(cn->maxDaysPerWeek>this->nDaysPerWeek){
				RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint TeacherIntervalMaxDaysPerWeek max days corrupt for teacher %1, max days %2 >nDaysPerWeek, constraint added, please correct constraint")
					.arg(cn->teacherName)
					.arg(text));
				/*delete cn;
				cn=nullptr;
				goto corruptConstraintTime;*/
			}
			//assert(cn->maxDaysPerWeek>0 && cn->maxDaysPerWeek <= this->nDaysPerWeek);
			xmlReadingLog+="    Max. days per week="+CustomFETString::number(cn->maxDaysPerWeek)+"\n";
		}
		else if(xmlReader.name()==QString("Interval_Start_Hour")){
			QString text=xmlReader.readElementText();
			for(h1=0; h1 < this->nHoursPerDay; h1++)
				if(this->hoursOfTheDay[h1]==text)
					break;
			if(h1>=this->nHoursPerDay){
				xmlReader.raiseError(tr("Hour %1 is nonexistent").arg(text));
				/*RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint Teacher interval max days per week start hour corrupt for teacher %1, hour %2 is nonexistent ... ignoring constraint")
					.arg(cn->teacherName)
					.arg(text));*/
				delete cn;
				//cn=nullptr;
				//goto corruptConstraintTime;
				return nullptr;
			}
			assert(h1>=0 && h1 < this->nHoursPerDay);
			xmlReadingLog+="    Interval start hour="+this->hoursOfTheDay[h1]+"\n";
			cn->startHour=h1;
		}
		else if(xmlReader.name()==QString("Interval_End_Hour")){
			QString text=xmlReader.readElementText();
			if(text==""){
				xmlReadingLog+="    Interval end hour void, meaning end of day\n";
				cn->endHour=this->nHoursPerDay;
			}
			else{
				for(h2=0; h2 < this->nHoursPerDay; h2++)
					if(this->hoursOfTheDay[h2]==text)
						break;
				if(h2>=this->nHoursPerDay){
					xmlReader.raiseError(tr("Hour %1 is nonexistent (it is also not void, to specify end of the day)").arg(text));
					/*RulesReconcilableMessage::information(parent, tr("FET information"),
						tr("Constraint Teacher interval max days per week end hour corrupt for teacher %1, hour %2 is nonexistent (it is also not void, to specify end of the day) ... ignoring constraint")
						.arg(cn->teacherName)
						.arg(text));*/
					delete cn;
					//cn=nullptr;
					//goto corruptConstraintTime;
					return nullptr;
				}
				assert(h2>=0 && h2 < this->nHoursPerDay);
				xmlReadingLog+="    Interval end hour="+this->hoursOfTheDay[h2]+"\n";
				cn->endHour=h2;
			}
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTeachersIntervalMaxDaysPerWeek(QWidget* parent, QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeachersIntervalMaxDaysPerWeek"));
	ConstraintTeachersIntervalMaxDaysPerWeek* cn=new ConstraintTeachersIntervalMaxDaysPerWeek();
	cn->maxDaysPerWeek=this->nDaysPerWeek;
	cn->startHour=this->nHoursPerDay;
	cn->endHour=this->nHoursPerDay;
	int h1, h2;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - generating 100% weight percentage\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		/*else if(xmlReader.name()==QString("Teacher_Name")){
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}*/
		else if(xmlReader.name()==QString("Max_Days_Per_Week")){
			QString text=xmlReader.readElementText();
			cn->maxDaysPerWeek=text.toInt();
			if(cn->maxDaysPerWeek>this->nDaysPerWeek){
				RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint TeachersIntervalMaxDaysPerWeek max days corrupt, max days %1 >nDaysPerWeek, constraint added, please correct constraint")
					//.arg(cn->teacherName)
					.arg(text));
				/*delete cn;
				cn=nullptr;
				goto corruptConstraintTime;*/
			}
			//assert(cn->maxDaysPerWeek>0 && cn->maxDaysPerWeek <= this->nDaysPerWeek);
			xmlReadingLog+="    Max. days per week="+CustomFETString::number(cn->maxDaysPerWeek)+"\n";
		}
		else if(xmlReader.name()==QString("Interval_Start_Hour")){
			QString text=xmlReader.readElementText();
			for(h1=0; h1 < this->nHoursPerDay; h1++)
				if(this->hoursOfTheDay[h1]==text)
					break;
			if(h1>=this->nHoursPerDay){
				xmlReader.raiseError(tr("Hour %1 is nonexistent").arg(text));
				/*RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint Teachers interval max days per week start hour corrupt because hour %1 is nonexistent ... ignoring constraint")
					//.arg(cn->teacherName)
					.arg(text));*/
				delete cn;
				//cn=nullptr;
				//goto corruptConstraintTime;
				return nullptr;
			}
			assert(h1>=0 && h1 < this->nHoursPerDay);
			xmlReadingLog+="    Interval start hour="+this->hoursOfTheDay[h1]+"\n";
			cn->startHour=h1;
		}
		else if(xmlReader.name()==QString("Interval_End_Hour")){
			QString text=xmlReader.readElementText();
			if(text==""){
				xmlReadingLog+="    Interval end hour void, meaning end of day\n";
				cn->endHour=this->nHoursPerDay;
			}
			else{
				for(h2=0; h2 < this->nHoursPerDay; h2++)
					if(this->hoursOfTheDay[h2]==text)
						break;
				if(h2>=this->nHoursPerDay){
					xmlReader.raiseError(tr("Hour %1 is nonexistent (it is also not void, to specify end of the day)").arg(text));
					/*RulesReconcilableMessage::information(parent, tr("FET information"),
						tr("Constraint Teachers interval max days per week end hour corrupt because hour %1 is nonexistent (it is also not void, to specify end of the day) ... ignoring constraint")
						//.arg(cn->teacherName)
						.arg(text));*/
					delete cn;
					//cn=nullptr;
					//goto corruptConstraintTime;
					return nullptr;
				}
				assert(h2>=0 && h2 < this->nHoursPerDay);
				xmlReadingLog+="    Interval end hour="+this->hoursOfTheDay[h2]+"\n";
				cn->endHour=h2;
			}
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readStudentsSetMaxDaysPerWeek(QWidget* parent, QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsSetMaxDaysPerWeek"));
	ConstraintStudentsSetMaxDaysPerWeek* cn=new ConstraintStudentsSetMaxDaysPerWeek();
	cn->maxDaysPerWeek=this->nDaysPerWeek;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->students=text;
			xmlReadingLog+="    Read students set name="+cn->students+"\n";
		}
		else if(xmlReader.name()==QString("Max_Days_Per_Week")){
			QString text=xmlReader.readElementText();
			cn->maxDaysPerWeek=text.toInt();
			if(cn->maxDaysPerWeek>this->nDaysPerWeek){
				RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint StudentsSetMaxDaysPerWeek max days corrupt for students set %1, max days %2 >nDaysPerWeek, constraint added, please correct constraint")
					.arg(cn->students)
					.arg(text));
			}
			xmlReadingLog+="    Max. days per week="+CustomFETString::number(cn->maxDaysPerWeek)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readStudentsMaxDaysPerWeek(QWidget* parent, QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsMaxDaysPerWeek"));
	ConstraintStudentsMaxDaysPerWeek* cn=new ConstraintStudentsMaxDaysPerWeek();
	cn->maxDaysPerWeek=this->nDaysPerWeek;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Max_Days_Per_Week")){
			QString text=xmlReader.readElementText();
			cn->maxDaysPerWeek=text.toInt();
			if(cn->maxDaysPerWeek>this->nDaysPerWeek){
				RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint StudentsMaxDaysPerWeek max days corrupt, max days %1 >nDaysPerWeek, constraint added, please correct constraint")
					.arg(text));
			}
			xmlReadingLog+="    Max. days per week="+CustomFETString::number(cn->maxDaysPerWeek)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readStudentsSetIntervalMaxDaysPerWeek(QWidget* parent, QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsSetIntervalMaxDaysPerWeek"));
	ConstraintStudentsSetIntervalMaxDaysPerWeek* cn=new ConstraintStudentsSetIntervalMaxDaysPerWeek();
	cn->maxDaysPerWeek=this->nDaysPerWeek;
	cn->startHour=this->nHoursPerDay;
	cn->endHour=this->nHoursPerDay;
	int h1, h2;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - generating 100% weight percentage\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->students=text;
			xmlReadingLog+="    Read students set name="+cn->students+"\n";
		}
		else if(xmlReader.name()==QString("Max_Days_Per_Week")){
			QString text=xmlReader.readElementText();
			cn->maxDaysPerWeek=text.toInt();
			if(cn->maxDaysPerWeek>this->nDaysPerWeek){
				RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint StudentsSetIntervalMaxDaysPerWeek max days corrupt for students set %1, max days %2 >nDaysPerWeek, constraint added, please correct constraint")
					.arg(cn->students)
					.arg(text));
				/*delete cn;
				cn=nullptr;
				goto corruptConstraintTime;*/
			}
			//assert(cn->maxDaysPerWeek>0 && cn->maxDaysPerWeek <= this->nDaysPerWeek);
			xmlReadingLog+="    Max. days per week="+CustomFETString::number(cn->maxDaysPerWeek)+"\n";
		}
		else if(xmlReader.name()==QString("Interval_Start_Hour")){
			QString text=xmlReader.readElementText();
			for(h1=0; h1 < this->nHoursPerDay; h1++)
				if(this->hoursOfTheDay[h1]==text)
					break;
			if(h1>=this->nHoursPerDay){
				xmlReader.raiseError(tr("Hour %1 is nonexistent").arg(text));
				/*RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint Students set interval max days per week start hour corrupt for students %1, hour %2 is nonexistent ... ignoring constraint")
					.arg(cn->students)
					.arg(text));*/
				delete cn;
				//cn=nullptr;
				//goto corruptConstraintTime;
				return nullptr;
			}
			assert(h1>=0 && h1 < this->nHoursPerDay);
			xmlReadingLog+="    Interval start hour="+this->hoursOfTheDay[h1]+"\n";
			cn->startHour=h1;
		}
		else if(xmlReader.name()==QString("Interval_End_Hour")){
			QString text=xmlReader.readElementText();
			if(text==""){
				xmlReadingLog+="    Interval end hour void, meaning end of day\n";
				cn->endHour=this->nHoursPerDay;
			}
			else{
				for(h2=0; h2 < this->nHoursPerDay; h2++)
					if(this->hoursOfTheDay[h2]==text)
						break;
				if(h2>=this->nHoursPerDay){
					xmlReader.raiseError(tr("Hour %1 is nonexistent (it is also not void, to specify end of the day)").arg(text));
					/*RulesReconcilableMessage::information(parent, tr("FET information"),
						tr("Constraint Students set interval max days per week end hour corrupt for students %1, hour %2 is nonexistent (it is also not void, to specify end of the day) ... ignoring constraint")
						.arg(cn->students)
						.arg(text));*/
					delete cn;
					//cn=nullptr;
					//goto corruptConstraintTime;
					return nullptr;
				}
				assert(h2>=0 && h2 < this->nHoursPerDay);
				xmlReadingLog+="    Interval end hour="+this->hoursOfTheDay[h2]+"\n";
				cn->endHour=h2;
			}
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readStudentsIntervalMaxDaysPerWeek(QWidget* parent, QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsIntervalMaxDaysPerWeek"));
	ConstraintStudentsIntervalMaxDaysPerWeek* cn=new ConstraintStudentsIntervalMaxDaysPerWeek();
	cn->maxDaysPerWeek=this->nDaysPerWeek;
	cn->startHour=this->nHoursPerDay;
	cn->endHour=this->nHoursPerDay;
	int h1, h2;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - generating 100% weight percentage\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		/*else if(xmlReader.name()==QString("Students")){
			cn->students=text;
			xmlReadingLog+="    Read students set name="+cn->students+"\n";
		}*/
		else if(xmlReader.name()==QString("Max_Days_Per_Week")){
			QString text=xmlReader.readElementText();
			cn->maxDaysPerWeek=text.toInt();
			if(cn->maxDaysPerWeek>this->nDaysPerWeek){
				RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint StudentsIntervalMaxDaysPerWeek max days corrupt: max days %1 >nDaysPerWeek, constraint added, please correct constraint")
					.arg(text));
				/*delete cn;
				cn=nullptr;
				goto corruptConstraintTime;*/
			}
			//assert(cn->maxDaysPerWeek>0 && cn->maxDaysPerWeek <= this->nDaysPerWeek);
			xmlReadingLog+="    Max. days per week="+CustomFETString::number(cn->maxDaysPerWeek)+"\n";
		}
		else if(xmlReader.name()==QString("Interval_Start_Hour")){
			QString text=xmlReader.readElementText();
			for(h1=0; h1 < this->nHoursPerDay; h1++)
				if(this->hoursOfTheDay[h1]==text)
					break;
			if(h1>=this->nHoursPerDay){
				xmlReader.raiseError(tr("Hour %1 is nonexistent").arg(text));
				/*RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint Students interval max days per week start hour corrupt: hour %1 is nonexistent ... ignoring constraint")
					//.arg(cn->students)
					.arg(text));*/
				delete cn;
				//cn=nullptr;
				//goto corruptConstraintTime;
				return nullptr;
			}
			assert(h1>=0 && h1 < this->nHoursPerDay);
			xmlReadingLog+="    Interval start hour="+this->hoursOfTheDay[h1]+"\n";
			cn->startHour=h1;
		}
		else if(xmlReader.name()==QString("Interval_End_Hour")){
			QString text=xmlReader.readElementText();
			if(text==""){
				xmlReadingLog+="    Interval end hour void, meaning end of day\n";
				cn->endHour=this->nHoursPerDay;
			}
			else{
				for(h2=0; h2 < this->nHoursPerDay; h2++)
					if(this->hoursOfTheDay[h2]==text)
						break;
				if(h2>=this->nHoursPerDay){
					xmlReader.raiseError(tr("Hour %1 is nonexistent (it is also not void, to specify end of the day)").arg(text));
					/*RulesReconcilableMessage::information(parent, tr("FET information"),
						tr("Constraint Students interval max days per week end hour corrupt: hour %1 is nonexistent (it is also not void, to specify end of the day) ... ignoring constraint")
						//.arg(cn->students)
						.arg(text));*/
					delete cn;
					//cn=nullptr;
					//goto corruptConstraintTime;
					return nullptr;
				}
				assert(h2>=0 && h2 < this->nHoursPerDay);
				xmlReadingLog+="    Interval end hour="+this->hoursOfTheDay[h2]+"\n";
				cn->endHour=h2;
			}
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readStudentsSetNotAvailable(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsSetNotAvailable"));

	//ConstraintStudentsSetNotAvailableTimes* cn=new ConstraintStudentsSetNotAvailableTimes();
	QList<int> days;
	QList<int> hours;
	QString students;
	double weightPercentage=100;
	int d=-1, h1=-1, h2=-1;
	bool active=true;
	QString comments="";
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			weightPercentage=customFETStrToDouble(text);
			if(weightPercentage<0){
				xmlReader.raiseError(tr("Weight percentage incorrect"));
				return nullptr;
			}
			assert(weightPercentage>=0);
			xmlReadingLog+="    Read weight percentage="+CustomFETString::number(weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			comments=text;
		}
		else if(xmlReader.name()==QString("Day")){
			QString text=xmlReader.readElementText();
			for(d=0; d<this->nDaysPerWeek; d++)
				if(this->daysOfTheWeek[d]==text)
					break;
			if(d>=this->nDaysPerWeek){
				xmlReader.raiseError(tr("Day %1 is nonexistent").arg(text));
				/*RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint StudentsSetNotAvailable day corrupt for students %1, day %2 is nonexistent ... ignoring constraint")
					.arg(students)
					.arg(text));*/
				//cn=nullptr;
				//goto corruptConstraintTime;
				return nullptr;
			}
			assert(d<this->nDaysPerWeek);
			xmlReadingLog+="    Crt. day="+this->daysOfTheWeek[d]+"\n";
		}
		else if(xmlReader.name()==QString("Start_Hour")){
			QString text=xmlReader.readElementText();
			for(h1=0; h1 < this->nHoursPerDay; h1++)
				if(this->hoursOfTheDay[h1]==text)
					break;
			if(h1==this->nHoursPerDay){
				xmlReader.raiseError(tr("Hour %1 is the last hour - impossible").arg(text));
				return nullptr;
			}
			else if(h1>this->nHoursPerDay){
				xmlReader.raiseError(tr("Hour %1 is nonexistent").arg(text));
				/*RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint StudentsSetNotAvailable start hour corrupt for students set %1, hour %2 is nonexistent ... ignoring constraint")
					.arg(students)
					.arg(text));*/
				//cn=nullptr;
				//goto corruptConstraintTime;
				return nullptr;
			}
			assert(h1>=0 && h1 < this->nHoursPerDay);
			xmlReadingLog+="    Start hour="+this->hoursOfTheDay[h1]+"\n";
		}
		else if(xmlReader.name()==QString("End_Hour")){
			QString text=xmlReader.readElementText();
			for(h2=0; h2 < this->nHoursPerDay; h2++)
				if(this->hoursOfTheDay[h2]==text)
					break;
			if(h2==0){
				xmlReader.raiseError(tr("Hour %1 is the first hour - impossible").arg(text));
				return nullptr;
			}
			else if(h2>this->nHoursPerDay){
				xmlReader.raiseError(tr("Hour %1 is nonexistent").arg(text));
				return nullptr;
			}
			/*if(h2<=0 || h2>this->nHoursPerDay){
				RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint StudentsSetNotAvailable end hour corrupt for students %1, hour %2 is nonexistent ... ignoring constraint")
					.arg(students)
					.arg(text));
				//goto corruptConstraintTime;
				return nullptr;
			}*/
			assert(h2>0 && h2 <= this->nHoursPerDay);
			xmlReadingLog+="    End hour="+this->hoursOfTheDay[h2]+"\n";
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			students=text;
			xmlReadingLog+="    Read students name="+students+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	
	assert(weightPercentage>=0);
	if(d<0){
		xmlReader.raiseError(tr("Field missing: %1").arg("Day"));
		return nullptr;
	}
	else if(h1<0){
		xmlReader.raiseError(tr("Field missing: %1").arg("Start_Hour"));
		return nullptr;
	}
	else if(h2<0){
		xmlReader.raiseError(tr("Field missing: %1").arg("End_Hour"));
		return nullptr;
	}
	assert(d>=0 && h1>=0 && h2>=0);
	
	ConstraintStudentsSetNotAvailableTimes* cn = nullptr;
	
	bool found=false;
	for(TimeConstraint* c : std::as_const(this->timeConstraintsList))
		if(c->type==CONSTRAINT_STUDENTS_SET_NOT_AVAILABLE_TIMES){
			ConstraintStudentsSetNotAvailableTimes* ssna=(ConstraintStudentsSetNotAvailableTimes*) c;
			if(ssna->students==students){
				found=true;
				
				for(int hh=h1; hh<h2; hh++){
					int k;
					for(k=0; k<ssna->days.count(); k++)
						if(ssna->days.at(k)==d && ssna->hours.at(k)==hh)
							break;
					if(k==ssna->days.count()){
						ssna->days.append(d);
						ssna->hours.append(hh);
					}
				}
				
				assert(ssna->days.count()==ssna->hours.count());
			}
		}
	if(!found){
		days.clear();
		hours.clear();
		for(int hh=h1; hh<h2; hh++){
			days.append(d);
			hours.append(hh);
		}
	
		cn=new ConstraintStudentsSetNotAvailableTimes(weightPercentage, students, days, hours);
		cn->active=active;
		cn->comments=comments;

		//crt_constraint=cn;
		return cn;
	}
	else
		return nullptr;
}

TimeConstraint* Rules::readStudentsSetNotAvailableTimes(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsSetNotAvailableTimes"));
	
	ConstraintStudentsSetNotAvailableTimes* cn=new ConstraintStudentsSetNotAvailableTimes();
	int nNotAvailableSlots=0;
	int i=0;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Read weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}

		else if(xmlReader.name()==QString("Number_of_Not_Available_Times")){
			QString text=xmlReader.readElementText();
			nNotAvailableSlots=text.toInt();
			xmlReadingLog+="    Read number of not available times="+CustomFETString::number(nNotAvailableSlots)+"\n";
		}

		else if(xmlReader.name()==QString("Not_Available_Time")){
			xmlReadingLog+="    Read: not available time\n";
			
			int d=-1;
			int h=-1;

			assert(xmlReader.isStartElement());
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
				if(xmlReader.name()==QString("Day")){
					QString text=xmlReader.readElementText();
					for(d=0; d<this->nDaysPerWeek; d++)
						if(this->daysOfTheWeek[d]==text)
							break;

					if(d>=this->nDaysPerWeek){
						xmlReader.raiseError(tr("Day %1 is nonexistent").arg(text));
						/*RulesReconcilableMessage::information(parent, tr("FET information"),
							tr("Constraint StudentsSetNotAvailableTimes day corrupt for students %1, day %2 is nonexistent ... ignoring constraint")
							.arg(cn->students)
							.arg(text));*/
						delete cn;
						cn=nullptr;
						//goto corruptConstraintTime;
						return nullptr;
					}
		
					assert(d<this->nDaysPerWeek);
					xmlReadingLog+="    Day="+this->daysOfTheWeek[d]+"("+CustomFETString::number(i)+")"+"\n";
				}
				else if(xmlReader.name()==QString("Hour")){
					QString text=xmlReader.readElementText();
					for(h=0; h < this->nHoursPerDay; h++)
						if(this->hoursOfTheDay[h]==text)
							break;
					
					if(h>=this->nHoursPerDay){
						xmlReader.raiseError(tr("Hour %1 is nonexistent").arg(text));
						/*RulesReconcilableMessage::information(parent, tr("FET information"),
							tr("Constraint StudentsSetNotAvailableTimes hour corrupt for students %1, hour %2 is nonexistent ... ignoring constraint")
							.arg(cn->students)
							.arg(text));*/
						delete cn;
						cn=nullptr;
						//goto corruptConstraintTime;
						return nullptr;
					}
					
					assert(h>=0 && h < this->nHoursPerDay);
					xmlReadingLog+="    Hour="+this->hoursOfTheDay[h]+"\n";
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
					unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

					xmlReader.skipCurrentElement();
					xmlReaderNumberOfUnrecognizedFields++;
				}
			}
			i++;
			
			cn->days.append(d);
			cn->hours.append(h);

			if(d==-1 || h==-1){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Not_Available_Time"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->students=text;
			xmlReadingLog+="    Read students name="+cn->students+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	assert(i==cn->days.count() && i==cn->hours.count());
	if(!(i==nNotAvailableSlots)){
		xmlReader.raiseError(tr("%1 does not coincide with the number of %2 which were read").arg("Number_of_Not_Available_Times").arg("Not_Available_Time"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(i==nNotAvailableSlots);

	return cn;
}

TimeConstraint* Rules::readMinNDaysBetweenActivities(QWidget* parent, QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintMinNDaysBetweenActivities"));
	
	ConstraintMinDaysBetweenActivities* cn=new ConstraintMinDaysBetweenActivities();
	cn->n_activities=0;
	bool foundCISD=false;
	int n_act=0;
	cn->activitiesIds.clear();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - generating weightPercentage=95%\n";
			cn->weightPercentage=95;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weightPercentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Consecutive_If_Same_Day") || xmlReader.name()==QString("Adjacent_If_Broken")){
			QString text=xmlReader.readElementText();
			if(text=="yes" || text=="true" || text=="1"){
				cn->consecutiveIfSameDay=true;
				foundCISD=true;
				xmlReadingLog+="    Current constraint has consecutive if on the same day=true\n";
			}
			else{
				if(!(text=="no" || text=="false" || text=="0")){
					RulesReconcilableMessage::warning(parent, tr("FET warning"),
						tr("Found constraint min days between activities with tag consecutive if on the same day"
						" which is not 'true', 'false', 'yes', 'no', '1' or '0'."
						" The tag will be considered false",
						"Instructions for translators: please leave the 'true', 'false', 'yes' and 'no' fields untranslated, as they are in English"));
				}
				//assert(text=="no" || text=="false" || text=="0");
				cn->consecutiveIfSameDay=false;
				foundCISD=true;
				xmlReadingLog+="    Current constraint has consecutive if on the same day=false\n";
			}
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=95;
				cn->consecutiveIfSameDay=true;
				foundCISD=true;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
				cn->consecutiveIfSameDay=false;
				foundCISD=true;
			}
		}
		else if(xmlReader.name()==QString("Number_of_Activities")){
			QString text=xmlReader.readElementText();
			cn->n_activities=text.toInt();
			xmlReadingLog+="    Read n_activities="+CustomFETString::number(cn->n_activities)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			
			int ti=text.toInt();
			if(cn->activitiesIds.contains(ti)){
				xmlReader.raiseError(tr("Activity id %1 is a duplicate in this constraint").arg(ti));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			
			//cn->activitiesIds[n_act]=text.toInt();
			cn->activitiesIds.append(ti);
			assert(n_act==cn->activitiesIds.count()-1);
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activitiesIds[n_act])+"\n";
			n_act++;
		}
		else if(xmlReader.name()==QString("MinDays")){
			QString text=xmlReader.readElementText();
			cn->minDays=text.toInt();
			xmlReadingLog+="    Read MinDays="+CustomFETString::number(cn->minDays)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(!foundCISD){
		xmlReadingLog+="    Could not find consecutive if on the same day information - making it true\n";
		cn->consecutiveIfSameDay=true;
	}
	if(!(n_act==cn->n_activities)){
		xmlReader.raiseError(tr("%1 does not coincide with the number of %2 which were read").arg("Number_of_Activities").arg("Activity_Id"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(n_act==cn->n_activities);
	return cn;
/*
#if 0
	if(0 && reportIncorrectMinDays && cn->n_activities > this->nDaysPerWeek){
		QString s=tr("You have a constraint min days between activities with more activities than the number of days per week.");
		s+=" ";
		s+=tr("Constraint is:");
		s+="\n";
		s+=crt_constraint->getDescription(*this);
		s+="\n";
		s+=tr("This is a very bad practice from the way the algorithm of generation works (it slows down the generation and makes it harder to find a solution).");
		s+="\n\n";
		s+=tr("To improve your file, you are advised to remove the corresponding activities and constraint and add activities again, respecting the following rules:");
		s+="\n\n";
		s+=tr("1. If you selected 'consecutive if on the same day', then couple extra activities in pairs to obtain a number of activities equal to the number of days per week"
			". Example: 7 activities with duration 1 in a 5 days week, then transform into 5 activities with durations: 2,2,1,1,1 and add a single container activity with these 5 components"
			" (possibly raising the weight of added constraint min days between activities up to 100%)");
		s+="\n\n";

		s+=tr("2. If you didn't select 'consecutive if on the same day', then add a larger activity split into a number of"
			" activities equal with the number of days per week and the remaining components into other larger split activity."
			" For example, suppose you need to add 7 activities with duration 1 in a 5 days week. Add 2 larger container activities,"
			" first one split into 5 activities with duration 1 and second one split into 2 activities with duration 1"
			" (possibly raising the weight of added constraints min days between activities for each of the 2 containers up to 100%)");

		s+="\n\n";
		s+=tr("Note: If the weight of the added constraint min days between activities is 0% or a low value, you can safely ignore this warning.");
		
		int t=QMessageBox::warning(parent, tr("FET warning"), s,
			tr("Skip rest"), tr("See next"), QString(),
			1, 0 );
		
		if(t==0)
			reportIncorrectMinDays=false;
	}
#endif
*/
}

TimeConstraint* Rules::readMinDaysBetweenActivities(QWidget* parent, QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintMinDaysBetweenActivities"));
	
	ConstraintMinDaysBetweenActivities* cn=new ConstraintMinDaysBetweenActivities();
	cn->n_activities=0;
	bool foundCISD=false;
	int n_act=0;
	cn->activitiesIds.clear();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - generating weightPercentage=95%\n";
			cn->weightPercentage=95;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weightPercentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Consecutive_If_Same_Day") || xmlReader.name()==QString("Adjacent_If_Broken")){
			QString text=xmlReader.readElementText();
			if(text=="yes" || text=="true" || text=="1"){
				cn->consecutiveIfSameDay=true;
				foundCISD=true;
				xmlReadingLog+="    Current constraint has consecutive if on the same day=true\n";
			}
			else{
				if(!(text=="no" || text=="false" || text=="0")){
					RulesReconcilableMessage::warning(parent, tr("FET warning"),
						tr("Found constraint min days between activities with tag consecutive if on the same day"
						" which is not 'true', 'false', 'yes', 'no', '1' or '0'."
						" The tag will be considered false",
						"Instructions for translators: please leave the 'true', 'false', 'yes' and 'no' fields untranslated, as they are in English"));
				}
				//assert(text=="no" || text=="false" || text=="0");
				cn->consecutiveIfSameDay=false;
				foundCISD=true;
				xmlReadingLog+="    Current constraint has consecutive if on the same day=false\n";
			}
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=95;
				cn->consecutiveIfSameDay=true;
				foundCISD=true;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
				cn->consecutiveIfSameDay=false;
				foundCISD=true;
			}
		}
		else if(xmlReader.name()==QString("Number_of_Activities")){
			QString text=xmlReader.readElementText();
			cn->n_activities=text.toInt();
			xmlReadingLog+="    Read n_activities="+CustomFETString::number(cn->n_activities)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			
			int ti=text.toInt();
			if(cn->activitiesIds.contains(ti)){
				xmlReader.raiseError(tr("Activity id %1 is a duplicate in this constraint").arg(ti));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			
			//cn->activitiesIds[n_act]=text.toInt();
			cn->activitiesIds.append(ti);
			assert(n_act==cn->activitiesIds.count()-1);
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activitiesIds[n_act])+"\n";
			n_act++;
		}
		else if(xmlReader.name()==QString("MinDays")){
			QString text=xmlReader.readElementText();
			cn->minDays=text.toInt();
			xmlReadingLog+="    Read MinDays="+CustomFETString::number(cn->minDays)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(!foundCISD){
		xmlReadingLog+="    Could not find consecutive if on the same day information - making it true\n";
		cn->consecutiveIfSameDay=true;
	}
	if(!(n_act==cn->n_activities)){
		xmlReader.raiseError(tr("%1 does not coincide with the number of %2 which were read").arg("Number_of_Activities").arg("Activity_Id"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(n_act==cn->n_activities);
	return cn;
/*
#if 0
	if(0 && reportIncorrectMinDays && cn->n_activities > this->nDaysPerWeek){
		QString s=tr("You have a constraint min days between activities with more activities than the number of days per week.");
		s+=" ";
		s+=tr("Constraint is:");
		s+="\n";
		s+=crt_constraint->getDescription(*this);
		s+="\n";
		s+=tr("This is a very bad practice from the way the algorithm of generation works (it slows down the generation and makes it harder to find a solution).");
		s+="\n\n";
		s+=tr("To improve your file, you are advised to remove the corresponding activities and constraint and add activities again, respecting the following rules:");
		s+="\n\n";
		s+=tr("1. If you selected 'consecutive if on the same day', then couple extra activities in pairs to obtain a number of activities equal to the number of days per week"
			". Example: 7 activities with duration 1 in a 5 days week, then transform into 5 activities with durations: 2,2,1,1,1 and add a single container activity with these 5 components"
			" (possibly raising the weight of added constraint min days between activities up to 100%)");
		s+="\n\n";

		s+=tr("2. If you didn't select 'consecutive if on the same day', then add a larger activity split into a number of"
			" activities equal with the number of days per week and the remaining components into other larger split activity."
			" For example, suppose you need to add 7 activities with duration 1 in a 5 days week. Add 2 larger container activities,"
			" first one split into 5 activities with duration 1 and second one split into 2 activities with duration 1"
			" (possibly raising the weight of added constraints min days between activities for each of the 2 containers up to 100%)");

		s+="\n\n";
		s+=tr("Note: If the weight of the added constraint min days between activities is 0% or a low value, you can safely ignore this warning.");
		
		int t=QMessageBox::warning(parent, tr("FET warning"), s,
			tr("Skip rest"), tr("See next"), QString(),
			1, 0 );
		
		if(t==0)
			reportIncorrectMinDays=false;
	}
#endif
*/
}

TimeConstraint* Rules::readMinHalfDaysBetweenActivities(QWidget* parent, QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintMinHalfDaysBetweenActivities"));
	
	ConstraintMinHalfDaysBetweenActivities* cn=new ConstraintMinHalfDaysBetweenActivities();
	cn->n_activities=0;
	bool foundCISD=false;
	int n_act=0;
	cn->activitiesIds.clear();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - generating weightPercentage=95%\n";
			cn->weightPercentage=95;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weightPercentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Consecutive_If_Same_Day") || xmlReader.name()==QString("Adjacent_If_Broken")){
			QString text=xmlReader.readElementText();
			if(text=="yes" || text=="true" || text=="1"){
				cn->consecutiveIfSameDay=true;
				foundCISD=true;
				xmlReadingLog+="    Current constraint has consecutive if on the same day=true\n";
			}
			else{
				if(!(text=="no" || text=="false" || text=="0")){
					RulesReconcilableMessage::warning(parent, tr("FET warning"),
						tr("Found constraint min half days between activities with tag consecutive if on the same day"
						" which is not 'true', 'false', 'yes', 'no', '1' or '0'."
						" The tag will be considered false",
						"Instructions for translators: please leave the 'true', 'false', 'yes' and 'no' fields untranslated, as they are in English"));
				}
				//assert(text=="no" || text=="false" || text=="0");
				cn->consecutiveIfSameDay=false;
				foundCISD=true;
				xmlReadingLog+="    Current constraint has consecutive if on the same day=false\n";
			}
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=95;
				cn->consecutiveIfSameDay=true;
				foundCISD=true;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
				cn->consecutiveIfSameDay=false;
				foundCISD=true;
			}
		}
		else if(xmlReader.name()==QString("Number_of_Activities")){
			QString text=xmlReader.readElementText();
			cn->n_activities=text.toInt();
			xmlReadingLog+="    Read n_activities="+CustomFETString::number(cn->n_activities)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			//cn->activitiesIds[n_act]=text.toInt();
			
			int ti=text.toInt();
			if(cn->activitiesIds.contains(ti)){
				xmlReader.raiseError(tr("Activity id %1 is a duplicate in this constraint").arg(ti));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			
			cn->activitiesIds.append(ti);
			assert(n_act==cn->activitiesIds.count()-1);
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activitiesIds[n_act])+"\n";
			n_act++;
		}
		else if(xmlReader.name()==QString("MinDays")){
			QString text=xmlReader.readElementText();
			cn->minDays=text.toInt();
			xmlReadingLog+="    Read MinDays="+CustomFETString::number(cn->minDays)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(!foundCISD){
		xmlReadingLog+="    Could not find consecutive if on the same day information - making it true\n";
		cn->consecutiveIfSameDay=true;
	}
	if(!(n_act==cn->n_activities)){
		xmlReader.raiseError(tr("%1 does not coincide with the number of %2 which were read").arg("Number_of_Activities").arg("Activity_Id"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(n_act==cn->n_activities);
	return cn;
/*
#if 0
	if(0 && reportIncorrectMinDays && cn->n_activities > this->nDaysPerWeek){
		QString s=tr("You have a constraint min days between activities with more activities than the number of days per week.");
		s+=" ";
		s+=tr("Constraint is:");
		s+="\n";
		s+=crt_constraint->getDescription(*this);
		s+="\n";
		s+=tr("This is a very bad practice from the way the algorithm of generation works (it slows down the generation and makes it harder to find a solution).");
		s+="\n\n";
		s+=tr("To improve your file, you are advised to remove the corresponding activities and constraint and add activities again, respecting the following rules:");
		s+="\n\n";
		s+=tr("1. If you selected 'consecutive if on the same day', then couple extra activities in pairs to obtain a number of activities equal to the number of days per week"
			". Example: 7 activities with duration 1 in a 5 days week, then transform into 5 activities with durations: 2,2,1,1,1 and add a single container activity with these 5 components"
			" (possibly raising the weight of added constraint min days between activities up to 100%)");
		s+="\n\n";

		s+=tr("2. If you didn't select 'consecutive if on the same day', then add a larger activity split into a number of"
			" activities equal with the number of days per week and the remaining components into other larger split activity."
			" For example, suppose you need to add 7 activities with duration 1 in a 5 days week. Add 2 larger container activities,"
			" first one split into 5 activities with duration 1 and second one split into 2 activities with duration 1"
			" (possibly raising the weight of added constraints min days between activities for each of the 2 containers up to 100%)");

		s+="\n\n";
		s+=tr("Note: If the weight of the added constraint min days between activities is 0% or a low value, you can safely ignore this warning.");
		
		int t=QMessageBox::warning(parent, tr("FET warning"), s,
			tr("Skip rest"), tr("See next"), QString(),
			1, 0 );
		
		if(t==0)
			reportIncorrectMinDays=false;
	}
#endif
*/
}

TimeConstraint* Rules::readMaxDaysBetweenActivities(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintMaxDaysBetweenActivities"));
	
	ConstraintMaxDaysBetweenActivities* cn=new ConstraintMaxDaysBetweenActivities();
	cn->n_activities=0;
	int n_act=0;
	cn->activitiesIds.clear();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weightPercentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Number_of_Activities")){
			QString text=xmlReader.readElementText();
			cn->n_activities=text.toInt();
			xmlReadingLog+="    Read n_activities="+CustomFETString::number(cn->n_activities)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->activitiesIds.append(text.toInt());
			assert(n_act==cn->activitiesIds.count()-1);
			//cn->activitiesIds[n_act]=text.toInt();
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activitiesIds[n_act])+"\n";
			n_act++;
		}
		else if(xmlReader.name()==QString("MaxDays")){
			QString text=xmlReader.readElementText();
			cn->maxDays=text.toInt();
			xmlReadingLog+="    Read MaxDays="+CustomFETString::number(cn->maxDays)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(!(n_act==cn->n_activities)){
		xmlReader.raiseError(tr("%1 does not coincide with the number of %2 which were read").arg("Number_of_Activities").arg("Activity_Id"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(n_act==cn->n_activities);
	return cn;
}

TimeConstraint* Rules::readActivitiesMaxHourlySpan(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivitiesMaxHourlySpan"));
	
	ConstraintActivitiesMaxHourlySpan* cn=new ConstraintActivitiesMaxHourlySpan();
	cn->n_activities=0;
	int n_act=0;
	cn->activitiesIds.clear();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weightPercentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Number_of_Activities")){
			QString text=xmlReader.readElementText();
			cn->n_activities=text.toInt();
			xmlReadingLog+="    Read n_activities="+CustomFETString::number(cn->n_activities)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->activitiesIds.append(text.toInt());
			assert(n_act==cn->activitiesIds.count()-1);
			//cn->activitiesIds[n_act]=text.toInt();
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activitiesIds[n_act])+"\n";
			n_act++;
		}
		else if(xmlReader.name()==QString("MaxHourlySpan")){
			QString text=xmlReader.readElementText();
			cn->maxHourlySpan=text.toInt();
			xmlReadingLog+="    Read MaxHourlySpan="+CustomFETString::number(cn->maxHourlySpan)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(!(n_act==cn->n_activities)){
		xmlReader.raiseError(tr("%1 does not coincide with the number of %2 which were read").arg("Number_of_Activities").arg("Activity_Id"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(n_act==cn->n_activities);
	return cn;
}

TimeConstraint* Rules::readMaxHalfDaysBetweenActivities(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintMaxHalfDaysBetweenActivities"));
	
	ConstraintMaxHalfDaysBetweenActivities* cn=new ConstraintMaxHalfDaysBetweenActivities();
	cn->n_activities=0;
	int n_act=0;
	cn->activitiesIds.clear();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weightPercentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Number_of_Activities")){
			QString text=xmlReader.readElementText();
			cn->n_activities=text.toInt();
			xmlReadingLog+="    Read n_activities="+CustomFETString::number(cn->n_activities)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->activitiesIds.append(text.toInt());
			assert(n_act==cn->activitiesIds.count()-1);
			//cn->activitiesIds[n_act]=text.toInt();
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activitiesIds[n_act])+"\n";
			n_act++;
		}
		else if(xmlReader.name()==QString("MaxDays")){
			QString text=xmlReader.readElementText();
			cn->maxDays=text.toInt();
			xmlReadingLog+="    Read MaxDays="+CustomFETString::number(cn->maxDays)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(!(n_act==cn->n_activities)){
		xmlReader.raiseError(tr("%1 does not coincide with the number of %2 which were read").arg("Number_of_Activities").arg("Activity_Id"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(n_act==cn->n_activities);
	return cn;
}

TimeConstraint* Rules::readMaxTermsBetweenActivities(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintMaxTermsBetweenActivities"));
	
	ConstraintMaxTermsBetweenActivities* cn=new ConstraintMaxTermsBetweenActivities();
	cn->n_activities=0;
	int n_act=0;
	cn->activitiesIds.clear();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weightPercentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Number_of_Activities")){
			QString text=xmlReader.readElementText();
			cn->n_activities=text.toInt();
			xmlReadingLog+="    Read n_activities="+CustomFETString::number(cn->n_activities)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->activitiesIds.append(text.toInt());
			assert(n_act==cn->activitiesIds.count()-1);
			//cn->activitiesIds[n_act]=text.toInt();
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activitiesIds[n_act])+"\n";
			n_act++;
		}
		else if(xmlReader.name()==QString("MaxTerms")){
			QString text=xmlReader.readElementText();
			cn->maxTerms=text.toInt();
			xmlReadingLog+="    Read MaxTerms="+CustomFETString::number(cn->maxTerms)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(!(n_act==cn->n_activities)){
		xmlReader.raiseError(tr("%1 does not coincide with the number of %2 which were read").arg("Number_of_Activities").arg("Activity_Id"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(n_act==cn->n_activities);
	return cn;
}

TimeConstraint* Rules::readMinGapsBetweenActivities(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintMinGapsBetweenActivities"));
	ConstraintMinGapsBetweenActivities* cn=new ConstraintMinGapsBetweenActivities();
	cn->n_activities=0;
	int n_act=0;
	cn->activitiesIds.clear();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weightPercentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Number_of_Activities")){
			QString text=xmlReader.readElementText();
			cn->n_activities=text.toInt();
			xmlReadingLog+="    Read n_activities="+CustomFETString::number(cn->n_activities)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->activitiesIds.append(text.toInt());
			assert(n_act==cn->activitiesIds.count()-1);
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activitiesIds[n_act])+"\n";
			n_act++;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			xmlReadingLog+="    Read MinGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(!(n_act==cn->n_activities)){
		xmlReader.raiseError(tr("%1 does not coincide with the number of %2 which were read").arg("Number_of_Activities").arg("Activity_Id"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(n_act==cn->n_activities);
	return cn;
}

TimeConstraint* Rules::readMaxGapsBetweenActivities(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintMaxGapsBetweenActivities"));
	ConstraintMaxGapsBetweenActivities* cn=new ConstraintMaxGapsBetweenActivities();
	cn->n_activities=0;
	int n_act=0;
	cn->activitiesIds.clear();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weightPercentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Number_of_Activities")){
			QString text=xmlReader.readElementText();
			cn->n_activities=text.toInt();
			xmlReadingLog+="    Read n_activities="+CustomFETString::number(cn->n_activities)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->activitiesIds.append(text.toInt());
			assert(n_act==cn->activitiesIds.count()-1);
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activitiesIds[n_act])+"\n";
			n_act++;
		}
		else if(xmlReader.name()==QString("MaxGaps")){
			QString text=xmlReader.readElementText();
			cn->maxGaps=text.toInt();
			xmlReadingLog+="    Read MaxGaps="+CustomFETString::number(cn->maxGaps)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(!(n_act==cn->n_activities)){
		xmlReader.raiseError(tr("%1 does not coincide with the number of %2 which were read").arg("Number_of_Activities").arg("Activity_Id"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(n_act==cn->n_activities);
	return cn;
}

TimeConstraint* Rules::readActivitiesNotOverlapping(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivitiesNotOverlapping"));
	ConstraintActivitiesNotOverlapping* cn=new ConstraintActivitiesNotOverlapping();
	cn->n_activities=0;
	int n_act=0;
	cn->activitiesIds.clear();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Number_of_Activities")){
			QString text=xmlReader.readElementText();
			cn->n_activities=text.toInt();
			xmlReadingLog+="    Read n_activities="+CustomFETString::number(cn->n_activities)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			//cn->activitiesIds[n_act]=text.toInt();
			cn->activitiesIds.append(text.toInt());
			assert(n_act==cn->activitiesIds.count()-1);
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activitiesIds[n_act])+"\n";
			n_act++;
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(!(n_act==cn->n_activities)){
		xmlReader.raiseError(tr("%1 does not coincide with the number of %2 which were read").arg("Number_of_Activities").arg("Activity_Id"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(n_act==cn->n_activities);
	return cn;
}

TimeConstraint* Rules::readActivityTagsNotOverlapping(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivityTagsNotOverlapping"));
	ConstraintActivityTagsNotOverlapping* cn=new ConstraintActivityTagsNotOverlapping();
	int nActivityTags=-1;
	cn->activityTagsNames.clear();
	QSet<QString> readTags;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Number_of_Activity_Tags")){
			QString text=xmlReader.readElementText();
			nActivityTags=text.toInt();
			if(nActivityTags<2){
				xmlReader.raiseError(tr("The number of activity tags in the constraint activity tags not overlapping is lower than two"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read n activity tags="+CustomFETString::number(nActivityTags)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			if(readTags.contains(text)){
				xmlReader.raiseError(tr("Duplicate activity tag %1 found in constraint activity tags not overlapping").arg(text));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			else{
				readTags.insert(text);
			}
			cn->activityTagsNames.append(text);
			xmlReadingLog+="    Read activity tag="+cn->activityTagsNames.at(cn->activityTagsNames.count()-1)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(!(nActivityTags==cn->activityTagsNames.count())){
		xmlReader.raiseError(tr("%1 does not coincide with the number of %2 which were read").arg("Number_of_Activity_Tags").arg("Activity_Tag"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(nActivityTags==cn->activityTagsNames.count());
	return cn;
}

TimeConstraint* Rules::readActivitiesSameStartingTime(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivitiesSameStartingTime"));
	ConstraintActivitiesSameStartingTime* cn=new ConstraintActivitiesSameStartingTime();
	cn->n_activities=0;
	int n_act=0;
	cn->activitiesIds.clear();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Number_of_Activities")){
			QString text=xmlReader.readElementText();
			cn->n_activities=text.toInt();
			xmlReadingLog+="    Read n_activities="+CustomFETString::number(cn->n_activities)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			//cn->activitiesIds[n_act]=text.toInt();
			cn->activitiesIds.append(text.toInt());
			assert(n_act==cn->activitiesIds.count()-1);
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activitiesIds[n_act])+"\n";
			n_act++;
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(!(n_act==cn->n_activities)){
		xmlReader.raiseError(tr("%1 does not coincide with the number of %2 which were read").arg("Number_of_Activities").arg("Activity_Id"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(n_act==cn->n_activities);
	return cn;
}

TimeConstraint* Rules::readActivitiesSameStartingHour(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivitiesSameStartingHour"));
	ConstraintActivitiesSameStartingHour* cn=new ConstraintActivitiesSameStartingHour();
	cn->n_activities=0;
	int n_act=0;
	cn->activitiesIds.clear();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Number_of_Activities")){
			QString text=xmlReader.readElementText();
			cn->n_activities=text.toInt();
			xmlReadingLog+="    Read n_activities="+CustomFETString::number(cn->n_activities)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			//cn->activitiesIds[n_act]=text.toInt();
			cn->activitiesIds.append(text.toInt());
			assert(n_act==cn->activitiesIds.count()-1);
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activitiesIds[n_act])+"\n";
			n_act++;
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(!(n_act==cn->n_activities)){
		xmlReader.raiseError(tr("%1 does not coincide with the number of %2 which were read").arg("Number_of_Activities").arg("Activity_Id"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(n_act==cn->n_activities);
	return cn;
}

TimeConstraint* Rules::readActivitiesSameStartingDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivitiesSameStartingDay"));
	ConstraintActivitiesSameStartingDay* cn=new ConstraintActivitiesSameStartingDay();
	cn->n_activities=0;
	int n_act=0;
	cn->activitiesIds.clear();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Number_of_Activities")){
			QString text=xmlReader.readElementText();
			cn->n_activities=text.toInt();
			xmlReadingLog+="    Read n_activities="+CustomFETString::number(cn->n_activities)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			//cn->activitiesIds[n_act]=text.toInt();
			cn->activitiesIds.append(text.toInt());
			assert(n_act==cn->activitiesIds.count()-1);
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activitiesIds[n_act])+"\n";
			n_act++;
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(!(n_act==cn->n_activities)){
		xmlReader.raiseError(tr("%1 does not coincide with the number of %2 which were read").arg("Number_of_Activities").arg("Activity_Id"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(n_act==cn->n_activities);
	return cn;
}

TimeConstraint* Rules::readTeachersMaxHoursDaily(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeachersMaxHoursDaily"));
	ConstraintTeachersMaxHoursDaily* cn=new ConstraintTeachersMaxHoursDaily();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Maximum_Hours_Daily")){
			QString text=xmlReader.readElementText();
			cn->maxHoursDaily=text.toInt();
			xmlReadingLog+="    Read maxHoursDaily="+CustomFETString::number(cn->maxHoursDaily)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTeacherMaxHoursDaily(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeacherMaxHoursDaily"));
	ConstraintTeacherMaxHoursDaily* cn=new ConstraintTeacherMaxHoursDaily();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Maximum_Hours_Daily")){
			QString text=xmlReader.readElementText();
			cn->maxHoursDaily=text.toInt();
			xmlReadingLog+="    Read maxHoursDaily="+CustomFETString::number(cn->maxHoursDaily)+"\n";
		}
		else if(xmlReader.name()==QString("Teacher_Name")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTeachersMaxHoursContinuously(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeachersMaxHoursContinuously"));
	ConstraintTeachersMaxHoursContinuously* cn=new ConstraintTeachersMaxHoursContinuously();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Maximum_Hours_Continuously")){
			QString text=xmlReader.readElementText();
			cn->maxHoursContinuously=text.toInt();
			xmlReadingLog+="    Read maxHoursContinuously="+CustomFETString::number(cn->maxHoursContinuously)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTeacherMaxHoursContinuously(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeacherMaxHoursContinuously"));
	ConstraintTeacherMaxHoursContinuously* cn=new ConstraintTeacherMaxHoursContinuously();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Maximum_Hours_Continuously")){
			QString text=xmlReader.readElementText();
			cn->maxHoursContinuously=text.toInt();
			xmlReadingLog+="    Read maxHoursContinuously="+CustomFETString::number(cn->maxHoursContinuously)+"\n";
		}
		else if(xmlReader.name()==QString("Teacher_Name")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTeacherActivityTagMaxHoursContinuously(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeacherActivityTagMaxHoursContinuously"));
	ConstraintTeacherActivityTagMaxHoursContinuously* cn=new ConstraintTeacherActivityTagMaxHoursContinuously();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Maximum_Hours_Continuously")){
			QString text=xmlReader.readElementText();
			cn->maxHoursContinuously=text.toInt();
			xmlReadingLog+="    Read maxHoursContinuously="+CustomFETString::number(cn->maxHoursContinuously)+"\n";
		}
		else if(xmlReader.name()==QString("Teacher_Name")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag_Name")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTeachersActivityTagMaxHoursContinuously(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeachersActivityTagMaxHoursContinuously"));
	ConstraintTeachersActivityTagMaxHoursContinuously* cn=new ConstraintTeachersActivityTagMaxHoursContinuously();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Maximum_Hours_Continuously")){
			QString text=xmlReader.readElementText();
			cn->maxHoursContinuously=text.toInt();
			xmlReadingLog+="    Read maxHoursContinuously="+CustomFETString::number(cn->maxHoursContinuously)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag_Name")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTeacherActivityTagMaxHoursDaily(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeacherActivityTagMaxHoursDaily"));
	ConstraintTeacherActivityTagMaxHoursDaily* cn=new ConstraintTeacherActivityTagMaxHoursDaily();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Maximum_Hours_Daily")){
			QString text=xmlReader.readElementText();
			cn->maxHoursDaily=text.toInt();
			xmlReadingLog+="    Read maxHoursDaily="+CustomFETString::number(cn->maxHoursDaily)+"\n";
		}
		else if(xmlReader.name()==QString("Teacher_Name")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag_Name")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTeachersActivityTagMaxHoursDaily(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeachersActivityTagMaxHoursDaily"));
	ConstraintTeachersActivityTagMaxHoursDaily* cn=new ConstraintTeachersActivityTagMaxHoursDaily();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Maximum_Hours_Daily")){
			QString text=xmlReader.readElementText();
			cn->maxHoursDaily=text.toInt();
			xmlReadingLog+="    Read maxHoursDaily="+CustomFETString::number(cn->maxHoursDaily)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag_Name")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTeacherActivityTagMinHoursDaily(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeacherActivityTagMinHoursDaily"));
	ConstraintTeacherActivityTagMinHoursDaily* cn=new ConstraintTeacherActivityTagMinHoursDaily();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Minimum_Hours_Daily")){
			QString text=xmlReader.readElementText();
			cn->minHoursDaily=text.toInt();
			xmlReadingLog+="    Read minHoursDaily="+CustomFETString::number(cn->minHoursDaily)+"\n";
		}
		else if(xmlReader.name()==QString("Teacher_Name")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag_Name")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Allow_Empty_Days")){ //old option
			QString text=xmlReader.readElementText();
			if(text=="true")
				cn->minDaysWithTag=0;
			else
				cn->minDaysWithTag=this->nDaysPerWeek;
		}
		else if(xmlReader.name()==QString("Minimum_Days_With_Tag")){
			QString text=xmlReader.readElementText();
			cn->minDaysWithTag=text.toInt();
			xmlReadingLog+="    Read minDaysWithTag="+CustomFETString::number(cn->minDaysWithTag)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTeachersActivityTagMinHoursDaily(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeachersActivityTagMinHoursDaily"));
	ConstraintTeachersActivityTagMinHoursDaily* cn=new ConstraintTeachersActivityTagMinHoursDaily();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Minimum_Hours_Daily")){
			QString text=xmlReader.readElementText();
			cn->minHoursDaily=text.toInt();
			xmlReadingLog+="    Read minHoursDaily="+CustomFETString::number(cn->minHoursDaily)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag_Name")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Allow_Empty_Days")){ //old option
			QString text=xmlReader.readElementText();
			if(text=="true")
				cn->minDaysWithTag=0;
			else
				cn->minDaysWithTag=this->nDaysPerWeek;
		}
		else if(xmlReader.name()==QString("Minimum_Days_With_Tag")){
			QString text=xmlReader.readElementText();
			cn->minDaysWithTag=text.toInt();
			xmlReadingLog+="    Read minDaysWithTag="+CustomFETString::number(cn->minDaysWithTag)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTeachersMinHoursDaily(QWidget* parent, QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeachersMinHoursDaily"));
	ConstraintTeachersMinHoursDaily* cn=new ConstraintTeachersMinHoursDaily();
	cn->allowEmptyDays=true;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Minimum_Hours_Daily")){
			QString text=xmlReader.readElementText();
			cn->minHoursDaily=text.toInt();
			xmlReadingLog+="    Read minHoursDaily="+CustomFETString::number(cn->minHoursDaily)+"\n";
		}
		else if(xmlReader.name()==QString("Allow_Empty_Days")){
			QString text=xmlReader.readElementText();
			if(text=="true" || text=="1" || text=="yes"){
				xmlReadingLog+="    Read allow empty days=true\n";
				cn->allowEmptyDays=true;
			}
			else{
				if(!(text=="no" || text=="false" || text=="0")){
					RulesReconcilableMessage::warning(parent, tr("FET warning"),
						tr("Found constraint teachers min hours daily with tag allow empty days"
						" which is not 'true', 'false', 'yes', 'no', '1' or '0'."
						" The tag will be considered false",
						"Instructions for translators: please leave the 'true', 'false', 'yes' and 'no' fields untranslated, as they are in English"));
				}
				//assert(text=="false" || text=="0" || text=="no");
				xmlReadingLog+="    Read allow empty days=false\n";
				cn->allowEmptyDays=false;
			}
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTeacherMinHoursDaily(QWidget* parent, QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeacherMinHoursDaily"));
	ConstraintTeacherMinHoursDaily* cn=new ConstraintTeacherMinHoursDaily();
	cn->allowEmptyDays=true;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Minimum_Hours_Daily")){
			QString text=xmlReader.readElementText();
			cn->minHoursDaily=text.toInt();
			xmlReadingLog+="    Read minHoursDaily="+CustomFETString::number(cn->minHoursDaily)+"\n";
		}
		else if(xmlReader.name()==QString("Teacher_Name")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Allow_Empty_Days")){
			QString text=xmlReader.readElementText();
			if(text=="true" || text=="1" || text=="yes"){
				xmlReadingLog+="    Read allow empty days=true\n";
				cn->allowEmptyDays=true;
			}
			else{
				if(!(text=="no" || text=="false" || text=="0")){
					RulesReconcilableMessage::warning(parent, tr("FET warning"),
						tr("Found constraint teacher min hours daily with tag allow empty days"
						" which is not 'true', 'false', 'yes', 'no', '1' or '0'."
						" The tag will be considered false",
						"Instructions for translators: please leave the 'true', 'false', 'yes' and 'no' fields untranslated, as they are in English"));
				}
				//assert(text=="false" || text=="0" || text=="no");
				xmlReadingLog+="    Read allow empty days=false\n";
				cn->allowEmptyDays=false;
			}
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readStudentsMaxHoursDaily(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsMaxHoursDaily"));
	ConstraintStudentsMaxHoursDaily* cn=new ConstraintStudentsMaxHoursDaily();
	cn->maxHoursDaily=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Maximum_Hours_Daily")){
			QString text=xmlReader.readElementText();
			cn->maxHoursDaily=text.toInt();
			if(cn->maxHoursDaily<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Maximum_Hours_Daily"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read maxHoursDaily="+CustomFETString::number(cn->maxHoursDaily)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->maxHoursDaily<0){
		xmlReader.raiseError(tr("%1 not found").arg("Maximum_Hours_Daily"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->maxHoursDaily>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsSetMaxHoursDaily(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsSetMaxHoursDaily"));
	ConstraintStudentsSetMaxHoursDaily* cn=new ConstraintStudentsSetMaxHoursDaily();
	cn->maxHoursDaily=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Maximum_Hours_Daily")){
			QString text=xmlReader.readElementText();
			cn->maxHoursDaily=text.toInt();
			if(cn->maxHoursDaily<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Maximum_Hours_Daily"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read maxHoursDaily="+CustomFETString::number(cn->maxHoursDaily)+"\n";
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->students=text;
			xmlReadingLog+="    Read students name="+cn->students+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->maxHoursDaily<0){
		xmlReader.raiseError(tr("%1 not found").arg("Maximum_Hours_Daily"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->maxHoursDaily>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsMaxHoursContinuously(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsMaxHoursContinuously"));
	ConstraintStudentsMaxHoursContinuously* cn=new ConstraintStudentsMaxHoursContinuously();
	cn->maxHoursContinuously=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Maximum_Hours_Continuously")){
			QString text=xmlReader.readElementText();
			cn->maxHoursContinuously=text.toInt();
			if(cn->maxHoursContinuously<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Maximum_Hours_Continuously"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read maxHoursContinuously="+CustomFETString::number(cn->maxHoursContinuously)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->maxHoursContinuously<0){
		xmlReader.raiseError(tr("%1 not found").arg("Maximum_Hours_Continuously"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->maxHoursContinuously>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsSetMaxHoursContinuously(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsSetMaxHoursContinuously"));
	ConstraintStudentsSetMaxHoursContinuously* cn=new ConstraintStudentsSetMaxHoursContinuously();
	cn->maxHoursContinuously=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Maximum_Hours_Continuously")){
			QString text=xmlReader.readElementText();
			cn->maxHoursContinuously=text.toInt();
			if(cn->maxHoursContinuously<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Maximum_Hours_Continuously"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read maxHoursContinuously="+CustomFETString::number(cn->maxHoursContinuously)+"\n";
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->students=text;
			xmlReadingLog+="    Read students name="+cn->students+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->maxHoursContinuously<0){
		xmlReader.raiseError(tr("%1 not found").arg("Maximum_Hours_Continuously"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->maxHoursContinuously>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsSetActivityTagMaxHoursContinuously(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsSetActivityTagMaxHoursContinuously"));
	ConstraintStudentsSetActivityTagMaxHoursContinuously* cn=new ConstraintStudentsSetActivityTagMaxHoursContinuously();
	cn->maxHoursContinuously=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Maximum_Hours_Continuously")){
			QString text=xmlReader.readElementText();
			cn->maxHoursContinuously=text.toInt();
			if(cn->maxHoursContinuously<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Maximum_Hours_Continuously"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read maxHoursContinuously="+CustomFETString::number(cn->maxHoursContinuously)+"\n";
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->students=text;
			xmlReadingLog+="    Read students name="+cn->students+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->maxHoursContinuously<0){
		xmlReader.raiseError(tr("%1 not found").arg("Maximum_Hours_Continuously"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->maxHoursContinuously>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsActivityTagMaxHoursContinuously(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsActivityTagMaxHoursContinuously"));
	ConstraintStudentsActivityTagMaxHoursContinuously* cn=new ConstraintStudentsActivityTagMaxHoursContinuously();
	cn->maxHoursContinuously=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Maximum_Hours_Continuously")){
			QString text=xmlReader.readElementText();
			cn->maxHoursContinuously=text.toInt();
			if(cn->maxHoursContinuously<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Maximum_Hours_Continuously"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read maxHoursContinuously="+CustomFETString::number(cn->maxHoursContinuously)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->maxHoursContinuously<0){
		xmlReader.raiseError(tr("%1 not found").arg("Maximum_Hours_Continuously"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->maxHoursContinuously>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsSetActivityTagMaxHoursDaily(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsSetActivityTagMaxHoursDaily"));
	ConstraintStudentsSetActivityTagMaxHoursDaily* cn=new ConstraintStudentsSetActivityTagMaxHoursDaily();
	cn->maxHoursDaily=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Maximum_Hours_Daily")){
			QString text=xmlReader.readElementText();
			cn->maxHoursDaily=text.toInt();
			if(cn->maxHoursDaily<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Maximum_Hours_Daily"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read maxHoursDaily="+CustomFETString::number(cn->maxHoursDaily)+"\n";
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->students=text;
			xmlReadingLog+="    Read students name="+cn->students+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->maxHoursDaily<0){
		xmlReader.raiseError(tr("%1 not found").arg("Maximum_Hours_Daily"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->maxHoursDaily>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsActivityTagMaxHoursDaily(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsActivityTagMaxHoursDaily"));
	ConstraintStudentsActivityTagMaxHoursDaily* cn=new ConstraintStudentsActivityTagMaxHoursDaily();
	cn->maxHoursDaily=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Maximum_Hours_Daily")){
			QString text=xmlReader.readElementText();
			cn->maxHoursDaily=text.toInt();
			if(cn->maxHoursDaily<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Maximum_Hours_Daily"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read maxHoursDaily="+CustomFETString::number(cn->maxHoursDaily)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->maxHoursDaily<0){
		xmlReader.raiseError(tr("%1 not found").arg("Maximum_Hours_Daily"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->maxHoursDaily>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsSetActivityTagMinHoursDaily(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsSetActivityTagMinHoursDaily"));
	ConstraintStudentsSetActivityTagMinHoursDaily* cn=new ConstraintStudentsSetActivityTagMinHoursDaily();
	cn->minHoursDaily=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Minimum_Hours_Daily")){
			QString text=xmlReader.readElementText();
			cn->minHoursDaily=text.toInt();
			if(cn->minHoursDaily<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Minimum_Hours_Daily"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minHoursDaily="+CustomFETString::number(cn->minHoursDaily)+"\n";
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->students=text;
			xmlReadingLog+="    Read students name="+cn->students+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Allow_Empty_Days")){ //old option
			QString text=xmlReader.readElementText();
			if(text=="true")
				cn->minDaysWithTag=0;
			else
				cn->minDaysWithTag=this->nDaysPerWeek;
		}
		else if(xmlReader.name()==QString("Minimum_Days_With_Tag")){
			QString text=xmlReader.readElementText();
			cn->minDaysWithTag=text.toInt();
			xmlReadingLog+="    Read minDaysWithTag="+CustomFETString::number(cn->minDaysWithTag)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minHoursDaily<0){
		xmlReader.raiseError(tr("%1 not found").arg("Minimum_Hours_Daily"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minHoursDaily>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsActivityTagMinHoursDaily(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsActivityTagMinHoursDaily"));
	ConstraintStudentsActivityTagMinHoursDaily* cn=new ConstraintStudentsActivityTagMinHoursDaily();
	cn->minHoursDaily=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Minimum_Hours_Daily")){
			QString text=xmlReader.readElementText();
			cn->minHoursDaily=text.toInt();
			if(cn->minHoursDaily<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Minimum_Hours_Daily"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minHoursDaily="+CustomFETString::number(cn->minHoursDaily)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Allow_Empty_Days")){ //old option
			QString text=xmlReader.readElementText();
			if(text=="true")
				cn->minDaysWithTag=0;
			else
				cn->minDaysWithTag=this->nDaysPerWeek;
		}
		else if(xmlReader.name()==QString("Minimum_Days_With_Tag")){
			QString text=xmlReader.readElementText();
			cn->minDaysWithTag=text.toInt();
			xmlReadingLog+="    Read minDaysWithTag="+CustomFETString::number(cn->minDaysWithTag)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minHoursDaily<0){
		xmlReader.raiseError(tr("%1 not found").arg("Minimum_Hours_Daily"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minHoursDaily>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsMinHoursDaily(QWidget* parent, QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsMinHoursDaily"));
	ConstraintStudentsMinHoursDaily* cn=new ConstraintStudentsMinHoursDaily();
	cn->minHoursDaily=-1;
	cn->allowEmptyDays=false;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Minimum_Hours_Daily")){
			QString text=xmlReader.readElementText();
			cn->minHoursDaily=text.toInt();
			if(cn->minHoursDaily<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Minimum_Hours_Daily"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minHoursDaily="+CustomFETString::number(cn->minHoursDaily)+"\n";
		}
		else if(xmlReader.name()==QString("Allow_Empty_Days")){
			QString text=xmlReader.readElementText();
			if(text=="true" || text=="1" || text=="yes"){
				xmlReadingLog+="    Read allow empty days=true\n";
				cn->allowEmptyDays=true;
			}
			else{
				if(!(text=="no" || text=="false" || text=="0")){
					RulesReconcilableMessage::warning(parent, tr("FET warning"),
						tr("Found constraint students min hours daily with tag allow empty days"
						" which is not 'true', 'false', 'yes', 'no', '1' or '0'."
						" The tag will be considered false",
						"Instructions for translators: please leave the 'true', 'false', 'yes' and 'no' fields untranslated, as they are in English"));
				}
				//assert(text=="false" || text=="0" || text=="no");
				xmlReadingLog+="    Read allow empty days=false\n";
				cn->allowEmptyDays=false;
			}
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minHoursDaily<0){
		xmlReader.raiseError(tr("%1 not found").arg("Minimum_Hours_Daily"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minHoursDaily>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsSetMinHoursDaily(QWidget* parent, QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsSetMinHoursDaily"));
	ConstraintStudentsSetMinHoursDaily* cn=new ConstraintStudentsSetMinHoursDaily();
	cn->minHoursDaily=-1;
	cn->allowEmptyDays=false;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Minimum_Hours_Daily")){
			QString text=xmlReader.readElementText();
			cn->minHoursDaily=text.toInt();
			if(cn->minHoursDaily<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("Minimum_Hours_Daily"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minHoursDaily="+CustomFETString::number(cn->minHoursDaily)+"\n";
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->students=text;
			xmlReadingLog+="    Read students name="+cn->students+"\n";
		}
		else if(xmlReader.name()==QString("Allow_Empty_Days")){
			QString text=xmlReader.readElementText();
			if(text=="true" || text=="1" || text=="yes"){
				xmlReadingLog+="    Read allow empty days=true\n";
				cn->allowEmptyDays=true;
			}
			else{
				if(!(text=="no" || text=="false" || text=="0")){
					RulesReconcilableMessage::warning(parent, tr("FET warning"),
						tr("Found constraint students set min hours daily with tag allow empty days"
						" which is not 'true', 'false', 'yes', 'no', '1' or '0'."
						" The tag will be considered false",
						"Instructions for translators: please leave the 'true', 'false', 'yes' and 'no' fields untranslated, as they are in English"));
				}
				//assert(text=="false" || text=="0" || text=="no");
				xmlReadingLog+="    Read allow empty days=false\n";
				cn->allowEmptyDays=false;
			}
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minHoursDaily<0){
		xmlReader.raiseError(tr("%1 not found").arg("Minimum_Hours_Daily"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minHoursDaily>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsSetMinGapsBetweenOrderedPairOfActivityTags(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTags"));
	ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTags* cn=new ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTags();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->students=text;
			xmlReadingLog+="    Read students name="+cn->students+"\n";
		}
		else if(xmlReader.name()==QString("First_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->firstActivityTag=text;
			xmlReadingLog+="    Read first activity tag name="+cn->firstActivityTag+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->secondActivityTag=text;
			xmlReadingLog+="    Read second activity tag name="+cn->secondActivityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsMinGapsBetweenOrderedPairOfActivityTags(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTags"));
	ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTags* cn=new ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTags();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("First_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->firstActivityTag=text;
			xmlReadingLog+="    Read first activity tag name="+cn->firstActivityTag+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->secondActivityTag=text;
			xmlReadingLog+="    Read second activity tag name="+cn->secondActivityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readTeacherMinGapsBetweenOrderedPairOfActivityTags(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTags"));
	ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTags* cn=new ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTags();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacher=text;
			xmlReadingLog+="    Read teacher name="+cn->teacher+"\n";
		}
		else if(xmlReader.name()==QString("First_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->firstActivityTag=text;
			xmlReadingLog+="    Read first activity tag name="+cn->firstActivityTag+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->secondActivityTag=text;
			xmlReadingLog+="    Read second activity tag name="+cn->secondActivityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readTeachersMinGapsBetweenOrderedPairOfActivityTags(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTags"));
	ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTags* cn=new ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTags();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("First_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->firstActivityTag=text;
			xmlReadingLog+="    Read first activity tag name="+cn->firstActivityTag+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->secondActivityTag=text;
			xmlReadingLog+="    Read second activity tag name="+cn->secondActivityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsSetMinGapsBetweenActivityTag(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsSetMinGapsBetweenActivityTag"));
	ConstraintStudentsSetMinGapsBetweenActivityTag* cn=new ConstraintStudentsSetMinGapsBetweenActivityTag();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->students=text;
			xmlReadingLog+="    Read students name="+cn->students+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTag=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsMinGapsBetweenActivityTag(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsMinGapsBetweenActivityTag"));
	ConstraintStudentsMinGapsBetweenActivityTag* cn=new ConstraintStudentsMinGapsBetweenActivityTag();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTag=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readTeacherMinGapsBetweenActivityTag(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeacherMinGapsBetweenActivityTag"));
	ConstraintTeacherMinGapsBetweenActivityTag* cn=new ConstraintTeacherMinGapsBetweenActivityTag();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacher=text;
			xmlReadingLog+="    Read teacher name="+cn->teacher+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTag=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readTeachersMinGapsBetweenActivityTag(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeachersMinGapsBetweenActivityTag"));
	ConstraintTeachersMinGapsBetweenActivityTag* cn=new ConstraintTeachersMinGapsBetweenActivityTag();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTag=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay"));
	ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* cn=new ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsPerRealDay();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->students=text;
			xmlReadingLog+="    Read students name="+cn->students+"\n";
		}
		else if(xmlReader.name()==QString("First_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->firstActivityTag=text;
			xmlReadingLog+="    Read first activity tag name="+cn->firstActivityTag+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->secondActivityTag=text;
			xmlReadingLog+="    Read second activity tag name="+cn->secondActivityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsMinGapsBetweenOrderedPairOfActivityTagsPerRealDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsPerRealDay"));
	ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* cn=new ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsPerRealDay();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("First_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->firstActivityTag=text;
			xmlReadingLog+="    Read first activity tag name="+cn->firstActivityTag+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->secondActivityTag=text;
			xmlReadingLog+="    Read second activity tag name="+cn->secondActivityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readTeacherMinGapsBetweenOrderedPairOfActivityTagsPerRealDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsPerRealDay"));
	ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* cn=new ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsPerRealDay();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacher=text;
			xmlReadingLog+="    Read teacher name="+cn->teacher+"\n";
		}
		else if(xmlReader.name()==QString("First_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->firstActivityTag=text;
			xmlReadingLog+="    Read first activity tag name="+cn->firstActivityTag+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->secondActivityTag=text;
			xmlReadingLog+="    Read second activity tag name="+cn->secondActivityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readTeachersMinGapsBetweenOrderedPairOfActivityTagsPerRealDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsPerRealDay"));
	ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsPerRealDay* cn=new ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsPerRealDay();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("First_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->firstActivityTag=text;
			xmlReadingLog+="    Read first activity tag name="+cn->firstActivityTag+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->secondActivityTag=text;
			xmlReadingLog+="    Read second activity tag name="+cn->secondActivityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsSetMinGapsBetweenActivityTagPerRealDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsSetMinGapsBetweenActivityTagPerRealDay"));
	ConstraintStudentsSetMinGapsBetweenActivityTagPerRealDay* cn=new ConstraintStudentsSetMinGapsBetweenActivityTagPerRealDay();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->students=text;
			xmlReadingLog+="    Read students name="+cn->students+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTag=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsMinGapsBetweenActivityTagPerRealDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsMinGapsBetweenActivityTagPerRealDay"));
	ConstraintStudentsMinGapsBetweenActivityTagPerRealDay* cn=new ConstraintStudentsMinGapsBetweenActivityTagPerRealDay();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTag=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readTeacherMinGapsBetweenActivityTagPerRealDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeacherMinGapsBetweenActivityTagPerRealDay"));
	ConstraintTeacherMinGapsBetweenActivityTagPerRealDay* cn=new ConstraintTeacherMinGapsBetweenActivityTagPerRealDay();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacher=text;
			xmlReadingLog+="    Read teacher name="+cn->teacher+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTag=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readTeachersMinGapsBetweenActivityTagPerRealDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeachersMinGapsBetweenActivityTagPerRealDay"));
	ConstraintTeachersMinGapsBetweenActivityTagPerRealDay* cn=new ConstraintTeachersMinGapsBetweenActivityTagPerRealDay();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTag=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon"));
	ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* cn=new ConstraintStudentsSetMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->students=text;
			xmlReadingLog+="    Read students name="+cn->students+"\n";
		}
		else if(xmlReader.name()==QString("First_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->firstActivityTag=text;
			xmlReadingLog+="    Read first activity tag name="+cn->firstActivityTag+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->secondActivityTag=text;
			xmlReadingLog+="    Read second activity tag name="+cn->secondActivityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon"));
	ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* cn=new ConstraintStudentsMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("First_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->firstActivityTag=text;
			xmlReadingLog+="    Read first activity tag name="+cn->firstActivityTag+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->secondActivityTag=text;
			xmlReadingLog+="    Read second activity tag name="+cn->secondActivityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readTeacherMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon"));
	ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* cn=new ConstraintTeacherMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacher=text;
			xmlReadingLog+="    Read teacher name="+cn->teacher+"\n";
		}
		else if(xmlReader.name()==QString("First_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->firstActivityTag=text;
			xmlReadingLog+="    Read first activity tag name="+cn->firstActivityTag+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->secondActivityTag=text;
			xmlReadingLog+="    Read second activity tag name="+cn->secondActivityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readTeachersMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon"));
	ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon* cn=new ConstraintTeachersMinGapsBetweenOrderedPairOfActivityTagsBetweenMorningAndAfternoon();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("First_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->firstActivityTag=text;
			xmlReadingLog+="    Read first activity tag name="+cn->firstActivityTag+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->secondActivityTag=text;
			xmlReadingLog+="    Read second activity tag name="+cn->secondActivityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon"));
	ConstraintStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon* cn=new ConstraintStudentsSetMinGapsBetweenActivityTagBetweenMorningAndAfternoon();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->students=text;
			xmlReadingLog+="    Read students name="+cn->students+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTag=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readStudentsMinGapsBetweenActivityTagBetweenMorningAndAfternoon(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintStudentsMinGapsBetweenActivityTagBetweenMorningAndAfternoon"));
	ConstraintStudentsMinGapsBetweenActivityTagBetweenMorningAndAfternoon* cn=new ConstraintStudentsMinGapsBetweenActivityTagBetweenMorningAndAfternoon();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTag=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readTeacherMinGapsBetweenActivityTagBetweenMorningAndAfternoon(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeacherMinGapsBetweenActivityTagBetweenMorningAndAfternoon"));
	ConstraintTeacherMinGapsBetweenActivityTagBetweenMorningAndAfternoon* cn=new ConstraintTeacherMinGapsBetweenActivityTagBetweenMorningAndAfternoon();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacher=text;
			xmlReadingLog+="    Read teacher name="+cn->teacher+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTag=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readTeachersMinGapsBetweenActivityTagBetweenMorningAndAfternoon(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTeachersMinGapsBetweenActivityTagBetweenMorningAndAfternoon"));
	ConstraintTeachersMinGapsBetweenActivityTagBetweenMorningAndAfternoon* cn=new ConstraintTeachersMinGapsBetweenActivityTagBetweenMorningAndAfternoon();
	cn->minGaps=-1;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("MinGaps")){
			QString text=xmlReader.readElementText();
			cn->minGaps=text.toInt();
			if(cn->minGaps<0){
				xmlReader.raiseError(tr("%1 is incorrect").arg("MinGaps"));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
			xmlReadingLog+="    Read minGaps="+CustomFETString::number(cn->minGaps)+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTag=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTag+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	if(cn->minGaps<0){
		xmlReader.raiseError(tr("%1 not found").arg("MinGaps"));
		delete cn;
		cn=nullptr;
		return nullptr;
	}
	assert(cn->minGaps>=0);
	return cn;
}

TimeConstraint* Rules::readActivityPreferredTime(QWidget* parent, QXmlStreamReader& xmlReader, FakeString& xmlReadingLog,
bool& reportUnspecifiedPermanentlyLockedTime, bool& reportUnspecifiedDayOrHourPreferredStartingTime){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivityPreferredTime"));

	ConstraintActivityPreferredStartingTime* cn=new ConstraintActivityPreferredStartingTime();
	cn->day = cn->hour = -1;
	cn->permanentlyLocked=false; //default not locked
	bool foundLocked=false;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Permanently_Locked")){
			QString text=xmlReader.readElementText();
			if(text=="true" || text=="1" || text=="yes"){
				xmlReadingLog+="    Permanently locked\n";
				cn->permanentlyLocked=true;
			}
			else{
				if(!(text=="no" || text=="false" || text=="0")){
					RulesReconcilableMessage::warning(parent, tr("FET warning"),
						tr("Found constraint activity preferred starting time with tag permanently locked"
						" which is not 'true', 'false', 'yes', 'no', '1' or '0'."
						" The tag will be considered false",
						"Instructions for translators: please leave the 'true', 'false', 'yes' and 'no' fields untranslated, as they are in English"));
				}
				//assert(text=="false" || text=="0" || text=="no");
				xmlReadingLog+="    Not permanently locked\n";
				cn->permanentlyLocked=false;
			}
			foundLocked=true;
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->activityId=text.toInt();
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activityId)+"\n";
		}
		else if(xmlReader.name()==QString("Preferred_Day") || xmlReader.name()==QString("Day")){
			QString text=xmlReader.readElementText();
			for(cn->day=0; cn->day<this->nDaysPerWeek; cn->day++)
				if(this->daysOfTheWeek[cn->day]==text)
					break;
			if(cn->day>=this->nDaysPerWeek){
				xmlReader.raiseError(tr("Day %1 is nonexistent").arg(text));
				/*RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint ActivityPreferredTime day corrupt for activity with id %1, day %2 is nonexistent ... ignoring constraint")
					.arg(cn->activityId)
					.arg(text));*/
				delete cn;
				cn=nullptr;
				//goto corruptConstraintTime;
				return nullptr;
			}
			assert(cn->day<this->nDaysPerWeek);
			xmlReadingLog+="    Day="+this->daysOfTheWeek[cn->day]+"\n";
		}
		else if(xmlReader.name()==QString("Preferred_Hour") || xmlReader.name()==QString("Hour")){
			QString text=xmlReader.readElementText();
			for(cn->hour=0; cn->hour < this->nHoursPerDay; cn->hour++)
				if(this->hoursOfTheDay[cn->hour]==text)
					break;
			if(cn->hour>=this->nHoursPerDay){
				xmlReader.raiseError(tr("Hour %1 is nonexistent").arg(text));
				/*RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint ActivityPreferredTime hour corrupt for activity with id %1, hour %2 is nonexistent ... ignoring constraint")
					.arg(cn->activityId)
					.arg(text));*/
				delete cn;
				cn=nullptr;
				//goto corruptConstraintTime;
				return nullptr;
			}
			assert(cn->hour>=0 && cn->hour < this->nHoursPerDay);
			xmlReadingLog+="    Hour="+this->hoursOfTheDay[cn->hour]+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	//crt_constraint=cn;

	if(cn->hour>=0 && cn->day>=0 && !foundLocked && reportUnspecifiedPermanentlyLockedTime){
		int t=RulesReconcilableMessage::information(parent, tr("FET information"),
			tr("Found constraint activity preferred starting time, with unspecified tag"
			" 'permanently locked' - this tag will be set to 'false' by default. You can always modify it"
			" by editing the constraint in the 'Data' menu")+"\n\n"
			+tr("Explanation: starting with version 5.8.0 (January 2009), the constraint"
			" activity preferred starting time has"
			" a new tag, 'permanently locked' (true or false)."
			" It is recommended to make the tag 'permanently locked' true for the constraints you"
			" need to be not modifiable from the 'Timetable' menu"
			" and leave this tag false for the constraints you need to be modifiable from the 'Timetable' menu"
			" (the 'permanently locked' tag can be modified by editing the constraint from the 'Data' menu)."
			" This way, when viewing the timetable"
			" and locking/unlocking some activities, you will not unlock the constraints which"
			" need to be locked all the time."
			),
			tr("Skip rest"), tr("See next"), QString(), 1, 0 );
		if(t==0)
			reportUnspecifiedPermanentlyLockedTime=false;
	}
	
	if(cn->hour==-1 || cn->day==-1){
		if(reportUnspecifiedDayOrHourPreferredStartingTime){
			int t=RulesReconcilableMessage::information(parent, tr("FET information"),
				tr("Found constraint activity preferred starting time, with unspecified day or hour."
				" This constraint will be transformed into constraint activity preferred starting times (a set of times, not only one)."
				" This change is done in FET versions 5.8.1 and higher."
				),
				tr("Skip rest"), tr("See next"), QString(), 1, 0 );
			if(t==0)
				reportUnspecifiedDayOrHourPreferredStartingTime=false;
		}
			
		ConstraintActivityPreferredStartingTimes* cgood=new ConstraintActivityPreferredStartingTimes();
		if(cn->day==-1){
			cgood->activityId=cn->activityId;
			cgood->weightPercentage=cn->weightPercentage;
			cgood->nPreferredStartingTimes_L=this->nDaysPerWeek;
			for(int i=0; i<cgood->nPreferredStartingTimes_L; i++){
				/*cgood->days[i]=i;
				cgood->hours[i]=cn->hour;*/
				cgood->days_L.append(i);
				cgood->hours_L.append(cn->hour);
			}
		}
		else{
			assert(cn->hour==-1);
			cgood->activityId=cn->activityId;
			cgood->weightPercentage=cn->weightPercentage;
			cgood->nPreferredStartingTimes_L=this->nHoursPerDay;
			for(int i=0; i<cgood->nPreferredStartingTimes_L; i++){
				/*cgood->days[i]=cn->day;
				cgood->hours[i]=i;*/
				cgood->days_L.append(cn->day);
				cgood->hours_L.append(i);
			}
		}
		
		delete cn;
		return cgood;
	}
	
	return cn;
}

TimeConstraint* Rules::readActivityPreferredStartingTime(QWidget* parent, QXmlStreamReader& xmlReader, FakeString& xmlReadingLog,
bool& reportUnspecifiedPermanentlyLockedTime, bool& reportUnspecifiedDayOrHourPreferredStartingTime){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivityPreferredStartingTime"));
	ConstraintActivityPreferredStartingTime* cn=new ConstraintActivityPreferredStartingTime();
	cn->day = cn->hour = -1;
	cn->permanentlyLocked=false; //default false
	bool foundLocked=false;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("Permanently_Locked")){
			QString text=xmlReader.readElementText();
			if(text=="true" || text=="1" || text=="yes"){
				xmlReadingLog+="    Permanently locked\n";
				cn->permanentlyLocked=true;
			}
			else{
				if(!(text=="no" || text=="false" || text=="0")){
					RulesReconcilableMessage::warning(parent, tr("FET warning"),
						tr("Found constraint activity preferred starting time with tag permanently locked"
						" which is not 'true', 'false', 'yes', 'no', '1' or '0'."
						" The tag will be considered false",
						"Instructions for translators: please leave the 'true', 'false', 'yes' and 'no' fields untranslated, as they are in English"));
				}
				//assert(text=="false" || text=="0" || text=="no");
				xmlReadingLog+="    Not permanently locked\n";
				cn->permanentlyLocked=false;
			}
			foundLocked=true;
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->activityId=text.toInt();
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activityId)+"\n";
		}
		else if(xmlReader.name()==QString("Preferred_Day") || xmlReader.name()==QString("Day")){
			QString text=xmlReader.readElementText();
			for(cn->day=0; cn->day<this->nDaysPerWeek; cn->day++)
				if(this->daysOfTheWeek[cn->day]==text)
					break;
			if(cn->day>=this->nDaysPerWeek){
				xmlReader.raiseError(tr("Day %1 is nonexistent").arg(text));
				/*RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint ActivityPreferredStartingTime day corrupt for activity with id %1, day %2 is nonexistent ... ignoring constraint")
					.arg(cn->activityId)
					.arg(text));*/
				delete cn;
				cn=nullptr;
				//goto corruptConstraintTime;
				return nullptr;
			}
			assert(cn->day<this->nDaysPerWeek);
			xmlReadingLog+="    Day="+this->daysOfTheWeek[cn->day]+"\n";
		}
		else if(xmlReader.name()==QString("Preferred_Hour") || xmlReader.name()==QString("Hour")){
			QString text=xmlReader.readElementText();
			for(cn->hour=0; cn->hour < this->nHoursPerDay; cn->hour++)
				if(this->hoursOfTheDay[cn->hour]==text)
					break;
			if(cn->hour>=this->nHoursPerDay){
				xmlReader.raiseError(tr("Hour %1 is nonexistent").arg(text));
				/*RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint ActivityPreferredStartingTime hour corrupt for activity with id %1, hour %2 is nonexistent ... ignoring constraint")
					.arg(cn->activityId)
					.arg(text));*/
				delete cn;
				cn=nullptr;
				//goto corruptConstraintTime;
				return nullptr;
			}
			assert(cn->hour>=0 && cn->hour < this->nHoursPerDay);
			xmlReadingLog+="    Hour="+this->hoursOfTheDay[cn->hour]+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	//crt_constraint=cn;

	if(cn->hour>=0 && cn->day>=0 && !foundLocked && reportUnspecifiedPermanentlyLockedTime){
		int t=RulesReconcilableMessage::information(parent, tr("FET information"),
			tr("Found constraint activity preferred starting time, with unspecified tag"
			" 'permanently locked' - this tag will be set to 'false' by default. You can always modify it"
			" by editing the constraint in the 'Data' menu")+"\n\n"
			+tr("Explanation: starting with version 5.8.0 (January 2009), the constraint"
			" activity preferred starting time has"
			" a new tag, 'permanently locked' (true or false)."
			" It is recommended to make the tag 'permanently locked' true for the constraints you"
			" need to be not modifiable from the 'Timetable' menu"
			" and leave this tag false for the constraints you need to be modifiable from the 'Timetable' menu"
			" (the 'permanently locked' tag can be modified by editing the constraint from the 'Data' menu)."
			" This way, when viewing the timetable"
			" and locking/unlocking some activities, you will not unlock the constraints which"
			" need to be locked all the time."
			),
			tr("Skip rest"), tr("See next"), QString(), 1, 0 );
		if(t==0)
			reportUnspecifiedPermanentlyLockedTime=false;
	}

	if(cn->hour==-1 || cn->day==-1){
		if(reportUnspecifiedDayOrHourPreferredStartingTime){
			int t=RulesReconcilableMessage::information(parent, tr("FET information"),
				tr("Found constraint activity preferred starting time, with unspecified day or hour."
				" This constraint will be transformed into constraint activity preferred starting times (a set of times, not only one)."
				" This change is done in FET versions 5.8.1 and higher."
				),
				tr("Skip rest"), tr("See next"), QString(), 1, 0 );
			if(t==0)
				reportUnspecifiedDayOrHourPreferredStartingTime=false;
		}
			
		ConstraintActivityPreferredStartingTimes* cgood=new ConstraintActivityPreferredStartingTimes();
		if(cn->day==-1){
			cgood->activityId=cn->activityId;
			cgood->weightPercentage=cn->weightPercentage;
			cgood->nPreferredStartingTimes_L=this->nDaysPerWeek;
			for(int i=0; i<cgood->nPreferredStartingTimes_L; i++){
				/*cgood->days[i]=i;
				cgood->hours[i]=cn->hour;*/
				cgood->days_L.append(i);
				cgood->hours_L.append(cn->hour);
			}
		}
		else{
			assert(cn->hour==-1);
			cgood->activityId=cn->activityId;
			cgood->weightPercentage=cn->weightPercentage;
			cgood->nPreferredStartingTimes_L=this->nHoursPerDay;
			for(int i=0; i<cgood->nPreferredStartingTimes_L; i++){
				/*cgood->days[i]=cn->day;
				cgood->hours[i]=i;*/
				cgood->days_L.append(cn->day);
				cgood->hours_L.append(i);
			}
		}
		
		delete cn;
		return cgood;
	}
	
	return cn;
}

TimeConstraint* Rules::readActivityPreferredDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivityPreferredDay"));
	ConstraintActivityPreferredDay* cn=new ConstraintActivityPreferredDay();
	cn->day = -1;
	//cn->permanentlyLocked=false; //default false
	//bool foundLocked=false;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		/*else if(xmlReader.name()==QString("Permanently_Locked")){
			QString text=xmlReader.readElementText();
			if(text=="true" || text=="1" || text=="yes"){
				xmlReadingLog+="    Permanently locked\n";
				cn->permanentlyLocked=true;
			}
			else{
				if(!(text=="no" || text=="false" || text=="0")){
					RulesReconcilableMessage::warning(parent, tr("FET warning"),
						tr("Found constraint activity preferred starting time with tag permanently locked"
						" which is not 'true', 'false', 'yes', 'no', '1' or '0'."
						" The tag will be considered false",
						"Instructions for translators: please leave the 'true', 'false', 'yes' and 'no' fields untranslated, as they are in English"));
				}
				//assert(text=="false" || text=="0" || text=="no");
				xmlReadingLog+="    Not permanently locked\n";
				cn->permanentlyLocked=false;
			}
			foundLocked=true;
		}*/
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->activityId=text.toInt();
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activityId)+"\n";

			if(!this->apdHash.value(cn->activityId, QSet<ConstraintActivityPreferredDay*>()).isEmpty()){
				xmlReader.raiseError(tr("It is not allowed to have more than one constraint of type activity preferred day for an activity;"
				 " this condition is not respected for the activity id %1").arg(cn->activityId));
				delete cn;
				cn=nullptr;
				return nullptr;
			}
		}
		else if(xmlReader.name()==QString("Preferred_Day") || xmlReader.name()==QString("Day")){
			QString text=xmlReader.readElementText();
			for(cn->day=0; cn->day<this->nDaysPerWeek; cn->day++)
				if(this->daysOfTheWeek[cn->day]==text)
					break;
			if(cn->day>=this->nDaysPerWeek){
				xmlReader.raiseError(tr("Day %1 is nonexistent").arg(text));
				/*RulesReconcilableMessage::information(parent, tr("FET information"),
					tr("Constraint ActivityPreferredStartingTime day corrupt for activity with id %1, day %2 is nonexistent ... ignoring constraint")
					.arg(cn->activityId)
					.arg(text));*/
				delete cn;
				cn=nullptr;
				//goto corruptConstraintTime;
				return nullptr;
			}
			assert(cn->day<this->nDaysPerWeek);
			xmlReadingLog+="    Day="+this->daysOfTheWeek[cn->day]+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	//crt_constraint=cn;

	/*if(cn->hour>=0 && cn->day>=0 && !foundLocked && reportUnspecifiedPermanentlyLockedTime){
		int t=RulesReconcilableMessage::information(parent, tr("FET information"),
			tr("Found constraint activity preferred starting time, with unspecified tag"
			" 'permanently locked' - this tag will be set to 'false' by default. You can always modify it"
			" by editing the constraint in the 'Data' menu")+"\n\n"
			+tr("Explanation: starting with version 5.8.0 (January 2009), the constraint"
			" activity preferred starting time has"
			" a new tag, 'permanently locked' (true or false)."
			" It is recommended to make the tag 'permanently locked' true for the constraints you"
			" need to be not modifiable from the 'Timetable' menu"
			" and leave this tag false for the constraints you need to be modifiable from the 'Timetable' menu"
			" (the 'permanently locked' tag can be modified by editing the constraint from the 'Data' menu)."
			" This way, when viewing the timetable"
			" and locking/unlocking some activities, you will not unlock the constraints which"
			" need to be locked all the time."
			),
			tr("Skip rest"), tr("See next"), QString(), 1, 0 );
		if(t==0)
			reportUnspecifiedPermanentlyLockedTime=false;
	}*/

	/*if(cn->hour==-1 || cn->day==-1){
		if(reportUnspecifiedDayOrHourPreferredStartingTime){
			int t=RulesReconcilableMessage::information(parent, tr("FET information"),
				tr("Found constraint activity preferred starting time, with unspecified day or hour."
				" This constraint will be transformed into constraint activity preferred starting times (a set of times, not only one)."
				" This change is done in FET versions 5.8.1 and higher."
				),
				tr("Skip rest"), tr("See next"), QString(), 1, 0 );
			if(t==0)
				reportUnspecifiedDayOrHourPreferredStartingTime=false;
		}
			
		ConstraintActivityPreferredStartingTimes* cgood=new ConstraintActivityPreferredStartingTimes();
		if(cn->day==-1){
			cgood->activityId=cn->activityId;
			cgood->weightPercentage=cn->weightPercentage;
			cgood->nPreferredStartingTimes_L=this->nDaysPerWeek;
			for(int i=0; i<cgood->nPreferredStartingTimes_L; i++){
				cgood->days_L.append(i);
				cgood->hours_L.append(cn->hour);
			}
		}
		else{
			assert(cn->hour==-1);
			cgood->activityId=cn->activityId;
			cgood->weightPercentage=cn->weightPercentage;
			cgood->nPreferredStartingTimes_L=this->nHoursPerDay;
			for(int i=0; i<cgood->nPreferredStartingTimes_L; i++){
				cgood->days_L.append(cn->day);
				cgood->hours_L.append(i);
			}
		}
		
		delete cn;
		return cgood;
	}*/
	
	return cn;
}

TimeConstraint* Rules::readActivityEndsStudentsDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivityEndsStudentsDay"));
	ConstraintActivityEndsStudentsDay* cn=new ConstraintActivityEndsStudentsDay();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->activityId=text.toInt();
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activityId)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readActivitiesEndStudentsDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivitiesEndStudentsDay"));
	ConstraintActivitiesEndStudentsDay* cn=new ConstraintActivitiesEndStudentsDay();
	cn->teacherName="";
	cn->studentsName="";
	cn->subjectName="";
	cn->activityTagName="";
	
	//i=0;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Teacher_Name")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Students_Name")){
			QString text=xmlReader.readElementText();
			cn->studentsName=text;
			xmlReadingLog+="    Read students name="+cn->studentsName+"\n";
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->studentsName=text;
			xmlReadingLog+="    Read students name="+cn->studentsName+"\n";
		}
		else if(xmlReader.name()==QString("Subject_Name")){
			QString text=xmlReader.readElementText();
			cn->subjectName=text;
			xmlReadingLog+="    Read subject name="+cn->subjectName+"\n";
		}
		else if(xmlReader.name()==QString("Subject")){
			QString text=xmlReader.readElementText();
			cn->subjectName=text;
			xmlReadingLog+="    Read subject name="+cn->subjectName+"\n";
		}
		else if(xmlReader.name()==QString("Subject_Tag_Name")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag_Name")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readActivityEndsTeachersDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivityEndsTeachersDay"));
	ConstraintActivityEndsTeachersDay* cn=new ConstraintActivityEndsTeachersDay();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->activityId=text.toInt();
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activityId)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readActivitiesEndTeachersDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivitiesEndTeachersDay"));
	ConstraintActivitiesEndTeachersDay* cn=new ConstraintActivitiesEndTeachersDay();
	cn->teacherName="";
	cn->studentsName="";
	cn->subjectName="";
	cn->activityTagName="";
	
	//i=0;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Teacher_Name")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Students_Name")){
			QString text=xmlReader.readElementText();
			cn->studentsName=text;
			xmlReadingLog+="    Read students name="+cn->studentsName+"\n";
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->studentsName=text;
			xmlReadingLog+="    Read students name="+cn->studentsName+"\n";
		}
		else if(xmlReader.name()==QString("Subject_Name")){
			QString text=xmlReader.readElementText();
			cn->subjectName=text;
			xmlReadingLog+="    Read subject name="+cn->subjectName+"\n";
		}
		else if(xmlReader.name()==QString("Subject")){
			QString text=xmlReader.readElementText();
			cn->subjectName=text;
			xmlReadingLog+="    Read subject name="+cn->subjectName+"\n";
		}
		else if(xmlReader.name()==QString("Subject_Tag_Name")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag_Name")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readActivityBeginsStudentsDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivityBeginsStudentsDay"));
	ConstraintActivityBeginsStudentsDay* cn=new ConstraintActivityBeginsStudentsDay();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->activityId=text.toInt();
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activityId)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readActivitiesBeginStudentsDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivitiesBeginStudentsDay"));
	ConstraintActivitiesBeginStudentsDay* cn=new ConstraintActivitiesBeginStudentsDay();
	cn->teacherName="";
	cn->studentsName="";
	cn->subjectName="";
	cn->activityTagName="";
	
	//i=0;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Teacher_Name")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Students_Name")){
			QString text=xmlReader.readElementText();
			cn->studentsName=text;
			xmlReadingLog+="    Read students name="+cn->studentsName+"\n";
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->studentsName=text;
			xmlReadingLog+="    Read students name="+cn->studentsName+"\n";
		}
		else if(xmlReader.name()==QString("Subject_Name")){
			QString text=xmlReader.readElementText();
			cn->subjectName=text;
			xmlReadingLog+="    Read subject name="+cn->subjectName+"\n";
		}
		else if(xmlReader.name()==QString("Subject")){
			QString text=xmlReader.readElementText();
			cn->subjectName=text;
			xmlReadingLog+="    Read subject name="+cn->subjectName+"\n";
		}
		else if(xmlReader.name()==QString("Subject_Tag_Name")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag_Name")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readActivityBeginsTeachersDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivityBeginsTeachersDay"));
	ConstraintActivityBeginsTeachersDay* cn=new ConstraintActivityBeginsTeachersDay();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->activityId=text.toInt();
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activityId)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readActivitiesBeginTeachersDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivitiesBeginTeachersDay"));
	ConstraintActivitiesBeginTeachersDay* cn=new ConstraintActivitiesBeginTeachersDay();
	cn->teacherName="";
	cn->studentsName="";
	cn->subjectName="";
	cn->activityTagName="";
	
	//i=0;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Teacher_Name")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Students_Name")){
			QString text=xmlReader.readElementText();
			cn->studentsName=text;
			xmlReadingLog+="    Read students name="+cn->studentsName+"\n";
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->studentsName=text;
			xmlReadingLog+="    Read students name="+cn->studentsName+"\n";
		}
		else if(xmlReader.name()==QString("Subject_Name")){
			QString text=xmlReader.readElementText();
			cn->subjectName=text;
			xmlReadingLog+="    Read subject name="+cn->subjectName+"\n";
		}
		else if(xmlReader.name()==QString("Subject")){
			QString text=xmlReader.readElementText();
			cn->subjectName=text;
			xmlReadingLog+="    Read subject name="+cn->subjectName+"\n";
		}
		else if(xmlReader.name()==QString("Subject_Tag_Name")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag_Name")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readActivityBeginsOrEndsStudentsDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivityBeginsOrEndsStudentsDay"));
	ConstraintActivityBeginsOrEndsStudentsDay* cn=new ConstraintActivityBeginsOrEndsStudentsDay();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->activityId=text.toInt();
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activityId)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readActivitiesBeginOrEndStudentsDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivitiesBeginOrEndStudentsDay"));
	ConstraintActivitiesBeginOrEndStudentsDay* cn=new ConstraintActivitiesBeginOrEndStudentsDay();
	cn->teacherName="";
	cn->studentsName="";
	cn->subjectName="";
	cn->activityTagName="";
	
	//i=0;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Teacher_Name")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Students_Name")){
			QString text=xmlReader.readElementText();
			cn->studentsName=text;
			xmlReadingLog+="    Read students name="+cn->studentsName+"\n";
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->studentsName=text;
			xmlReadingLog+="    Read students name="+cn->studentsName+"\n";
		}
		else if(xmlReader.name()==QString("Subject_Name")){
			QString text=xmlReader.readElementText();
			cn->subjectName=text;
			xmlReadingLog+="    Read subject name="+cn->subjectName+"\n";
		}
		else if(xmlReader.name()==QString("Subject")){
			QString text=xmlReader.readElementText();
			cn->subjectName=text;
			xmlReadingLog+="    Read subject name="+cn->subjectName+"\n";
		}
		else if(xmlReader.name()==QString("Subject_Tag_Name")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag_Name")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readActivityBeginsOrEndsTeachersDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivityBeginsOrEndsTeachersDay"));
	ConstraintActivityBeginsOrEndsTeachersDay* cn=new ConstraintActivityBeginsOrEndsTeachersDay();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->activityId=text.toInt();
			xmlReadingLog+="    Read activity id="+CustomFETString::number(cn->activityId)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readActivitiesBeginOrEndTeachersDay(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintActivitiesBeginOrEndTeachersDay"));
	ConstraintActivitiesBeginOrEndTeachersDay* cn=new ConstraintActivitiesBeginOrEndTeachersDay();
	cn->teacherName="";
	cn->studentsName="";
	cn->subjectName="";
	cn->activityTagName="";
	
	//i=0;
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Teacher_Name")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Teacher")){
			QString text=xmlReader.readElementText();
			cn->teacherName=text;
			xmlReadingLog+="    Read teacher name="+cn->teacherName+"\n";
		}
		else if(xmlReader.name()==QString("Students_Name")){
			QString text=xmlReader.readElementText();
			cn->studentsName=text;
			xmlReadingLog+="    Read students name="+cn->studentsName+"\n";
		}
		else if(xmlReader.name()==QString("Students")){
			QString text=xmlReader.readElementText();
			cn->studentsName=text;
			xmlReadingLog+="    Read students name="+cn->studentsName+"\n";
		}
		else if(xmlReader.name()==QString("Subject_Name")){
			QString text=xmlReader.readElementText();
			cn->subjectName=text;
			xmlReadingLog+="    Read subject name="+cn->subjectName+"\n";
		}
		else if(xmlReader.name()==QString("Subject")){
			QString text=xmlReader.readElementText();
			cn->subjectName=text;
			xmlReadingLog+="    Read subject name="+cn->subjectName+"\n";
		}
		else if(xmlReader.name()==QString("Subject_Tag_Name")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag_Name")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else if(xmlReader.name()==QString("Activity_Tag")){
			QString text=xmlReader.readElementText();
			cn->activityTagName=text;
			xmlReadingLog+="    Read activity tag name="+cn->activityTagName+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::read2ActivitiesConsecutive(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("Constraint2ActivitiesConsecutive"));
	ConstraintTwoActivitiesConsecutive* cn=new ConstraintTwoActivitiesConsecutive();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("First_Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->firstActivityId=text.toInt();
			xmlReadingLog+="    Read first activity id="+CustomFETString::number(cn->firstActivityId)+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->secondActivityId=text.toInt();
			xmlReadingLog+="    Read second activity id="+CustomFETString::number(cn->secondActivityId)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::read2ActivitiesGrouped(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("Constraint2ActivitiesGrouped"));
	ConstraintTwoActivitiesGrouped* cn=new ConstraintTwoActivitiesGrouped();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("First_Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->firstActivityId=text.toInt();
			xmlReadingLog+="    Read first activity id="+CustomFETString::number(cn->firstActivityId)+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->secondActivityId=text.toInt();
			xmlReadingLog+="    Read second activity id="+CustomFETString::number(cn->secondActivityId)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::read3ActivitiesGrouped(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("Constraint3ActivitiesGrouped"));
	ConstraintThreeActivitiesGrouped* cn=new ConstraintThreeActivitiesGrouped();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("First_Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->firstActivityId=text.toInt();
			xmlReadingLog+="    Read first activity id="+CustomFETString::number(cn->firstActivityId)+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->secondActivityId=text.toInt();
			xmlReadingLog+="    Read second activity id="+CustomFETString::number(cn->secondActivityId)+"\n";
		}
		else if(xmlReader.name()==QString("Third_Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->thirdActivityId=text.toInt();
			xmlReadingLog+="    Read third activity id="+CustomFETString::number(cn->thirdActivityId)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::read2ActivitiesOrdered(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("Constraint2ActivitiesOrdered"));
	ConstraintTwoActivitiesOrdered* cn=new ConstraintTwoActivitiesOrdered();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("First_Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->firstActivityId=text.toInt();
			xmlReadingLog+="    Read first activity id="+CustomFETString::number(cn->firstActivityId)+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->secondActivityId=text.toInt();
			xmlReadingLog+="    Read second activity id="+CustomFETString::number(cn->secondActivityId)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTwoActivitiesConsecutive(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTwoActivitiesConsecutive"));
	ConstraintTwoActivitiesConsecutive* cn=new ConstraintTwoActivitiesConsecutive();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("First_Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->firstActivityId=text.toInt();
			xmlReadingLog+="    Read first activity id="+CustomFETString::number(cn->firstActivityId)+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->secondActivityId=text.toInt();
			xmlReadingLog+="    Read second activity id="+CustomFETString::number(cn->secondActivityId)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTwoActivitiesGrouped(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTwoActivitiesGrouped"));
	ConstraintTwoActivitiesGrouped* cn=new ConstraintTwoActivitiesGrouped();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("First_Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->firstActivityId=text.toInt();
			xmlReadingLog+="    Read first activity id="+CustomFETString::number(cn->firstActivityId)+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->secondActivityId=text.toInt();
			xmlReadingLog+="    Read second activity id="+CustomFETString::number(cn->secondActivityId)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readThreeActivitiesGrouped(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintThreeActivitiesGrouped"));
	ConstraintThreeActivitiesGrouped* cn=new ConstraintThreeActivitiesGrouped();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("First_Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->firstActivityId=text.toInt();
			xmlReadingLog+="    Read first activity id="+CustomFETString::number(cn->firstActivityId)+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->secondActivityId=text.toInt();
			xmlReadingLog+="    Read second activity id="+CustomFETString::number(cn->secondActivityId)+"\n";
		}
		else if(xmlReader.name()==QString("Third_Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->thirdActivityId=text.toInt();
			xmlReadingLog+="    Read third activity id="+CustomFETString::number(cn->thirdActivityId)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTwoActivitiesOrdered(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTwoActivitiesOrdered"));
	ConstraintTwoActivitiesOrdered* cn=new ConstraintTwoActivitiesOrdered();
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight")){
			//cn->weight=customFETStrToDouble(text);
			xmlReader.skipCurrentElement();
			xmlReadingLog+="    Ignoring old tag - weight - making weight percentage=100\n";
			cn->weightPercentage=100;
		}
		else if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("Compulsory")){
			QString text=xmlReader.readElementText();
			if(text=="yes"){
				//cn->compulsory=true;
				xmlReadingLog+="    Ignoring old tag - Current constraint is compulsory\n";
				cn->weightPercentage=100;
			}
			else{
				//cn->compulsory=false;
				xmlReadingLog+="    Old tag - current constraint is not compulsory - making weightPercentage=0%\n";
				cn->weightPercentage=0;
			}
		}
		else if(xmlReader.name()==QString("First_Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->firstActivityId=text.toInt();
			xmlReadingLog+="    Read first activity id="+CustomFETString::number(cn->firstActivityId)+"\n";
		}
		else if(xmlReader.name()==QString("Second_Activity_Id")){
			QString text=xmlReader.readElementText();
			cn->secondActivityId=text.toInt();
			xmlReadingLog+="    Read second activity id="+CustomFETString::number(cn->secondActivityId)+"\n";
		}
		else{
			unrecognizedXmlTags.append(xmlReader.name().toString());
			unrecognizedXmlLineNumbers.append(xmlReader.lineNumber());
			unrecognizedXmlColumnNumbers.append(xmlReader.columnNumber());

			xmlReader.skipCurrentElement();
			xmlReaderNumberOfUnrecognizedFields++;
		}
	}
	return cn;
}

TimeConstraint* Rules::readTwoSetsOfActivitiesOrdered(QXmlStreamReader& xmlReader, FakeString& xmlReadingLog){
	assert(xmlReader.isStartElement() && xmlReader.name()==QString("ConstraintTwoSetsOfActivitiesOrdered"));
	ConstraintTwoSetsOfActivitiesOrdered* cn=new ConstraintTwoSetsOfActivitiesOrdered();
	int rnfa=-1, rnsa=-1; //read number of first/second activities
	while(xmlReader.readNextStartElement()){
		xmlReadingLog+="    Found "+xmlReader.name().toString()+" tag\n";
		if(xmlReader.name()==QString("Weight_Percentage")){
			QString text=xmlReader.readElementText();
			cn->weightPercentage=customFETStrToDouble(text);
			xmlReadingLog+="    Adding weight percentage="+CustomFETString::number(cn->weightPercentage)+"\n";
		}
		else if(xmlReader.name()==QString("Active")){
			QString text=xmlReader.readElementText();
			if(text=="false"){
				cn->active=false;
			}
		}
		else if(xmlReader.name()==QString("Comments")){
			QString text=xmlReader.readElementText();
			cn->comments=text;
		}
		else if(xmlReader.name()==QString("First_Activities_Ids_Set")){
			xmlReadingLog+="    Reading first activities ids set\n";
			assert(xmlReader.isStartElement());
			while(xmlReader.readNextStartElement()){
				xmlReadingLog+="     Found "+xmlReader.name().toString()+" tag\n";
				if(xmlReader.name()==QString("Number_of_Activities")){
					QString text=xmlReader.readElementText();
					rnfa=text.toInt();
					xmlReadingLog+="     Read number of activities="+CustomFETString::number(rnfa)+"\n";
				}
				else if(xmlReader.name()==QString("Activity_Id")){
					QString text=xmlReader.readElementText();
					cn->firstActivitiesIdsList.append(text.toInt());
					xmlReadingLog+="     Read activity id="+CustomFETString::number(cn->firstActivitiesIdsList.last())+"\n";
				}
				else{
					unrecognizedXmlTags.append(xmlReader.name().toString());
					unrecognizedXmlLine